/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.tools;

import com.ibm.jvm.dtfjview.spi.IOutputChannel;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class ToolsRegistryOutputChannels
extends OutputStream {
    private List<IOutputChannel> channels;
    private List<Byte> buffer;
    private String charsetName;
    private static ToolsRegistryOutputChannels instance = null;

    public static void initialize(String string) {
        if (instance == null) {
            instance = new ToolsRegistryOutputChannels(string);
        }
    }

    public static void addChannel(IOutputChannel iOutputChannel) {
        ToolsRegistryOutputChannels.instance.channels.add(iOutputChannel);
    }

    public static void removeChannel(IOutputChannel iOutputChannel) {
        if (ToolsRegistryOutputChannels.instance.channels.contains(iOutputChannel)) {
            ToolsRegistryOutputChannels.instance.channels.remove(iOutputChannel);
        }
    }

    public static boolean contains(IOutputChannel iOutputChannel) {
        for (IOutputChannel iOutputChannel2 : ToolsRegistryOutputChannels.instance.channels) {
            if (!iOutputChannel2.equals(iOutputChannel)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void write(int n) throws IOException {
        this.buffer.add(Integer.valueOf(n).byteValue());
        if (10 == n || 21 == n) {
            this.writeBuffer();
        }
    }

    @Override
    public void close() throws IOException {
        this.writeBuffer();
        for (IOutputChannel iOutputChannel : this.channels) {
            iOutputChannel.close();
        }
    }

    @Override
    public void flush() throws IOException {
        this.writeBuffer();
        for (IOutputChannel iOutputChannel : this.channels) {
            iOutputChannel.flush();
        }
    }

    public static PrintStream newPrintStream() {
        return new PrintStream(instance, true);
    }

    private ToolsRegistryOutputChannels(String string) {
        this.charsetName = string;
        this.channels = new ArrayList<IOutputChannel>();
        this.buffer = new ArrayList<Byte>();
    }

    private void writeBuffer() throws IOException {
        if (0 == this.buffer.size()) {
            return;
        }
        byte[] byArray = new byte[this.buffer.size()];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = this.buffer.get(i);
        }
        for (IOutputChannel iOutputChannel : this.channels) {
            if (this.charsetName == null) {
                iOutputChannel.print(new String(byArray));
                continue;
            }
            iOutputChannel.print(new String(byArray, this.charsetName));
        }
        this.buffer = new ArrayList<Byte>();
    }
}

