/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.heapdump;

import java.util.Map;

public class HeapDumpSettings {
    public static final String HEAP_DUMP_FILE_PROPERTY = "heap_dump_file";
    public static final String HEAP_DUMP_FORMAT_PROPERTY = "heap_dump_format";
    public static final String MULTIPLE_HEAPS_MULTIPLE_FILES_PROPERTY = "heap_dump_multiple_heaps_multiple_files";
    public static final String HEAP_DUMP_RUNTIME_ID = "heap_dump_runtime_id";

    public static void setFileName(String string, Map map) {
        map.put(HEAP_DUMP_FILE_PROPERTY, string);
    }

    public static String getFileName(Map map) {
        String string = (String)map.get(HEAP_DUMP_FILE_PROPERTY);
        if (string != null) {
            return string;
        }
        return HeapDumpSettings.getDefaultHeapDumpFileName(map);
    }

    public static boolean heapDumpFileNameSet(Map map) {
        return map.containsKey(HEAP_DUMP_FILE_PROPERTY);
    }

    private static String getDefaultHeapDumpFileName(Map map) {
        String string = (String)map.get("core_file_path");
        String string2 = (String)map.get(HEAP_DUMP_RUNTIME_ID);
        if (string2 == null) {
            string2 = "";
        }
        if (HeapDumpSettings.areHeapDumpsPHD(map)) {
            return string + string2 + ".phd";
        }
        return string + string2 + ".txt";
    }

    public static void setClassicHeapDumps(Map map) {
        map.put(HEAP_DUMP_FORMAT_PROPERTY, "classic");
    }

    public static boolean areHeapDumpsPHD(Map map) {
        Object v = map.get(HEAP_DUMP_FORMAT_PROPERTY);
        return v == null || !v.equals("classic");
    }

    public static void setPHDHeapDumps(Map map) {
        map.put(HEAP_DUMP_FORMAT_PROPERTY, "phd");
    }

    public static void setMultipleHeapsMultipleFiles(Map map) {
        map.put(MULTIPLE_HEAPS_MULTIPLE_FILES_PROPERTY, "true");
    }

    public static void setMultipleHeapsSingleFile(Map map) {
        map.put(MULTIPLE_HEAPS_MULTIPLE_FILES_PROPERTY, "false");
    }

    public static void setRuntimeID(Map map, int n) {
        map.put(HEAP_DUMP_RUNTIME_ID, "." + n);
    }

    public static boolean multipleHeapsInMultipleFiles(Map map) {
        Object v = map.get(MULTIPLE_HEAPS_MULTIPLE_FILES_PROPERTY);
        if (v == null) {
            return false;
        }
        return v.equals("true");
    }
}

