/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.xcommands;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaHeap;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaReference;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.helpers.ClassOutput;
import com.ibm.jvm.dtfjview.commands.helpers.Exceptions;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import com.ibm.jvm.dtfjview.commands.xcommands.XCommand;
import java.io.PrintStream;
import java.util.Iterator;

@DTFJPlugin(version="1.*", runtime=false)
public class XJCommand
extends XCommand {
    public XJCommand() {
        this.addCommand("x/j", "<object address> | <class name>", "displays information about a particular object or all objects of a class");
    }

    @Override
    public boolean recognises(String string, IContext iContext) {
        if (super.recognises(string, iContext)) {
            return string.toLowerCase().endsWith("j");
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void doCommand(String[] stringArray) {
        String string;
        boolean bl = false;
        String string2 = stringArray[0];
        Long l = Utils.longFromStringWithPrefix(string2);
        if (null == l) {
            string = string2;
            if (stringArray.length >= 2) {
                String string3 = stringArray[1];
                if (string3.equals("super")) {
                    bl = true;
                } else {
                    if (!string3.equals("nosuper")) {
                        this.out.println("second parameter for \"x/j\" must be \"super\" or \"nosuper\"");
                        return;
                    }
                    bl = false;
                }
            }
        } else {
            string = null;
        }
        this.printHeapObjects(l, string, this.out, bl);
    }

    private void printHeapObjects(Long l, String string, PrintStream printStream, boolean bl) {
        JavaRuntime javaRuntime = this.ctx.getRuntime();
        Iterator iterator = javaRuntime.getHeaps();
        int n = 1;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof JavaHeap) {
                JavaHeap javaHeap = (JavaHeap)e;
                printStream.print("\t heap #" + n + " - name: ");
                printStream.print(javaHeap.getName());
                printStream.print("\n\n");
                this.printObjects(javaHeap, l, string, printStream, bl, javaRuntime);
                ++n;
                continue;
            }
            printStream.println("\t\tWarning : skipping corrupt heap");
        }
    }

    private void printObjects(JavaHeap javaHeap, Long l, String string, PrintStream printStream, boolean bl, JavaRuntime javaRuntime) {
        if (string != null) {
            this.printObjectsFromName(javaHeap, string, printStream, bl, javaRuntime);
        } else {
            this.printObjectsFromAddress(javaHeap, l, printStream, javaRuntime);
        }
    }

    private void printObjectsFromName(JavaHeap javaHeap, String string, PrintStream printStream, boolean bl, JavaRuntime javaRuntime) {
        if (string != null) {
            JavaClass[] javaClassArray = Utils.getClassGivenName(string, javaRuntime, printStream);
            if (javaClassArray == null || javaClassArray.length == 0) {
                printStream.print("\t  could not find class with name \"" + string + "\"\n\n");
                return;
            }
            for (int i = 0; i < javaClassArray.length; ++i) {
                boolean bl2 = false;
                JavaClass javaClass = javaClassArray[i];
                if (javaClassArray.length > 1) {
                    ClassOutput.printRuntimeClassAndLoader(javaClass, printStream);
                }
                ClassOutput.printStaticFields(javaClass, printStream);
                Iterator iterator = javaHeap.getObjects();
                int n = 0;
                while (iterator.hasNext()) {
                    JavaClass javaClass2;
                    Object e = iterator.next();
                    if (e instanceof CorruptData) {
                        ++n;
                        continue;
                    }
                    JavaObject javaObject = (JavaObject)e;
                    String string2 = "";
                    try {
                        javaClass2 = javaObject.getJavaClass();
                    }
                    catch (CorruptDataException corruptDataException) {
                        printStream.print("\t  <error getting class while traversing objects: ");
                        printStream.print(Exceptions.getCorruptDataExceptionString());
                        printStream.print(">\n");
                        javaClass2 = null;
                    }
                    boolean bl3 = false;
                    while (javaClass2 != null && !bl3) {
                        String string3;
                        try {
                            string3 = javaClass2.getName();
                        }
                        catch (CorruptDataException corruptDataException) {
                            printStream.print("\t  <error getting class name while traversing objects: ");
                            printStream.print(Exceptions.getCorruptDataExceptionString());
                            printStream.print(">\n");
                            javaClass2 = null;
                            continue;
                        }
                        string2 = string2.equals("") ? string3 : string3 + " => " + string2;
                        if (javaClass2.equals((Object)javaClass)) {
                            bl2 = true;
                            bl3 = true;
                            printStream.print("\t  ");
                            printStream.print(string2);
                            printStream.print(" @ ");
                            printStream.print(Utils.toHex(javaObject.getID().getAddress()));
                            printStream.print("\n");
                            ClassOutput.printFields(javaObject, javaClass2, javaRuntime, printStream);
                            XJCommand.printReferences(javaObject, printStream);
                            continue;
                        }
                        if (bl) {
                            try {
                                javaClass2 = javaClass2.getSuperclass();
                            }
                            catch (CorruptDataException corruptDataException) {
                                printStream.print("\t  <error getting superclass while traversing objects: ");
                                printStream.print(Exceptions.getCorruptDataExceptionString());
                                printStream.print(">\n");
                                javaClass2 = null;
                            }
                            continue;
                        }
                        javaClass2 = null;
                    }
                }
                if (!bl2) {
                    printStream.print("\t  <no object of class \"");
                    printStream.print(string);
                    printStream.print("\" exists>\n\n");
                }
                if (n == 0) continue;
                printStream.println("\t Warning : " + n + " corrupt objects were skipped\n");
            }
        }
    }

    private void printObjectsFromAddress(JavaHeap javaHeap, Long l, PrintStream printStream, JavaRuntime javaRuntime) {
        Iterator iterator = javaHeap.getObjects();
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (iterator.hasNext() && !bl2) {
            JavaClass javaClass;
            Object e = iterator.next();
            if (e instanceof CorruptData) {
                ++n;
                continue;
            }
            JavaObject javaObject = (JavaObject)e;
            if (javaObject.getID().getAddress() != l.longValue()) continue;
            bl = true;
            printStream.print("\t  ");
            try {
                javaClass = javaObject.getJavaClass();
            }
            catch (CorruptDataException corruptDataException) {
                printStream.print("\t  <error getting class while traversing objects: ");
                printStream.print(Exceptions.getCorruptDataExceptionString());
                printStream.print(">");
                javaClass = null;
            }
            if (null == javaClass) continue;
            try {
                printStream.print(javaClass.getName());
            }
            catch (CorruptDataException corruptDataException) {
                printStream.print("\t  <error getting class name while traversing objects: ");
                printStream.print(Exceptions.getCorruptDataExceptionString());
                printStream.print(">");
            }
            printStream.print(" @ ");
            printStream.print(Utils.toHex(l));
            printStream.print("\n");
            ClassOutput.printFields(javaObject, javaClass, javaRuntime, printStream);
            XJCommand.printReferences(javaObject, printStream);
            bl2 = true;
        }
        if (!bl) {
            printStream.print("\t  <no object found at address ");
            printStream.print(Utils.toHex(l));
            printStream.print(">\n\n");
        }
        if (n != 0) {
            printStream.println("\t Warning : " + n + " corrupt objects were skipped\n");
        }
    }

    @Override
    public void printDetailedHelp(PrintStream printStream) {
        super.printDetailedHelp(printStream);
        printStream.println("displays information about a particular object or all objects of a class\n\nparameters: 0x<object_addr> | <class_name> [super | nosuper]\n\nIf given class name, all static fields with their values will be printed, followed by all objects of that class with their fields and values for each class of that name (if multiple classloaders have loaded classes with that name).\n\nIf \"super\" is specifed with \"x/j < class_name>\" it is interpreted as a superclass name, and all instances of any subclasses will be printed.\n\nIf given an object address (in hex), static fields for that object's class will not be printed; the other fields and values of that object will be printed along with its address.\n\nNote: this command ignores the number of items and unit size passed to it by the \"x/\" command.\n\n");
    }

    public static void printReferences(JavaObject javaObject, PrintStream printStream) {
        Iterator iterator = javaObject.getReferences();
        if (iterator.hasNext()) {
            iterator.next();
        }
        if (!iterator.hasNext()) {
            printStream.print("\t    references: <none>\n ");
            printStream.print("\t     ");
        } else {
            printStream.print("\t    references:\n ");
            printStream.print("\t     ");
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof JavaReference)) continue;
                JavaReference javaReference = (JavaReference)e;
                try {
                    Object object = javaReference.getTarget();
                    if (object instanceof JavaObject) {
                        printStream.print(" 0x" + Long.toHexString(((JavaObject)object).getID().getAddress()));
                        continue;
                    }
                    if (!(object instanceof JavaClass)) continue;
                    printStream.print(" 0x" + Long.toHexString(((JavaClass)object).getID().getAddress()));
                }
                catch (DataUnavailable dataUnavailable) {
                }
                catch (CorruptDataException corruptDataException) {
                    printStream.print(Exceptions.getCorruptDataExceptionString());
                }
            }
        }
        printStream.print("\n\n");
    }
}

