/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.xcommands;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import com.ibm.jvm.dtfjview.commands.xcommands.XCommand;
import java.io.PrintStream;

@DTFJPlugin(version="1.*", runtime=false)
public class XDCommand
extends XCommand {
    public XDCommand() {
        this.addCommand("x/d", "<hex address>", "displays the integer at the specified address");
    }

    @Override
    public boolean recognises(String string, IContext iContext) {
        if (super.recognises(string, iContext)) {
            return string.toLowerCase().endsWith("d");
        }
        return false;
    }

    @Override
    public void doCommand(String[] stringArray) {
        String string = stringArray[0];
        Long l = Utils.longFromStringWithPrefix(string);
        if (null == l) {
            this.out.println("invalid hex address specified; address must be specified as \"0x<hex_address>\"");
            return;
        }
        this.out.print("\n");
        boolean bl = false;
        for (int i = 0; i < this.argUnitNumber; ++i) {
            long l2 = l + (long)(i * this.argUnitSize);
            this.out.print("\t");
            this.out.print(Utils.toHex(l2));
            this.out.print(": ");
            ImageAddressSpace imageAddressSpace = this.ctx.getAddressSpace();
            ImagePointer imagePointer = imageAddressSpace.getPointer(l2);
            byte by = 0;
            short s = 0;
            int n = 0;
            long l3 = 0L;
            try {
                switch (this.argUnitSize) {
                    case 1: {
                        by = imagePointer.getByteAt(0L);
                        break;
                    }
                    case 2: {
                        s = imagePointer.getShortAt(0L);
                        break;
                    }
                    case 4: {
                        n = imagePointer.getIntAt(0L);
                        break;
                    }
                    case 8: {
                        l3 = imagePointer.getLongAt(0L);
                    }
                }
                bl = true;
            }
            catch (CorruptDataException corruptDataException) {
                bl = false;
            }
            catch (MemoryAccessException memoryAccessException) {
                bl = false;
            }
            if (bl) {
                switch (this.argUnitSize) {
                    case 1: {
                        this.out.print(Byte.toString(by));
                        break;
                    }
                    case 2: {
                        this.out.print(Short.toString(s));
                        break;
                    }
                    case 4: {
                        this.out.print(Integer.toString(n));
                        break;
                    }
                    case 8: {
                        this.out.print(Long.toString(l3));
                    }
                }
            }
            this.out.print("\n");
        }
        if (!bl) {
            this.out.print("<address not found in any address space>");
        }
        this.out.print("\n");
    }

    @Override
    public void printDetailedHelp(PrintStream printStream) {
        super.printDetailedHelp(printStream);
        printStream.println("displays the integer at the specified address\n\nparameters: 0x<addr>\n\nDisplays the integer at the specified address, adjusted for the endianness of the architecture this dump file is from.\n\nNote: This command uses the number of items and unit size passed to it by the \"x/\" command.\n");
    }
}

