// Created on: 1994-10-28
// Created by: Jean Yves LEBEY
// Copyright (c) 1994-1999 Matra Datavision
// Copyright (c) 1999-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and / or modify it
// under the terms of the GNU Lesser General Public version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

#include <TopOpeBRepDS_FaceEdgeInterference.ixx>
#include <TopOpeBRepDS_Kind.hxx>

//=======================================================================
//function : TopOpeBRepDS_FaceEdgeInterference
//purpose  : 
//=======================================================================

TopOpeBRepDS_FaceEdgeInterference::TopOpeBRepDS_FaceEdgeInterference
  (const TopOpeBRepDS_Transition& T, 
   const Standard_Integer         S, 
   const Standard_Integer         G,
   const Standard_Boolean         GIsBound, 
   const TopOpeBRepDS_Config      C) :
  TopOpeBRepDS_ShapeShapeInterference
  (T,TopOpeBRepDS_FACE,S,TopOpeBRepDS_EDGE,G,GIsBound,C)
{
}

//=======================================================================
//function : Dump
//purpose  : 
//=======================================================================

Standard_OStream& TopOpeBRepDS_FaceEdgeInterference::Dump
(Standard_OStream& OS) const
{
#ifdef DEB
  OS<<"FEI ";
  TopOpeBRepDS_ShapeShapeInterference::Dump(OS);
#endif

  return OS;
}
