/**CHeaderFile*****************************************************************

  FileName    [SATPartialTraceExecutor_private.h]

  PackageName [trace.exec]

  Synopsis    [Private and protected interface of class 'SATPartialTraceExecutor']

  Description [This file can be included only by derived and friend classes]

  SeeAlso     [SATPartialTraceExecutor.h]

  Author      [Marco Pensallorto]

  Copyright   [
  This file is part of the ``trace.exec'' package of NuSMV version 2.
  Copyright (C) 2010 by FBK-irst.

  NuSMV version 2 is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  NuSMV version 2 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA.

  For more information on NuSMV see <http://nusmv.fbk.eu>
  or email to <nusmv-users@fbk.eu>.
  Please report bugs to <nusmv-users@fbk.eu>.

  To contact the NuSMV development board, email to <nusmv@fbk.eu>. ]

  Revision    [$Id: $]

******************************************************************************/


#ifndef __SAT_PARTIAL_TRACE_EXECUTOR_PRIVATE_H__
#define __SAT_PARTIAL_TRACE_EXECUTOR_PRIVATE_H__

#include "PartialTraceExecutor.h"
#include "PartialTraceExecutor_private.h"

#include "SATPartialTraceExecutor.h"

#include "utils/utils.h"


/**Struct**********************************************************************

  Synopsis    [SATPartialTraceExecutor class definition derived from
               class PartialTraceExecutor]

  Description []

  SeeAlso     [Base class PartialTraceExecutor]

******************************************************************************/
typedef struct SATPartialTraceExecutor_TAG
{
  /* this MUST stay on the top */
  INHERITS_FROM(PartialTraceExecutor);

  /* -------------------------------------------------- */
  /*                  Private members                   */
  /* -------------------------------------------------- */
  BeFsm_ptr fsm;
  BeEnc_ptr enc;

  BddEnc_ptr bdd_enc; /* needed for booleanization */

  boolean use_restart;
  /* -------------------------------------------------- */
  /*                  Virtual methods                   */
  /* -------------------------------------------------- */

} SATPartialTraceExecutor;



/* ---------------------------------------------------------------------- */
/* Private methods to be used by derivated and friend classes only         */
/* ---------------------------------------------------------------------- */
EXTERN void
sat_partial_trace_executor_init ARGS((SATPartialTraceExecutor_ptr self,
                                      const BeFsm_ptr fsm, const BeEnc_ptr enc,
                                      const BddEnc_ptr bdd_enc,
                                      boolean use_restart));

EXTERN void
sat_partial_trace_executor_deinit ARGS((SATPartialTraceExecutor_ptr self));

#endif /* __SAT_PARTIAL_TRACE_EXECUTOR_PRIVATE_H__ */
