// Copyright 2023 the V8 project authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if !V8_ENABLE_WEBASSEMBLY
#error This header should only be included if WebAssembly is enabled.
#endif  // !V8_ENABLE_WEBASSEMBLY

#ifndef V8_COMPILER_TURBOSHAFT_WASM_DEAD_CODE_ELIMINATION_PHASE_H_
#define V8_COMPILER_TURBOSHAFT_WASM_DEAD_CODE_ELIMINATION_PHASE_H_

#include "src/compiler/turboshaft/phase.h"

namespace v8::internal::compiler::turboshaft {

struct WasmDeadCodeEliminationPhase {
  DECL_TURBOSHAFT_PHASE_CONSTANTS(WasmDeadCodeElimination)

  void Run(Zone* temp_zone);
};

}  // namespace v8::internal::compiler::turboshaft

#endif  // V8_COMPILER_TURBOSHAFT_WASM_DEAD_CODE_ELIMINATION_PHASE_H_
