<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/collectors/charts.d.plugin/opensips/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/collectors/charts.d.plugin/opensips/metadata.yaml"
sidebar_label: "OpenSIPS"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Telephony Servers"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# OpenSIPS


<img src="https://netdata.cloud/img/opensips.png" width="150"/>


Plugin: charts.d.plugin
Module: opensips

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

Examine OpenSIPS metrics for insights into SIP server operations. Study call rates, error rates, and response times for reliable voice over IP services.

The collector uses the `opensipsctl` command line utility to gather OpenSIPS metrics.

This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

The collector will attempt to call `opensipsctl` along with a default number of parameters, even without any configuration.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.

## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per OpenSIPS instance

These metrics refer to the entire monitored application.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| opensips.dialogs_active | active, early | dialogs |
| opensips.users | registered, location, contacts, expires | users |
| opensips.registrar | accepted, rejected | registrations/s |
| opensips.transactions | UAS, UAC | transactions/s |
| opensips.core_rcv | requests, replies | queries/s |
| opensips.core_fwd | requests, replies | queries/s |
| opensips.core_drop | requests, replies | queries/s |
| opensips.core_err | requests, replies | queries/s |
| opensips.core_bad | bad_URIs_rcvd, unsupported_methods, bad_msg_hdr | queries/s |
| opensips.tm_replies | received, relayed, local | replies/s |
| opensips.transactions_status | 2xx, 3xx, 4xx, 5xx, 6xx | transactions/s |
| opensips.transactions_inuse | inuse | transactions |
| opensips.sl_replies | 1xx, 2xx, 3xx, 4xx, 5xx, 6xx, sent, error, ACKed | replies/s |
| opensips.dialogs | processed, expire, failed | dialogs/s |
| opensips.net_waiting | UDP, TCP | kilobytes |
| opensips.uri_checks | positive, negative | checks / sec |
| opensips.traces | requests, replies | traces / sec |
| opensips.shmem | total, used, real_used, max_used, free | kilobytes |
| opensips.shmem_fragment | fragments | fragments |



## Alerts

There are no alerts configured by default for this integration.


## Setup


### Prerequisites

#### Install charts.d plugin

If [using our official native DEB/RPM packages](https://github.com/netdata/netdata/blob/master/packaging/installer/UPDATE.md#determine-which-installation-method-you-used), make sure `netdata-plugin-chartsd` is installed.


#### Required software

The collector requires the `opensipsctl` to be installed.


### Configuration

#### Options

The config file is sourced by the charts.d plugin. It's a standard bash file.

The following collapsed table contains all the options that can be configured for the opensips collector.


<details open><summary>Config options</summary>



| Option | Description | Default | Required |
|:-----|:------------|:--------|:---------:|
| opensips_opts | Specify parameters to the `opensipsctl` command. If the default value fails to get global status, set here whatever options are needed to connect to the opensips server. | fifo get_statistics all | no |
| opensips_cmd | If `opensipsctl` is not in $PATH, specify it's full path here. |  | no |
| opensips_timeout | How long to wait for `opensipsctl` to respond. | 2 | no |
| opensips_update_every | The data collection frequency. If unset, will inherit the netdata update frequency. | 5 | no |
| opensips_priority | The charts priority on the dashboard. | 80000 | no |
| opensips_retries | The number of retries to do in case of failure before disabling the collector. | 10 | no |


</details>



#### via File

The configuration file name for this integration is `charts.d/opensips.conf`.

The file format is POSIX shell script. Generally, the structure is:

```sh
OPTION_1="some value"
OPTION_2="some other value"
```
You can edit the configuration file using the [`edit-config`](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#edit-a-configuration-file-using-edit-config) script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config charts.d/opensips.conf
```

##### Examples

###### Custom `opensipsctl` command

Set a custom path to the `opensipsctl` command

```yaml
#opensips_opts="fifo get_statistics all"
opensips_cmd=/opt/opensips/bin/opensipsctl
#opensips_timeout=2

# the data collection frequency
# if unset, will inherit the netdata update frequency
#opensips_update_every=5

# the charts priority on the dashboard
#opensips_priority=80000

# the number of retries to do in case of failure
# before disabling the module
#opensips_retries=10

```


## Troubleshooting

### Debug Mode


To troubleshoot issues with the `opensips` collector, run the `charts.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `charts.d.plugin` to debug the collector:

  ```bash
  ./charts.d.plugin debug 1 opensips
  ```

### Getting Logs

If you're encountering problems with the `opensips` collector, follow these steps to retrieve logs and identify potential issues:

- **Run the command** specific to your system (systemd, non-systemd, or Docker container).
- **Examine the output** for any warnings or error messages that might indicate issues.  These messages should provide clues about the root cause of the problem.

#### System with systemd

Use the following command to view logs generated since the last Netdata service restart:

```bash
journalctl _SYSTEMD_INVOCATION_ID="$(systemctl show --value --property=InvocationID netdata)" --namespace=netdata --grep opensips
```

#### System without systemd

Locate the collector log file, typically at `/var/log/netdata/collector.log`, and use `grep` to filter for collector's name:

```bash
grep opensips /var/log/netdata/collector.log
```

**Note**: This method shows logs from all restarts. Focus on the **latest entries** for troubleshooting current issues.

#### Docker Container

If your Netdata runs in a Docker container named "netdata" (replace if different), use this command:

```bash
docker logs netdata 2>&1 | grep opensips
```


