-- Tests for :[count]argument! and :[count]argdelete

local helpers = require('test.functional.helpers')
local clear, execute, eq, eval =
  helpers.clear, helpers.execute, helpers.eq, helpers.eval

describe('argument_count', function()
  setup(clear)

  it('is working', function()
    execute('%argd')
    execute('argadd a b c d')
    eq({'a', 'b', 'c', 'd'}, eval('argv()'))
    execute('set hidden')
    execute('let buffers = []')
    execute('augroup TEST')
    execute([[au BufEnter * call add(buffers, expand('%:t'))]])
    execute('augroup END')
    execute('$argu')
    execute('$-argu')
    execute('-argu')
    execute('1argu')
    execute('+2argu')
    execute('augroup TEST')
    execute('au!')
    execute('augroup END')
    eq({'d', 'c', 'b', 'a', 'c'}, eval('buffers'))
    execute('.argd')
    eq({'a', 'b', 'd'}, eval('argv()'))
    execute('-argd')
    eq({'a', 'd'}, eval('argv()'))
    execute('$argd')
    eq({'a'}, eval('argv()'))
    execute('1arga c')
    execute('1arga b')
    execute('$argu')
    execute('$arga x')
    eq({'a', 'b', 'c', 'x'}, eval('argv()'))
    execute('0arga Y')
    eq({'Y', 'a', 'b', 'c', 'x'}, eval('argv()'))
    execute('%argd')
    eq({}, eval('argv()'))
    execute('arga a b c d e f')
    execute('2,$-argd')
    eq({'a', 'f'}, eval('argv()'))
  end)
end)
