IF( CMAKE_SYSTEM_PROCESSOR STREQUAL "x86_64" )
    SET(INTEL_LIBDIR "intel64")
ELSE ( CMAKE_SYSTEM_PROCESSOR  STREQUAL "x86_64" )
    SET(INTEL_LIBDIR "ia32")
ENDIF( CMAKE_SYSTEM_PROCESSOR STREQUAL "x86_64" )

FIND_LIBRARY(MKL_LAPACK
    NAMES mkl_lapack
    HINTS $ENV{MKL_HOME}/lib/${INTEL_LIBDIR} $ENV{MKLROOT}/lib/${INTEL_LIBDIR}
)

IF ( MKL_LAPACK_FOUND )
    # old MKL versions
    IF ( CMAKE_SYSTEM_PROCESSOR STREQUAL "x86_64" )
        FIND_LIBRARY(MKL
            NAMES mkl_ia64
            HINTS $ENV{MKL_HOME}/lib/${INTEL_LIBDIR}
                  $ENV{MKLROOT}/lib/${INTEL_LIBDIR}
        )
    ELSE ( CMAKE_SYSTEM_PROCESSOR STREQUAL "x86_64" )
        FIND_LIBRARY(MKL
            NAMES mkl_ia32
            HINTS $ENV{MKL_HOME}/lib/${INTEL_LIBDIR}
                  $ENV{MKLROOT}/lib/${INTEL_LIBDIR}
        )
    ENDIF( CMAKE_SYSTEM_PROCESSOR STREQUAL "x86_64" )

    FIND_LIBRARY(MKL_GUIDE
        NAMES guide
        HINTS $ENV{MKL_HOME}/lib/${INTEL_LIBDIR}
              $ENV{MKLROOT}/lib/${INTEL_LIBDIR}
    )

    SET (BLAS_LAPACK ${MKL} ${MKL_LAPACK} ${MKL_GUIDE} CACHE INTERNAL "BLAS/LAPACK location (MKL)")
ELSE (MKL_LAPACK_FOUND )
    # newer MKL version
    FIND_LIBRARY(MKL_INTEL
        NAMES mkl_intel_lp64
        HINTS $ENV{MKL_HOME}/lib/${INTEL_LIBDIR}
              $ENV{MKLROOT}/lib/${INTEL_LIBDIR}
    )
    FIND_LIBRARY(MKL_SEQUENTIAL
        NAMES mkl_sequential
        HINTS $ENV{MKL_HOME}/lib/${INTEL_LIBDIR}
              $ENV{MKLROOT}/lib/${INTEL_LIBDIR}
    )
    FIND_LIBRARY(MKL_CORE
        NAMES mkl_core
        HINTS $ENV{MKL_HOME}/lib/${INTEL_LIBDIR}
              $ENV{MKLROOT}/lib/${INTEL_LIBDIR}
    )
    SET (BLAS_LAPACK ${MKL_INTEL} ${MKL_SEQUENTIAL} ${MKL_CORE} CACHE INTERNAL "BLAS/LAPACK location (MKL)")
ENDIF ( MKL_LAPACK_FOUND )

IF (MKL OR MKL_CORE)
    SET(LAPACK_FOUND TRUE)
ENDIF ()

IF (NOT LAPACK_FOUND )
    MESSAGE(FATAL_ERROR "Could not find MKL")        
ENDIF()

MARK_AS_ADVANCED(MKL_LAPACK)
MARK_AS_ADVANCED(MKL_GUIDE)
MARK_AS_ADVANCED(MKL_INTEL)
MARK_AS_ADVANCED(MKL_SEQUENTIAL)
MARK_AS_ADVANCED(MKL_CORE)
