/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.daemon;

import io.takari.maven.builder.smart.DependencyGraph;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.logging.BuildEventListener;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.transfer.TransferEvent;
import org.mvndaemon.mvnd.common.Message;

public class ClientDispatcher
implements BuildEventListener {
    private final Collection<Message> queue;
    private static final Pattern TRAILING_EOLS_PATTERN = Pattern.compile("[\r\n]+$");
    private final Map<String, Boolean> projects = new ConcurrentHashMap<String, Boolean>();

    public ClientDispatcher(Collection<Message> queue) {
        this.queue = queue;
    }

    public void sessionStarted(ExecutionEvent event) {
        MavenSession session = event.getSession();
        int degreeOfConcurrency = session.getRequest().getDegreeOfConcurrency();
        DependencyGraph dependencyGraph = DependencyGraph.fromMaven((MavenSession)session);
        int maxThreads = degreeOfConcurrency == 1 ? 1 : dependencyGraph.computeMaxWidth(degreeOfConcurrency, 1000L);
        List projects = session.getProjects();
        int _90thArtifactIdLengthPercentile = ClientDispatcher.artifactIdLength90thPercentile(projects);
        this.queue.add((Message)new Message.BuildStarted(this.getCurrentProject(session).getArtifactId(), projects.size(), maxThreads, _90thArtifactIdLengthPercentile));
    }

    static int artifactIdLength90thPercentile(List<MavenProject> projects) {
        if (projects.size() == 1) {
            return projects.get(0).getArtifactId().length();
        }
        TreeMap<Integer, Integer> frequencyDistribution = new TreeMap<Integer, Integer>();
        for (MavenProject p : projects) {
            frequencyDistribution.compute(p.getArtifactId().length(), (k, v) -> v == null ? Integer.valueOf(1) : Integer.valueOf(v + 1));
        }
        int _90PercCount = Math.round(0.9f * (float)projects.size());
        int cnt = 0;
        for (Map.Entry en : frequencyDistribution.entrySet()) {
            if ((cnt += ((Integer)en.getValue()).intValue()) < _90PercCount) continue;
            return (Integer)en.getKey();
        }
        throw new IllegalStateException("Could not compute the 90th percentile of the projects length from " + String.valueOf(projects));
    }

    public void projectStarted(String projectId) {
        this.projects.put(projectId, Boolean.TRUE);
        this.queue.add((Message)Message.projectStarted((String)projectId));
    }

    public void projectLogMessage(String projectId, String event) {
        Boolean b;
        if (projectId == null || (b = this.projects.get(projectId)) != Boolean.TRUE) {
            // empty if block
        }
        this.queue.add((Message)(projectId == null ? Message.log((String)ClientDispatcher.trimTrailingEols(event)) : Message.log((String)projectId, (String)ClientDispatcher.trimTrailingEols(event))));
    }

    public void projectFinished(String projectId) {
        this.projects.put(projectId, Boolean.FALSE);
        this.queue.add((Message)Message.projectStopped((String)projectId));
    }

    public void executionFailure(String projectId, boolean halted, String exception) {
        this.projects.put(projectId, Boolean.FALSE);
        this.queue.add((Message)Message.executionFailure((String)projectId, (boolean)halted, (String)exception));
    }

    public void mojoStarted(ExecutionEvent event) {
        MojoExecution execution = event.getMojoExecution();
        String goalPrefix = execution.getMojoDescriptor().getPluginDescriptor().getGoalPrefix();
        this.queue.add(Message.mojoStarted((String)event.getProject().getArtifactId(), (String)execution.getGroupId(), (String)execution.getArtifactId(), (String)(goalPrefix != null ? goalPrefix : ""), (String)execution.getVersion(), (String)execution.getGoal(), (String)execution.getExecutionId()));
    }

    public void finish(int exitCode) throws Exception {
        this.queue.add((Message)new Message.BuildFinished(exitCode));
        this.queue.add((Message)Message.BareMessage.STOP_SINGLETON);
    }

    public void fail(Throwable t) throws Exception {
        this.queue.add((Message)new Message.BuildException(t));
        this.queue.add((Message)Message.BareMessage.STOP_SINGLETON);
    }

    public void log(String msg) {
        this.queue.add((Message)Message.log((String)ClientDispatcher.trimTrailingEols(msg)));
    }

    public void transfer(String projectId, TransferEvent e) {
        int event = switch (e.getType()) {
            case TransferEvent.EventType.INITIATED -> 18;
            case TransferEvent.EventType.STARTED -> 19;
            case TransferEvent.EventType.PROGRESSED -> 20;
            case TransferEvent.EventType.CORRUPTED -> 21;
            case TransferEvent.EventType.SUCCEEDED -> 22;
            case TransferEvent.EventType.FAILED -> 23;
            default -> throw new IllegalStateException("Unexpected " + TransferEvent.EventType.class.getSimpleName() + ": " + String.valueOf(e.getType()));
        };
        int requestType = switch (e.getRequestType()) {
            case TransferEvent.RequestType.GET -> 0;
            case TransferEvent.RequestType.GET_EXISTENCE -> 1;
            case TransferEvent.RequestType.PUT -> 2;
            default -> throw new IllegalStateException("Unexpected " + TransferEvent.RequestType.class.getSimpleName() + ": " + String.valueOf(e.getRequestType()));
        };
        String repositoryId = e.getResource().getRepositoryId();
        String repositoryUrl = e.getResource().getRepositoryUrl();
        String resourceName = e.getResource().getResourceName();
        long contentLength = e.getResource().getContentLength();
        long transferredBytes = e.getTransferredBytes();
        String exception = e.getException() != null ? e.getException().toString() : null;
        this.queue.add((Message)Message.transfer((String)projectId, (int)event, (int)requestType, (String)repositoryId, (String)repositoryUrl, (String)resourceName, (long)contentLength, (long)transferredBytes, (String)exception));
    }

    private MavenProject getCurrentProject(MavenSession mavenSession) {
        String executionRootDirectory = mavenSession.getExecutionRootDirectory();
        if (executionRootDirectory == null) {
            return mavenSession.getCurrentProject();
        }
        return mavenSession.getProjects().stream().filter(p -> p.getFile() != null && executionRootDirectory.equals(p.getFile().getParent())).findFirst().orElse(mavenSession.getCurrentProject());
    }

    static String trimTrailingEols(String message) {
        return message == null ? null : TRAILING_EOLS_PATTERN.matcher(message).replaceFirst("");
    }
}

