/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExclusionArtifactFilter;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.lifecycle.internal.ProjectArtifactFactory;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;

@Named
public class DefaultProjectArtifactFactory
implements ProjectArtifactFactory {
    private final ArtifactFactory artifactFactory;

    @Inject
    public DefaultProjectArtifactFactory(ArtifactFactory artifactFactory) {
        this.artifactFactory = artifactFactory;
    }

    @Override
    public Set<Artifact> createArtifacts(MavenProject project) throws InvalidDependencyVersionException {
        return DefaultProjectArtifactFactory.createArtifacts(this.artifactFactory, project.getDependencies(), null, null, project);
    }

    public static Set<Artifact> createArtifacts(ArtifactFactory artifactFactory, List<Dependency> dependencies, String inheritedScope, ArtifactFilter dependencyFilter, MavenProject project) throws InvalidDependencyVersionException {
        LinkedHashSet<Artifact> artifacts = new LinkedHashSet<Artifact>();
        for (Dependency d : dependencies) {
            Artifact dependencyArtifact;
            try {
                dependencyArtifact = DefaultProjectArtifactFactory.createDependencyArtifact(artifactFactory, d, inheritedScope, dependencyFilter);
            }
            catch (InvalidVersionSpecificationException e) {
                throw new InvalidDependencyVersionException(project.getId(), d, project.getFile(), e);
            }
            if (dependencyArtifact == null) continue;
            artifacts.add(dependencyArtifact);
        }
        return artifacts;
    }

    private static Artifact createDependencyArtifact(ArtifactFactory factory, Dependency dependency, String inheritedScope, ArtifactFilter inheritedFilter) throws InvalidVersionSpecificationException {
        String effectiveScope = DefaultProjectArtifactFactory.getEffectiveScope(dependency.getScope(), inheritedScope);
        if (effectiveScope == null) {
            return null;
        }
        VersionRange versionRange = VersionRange.createFromVersionSpec((String)dependency.getVersion());
        Artifact dependencyArtifact = factory.createDependencyArtifact(dependency.getGroupId(), dependency.getArtifactId(), versionRange, dependency.getType(), dependency.getClassifier(), effectiveScope, dependency.isOptional());
        if (inheritedFilter != null && !inheritedFilter.include(dependencyArtifact)) {
            return null;
        }
        if ("system".equals(effectiveScope)) {
            dependencyArtifact.setFile(new File(dependency.getSystemPath()));
        }
        dependencyArtifact.setDependencyFilter(DefaultProjectArtifactFactory.createDependencyFilter(dependency, inheritedFilter));
        return dependencyArtifact;
    }

    private static String getEffectiveScope(String originalScope, String inheritedScope) {
        String effectiveScope = "runtime";
        if (originalScope == null) {
            originalScope = "compile";
        }
        if (inheritedScope == null) {
            effectiveScope = originalScope;
        } else if ("test".equals(originalScope) || "provided".equals(originalScope)) {
            effectiveScope = null;
        } else if ("system".equals(originalScope)) {
            effectiveScope = "system";
        } else if ("compile".equals(originalScope) && "compile".equals(inheritedScope)) {
            effectiveScope = "compile";
        } else if ("test".equals(inheritedScope)) {
            effectiveScope = "test";
        } else if ("provided".equals(inheritedScope)) {
            effectiveScope = "provided";
        }
        return effectiveScope;
    }

    private static ArtifactFilter createDependencyFilter(Dependency dependency, ArtifactFilter inheritedFilter) {
        ArtifactFilter effectiveFilter = inheritedFilter;
        if (!dependency.getExclusions().isEmpty()) {
            effectiveFilter = new ExclusionArtifactFilter(dependency.getExclusions());
            if (inheritedFilter != null) {
                effectiveFilter = new AndArtifactFilter(Arrays.asList(inheritedFilter, effectiveFilter));
            }
        }
        return effectiveFilter;
    }
}

