/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.aether;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.Authentication;
import org.apache.maven.bridge.MavenRepositorySystem;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.internal.aether.RepositorySystemSessionExtender;
import org.apache.maven.repository.Proxy;
import org.apache.maven.settings.Mirror;
import org.eclipse.aether.repository.AuthenticationContext;
import org.eclipse.aether.repository.AuthenticationSelector;
import org.eclipse.aether.repository.MirrorSelector;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.RemoteRepository;

@Named
@Singleton
public class LegacyRepositorySystemSessionExtender
implements RepositorySystemSessionExtender {
    @Override
    public void extend(MavenExecutionRequest mavenExecutionRequest, Map<String, Object> configProperties, MirrorSelector mirrorSelector, ProxySelector proxySelector, AuthenticationSelector authenticationSelector) {
        this.injectMirror(mavenExecutionRequest.getRemoteRepositories(), mavenExecutionRequest.getMirrors());
        this.injectProxy(proxySelector, mavenExecutionRequest.getRemoteRepositories());
        this.injectAuthentication(authenticationSelector, mavenExecutionRequest.getRemoteRepositories());
        this.injectMirror(mavenExecutionRequest.getPluginArtifactRepositories(), mavenExecutionRequest.getMirrors());
        this.injectProxy(proxySelector, mavenExecutionRequest.getPluginArtifactRepositories());
        this.injectAuthentication(authenticationSelector, mavenExecutionRequest.getPluginArtifactRepositories());
    }

    private void injectMirror(List<ArtifactRepository> repositories, List<Mirror> mirrors) {
        if (repositories != null && mirrors != null) {
            for (ArtifactRepository repository : repositories) {
                Mirror mirror = MavenRepositorySystem.getMirror(repository, mirrors);
                this.injectMirror(repository, mirror);
            }
        }
    }

    private void injectMirror(ArtifactRepository repository, Mirror mirror) {
        if (mirror != null) {
            ArtifactRepository original = MavenRepositorySystem.createArtifactRepository(repository.getId(), repository.getUrl(), repository.getLayout(), repository.getSnapshots(), repository.getReleases());
            repository.setMirroredRepositories(Collections.singletonList(original));
            repository.setId(mirror.getId());
            repository.setUrl(mirror.getUrl());
            if (mirror.getLayout() != null && !mirror.getLayout().isEmpty()) {
                repository.setLayout(original.getLayout());
            }
            repository.setBlocked(mirror.isBlocked());
        }
    }

    private void injectProxy(ProxySelector selector, List<ArtifactRepository> repositories) {
        if (repositories != null && selector != null) {
            for (ArtifactRepository repository : repositories) {
                repository.setProxy(this.getProxy(selector, repository));
            }
        }
    }

    private Proxy getProxy(ProxySelector selector, ArtifactRepository repository) {
        RemoteRepository repo;
        org.eclipse.aether.repository.Proxy proxy;
        if (selector != null && (proxy = selector.getProxy(repo = RepositoryUtils.toRepo(repository))) != null) {
            Proxy p = new Proxy();
            p.setHost(proxy.getHost());
            p.setProtocol(proxy.getType());
            p.setPort(proxy.getPort());
            if (proxy.getAuthentication() != null) {
                repo = new RemoteRepository.Builder(repo).setProxy(proxy).build();
                AuthenticationContext authCtx = AuthenticationContext.forProxy(null, (RemoteRepository)repo);
                p.setUserName(authCtx.get("username"));
                p.setPassword(authCtx.get("password"));
                p.setNtlmDomain(authCtx.get("ntlm.domain"));
                p.setNtlmHost(authCtx.get("ntlm.workstation"));
                authCtx.close();
            }
            return p;
        }
        return null;
    }

    private void injectAuthentication(AuthenticationSelector selector, List<ArtifactRepository> repositories) {
        if (repositories != null && selector != null) {
            for (ArtifactRepository repository : repositories) {
                repository.setAuthentication(this.getAuthentication(selector, repository));
            }
        }
    }

    private Authentication getAuthentication(AuthenticationSelector selector, ArtifactRepository repository) {
        RemoteRepository repo;
        org.eclipse.aether.repository.Authentication auth;
        if (selector != null && (auth = selector.getAuthentication(repo = RepositoryUtils.toRepo(repository))) != null) {
            repo = new RemoteRepository.Builder(repo).setAuthentication(auth).build();
            AuthenticationContext authCtx = AuthenticationContext.forRepository(null, (RemoteRepository)repo);
            Authentication result = new Authentication(authCtx.get("username"), authCtx.get("password"));
            result.setPrivateKey(authCtx.get("privateKey.path"));
            result.setPassphrase(authCtx.get("privateKey.passphrase"));
            authCtx.close();
            return result;
        }
        return null;
    }
}

