/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.common;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.function.Consumer;

public class BufferHelper {
    private static final Object unsafe;
    private static final Method invokeCleanerMethod;

    public static boolean closeDirectByteBuffer(ByteBuffer byteBuffer) {
        return BufferHelper.closeDirectByteBuffer(byteBuffer, null);
    }

    public static boolean closeDirectByteBuffer(ByteBuffer byteBuffer, Consumer<String> log) {
        if (byteBuffer != null && byteBuffer.isDirect()) {
            try {
                invokeCleanerMethod.invoke(unsafe, byteBuffer);
                return true;
            }
            catch (Exception e) {
                if (log != null) {
                    log.accept("Failed to clean ByteBuffer: " + String.valueOf(e));
                }
                return false;
            }
        }
        return false;
    }

    static {
        Object tmpUnsafe = null;
        Method tmpInvokeCleaner = null;
        try {
            Class<?> unsafeClass = Class.forName("jdk.internal.misc.Unsafe");
            Field theUnsafeField = unsafeClass.getDeclaredField("theUnsafe");
            theUnsafeField.setAccessible(true);
            tmpUnsafe = theUnsafeField.get(null);
            tmpInvokeCleaner = unsafeClass.getMethod("invokeCleaner", ByteBuffer.class);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Unable to access jdk.internal.misc.Unsafe#invokeCleaner", e);
        }
        unsafe = tmpUnsafe;
        invokeCleanerMethod = tmpInvokeCleaner;
    }
}

