/*    Copyright 2014 MongoDB Inc.
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

#pragma once

#include <exception>
#include <string>

#include "mongo/db/jsobj.h"
#include "mongo/util/assert_util.h"

namespace mongo {

    /**
     * General runtime exception generated by the MongoDB client driver.
     */
    class MONGO_CLIENT_API OperationException : public DBException {
    public:
        /** Takes a BSONObj that is the result of the "getlasterror" command */
        OperationException(const BSONObj& errorObj);

        /** Required due to BSONObj member desctructor not specifying throw() */
        virtual ~OperationException() throw();

        /** Get the last_error object representing the operation exception */
        const BSONObj& obj() const { return _lastError; }

    private:
        const BSONObj _lastError;
        const std::string _errorString;
    };

} // namespace mongo
