        program cgrego
c------------------------------------------------------------------------
c
c= CGREGO  - Convert a polygonal region text file to a cgdisp overlay file
c
c& nebk
c: image analysis
c+
c       CGREGO is a MIRIAD task to convert polygonal regions specified
c       in a text file (such as those generated by CGCURS) into
c       an overlay text file (such as that expected by CGDISP)
c       so that one can make a line-graphic drawing of a polygonal 
c       region on an image display.
c
c@ region
c       The input region text file. No default.
c@ olay
c       The output overlay text file. Default is input + ".olay"
c--
c
c History:
c   nebk 10apr98   Finally got fed up and did this
c   rjs  18may98   Correct fortran to make it compile on Alphas.
c   nebk 11jun99   Handle plane in region
c   rjs  14aug99   Correct some non-standard fortran.
c   rjs  08sep99   Initialise uninitialised variables. 
c------------------------------------------------------------------------
      implicit none
      character version*(*)
      parameter(version='CgRego: version 8-Sep-99')
c
      character region*80, olay*80, olaydef*80, line*2048
      integer lunin, lunout, iostat, ilen, len1, iline, l
c------------------------------------------------------------------------
c
c Get inputs
c
      call output (version)
      call keyini
      call keya('region', region, ' ')
      if (region.eq.' ') 
     +   call bug ('f', 'You must specify the region file name')
      olaydef = region(1:len1(region))//'.olay'
      call keya('olay', olay, olaydef)
c
c Open files
c
      call txtopen (lunin, region, 'old', iostat)
      if (iostat.ne.0) call bug ('f', 'Error opening region file')
      call txtopen (lunout, olay, 'new', iostat)
      if (iostat.ne.0) call bug ('f', 'Error opening overlay file')
c
c Loop over regions in file
c
      iline = 1
      iostat = 0
      do while (iostat.ne.-1)
        call txtread (lunin, line, ilen, iostat)
        if (iostat.eq.0) then
c
c Parse and write out overlay file
c
	  l = len1(line)
          call parse(line(1:l), lunout, iline)
          iline = iline + 1
        else 
          if (iostat.ne.-1) then
             call bug ('f', 'Error reading region file')
          end if 
        end if
      end do
c
c Close up
c
      call txtclose(lunin)
      call txtclose(lunout)
c
      end

      subroutine parse(line, lunout, iline)
      implicit none
c
      integer lunout, iline
      character*(*) line
cc
      character lineout*132, prefix*30, text*80,temp*512
      character*18 preamble(3)
      character*20 first, second, third, fourth, sfirst, ssecond
      character plane*4
      logical more, error
      integer len1, i1, i2, i3, i4, ppt, lenp, iostat
      integer b1, e1
      data preamble /'line arcsec arcsec', 'line abspix abspix',
     +               'line relpix relpix'/
c------------------------------------------------------------------------
c
c Can only handle polygons
c
      write (text,'(a,i4)') 'Processing region # ', iline
      if (index(line,'poly').eq.0) then
        call bug ('f', 'Region is not polygonal')
        return
      end if
c
c Look for units
c
      if (index(line,'arcsec').ne.0) then
        ppt = 1
      else if (index(line,'abspix').ne.0) then
        ppt = 2
      else if (index(line,'relpix').ne.0) then
        ppt = 3
      else
        call bug ('f', 'Unrecognized units for region')
        return 
      end if
      write (prefix, '(a,1x,i3,1x,a)') preamble(ppt), iline, 'no'
      lenp = len1(prefix)
c
c Find opening bracket and subsection from there
c
      i1 = index(line, '(') + 1
      if (i1.eq.0) then
         call bug ('f', 'Invalid format for region')
         return
      end if
      i2 = len1(line)
      temp = line(i1:i2)
      line = temp
      error = .false.
c
c Find first two numbers
c
      i1 = index(line, ',')
      if (i1.ne.0) then
        third = line(1:i1-1)
        sfirst = third

        i2 = index(line(i1+1:), ',')
        if (i2.ne.0) then
          i2 = i2 + i1
          fourth = line(i1+1:i2-1)
          ssecond = fourth
        else
          error = .true.
        end if
      else
        error = .true.
      end if
      if (error) then
        call bug ('f', 'Too few points for region')
        return
      end if
      temp = line(i2+1:)
      line = temp
c
c Find trailing plane if any
c
      plane = ' '
      b1 = index(line,'(')
      if (b1.ne.0) then
        e1 = index(line(b1:), ')')
        if (e1.ne.0) then
           e1 = e1 + b1 - 1
           if (e1.gt.b1) then
              plane = line(b1+1:e1-1)            
           end if
        end if
      end if
c
c Loop over line, extracting new pairs of values
c
      more = .true.
      error = .false.
      do while (more)
         first = third
         second = fourth

         i3 = index(line(1:), ',')
         if (i3.ne.0) then
           third = line(1:i3-1)
           i4 = index(line(i3+1:), ',')
           if (i4.ne.0) then
             i4 = i4 + i3
             fourth = line(i3+1:i4-1)
           else 
             i4 = index(line(i3+1:), ')')
             if (i4.ne.0) then
               i4 = i4 + i3
               fourth = line(i3+1:i4-1)
               more = .false.
             else
               error = .true.
             end if
           end if
         else
           error = .true.
         end if

        if (error) then
          write (*,*) 'Error, too few points for region ', iline
          more = .false.
        else
          lineout = prefix(1:lenp)//' '//first(1:len1(first))
     +                            //' '//second(1:len1(second))
     +                            //' '//third(1:len1(third))
     +                            //' '//fourth(1:len1(fourth))
     +                            //' '//plane(1:len1(plane))
          call txtwrite(lunout, lineout, len1(lineout), iostat)
          if (iostat.ne.0) call bug ('f', 'Error writing overlay file')
c
          temp = line(i4+1:)
          line = temp
        end if
      end do
c
c close polygon
c
      lineout = prefix(1:lenp)//' '//sfirst(1:len1(first))
     +                        //' '//ssecond(1:len1(second))
     +                        //' '//third(1:len1(third))
     +                        //' '//fourth(1:len1(fourth))
     +                            //' '//plane(1:len1(plane))
      call txtwrite(lunout, lineout, len1(lineout), iostat)
      if (iostat.ne.0) call bug ('f', 'Error writing overlay file')
c      
      return
      end
   
    
