C***********************************************************************
c*SPBDI -- Determinant of a real symmetrix positive definite band matrix.
c:LINPACK
c+
      SUBROUTINE SPBDI(ABD,LDA,N,M,DET)
      INTEGER LDA,N,M
      REAL ABD(LDA,1)
      REAL DET(2)
C
C     SPBDI COMPUTES THE DETERMINANT
C     OF A REAL SYMMETRIC POSITIVE DEFINITE BAND MATRIX
C     USING THE FACTORS COMPUTED BY SPBCO OR SPBFA.
C     IF THE INVERSE IS NEEDED, USE SPBSL  N  TIMES.
C
C     ON ENTRY
C
C	 ABD	 REAL(LDA, N)
C		 THE OUTPUT FROM SPBCO OR SPBFA.
C
C	 LDA	 INTEGER
C		 THE LEADING DIMENSION OF THE ARRAY  ABD .
C
C	 N	 INTEGER
C		 THE ORDER OF THE MATRIX  A .
C
C	 M	 INTEGER
C		 THE NUMBER OF DIAGONALS ABOVE THE MAIN DIAGONAL.
C
C     ON RETURN
C
C	 DET	 REAL(2)
C		 DETERMINANT OF ORIGINAL MATRIX IN THE FORM
C		 DETERMINANT = DET(1) * 10.0**DET(2)
C		 WITH  1.0 .LE. DET(1) .LT. 10.0
C		 OR  DET(1) .EQ. 0.0 .
C
C--
C     LINPACK.	THIS VERSION DATED 08/14/78 .
C     CLEVE MOLER, UNIVERSITY OF NEW MEXICO, ARGONNE NATIONAL LAB.
C
C     SUBROUTINES AND FUNCTIONS
C
C
C     INTERNAL VARIABLES
C
      REAL S
      INTEGER I
C
C     COMPUTE DETERMINANT
C
      DET(1) = 1.0E0
      DET(2) = 0.0E0
      S = 10.0E0
      DO 50 I = 1, N
	 DET(1) = ABD(M+1,I)**2*DET(1)
C     ...EXIT
	 IF (DET(1) .EQ. 0.0E0) GO TO 60
   10	 IF (DET(1) .GE. 1.0E0) GO TO 20
	    DET(1) = S*DET(1)
	    DET(2) = DET(2) - 1.0E0
	 GO TO 10
   20	 CONTINUE
   30	 IF (DET(1) .LT. S) GO TO 40
	    DET(1) = DET(1)/S
	    DET(2) = DET(2) + 1.0E0
	 GO TO 30
   40	 CONTINUE
   50 CONTINUE
   60 CONTINUE
      RETURN
      END
