/*
 * This software is supplied by Renesas Electronics Corporation and is only intended for
 * use with Renesas products. No other uses are authorized. This software is owned by
 * Renesas Electronics Corporation and is protected under all applicable laws, including
 * copyright laws.
 *
 * THIS SOFTWARE IS PROVIDED 'AS IS' AND RENESAS MAKES NO WARRANTIES REGARDING
 * THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING BUT NOT LIMITED TO
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT.
 * ALL SUCH WARRANTIES ARE EXPRESSLY DISCLAIMED. TO THE MAXIMUM EXTENT PERMITTED NOT
 * PROHIBITED BY LAW, NEITHER RENESAS ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED
 * COMPANIES SHALL BE LIABLE FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL
 * DAMAGES FOR ANY REASON RELATED TO THIS SOFTWARE, EVEN IF RENESAS OR ITS AFFILIATES HAVE
 * BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 *
 * Renesas reserves the right, without notice, to make changes to this software and to
 * discontinue the availability of this software. By using this software, you agree to
 * the additional terms and conditions found by accessing the following link:
 * http://www.renesas.com/disclaimer
 *
 *
 * @file     ./out/R7FA6T3BB.h
 * @brief    CMSIS HeaderFile
 * @version  0.50.00
 */

/** @addtogroup Renesas Electronics Corporation
 * @{
 */

/** @addtogroup R7FA6T3BB
 * @{
 */

#ifndef R7FA6T3BB_H
 #define R7FA6T3BB_H

 #ifdef __cplusplus
extern "C" {
 #endif

/** @addtogroup Configuration_of_CMSIS
 * @{
 */

/* =========================================================================================================================== */
/* ================                                Interrupt Number Definition                                ================ */
/* =========================================================================================================================== */

/* =========================================================================================================================== */
/* ================                           Processor and Core Peripheral Section                           ================ */
/* =========================================================================================================================== */

/* ==========================  Configuration of the ARM Cortex-M33 Processor and Core Peripherals  =========================== */
 #define __CM33_REV                0x0004U /*!< CM33 Core Revision                                                        */
 #define __NVIC_PRIO_BITS          4       /*!< Number of Bits used for Priority Levels                                   */
 #define __Vendor_SysTickConfig    0       /*!< Set to 1 if different SysTick Config is used                              */
 #define __VTOR_PRESENT            1       /*!< Set to 1 if CPU supports Vector Table Offset Register                     */
 #define __MPU_PRESENT             1       /*!< MPU present                                                               */
 #define __FPU_PRESENT             1       /*!< FPU present                                                               */
 #define __FPU_DP                  0       /*!< Double Precision FPU                                                      */
 #define __DSP_PRESENT             1       /*!< DSP extension present                                                     */
 #define __SAUREGION_PRESENT       0       /*!< SAU region present                                                        */

/** @} */ /* End of group Configuration_of_CMSIS */

 #include "core_cm33.h"                    /*!< ARM Cortex-M33 processor and core peripherals                             */
 #include "system.h"                       /*!< R7FA6T3BB System                                                          */

 #ifndef __IM                              /*!< Fallback for older CMSIS versions                                         */
  #define __IM     __I
 #endif
 #ifndef __OM                              /*!< Fallback for older CMSIS versions                                         */
  #define __OM     __O
 #endif
 #ifndef __IOM                             /*!< Fallback for older CMSIS versions                                         */
  #define __IOM    __IO
 #endif

/* ========================================  Start of section using anonymous unions  ======================================== */
 #if defined(__CC_ARM)
  #pragma push
  #pragma anon_unions
 #elif defined(__ICCARM__)
  #pragma language=extended
 #elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic push
  #pragma clang diagnostic ignored "-Wc11-extensions"
  #pragma clang diagnostic ignored "-Wreserved-id-macro"
  #pragma clang diagnostic ignored "-Wgnu-anonymous-struct"
  #pragma clang diagnostic ignored "-Wnested-anon-types"
 #elif defined(__GNUC__)

/* anonymous unions are enabled by default */
 #elif defined(__TMS470__)

/* anonymous unions are enabled by default */
 #elif defined(__TASKING__)
  #pragma warning 586
 #elif defined(__CSMC__)

/* anonymous unions are enabled by default */
 #else
  #warning Not supported compiler type
 #endif

/* =========================================================================================================================== */
/* ================                              Device Specific Cluster Section                              ================ */
/* =========================================================================================================================== */

/** @addtogroup Device_Peripheral_clusters
 * @{
 */

/**
 * @brief R_BUS_CSa [CSa] (CS Registers)
 */
typedef struct
{
    __IM uint16_t RESERVED;

    union
    {
        __IOM uint16_t MOD;            /*!< (@ 0x00000002) Mode Register                                              */

        struct
        {
            __IOM uint16_t WRMOD : 1;  /*!< [0..0] Write Access Mode Select                                           */
            uint16_t             : 2;
            __IOM uint16_t EWENB : 1;  /*!< [3..3] External Wait Enable                                               */
            uint16_t             : 4;
            __IOM uint16_t PRENB : 1;  /*!< [8..8] Page Read Access Enable                                            */
            __IOM uint16_t PWENB : 1;  /*!< [9..9] Page Write Access Enable                                           */
            uint16_t             : 5;
            __IOM uint16_t PRMOD : 1;  /*!< [15..15] Page Read Access Mode Select                                     */
        } MOD_b;
    };

    union
    {
        __IOM uint32_t WCR1;             /*!< (@ 0x00000004) Wait Control Register 1                                    */

        struct
        {
            __IOM uint32_t CSPWWAIT : 3; /*!< [2..0] Page Write Cycle Wait SelectNOTE: The CSPWWAIT value
                                          *   is valid only when the PWENB bit in CSnMOD is set to 1.                   */
            uint32_t                : 5;
            __IOM uint32_t CSPRWAIT : 3; /*!< [10..8] Page Read Cycle Wait SelectNOTE: The CSPRWAIT value
                                          *   is valid only when the PRENB bit in CSnMOD is set to 1.                   */
            uint32_t               : 5;
            __IOM uint32_t CSWWAIT : 5;  /*!< [20..16] Normal Write Cycle Wait Select                                   */
            uint32_t               : 3;
            __IOM uint32_t CSRWAIT : 5;  /*!< [28..24] Normal Read Cycle Wait Select                                    */
            uint32_t               : 3;
        } WCR1_b;
    };

    union
    {
        __IOM uint32_t WCR2;           /*!< (@ 0x00000008) Wait Control Register 2                                    */

        struct
        {
            __IOM uint32_t CSROFF : 3; /*!< [2..0] Read-Access CS Extension Cycle Select                              */
            uint32_t              : 1;
            __IOM uint32_t CSWOFF : 3; /*!< [6..4] Write-Access CS Extension Cycle Select                             */
            uint32_t              : 1;
            __IOM uint32_t WDOFF  : 3; /*!< [10..8] Write Data Output Extension Cycle Select                          */
            uint32_t              : 1;
            __IOM uint32_t AWAIT  : 2; /*!< [13..12] CS Assert Wait Select                                            */
            uint32_t              : 2;
            __IOM uint32_t RDON   : 3; /*!< [18..16] RD Assert Wait Select                                            */
            uint32_t              : 1;
            __IOM uint32_t WRON   : 3; /*!< [22..20] WR Assert Wait Select                                            */
            uint32_t              : 1;
            __IOM uint32_t WDON   : 3; /*!< [26..24] Write Data Output Wait Select                                    */
            uint32_t              : 1;
            __IOM uint32_t CSON   : 3; /*!< [30..28] CS Assert Wait Select                                            */
            uint32_t              : 1;
        } WCR2_b;
    };
    __IM uint32_t RESERVED1;
} R_BUS_CSa_Type;                      /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_BUS_CSb [CSb] (CS Registers)
 */
typedef struct
{
    __IM uint16_t RESERVED;

    union
    {
        __IOM uint16_t CR;             /*!< (@ 0x00000002) Control Register                                           */

        struct
        {
            __IOM uint16_t EXENB : 1;  /*!< [0..0] Operation Enable                                                   */
            uint16_t             : 3;
            __IOM uint16_t BSIZE : 2;  /*!< [5..4] External Bus Width Select                                          */
            uint16_t             : 2;
            __IOM uint16_t EMODE : 1;  /*!< [8..8] Endian Mode                                                        */
            uint16_t             : 3;
            __IOM uint16_t MPXEN : 1;  /*!< [12..12] Address/Data Multiplexed I/O Interface Select                    */
            uint16_t             : 3;
        } CR_b;
    };
    __IM uint16_t RESERVED1[3];

    union
    {
        __IOM uint16_t REC;            /*!< (@ 0x0000000A) Recovery Cycle Register                                    */

        struct
        {
            __IOM uint16_t RRCV : 4;   /*!< [3..0] Read Recovery                                                      */
            uint16_t            : 4;
            __IOM uint16_t WRCV : 4;   /*!< [11..8] Write Recovery                                                    */
            uint16_t            : 4;
        } REC_b;
    };
    __IM uint16_t RESERVED2[2];
} R_BUS_CSb_Type;                      /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_BUS_SDRAM [SDRAM] (SDRAM Registers)
 */
typedef struct
{
    union
    {
        __IOM uint8_t SDCCR;           /*!< (@ 0x00000000) SDC Control Register                                       */

        struct
        {
            __IOM uint8_t EXENB : 1;   /*!< [0..0] Operation Enable                                                   */
            uint8_t             : 3;
            __IOM uint8_t BSIZE : 2;   /*!< [5..4] SDRAM Bus Width Select                                             */
            uint8_t             : 2;
        } SDCCR_b;
    };

    union
    {
        __IOM uint8_t SDCMOD;          /*!< (@ 0x00000001) SDC Mode Register                                          */

        struct
        {
            __IOM uint8_t EMODE : 1;   /*!< [0..0] Endian Mode                                                        */
            uint8_t             : 7;
        } SDCMOD_b;
    };

    union
    {
        __IOM uint8_t SDAMOD;          /*!< (@ 0x00000002) SDRAM Access Mode Register                                 */

        struct
        {
            __IOM uint8_t BE : 1;      /*!< [0..0] Continuous Access Enable                                           */
            uint8_t          : 7;
        } SDAMOD_b;
    };
    __IM uint8_t  RESERVED;
    __IM uint32_t RESERVED1[3];

    union
    {
        __IOM uint8_t SDSELF;          /*!< (@ 0x00000010) SDRAM Self-Refresh Control Register                        */

        struct
        {
            __IOM uint8_t SFEN : 1;    /*!< [0..0] SDRAM Self-Refresh Enable                                          */
            uint8_t            : 7;
        } SDSELF_b;
    };
    __IM uint8_t  RESERVED2;
    __IM uint16_t RESERVED3;

    union
    {
        __IOM uint16_t SDRFCR;         /*!< (@ 0x00000014) SDRAM Refresh Control Register                             */

        struct
        {
            __IOM uint16_t RFC  : 12;  /*!< [11..0] Auto-Refresh Request Interval Setting                             */
            __IOM uint16_t REFW : 4;   /*!< [15..12] Auto-Refresh Cycle/ Self-Refresh Clearing Cycle Count
                                        *   Setting. ( REFW+1 Cycles )                                                */
        } SDRFCR_b;
    };

    union
    {
        __IOM uint8_t SDRFEN;          /*!< (@ 0x00000016) SDRAM Auto-Refresh Control Register                        */

        struct
        {
            __IOM uint8_t RFEN : 1;    /*!< [0..0] Auto-Refresh Operation Enable                                      */
            uint8_t            : 7;
        } SDRFEN_b;
    };
    __IM uint8_t  RESERVED4;
    __IM uint32_t RESERVED5[2];

    union
    {
        __IOM uint8_t SDICR;           /*!< (@ 0x00000020) SDRAM Initialization Sequence Control Register             */

        struct
        {
            __IOM uint8_t INIRQ : 1;   /*!< [0..0] Initialization Sequence Start                                      */
            uint8_t             : 7;
        } SDICR_b;
    };
    __IM uint8_t  RESERVED6;
    __IM uint16_t RESERVED7;

    union
    {
        __IOM uint16_t SDIR;           /*!< (@ 0x00000024) SDRAM Initialization Register                              */

        struct
        {
            __IOM uint16_t ARFI : 4;   /*!< [3..0] Initialization Auto-Refresh Interval ( PRF+3 cycles )              */
            __IOM uint16_t ARFC : 4;   /*!< [7..4] Initialization Auto-Refresh Count                                  */
            __IOM uint16_t PRC  : 3;   /*!< [10..8] Initialization Precharge Cycle Count ( PRF+3 cycles
                                        *   )                                                                         */
            uint16_t : 5;
        } SDIR_b;
    };
    __IM uint16_t RESERVED8;
    __IM uint32_t RESERVED9[6];

    union
    {
        __IOM uint8_t SDADR;           /*!< (@ 0x00000040) SDRAM Address Register                                     */

        struct
        {
            __IOM uint8_t MXC : 2;     /*!< [1..0] Address Multiplex Select                                           */
            uint8_t           : 6;
        } SDADR_b;
    };
    __IM uint8_t  RESERVED10;
    __IM uint16_t RESERVED11;

    union
    {
        __IOM uint32_t SDTR;           /*!< (@ 0x00000044) SDRAM Timing Register                                      */

        struct
        {
            __IOM uint32_t CL  : 3;    /*!< [2..0] SDRAMC Column Latency                                              */
            uint32_t           : 5;
            __IOM uint32_t WR  : 1;    /*!< [8..8] Write Recovery Interval                                            */
            __IOM uint32_t RP  : 3;    /*!< [11..9] Row Precharge Interval ( RP+1 cycles )                            */
            __IOM uint32_t RCD : 2;    /*!< [13..12] Row Column Latency ( RCD+1 cycles )                              */
            uint32_t           : 2;
            __IOM uint32_t RAS : 3;    /*!< [18..16] Row Active Interval                                              */
            uint32_t           : 13;
        } SDTR_b;
    };

    union
    {
        __IOM uint16_t SDMOD;          /*!< (@ 0x00000048) SDRAM Mode Register                                        */

        struct
        {
            __IOM uint16_t MR : 15;    /*!< [14..0] Mode Register SettingWriting to these bits: Mode register
                                        *   set command is issued.                                                    */
            uint16_t : 1;
        } SDMOD_b;
    };
    __IM uint16_t RESERVED12;
    __IM uint32_t RESERVED13;

    union
    {
        __IM uint8_t SDSR;             /*!< (@ 0x00000050) SDRAM Status Register                                      */

        struct
        {
            __IM uint8_t MRSST : 1;    /*!< [0..0] Mode Register Setting Status                                       */
            uint8_t            : 2;
            __IM uint8_t INIST : 1;    /*!< [3..3] Initialization Status                                              */
            __IM uint8_t SRFST : 1;    /*!< [4..4] Self-Refresh Transition/Recovery Status                            */
            uint8_t            : 3;
        } SDSR_b;
    };
    __IM uint8_t  RESERVED14;
    __IM uint16_t RESERVED15;
} R_BUS_SDRAM_Type;                    /*!< Size = 84 (0x54)                                                          */

/**
 * @brief R_BUS_BUSERR [BUSERR] (Bus Error Registers)
 */
typedef struct
{
    union
    {
        __IM uint32_t ADD;             /*!< (@ 0x00000000) Bus Error Address Register                                 */

        struct
        {
            __IM uint32_t BERAD : 32;  /*!< [31..0] Bus Error AddressWhen a bus error occurs, It stores
                                        *   an error address.                                                         */
        } ADD_b;
    };

    union
    {
        __IM uint8_t STAT;             /*!< (@ 0x00000004) Bus Error Status Register                                  */

        struct
        {
            __IM uint8_t ACCSTAT : 1;  /*!< [0..0] Error access statusThe status at the time of the error             */
            uint8_t              : 6;
            __IM uint8_t ERRSTAT : 1;  /*!< [7..7] Bus Error StatusWhen bus error assert, error flag occurs.          */
        } STAT_b;
    };
    __IM uint8_t  RESERVED;
    __IM uint16_t RESERVED1;
    __IM uint32_t RESERVED2[2];
} R_BUS_BUSERR_Type;                   /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_BUS_BUSM [BUSM] (Master Bus Control Register Array)
 */
typedef struct
{
    union
    {
        __IOM uint16_t CNT;            /*!< (@ 0x00000000) Master Bus Control Register                                */

        struct
        {
            uint16_t             : 15;
            __IOM uint16_t IERES : 1;  /*!< [15..15] Ignore Error Responses                                           */
        } CNT_b;
    };
    __IM uint16_t RESERVED;
} R_BUS_BUSM_Type;                     /*!< Size = 4 (0x4)                                                            */

/**
 * @brief R_BUS_BUSS [BUSS] (Slave Bus Control Register Array)
 */
typedef struct
{
    union
    {
        __IOM uint16_t CNT;            /*!< (@ 0x00000000) Slave Bus Control Register                                 */

        struct
        {
            uint16_t              : 4;
            __IOM uint16_t ARBMET : 2; /*!< [5..4] Arbitration MethodSpecify the priority between groups              */
            uint16_t              : 10;
        } CNT_b;
    };
    __IM uint16_t RESERVED;
} R_BUS_BUSS_Type;                     /*!< Size = 4 (0x4)                                                            */

/**
 * @brief R_CANFD_CFDC [CFDC] (Channel Control/Status)
 */
typedef struct
{
    union
    {
        __IOM uint32_t NCFG;            /*!< (@ 0x00000000) Channel Nominal Bitrate Configuration Register             */

        struct
        {
            __IOM uint32_t NBRP   : 10; /*!< [9..0] Channel Nominal Baud Rate Prescaler                                */
            __IOM uint32_t NSJW   : 7;  /*!< [16..10] Resynchronization Jump Width                                     */
            __IOM uint32_t NTSEG1 : 8;  /*!< [24..17] Timing Segment 1                                                 */
            __IOM uint32_t NTSEG2 : 7;  /*!< [31..25] Timing Segment 2                                                 */
        } NCFG_b;
    };

    union
    {
        __IOM uint32_t CTR;             /*!< (@ 0x00000004) Channel Control Registers                                  */

        struct
        {
            __IOM uint32_t CHMDC   : 2; /*!< [1..0] Channel Mode Control                                               */
            __IOM uint32_t CSLPR   : 1; /*!< [2..2] Channel Sleep Request                                              */
            __IOM uint32_t RTBO    : 1; /*!< [3..3] Return from Bus-Off                                                */
            uint32_t               : 4;
            __IOM uint32_t BEIE    : 1; /*!< [8..8] Bus Error Interrupt Enable                                         */
            __IOM uint32_t EWIE    : 1; /*!< [9..9] Error Warning Interrupt Enable                                     */
            __IOM uint32_t EPIE    : 1; /*!< [10..10] Error Passive Interrupt Enable                                   */
            __IOM uint32_t BOEIE   : 1; /*!< [11..11] Bus-Off Entry Interrupt Enable                                   */
            __IOM uint32_t BORIE   : 1; /*!< [12..12] Bus-Off Recovery Interrupt Enable                                */
            __IOM uint32_t OLIE    : 1; /*!< [13..13] Overload Interrupt Enable                                        */
            __IOM uint32_t BLIE    : 1; /*!< [14..14] Bus Lock Interrupt Enable                                        */
            __IOM uint32_t ALIE    : 1; /*!< [15..15] Arbitration Lost Interrupt Enable                                */
            __IOM uint32_t TAIE    : 1; /*!< [16..16] Transmission abort Interrupt Enable                              */
            __IOM uint32_t EOCOIE  : 1; /*!< [17..17] Error occurrence counter overflow Interrupt enable               */
            __IOM uint32_t SOCOIE  : 1; /*!< [18..18] Successful Occurrence Counter Overflow Interrupt enable          */
            __IOM uint32_t TDCVFIE : 1; /*!< [19..19] Transceiver Delay Compensation Violation Interrupt
                                         *   enable                                                                    */
            uint32_t            : 1;
            __IOM uint32_t BOM  : 2;    /*!< [22..21] Channel Bus-Off Mode                                             */
            __IOM uint32_t ERRD : 1;    /*!< [23..23] Channel Error Display                                            */
            __IOM uint32_t CTME : 1;    /*!< [24..24] Channel Test Mode Enable                                         */
            __IOM uint32_t CTMS : 2;    /*!< [26..25] Channel Test Mode Select                                         */
            uint32_t            : 3;
            __IOM uint32_t CRCT : 1;    /*!< [30..30] CRC Error Test                                                   */
            __IOM uint32_t ROM  : 1;    /*!< [31..31] Restricted Operation Mode                                        */
        } CTR_b;
    };

    union
    {
        __IOM uint32_t STS;             /*!< (@ 0x00000008) Channel Status Registers                                   */

        struct
        {
            __IM uint32_t  CRSTSTS : 1; /*!< [0..0] Channel RESET Status                                               */
            __IM uint32_t  CHLTSTS : 1; /*!< [1..1] Channel HALT Status                                                */
            __IM uint32_t  CSLPSTS : 1; /*!< [2..2] Channel SLEEP Status                                               */
            __IM uint32_t  EPSTS   : 1; /*!< [3..3] Channel Error Passive Status                                       */
            __IM uint32_t  BOSTS   : 1; /*!< [4..4] Channel Bus-Off Status                                             */
            __IM uint32_t  TRMSTS  : 1; /*!< [5..5] Channel Transmit Status                                            */
            __IM uint32_t  RECSTS  : 1; /*!< [6..6] Channel Receive Status                                             */
            __IM uint32_t  COMSTS  : 1; /*!< [7..7] Channel Communication Status                                       */
            __IOM uint32_t ESIF    : 1; /*!< [8..8] Error State Indication Flag                                        */
            uint32_t               : 7;
            __IM uint32_t  REC     : 8; /*!< [23..16] Reception Error Count                                            */
            __IOM uint32_t TEC     : 8; /*!< [31..24] Transmission Error Count                                         */
        } STS_b;
    };

    union
    {
        __IOM uint32_t ERFL;           /*!< (@ 0x0000000C) Channel Error Flag Registers                               */

        struct
        {
            __IOM uint32_t BEF   : 1;  /*!< [0..0] Bus Error Flag                                                     */
            __IOM uint32_t EWF   : 1;  /*!< [1..1] Error Warning Flag                                                 */
            __IOM uint32_t EPF   : 1;  /*!< [2..2] Error Passive Flag                                                 */
            __IOM uint32_t BOEF  : 1;  /*!< [3..3] Bus-Off Entry Flag                                                 */
            __IOM uint32_t BORF  : 1;  /*!< [4..4] Bus-Off Recovery Flag                                              */
            __IOM uint32_t OVLF  : 1;  /*!< [5..5] Overload Flag                                                      */
            __IOM uint32_t BLF   : 1;  /*!< [6..6] Bus Lock Flag                                                      */
            __IOM uint32_t ALF   : 1;  /*!< [7..7] Arbitration Lost Flag                                              */
            __IOM uint32_t SERR  : 1;  /*!< [8..8] Stuff Error                                                        */
            __IOM uint32_t FERR  : 1;  /*!< [9..9] Form Error                                                         */
            __IOM uint32_t AERR  : 1;  /*!< [10..10] Acknowledge Error                                                */
            __IOM uint32_t CERR  : 1;  /*!< [11..11] CRC Error                                                        */
            __IOM uint32_t B1ERR : 1;  /*!< [12..12] Bit 1 Error                                                      */
            __IOM uint32_t B0ERR : 1;  /*!< [13..13] Bit 0 Error                                                      */
            __IOM uint32_t ADERR : 1;  /*!< [14..14] Acknowledge Delimiter Error                                      */
            uint32_t             : 1;
            __IM uint32_t CRCREG : 15; /*!< [30..16] CRC Register value                                               */
            uint32_t             : 1;
        } ERFL_b;
    };
} R_CANFD_CFDC_Type;                   /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_CANFD_CFDC2 [CFDC2] (Channel Configuration Registers)
 */
typedef struct
{
    union
    {
        __IOM uint32_t DCFG;           /*!< (@ 0x00000000) Channel Data Bitrate Configuration Register                */

        struct
        {
            __IOM uint32_t DBRP   : 8; /*!< [7..0] Channel Data Baud Rate Prescaler                                   */
            __IOM uint32_t DTSEG1 : 5; /*!< [12..8] Timing Segment 1                                                  */
            uint32_t              : 3;
            __IOM uint32_t DTSEG2 : 4; /*!< [19..16] Timing Segment 2                                                 */
            uint32_t              : 4;
            __IOM uint32_t DSJW   : 4; /*!< [27..24] Resynchronization Jump Width                                     */
            uint32_t              : 4;
        } DCFG_b;
    };

    union
    {
        __IOM uint32_t FDCFG;          /*!< (@ 0x00000004) Channel CAN-FD Configuration Register                      */

        struct
        {
            __IOM uint32_t EOCCFG : 3; /*!< [2..0] Error Occurrence Counter Configuration                             */
            uint32_t              : 5;
            __IOM uint32_t TDCOC  : 1; /*!< [8..8] Transceiver Delay Compensation Offset Configuration                */
            __IOM uint32_t TDCE   : 1; /*!< [9..9] Transceiver Delay Compensation Enable                              */
            __IOM uint32_t ESIC   : 1; /*!< [10..10] Error State Indication Configuration                             */
            uint32_t              : 5;
            __IOM uint32_t TDCO   : 8; /*!< [23..16] Transceiver Delay Compensation Offset                            */
            uint32_t              : 4;
            __IOM uint32_t FDOE   : 1; /*!< [28..28] FD only enable                                                   */
            __IOM uint32_t REFE   : 1; /*!< [29..29] RX edge filter enable                                            */
            __IOM uint32_t CLOE   : 1; /*!< [30..30] Classical CAN only enable                                        */
            uint32_t              : 1;
        } FDCFG_b;
    };

    union
    {
        __IOM uint32_t FDCTR;          /*!< (@ 0x00000008) Channel CAN-FD Control Register                            */

        struct
        {
            __IOM uint32_t EOCCLR : 1; /*!< [0..0] Error Occurrence Counter Clear                                     */
            __IOM uint32_t SOCCLR : 1; /*!< [1..1] Successful Occurrence Counter Clear                                */
            uint32_t              : 30;
        } FDCTR_b;
    };

    union
    {
        __IOM uint32_t FDSTS;          /*!< (@ 0x0000000C) Channel CAN-FD Status Register                             */

        struct
        {
            __IM uint32_t  TDCR  : 8;  /*!< [7..0] Transceiver Delay Compensation Result                              */
            __IOM uint32_t EOCO  : 1;  /*!< [8..8] Error occurrence counter overflow                                  */
            __IOM uint32_t SOCO  : 1;  /*!< [9..9] Successful occurrence counter overflow                             */
            uint32_t             : 5;
            __IOM uint32_t TDCVF : 1;  /*!< [15..15] Transceiver Delay Compensation Violation Flag                    */
            __IM uint32_t  EOC   : 8;  /*!< [23..16] Error occurrence counter register                                */
            __IM uint32_t  SOC   : 8;  /*!< [31..24] Successful occurrence counter register                           */
        } FDSTS_b;
    };

    union
    {
        __IOM uint32_t FDCRC;          /*!< (@ 0x00000010) Channel CAN-FD CRC Register                                */

        struct
        {
            __IM uint32_t CRCREG : 21; /*!< [20..0] CRC Register value                                                */
            uint32_t             : 3;
            __IM uint32_t SCNT   : 4;  /*!< [27..24] Stuff bit count                                                  */
            uint32_t             : 4;
        } FDCRC_b;
    };
    __IM uint32_t RESERVED[3];
} R_CANFD_CFDC2_Type;                  /*!< Size = 32 (0x20)                                                          */

/**
 * @brief R_CANFD_CFDGAFL [CFDGAFL] (Global Acceptance Filter List Registers)
 */
typedef struct
{
    union
    {
        __IOM uint32_t ID;               /*!< (@ 0x00000000) Global Acceptance Filter List ID Registers                 */

        struct
        {
            __IOM uint32_t GAFLID  : 29; /*!< [28..0] Global Acceptance Filter List Entry ID Field                      */
            __IOM uint32_t GAFLLB  : 1;  /*!< [29..29] Global Acceptance Filter List Entry Loopback Configuration       */
            __IOM uint32_t GAFLRTR : 1;  /*!< [30..30] Global Acceptance Filter List Entry RTR Field                    */
            __IOM uint32_t GAFLIDE : 1;  /*!< [31..31] Global Acceptance Filter List Entry IDE Field                    */
        } ID_b;
    };

    union
    {
        __IOM uint32_t M;                 /*!< (@ 0x00000004) Global Acceptance Filter List Mask Registers               */

        struct
        {
            __IOM uint32_t GAFLIDM  : 29; /*!< [28..0] Global Acceptance Filter List ID Mask Field                       */
            __IOM uint32_t GAFLIFL1 : 1;  /*!< [29..29] Global Acceptance Filter List Information Label 1                */
            __IOM uint32_t GAFLRTRM : 1;  /*!< [30..30] Global Acceptance Filter List Entry RTR Mask                     */
            __IOM uint32_t GAFLIDEM : 1;  /*!< [31..31] Global Acceptance Filter List IDE Mask                           */
        } M_b;
    };

    union
    {
        __IOM uint32_t P0;               /*!< (@ 0x00000008) Global Acceptance Filter List Pointer 0 Registers          */

        struct
        {
            __IOM uint32_t GAFLDLC  : 4; /*!< [3..0] Global Acceptance Filter List DLC Field                            */
            uint32_t                : 3;
            __IOM uint32_t GAFLIFL0 : 1; /*!< [7..7] Global Acceptance Filter List Information Label 0                  */
            __IOM uint32_t GAFLRMDP : 5; /*!< [12..8] Global Acceptance Filter List RX Message Buffer Direction
                                          *   Pointer                                                                   */
            uint32_t               : 2;
            __IOM uint32_t GAFLRMV : 1;  /*!< [15..15] Global Acceptance Filter List RX Message Buffer Valid            */
            __IOM uint32_t GAFLPTR : 16; /*!< [31..16] Global Acceptance Filter List Pointer Field                      */
        } P0_b;
    };

    union
    {
        __IOM uint32_t P1;              /*!< (@ 0x0000000C) Global Acceptance Filter List Pointer 1 Registers          */

        struct
        {
            __IOM uint32_t GAFLFDP : 9; /*!< [8..0] Global Acceptance Filter List FIFO Direction Pointer               */
            uint32_t               : 23;
        } P1_b;
    };
} R_CANFD_CFDGAFL_Type;                 /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_CANFD_CFDTHL [CFDTHL] (Channel TX History List)
 */
typedef struct
{
    union
    {
        __IM uint32_t ACC0;            /*!< (@ 0x00000000) Channel TX History List Access Registers 0                 */

        struct
        {
            __IM uint32_t BT   : 3;    /*!< [2..0] Buffer Type                                                        */
            __IM uint32_t BN   : 7;    /*!< [9..3] Buffer No.                                                         */
            uint32_t           : 6;
            __IM uint32_t TMTS : 16;   /*!< [31..16] Transmit Timestamp                                               */
        } ACC0_b;
    };

    union
    {
        __IOM uint32_t ACC1;           /*!< (@ 0x00000004) Channel TX History List Access Registers 1                 */

        struct
        {
            __IM uint32_t TID  : 16;   /*!< [15..0] Transmit ID                                                       */
            __IM uint32_t TIFL : 2;    /*!< [17..16] Transmit Information Label                                       */
            uint32_t           : 14;
        } ACC1_b;
    };
} R_CANFD_CFDTHL_Type;                 /*!< Size = 8 (0x8)                                                            */

/**
 * @brief R_CANFD_CFDRF [CFDRF] (RX FIFO Access Registers)
 */
typedef struct
{
    union
    {
        __IM uint32_t ID;              /*!< (@ 0x00000000) RX FIFO Access ID Register                                 */

        struct
        {
            __IM uint32_t RFID  : 29;  /*!< [28..0] RX FIFO Buffer ID Field                                           */
            uint32_t            : 1;
            __IM uint32_t RFRTR : 1;   /*!< [30..30] RX FIFO Buffer RTR Frame                                         */
            __IM uint32_t RFIDE : 1;   /*!< [31..31] RX FIFO Buffer IDE Bit                                           */
        } ID_b;
    };

    union
    {
        __IM uint32_t PTR;             /*!< (@ 0x00000004) RX FIFO Access Pointer Register                            */

        struct
        {
            __IM uint32_t RFTS  : 16;  /*!< [15..0] RX FIFO Timestamp Field                                           */
            uint32_t            : 12;
            __IM uint32_t RFDLC : 4;   /*!< [31..28] RX FIFO Buffer DLC Field                                         */
        } PTR_b;
    };

    union
    {
        __IM uint32_t FDSTS;           /*!< (@ 0x00000008) RX FIFO Access CAN-FD Status Register                      */

        struct
        {
            __IM uint32_t RFESI : 1;   /*!< [0..0] Error State Indicator bit                                          */
            __IM uint32_t RFBRS : 1;   /*!< [1..1] Bit Rate Switch bit                                                */
            __IM uint32_t RFFDF : 1;   /*!< [2..2] CAN FD Format bit                                                  */
            uint32_t            : 5;
            __IM uint32_t RFIFL : 2;   /*!< [9..8] RX FIFO Buffer Information Label Field                             */
            uint32_t            : 6;
            __IM uint32_t RFPTR : 16;  /*!< [31..16] RX FIFO Buffer Pointer Field                                     */
        } FDSTS_b;
    };

    union
    {
        __IM uint8_t DF[64];           /*!< (@ 0x0000000C) RX FIFO Access Data Field Registers                        */

        struct
        {
            __IM uint8_t RFDB : 8;     /*!< [7..0] RX FIFO Buffer Data Byte                                           */
        } DF_b[64];
    };
} R_CANFD_CFDRF_Type;                  /*!< Size = 76 (0x4c)                                                          */

/**
 * @brief R_CANFD_CFDCF [CFDCF] (Common FIFO Access Registers)
 */
typedef struct
{
    union
    {
        __IOM uint32_t ID;             /*!< (@ 0x00000000) Common FIFO Access ID Register                             */

        struct
        {
            __IOM uint32_t CFID  : 29; /*!< [28..0] Common FIFO Buffer ID Field                                       */
            uint32_t             : 1;
            __IOM uint32_t CFRTR : 1;  /*!< [30..30] Common FIFO Buffer RTR Frame                                     */
            __IOM uint32_t CFIDE : 1;  /*!< [31..31] Common FIFO Buffer IDE Bit                                       */
        } ID_b;
    };

    union
    {
        __IOM uint32_t PTR;            /*!< (@ 0x00000004) Common FIFO Access Pointer Register                        */

        struct
        {
            __IOM uint32_t CFTS  : 16; /*!< [15..0] Common FIFO Timestamp Field                                       */
            uint32_t             : 12;
            __IOM uint32_t CFDLC : 4;  /*!< [31..28] Common FIFO Buffer DLC Field                                     */
        } PTR_b;
    };

    union
    {
        __IOM uint32_t FDSTS;          /*!< (@ 0x00000008) Common FIFO Access CAN-FD Status Register                  */

        struct
        {
            __IOM uint32_t CFESI : 1;  /*!< [0..0] Error State Indicator bit                                          */
            __IOM uint32_t CFBRS : 1;  /*!< [1..1] Bit Rate Switch bit                                                */
            __IOM uint32_t CFFDF : 1;  /*!< [2..2] CAN FD Format bit                                                  */
            uint32_t             : 5;
            __IOM uint32_t CFIFL : 2;  /*!< [9..8] Common FIFO Buffer Information Label Field                         */
            uint32_t             : 6;
            __IOM uint32_t CFPTR : 16; /*!< [31..16] Common FIFO Buffer Pointer Field                                 */
        } FDSTS_b;
    };

    union
    {
        __IOM uint8_t DF[64];          /*!< (@ 0x0000000C) Common FIFO Access Data Field Registers                    */

        struct
        {
            __IOM uint8_t CFDB : 8;    /*!< [7..0] Common FIFO Buffer Data Byte                                       */
        } DF_b[64];
    };
} R_CANFD_CFDCF_Type;                  /*!< Size = 76 (0x4c)                                                          */

/**
 * @brief R_CANFD_CFDTM [CFDTM] (TX Message Buffer Access Registers)
 */
typedef struct
{
    union
    {
        __IOM uint32_t ID;             /*!< (@ 0x00000000) TX Message Buffer ID Register                              */

        struct
        {
            __IOM uint32_t TMID  : 29; /*!< [28..0] TX Message Buffer ID Field                                        */
            uint32_t             : 1;
            __IOM uint32_t TMRTR : 1;  /*!< [30..30] TX Message Buffer RTR Frame                                      */
            __IOM uint32_t TMIDE : 1;  /*!< [31..31] TX Message Buffer IDE Bit                                        */
        } ID_b;
    };

    union
    {
        __IOM uint32_t PTR;            /*!< (@ 0x00000004) TX Message Buffer Pointer Register                         */

        struct
        {
            __IOM uint32_t TMTS  : 16; /*!< [15..0] TX Message Buffer Timestamp Field                                 */
            uint32_t             : 12;
            __IOM uint32_t TMDLC : 4;  /*!< [31..28] TX Message Buffer DLC Field                                      */
        } PTR_b;
    };

    union
    {
        __IOM uint32_t FDCTR;          /*!< (@ 0x00000008) TX Message Buffer CAN-FD Control Register                  */

        struct
        {
            __IOM uint32_t TMESI : 1;  /*!< [0..0] Error State Indicator bit                                          */
            __IOM uint32_t TMBRS : 1;  /*!< [1..1] Bit Rate Switch bit                                                */
            __IOM uint32_t TMFDF : 1;  /*!< [2..2] CAN FD Format bit                                                  */
            uint32_t             : 5;
            __IOM uint32_t TMIFL : 2;  /*!< [9..8] TX Message Buffer Information Label Field                          */
            uint32_t             : 6;
            __IOM uint32_t TMPTR : 16; /*!< [31..16] TX Message Buffer Pointer Field                                  */
        } FDCTR_b;
    };

    union
    {
        __IOM uint8_t DF[64];          /*!< (@ 0x0000000C) TX Message Buffer Data Field Registers                     */

        struct
        {
            __IOM uint8_t TMDB : 8;    /*!< [7..0] TX Message Buffer Data Byte                                        */
        } DF_b[64];
    };
} R_CANFD_CFDTM_Type;                  /*!< Size = 76 (0x4c)                                                          */

/**
 * @brief R_CANFD_CFDRM_RM [RM] (RX Message Buffer Access Registers)
 */
typedef struct
{
    union
    {
        __IM uint32_t ID;              /*!< (@ 0x00000000) RX Message Buffer ID Register                              */

        struct
        {
            __IM uint32_t RMID  : 29;  /*!< [28..0] RX Message Buffer ID Field                                        */
            uint32_t            : 1;
            __IM uint32_t RMRTR : 1;   /*!< [30..30] RX Message Buffer RTR Frame                                      */
            __IM uint32_t RMIDE : 1;   /*!< [31..31] RX Message Buffer IDE Bit                                        */
        } ID_b;
    };

    union
    {
        __IM uint32_t PTR;             /*!< (@ 0x00000004) RX Message Buffer Pointer Register                         */

        struct
        {
            __IM uint32_t RMTS  : 16;  /*!< [15..0] RX Message Buffer Timestamp Field                                 */
            uint32_t            : 12;
            __IM uint32_t RMDLC : 4;   /*!< [31..28] RX Message Buffer DLC Field                                      */
        } PTR_b;
    };

    union
    {
        __IM uint32_t FDSTS;           /*!< (@ 0x00000008) RX Message Buffer CAN-FD Status Register                   */

        struct
        {
            __IM uint32_t RMESI : 1;   /*!< [0..0] Error State Indicator bit                                          */
            __IM uint32_t RMBRS : 1;   /*!< [1..1] Bit Rate Switch bit                                                */
            __IM uint32_t RMFDF : 1;   /*!< [2..2] CAN FD Format bit                                                  */
            uint32_t            : 5;
            __IM uint32_t RMIFL : 2;   /*!< [9..8] RX Message Buffer Information Label Field                          */
            uint32_t            : 6;
            __IM uint32_t RMPTR : 16;  /*!< [31..16] RX Message Buffer Pointer Field                                  */
        } FDSTS_b;
    };

    union
    {
        __IM uint8_t DF[64];           /*!< (@ 0x0000000C) RX Message Buffer Data Field Registers                     */

        struct
        {
            __IM uint8_t RMDB : 8;     /*!< [7..0] RX Message Buffer Data Byte                                        */
        } DF_b[64];
    };
} R_CANFD_CFDRM_RM_Type;               /*!< Size = 76 (0x4c)                                                          */

/**
 * @brief R_CANFD_CFDRM [CFDRM] (RX Message Buffer Access Clusters)
 */
typedef struct
{
    __IOM R_CANFD_CFDRM_RM_Type RM[8]; /*!< (@ 0x00000000) RX Message Buffer Access Registers                         */
    __IM uint32_t               RESERVED[104];
} R_CANFD_CFDRM_Type;                  /*!< Size = 1024 (0x400)                                                       */

/**
 * @brief R_ELC_ELSEGR [ELSEGR] (Event Link Software Event Generation Register)
 */
typedef struct
{
    union
    {
        __IOM uint8_t BY;              /*!< (@ 0x00000000) Event Link Software Event Generation Register              */

        struct
        {
            __OM uint8_t SEG : 1;      /*!< [0..0] Software Event Generation                                          */
            uint8_t          : 5;
            __IOM uint8_t WE : 1;      /*!< [6..6] SEG Bit Write Enable                                               */
            __OM uint8_t  WI : 1;      /*!< [7..7] ELSEGR Register Write Disable                                      */
        } BY_b;
    };
    __IM uint8_t RESERVED;
} R_ELC_ELSEGR_Type;                   /*!< Size = 2 (0x2)                                                            */

/**
 * @brief R_ELC_ELSR [ELSR] (Event Link Setting Register [0..22])
 */
typedef struct
{
    union
    {
        __IOM uint16_t HA;             /*!< (@ 0x00000000) Event Link Setting Register                                */

        struct
        {
            __IOM uint16_t ELS : 9;    /*!< [8..0] Event Link Select                                                  */
            uint16_t           : 7;
        } HA_b;
    };
    __IM uint16_t RESERVED;
} R_ELC_ELSR_Type;                     /*!< Size = 4 (0x4)                                                            */

/**
 * @brief R_IIC0_SAR [SAR] (Slave Address Registers)
 */
typedef struct
{
    union
    {
        __IOM uint8_t L;               /*!< (@ 0x00000000) Slave Address Register L                                   */

        struct
        {
            __IOM uint8_t SVA : 8;     /*!< [7..0] A slave address is set.7-Bit Address = SVA[7:1] 10-Bit
                                        *   Address = { SVA9,SVA8,SVA[7:0] }                                          */
        } L_b;
    };

    union
    {
        __IOM uint8_t U;               /*!< (@ 0x00000001) Slave Address Register U                                   */

        struct
        {
            __IOM uint8_t FS   : 1;    /*!< [0..0] 7-Bit/10-Bit Address Format Selection                              */
            __IOM uint8_t SVA8 : 1;    /*!< [1..1] 10-Bit Address(bit8)                                               */
            __IOM uint8_t SVA9 : 1;    /*!< [2..2] 10-Bit Address(bit9)                                               */
            uint8_t            : 5;
        } U_b;
    };
} R_IIC0_SAR_Type;                     /*!< Size = 2 (0x2)                                                            */

/**
 * @brief R_MPU_MMPU_MMPU_REGION [REGION] (Address Region registers)
 */
typedef struct
{
    union
    {
        __IOM uint16_t C;              /*!< (@ 0x00000000) Access Control Register                                    */

        struct
        {
            __IOM uint16_t ENABLE : 1; /*!< [0..0] Region enable                                                      */
            __IOM uint16_t RP     : 1; /*!< [1..1] Read protection                                                    */
            __IOM uint16_t WP     : 1; /*!< [2..2] Write protection                                                   */
            uint16_t              : 13;
        } C_b;
    };
    __IM uint16_t RESERVED;

    union
    {
        __IOM uint32_t S;                /*!< (@ 0x00000004) Start Address Register                                     */

        struct
        {
            __IOM uint32_t MMPUSmn : 32; /*!< [31..0] Address where the region starts, for use in region determination.NOTE:
                                          *   The low-order 2 bits are fixed to 0.                                      */
        } S_b;
    };

    union
    {
        __IOM uint32_t E;                /*!< (@ 0x00000008) End Address Register                                       */

        struct
        {
            __IOM uint32_t MMPUEmn : 32; /*!< [31..0] Region end address registerAddress where the region
                                          *   end, for use in region determination.NOTE: The low-order
                                          *   2 bits are fixed to 1.                                                    */
        } E_b;
    };
    __IM uint32_t RESERVED1;
} R_MPU_MMPU_MMPU_REGION_Type;           /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_MPU_MMPU_MMPU [MMPU] (Bus Master MPU Registers)
 */
typedef struct
{
    union
    {
        __IOM uint16_t CTL;            /*!< (@ 0x00000000) Bus Master MPU Control Register                            */

        struct
        {
            __IOM uint16_t ENABLE : 1; /*!< [0..0] Master Group enable                                                */
            __IOM uint16_t OAD    : 1; /*!< [1..1] Operation after detection                                          */
            uint16_t              : 6;
            __OM uint16_t KEY     : 8; /*!< [15..8] Write Keyword The data written to these bits are not
                                        *   stored.                                                                   */
        } CTL_b;
    };
    __IM uint16_t RESERVED;
    __IM uint32_t RESERVED1[63];
    __IM uint16_t RESERVED2;

    union
    {
        __IOM uint16_t PT;                        /*!< (@ 0x00000102) Protection of Register                                     */

        struct
        {
            __IOM uint16_t PROTECT : 1;           /*!< [0..0] Protection of region register                                      */
            uint16_t               : 7;
            __OM uint16_t KEY      : 8;           /*!< [15..8] Write Keyword The data written to these bits are not
                                                   *   stored.                                                                   */
        } PT_b;
    };
    __IM uint32_t RESERVED3[63];
    __IOM R_MPU_MMPU_MMPU_REGION_Type REGION[32]; /*!< (@ 0x00000200) Address Region registers                                   */
} R_MPU_MMPU_MMPU_Type;                           /*!< Size = 1024 (0x400)                                                       */

/**
 * @brief R_MPU_SMPU_SMPU [SMPU] (Access Control Structure for MBIU)
 */
typedef struct
{
    union
    {
        __IOM uint16_t R;              /*!< (@ 0x00000000) Access Control Register for MBIU                           */

        struct
        {
            uint16_t              : 2;
            __IOM uint16_t RPGRPA : 1;   /*!< [2..2] Master Group A Read protection                                     */
            __IOM uint16_t WPGRPA : 1;   /*!< [3..3] Master Group A Write protection                                    */
            __IOM uint16_t RPGRPB : 1;   /*!< [4..4] Master Group B Read protection                                     */
            __IOM uint16_t WPGRPB : 1;   /*!< [5..5] Master Group B Write protection                                    */
            __IOM uint16_t RPGRPC : 1;   /*!< [6..6] Master Group C Read protection                                     */
            __IOM uint16_t WPGRPC : 1;   /*!< [7..7] Master Group C Write protection                                    */
            uint16_t              : 4;
            __IOM uint16_t RPFLI  : 1;   /*!< [12..12] Code Flash Memory Read Protection                                */
            __IOM uint16_t WPFLI  : 1;   /*!< [13..13] Code Flash Memory Write Protection (Note: This bit
                                          *   is read as 1. The write value should be 1.)                               */
            __IOM uint16_t RPSRAMHS : 1; /*!< [14..14] SRAMHS Read Protection                                           */
            __IOM uint16_t WPSRAMHS : 1; /*!< [15..15] SRAMHS Write Protection                                          */
        } R_b;
    };
    __IM uint16_t RESERVED;
} R_MPU_SMPU_SMPU_Type;                  /*!< Size = 4 (0x4)                                                            */

/**
 * @brief R_MPU_SPMON_SP [SP] (Stack Pointer Monitor)
 */
typedef struct
{
    union
    {
        __IOM uint16_t OAD;            /*!< (@ 0x00000000) Stack Pointer Monitor Operation After Detection
                                        *                  Register                                                   */

        struct
        {
            __IOM uint16_t OAD : 1;    /*!< [0..0] Operation after detection                                          */
            uint16_t           : 7;
            __OM uint16_t KEY  : 8;    /*!< [15..8] Write Keyword The data written to these bits are not
                                        *   stored.                                                                   */
        } OAD_b;
    };
    __IM uint16_t RESERVED;

    union
    {
        __IOM uint16_t CTL;            /*!< (@ 0x00000004) Stack Pointer Monitor Access Control Register              */

        struct
        {
            __IOM uint16_t ENABLE : 1; /*!< [0..0] Stack Pointer Monitor Enable                                       */
            uint16_t              : 7;
            __IOM uint16_t ERROR  : 1; /*!< [8..8] Stack Pointer Monitor Error Flag                                   */
            uint16_t              : 7;
        } CTL_b;
    };

    union
    {
        __IOM uint16_t PT;              /*!< (@ 0x00000006) Stack Pointer Monitor Protection Register                  */

        struct
        {
            __IOM uint16_t PROTECT : 1; /*!< [0..0] Protection of register (MSPMPUAC, MSPMPUSA and MSPMPUSE)           */
            uint16_t               : 7;
            __OM uint16_t KEY      : 8; /*!< [15..8] Write Keyword The data written to these bits are not
                                         *   stored.                                                                   */
        } PT_b;
    };

    union
    {
        __IOM uint32_t SA;                /*!< (@ 0x00000008) Stack Pointer Monitor Start Address Register               */

        struct
        {
            __IOM uint32_t MSPMPUSA : 32; /*!< [31..0] Region start address register Address where the region
                                           *   starts, for use in region determination.NOTE: Range: 0x1FF00000-0x200FFFF
                                           *   The low-order 2 bits are fixed to 0.                                      */
        } SA_b;
    };

    union
    {
        __IOM uint32_t EA;                /*!< (@ 0x0000000C) Stack Pointer Monitor End Address Register                 */

        struct
        {
            __IOM uint32_t MSPMPUEA : 32; /*!< [31..0] Region end address register Address where the region
                                           *   starts, for use in region determination.NOTE: Range: 0x1FF00003-0x200FFFF
                                           *   The low-order 2 bits are fixed to 1.                                      */
        } EA_b;
    };
} R_MPU_SPMON_SP_Type;                    /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_PFS_PORT_PIN [PIN] (Pin Function Selects)
 */
typedef struct
{
    union
    {
        union
        {
            __IOM uint32_t PmnPFS;        /*!< (@ 0x00000000) Pin Function Control Register                              */

            struct
            {
                __IOM uint32_t PODR  : 1; /*!< [0..0] Port Output Data                                                   */
                __IM uint32_t  PIDR  : 1; /*!< [1..1] Port Input Data                                                    */
                __IOM uint32_t PDR   : 1; /*!< [2..2] Port Direction                                                     */
                uint32_t             : 1;
                __IOM uint32_t PCR   : 1; /*!< [4..4] Pull-up Control                                                    */
                __IOM uint32_t PIM   : 1; /*!< [5..5] Port Input Mode Control                                            */
                __IOM uint32_t NCODR : 1; /*!< [6..6] N-Channel Open Drain Control                                       */
                uint32_t             : 3;
                __IOM uint32_t DSCR  : 2; /*!< [11..10] Drive Strength Control Register                                  */
                __IOM uint32_t EOFR  : 2; /*!< [13..12] Event on Falling/Rising                                          */
                __IOM uint32_t ISEL  : 1; /*!< [14..14] IRQ input enable                                                 */
                __IOM uint32_t ASEL  : 1; /*!< [15..15] Analog Input enable                                              */
                __IOM uint32_t PMR   : 1; /*!< [16..16] Port Mode Control                                                */
                uint32_t             : 7;
                __IOM uint32_t PSEL  : 5; /*!< [28..24] Port Function SelectThese bits select the peripheral
                                           *   function. For individual pin functions, see the MPC table                 */
                uint32_t : 3;
            } PmnPFS_b;
        };

        struct
        {
            union
            {
                struct
                {
                    __IM uint16_t RESERVED;

                    union
                    {
                        __IOM uint16_t PmnPFS_HA;     /*!< (@ 0x00000002) Pin Function Control Register                              */

                        struct
                        {
                            __IOM uint16_t PODR  : 1; /*!< [0..0] Port Output Data                                                   */
                            __IM uint16_t  PIDR  : 1; /*!< [1..1] Port Input Data                                                    */
                            __IOM uint16_t PDR   : 1; /*!< [2..2] Port Direction                                                     */
                            uint16_t             : 1;
                            __IOM uint16_t PCR   : 1; /*!< [4..4] Pull-up Control                                                    */
                            __IOM uint16_t PIM   : 1; /*!< [5..5] Port Input Mode Control                                            */
                            __IOM uint16_t NCODR : 1; /*!< [6..6] N-Channel Open Drain Control                                       */
                            uint16_t             : 3;
                            __IOM uint16_t DSCR  : 2; /*!< [11..10] Drive Strength Control Register                                  */
                            __IOM uint16_t EOFR  : 2; /*!< [13..12] Event on Falling/Rising                                          */
                            __IOM uint16_t ISEL  : 1; /*!< [14..14] IRQ input enable                                                 */
                            __IOM uint16_t ASEL  : 1; /*!< [15..15] Analog Input enable                                              */
                        } PmnPFS_HA_b;
                    };
                };

                struct
                {
                    __IM uint16_t RESERVED1;
                    __IM uint8_t  RESERVED2;

                    union
                    {
                        __IOM uint8_t PmnPFS_BY;     /*!< (@ 0x00000003) Pin Function Control Register                              */

                        struct
                        {
                            __IOM uint8_t PODR  : 1; /*!< [0..0] Port Output Data                                                   */
                            __IM uint8_t  PIDR  : 1; /*!< [1..1] Port Input Data                                                    */
                            __IOM uint8_t PDR   : 1; /*!< [2..2] Port Direction                                                     */
                            uint8_t             : 1;
                            __IOM uint8_t PCR   : 1; /*!< [4..4] Pull-up Control                                                    */
                            __IOM uint8_t PIM   : 1; /*!< [5..5] Port Input Mode Control                                            */
                            __IOM uint8_t NCODR : 1; /*!< [6..6] N-Channel Open Drain Control                                       */
                            uint8_t             : 1;
                        } PmnPFS_BY_b;
                    };
                };
            };
        };
    };
} R_PFS_PORT_PIN_Type;                 /*!< Size = 4 (0x4)                                                            */

/**
 * @brief R_PFS_PORT [PORT] (Port [0..14])
 */
typedef struct
{
    __IOM R_PFS_PORT_PIN_Type PIN[16]; /*!< (@ 0x00000000) Pin Function Selects                                       */
} R_PFS_PORT_Type;                     /*!< Size = 64 (0x40)                                                          */

/**
 * @brief R_PFS_VLSEL [VLSEL] (VLSEL)
 */
typedef struct
{
    __IM uint8_t RESERVED[389];

    union
    {
        __IOM uint8_t VL1SEL;          /*!< (@ 0x00000185) VL1 Select Control Register                                */

        struct
        {
            __IOM uint8_t SELVL : 1;   /*!< [0..0] VL1 Voltage Connection Switching Control                           */
            uint8_t             : 7;
        } VL1SEL_b;
    };
} R_PFS_VLSEL_Type;                    /*!< Size = 390 (0x186)                                                        */

/**
 * @brief R_PMISC_PMSAR [PMSAR] (Port Security Attribution Register)
 */
typedef struct
{
    __IOM uint16_t PMSAR;              /*!< (@ 0x00000000) Port Security Attribution Register                         */
} R_PMISC_PMSAR_Type;                  /*!< Size = 2 (0x2)                                                            */

/**
 * @brief R_RTC_RTCCR [RTCCR] (AGTIO I/O direction control register)
 */
typedef struct
{
    union
    {
        __IOM uint8_t RTCCR;           /*!< (@ 0x00000000) AGTIO I/O direction control register                       */

        struct
        {
            uint8_t            : 7;
            __IOM uint8_t TCEN : 1;    /*!< [7..7] Select AGTIO I/O direction as input                                */
        } RTCCR_b;
    };
    __IM uint8_t RESERVED;
} R_RTC_RTCCR_Type;                    /*!< Size = 2 (0x2)                                                            */

/**
 * @brief R_BUS_B_CSa [CSa] (CS Registers)
 */
typedef struct
{
    __IM uint16_t RESERVED;

    union
    {
        __IOM uint16_t MOD;            /*!< (@ 0x00000002) Mode Register                                              */

        struct
        {
            __IOM uint16_t WRMOD : 1;  /*!< [0..0] Write Access Mode Select                                           */
            uint16_t             : 2;
            __IOM uint16_t EWENB : 1;  /*!< [3..3] External Wait Enable                                               */
            uint16_t             : 4;
            __IOM uint16_t PRENB : 1;  /*!< [8..8] Page Read Access Enable                                            */
            __IOM uint16_t PWENB : 1;  /*!< [9..9] Page Write Access Enable                                           */
            uint16_t             : 5;
            __IOM uint16_t PRMOD : 1;  /*!< [15..15] Page Read Access Mode Select                                     */
        } MOD_b;
    };

    union
    {
        __IOM uint32_t WCR1;             /*!< (@ 0x00000004) Wait Control Register 1                                    */

        struct
        {
            __IOM uint32_t CSPWWAIT : 3; /*!< [2..0] Page Write Cycle Wait SelectNOTE: The CSPWWAIT value
                                          *   is valid only when the PWENB bit in CSnMOD is set to 1.                   */
            uint32_t                : 5;
            __IOM uint32_t CSPRWAIT : 3; /*!< [10..8] Page Read Cycle Wait SelectNOTE: The CSPRWAIT value
                                          *   is valid only when the PRENB bit in CSnMOD is set to 1.                   */
            uint32_t               : 5;
            __IOM uint32_t CSWWAIT : 5;  /*!< [20..16] Normal Write Cycle Wait Select                                   */
            uint32_t               : 3;
            __IOM uint32_t CSRWAIT : 5;  /*!< [28..24] Normal Read Cycle Wait Select                                    */
            uint32_t               : 3;
        } WCR1_b;
    };

    union
    {
        __IOM uint32_t WCR2;           /*!< (@ 0x00000008) Wait Control Register 2                                    */

        struct
        {
            __IOM uint32_t CSROFF : 3; /*!< [2..0] Read-Access CS Extension Cycle Select                              */
            uint32_t              : 1;
            __IOM uint32_t CSWOFF : 3; /*!< [6..4] Write-Access CS Extension Cycle Select                             */
            uint32_t              : 1;
            __IOM uint32_t WDOFF  : 3; /*!< [10..8] Write Data Output Extension Cycle Select                          */
            uint32_t              : 1;
            __IOM uint32_t AWAIT  : 2; /*!< [13..12] CS Assert Wait Select                                            */
            uint32_t              : 2;
            __IOM uint32_t RDON   : 3; /*!< [18..16] RD Assert Wait Select                                            */
            uint32_t              : 1;
            __IOM uint32_t WRON   : 3; /*!< [22..20] WR Assert Wait Select                                            */
            uint32_t              : 1;
            __IOM uint32_t WDON   : 3; /*!< [26..24] Write Data Output Wait Select                                    */
            uint32_t              : 1;
            __IOM uint32_t CSON   : 3; /*!< [30..28] CS Assert Wait Select                                            */
            uint32_t              : 1;
        } WCR2_b;
    };
    __IM uint32_t RESERVED1;
} R_BUS_B_CSa_Type;                    /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_BUS_B_CSb [CSb] (CS Registers)
 */
typedef struct
{
    __IM uint16_t RESERVED;

    union
    {
        __IOM uint16_t CR;             /*!< (@ 0x00000002) Control Register                                           */

        struct
        {
            __IOM uint16_t EXENB : 1;  /*!< [0..0] Operation Enable                                                   */
            uint16_t             : 3;
            __IOM uint16_t BSIZE : 2;  /*!< [5..4] External Bus Width Select                                          */
            uint16_t             : 2;
            __IOM uint16_t EMODE : 1;  /*!< [8..8] Endian Mode                                                        */
            uint16_t             : 3;
            __IOM uint16_t MPXEN : 1;  /*!< [12..12] Address/Data Multiplexed I/O Interface Select                    */
            uint16_t             : 3;
        } CR_b;
    };
    __IM uint16_t RESERVED1[3];

    union
    {
        __IOM uint16_t REC;            /*!< (@ 0x0000000A) Recovery Cycle Register                                    */

        struct
        {
            __IOM uint16_t RRCV : 4;   /*!< [3..0] Read Recovery                                                      */
            uint16_t            : 4;
            __IOM uint16_t WRCV : 4;   /*!< [11..8] Write Recovery                                                    */
            uint16_t            : 4;
        } REC_b;
    };
    __IM uint16_t RESERVED2[2];
} R_BUS_B_CSb_Type;                    /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_BUS_B_BUSERR [BUSERR] (Bus Error Registers)
 */
typedef struct
{
    union
    {
        __IM uint32_t ADD;             /*!< (@ 0x00000000) Bus Error Address Register                                 */

        struct
        {
            __IM uint32_t BERAD : 32;  /*!< [31..0] Bus Error AddressWhen a bus error occurs, It stores
                                        *   an error address.                                                         */
        } ADD_b;
    };

    union
    {
        __IM uint8_t ERRRW;            /*!< (@ 0x00000004) BUS Error Read Write Register                              */

        struct
        {
            __IM uint8_t RWSTAT : 1;   /*!< [0..0] Error access statusThe status at the time of the error             */
            uint8_t             : 7;
        } ERRRW_b;
    };
    __IM uint8_t  RESERVED;
    __IM uint16_t RESERVED1;
    __IM uint32_t RESERVED2[2];
} R_BUS_B_BUSERR_Type;                 /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_BUS_B_BUSTZFERR [BUSTZFERR] (Bus TZF Error Registers)
 */
typedef struct
{
    union
    {
        __IM uint32_t TZFADD;            /*!< (@ 0x00000000) Bus TZF Error Address Register                             */

        struct
        {
            __IM uint32_t BTZFERAD : 32; /*!< [31..0] Bus TrustZone Filter Error AddressWhen a bus error occurs,
                                          *   It stores an error address.                                               */
        } TZFADD_b;
    };

    union
    {
        __IM uint8_t TZFERRRW;         /*!< (@ 0x00000004) BUS TZF Error Read Write Register                          */

        struct
        {
            __IM uint8_t TRWSTAT : 1;  /*!< [0..0] TrustZone filter Error access statusThe status at the
                                        *   time of the error                                                         */
            uint8_t : 7;
        } TZFERRRW_b;
    };
    __IM uint8_t  RESERVED;
    __IM uint16_t RESERVED1;
    __IM uint32_t RESERVED2[2];
} R_BUS_B_BUSTZFERR_Type;              /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_USB_FS0_PIPE_TR [PIPE_TR] (Pipe Transaction Counter Registers)
 */
typedef struct
{
    union
    {
        __IOM uint16_t E;              /*!< (@ 0x00000000) Pipe Transaction Counter Enable Register                   */

        struct
        {
            uint16_t             : 8;
            __IOM uint16_t TRCLR : 1;  /*!< [8..8] Transaction Counter Clear                                          */
            __IOM uint16_t TRENB : 1;  /*!< [9..9] Transaction Counter Enable                                         */
            uint16_t             : 6;
        } E_b;
    };

    union
    {
        __IOM uint16_t N;               /*!< (@ 0x00000002) Pipe Transaction Counter Register                          */

        struct
        {
            __IOM uint16_t TRNCNT : 16; /*!< [15..0] Transaction Counter                                               */
        } N_b;
    };
} R_USB_FS0_PIPE_TR_Type;               /*!< Size = 4 (0x4)                                                            */

/**
 * @brief R_AGTX0_AGT16_CTRL [CTRL] (CTRL)
 */
typedef struct
{
    union
    {
        __IOM uint8_t AGTCR;           /*!< (@ 0x00000000) AGT Control Register                                       */

        struct
        {
            __IOM uint8_t TSTART : 1;  /*!< [0..0] AGT count start                                                    */
            __IM uint8_t  TCSTF  : 1;  /*!< [1..1] AGT count status flag                                              */
            __OM uint8_t  TSTOP  : 1;  /*!< [2..2] AGT count forced stop                                              */
            uint8_t              : 1;
            __IOM uint8_t TEDGF  : 1;  /*!< [4..4] Active edge judgment flag                                          */
            __IOM uint8_t TUNDF  : 1;  /*!< [5..5] Underflow flag                                                     */
            __IOM uint8_t TCMAF  : 1;  /*!< [6..6] Compare match A flag                                               */
            __IOM uint8_t TCMBF  : 1;  /*!< [7..7] Compare match B flag                                               */
        } AGTCR_b;
    };

    union
    {
        __IOM uint8_t AGTMR1;          /*!< (@ 0x00000001) AGT Mode Register 1                                        */

        struct
        {
            __IOM uint8_t TMOD   : 3;  /*!< [2..0] Operating mode                                                     */
            __IOM uint8_t TEDGPL : 1;  /*!< [3..3] Edge polarity                                                      */
            __IOM uint8_t TCK    : 3;  /*!< [6..4] Count source                                                       */
            uint8_t              : 1;
        } AGTMR1_b;
    };

    union
    {
        __IOM uint8_t AGTMR2;          /*!< (@ 0x00000002) AGT Mode Register 2                                        */

        struct
        {
            __IOM uint8_t CKS : 3;     /*!< [2..0] AGTLCLK/AGTSCLK count source clock frequency division
                                        *   ratio                                                                     */
            uint8_t           : 4;
            __IOM uint8_t LPM : 1;     /*!< [7..7] Low Power Mode                                                     */
        } AGTMR2_b;
    };

    union
    {
        __IOM uint8_t AGTIOSEL_ALT;    /*!< (@ 0x00000003) AGT Pin Select Register                                    */

        struct
        {
            __IOM uint8_t SEL  : 2;    /*!< [1..0] AGTIO pin select                                                   */
            uint8_t            : 2;
            __IOM uint8_t TIES : 1;    /*!< [4..4] AGTIO input enable                                                 */
            uint8_t            : 3;
        } AGTIOSEL_ALT_b;
    };

    union
    {
        __IOM uint8_t AGTIOC;          /*!< (@ 0x00000004) AGT I/O Control Register                                   */

        struct
        {
            __IOM uint8_t TEDGSEL : 1; /*!< [0..0] I/O polarity switchFunction varies depending on the operating
                                        *   mode.                                                                     */
            uint8_t             : 1;
            __IOM uint8_t TOE   : 1;   /*!< [2..2] AGTOn output enable                                                */
            uint8_t             : 1;
            __IOM uint8_t TIPF  : 2;   /*!< [5..4] Input filter                                                       */
            __IOM uint8_t TIOGT : 2;   /*!< [7..6] Count control                                                      */
        } AGTIOC_b;
    };

    union
    {
        __IOM uint8_t AGTISR;          /*!< (@ 0x00000005) AGT Event Pin Select Register                              */

        struct
        {
            uint8_t            : 2;
            __IOM uint8_t EEPS : 1;    /*!< [2..2] AGTEE polarty selection                                            */
            uint8_t            : 5;
        } AGTISR_b;
    };

    union
    {
        __IOM uint8_t AGTCMSR;         /*!< (@ 0x00000006) AGT Compare Match Function Select Register                 */

        struct
        {
            __IOM uint8_t TCMEA  : 1;  /*!< [0..0] Compare match A register enable                                    */
            __IOM uint8_t TOEA   : 1;  /*!< [1..1] AGTOA output enable                                                */
            __IOM uint8_t TOPOLA : 1;  /*!< [2..2] AGTOA polarity select                                              */
            uint8_t              : 1;
            __IOM uint8_t TCMEB  : 1;  /*!< [4..4] Compare match B register enable                                    */
            __IOM uint8_t TOEB   : 1;  /*!< [5..5] AGTOB output enable                                                */
            __IOM uint8_t TOPOLB : 1;  /*!< [6..6] AGTOB polarity select                                              */
            uint8_t              : 1;
        } AGTCMSR_b;
    };

    union
    {
        __IOM uint8_t AGTIOSEL;        /*!< (@ 0x00000007) AGT Pin Select Register                                    */

        struct
        {
            __IOM uint8_t SEL  : 2;    /*!< [1..0] AGTIO pin select                                                   */
            uint8_t            : 2;
            __IOM uint8_t TIES : 1;    /*!< [4..4] AGTIO input enable                                                 */
            uint8_t            : 3;
        } AGTIOSEL_b;
    };
} R_AGTX0_AGT16_CTRL_Type;             /*!< Size = 8 (0x8)                                                            */

/**
 * @brief R_AGTX0_AGT16 [AGT16] (AGT (16-bit) peripheral registers)
 */
typedef struct
{
    union
    {
        __IOM uint16_t AGT;            /*!< (@ 0x00000000) AGT Counter Register                                       */

        struct
        {
            __IOM uint16_t AGT : 16;   /*!< [15..0] 16bit counter and reload register. NOTE : When 1 is
                                        *   written to the TSTOP bit in the AGTCRn register, the 16-bit
                                        *   counter is forcibly stopped and set to FFFFH.                             */
        } AGT_b;
    };

    union
    {
        __IOM uint16_t AGTCMA;          /*!< (@ 0x00000002) AGT Compare Match A Register                               */

        struct
        {
            __IOM uint16_t AGTCMA : 16; /*!< [15..0] AGT Compare Match A data is stored.NOTE : When 1 is
                                         *   written to the TSTOP bit in the AGTCRn register, set to
                                         *   FFFFH                                                                     */
        } AGTCMA_b;
    };

    union
    {
        __IOM uint16_t AGTCMB;          /*!< (@ 0x00000004) AGT Compare Match B Register                               */

        struct
        {
            __IOM uint16_t AGTCMB : 16; /*!< [15..0] AGT Compare Match B data is stored.NOTE : When 1 is
                                         *   written to the TSTOP bit in the AGTCR register, set to
                                         *   FFFFH                                                                     */
        } AGTCMB_b;
    };
    __IM uint16_t                 RESERVED;
    __IOM R_AGTX0_AGT16_CTRL_Type CTRL; /*!< (@ 0x00000008) CTRL                                                       */
} R_AGTX0_AGT16_Type;                   /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_AGTX0_AGT32 [AGT32] (AGTW (32-bit) peripheral registers)
 */
typedef struct
{
    union
    {
        __IOM uint32_t AGT;            /*!< (@ 0x00000000) AGT 32-bit Counter Register                                */

        struct
        {
            __IOM uint32_t AGT : 32;   /*!< [31..0] 32bit counter and reload register. NOTE : When 1 is
                                        *   written to the TSTOP bit in the AGTCRn register, the 16-bit
                                        *   counter is forcibly stopped and set to FFFFH.                             */
        } AGT_b;
    };

    union
    {
        __IOM uint32_t AGTCMA;          /*!< (@ 0x00000004) AGT Compare Match A Register                               */

        struct
        {
            __IOM uint32_t AGTCMA : 32; /*!< [31..0] AGT Compare Match A data is stored.NOTE : When 1 is
                                         *   written to the TSTOP bit in the AGTCRn register, set to
                                         *   FFFFH                                                                     */
        } AGTCMA_b;
    };

    union
    {
        __IOM uint32_t AGTCMB;          /*!< (@ 0x00000008) AGT Compare Match B Register                               */

        struct
        {
            __IOM uint32_t AGTCMB : 32; /*!< [31..0] AGT Compare Match B data is stored.NOTE : When 1 is
                                         *   written to the TSTOP bit in the AGTCR register, set to
                                         *   FFFFH                                                                     */
        } AGTCMB_b;
    };
    __IOM R_AGTX0_AGT16_CTRL_Type CTRL; /*!< (@ 0x0000000C) CTRL                                                       */
} R_AGTX0_AGT32_Type;                   /*!< Size = 20 (0x14)                                                          */

/** @} */ /* End of group Device_Peripheral_clusters */

/* =========================================================================================================================== */
/* ================                            Device Specific Peripheral Section                             ================ */
/* =========================================================================================================================== */

/** @addtogroup Device_Peripheral_peripherals
 * @{
 */

/* =========================================================================================================================== */
/* ================                                         R_ACMPHS0                                         ================ */
/* =========================================================================================================================== */

/**
 * @brief High-Speed Analog Comparator (R_ACMPHS0)
 */

typedef struct                         /*!< (@ 0x400F4000) R_ACMPHS0 Structure                                        */
{
    union
    {
        __IOM uint8_t CMPCTL;          /*!< (@ 0x00000000) Comparator Control Register                                */

        struct
        {
            __IOM uint8_t CINV   : 1;  /*!< [0..0] Comparator output polarity selection                               */
            __IOM uint8_t COE    : 1;  /*!< [1..1] Comparator output enable                                           */
            __IOM uint8_t CSTEN  : 1;  /*!< [2..2] Interrupt Select                                                   */
            __IOM uint8_t CEG    : 2;  /*!< [4..3] Selection of valid edge (Edge selector)                            */
            __IOM uint8_t CDFS   : 2;  /*!< [6..5] Noise filter selection                                             */
            __IOM uint8_t HCMPON : 1;  /*!< [7..7] Comparator operation control                                       */
        } CMPCTL_b;
    };
    __IM uint8_t RESERVED[3];

    union
    {
        __IOM uint8_t CMPSEL0;         /*!< (@ 0x00000004) Comparator Input Select Register                           */

        struct
        {
            __IOM uint8_t CMPSEL : 4;  /*!< [3..0] Comparator Input Selection                                         */
            uint8_t              : 4;
        } CMPSEL0_b;
    };
    __IM uint8_t RESERVED1[3];

    union
    {
        __IOM uint8_t CMPSEL1;         /*!< (@ 0x00000008) Comparator Reference Voltage Select Register               */

        struct
        {
            __IOM uint8_t CRVS : 6;    /*!< [5..0] Reference Voltage Selection                                        */
            uint8_t            : 2;
        } CMPSEL1_b;
    };
    __IM uint8_t RESERVED2[3];

    union
    {
        __IM uint8_t CMPMON;           /*!< (@ 0x0000000C) Comparator Output Monitor Register                         */

        struct
        {
            __IM uint8_t CMPMON : 1;   /*!< [0..0] Comparator output monitor                                          */
            uint8_t             : 7;
        } CMPMON_b;
    };
    __IM uint8_t RESERVED3[3];

    union
    {
        __IOM uint8_t CPIOC;           /*!< (@ 0x00000010) Comparator Output Control Register                         */

        struct
        {
            __IOM uint8_t CPOE   : 1;  /*!< [0..0] Comparator output selection                                        */
            uint8_t              : 6;
            __IOM uint8_t VREFEN : 1;  /*!< [7..7] Internal Vref enable                                               */
        } CPIOC_b;
    };
} R_ACMPHS0_Type;                      /*!< Size = 17 (0x11)                                                          */

/* =========================================================================================================================== */
/* ================                                          R_ADC0                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief A/D Converter (R_ADC0)
 */

typedef struct                         /*!< (@ 0x40170000) R_ADC0 Structure                                           */
{
    union
    {
        __IOM uint16_t ADCSR;          /*!< (@ 0x00000000) A/D Control Register                                       */

        struct
        {
            __IOM uint16_t DBLANS : 5; /*!< [4..0] Double Trigger Channel SelectThese bits select one analog
                                        *   input channel for double triggered operation. The setting
                                        *   is only effective while double trigger mode is selected.                  */
            uint16_t              : 1;
            __IOM uint16_t GBADIE : 1; /*!< [6..6] Group B Scan End Interrupt Enable                                  */
            __IOM uint16_t DBLE   : 1; /*!< [7..7] Double Trigger Mode Select                                         */
            __IOM uint16_t EXTRG  : 1; /*!< [8..8] Trigger Select                                                     */
            __IOM uint16_t TRGE   : 1; /*!< [9..9] Trigger Start Enable                                               */
            __IOM uint16_t ADHSC  : 1; /*!< [10..10] A/D Conversion Operation Mode Select                             */
            uint16_t              : 1;
            __IOM uint16_t ADIE   : 1; /*!< [12..12] Scan End Interrupt Enable                                        */
            __IOM uint16_t ADCS   : 2; /*!< [14..13] Scan Mode Select                                                 */
            __IOM uint16_t ADST   : 1; /*!< [15..15] A/D Conversion Start                                             */
        } ADCSR_b;
    };

    union
    {
        __IOM uint8_t ADREF;           /*!< (@ 0x00000002) A/D status register                                        */

        struct
        {
            __IOM uint8_t ADF : 1;     /*!< [0..0] Scanning end flag bitThis bit is a status bit that becomes
                                        *   '1' while scanning.                                                       */
            uint8_t              : 6;
            __IM uint8_t ADSCACT : 1;  /*!< [7..7] Scanning status bit                                                */
        } ADREF_b;
    };

    union
    {
        __IOM uint8_t ADEXREF;         /*!< (@ 0x00000003) A/D enhancing status register                              */

        struct
        {
            __IOM uint8_t GBADF : 1;   /*!< [0..0] Group B scanning end flag bit.                                     */
            uint8_t             : 7;
        } ADEXREF_b;
    };

    union
    {
        __IOM uint16_t ADANSA[2];      /*!< (@ 0x00000004) A/D Channel Select Register                                */

        struct
        {
            __IOM uint16_t ANSA0  : 1; /*!< [0..0] AN Input Select                                                    */
            __IOM uint16_t ANSA1  : 1; /*!< [1..1] AN Input Select                                                    */
            __IOM uint16_t ANSA2  : 1; /*!< [2..2] AN Input Select                                                    */
            __IOM uint16_t ANSA3  : 1; /*!< [3..3] AN Input Select                                                    */
            __IOM uint16_t ANSA4  : 1; /*!< [4..4] AN Input Select                                                    */
            __IOM uint16_t ANSA5  : 1; /*!< [5..5] AN Input Select                                                    */
            __IOM uint16_t ANSA6  : 1; /*!< [6..6] AN Input Select                                                    */
            __IOM uint16_t ANSA7  : 1; /*!< [7..7] AN Input Select                                                    */
            __IOM uint16_t ANSA8  : 1; /*!< [8..8] AN Input Select                                                    */
            __IOM uint16_t ANSA9  : 1; /*!< [9..9] AN Input Select                                                    */
            __IOM uint16_t ANSA10 : 1; /*!< [10..10] AN Input Select                                                  */
            __IOM uint16_t ANSA11 : 1; /*!< [11..11] AN Input Select                                                  */
            __IOM uint16_t ANSA12 : 1; /*!< [12..12] AN Input Select                                                  */
            __IOM uint16_t ANSA13 : 1; /*!< [13..13] AN Input Select                                                  */
            __IOM uint16_t ANSA14 : 1; /*!< [14..14] AN Input Select                                                  */
            __IOM uint16_t ANSA15 : 1; /*!< [15..15] AN Input Select                                                  */
        } ADANSA_b[2];
    };

    union
    {
        __IOM uint16_t ADADS[2];       /*!< (@ 0x00000008) A/D-Converted Value Addition/Average Channel
                                        *                  Select Register                                            */

        struct
        {
            __IOM uint16_t ADS0  : 1;  /*!< [0..0] A/D-Converted Value Addition/Average Channel Select                */
            __IOM uint16_t ADS1  : 1;  /*!< [1..1] A/D-Converted Value Addition/Average Channel Select                */
            __IOM uint16_t ADS2  : 1;  /*!< [2..2] A/D-Converted Value Addition/Average Channel Select                */
            __IOM uint16_t ADS3  : 1;  /*!< [3..3] A/D-Converted Value Addition/Average Channel Select                */
            __IOM uint16_t ADS4  : 1;  /*!< [4..4] A/D-Converted Value Addition/Average Channel Select                */
            __IOM uint16_t ADS5  : 1;  /*!< [5..5] A/D-Converted Value Addition/Average Channel Select                */
            __IOM uint16_t ADS6  : 1;  /*!< [6..6] A/D-Converted Value Addition/Average Channel Select                */
            __IOM uint16_t ADS7  : 1;  /*!< [7..7] A/D-Converted Value Addition/Average Channel Select                */
            __IOM uint16_t ADS8  : 1;  /*!< [8..8] A/D-Converted Value Addition/Average Channel Select                */
            __IOM uint16_t ADS9  : 1;  /*!< [9..9] A/D-Converted Value Addition/Average Channel Select                */
            __IOM uint16_t ADS10 : 1;  /*!< [10..10] A/D-Converted Value Addition/Average Channel Select              */
            __IOM uint16_t ADS11 : 1;  /*!< [11..11] A/D-Converted Value Addition/Average Channel Select              */
            __IOM uint16_t ADS12 : 1;  /*!< [12..12] A/D-Converted Value Addition/Average Channel Select              */
            __IOM uint16_t ADS13 : 1;  /*!< [13..13] A/D-Converted Value Addition/Average Channel Select              */
            __IOM uint16_t ADS14 : 1;  /*!< [14..14] A/D-Converted Value Addition/Average Channel Select              */
            __IOM uint16_t ADS15 : 1;  /*!< [15..15] A/D-Converted Value Addition/Average Channel Select              */
        } ADADS_b[2];
    };

    union
    {
        __IOM uint8_t ADADC;           /*!< (@ 0x0000000C) A/D-Converted Value Addition/Average Count Select
                                        *                  Register                                                   */

        struct
        {
            __IOM uint8_t ADC : 3;     /*!< [2..0] Addition frequency selection bit.NOTE: AVEE bit is valid
                                        *   at the only setting of ADC[2:0] bits = 001b or 011b. When
                                        *   average mode is selected by setting the ADADC.AVEE bit
                                        *   to 1, do not set the addition count to three times (ADADC.ADC[2:0]
                                        *   = 010b)                                                                   */
            uint8_t            : 4;
            __IOM uint8_t AVEE : 1;    /*!< [7..7] Average Mode Enable. NOTE:When average mode is deselected
                                        *   by setting the ADADC.AVEE bit to 0, set the addition count
                                        *   to 1, 2, 3, 4 or 16-time conversion. 16-time conversion
                                        *   can only be used with 12-bit accuracy selected. NOTE: AVEE
                                        *   bit is valid at the only setting of ADC[2:0] bits = 001b
                                        *   or 011b. When average mode is selected by setting the ADADC.AVEE
                                        *   bit to 1, do not set the addition count to three times
                                        *   (ADADC.ADC[2:0] = 010b)                                                   */
        } ADADC_b;
    };
    __IM uint8_t RESERVED;

    union
    {
        __IOM uint16_t ADCER;          /*!< (@ 0x0000000E) A/D Control Extended Register                              */

        struct
        {
            uint16_t               : 1;
            __IOM uint16_t ADPRC   : 2; /*!< [2..1] A/D Conversion Accuracy Specify                                    */
            uint16_t               : 1;
            __IOM uint16_t DCE     : 1; /*!< [4..4] Discharge Enable                                                   */
            __IOM uint16_t ACE     : 1; /*!< [5..5] A/D Data Register Automatic Clearing Enable                        */
            uint16_t               : 2;
            __IOM uint16_t DIAGVAL : 2; /*!< [9..8] Self-Diagnosis Conversion Voltage Select                           */
            __IOM uint16_t DIAGLD  : 1; /*!< [10..10] Self-Diagnosis Mode Select                                       */
            __IOM uint16_t DIAGM   : 1; /*!< [11..11] Self-Diagnosis Enable                                            */
            uint16_t               : 2;
            __IOM uint16_t ADINV   : 1; /*!< [14..14] Single-Ended Input A/D Converted Data Inversion Select           */
            __IOM uint16_t ADRFMT  : 1; /*!< [15..15] A/D Data Register Format Select                                  */
        } ADCER_b;
    };

    union
    {
        __IOM uint16_t ADSTRGR;        /*!< (@ 0x00000010) A/D Conversion Start Trigger Select Register               */

        struct
        {
            __IOM uint16_t TRSB : 6;   /*!< [5..0] A/D Conversion Start Trigger Select for Group BSelect
                                        *   the A/D conversion start trigger for group B in group scan
                                        *   mode.                                                                     */
            uint16_t            : 2;
            __IOM uint16_t TRSA : 6;   /*!< [13..8] A/D Conversion Start Trigger SelectSelect the A/D conversion
                                        *   start trigger in single scan mode and continuous mode.
                                        *   In group scan mode, the A/D conversion start trigger for
                                        *   group A is selected.                                                      */
            uint16_t : 2;
        } ADSTRGR_b;
    };

    union
    {
        __IOM uint16_t ADEXICR;        /*!< (@ 0x00000012) A/D Conversion Extended Input Control Register             */

        struct
        {
            __IOM uint16_t TSSAD : 1;  /*!< [0..0] Temperature Sensor Output A/D converted Value Addition/Average
                                        *   Mode Select                                                               */
            __IOM uint16_t OCSAD : 1;  /*!< [1..1] Internal Reference Voltage A/D converted Value Addition/Average
                                        *   Mode Select                                                               */
            uint16_t            : 6;
            __IOM uint16_t TSSA : 1;   /*!< [8..8] Temperature Sensor Output A/D Conversion Select                    */
            __IOM uint16_t OCSA : 1;   /*!< [9..9] Internal Reference Voltage A/D Conversion Select                   */
            __IOM uint16_t TSSB : 1;   /*!< [10..10] Temperature Sensor Output A/D Conversion Select for
                                        *   Group B in group scan mode.                                               */
            __IOM uint16_t OCSB : 1;   /*!< [11..11] Internal Reference Voltage A/D Conversion Select for
                                        *   Group B in group scan mode.                                               */
            uint16_t             : 2;
            __IOM uint16_t EXSEL : 1;  /*!< [14..14] Extended Analog Input Select                                     */
            __IOM uint16_t EXOEN : 1;  /*!< [15..15] Extended Analog Output Control                                   */
        } ADEXICR_b;
    };

    union
    {
        __IOM uint16_t ADANSB[2];      /*!< (@ 0x00000014) A/D Channel Select Register B                              */

        struct
        {
            __IOM uint16_t ANSB0  : 1; /*!< [0..0] AN Input Select                                                    */
            __IOM uint16_t ANSB1  : 1; /*!< [1..1] AN Input Select                                                    */
            __IOM uint16_t ANSB2  : 1; /*!< [2..2] AN Input Select                                                    */
            __IOM uint16_t ANSB3  : 1; /*!< [3..3] AN Input Select                                                    */
            __IOM uint16_t ANSB4  : 1; /*!< [4..4] AN Input Select                                                    */
            __IOM uint16_t ANSB5  : 1; /*!< [5..5] AN Input Select                                                    */
            __IOM uint16_t ANSB6  : 1; /*!< [6..6] AN Input Select                                                    */
            __IOM uint16_t ANSB7  : 1; /*!< [7..7] AN Input Select                                                    */
            __IOM uint16_t ANSB8  : 1; /*!< [8..8] AN Input Select                                                    */
            __IOM uint16_t ANSB9  : 1; /*!< [9..9] AN Input Select                                                    */
            __IOM uint16_t ANSB10 : 1; /*!< [10..10] AN Input Select                                                  */
            __IOM uint16_t ANSB11 : 1; /*!< [11..11] AN Input Select                                                  */
            __IOM uint16_t ANSB12 : 1; /*!< [12..12] AN Input Select                                                  */
            __IOM uint16_t ANSB13 : 1; /*!< [13..13] AN Input Select                                                  */
            __IOM uint16_t ANSB14 : 1; /*!< [14..14] AN Input Select                                                  */
            __IOM uint16_t ANSB15 : 1; /*!< [15..15] AN Input Select                                                  */
        } ADANSB_b[2];
    };

    union
    {
        __IM uint16_t ADDBLDR;          /*!< (@ 0x00000018) A/D Data Duplication Register                              */

        struct
        {
            __IM uint16_t ADDBLDR : 16; /*!< [15..0] This is a 16-bit read-only register for storing the
                                         *   result of A/D conversion in response to the second trigger
                                         *   in double trigger mode.                                                   */
        } ADDBLDR_b;
    };

    union
    {
        __IM uint16_t ADTSDR;          /*!< (@ 0x0000001A) A/D Temperature Sensor Data Register                       */

        struct
        {
            __IM uint16_t ADTSDR : 16; /*!< [15..0] This is a 16-bit read-only register for storing the
                                        *   A/D conversion result of temperature sensor output.                       */
        } ADTSDR_b;
    };

    union
    {
        __IM uint16_t ADOCDR;          /*!< (@ 0x0000001C) A/D Internal Reference Voltage Data Register               */

        struct
        {
            __IM uint16_t ADOCDR : 16; /*!< [15..0] This is a 16-bit read-only register for storing the
                                        *   A/D result of internal reference voltage.                                 */
        } ADOCDR_b;
    };

    union
    {
        union
        {
            __IM uint16_t ADRD_RIGHT;     /*!< (@ 0x0000001E) A/D Self-Diagnosis Data Register Right Justified           */

            struct
            {
                __IM uint16_t AD : 14;    /*!< [13..0] A/D-converted value (right-justified)The format for
                                           *   data determine ADCER.ADRFMT and ADCER.ADPRC.                              */
                __IM uint16_t DIAGST : 2; /*!< [15..14] Self-Diagnosis Status                                            */
            } ADRD_RIGHT_b;
        };

        union
        {
            __IM uint16_t ADRD_LEFT;       /*!< (@ 0x0000001E) A/D Self-Diagnosis Data Register Left Justified            */

            struct
            {
                __IM uint16_t DIAGST : 2;  /*!< [1..0] Self-Diagnosis Status                                              */
                __IM uint16_t AD     : 14; /*!< [15..2] A/D-converted value (right-justified)The format for
                                            *   data determine ADCER.ADRFMT and ADCER.ADPRC.                              */
            } ADRD_LEFT_b;
        };
    };

    union
    {
        __IM uint16_t ADDR[29];        /*!< (@ 0x00000020) A/D Data Register                                          */

        struct
        {
            __IM uint16_t ADDR : 16;   /*!< [15..0] The ADDR register is a 16-bit read-only registers for
                                        *   storing the result of A/D conversion.                                     */
        } ADDR_b[29];
    };
    __IM uint16_t RESERVED1;
    __IM uint32_t RESERVED2;
    __IM uint16_t RESERVED3;

    union
    {
        __IOM uint8_t ADAMPOFF;        /*!< (@ 0x00000062) A/D RRAMP off state register                               */

        struct
        {
            __IOM uint8_t OPOFF : 8;   /*!< [7..0] OPOFF                                                              */
        } ADAMPOFF_b;
    };

    union
    {
        __IOM uint8_t ADTSTPR;         /*!< (@ 0x00000063) A/D Test Protecting Release Register                       */

        struct
        {
            __IOM uint8_t PRO  : 1;    /*!< [0..0] Test register protecting bit.                                      */
            __IOM uint8_t B0WI : 1;    /*!< [1..1] Bit 0 writing permission bit.                                      */
            uint8_t            : 6;
        } ADTSTPR_b;
    };

    union
    {
        __IOM uint16_t ADDDACER;       /*!< (@ 0x00000064) A/D RRAMP Discharge Period Register                        */

        struct
        {
            __IOM uint16_t WRION  : 5; /*!< [4..0] WRION                                                              */
            uint16_t              : 3;
            __IOM uint16_t WRIOFF : 5; /*!< [12..8] WRIOFF                                                            */
            uint16_t              : 2;
            __IOM uint16_t ADHS   : 1; /*!< [15..15] ADHS                                                             */
        } ADDDACER_b;
    };

    union
    {
        __IOM uint16_t ADSHCR;         /*!< (@ 0x00000066) A/D Sample and Hold Circuit Control Register               */

        struct
        {
            __IOM uint16_t SSTSH : 8;  /*!< [7..0] Channel-Dedicated Sample-and-Hold Circuit Sampling Time
                                        *   Setting Set the sampling time (4 to 255 states)                           */
            __IOM uint16_t SHANS0 : 1; /*!< [8..8] AN000 sample-and-hold circuit Select                               */
            __IOM uint16_t SHANS1 : 1; /*!< [9..9] AN001 sample-and-hold circuit Select                               */
            __IOM uint16_t SHANS2 : 1; /*!< [10..10] AN002 sample-and-hold circuit Select                             */
            uint16_t              : 5;
        } ADSHCR_b;
    };

    union
    {
        __IOM uint16_t ADEXTSTR;       /*!< (@ 0x00000068) A/D Enhancing Test Register                                */

        struct
        {
            __IOM uint16_t SHTEST : 3; /*!< [2..0] Test mode bit for S&H circuit.Test mode bit of S&H circuit
                                        *   only for channel.                                                         */
            uint16_t             : 1;
            __IOM uint16_t SWTST : 2;  /*!< [5..4] Test selection bit for pressure switch.                            */
            uint16_t             : 2;
            __IOM uint16_t SHTRM : 2;  /*!< [9..8] Current adjustment trim bit for S&H circuit.Trim bit
                                        *   for adjustment to hardening of process.                                   */
            uint16_t              : 1;
            __IOM uint16_t ADTRM3 : 1; /*!< [11..11] Trim bit 3 for A/D hard macro.3bit Flash comparator
                                        *   power save bit for A/D hard macro to hardening of process.                */
            __IOM uint16_t ADTRM2 : 2; /*!< [13..12] Trim bit 2 for A/D hard macro.Bias adjustment trim
                                        *   bit for A/D hard macro to hardening of process.                           */
            __IOM uint16_t ADTRM1 : 2; /*!< [15..14] Trim bit 1 for A/D hard macro.Timing adjustment trim
                                        *   bit for A/D hard macro to hardening of process.                           */
        } ADEXTSTR_b;
    };

    union
    {
        __IOM uint16_t ADTSTRA;           /*!< (@ 0x0000006A) A/D Test Register A                                        */

        struct
        {
            __IOM uint16_t ATBUSSEL : 1;  /*!< [0..0] Analog test bus selection bit.                                     */
            __IOM uint16_t TSTSWREF : 3;  /*!< [3..1] Pressure switch refreshing setting bit for S&H circuit
                                           *   amplifier test.Refreshing the pressure switch that opens
                                           *   for the DAC output voltage charge period when the amplifier
                                           *   of the S&H circuit is tested only for the channel is set.                 */
            uint16_t            : 1;
            __IOM uint16_t OCSW : 1;      /*!< [5..5] Internal reference voltage analog switch test control
                                           *   bit.                                                                      */
            __IOM uint16_t TSSW : 1;      /*!< [6..6] Temperature sensor output analogue switch test control
                                           *   bit                                                                       */
            uint16_t                 : 1;
            __IOM uint16_t ADTEST_AD : 4; /*!< [11..8] Test bit for A/D analog module Bit for test of A/D analog
                                           *   module Details are described to the bit explanation.                      */
            __IOM uint16_t ADTEST_IO : 4; /*!< [15..12] Test bit for analog I/ODetails are described to the
                                           *   bit explanation.                                                          */
        } ADTSTRA_b;
    };

    union
    {
        __IOM uint16_t ADTSTRB;        /*!< (@ 0x0000006C) A/D Test Register B                                        */

        struct
        {
            __IOM uint16_t ADVAL : 15; /*!< [14..0] Signal input bit bit14-0 for A/D analog module test.It
                                        *   corresponds to ADVAL 14:0 input of A/D analog module.                     */
            uint16_t : 1;
        } ADTSTRB_b;
    };

    union
    {
        __IOM uint16_t ADTSTRC;         /*!< (@ 0x0000006E) A/D Test Register C                                        */

        struct
        {
            __IOM uint16_t ADMD : 8;    /*!< [7..0] Bit for A/D analog module test.ADMODE 6:0 input of A/D
                                         *   analog module.                                                            */
            uint16_t               : 4;
            __IOM uint16_t SYNCERR : 1; /*!< [12..12] Synchronous analog to digital conversion error bit.              */
            uint16_t               : 3;
        } ADTSTRC_b;
    };

    union
    {
        __IOM uint16_t ADTSTRD;         /*!< (@ 0x00000070) A/D Test Register D                                        */

        struct
        {
            __IOM uint16_t ADVAL16 : 1; /*!< [0..0] Signal input bit bit16 for A/D analog module test.It
                                         *   corresponds to ADVAL 16 input of A/D analog module.                       */
            uint16_t : 15;
        } ADTSTRD_b;
    };

    union
    {
        __IOM uint16_t ADSWTSTR0;      /*!< (@ 0x00000072) A/D Channel Switch Test Control Register 0                 */

        struct
        {
            __IOM uint16_t CHSW00 : 1; /*!< [0..0] Channel switch test control bit.                                   */
            __IOM uint16_t CHSW01 : 1; /*!< [1..1] Channel switch test control bit.                                   */
            __IOM uint16_t CHSW02 : 1; /*!< [2..2] Channel switch test control bit.                                   */
            __IOM uint16_t CHSW03 : 1; /*!< [3..3] Channel switch test control bit.                                   */
            __IOM uint16_t CHSW04 : 1; /*!< [4..4] Channel switch test control bit.                                   */
            __IOM uint16_t CHSW05 : 1; /*!< [5..5] Channel switch test control bit.                                   */
            uint16_t              : 10;
        } ADSWTSTR0_b;
    };

    union
    {
        __IOM uint16_t ADSWTSTR1;      /*!< (@ 0x00000074) A/D Channel Switch Test Control Register 1                 */

        struct
        {
            __IOM uint16_t CHSW16 : 1; /*!< [0..0] Channel switch test control bit.                                   */
            __IOM uint16_t CHSW17 : 1; /*!< [1..1] Channel switch test control bit.                                   */
            __IOM uint16_t CHSW18 : 1; /*!< [2..2] Channel switch test control bit.                                   */
            __IOM uint16_t CHSW19 : 1; /*!< [3..3] Channel switch test control bit.                                   */
            __IOM uint16_t CHSW20 : 1; /*!< [4..4] Channel switch test control bit.                                   */
            __IOM uint16_t CHSW21 : 1; /*!< [5..5] Channel switch test control bit.                                   */
            uint16_t              : 10;
        } ADSWTSTR1_b;
    };

    union
    {
        __IOM uint16_t ADSWTSTR2;        /*!< (@ 0x00000076) A/D Channel Switch Test Control Register 2                 */

        struct
        {
            __IOM uint16_t EX0SW : 1;    /*!< [0..0] Test control of 0 enhancing input channel switches bit
                                          *   (ANEX0 switch)                                                            */
            __IOM uint16_t EX1SW : 1;    /*!< [1..1] Test control of one enhancing input channel switch bit
                                          *   (ANEX1 switch).                                                           */
            uint16_t                : 2;
            __IOM uint16_t SHBYPS0  : 1; /*!< [4..4] S&H circuit by-pass switch control bit 0.                          */
            __IOM uint16_t SHBYPS1  : 1; /*!< [5..5] S&H circuit by-pass switch control bit 1.                          */
            __IOM uint16_t SHBYPS2  : 1; /*!< [6..6] S&H circuit by-pass switch control bit 2.                          */
            uint16_t                : 1;
            __IOM uint16_t GRP0SW   : 1; /*!< [8..8] Test control of 0 group switches bit.                              */
            __IOM uint16_t GRP1SW   : 1; /*!< [9..9] Test control of one group switch bit.                              */
            __IOM uint16_t GRP2SW   : 1; /*!< [10..10] Test control of two group switches bit                           */
            __IOM uint16_t GRP3SW   : 1; /*!< [11..11] Test control of two group switches bit                           */
            __IOM uint16_t GRPEX1SW : 1; /*!< [12..12] Switch test control bit of enhancing analog ANEX1                */
            uint16_t                : 3;
        } ADSWTSTR2_b;
    };
    __IM uint16_t RESERVED4;

    union
    {
        __IOM uint8_t ADDISCR;         /*!< (@ 0x0000007A) A/D Disconnection Detection Control Register               */

        struct
        {
            __IOM uint8_t ADNDIS : 4;  /*!< [3..0] The charging time                                                  */
            __IOM uint8_t CHARGE : 1;  /*!< [4..4] Selection of Precharge or Discharge                                */
            uint8_t              : 3;
        } ADDISCR_b;
    };

    union
    {
        __IOM uint8_t ADSWCR;          /*!< (@ 0x0000007B) A/D Pressure Switch Control Register                       */

        struct
        {
            __IOM uint8_t ADSWREF : 3; /*!< [2..0] These bits are read as 0. The write value should be 0.Refreshing
                                        *   the pressure switch in A/D analog module is set.                          */
            uint8_t               : 1;
            __IOM uint8_t SHSWREF : 3; /*!< [6..4] S&H Boost Switch Refresh Interval Setting                          */
            uint8_t               : 1;
        } ADSWCR_b;
    };

    union
    {
        __IOM uint8_t ADSHMSR;         /*!< (@ 0x0000007C) A/D Sample and Hold Operation Mode Select Register         */

        struct
        {
            __IOM uint8_t SHMD : 1;    /*!< [0..0] Channel-Dedicated Sample-and-Hold Circuit Operation Mode
                                        *   Select                                                                    */
            uint8_t : 7;
        } ADSHMSR_b;
    };

    union
    {
        __IOM uint8_t ADICR;           /*!< (@ 0x0000007D) A/D Interrupt Control Register                             */

        struct
        {
            __IOM uint8_t ADIC : 2;    /*!< [1..0] A/D Interrupt Control                                              */
            uint8_t            : 6;
        } ADICR_b;
    };

    union
    {
        __IOM uint8_t ADACSR;          /*!< (@ 0x0000007E) A/D Conversion Operation Mode Select Register              */

        struct
        {
            uint8_t             : 1;
            __IOM uint8_t ADSAC : 1;   /*!< [1..1] Successive Approximation Control Setting                           */
            uint8_t             : 6;
        } ADACSR_b;
    };
    __IM uint8_t RESERVED5;

    union
    {
        __IOM uint16_t ADGSPCR;         /*!< (@ 0x00000080) A/D Group Scan Priority Control Register                   */

        struct
        {
            __IOM uint16_t PGS : 1;     /*!< [0..0] Group A priority control setting bit.Note: When the PGS
                                         *   bit is to be set to 1, the ADCSR.ADCS[1:0] bits must be
                                         *   set to 01b (group scan mode). If the bits are set to any
                                         *   other values, proper operation is not guaranteed.                         */
            __IOM uint16_t GBRSCN : 1;  /*!< [1..1] Group B Restart Setting(Enabled only when PGS = 1. Reserved
                                         *   when PGS = 0.)                                                            */
            uint16_t               : 6;
            __IOM uint16_t GBEXTRG : 1; /*!< [8..8] External trigger selection bit for group B.                        */
            uint16_t               : 6;
            __IOM uint16_t GBRP    : 1; /*!< [15..15] Group B Single Scan Continuous Start(Enabled only when
                                         *   PGS = 1. Reserved when PGS = 0.)Note: When the GBRP bit
                                         *   has been set to 1, single scan is performed continuously
                                         *   for group B regardless of the setting of the GBRSCN bit.                  */
        } ADGSPCR_b;
    };

    union
    {
        __IM uint16_t ADGSCS;          /*!< (@ 0x00000082) A/D Conversion Channel Status Register (for Group
                                        *                  Scan)                                                      */

        struct
        {
            __IM uint16_t CHSELGB : 8; /*!< [7..0] Channel status of Group B scan                                     */
            __IM uint16_t CHSELGA : 8; /*!< [15..8] Channel status of Group A scan                                    */
        } ADGSCS_b;
    };

    union
    {
        __IM uint16_t ADDBLDRA;          /*!< (@ 0x00000084) A/D Data Duplexing Register A                              */

        struct
        {
            __IM uint16_t ADDBLDRA : 16; /*!< [15..0] This register is a 16-bit read-only registers for storing
                                          *   the result of A/D conversion in response to the respective
                                          *   triggers during extended operation in double trigger mode.                */
        } ADDBLDRA_b;
    };

    union
    {
        __IM uint16_t ADDBLDRB;          /*!< (@ 0x00000086) A/D Data Duplexing Register B                              */

        struct
        {
            __IM uint16_t ADDBLDRB : 16; /*!< [15..0] This register is a 16-bit read-only registers for storing
                                          *   the result of A/D conversion in response to the respective
                                          *   triggers during extended operation in double trigger mode.                */
        } ADDBLDRB_b;
    };

    union
    {
        __IOM uint8_t ADSER;           /*!< (@ 0x00000088) A/D Sampling Extension Register                            */

        struct
        {
            uint8_t             : 7;
            __IOM uint8_t SMPEX : 1;   /*!< [7..7] Sampling extension control                                         */
        } ADSER_b;
    };
    __IM uint8_t RESERVED6;

    union
    {
        __IOM uint8_t ADHVREFCNT;      /*!< (@ 0x0000008A) A/D High-Potential/Low-Potential Reference Voltage
                                        *                  Control Register                                           */

        struct
        {
            __IOM uint8_t HVSEL : 2;   /*!< [1..0] High-Potential Reference Voltage Select                            */
            uint8_t             : 2;
            __IOM uint8_t LVSEL : 1;   /*!< [4..4] Low-Potential Reference Voltage Select                             */
            uint8_t             : 2;
            __IOM uint8_t ADSLP : 1;   /*!< [7..7] Sleep                                                              */
        } ADHVREFCNT_b;
    };
    __IM uint8_t RESERVED7;

    union
    {
        __IM uint8_t ADWINMON;         /*!< (@ 0x0000008C) A/D Compare Function Window A/B Status Monitor
                                        *                  Register                                                   */

        struct
        {
            __IM uint8_t MONCOMB : 1;  /*!< [0..0] Combination result monitorThis bit indicates the combination
                                        *   result.This bit is valid when both window A operation and
                                        *   window B operation are enabled.                                           */
            uint8_t              : 3;
            __IM uint8_t MONCMPA : 1;  /*!< [4..4] Comparison Result Monitor A                                        */
            __IM uint8_t MONCMPB : 1;  /*!< [5..5] Comparison Result Monitor B                                        */
            uint8_t              : 2;
        } ADWINMON_b;
    };
    __IM uint8_t  RESERVED8;
    __IM uint16_t RESERVED9;

    union
    {
        __IOM uint16_t ADCMPCR;        /*!< (@ 0x00000090) A/D Compare Function Control Register                      */

        struct
        {
            __IOM uint16_t CMPAB : 2;  /*!< [1..0] Window A/B Composite Conditions SettingNOTE: These bits
                                        *   are valid when both window A and window B are enabled (CMPAE
                                        *   = 1 and CMPBE = 1).                                                       */
            uint16_t              : 7;
            __IOM uint16_t CMPBE  : 1; /*!< [9..9] Compare Window B Operation Enable                                  */
            uint16_t              : 1;
            __IOM uint16_t CMPAE  : 1; /*!< [11..11] Compare Window A Operation Enable                                */
            uint16_t              : 1;
            __IOM uint16_t CMPBIE : 1; /*!< [13..13] Compare B Interrupt Enable                                       */
            __IOM uint16_t WCMPE  : 1; /*!< [14..14] Window Function Setting                                          */
            __IOM uint16_t CMPAIE : 1; /*!< [15..15] Compare A Interrupt Enable                                       */
        } ADCMPCR_b;
    };

    union
    {
        __IOM uint8_t ADCMPANSER;      /*!< (@ 0x00000092) A/D Compare Function Window A Extended Input
                                        *                  Select Register                                            */

        struct
        {
            __IOM uint8_t CMPTSA : 1;  /*!< [0..0] Temperature sensor output Compare selection bit.                   */
            __IOM uint8_t CMPOCA : 1;  /*!< [1..1] Internal reference voltage Compare selection bit.                  */
            uint8_t              : 6;
        } ADCMPANSER_b;
    };

    union
    {
        __IOM uint8_t ADCMPLER;        /*!< (@ 0x00000093) A/D Compare Function Window A Extended Input
                                        *                  Comparison Condition Setting Register                      */

        struct
        {
            __IOM uint8_t CMPLTSA : 1; /*!< [0..0] Compare Window A Temperature Sensor Output Comparison
                                        *   Condition Select                                                          */
            __IOM uint8_t CMPLOCA : 1; /*!< [1..1] Compare Window A Internal Reference Voltage ComparisonCondition
                                        *   Select                                                                    */
            uint8_t : 6;
        } ADCMPLER_b;
    };

    union
    {
        __IOM uint16_t ADCMPANSR[2];     /*!< (@ 0x00000094) A/D Compare Function Window A Channel Select
                                          *                  Register                                                   */

        struct
        {
            __IOM uint16_t CMPCHA0  : 1; /*!< [0..0] AN Input Select                                                    */
            __IOM uint16_t CMPCHA1  : 1; /*!< [1..1] AN Input Select                                                    */
            __IOM uint16_t CMPCHA2  : 1; /*!< [2..2] AN Input Select                                                    */
            __IOM uint16_t CMPCHA3  : 1; /*!< [3..3] AN Input Select                                                    */
            __IOM uint16_t CMPCHA4  : 1; /*!< [4..4] AN Input Select                                                    */
            __IOM uint16_t CMPCHA5  : 1; /*!< [5..5] AN Input Select                                                    */
            __IOM uint16_t CMPCHA6  : 1; /*!< [6..6] AN Input Select                                                    */
            __IOM uint16_t CMPCHA7  : 1; /*!< [7..7] AN Input Select                                                    */
            __IOM uint16_t CMPCHA8  : 1; /*!< [8..8] AN Input Select                                                    */
            __IOM uint16_t CMPCHA9  : 1; /*!< [9..9] AN Input Select                                                    */
            __IOM uint16_t CMPCHA10 : 1; /*!< [10..10] AN Input Select                                                  */
            __IOM uint16_t CMPCHA11 : 1; /*!< [11..11] AN Input Select                                                  */
            __IOM uint16_t CMPCHA12 : 1; /*!< [12..12] AN Input Select                                                  */
            __IOM uint16_t CMPCHA13 : 1; /*!< [13..13] AN Input Select                                                  */
            __IOM uint16_t CMPCHA14 : 1; /*!< [14..14] AN Input Select                                                  */
            __IOM uint16_t CMPCHA15 : 1; /*!< [15..15] AN Input Select                                                  */
        } ADCMPANSR_b[2];
    };

    union
    {
        __IOM uint16_t ADCMPLR[2];        /*!< (@ 0x00000098) A/D Compare Function Window A Comparison Condition
                                           *                  Setting Register                                           */

        struct
        {
            __IOM uint16_t CMPLCHA0  : 1; /*!< [0..0] Comparison condition of input                                      */
            __IOM uint16_t CMPLCHA1  : 1; /*!< [1..1] Comparison condition of input                                      */
            __IOM uint16_t CMPLCHA2  : 1; /*!< [2..2] Comparison condition of input                                      */
            __IOM uint16_t CMPLCHA3  : 1; /*!< [3..3] Comparison condition of input                                      */
            __IOM uint16_t CMPLCHA4  : 1; /*!< [4..4] Comparison condition of input                                      */
            __IOM uint16_t CMPLCHA5  : 1; /*!< [5..5] Comparison condition of input                                      */
            __IOM uint16_t CMPLCHA6  : 1; /*!< [6..6] Comparison condition of input                                      */
            __IOM uint16_t CMPLCHA7  : 1; /*!< [7..7] Comparison condition of input                                      */
            __IOM uint16_t CMPLCHA8  : 1; /*!< [8..8] Comparison condition of input                                      */
            __IOM uint16_t CMPLCHA9  : 1; /*!< [9..9] Comparison condition of input                                      */
            __IOM uint16_t CMPLCHA10 : 1; /*!< [10..10] Comparison condition of input                                    */
            __IOM uint16_t CMPLCHA11 : 1; /*!< [11..11] Comparison condition of input                                    */
            __IOM uint16_t CMPLCHA12 : 1; /*!< [12..12] Comparison condition of input                                    */
            __IOM uint16_t CMPLCHA13 : 1; /*!< [13..13] Comparison condition of input                                    */
            __IOM uint16_t CMPLCHA14 : 1; /*!< [14..14] Comparison condition of input                                    */
            __IOM uint16_t CMPLCHA15 : 1; /*!< [15..15] Comparison condition of input                                    */
        } ADCMPLR_b[2];
    };

    union
    {
        __IOM uint16_t ADCMPDR0;          /*!< (@ 0x0000009C) A/D Compare Function Window A Lower-Side Level
                                           *                  Setting Register                                           */

        struct
        {
            __IOM uint16_t ADCMPDR0 : 16; /*!< [15..0] The ADCMPDR0 register sets the reference data when the
                                           *   compare window A function is used. ADCMPDR0 sets the lower-side
                                           *   level of window A.                                                        */
        } ADCMPDR0_b;
    };

    union
    {
        __IOM uint16_t ADCMPDR1;          /*!< (@ 0x0000009E) A/D Compare Function Window A Upper-Side Level
                                           *                  Setting Register                                           */

        struct
        {
            __IOM uint16_t ADCMPDR1 : 16; /*!< [15..0] The ADCMPDR1 register sets the reference data when the
                                           *   compare window A function is used. ADCMPDR1 sets the upper-side
                                           *   level of window A..                                                       */
        } ADCMPDR1_b;
    };

    union
    {
        __IOM uint16_t ADCMPSR[2];         /*!< (@ 0x000000A0) A/D Compare Function Window A Channel Status
                                            *                  Register                                                   */

        struct
        {
            __IOM uint16_t CMPSTCHA0  : 1; /*!< [0..0] Compare window A flag of input                                     */
            __IOM uint16_t CMPSTCHA1  : 1; /*!< [1..1] Compare window A flag of input                                     */
            __IOM uint16_t CMPSTCHA2  : 1; /*!< [2..2] Compare window A flag of input                                     */
            __IOM uint16_t CMPSTCHA3  : 1; /*!< [3..3] Compare window A flag of input                                     */
            __IOM uint16_t CMPSTCHA4  : 1; /*!< [4..4] Compare window A flag of input                                     */
            __IOM uint16_t CMPSTCHA5  : 1; /*!< [5..5] Compare window A flag of input                                     */
            __IOM uint16_t CMPSTCHA6  : 1; /*!< [6..6] Compare window A flag of input                                     */
            __IOM uint16_t CMPSTCHA7  : 1; /*!< [7..7] Compare window A flag of input                                     */
            __IOM uint16_t CMPSTCHA8  : 1; /*!< [8..8] Compare window A flag of input                                     */
            __IOM uint16_t CMPSTCHA9  : 1; /*!< [9..9] Compare window A flag of input                                     */
            __IOM uint16_t CMPSTCHA10 : 1; /*!< [10..10] Compare window A flag of input                                   */
            __IOM uint16_t CMPSTCHA11 : 1; /*!< [11..11] Compare window A flag of input                                   */
            __IOM uint16_t CMPSTCHA12 : 1; /*!< [12..12] Compare window A flag of input                                   */
            __IOM uint16_t CMPSTCHA13 : 1; /*!< [13..13] Compare window A flag of input                                   */
            __IOM uint16_t CMPSTCHA14 : 1; /*!< [14..14] Compare window A flag of input                                   */
            __IOM uint16_t CMPSTCHA15 : 1; /*!< [15..15] Compare window A flag of input                                   */
        } ADCMPSR_b[2];
    };

    union
    {
        __IOM uint8_t ADCMPSER;         /*!< (@ 0x000000A4) A/D Compare Function Window A Extended Input
                                         *                  Channel Status Register                                    */

        struct
        {
            __IOM uint8_t CMPSTTSA : 1; /*!< [0..0] Compare Window A Temperature Sensor Output Compare Flag
                                         *   When window A operation is enabled (ADCMPCR.CMPAE = 1b),
                                         *   this bit indicates the temperature sensor output comparison
                                         *   result. When window A operation is disabled (ADCMPCR.CMPAE
                                         *   = 0b), comparison conditions for CMPSTTSA are not met any
                                         *   time.                                                                     */
            __IOM uint8_t CMPSTOCA : 1; /*!< [1..1] Compare Window A Internal Reference Voltage Compare Flag
                                         *   When window A operation is enabled (ADCMPCR.CMPAE = 1b),
                                         *   this bit indicates the temperature sensor output comparison
                                         *   result. When window A operation is disabled (ADCMPCR.CMPAE
                                         *   = 0b), comparison conditions for CMPSTTSA are not met any
                                         *   time.                                                                     */
            uint8_t : 6;
        } ADCMPSER_b;
    };
    __IM uint8_t RESERVED10;

    union
    {
        __IOM uint8_t ADCMPBNSR;       /*!< (@ 0x000000A6) A/D Compare Function Window B Channel Selection
                                        *                  Register                                                   */

        struct
        {
            __IOM uint8_t CMPCHB : 6;  /*!< [5..0] Compare window B channel selection bit.The channel that
                                        *   compares it on the condition of compare window B is selected.             */
            uint8_t             : 1;
            __IOM uint8_t CMPLB : 1;   /*!< [7..7] Compare window B Compare condition setting bit.                    */
        } ADCMPBNSR_b;
    };
    __IM uint8_t RESERVED11;

    union
    {
        __IOM uint16_t ADWINLLB;          /*!< (@ 0x000000A8) A/D Compare Function Window B Lower-Side Level
                                           *                  Setting Register                                           */

        struct
        {
            __IOM uint16_t ADWINLLB : 16; /*!< [15..0] This register is used to compare A window function is
                                           *   used to set the lower level of the window B.                              */
        } ADWINLLB_b;
    };

    union
    {
        __IOM uint16_t ADWINULB;          /*!< (@ 0x000000AA) A/D Compare Function Window B Upper-Side Level
                                           *                  Setting Register                                           */

        struct
        {
            __IOM uint16_t ADWINULB : 16; /*!< [15..0] This register is used to compare A window function is
                                           *   used to set the higher level of the window B.                             */
        } ADWINULB_b;
    };

    union
    {
        __IOM uint8_t ADCMPBSR;        /*!< (@ 0x000000AC) A/D Compare Function Window B Status Register              */

        struct
        {
            __IOM uint8_t CMPSTB : 1;  /*!< [0..0] Compare window B flag.It is a status flag that shows
                                        *   the comparative result of CH (AN000-AN027, temperature
                                        *   sensor, and internal reference voltage) made the object
                                        *   of window B relation condition.                                           */
            uint8_t : 7;
        } ADCMPBSR_b;
    };
    __IM uint8_t  RESERVED12;
    __IM uint16_t RESERVED13;

    union
    {
        __IM uint16_t ADBUF0;          /*!< (@ 0x000000B0) A/D Data Buffer Register 0                                 */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF0_b;
    };

    union
    {
        __IM uint16_t ADBUF1;          /*!< (@ 0x000000B2) A/D Data Buffer Register 1                                 */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF1_b;
    };

    union
    {
        __IM uint16_t ADBUF2;          /*!< (@ 0x000000B4) A/D Data Buffer Register 2                                 */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF2_b;
    };

    union
    {
        __IM uint16_t ADBUF3;          /*!< (@ 0x000000B6) A/D Data Buffer Register 3                                 */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF3_b;
    };

    union
    {
        __IM uint16_t ADBUF4;          /*!< (@ 0x000000B8) A/D Data Buffer Register 4                                 */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF4_b;
    };

    union
    {
        __IM uint16_t ADBUF5;          /*!< (@ 0x000000BA) A/D Data Buffer Register 5                                 */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF5_b;
    };

    union
    {
        __IM uint16_t ADBUF6;          /*!< (@ 0x000000BC) A/D Data Buffer Register 6                                 */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF6_b;
    };

    union
    {
        __IM uint16_t ADBUF7;          /*!< (@ 0x000000BE) A/D Data Buffer Register 7                                 */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF7_b;
    };

    union
    {
        __IM uint16_t ADBUF8;          /*!< (@ 0x000000C0) A/D Data Buffer Register 8                                 */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF8_b;
    };

    union
    {
        __IM uint16_t ADBUF9;          /*!< (@ 0x000000C2) A/D Data Buffer Register 9                                 */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF9_b;
    };

    union
    {
        __IM uint16_t ADBUF10;         /*!< (@ 0x000000C4) A/D Data Buffer Register 10                                */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF10_b;
    };

    union
    {
        __IM uint16_t ADBUF11;         /*!< (@ 0x000000C6) A/D Data Buffer Register 11                                */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF11_b;
    };

    union
    {
        __IM uint16_t ADBUF12;         /*!< (@ 0x000000C8) A/D Data Buffer Register 12                                */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF12_b;
    };

    union
    {
        __IM uint16_t ADBUF13;         /*!< (@ 0x000000CA) A/D Data Buffer Register 13                                */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF13_b;
    };

    union
    {
        __IM uint16_t ADBUF14;         /*!< (@ 0x000000CC) A/D Data Buffer Register 14                                */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF14_b;
    };

    union
    {
        __IM uint16_t ADBUF15;         /*!< (@ 0x000000CE) A/D Data Buffer Register 15                                */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF15_b;
    };

    union
    {
        __IOM uint8_t ADBUFEN;         /*!< (@ 0x000000D0) A/D Data Buffer Enable Register                            */

        struct
        {
            __IOM uint8_t BUFEN : 1;   /*!< [0..0] Data Buffer Enable                                                 */
            uint8_t             : 7;
        } ADBUFEN_b;
    };
    __IM uint8_t RESERVED14;

    union
    {
        __IOM uint8_t ADBUFPTR;        /*!< (@ 0x000000D2) A/D Data Buffer Pointer Register                           */

        struct
        {
            __IM uint8_t BUFPTR : 4;   /*!< [3..0] Data Buffer PointerThese bits indicate the number of
                                        *   data buffer to which the next A/D converted data is transferred.          */
            __IM uint8_t PTROVF : 1;   /*!< [4..4] Pointer Overflow Flag                                              */
            uint8_t             : 3;
        } ADBUFPTR_b;
    };
    __IM uint8_t  RESERVED15;
    __IM uint32_t RESERVED16[2];
    __IM uint8_t  RESERVED17;

    union
    {
        __IOM uint8_t ADSSTRL;         /*!< (@ 0x000000DD) A/D Sampling State Register L                              */

        struct
        {
            __IOM uint8_t SST : 8;     /*!< [7..0] Sampling Time Setting (AN016-AN027)                                */
        } ADSSTRL_b;
    };

    union
    {
        __IOM uint8_t ADSSTRT;         /*!< (@ 0x000000DE) A/D Sampling State Register T                              */

        struct
        {
            __IOM uint8_t SST : 8;     /*!< [7..0] Sampling Time Setting (temperature sensor output)                  */
        } ADSSTRT_b;
    };

    union
    {
        __IOM uint8_t ADSSTRO;         /*!< (@ 0x000000DF) A/D Sampling State Register O                              */

        struct
        {
            __IOM uint8_t SST : 8;     /*!< [7..0] Sampling Time Setting (Internal reference voltage)                 */
        } ADSSTRO_b;
    };

    union
    {
        __IOM uint8_t ADSSTR[16];      /*!< (@ 0x000000E0) A/D Sampling State Registers                               */

        struct
        {
            __IOM uint8_t SST : 8;     /*!< [7..0] Sampling time setting                                              */
        } ADSSTR_b[16];
    };

    union
    {
        __IOM uint16_t ADANIM;         /*!< (@ 0x000000F0) A/D Channel Input Mode Select Register                     */

        struct
        {
            __IOM uint16_t ANIM0 : 1;  /*!< [0..0] Analog Channel Input Mode Select                                   */
            __IOM uint16_t ANIM1 : 1;  /*!< [1..1] Analog Channel Input Mode Select                                   */
            __IOM uint16_t ANIM2 : 1;  /*!< [2..2] Analog Channel Input Mode Select                                   */
            __IOM uint16_t ANIM3 : 1;  /*!< [3..3] Analog Channel Input Mode Select                                   */
            uint16_t             : 12;
        } ADANIM_b;
    };

    union
    {
        __IOM uint8_t ADCALEXE;        /*!< (@ 0x000000F2) A/D Calibration Execution Register                         */

        struct
        {
            uint8_t              : 6;
            __IM uint8_t  CALMON : 1;  /*!< [6..6] Calibration Status Flag                                            */
            __IOM uint8_t CALEXE : 1;  /*!< [7..7] Calibration Start                                                  */
        } ADCALEXE_b;
    };
    __IM uint8_t RESERVED18;

    union
    {
        __IOM uint8_t VREFAMPCNT;        /*!< (@ 0x000000F4) A/D Dedicated Reference Voltage Circuit Control
                                          *                  Register                                                   */

        struct
        {
            __IOM uint8_t OLDETEN   : 1; /*!< [0..0] OLDET Enable                                                       */
            __IOM uint8_t VREFADCG  : 2; /*!< [2..1] VREFADC Output Voltage Control                                     */
            __IOM uint8_t VREFADCEN : 1; /*!< [3..3] VREFADCG Enable                                                    */
            __IOM uint8_t BGREN     : 1; /*!< [4..4] BGR Enable                                                         */
            uint8_t                 : 2;
            __IOM uint8_t ADSLP     : 1; /*!< [7..7] Sleep                                                              */
        } VREFAMPCNT_b;
    };
    __IM uint8_t  RESERVED19;
    __IM uint16_t RESERVED20;

    union
    {
        __IOM uint16_t ADRD;           /*!< (@ 0x000000F8) A/D Self-Diagnosis Data Register                           */

        struct
        {
            __IM uint16_t AD : 16;     /*!< [15..0] Converted Value 15 to 0                                           */
        } ADRD_b;
    };

    union
    {
        __IM uint8_t ADRST;            /*!< (@ 0x000000FA) A/D Self-Diagnostic Status Register                        */

        struct
        {
            __IM uint8_t DIAGST : 2;   /*!< [1..0] Self-Diagnosis Status                                              */
            uint8_t             : 6;
        } ADRST_b;
    };
    __IM uint8_t  RESERVED21;
    __IM uint32_t RESERVED22[41];

    union
    {
        __IOM uint16_t ADPGACR;           /*!< (@ 0x000001A0) A/D Programmable Gain Amplifier Control Register           */

        struct
        {
            __IOM uint16_t P000SEL0  : 1; /*!< [0..0] A through amplifier is enable for PGA P000                         */
            __IOM uint16_t P000SEL1  : 1; /*!< [1..1] The amplifier passing is enable for PGA P000                       */
            __IOM uint16_t P000ENAMP : 1; /*!< [2..2] Amplifier enable bit for PGA P000                                  */
            __IOM uint16_t P000GEN   : 1; /*!< [3..3] PGA P000 gain setting and enable bit                               */
            __IOM uint16_t P001SEL0  : 1; /*!< [4..4] A through amplifier is enable for PGA P001                         */
            __IOM uint16_t P001SEL1  : 1; /*!< [5..5] The amplifier passing is enable for PGA P001                       */
            __IOM uint16_t P001ENAMP : 1; /*!< [6..6] Amplifier enable bit for PGA P001                                  */
            __IOM uint16_t P001GEN   : 1; /*!< [7..7] PGA P001 gain setting and enable bit                               */
            __IOM uint16_t P002SEL0  : 1; /*!< [8..8] A through amplifier is enable for PGA P002                         */
            __IOM uint16_t P002SEL1  : 1; /*!< [9..9] The amplifier passing is enable for PGA P002                       */
            __IOM uint16_t P002ENAMP : 1; /*!< [10..10] Amplifier enable bit for PGA P002                                */
            __IOM uint16_t P002GEN   : 1; /*!< [11..11] PGA P002 gain setting and enable bit                             */
            __IOM uint16_t P003SEL0  : 1; /*!< [12..12] A through amplifier is enable for PGA P003                       */
            __IOM uint16_t P003SEL1  : 1; /*!< [13..13] The amplifier passing is enable for PGA P003                     */
            __IOM uint16_t P003ENAMP : 1; /*!< [14..14] Amplifier enable bit for PGA P003                                */
            __IOM uint16_t P003GEN   : 1; /*!< [15..15] PGA P003 gain setting and enable bit                             */
        } ADPGACR_b;
    };

    union
    {
        __IOM uint16_t ADPGAGS0;         /*!< (@ 0x000001A2) A/D Programmable Gain Amplifier Gain Setting
                                          *                  Register 0                                                 */

        struct
        {
            __IOM uint16_t P000GAIN : 4; /*!< [3..0] PGA P000 gain setting bit.The gain magnification of (ADPGSDCR0.P000GEN=
                                          *   b) when the shingle end is input and each PGA P000 is set.
                                          *   When the differential motion is input, (ADPGSDCR0.P000GEN=1b)
                                          *   sets the gain magnification when the differential motion
                                          *   is input by the combination with ADPGSDCR0.P000DG 1:0.                    */
            __IOM uint16_t P001GAIN : 4; /*!< [7..4] PGA P001 gain setting bit.The gain magnification of (ADPGSDCR0.P001GEN=
                                          *   b) when the shingle end is input and each PGA P001 is set.
                                          *   When the differential motion is input, (ADPGSDCR0.P001GEN=1b)
                                          *   sets the gain magnification when the differential motion
                                          *   is input by the combination with ADPGSDCR0.P001DG 1:0.                    */
            __IOM uint16_t P002GAIN : 4; /*!< [11..8] PGA P002 gain setting bit.The gain magnification of
                                          *   (ADPGSDCR0.P002GEN=0b) when the shingle end is input and
                                          *   each PGA P002 is set. When the differential motion is input,
                                          *   (ADPGSDCR0.P002GEN=1b) sets the gain magnification when
                                          *   the differential motion is input by the combination with
                                          *   ADPGSDCR0.P002DG 1:0.                                                     */
            __IOM uint16_t P003GAIN : 4; /*!< [15..12] PGA P003 gain setting bit.The gain magnification of
                                          *   (ADPGSDCR0.P003GEN=0b) when the shingle end is input and
                                          *   each PGA P003 is set. When the differential motion is input,
                                          *   (ADPGSDCR0.P003GEN=1b) sets the gain magnification when
                                          *   the differential motion is input by the combination with
                                          *   ADPGSDCR0.P003DG 1:0.                                                     */
        } ADPGAGS0_b;
    };
    __IM uint32_t RESERVED23[3];

    union
    {
        __IOM uint16_t ADPGADCR0;       /*!< (@ 0x000001B0) A/D Programmable Gain Amplifier Differential
                                         *                  Input Control Register                                     */

        struct
        {
            __IOM uint16_t P000DG : 2;  /*!< [1..0] P000 Differential Input Gain SettingNOTE: When these
                                         *   bits are used, set {P000DEN, P000GEN} to 11b.                             */
            uint16_t               : 1;
            __IOM uint16_t P000DEN : 1; /*!< [3..3] P000 Differential Input Enable                                     */
            __IOM uint16_t P001DG  : 2; /*!< [5..4] P001 Differential Input Gain SettingNOTE: When these
                                         *   bits are used, set {P001DEN, P001GEN} to 11b.                             */
            uint16_t               : 1;
            __IOM uint16_t P001DEN : 1; /*!< [7..7] P001 Differential Input Enable                                     */
            __IOM uint16_t P002DG  : 2; /*!< [9..8] P002 Differential Input Gain SettingNOTE: When these
                                         *   bits are used, set {P002DEN, P002GEN} to 11b.                             */
            uint16_t               : 1;
            __IOM uint16_t P002DEN : 1; /*!< [11..11] P002 Differential Input Enable                                   */
            __IOM uint16_t P003DG  : 2; /*!< [13..12] P003 Differential Input Gain SettingNOTE: When these
                                         *   bits are used, set {P003DEN, P003GEN} to 11b.                             */
            uint16_t               : 1;
            __IOM uint16_t P003DEN : 1; /*!< [15..15] P003 Differential Input Enable                                   */
        } ADPGADCR0_b;
    };
    __IM uint16_t RESERVED24;

    union
    {
        __IOM uint8_t ADPGADBS0;       /*!< (@ 0x000001B4) A/D Programmable Gain Amplifier Differential
                                        *                  Input Bias Select Register 0                               */

        struct
        {
            __IOM uint8_t P0BIAS : 1;  /*!< [0..0] Programmable Gain Amplifiers P000 to P002 Bias Voltage
                                        *   SelectNOTE: This bit selects the input bias voltage value
                                        *   when differential inputs are used.                                        */
            uint8_t : 7;
        } ADPGADBS0_b;
    };

    union
    {
        __IOM uint8_t ADPGADBS1;       /*!< (@ 0x000001B5) A/D Programmable Gain Amplifier Differential
                                        *                  Input Bias Select Register 1                               */

        struct
        {
            __IOM uint8_t P3BIAS : 1;  /*!< [0..0] Programmable Gain Amplifiers P003 Bias Voltage SelectNOTE:
                                        *   This bit selects the input bias voltage value when differential
                                        *   inputs are used.                                                          */
            uint8_t : 7;
        } ADPGADBS1_b;
    };
    __IM uint16_t RESERVED25;
    __IM uint32_t RESERVED26[10];

    union
    {
        __IOM uint32_t ADREFMON;       /*!< (@ 0x000001E0) A/D External Reference Voltage Monitor Register            */

        struct
        {
            __IOM uint32_t PGAMON : 3; /*!< [2..0] PGA Monitor Output Enable                                          */
            uint32_t              : 13;
            __IOM uint32_t MONSEL : 4; /*!< [19..16] Monitor output selection bit.                                    */
            uint32_t              : 12;
        } ADREFMON_b;
    };
} R_ADC0_Type;                         /*!< Size = 484 (0x1e4)                                                        */

/* =========================================================================================================================== */
/* ================                                          R_PSCU                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Peripheral Security Control Unit (R_PSCU)
 */

typedef struct                         /*!< (@ 0x400E0000) R_PSCU Structure                                           */
{
    __IM uint32_t RESERVED;

    union
    {
        __IOM uint32_t PSARB;          /*!< (@ 0x00000004) Peripheral Security Attribution Register B                 */

        struct
        {
            uint32_t               : 1;
            __IOM uint32_t PSARB1  : 1; /*!< [1..1] CAN1 and the MSTPCRB.MSTPB1 bit security attribution               */
            __IOM uint32_t PSARB2  : 1; /*!< [2..2] CAN0 and the MSTPCRB.MSTPB2 bit security attribution               */
            __IOM uint32_t PSARB3  : 1; /*!< [3..3] CEC and the MSTPCRB.MSTPB3 bit security attribution                */
            uint32_t               : 2;
            __IM uint32_t  PSARB6  : 1; /*!< [6..6] QSPI and the MSTPCRB.MSTPB6 bit security attribution               */
            __IOM uint32_t PSARB7  : 1; /*!< [7..7] IIC2 and the MSTPCRB.MSTPB7 bit security attribution               */
            __IOM uint32_t PSARB8  : 1; /*!< [8..8] IIC1 and the MSTPCRB.MSTPB8 bit security attribution               */
            __IOM uint32_t PSARB9  : 1; /*!< [9..9] IIC0 and the MSTPCRB.MSTPB9 bit security attribution               */
            uint32_t               : 1;
            __IOM uint32_t PSARB11 : 1; /*!< [11..11] USBFS and the MSTPCRB.MSTPB11 bit security attribution           */
            __IOM uint32_t PSARB12 : 1; /*!< [12..12] USBHS and the MSTPCRB.MSTPB12 bit security attribution           */
            uint32_t               : 2;
            __IM uint32_t PSARB15  : 1; /*!< [15..15] ETHER0/EDMAC0, the MSTPCRB.MSTPB15 bit and the PFENET.PHYMODE0
                                         *   bit security attribution                                                  */
            __IM uint32_t PSARB16  : 1; /*!< [16..16] OSPI and the MSTPCRB.MSTPB16 bit security attribution            */
            uint32_t               : 1;
            __IOM uint32_t PSARB18 : 1; /*!< [18..18] RSPI1 and the MSTPCRB.MSTPB18 bit security attribution           */
            __IOM uint32_t PSARB19 : 1; /*!< [19..19] RSPI0 and the MSTPCRB.MSTPB19 bit security attribution           */
            uint32_t               : 2;
            __IOM uint32_t PSARB22 : 1; /*!< [22..22] SCI9 and the MSTPCRB.MSTPB22 bit security attribution            */
            __IOM uint32_t PSARB23 : 1; /*!< [23..23] SCI8 and the MSTPCRB.MSTPB23 bit security attribution            */
            __IOM uint32_t PSARB24 : 1; /*!< [24..24] SCI7 and the MSTPCRB.MSTPB24 bit security attribution            */
            __IOM uint32_t PSARB25 : 1; /*!< [25..25] SCI6 and the MSTPCRB.MSTPB25 bit security attribution            */
            __IOM uint32_t PSARB26 : 1; /*!< [26..26] SCI5 and the MSTPCRB.MSTPB26 bit security attribution            */
            __IOM uint32_t PSARB27 : 1; /*!< [27..27] SCI4 and the MSTPCRB.MSTPB27 bit security attribution            */
            __IOM uint32_t PSARB28 : 1; /*!< [28..28] SCI3 and the MSTPCRB.MSTPB28 bit security attribution            */
            __IOM uint32_t PSARB29 : 1; /*!< [29..29] SCI2 and the MSTPCRB.MSTPB29 bit security attribution            */
            __IOM uint32_t PSARB30 : 1; /*!< [30..30] SCI1 and the MSTPCRB.MSTPB30 bit security attribution            */
            __IOM uint32_t PSARB31 : 1; /*!< [31..31] SCI0 and the MSTPCRB.MSTPB31 bit security attribution            */
        } PSARB_b;
    };

    union
    {
        __IOM uint32_t PSARC;           /*!< (@ 0x00000008) Peripheral Security Attribution Register C                 */

        struct
        {
            __IOM uint32_t PSARC0  : 1; /*!< [0..0] CAC and the MSTPCRC.MSTPC0 bit security attribution                */
            __IOM uint32_t PSARC1  : 1; /*!< [1..1] CRC and the MSTPCRC.MSTPC1 bit security attribution                */
            uint32_t               : 1;
            __IOM uint32_t PSARC3  : 1; /*!< [3..3] CTSU and the MSTPCRC.MSTPC3 bit security attribution               */
            uint32_t               : 4;
            __IOM uint32_t PSARC8  : 1; /*!< [8..8] SSIE0 and the MSTPCRC.MSTPC8 bit security attribution              */
            uint32_t               : 3;
            __IOM uint32_t PSARC12 : 1; /*!< [12..12] SDHI0 and the MSTPCRC.MSTPC12 bit security attribution           */
            __IOM uint32_t PSARC13 : 1; /*!< [13..13] DOC and the MSTPCRC.MSTPC13 bit security attribution             */
            uint32_t               : 6;
            __IOM uint32_t PSARC20 : 1; /*!< [20..20] TFU and the MSTPCRC.MSTPC20 bit security attribution             */
            uint32_t               : 6;
            __IOM uint32_t PSARC27 : 1; /*!< [27..27] CANFD0 and the MSTPCRC.MSTPC27 bit security attribution          */
            uint32_t               : 3;
            __IOM uint32_t PSARC31 : 1; /*!< [31..31] TSIP and the MSTPCRC.MSTPC31 bit security attribution            */
        } PSARC_b;
    };

    union
    {
        __IOM uint32_t PSARD;           /*!< (@ 0x0000000C) Peripheral Security Attribution Register D                 */

        struct
        {
            __IOM uint32_t PSARD0  : 1; /*!< [0..0] AGT3 and the MSTPCRD.MSTPD0 bit security attribution               */
            __IOM uint32_t PSARD1  : 1; /*!< [1..1] AGT2 and the MSTPCRD.MSTPD1 bit security attribution               */
            __IOM uint32_t PSARD2  : 1; /*!< [2..2] AGT1 and the MSTPCRD.MSTPD2 bit security attribution               */
            __IOM uint32_t PSARD3  : 1; /*!< [3..3] AGT0 and the MSTPCRD.MSTPD3 bit security attribution               */
            uint32_t               : 7;
            __IOM uint32_t PSARD11 : 1; /*!< [11..11] PGI3 and the MSTPCRD.MSTPD11 bit security attribution            */
            __IOM uint32_t PSARD12 : 1; /*!< [12..12] PGI2 and the MSTPCRD.MSTPD12 bit security attribution            */
            __IOM uint32_t PSARD13 : 1; /*!< [13..13] PGI1 and the MSTPCRD.MSTPD13 bit security attribution            */
            __IOM uint32_t PSARD14 : 1; /*!< [14..14] PGI0 and the MSTPCRD.MSTPD14 bit security attribution            */
            __IOM uint32_t PSARD15 : 1; /*!< [15..15] ADC1 and the MSTPCRD.MSTPD15 bit security attribution            */
            __IOM uint32_t PSARD16 : 1; /*!< [16..16] ADC0 and the MSTPCRD.MSTPD16 bit security attribution            */
            uint32_t               : 2;
            __IOM uint32_t PSARD19 : 1; /*!< [19..19] DAC121 and the MSTPCRD.MSTPD19 bit security attribution          */
            __IOM uint32_t PSARD20 : 1; /*!< [20..20] DAC120 and the MSTPCRD.MSTPD20 bit security attribution          */
            uint32_t               : 1;
            __IOM uint32_t PSARD22 : 1; /*!< [22..22] TSN and the MSTPCRD.MSTPD22 bit security attribution             */
            uint32_t               : 2;
            __IOM uint32_t PSARD25 : 1; /*!< [25..25] ACMPHS3 and the MSTPCRD.MSTPD25 bit security attribution         */
            __IOM uint32_t PSARD26 : 1; /*!< [26..26] ACMPHS2 and the MSTPCRD.MSTPD26 bit security attribution         */
            __IOM uint32_t PSARD27 : 1; /*!< [27..27] ACMPHS1 and the MSTPCRD.MSTPD27 bit security attribution         */
            __IOM uint32_t PSARD28 : 1; /*!< [28..28] ACMPHS0 and the MSTPCRD.MSTPD28 bit security attribution         */
            uint32_t               : 3;
        } PSARD_b;
    };

    union
    {
        __IOM uint32_t PSARE;           /*!< (@ 0x00000010) Peripheral Security Attribution Register E                 */

        struct
        {
            __IOM uint32_t PSARE0  : 1; /*!< [0..0] WDT security attribution                                           */
            __IOM uint32_t PSARE1  : 1; /*!< [1..1] IWDT security attribution                                          */
            __IOM uint32_t PSARE2  : 1; /*!< [2..2] RTC security attribution                                           */
            uint32_t               : 11;
            __IOM uint32_t PSARE14 : 1; /*!< [14..14] AGT5 and the MSTPCRE.MSTPE14 bit security attribution            */
            __IOM uint32_t PSARE15 : 1; /*!< [15..15] AGT4 and the MSTPCRE.MSTPE15 bit security attribution            */
            uint32_t               : 6;
            __IOM uint32_t PSARE22 : 1; /*!< [22..22] GPT9 and the MSTPCRE.MSTPE22 bit security attribution            */
            __IOM uint32_t PSARE23 : 1; /*!< [23..23] GPT8 and the MSTPCRE.MSTPE23 bit security attribution            */
            __IOM uint32_t PSARE24 : 1; /*!< [24..24] GPT7 and the MSTPCRE.MSTPE24 bit security attribution            */
            __IOM uint32_t PSARE25 : 1; /*!< [25..25] GPT6 and the MSTPCRE.MSTPE25 bit security attribution            */
            __IOM uint32_t PSARE26 : 1; /*!< [26..26] GPT5 and the MSTPCRE.MSTPE26 bit security attribution            */
            __IOM uint32_t PSARE27 : 1; /*!< [27..27] GPT4 and the MSTPCRE.MSTPE27 bit security attribution            */
            __IOM uint32_t PSARE28 : 1; /*!< [28..28] GPT3 and the MSTPCRE.MSTPE28 bit security attribution            */
            __IOM uint32_t PSARE29 : 1; /*!< [29..29] GPT2 and the MSTPCRE.MSTPE29 bit security attribution            */
            __IOM uint32_t PSARE30 : 1; /*!< [30..30] GPT1 and the MSTPCRE.MSTPE30 bit security attribution            */
            __IOM uint32_t PSARE31 : 1; /*!< [31..31] GPT0 and the MSTPCRE.MSTPE31 bit security attribution            */
        } PSARE_b;
    };

    union
    {
        __IOM uint32_t MSSAR;          /*!< (@ 0x00000014) Module Stop Security Attribution Register                  */

        struct
        {
            __IOM uint32_t MSSAR0 : 1; /*!< [0..0] The MSTPCRC.MSTPC14 bit security attribution                       */
            __IOM uint32_t MSSAR1 : 1; /*!< [1..1] The MSTPCRA.MSTPA22 bit security attribution                       */
            __IOM uint32_t MSSAR2 : 1; /*!< [2..2] The MSTPCRA.MSTPA7 bit security attribution                        */
            __IOM uint32_t MSSAR3 : 1; /*!< [3..3] The MSTPCRA.MSTPA0 bit security attribution                        */
            uint32_t              : 28;
        } MSSAR_b;
    };

    union
    {
        __IOM uint32_t CFSAMONA;       /*!< (@ 0x00000018) Code Flash Security Attribution Monitor Register
                                        *                  A                                                          */

        struct
        {
            uint32_t            : 15;
            __IOM uint32_t CFS2 : 9;   /*!< [23..15] Code Flash Secure area 2                                         */
            uint32_t            : 8;
        } CFSAMONA_b;
    };

    union
    {
        __IOM uint32_t CFSAMONB;       /*!< (@ 0x0000001C) Code Flash Security Attribution Monitor Register
                                        *                  B                                                          */

        struct
        {
            uint32_t            : 10;
            __IOM uint32_t CFS1 : 14;  /*!< [23..10] Code Flash Secure area 1                                         */
            uint32_t            : 8;
        } CFSAMONB_b;
    };

    union
    {
        __IOM uint32_t DFSAMON;        /*!< (@ 0x00000020) Data Flash Security Attribution Monitor Register           */

        struct
        {
            uint32_t           : 10;
            __IOM uint32_t DFS : 6;    /*!< [15..10] Data flash Secure area                                           */
            uint32_t           : 16;
        } DFSAMON_b;
    };

    union
    {
        __IOM uint32_t SSAMONA;        /*!< (@ 0x00000024) SRAM Security Attribution Monitor Register A               */

        struct
        {
            uint32_t           : 13;
            __IOM uint32_t SS2 : 8;    /*!< [20..13] SRAM Secure area 2                                               */
            uint32_t           : 11;
        } SSAMONA_b;
    };

    union
    {
        __IOM uint32_t SSAMONB;        /*!< (@ 0x00000028) SRAM Security Attribution Monitor Register B               */

        struct
        {
            uint32_t           : 10;
            __IOM uint32_t SS1 : 11;   /*!< [20..10] SRAM secure area 1                                               */
            uint32_t           : 11;
        } SSAMONB_b;
    };

    union
    {
        __IM uint32_t DLMMON;          /*!< (@ 0x0000002C) Device Lifecycle Management State Monitor Register         */

        struct
        {
            __IM uint32_t DLMMON : 4;  /*!< [3..0] Device Lifecycle Management State Monitor                          */
            uint32_t             : 28;
        } DLMMON_b;
    };
} R_PSCU_Type;                         /*!< Size = 48 (0x30)                                                          */

/* =========================================================================================================================== */
/* ================                                           R_BUS                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Bus Interface (R_BUS)
 */

typedef struct                          /*!< (@ 0x40003000) R_BUS Structure                                            */
{
    __IOM R_BUS_CSa_Type CSa[8];        /*!< (@ 0x00000000) CS Registers                                               */
    __IM uint32_t        RESERVED[480];
    __IOM R_BUS_CSb_Type CSb[8];        /*!< (@ 0x00000800) CS Registers                                               */

    union
    {
        __IOM uint16_t CSRECEN;         /*!< (@ 0x00000880) CS Recovery Cycle Insertion Enable Register                */

        struct
        {
            __IOM uint16_t RCVEN0  : 1; /*!< [0..0] Separate Bus Recovery Cycle Insertion Enable                       */
            __IOM uint16_t RCVEN1  : 1; /*!< [1..1] Separate Bus Recovery Cycle Insertion Enable                       */
            __IOM uint16_t RCVEN2  : 1; /*!< [2..2] Separate Bus Recovery Cycle Insertion Enable                       */
            __IOM uint16_t RCVEN3  : 1; /*!< [3..3] Separate Bus Recovery Cycle Insertion Enable                       */
            __IOM uint16_t RCVEN4  : 1; /*!< [4..4] Separate Bus Recovery Cycle Insertion Enable                       */
            __IOM uint16_t RCVEN5  : 1; /*!< [5..5] Separate Bus Recovery Cycle Insertion Enable                       */
            __IOM uint16_t RCVEN6  : 1; /*!< [6..6] Separate Bus Recovery Cycle Insertion Enable                       */
            __IOM uint16_t RCVEN7  : 1; /*!< [7..7] Separate Bus Recovery Cycle Insertion Enable                       */
            __IOM uint16_t RCVENM0 : 1; /*!< [8..8] Multiplexed Bus Recovery Cycle Insertion Enable                    */
            __IOM uint16_t RCVENM1 : 1; /*!< [9..9] Multiplexed Bus Recovery Cycle Insertion Enable                    */
            __IOM uint16_t RCVENM2 : 1; /*!< [10..10] Multiplexed Bus Recovery Cycle Insertion Enable                  */
            __IOM uint16_t RCVENM3 : 1; /*!< [11..11] Multiplexed Bus Recovery Cycle Insertion Enable                  */
            __IOM uint16_t RCVENM4 : 1; /*!< [12..12] Multiplexed Bus Recovery Cycle Insertion Enable                  */
            __IOM uint16_t RCVENM5 : 1; /*!< [13..13] Multiplexed Bus Recovery Cycle Insertion Enable                  */
            __IOM uint16_t RCVENM6 : 1; /*!< [14..14] Multiplexed Bus Recovery Cycle Insertion Enable                  */
            __IOM uint16_t RCVENM7 : 1; /*!< [15..15] Multiplexed Bus Recovery Cycle Insertion Enable                  */
        } CSRECEN_b;
    };
    __IM uint16_t           RESERVED1;
    __IM uint32_t           RESERVED2[223];
    __IOM R_BUS_SDRAM_Type  SDRAM;      /*!< (@ 0x00000C00) SDRAM Registers                                            */
    __IM uint32_t           RESERVED3[235];
    __IOM R_BUS_BUSM_Type   BUSM[6];    /*!< (@ 0x00001000) Master Bus Control Register Array                          */
    __IM uint32_t           RESERVED4[58];
    __IOM R_BUS_BUSS_Type   BUSS[16];   /*!< (@ 0x00001100) Slave Bus Control Register Array                           */
    __IM uint32_t           RESERVED5[432];
    __IOM R_BUS_BUSERR_Type BUSERR[11]; /*!< (@ 0x00001800) Bus Error Registers                                        */
} R_BUS_Type;                           /*!< Size = 6320 (0x18b0)                                                      */

/* =========================================================================================================================== */
/* ================                                           R_CAC                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Clock Frequency Accuracy Measurement Circuit (R_CAC)
 */

typedef struct                         /*!< (@ 0x40083600) R_CAC Structure                                            */
{
    union
    {
        __IOM uint8_t CACR0;           /*!< (@ 0x00000000) CAC Control Register 0                                     */

        struct
        {
            __IOM uint8_t CFME : 1;    /*!< [0..0] Clock Frequency Measurement Enable.                                */
            uint8_t            : 7;
        } CACR0_b;
    };

    union
    {
        __IOM uint8_t CACR1;           /*!< (@ 0x00000001) CAC Control Register 1                                     */

        struct
        {
            __IOM uint8_t CACREFE : 1; /*!< [0..0] CACREF Pin Input Enable                                            */
            __IOM uint8_t FMCS    : 3; /*!< [3..1] Measurement Target Clock Select                                    */
            __IOM uint8_t TCSS    : 2; /*!< [5..4] Measurement Target Clock Frequency Division Ratio Select           */
            __IOM uint8_t EDGES   : 2; /*!< [7..6] Valid Edge Select                                                  */
        } CACR1_b;
    };

    union
    {
        __IOM uint8_t CACR2;           /*!< (@ 0x00000002) CAC Control Register 2                                     */

        struct
        {
            __IOM uint8_t RPS  : 1;    /*!< [0..0] Reference Signal Select                                            */
            __IOM uint8_t RSCS : 3;    /*!< [3..1] Measurement Reference Clock Select                                 */
            __IOM uint8_t RCDS : 2;    /*!< [5..4] Measurement Reference Clock Frequency Division Ratio
                                        *   Select                                                                    */
            __IOM uint8_t DFS : 2;     /*!< [7..6] Digital Filter Selection                                           */
        } CACR2_b;
    };

    union
    {
        __IOM uint8_t CAICR;           /*!< (@ 0x00000003) CAC Interrupt Control Register                             */

        struct
        {
            __IOM uint8_t FERRIE : 1;  /*!< [0..0] Frequency Error Interrupt Request Enable                           */
            __IOM uint8_t MENDIE : 1;  /*!< [1..1] Measurement End Interrupt Request Enable                           */
            __IOM uint8_t OVFIE  : 1;  /*!< [2..2] Overflow Interrupt Request Enable                                  */
            uint8_t              : 1;
            __OM uint8_t FERRFCL : 1;  /*!< [4..4] FERRF Clear                                                        */
            __OM uint8_t MENDFCL : 1;  /*!< [5..5] MENDF Clear                                                        */
            __OM uint8_t OVFFCL  : 1;  /*!< [6..6] OVFF Clear                                                         */
            uint8_t              : 1;
        } CAICR_b;
    };

    union
    {
        __IM uint8_t CASTR;            /*!< (@ 0x00000004) CAC Status Register                                        */

        struct
        {
            __IM uint8_t FERRF : 1;    /*!< [0..0] Frequency Error Flag                                               */
            __IM uint8_t MENDF : 1;    /*!< [1..1] Measurement End Flag                                               */
            __IM uint8_t OVFF  : 1;    /*!< [2..2] Counter Overflow Flag                                              */
            uint8_t            : 5;
        } CASTR_b;
    };
    __IM uint8_t RESERVED;

    union
    {
        __IOM uint16_t CAULVR;          /*!< (@ 0x00000006) CAC Upper-Limit Value Setting Register                     */

        struct
        {
            __IOM uint16_t CAULVR : 16; /*!< [15..0] CAULVR is a 16-bit readable/writable register that stores
                                         *   the upper-limit value of the frequency.                                   */
        } CAULVR_b;
    };

    union
    {
        __IOM uint16_t CALLVR;          /*!< (@ 0x00000008) CAC Lower-Limit Value Setting Register                     */

        struct
        {
            __IOM uint16_t CALLVR : 16; /*!< [15..0] CALLVR is a 16-bit readable/writable register that stores
                                         *   the lower-limit value of the frequency.                                   */
        } CALLVR_b;
    };

    union
    {
        __IM uint16_t CACNTBR;          /*!< (@ 0x0000000A) CAC Counter Buffer Register                                */

        struct
        {
            __IM uint16_t CACNTBR : 16; /*!< [15..0] CACNTBR is a 16-bit read-only register that retains
                                         *   the counter value at the time a valid reference signal
                                         *   edge is input                                                             */
        } CACNTBR_b;
    };
} R_CAC_Type;                           /*!< Size = 12 (0xc)                                                           */

/* =========================================================================================================================== */
/* ================                                         R_CANFD0                                          ================ */
/* =========================================================================================================================== */

/**
 * @brief Controller Area Network - Flexible Data (CAN-FD) Module (R_CANFD0)
 */

typedef struct                         /*!< (@ 0x400B0000) R_CANFD0 Structure                                         */
{
    __IOM R_CANFD_CFDC_Type CFDC[1];   /*!< (@ 0x00000000) Channel Control/Status                                     */
    __IM uint32_t           RESERVED;

    union
    {
        __IOM uint32_t CFDGCFG;        /*!< (@ 0x00000014) Global Configuration Register                              */

        struct
        {
            __IOM uint32_t TPRI  : 1;  /*!< [0..0] Transmission Priority                                              */
            __IOM uint32_t DCE   : 1;  /*!< [1..1] DLC Check Enable                                                   */
            __IOM uint32_t DRE   : 1;  /*!< [2..2] DLC Replacement Enable                                             */
            __IOM uint32_t MME   : 1;  /*!< [3..3] Mirror Mode Enable                                                 */
            __IOM uint32_t DCS   : 1;  /*!< [4..4] Data Link Controller Clock Select                                  */
            __IOM uint32_t CMPOC : 1;  /*!< [5..5] CAN-FD message Payload overflow configuration                      */
            uint32_t             : 2;
            __IOM uint32_t TSP   : 4;  /*!< [11..8] Timestamp Prescaler                                               */
            __IOM uint32_t TSSS  : 1;  /*!< [12..12] Timestamp Source Select                                          */
            uint32_t             : 3;
            __IOM uint32_t ITRCP : 16; /*!< [31..16] Interval Timer Reference Clock Prescaler                         */
        } CFDGCFG_b;
    };

    union
    {
        __IOM uint32_t CFDGCTR;         /*!< (@ 0x00000018) Global Control Register                                    */

        struct
        {
            __IOM uint32_t GMDC    : 2; /*!< [1..0] Global Mode Control                                                */
            __IOM uint32_t GSLPR   : 1; /*!< [2..2] Global Sleep Request                                               */
            uint32_t               : 5;
            __IOM uint32_t DEIE    : 1; /*!< [8..8] DLC check Interrupt Enable                                         */
            __IOM uint32_t MEIE    : 1; /*!< [9..9] Message lost Error Interrupt Enable                                */
            __IOM uint32_t THLEIE  : 1; /*!< [10..10] TX History List Entry Lost Interrupt Enable                      */
            __IOM uint32_t CMPOFIE : 1; /*!< [11..11] CAN-FD message payload overflow Flag Interrupt enable            */
            uint32_t               : 4;
            __IOM uint32_t TSRST   : 1; /*!< [16..16] Timestamp Reset                                                  */
            uint32_t               : 15;
        } CFDGCTR_b;
    };

    union
    {
        __IOM uint32_t CFDGSTS;         /*!< (@ 0x0000001C) Global Status Register                                     */

        struct
        {
            __IM uint32_t GRSTSTS  : 1; /*!< [0..0] Global Reset Status                                                */
            __IM uint32_t GHLTSTS  : 1; /*!< [1..1] Global Halt Status                                                 */
            __IM uint32_t GSLPSTS  : 1; /*!< [2..2] Global Sleep Status                                                */
            __IM uint32_t GRAMINIT : 1; /*!< [3..3] Global RAM Initialisation                                          */
            uint32_t               : 28;
        } CFDGSTS_b;
    };

    union
    {
        __IOM uint32_t CFDGERFL;       /*!< (@ 0x00000020) Global Error Flag Register                                 */

        struct
        {
            __IOM uint32_t DEF   : 1;  /*!< [0..0] DLC Error Flag                                                     */
            __IM uint32_t  MES   : 1;  /*!< [1..1] Message Lost Error Status                                          */
            __IM uint32_t  THLES : 1;  /*!< [2..2] TX History List Entry Lost Error Status                            */
            __IOM uint32_t CMPOF : 1;  /*!< [3..3] CAN-FD message payload overflow Flag                               */
            uint32_t             : 12;
            __IOM uint32_t EEF0  : 1;  /*!< [16..16] ECC Error Flag for Channel 0                                     */
            uint32_t             : 15;
        } CFDGERFL_b;
    };

    union
    {
        __IOM uint32_t CFDGTSC;        /*!< (@ 0x00000024) Global Timestamp Counter Register                          */

        struct
        {
            __IM uint32_t TS : 16;     /*!< [15..0] Timestamp Value                                                   */
            uint32_t         : 16;
        } CFDGTSC_b;
    };

    union
    {
        __IOM uint32_t CFDGAFLECTR;    /*!< (@ 0x00000028) Global Acceptance Filter List Entry Control Register       */

        struct
        {
            __IOM uint32_t AFLPN  : 4; /*!< [3..0] Acceptance Filter List Page Number                                 */
            uint32_t              : 4;
            __IOM uint32_t AFLDAE : 1; /*!< [8..8] Acceptance Filter List Data Access Enable                          */
            uint32_t              : 23;
        } CFDGAFLECTR_b;
    };

    union
    {
        __IOM uint32_t CFDGAFLCFG0;    /*!< (@ 0x0000002C) Global Acceptance Filter List Configuration Register
                                        *                  0                                                          */

        struct
        {
            __IOM uint32_t RNC1 : 9;   /*!< [8..0] Rule Number for Channel 1                                          */
            uint32_t            : 7;
            __IOM uint32_t RNC0 : 9;   /*!< [24..16] Rule Number for Channel 0                                        */
            uint32_t            : 7;
        } CFDGAFLCFG0_b;
    };

    union
    {
        __IOM uint32_t CFDRMNB;        /*!< (@ 0x00000030) RX Message Buffer Number Register                          */

        struct
        {
            __IOM uint32_t NRXMB : 8;  /*!< [7..0] Number of RX Message Buffers                                       */
            __IOM uint32_t RMPLS : 3;  /*!< [10..8] Reception Message Buffer Payload Data Size                        */
            uint32_t             : 21;
        } CFDRMNB_b;
    };

    union
    {
        __IOM uint32_t CFDRMND0;       /*!< (@ 0x00000034) RX Message Buffer New Data Register 0                      */

        struct
        {
            __IOM uint32_t RMNSu : 32; /*!< [31..0] RX Message Buffer New Data Status                                 */
        } CFDRMND0_b;
    };

    union
    {
        __IOM uint32_t CFDRMIEC;       /*!< (@ 0x00000038) RX Message Buffer Interrupt Enable Configuration
                                        *                  Register                                                   */

        struct
        {
            __IOM uint32_t RMIE : 32;  /*!< [31..0] RX Message Buffer Interrupt Enable                                */
        } CFDRMIEC_b;
    };

    union
    {
        __IOM uint32_t CFDRFCC[2];     /*!< (@ 0x0000003C) RX FIFO Configuration / Control Registers                  */

        struct
        {
            __IOM uint32_t RFE    : 1; /*!< [0..0] RX FIFO Enable                                                     */
            __IOM uint32_t RFIE   : 1; /*!< [1..1] RX FIFO Interrupt Enable                                           */
            uint32_t              : 2;
            __IOM uint32_t RFPLS  : 3; /*!< [6..4] Rx FIFO Payload Data Size configuration                            */
            uint32_t              : 1;
            __IOM uint32_t RFDC   : 3; /*!< [10..8] RX FIFO Depth Configuration                                       */
            uint32_t              : 1;
            __IOM uint32_t RFIM   : 1; /*!< [12..12] RX FIFO Interrupt Mode                                           */
            __IOM uint32_t RFIGCV : 3; /*!< [15..13] RX FIFO Interrupt Generation Counter Value                       */
            uint32_t              : 16;
        } CFDRFCC_b[2];
    };

    union
    {
        __IOM uint32_t CFDRFSTS[2];    /*!< (@ 0x00000044) RX FIFO Status Registers                                   */

        struct
        {
            __IM uint32_t  RFEMP : 1;  /*!< [0..0] RX FIFO Empty                                                      */
            __IM uint32_t  RFFLL : 1;  /*!< [1..1] RX FIFO Full                                                       */
            __IOM uint32_t RFMLT : 1;  /*!< [2..2] RX FIFO Message Lost                                               */
            __IOM uint32_t RFIF  : 1;  /*!< [3..3] RX FIFO Interrupt Flag                                             */
            uint32_t             : 4;
            __IM uint32_t RFMC   : 8;  /*!< [15..8] RX FIFO Message Count                                             */
            uint32_t             : 16;
        } CFDRFSTS_b[2];
    };

    union
    {
        __IOM uint32_t CFDRFPCTR[2];   /*!< (@ 0x0000004C) RX FIFO Pointer Control Registers                          */

        struct
        {
            __OM uint32_t RFPC : 8;    /*!< [7..0] RX FIFO Pointer Control                                            */
            uint32_t           : 24;
        } CFDRFPCTR_b[2];
    };

    union
    {
        __IOM uint32_t CFDCFCC[1];     /*!< (@ 0x00000054) Common FIFO Configuration / Control Registers              */

        struct
        {
            __IOM uint32_t CFE    : 1; /*!< [0..0] Common FIFO Enable                                                 */
            __IOM uint32_t CFRXIE : 1; /*!< [1..1] Common FIFO RX Interrupt Enable                                    */
            __IOM uint32_t CFTXIE : 1; /*!< [2..2] Common FIFO TX Interrupt Enable                                    */
            uint32_t              : 1;
            __IOM uint32_t CFPLS  : 3; /*!< [6..4] Common FIFO Payload Data size configuration                        */
            uint32_t              : 1;
            __IOM uint32_t CFM    : 2; /*!< [9..8] Common FIFO Mode                                                   */
            __IOM uint32_t CFITSS : 1; /*!< [10..10] Common FIFO Interval Timer Source Select                         */
            __IOM uint32_t CFITR  : 1; /*!< [11..11] Common FIFO Interval Timer Resolution                            */
            __IOM uint32_t CFIM   : 1; /*!< [12..12] Common FIFO Interrupt Mode                                       */
            __IOM uint32_t CFIGCV : 3; /*!< [15..13] Common FIFO Interrupt Generation Counter Value                   */
            __IOM uint32_t CFTML  : 5; /*!< [20..16] Common FIFO TX Message Buffer Link                               */
            __IOM uint32_t CFDC   : 3; /*!< [23..21] Common FIFO Depth Configuration                                  */
            __IOM uint32_t CFITT  : 8; /*!< [31..24] Common FIFO Interval Transmission Time                           */
        } CFDCFCC_b[1];
    };

    union
    {
        __IOM uint32_t CFDCFSTS[1];    /*!< (@ 0x00000058) Common FIFO Status Registers                               */

        struct
        {
            __IM uint32_t  CFEMP  : 1; /*!< [0..0] Common FIFO Empty                                                  */
            __IM uint32_t  CFFLL  : 1; /*!< [1..1] Common FIFO Full                                                   */
            __IOM uint32_t CFMLT  : 1; /*!< [2..2] Common FIFO Message Lost                                           */
            __IOM uint32_t CFRXIF : 1; /*!< [3..3] Common RX FIFO Interrupt Flag                                      */
            __IOM uint32_t CFTXIF : 1; /*!< [4..4] Common TX FIFO Interrupt Flag                                      */
            uint32_t              : 3;
            __IM uint32_t CFMC    : 8; /*!< [15..8] Common FIFO Message Count                                         */
            uint32_t              : 16;
        } CFDCFSTS_b[1];
    };

    union
    {
        __IOM uint32_t CFDCFPCTR[1];   /*!< (@ 0x0000005C) Common FIFO Pointer Control Registers                      */

        struct
        {
            __OM uint32_t CFPC : 8;    /*!< [7..0] Common FIFO Pointer Control                                        */
            uint32_t           : 24;
        } CFDCFPCTR_b[1];
    };

    union
    {
        __IM uint32_t CFDFESTS;        /*!< (@ 0x00000060) FIFO Empty Status Register                                 */

        struct
        {
            __IM uint32_t RFXEMP : 2;  /*!< [1..0] RX FIF0 Empty Status                                               */
            uint32_t             : 6;
            __IM uint32_t CFXEMP : 1;  /*!< [8..8] Common FIF0 Empty Status                                           */
            uint32_t             : 23;
        } CFDFESTS_b;
    };

    union
    {
        __IM uint32_t CFDFFSTS;        /*!< (@ 0x00000064) FIFO Full Status Register                                  */

        struct
        {
            __IM uint32_t RFXFLL : 2;  /*!< [1..0] RX FIF0 Full Status                                                */
            uint32_t             : 6;
            __IM uint32_t CFXFLL : 1;  /*!< [8..8] Common FIF0 Full Status                                            */
            uint32_t             : 23;
        } CFDFFSTS_b;
    };

    union
    {
        __IM uint32_t CFDFMSTS;        /*!< (@ 0x00000068) FIFO Message Lost Status Register                          */

        struct
        {
            __IM uint32_t RFXMLT : 2;  /*!< [1..0] RX FIFO Msg Lost Status                                            */
            uint32_t             : 6;
            __IM uint32_t CFXMLT : 1;  /*!< [8..8] Common FIFO Msg Lost Status                                        */
            uint32_t             : 23;
        } CFDFMSTS_b;
    };

    union
    {
        __IOM uint32_t CFDRFISTS;      /*!< (@ 0x0000006C) RX FIFO Interrupt Flag Status Register                     */

        struct
        {
            __IM uint32_t RFXIF : 1;   /*!< [0..0] RX FIFO[x] Interrupt Flag Status                                   */
            uint32_t            : 31;
        } CFDRFISTS_b;
    };

    union
    {
        __IOM uint8_t CFDTMC[4];       /*!< (@ 0x00000070) TX Message Buffer Control Registers                        */

        struct
        {
            __IOM uint8_t TMTR  : 1;   /*!< [0..0] TX Message Buffer Transmission Request                             */
            __IOM uint8_t TMTAR : 1;   /*!< [1..1] TX Message Buffer Transmission abort Request                       */
            __IOM uint8_t TMOM  : 1;   /*!< [2..2] TX Message Buffer One-shot Mode                                    */
            uint8_t             : 5;
        } CFDTMC_b[4];
    };

    union
    {
        __IOM uint8_t CFDTMSTS[4];     /*!< (@ 0x00000074) TX Message Buffer Status Registers                         */

        struct
        {
            __IM uint8_t  TMTSTS : 1;  /*!< [0..0] TX Message Buffer Transmission Status                              */
            __IOM uint8_t TMTRF  : 2;  /*!< [2..1] TX Message Buffer Transmission Result Flag                         */
            __IM uint8_t  TMTRM  : 1;  /*!< [3..3] TX Message Buffer Transmission Request Mirrored                    */
            __IM uint8_t  TMTARM : 1;  /*!< [4..4] TX Message Buffer Transmission abort Request Mirrored              */
            uint8_t              : 3;
        } CFDTMSTS_b[4];
    };

    union
    {
        __IM uint32_t CFDTMTRSTS[1];       /*!< (@ 0x00000078) TX Message Buffer Transmission Request Status
                                            *                  Register                                                   */

        struct
        {
            __IM uint32_t CFDTMTRSTSg : 4; /*!< [3..0] TX Message Buffer Transmission Request Status                      */
            uint32_t                  : 28;
        } CFDTMTRSTS_b[1];
    };

    union
    {
        __IM uint32_t CFDTMTARSTS[1];       /*!< (@ 0x0000007C) TX Message Buffer Transmission Abort Request
                                             *                  Status Register                                            */

        struct
        {
            __IM uint32_t CFDTMTARSTSg : 4; /*!< [3..0] TX Message Buffer Transmission abort Request Status                */
            uint32_t                   : 28;
        } CFDTMTARSTS_b[1];
    };

    union
    {
        __IM uint32_t CFDTMTCSTS[1];       /*!< (@ 0x00000080) TX Message Buffer Transmission Completion Status
                                            *                  Register                                                   */

        struct
        {
            __IM uint32_t CFDTMTCSTSg : 4; /*!< [3..0] TX Message Buffer Transmission Completion Status                   */
            uint32_t                  : 28;
        } CFDTMTCSTS_b[1];
    };

    union
    {
        __IM uint32_t CFDTMTASTS[1];       /*!< (@ 0x00000084) TX Message Buffer Transmission Abort Status Register       */

        struct
        {
            __IM uint32_t CFDTMTASTSg : 4; /*!< [3..0] TX Message Buffer Transmission abort Status                        */
            uint32_t                  : 28;
        } CFDTMTASTS_b[1];
    };

    union
    {
        __IOM uint32_t CFDTMIEC[1];    /*!< (@ 0x00000088) TX Message Buffer Interrupt Enable Configuration
                                        *                  Register                                                   */

        struct
        {
            __IOM uint32_t TMIEg : 4;  /*!< [3..0] TX Message Buffer Interrupt Enable                                 */
            uint32_t             : 28;
        } CFDTMIEC_b[1];
    };

    union
    {
        __IOM uint32_t CFDTXQCC0[1];    /*!< (@ 0x0000008C) TX Queue Configuration / Control Registers 0               */

        struct
        {
            __IOM uint32_t TXQE    : 1; /*!< [0..0] TX Queue Enable                                                    */
            uint32_t               : 4;
            __IOM uint32_t TXQTXIE : 1; /*!< [5..5] TX Queue TX Interrupt Enable                                       */
            uint32_t               : 1;
            __IOM uint32_t TXQIM   : 1; /*!< [7..7] TX Queue Interrupt Mode                                            */
            __IOM uint32_t TXQDC   : 2; /*!< [9..8] TX Queue Depth Configuration                                       */
            uint32_t               : 22;
        } CFDTXQCC0_b[1];
    };

    union
    {
        __IOM uint32_t CFDTXQSTS0[1];   /*!< (@ 0x00000090) TX Queue Status Registers 0                                */

        struct
        {
            __IM uint32_t  TXQEMP  : 1; /*!< [0..0] TX Queue Empty                                                     */
            __IM uint32_t  TXQFLL  : 1; /*!< [1..1] TX Queue Full                                                      */
            __IOM uint32_t TXQTXIF : 1; /*!< [2..2] TX Queue TX Interrupt Flag                                         */
            uint32_t               : 5;
            __IM uint32_t TXQMC    : 6; /*!< [13..8] TX Queue Message Count                                            */
            uint32_t               : 18;
        } CFDTXQSTS0_b[1];
    };

    union
    {
        __IOM uint32_t CFDTXQPCTR0[1]; /*!< (@ 0x00000094) TX Queue Pointer Control Registers 0                       */

        struct
        {
            __OM uint32_t TXQPC : 8;   /*!< [7..0] TX Queue Pointer Control                                           */
            uint32_t            : 24;
        } CFDTXQPCTR0_b[1];
    };

    union
    {
        __IOM uint32_t CFDTHLCC[1];    /*!< (@ 0x00000098) TX History List Configuration / Control Register           */

        struct
        {
            __IOM uint32_t THLE   : 1; /*!< [0..0] TX History List Enable                                             */
            uint32_t              : 7;
            __IOM uint32_t THLIE  : 1; /*!< [8..8] TX History List Interrupt Enable                                   */
            __IOM uint32_t THLIM  : 1; /*!< [9..9] TX History List Interrupt Mode                                     */
            __IOM uint32_t THLDTE : 1; /*!< [10..10] TX History List Dedicated TX Enable                              */
            uint32_t              : 21;
        } CFDTHLCC_b[1];
    };

    union
    {
        __IOM uint32_t CFDTHLSTS[1];   /*!< (@ 0x0000009C) TX History List Status Register                            */

        struct
        {
            __IM uint32_t  THLEMP : 1; /*!< [0..0] TX History List Empty                                              */
            __IM uint32_t  THLFLL : 1; /*!< [1..1] TX History List Full                                               */
            __IOM uint32_t THLELT : 1; /*!< [2..2] TX History List Entry Lost                                         */
            __IOM uint32_t THLIF  : 1; /*!< [3..3] TX History List Interrupt Flag                                     */
            uint32_t              : 4;
            __IM uint32_t THLMC   : 6; /*!< [13..8] TX History List Message Count                                     */
            uint32_t              : 18;
        } CFDTHLSTS_b[1];
    };

    union
    {
        __IOM uint32_t CFDTHLPCTR[1];  /*!< (@ 0x000000A0) TX History List Pointer Control Registers                  */

        struct
        {
            __OM uint32_t THLPC : 8;   /*!< [7..0] TX History List Pointer Control                                    */
            uint32_t            : 24;
        } CFDTHLPCTR_b[1];
    };

    union
    {
        __IOM uint32_t CFDGTINTSTS0;   /*!< (@ 0x000000A4) Global TX Interrupt Status Register 0                      */

        struct
        {
            __IM uint32_t TSIF0  : 1;  /*!< [0..0] TX Successful Interrupt Flag Channel 0                             */
            __IM uint32_t TAIF0  : 1;  /*!< [1..1] TX Abort Interrupt Flag Channel 0                                  */
            __IM uint32_t TQIF0  : 1;  /*!< [2..2] TX Queue Interrupt Flag Channel 0                                  */
            __IM uint32_t CFTIF0 : 1;  /*!< [3..3] COM FIFO TX/GW Mode Interrupt Flag Channel 0                       */
            __IM uint32_t THIF0  : 1;  /*!< [4..4] TX History List Interrupt Channel 0                                */
            uint32_t             : 27;
        } CFDGTINTSTS0_b;
    };

    union
    {
        __IOM uint32_t CFDGTSTCFG;     /*!< (@ 0x000000A8) Global Test Configuration Register                         */

        struct
        {
            uint32_t             : 16;
            __IOM uint32_t RTMPS : 10; /*!< [25..16] RAM Test Mode Page Select                                        */
            uint32_t             : 6;
        } CFDGTSTCFG_b;
    };

    union
    {
        __IOM uint32_t CFDGTSTCTR;     /*!< (@ 0x000000AC) Global Test Control Register                               */

        struct
        {
            uint32_t            : 2;
            __IOM uint32_t RTME : 1;   /*!< [2..2] RAM Test Mode Enable                                               */
            uint32_t            : 29;
        } CFDGTSTCTR_b;
    };

    union
    {
        __IOM uint32_t CFDGFDCFG;      /*!< (@ 0x000000B0) Global FD Configuration register                           */

        struct
        {
            __IOM uint32_t RPED   : 1; /*!< [0..0] RES bit Protocol exception disable                                 */
            uint32_t              : 7;
            __IOM uint32_t TSCCFG : 2; /*!< [9..8] Timestamp capture configuration                                    */
            uint32_t              : 22;
        } CFDGFDCFG_b;
    };
    __IM uint32_t RESERVED1;

    union
    {
        __IOM uint32_t CFDGLOCKK;      /*!< (@ 0x000000B8) Global Lock Key Register                                   */

        struct
        {
            __OM uint32_t LOCK : 16;   /*!< [15..0] Lock Key                                                          */
            uint32_t           : 16;
        } CFDGLOCKK_b;
    };
    __IM uint32_t RESERVED2;

    union
    {
        __IOM uint32_t CFDGAFLIGNENT;  /*!< (@ 0x000000C0) Global AFL Ignore Entry Register                           */

        struct
        {
            __IOM uint32_t IRN : 5;    /*!< [4..0] Ignore Rule Number                                                 */
            uint32_t           : 27;
        } CFDGAFLIGNENT_b;
    };

    union
    {
        __IOM uint32_t CFDGAFLIGNCTR;  /*!< (@ 0x000000C4) Global AFL Ignore Control Register                         */

        struct
        {
            __IOM uint32_t IREN : 1;   /*!< [0..0] Ignore Rule Enable                                                 */
            uint32_t            : 7;
            __OM uint32_t KEY   : 8;   /*!< [15..8] Key code                                                          */
            uint32_t            : 16;
        } CFDGAFLIGNCTR_b;
    };

    union
    {
        __IOM uint32_t CFDCDTCT;        /*!< (@ 0x000000C8) DMA Transfer Control Register                              */

        struct
        {
            __IOM uint32_t RFDMAE0 : 1; /*!< [0..0] DMA Transfer Enable for RXFIFO 0                                   */
            __IOM uint32_t RFDMAE1 : 1; /*!< [1..1] DMA Transfer Enable for RXFIFO 1                                   */
            uint32_t               : 6;
            __IOM uint32_t CFDMAE0 : 1; /*!< [8..8] DMA Transfer Enable for Common FIFO 0 of channel 0                 */
            uint32_t               : 23;
        } CFDCDTCT_b;
    };

    union
    {
        __IM uint32_t CFDCDTSTS;         /*!< (@ 0x000000CC) DMA Transfer Status Register                               */

        struct
        {
            __IM uint32_t RFDMASTS0 : 1; /*!< [0..0] DMA Transfer Status for RX FIFO 0                                  */
            __IM uint32_t RFDMASTS1 : 1; /*!< [1..1] DMA Transfer Status for RX FIFO 1                                  */
            uint32_t                : 6;
            __IM uint32_t CFDMASTS0 : 1; /*!< [8..8] DMA Transfer Status only for Common FIFO 0 of channel
                                          *   0                                                                         */
            uint32_t : 23;
        } CFDCDTSTS_b;
    };
    __IM uint32_t RESERVED3[2];

    union
    {
        __IOM uint32_t CFDGRSTC;       /*!< (@ 0x000000D8) Global SW reset Register                                   */

        struct
        {
            __IOM uint32_t SRST : 1;   /*!< [0..0] SW reset                                                           */
            uint32_t            : 7;
            __OM uint32_t KEY   : 8;   /*!< [15..8] Key code                                                          */
            uint32_t            : 16;
        } CFDGRSTC_b;
    };
    __IM uint32_t              RESERVED4[9];
    __IOM R_CANFD_CFDC2_Type   CFDC2[1];    /*!< (@ 0x00000100) Channel Configuration Registers                            */
    __IOM R_CANFD_CFDGAFL_Type CFDGAFL[16]; /*!< (@ 0x00000120) Global Acceptance Filter List Registers                    */
    __IM uint32_t              RESERVED5[24];

    union
    {
        __IOM uint32_t CFDRPGACC[64];    /*!< (@ 0x00000280) RAM Test Page Access Registers                             */

        struct
        {
            __IOM uint32_t RDTA : 32;    /*!< [31..0] RAM Data Test Access                                              */
        } CFDRPGACC_b[64];
    };
    __IM uint32_t             RESERVED6[104];
    __IOM R_CANFD_CFDRF_Type  CFDRF[2];  /*!< (@ 0x00000520) RX FIFO Access Registers                                   */
    __IOM R_CANFD_CFDCF_Type  CFDCF[1];  /*!< (@ 0x000005B8) Common FIFO Access Registers                               */
    __IOM R_CANFD_CFDTM_Type  CFDTM[4];  /*!< (@ 0x00000604) TX Message Buffer Access Registers                         */
    __IM uint32_t             RESERVED7[3];
    __IOM R_CANFD_CFDTHL_Type CFDTHL[1]; /*!< (@ 0x00000740) Channel TX History List                                    */
    __IM uint32_t             RESERVED8[118];
    __IOM R_CANFD_CFDRM_Type  CFDRM[4];  /*!< (@ 0x00000920) RX Message Buffer Access Clusters                          */
} R_CANFD_Type;                          /*!< Size = 6432 (0x1920)                                                      */

/* =========================================================================================================================== */
/* ================                                           R_CRC                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Cyclic Redundancy Check (CRC) Calculator (R_CRC)
 */

typedef struct                         /*!< (@ 0x40108000) R_CRC Structure                                            */
{
    union
    {
        __IOM uint8_t CRCCR0;          /*!< (@ 0x00000000) CRC Control Register0                                      */

        struct
        {
            __IOM uint8_t GPS    : 3;  /*!< [2..0] CRC Generating Polynomial Switching                                */
            uint8_t              : 3;
            __IOM uint8_t LMS    : 1;  /*!< [6..6] CRC Calculation Switching                                          */
            __OM uint8_t  DORCLR : 1;  /*!< [7..7] CRCDOR Register Clear                                              */
        } CRCCR0_b;
    };

    union
    {
        __IOM uint8_t CRCCR1;          /*!< (@ 0x00000001) CRC Control Register1                                      */

        struct
        {
            uint8_t              : 6;
            __IOM uint8_t CRCSWR : 1;  /*!< [6..6] Snoop-on-write/read switch bit                                     */
            __IOM uint8_t CRCSEN : 1;  /*!< [7..7] Snoop enable bit                                                   */
        } CRCCR1_b;
    };
    __IM uint16_t RESERVED;

    union
    {
        union
        {
            __IOM uint32_t CRCDIR;          /*!< (@ 0x00000004) CRC Data Input Register                                    */

            struct
            {
                __IOM uint32_t CRCDIR : 32; /*!< [31..0] Calculation input Data (Case of CRC-32, CRC-32C )                 */
            } CRCDIR_b;
        };

        union
        {
            __IOM uint8_t CRCDIR_BY;         /*!< (@ 0x00000004) CRC Data Input Register (byte access)                      */

            struct
            {
                __IOM uint8_t CRCDIR_BY : 8; /*!< [7..0] Calculation input Data ( Case of CRC-8, CRC-16 or CRC-CCITT
                                              *   )                                                                         */
            } CRCDIR_BY_b;
        };
    };

    union
    {
        union
        {
            __IOM uint32_t CRCDOR;          /*!< (@ 0x00000008) CRC Data Output Register                                   */

            struct
            {
                __IOM uint32_t CRCDOR : 32; /*!< [31..0] Calculation output Data (Case of CRC-32, CRC-32C )                */
            } CRCDOR_b;
        };

        union
        {
            __IOM uint16_t CRCDOR_HA;          /*!< (@ 0x00000008) CRC Data Output Register (halfword access)                 */

            struct
            {
                __IOM uint16_t CRCDOR_HA : 16; /*!< [15..0] Calculation output Data (Case of CRC-16 or CRC-CCITT
                                                *   )                                                                         */
            } CRCDOR_HA_b;
        };

        union
        {
            __IOM uint8_t CRCDOR_BY;         /*!< (@ 0x00000008) CRC Data Output Register(byte access)                      */

            struct
            {
                __IOM uint8_t CRCDOR_BY : 8; /*!< [7..0] Calculation output Data (Case of CRC-8 )                           */
            } CRCDOR_BY_b;
        };
    };

    union
    {
        __IOM uint16_t CRCSAR;         /*!< (@ 0x0000000C) Snoop Address Register                                     */

        struct
        {
            __IOM uint16_t CRCSA : 14; /*!< [13..0] snoop address bitSet the I/O register address to snoop            */
            uint16_t             : 2;
        } CRCSAR_b;
    };
    __IM uint16_t RESERVED1;
} R_CRC_Type;                          /*!< Size = 16 (0x10)                                                          */

/* =========================================================================================================================== */
/* ================                                           R_DAC                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief D/A Converter (R_DAC)
 */

typedef struct                         /*!< (@ 0x40171000) R_DAC Structure                                            */
{
    union
    {
        __IOM uint16_t DADR[2];        /*!< (@ 0x00000000) D/A Data Register                                          */

        struct
        {
            __IOM uint16_t DADR : 16;  /*!< [15..0] D/A Data RegisterNOTE: When DADPR.DPSEL = 0, the high-order
                                        *   4 bits are fixed to 0: right justified format. When DADPR.DPSEL
                                        *   = 1, the low-order 4 bits are fixed to 0: left justified
                                        *   format.                                                                   */
        } DADR_b[2];
    };

    union
    {
        __IOM uint8_t DACR;            /*!< (@ 0x00000004) D/A Control Register                                       */

        struct
        {
            uint8_t             : 5;
            __IOM uint8_t DAE   : 1;   /*!< [5..5] D/A Enable                                                         */
            __IOM uint8_t DAOE0 : 1;   /*!< [6..6] D/A Output Enable 0                                                */
            __IOM uint8_t DAOE1 : 1;   /*!< [7..7] D/A Output Enable 0                                                */
        } DACR_b;
    };

    union
    {
        __IOM uint8_t DADPR;           /*!< (@ 0x00000005) DADR0 Format Select Register                               */

        struct
        {
            uint8_t             : 7;
            __IOM uint8_t DPSEL : 1;   /*!< [7..7] DADRm Format Select                                                */
        } DADPR_b;
    };

    union
    {
        __IOM uint8_t DAADSCR;         /*!< (@ 0x00000006) D/A-A/D Synchronous Start Control Register                 */

        struct
        {
            uint8_t              : 7;
            __IOM uint8_t DAADST : 1;  /*!< [7..7] D/A-A/D Synchronous Conversion                                     */
        } DAADSCR_b;
    };

    union
    {
        __IOM uint8_t DAVREFCR;        /*!< (@ 0x00000007) D/A VREF Control Register                                  */

        struct
        {
            __IOM uint8_t REF : 3;     /*!< [2..0] D/A Reference Voltage Select                                       */
            uint8_t           : 5;
        } DAVREFCR_b;
    };

    union
    {
        __IOM uint8_t DAAMPCR;         /*!< (@ 0x00000008) D/A Output Amplifier Control Register                      */

        struct
        {
            uint8_t              : 6;
            __IOM uint8_t DAAMP0 : 1;  /*!< [6..6] Amplifier Control                                                  */
            __IOM uint8_t DAAMP1 : 1;  /*!< [7..7] Amplifier Control                                                  */
        } DAAMPCR_b;
    };

    union
    {
        __IOM uint8_t DAPC;            /*!< (@ 0x00000009) D/A Switch Charge Pump Control Register                    */

        struct
        {
            __IOM uint8_t PUMPEN : 1;  /*!< [0..0] Charge Pump Enable                                                 */
            uint8_t              : 7;
        } DAPC_b;
    };
    __IM uint16_t RESERVED[9];

    union
    {
        __IOM uint8_t DAASWCR;         /*!< (@ 0x0000001C) D/A Amplifier Stabilization Wait Control Register          */

        struct
        {
            uint8_t              : 6;
            __IOM uint8_t DAASW0 : 1;  /*!< [6..6] Set the DAASW0 bit to 1 in the initialization procedure
                                        *   to wait for stabilization of the output amplifier of D/A
                                        *   channel 0. When DAASW0 is set to 1, D/A conversion operates,
                                        *   but the conversion result D/A is not output from channel
                                        *   0. When the DAASW0 bit is 0, the stabilization wait time
                                        *   stops, and the D/A conversion result of channel 0 is output
                                        *   through the output amplifier.                                             */
            __IOM uint8_t DAASW1 : 1;  /*!< [7..7] Set the DAASW1 bit to 1 in the initialization procedure
                                        *   to wait for stabilization of the output amplifier of D/A
                                        *   channel 1. When DAASW1 is set to 1, D/A conversion operates,
                                        *   but the conversion result D/A is not output from channel
                                        *   1. When the DAASW1 bit is 0, the stabilization wait time
                                        *   stops, and the D/A conversion result of channel 1 is output
                                        *   through the output amplifier.                                             */
        } DAASWCR_b;
    };
    __IM uint8_t  RESERVED1;
    __IM uint16_t RESERVED2[2129];

    union
    {
        __IOM uint8_t DAADUSR;          /*!< (@ 0x000010C0) D/A A/D Synchronous Unit Select Register                   */

        struct
        {
            __IOM uint8_t AMADSEL0 : 1; /*!< [0..0] The DAADUSR register selects the target ADC12 unit for
                                         *   D/A and A/D synchronous conversions. Set bit [0] to 1 to
                                         *   select unit 0 as the target synchronous unit for the MCU.
                                         *   When setting the DAADSCR.DAADST bit to 1 for synchronous
                                         *   conversions, select the target unit in this register in
                                         *   advance. Only set the DAADUSR register while the ADCSR.ADST
                                         *   bit of the ADC12 is set to 0 and the DAADSCR.DAADST bit
                                         *   is set to 0.                                                              */
            __IOM uint8_t AMADSEL1 : 1; /*!< [1..1] The DAADUSR register selects the target ADC12 unit for
                                         *   D/A and A/D synchronous conversions. Set bit [1] to 1 to
                                         *   select unit 1 as the target synchronous unit for the MCU.
                                         *   When setting the DAADSCR.DAADST bit to 1 for synchronous
                                         *   conversions, select the target unit in this register in
                                         *   advance. Only set the DAADUSR register while the ADCSR.ADST
                                         *   bit of the ADC12 is set to 0 and the DAADSCR.DAADST bit
                                         *   is set to 0.                                                              */
            uint8_t : 6;
        } DAADUSR_b;
    };
    __IM uint8_t  RESERVED3;
    __IM uint16_t RESERVED4;
} R_DAC_Type;                          /*!< Size = 4292 (0x10c4)                                                      */

/* =========================================================================================================================== */
/* ================                                          R_DEBUG                                          ================ */
/* =========================================================================================================================== */

/**
 * @brief Debug Function (R_DEBUG)
 */

typedef struct                         /*!< (@ 0x4001B000) R_DEBUG Structure                                          */
{
    union
    {
        __IM uint32_t DBGSTR;          /*!< (@ 0x00000000) Debug Status Register                                      */

        struct
        {
            uint32_t                   : 28;
            __IM uint32_t CDBGPWRUPREQ : 1; /*!< [28..28] Debug power-up request                                           */
            __IM uint32_t CDBGPWRUPACK : 1; /*!< [29..29] Debug power-up acknowledge                                       */
            uint32_t                   : 2;
        } DBGSTR_b;
    };
    __IM uint32_t RESERVED[3];

    union
    {
        __IOM uint32_t DBGSTOPCR;             /*!< (@ 0x00000010) Debug Stop Control Register                                */

        struct
        {
            __IOM uint32_t DBGSTOP_IWDT  : 1; /*!< [0..0] Mask bit for IWDT reset/interrupt                                  */
            __IOM uint32_t DBGSTOP_WDT   : 1; /*!< [1..1] Mask bit for WDT reset/interrupt                                   */
            uint32_t                     : 14;
            __IOM uint32_t DBGSTOP_LVD0  : 1; /*!< [16..16] Mask bit for LVD reset/interupt                                  */
            __IOM uint32_t DBGSTOP_LVD1  : 1; /*!< [17..17] Mask bit for LVD reset/interupt                                  */
            __IOM uint32_t DBGSTOP_LVD2  : 1; /*!< [18..18] Mask bit for LVD reset/interupt                                  */
            uint32_t                     : 5;
            __IOM uint32_t DBGSTOP_RPER  : 1; /*!< [24..24] Mask bit for SRAM parity error                                   */
            __IOM uint32_t DBGSTOP_RECCR : 1; /*!< [25..25] Mask bit for SRAM ECC error                                      */
            uint32_t                     : 5;
            __IOM uint32_t DBGSTOP_CPER  : 1; /*!< [31..31] Mask bit for Cache SRAM parity error reset/interrupt             */
        } DBGSTOPCR_b;
    };
} R_DEBUG_Type;                               /*!< Size = 20 (0x14)                                                          */

/* =========================================================================================================================== */
/* ================                                           R_DMA                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief DMA Controller Common (R_DMA)
 */

typedef struct                         /*!< (@ 0x40005200) R_DMA Structure                                            */
{
    union
    {
        __IOM uint8_t DMAST;           /*!< (@ 0x00000000) DMAC Module Activation Register                            */

        struct
        {
            __IOM uint8_t DMST : 1;    /*!< [0..0] DMAC Operation Enable                                              */
            uint8_t            : 7;
        } DMAST_b;
    };
    __IM uint8_t  RESERVED;
    __IM uint16_t RESERVED1;
    __IM uint32_t RESERVED2[15];

    union
    {
        __IOM uint32_t DMECHR;          /*!< (@ 0x00000040) DMAC Error Channel Register                                */

        struct
        {
            __IM uint32_t DMECH    : 3; /*!< [2..0] DMAC Error channel                                                 */
            uint32_t               : 5;
            __IM uint32_t DMECHSAM : 1; /*!< [8..8] DMAC Error channel Security Attribution Monitor                    */
            uint32_t               : 7;
            __IOM uint32_t DMESTA  : 1; /*!< [16..16] DMAC Error Status                                                */
            uint32_t               : 15;
        } DMECHR_b;
    };
    __IM uint32_t RESERVED3[15];

    union
    {
        __IOM uint32_t DELSR[8];       /*!< (@ 0x00000080) DMAC Event Link Setting Register                           */

        struct
        {
            __IOM uint32_t DELS : 9;   /*!< [8..0] DMAC Event Link Select                                             */
            uint32_t            : 7;
            __IOM uint32_t IR   : 1;   /*!< [16..16] Interrupt Status Flag for DMAC NOTE: Writing 1 to the
                                        *   IR flag is prohibited.                                                    */
            uint32_t : 15;
        } DELSR_b[8];
    };
} R_DMA_Type;                          /*!< Size = 160 (0xa0)                                                         */

/* =========================================================================================================================== */
/* ================                                          R_DMAC0                                          ================ */
/* =========================================================================================================================== */

/**
 * @brief DMA Controller (R_DMAC0)
 */

typedef struct                         /*!< (@ 0x40005000) R_DMAC0 Structure                                          */
{
    union
    {
        __IOM uint32_t DMSAR;          /*!< (@ 0x00000000) DMA Source Address Register                                */

        struct
        {
            __IOM uint32_t DMSAR : 32; /*!< [31..0] Specifies the transfer source start address.                      */
        } DMSAR_b;
    };

    union
    {
        __IOM uint32_t DMDAR;          /*!< (@ 0x00000004) DMA Destination Address Register                           */

        struct
        {
            __IOM uint32_t DMDAR : 32; /*!< [31..0] Specifies the transfer destination start address.                 */
        } DMDAR_b;
    };

    union
    {
        __IOM uint32_t DMCRA;           /*!< (@ 0x00000008) DMA Transfer Count Register                                */

        struct
        {
            __IOM uint32_t DMCRAL : 16; /*!< [15..0] Lower bits of transfer count                                      */
            __IOM uint32_t DMCRAH : 10; /*!< [25..16] Upper bits of transfer count                                     */
            uint32_t              : 6;
        } DMCRA_b;
    };

    union
    {
        __IOM uint32_t DMCRB;           /*!< (@ 0x0000000C) DMA Block Transfer Count Register                          */

        struct
        {
            __IOM uint32_t DMCRBL : 16; /*!< [15..0] Functions as a number of block, repeat or repeat-block
                                         *   transfer counter.                                                         */
            __IOM uint32_t DMCRBH : 16; /*!< [31..16] Specifies the number of block transfer operations or
                                         *   repeat transfer operations.                                               */
        } DMCRB_b;
    };

    union
    {
        __IOM uint16_t DMTMD;          /*!< (@ 0x00000010) DMA Transfer Mode Register                                 */

        struct
        {
            __IOM uint16_t DCTG : 2;   /*!< [1..0] Transfer Request Source Select                                     */
            uint16_t            : 6;
            __IOM uint16_t SZ   : 2;   /*!< [9..8] Transfer Data Size Select                                          */
            __IOM uint16_t TKP  : 1;   /*!< [10..10] Transfer Keeping                                                 */
            uint16_t            : 1;
            __IOM uint16_t DTS  : 2;   /*!< [13..12] Repeat Area Select                                               */
            __IOM uint16_t MD   : 2;   /*!< [15..14] Transfer Mode Select                                             */
        } DMTMD_b;
    };
    __IM uint8_t RESERVED;

    union
    {
        __IOM uint8_t DMINT;           /*!< (@ 0x00000013) DMA Interrupt Setting Register                             */

        struct
        {
            __IOM uint8_t DARIE : 1;   /*!< [0..0] Destination Address Extended Repeat Area Overflow Interrupt
                                        *   Enable                                                                    */
            __IOM uint8_t SARIE : 1;   /*!< [1..1] Source Address Extended Repeat Area Overflow Interrupt
                                        *   Enable                                                                    */
            __IOM uint8_t RPTIE : 1;   /*!< [2..2] Repeat Size End Interrupt Enable                                   */
            __IOM uint8_t ESIE  : 1;   /*!< [3..3] Transfer Escape End Interrupt Enable                               */
            __IOM uint8_t DTIE  : 1;   /*!< [4..4] Transfer End Interrupt Enable                                      */
            uint8_t             : 3;
        } DMINT_b;
    };

    union
    {
        __IOM uint16_t DMAMD;          /*!< (@ 0x00000014) DMA Address Mode Register                                  */

        struct
        {
            __IOM uint16_t DARA : 5;   /*!< [4..0] Destination Address Extended Repeat Area Specifies the
                                        *   extended repeat area on the destination address. For details
                                        *   on the settings.                                                          */
            __IOM uint16_t DADR : 1;   /*!< [5..5] Destination Address Update Select After Reload                     */
            __IOM uint16_t DM   : 2;   /*!< [7..6] Destination Address Update Mode                                    */
            __IOM uint16_t SARA : 5;   /*!< [12..8] Source Address Extended Repeat Area Specifies the extended
                                        *   repeat area on the source address. For details on the settings.           */
            __IOM uint16_t SADR : 1;   /*!< [13..13] Source Address Update Select After Reload                        */
            __IOM uint16_t SM   : 2;   /*!< [15..14] Source Address Update Mode                                       */
        } DMAMD_b;
    };
    __IM uint16_t RESERVED1;

    union
    {
        __IOM uint32_t DMOFR;          /*!< (@ 0x00000018) DMA Offset Register                                        */

        struct
        {
            __IOM uint32_t DMOFR : 32; /*!< [31..0] Specifies the offset when offset addition is selected
                                        *   as the address update mode for transfer source or destination.            */
        } DMOFR_b;
    };

    union
    {
        __IOM uint8_t DMCNT;           /*!< (@ 0x0000001C) DMA Transfer Enable Register                               */

        struct
        {
            __IOM uint8_t DTE : 1;     /*!< [0..0] DMA Transfer Enable                                                */
            uint8_t           : 7;
        } DMCNT_b;
    };

    union
    {
        __IOM uint8_t DMREQ;           /*!< (@ 0x0000001D) DMA Software Start Register                                */

        struct
        {
            __IOM uint8_t SWREQ : 1;   /*!< [0..0] DMA Software Start                                                 */
            uint8_t             : 3;
            __IOM uint8_t CLRS  : 1;   /*!< [4..4] DMA Software Start Bit Auto Clear Select                           */
            uint8_t             : 3;
        } DMREQ_b;
    };

    union
    {
        __IOM uint8_t DMSTS;            /*!< (@ 0x0000001E) DMA Status Register                                        */

        struct
        {
            __IOM uint8_t ESIF : 1;     /*!< [0..0] Transfer Escape End Interrupt Flag                                 */
            uint8_t            : 3;
            __IOM uint8_t DTIF : 1;     /*!< [4..4] Transfer End Interrupt Flag                                        */
            uint8_t            : 2;
            __IM uint8_t ACT   : 1;     /*!< [7..7] DMA Active Flag                                                    */
        } DMSTS_b;
    };
    __IM uint8_t   RESERVED2;
    __IOM uint32_t DMSRR;               /*!< (@ 0x00000020) DMA Source Reload Address Register                         */
    __IOM uint32_t DMDRR;               /*!< (@ 0x00000024) DMA Destination Reload Address Register                    */

    union
    {
        __IOM uint32_t DMSBS;           /*!< (@ 0x00000028) DMA Source Buffer Size Register                            */

        struct
        {
            __IOM uint32_t DMSBSL : 16; /*!< [15..0] Functions as data transfer counter in repeat-block transfer
                                         *   mode                                                                      */
            __IOM uint32_t DMSBSH : 16; /*!< [31..16] Specifies the repeat-area size in repeat-block transfer
                                         *   mode                                                                      */
        } DMSBS_b;
    };

    union
    {
        __IOM uint32_t DMDBS;           /*!< (@ 0x0000002C) DMA Destination Buffer Size Register                       */

        struct
        {
            __IOM uint32_t DMDBSL : 16; /*!< [15..0] Functions as data transfer counter in repeat-block transfer
                                         *   mode                                                                      */
            __IOM uint32_t DMDBSH : 16; /*!< [31..16] Specifies the repeat-area size in repeat-block transfer
                                         *   mode                                                                      */
        } DMDBS_b;
    };

    union
    {
        __IOM uint8_t DMBWR;           /*!< (@ 0x00000030) DMA Bufferable Write Enable Register                       */

        struct
        {
            __IOM uint8_t BWE : 1;     /*!< [0..0] Bufferable Write Enable                                            */
            uint8_t           : 7;
        } DMBWR_b;
    };
    __IM uint8_t  RESERVED3;
    __IM uint16_t RESERVED4;
} R_DMAC0_Type;                        /*!< Size = 52 (0x34)                                                          */

/* =========================================================================================================================== */
/* ================                                           R_DOC                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Data Operation Circuit (R_DOC)
 */

typedef struct                         /*!< (@ 0x40109000) R_DOC Structure                                            */
{
    union
    {
        __IOM uint8_t DOCR;            /*!< (@ 0x00000000) DOC Control Register                                       */

        struct
        {
            __IOM uint8_t OMS     : 2; /*!< [1..0] Operating Mode Select                                              */
            __IOM uint8_t DCSEL   : 1; /*!< [2..2] Detection Condition Select                                         */
            uint8_t               : 2;
            __IM uint8_t  DOPCF   : 1; /*!< [5..5] Data Operation Circuit Flag                                        */
            __IOM uint8_t DOPCFCL : 1; /*!< [6..6] DOPCF Clear                                                        */
            uint8_t               : 1;
        } DOCR_b;
    };
    __IM uint8_t RESERVED;

    union
    {
        __IOM uint16_t DODIR;          /*!< (@ 0x00000002) DOC Data Input Register                                    */

        struct
        {
            __IOM uint16_t DODIR : 16; /*!< [15..0] 16-bit read-write register in which 16-bit data for
                                        *   use in the operations are stored.                                         */
        } DODIR_b;
    };

    union
    {
        __IOM uint16_t DODSR;          /*!< (@ 0x00000004) DOC Data Setting Register                                  */

        struct
        {
            __IOM uint16_t DODSR : 16; /*!< [15..0] This register stores 16-bit data for use as a reference
                                        *   in data comparison mode. This register also stores the
                                        *   results of operations in data addition and data subtraction
                                        *   modes.                                                                    */
        } DODSR_b;
    };
} R_DOC_Type;                          /*!< Size = 6 (0x6)                                                            */

/* =========================================================================================================================== */
/* ================                                           R_DTC                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Data Transfer Controller (R_DTC)
 */

typedef struct                         /*!< (@ 0x40005400) R_DTC Structure                                            */
{
    union
    {
        __IOM uint8_t DTCCR;           /*!< (@ 0x00000000) DTC Control Register                                       */

        struct
        {
            uint8_t           : 4;
            __IOM uint8_t RRS : 1;     /*!< [4..4] DTC Transfer Information Read Skip Enable.                         */
            uint8_t           : 3;
        } DTCCR_b;
    };
    __IM uint8_t  RESERVED;
    __IM uint16_t RESERVED1;

    union
    {
        __IOM uint32_t DTCVBR;          /*!< (@ 0x00000004) DTC Vector Base Register                                   */

        struct
        {
            __IOM uint32_t DTCVBR : 32; /*!< [31..0] DTC Vector Base Address.Note: A value cannot be set
                                         *   in the lower-order 10 bits. These bits are fixed to 0.                    */
        } DTCVBR_b;
    };
    __IM uint32_t RESERVED2;

    union
    {
        __IOM uint8_t DTCST;           /*!< (@ 0x0000000C) DTC Module Start Register                                  */

        struct
        {
            __IOM uint8_t DTCST : 1;   /*!< [0..0] DTC Module Start                                                   */
            uint8_t             : 7;
        } DTCST_b;
    };
    __IM uint8_t RESERVED3;

    union
    {
        __IM uint16_t DTCSTS;          /*!< (@ 0x0000000E) DTC Status Register                                        */

        struct
        {
            __IM uint16_t VECN : 8;    /*!< [7..0] DTC-Activating Vector Number MonitoringThese bits indicate
                                        *   the vector number for the activating source when DTC transfer
                                        *   is in progress.The value is only valid if DTC transfer
                                        *   is in progress (the value of the ACT flag is 1)                           */
            uint16_t          : 7;
            __IM uint16_t ACT : 1;     /*!< [15..15] DTC Active Flag                                                  */
        } DTCSTS_b;
    };

    union
    {
        __IOM uint8_t DTCCR_SEC;       /*!< (@ 0x00000010) DTC Control Register for secure Region                     */

        struct
        {
            uint8_t            : 4;
            __IOM uint8_t RRSS : 1;    /*!< [4..4] DTC Transfer Information Read Skip Enable for Secure               */
            uint8_t            : 3;
        } DTCCR_SEC_b;
    };
    __IM uint8_t   RESERVED4;
    __IM uint16_t  RESERVED5;
    __IOM uint32_t DTCVBR_SEC;         /*!< (@ 0x00000014) DTC Vector Base Register for secure Region                 */
    __IM uint32_t  RESERVED6[2];

    union
    {
        __IOM uint32_t DTEVR;          /*!< (@ 0x00000020) DTC Error Vector Register                                  */

        struct
        {
            __IM uint32_t DTEV    : 8; /*!< [7..0] DTC Error Vector Number                                            */
            __IM uint32_t DTEVSAM : 1; /*!< [8..8] DTC Error Vector Number SA Monitor                                 */
            uint32_t              : 7;
            __IOM uint32_t DTESTA : 1; /*!< [16..16] DTC Error Status Flag                                            */
            uint32_t              : 15;
        } DTEVR_b;
    };
} R_DTC_Type;                          /*!< Size = 36 (0x24)                                                          */

/* =========================================================================================================================== */
/* ================                                           R_ELC                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Event Link Controller (R_ELC)
 */

typedef struct                         /*!< (@ 0x40082000) R_ELC Structure                                            */
{
    union
    {
        __IOM uint8_t ELCR;            /*!< (@ 0x00000000) Event Link Controller Register                             */

        struct
        {
            uint8_t             : 7;
            __IOM uint8_t ELCON : 1;   /*!< [7..7] All Event Link Enable                                              */
        } ELCR_b;
    };
    __IM uint8_t            RESERVED;
    __IOM R_ELC_ELSEGR_Type ELSEGR[2]; /*!< (@ 0x00000002) Event Link Software Event Generation Register              */
    __IM uint16_t           RESERVED1[5];
    __IOM R_ELC_ELSR_Type   ELSR[23];  /*!< (@ 0x00000010) Event Link Setting Register [0..22]                        */
    __IM uint16_t           RESERVED2[4];

    union
    {
        __IOM uint16_t ELCSARA;         /*!< (@ 0x00000074) Event Link Controller Security Attribution Register
                                         *                  A                                                          */

        struct
        {
            __IOM uint16_t ELCR    : 1; /*!< [0..0] Event Link Controller RegisterSecurity Attribution                 */
            __IOM uint16_t ELSEGR0 : 1; /*!< [1..1] Event Link Software Event Generation Register 0 Security
                                         *   Attribution                                                               */
            __IOM uint16_t ELSEGR1 : 1; /*!< [2..2] Event Link Software Event Generation Register 1Security
                                         *   Attribution                                                               */
            uint16_t : 13;
        } ELCSARA_b;
    };
    __IM uint16_t RESERVED3;

    union
    {
        __IOM uint16_t ELCSARB;        /*!< (@ 0x00000078) Event Link Controller Security Attribution Register
                                        *                  B                                                          */

        struct
        {
            __IOM uint16_t ELSR0  : 1; /*!< [0..0] Event Link Setting Register 0Security Attribution                  */
            __IOM uint16_t ELSR1  : 1; /*!< [1..1] Event Link Setting Register 1Security Attribution                  */
            __IOM uint16_t ELSR2  : 1; /*!< [2..2] Event Link Setting Register 2Security Attribution                  */
            __IOM uint16_t ELSR3  : 1; /*!< [3..3] Event Link Setting Register 3Security Attribution                  */
            __IOM uint16_t ELSR4  : 1; /*!< [4..4] Event Link Setting Register 4Security Attribution                  */
            __IOM uint16_t ELSR5  : 1; /*!< [5..5] Event Link Setting Register 5Security Attribution                  */
            __IOM uint16_t ELSR6  : 1; /*!< [6..6] Event Link Setting Register 6Security Attribution                  */
            __IOM uint16_t ELSR7  : 1; /*!< [7..7] Event Link Setting Register 7Security Attribution                  */
            __IOM uint16_t ELSR8  : 1; /*!< [8..8] Event Link Setting Register 8Security Attribution                  */
            __IOM uint16_t ELSR9  : 1; /*!< [9..9] Event Link Setting Register 9Security Attribution                  */
            __IOM uint16_t ELSR10 : 1; /*!< [10..10] Event Link Setting Register 10Security Attribution               */
            __IOM uint16_t ELSR11 : 1; /*!< [11..11] Event Link Setting Register 11Security Attribution               */
            __IOM uint16_t ELSR12 : 1; /*!< [12..12] Event Link Setting Register 12Security Attribution               */
            __IOM uint16_t ELSR13 : 1; /*!< [13..13] Event Link Setting Register 13Security Attribution               */
            __IOM uint16_t ELSR14 : 1; /*!< [14..14] Event Link Setting Register 14Security Attribution               */
            __IOM uint16_t ELSR15 : 1; /*!< [15..15] Event Link Setting Register 15Security Attribution               */
        } ELCSARB_b;
    };
    __IM uint16_t RESERVED4;

    union
    {
        __IOM uint16_t ELCSARC;        /*!< (@ 0x0000007C) Event Link Controller Security Attribution Register
                                        *                  C                                                          */

        struct
        {
            __IOM uint16_t ELSR16 : 1; /*!< [0..0] Event Link Setting Register 16Security Attribution                 */
            __IOM uint16_t ELSR17 : 1; /*!< [1..1] Event Link Setting Register 17Security Attribution                 */
            __IOM uint16_t ELSR18 : 1; /*!< [2..2] Event Link Setting Register 18Security Attribution                 */
            uint16_t              : 13;
        } ELCSARC_b;
    };
} R_ELC_Type;                          /*!< Size = 126 (0x7e)                                                         */

/* =========================================================================================================================== */
/* ================                                       R_FACI_HP_CMD                                       ================ */
/* =========================================================================================================================== */

/**
 * @brief Flash Application Command Interface Command-Issuing Area (R_FACI_HP_CMD)
 */

typedef struct                         /*!< (@ 0x407E0000) R_FACI_HP_CMD Structure                                    */
{
    union
    {
        __IOM uint16_t FACI_CMD16;     /*!< (@ 0x00000000) FACI Command Issuing Area (halfword access)                */
        __IOM uint8_t  FACI_CMD8;      /*!< (@ 0x00000000) FACI Command Issuing Area (halfword access)                */
    };
} R_FACI_HP_CMD_Type;                  /*!< Size = 2 (0x2)                                                            */

/* =========================================================================================================================== */
/* ================                                         R_FACI_HP                                         ================ */
/* =========================================================================================================================== */

/**
 * @brief Flash Application Command Interface (R_FACI_HP)
 */

typedef struct                         /*!< (@ 0x407FE000) R_FACI_HP Structure                                        */
{
    __IM uint32_t RESERVED[4];

    union
    {
        __IOM uint8_t FASTAT;          /*!< (@ 0x00000010) Flash Access Status                                        */

        struct
        {
            uint8_t             : 3;
            __IOM uint8_t DFAE  : 1;   /*!< [3..3] Data Flash Access Error                                            */
            __IM uint8_t  CMDLK : 1;   /*!< [4..4] Command Lock                                                       */
            uint8_t             : 2;
            __IOM uint8_t CFAE  : 1;   /*!< [7..7] Code Flash Access Error                                            */
        } FASTAT_b;
    };
    __IM uint8_t  RESERVED1;
    __IM uint16_t RESERVED2;

    union
    {
        __IOM uint8_t FAEINT;          /*!< (@ 0x00000014) Flash Access Error Interrupt Enable                        */

        struct
        {
            uint8_t               : 3;
            __IOM uint8_t DFAEIE  : 1; /*!< [3..3] Data Flash Access Error Interrupt Enable                           */
            __IOM uint8_t CMDLKIE : 1; /*!< [4..4] Command Lock Interrupt Enable                                      */
            uint8_t               : 2;
            __IOM uint8_t CFAEIE  : 1; /*!< [7..7] Code Flash Access Error Interrupt Enable                           */
        } FAEINT_b;
    };
    __IM uint8_t  RESERVED3;
    __IM uint16_t RESERVED4;

    union
    {
        __IOM uint8_t FRDYIE;          /*!< (@ 0x00000018) Flash Ready Interrupt Enable                               */

        struct
        {
            __IOM uint8_t FRDYIE : 1;  /*!< [0..0] FRDY Interrupt Enable                                              */
            uint8_t              : 7;
        } FRDYIE_b;
    };
    __IM uint8_t  RESERVED5;
    __IM uint16_t RESERVED6;
    __IM uint32_t RESERVED7[5];

    union
    {
        __IOM uint32_t FSADDR;         /*!< (@ 0x00000030) Flash Start Address                                        */

        struct
        {
            __IOM uint32_t FSA : 32;   /*!< [31..0] Start Address of Flash Sequencer Command Target Area
                                        *   These bits can be written when FRDY bit of FSTATR register
                                        *   is '1'. Writing to these bits in FRDY = '0' is ignored.                   */
        } FSADDR_b;
    };

    union
    {
        __IOM uint32_t FEADDR;         /*!< (@ 0x00000034) Flash End Address                                          */

        struct
        {
            __IOM uint32_t FEA : 32;   /*!< [31..0] End Address of Flash Sequencer Command Target Area Specifies
                                        *   end address of target area in 'Blank Check' command. These
                                        *   bits can be written when FRDY bit of FSTATR register is
                                        *   '1'. Writing to these bits in FRDY = '0' is ignored.                      */
        } FEADDR_b;
    };
    __IM uint32_t RESERVED8[3];

    union
    {
        __IOM uint16_t FMEPROT;        /*!< (@ 0x00000044) Flash P/E Mode Entry Protection Register                   */

        struct
        {
            __IOM uint16_t CEPROT : 1; /*!< [0..0] Code Flash P/E Mode Entry ProtectionWriting to this bit
                                        *   is only possible when the FRDY bit in the FSTATR register
                                        *   is 1. Writing to this bit while the FRDY bit = 0 isignored.Writing
                                        *   to this bit is only possible when 16 bits are written and
                                        *   the value written to the KEY bits is D9h.Written values
                                        *   are not retained by these bits (always read as 0x00).Only
                                        *   secure access can write to this register. Both secure access
                                        *   and non-secure read access are allowed. Non-secure writeaccess
                                        *   is denied, but TrustZo                                                    */
            uint16_t          : 7;
            __OM uint16_t KEY : 8;     /*!< [15..8] KEY Code                                                          */
        } FMEPROT_b;
    };
    __IM uint16_t RESERVED9;
    __IM uint32_t RESERVED10[12];

    union
    {
        __IOM uint16_t FBPROT0;        /*!< (@ 0x00000078) Flash Block Protection Register                            */

        struct
        {
            __IOM uint16_t BPCN0 : 1;  /*!< [0..0] Block Protection for Non-secure CancelThis bit can be
                                        *   written when the FRDY bit in the FSTATR register is 1.
                                        *   Writing to this bit is ignored when the FRDY bit is 0.Writing
                                        *   to this bit is only possible when 16 bits are written and
                                        *   the value written to the KEY[7:0] bits is 0x78.Written
                                        *   values are not retained by these bits (always read as 0x00).              */
            uint16_t          : 7;
            __OM uint16_t KEY : 8;     /*!< [15..8] KEY Code                                                          */
        } FBPROT0_b;
    };
    __IM uint16_t RESERVED11;

    union
    {
        __IOM uint16_t FBPROT1;        /*!< (@ 0x0000007C) Flash Block Protection for Secure Register                 */

        struct
        {
            __IOM uint16_t BPCN1 : 1;  /*!< [0..0] Block Protection for Secure CancelWriting to this bit
                                        *   is only possible when the FRDY bit in the FSTATR register
                                        *   is 1. Writing to this bit while FRDY bit = 0 is ignored.Writing
                                        *   to this bit is only possible when 16 bits are written and
                                        *   the value written to the KEY[7:0] bits is 0xB1.Written
                                        *   values are not retained by these bits (always read as 0x00).              */
            uint16_t          : 7;
            __OM uint16_t KEY : 8;     /*!< [15..8] KEY Code                                                          */
        } FBPROT1_b;
    };
    __IM uint16_t RESERVED12;

    union
    {
        __IM uint32_t FSTATR;          /*!< (@ 0x00000080) Flash Status                                               */

        struct
        {
            uint32_t                 : 6;
            __IM uint32_t FLWEERR    : 1; /*!< [6..6] Flash Write/Erase Protect Error Flag                               */
            uint32_t                 : 1;
            __IM uint32_t PRGSPD     : 1; /*!< [8..8] Programming-Suspended Status                                       */
            __IM uint32_t ERSSPD     : 1; /*!< [9..9] Erasure-Suspended Status                                           */
            __IM uint32_t DBFULL     : 1; /*!< [10..10] Data Buffer Full                                                 */
            __IM uint32_t SUSRDY     : 1; /*!< [11..11] Suspend Ready                                                    */
            __IM uint32_t PRGERR     : 1; /*!< [12..12] Programming Error                                                */
            __IM uint32_t ERSERR     : 1; /*!< [13..13] Erasure Error                                                    */
            __IM uint32_t ILGLERR    : 1; /*!< [14..14] Illegal Command Error                                            */
            __IM uint32_t FRDY       : 1; /*!< [15..15] Flash Ready                                                      */
            uint32_t                 : 4;
            __IM uint32_t  OTERR     : 1; /*!< [20..20] Other Error                                                      */
            __IOM uint32_t SECERR    : 1; /*!< [21..21] Security Error                                                   */
            __IM uint32_t  FESETERR  : 1; /*!< [22..22] FENTRY Setting Error                                             */
            __IM uint32_t  ILGCOMERR : 1; /*!< [23..23] Illegal Command Error                                            */
            uint32_t                 : 8;
        } FSTATR_b;
    };

    union
    {
        __IOM uint16_t FENTRYR;         /*!< (@ 0x00000084) Program/Erase Mode Entry                                   */

        struct
        {
            __IOM uint16_t FENTRYC : 1; /*!< [0..0] Code Flash P/E Mode Entry These bits can be written when
                                         *   FRDY bit in FSTATR register is '1'. Writing to this bit
                                         *   in FRDY = '0' is ignored. Writing to these bits is enabled
                                         *   only when this register is accessed in 16-bit size and
                                         *   H'AA is written to KEY bits                                               */
            uint16_t               : 6;
            __IOM uint16_t FENTRYD : 1; /*!< [7..7] Data Flash P/E Mode Entry These bits can be written when
                                         *   FRDY bit in FSTATR register is '1'. Writing to this bit
                                         *   in FRDY = '0' is ignored. Writing to these bits is enabled
                                         *   only when this register is accessed in 16-bit size and
                                         *   H'AA is written to KEY bits.                                              */
            __OM uint16_t KEY : 8;      /*!< [15..8] KEY Code                                                          */
        } FENTRYR_b;
    };
    __IM uint16_t RESERVED13;
    __IM uint32_t RESERVED14;

    union
    {
        __IOM uint16_t FSUINITR;       /*!< (@ 0x0000008C) Flash Sequencer Set-up Initialize                          */

        struct
        {
            __IOM uint16_t SUINIT : 1; /*!< [0..0] Set-up Initialization This bit can be written when FRDY
                                        *   bit of FSTATR register is '1'. Writing to this bit in FRDY
                                        *   = '0' is ignored. Writing to these bits is enabled only
                                        *   when this register is accessed in 16-bit size and H'2D
                                        *   is written to KEY bits.                                                   */
            uint16_t          : 7;
            __OM uint16_t KEY : 8;     /*!< [15..8] KEY Code                                                          */
        } FSUINITR_b;
    };
    __IM uint16_t RESERVED15;
    __IM uint32_t RESERVED16[4];

    union
    {
        __IM uint16_t FCMDR;           /*!< (@ 0x000000A0) Flash Sequencer Command                                    */

        struct
        {
            __IM uint16_t PCMDR : 8;   /*!< [7..0] Previous Command Register                                          */
            __IM uint16_t CMDR  : 8;   /*!< [15..8] Command Register                                                  */
        } FCMDR_b;
    };
    __IM uint16_t RESERVED17;
    __IM uint32_t RESERVED18[11];

    union
    {
        __IOM uint8_t FBCCNT;          /*!< (@ 0x000000D0) Blank Check Control                                        */

        struct
        {
            __IOM uint8_t BCDIR : 1;   /*!< [0..0] Blank Check Direction                                              */
            uint8_t             : 7;
        } FBCCNT_b;
    };
    __IM uint8_t  RESERVED19;
    __IM uint16_t RESERVED20;

    union
    {
        __IM uint8_t FBCSTAT;          /*!< (@ 0x000000D4) Blank Check Status                                         */

        struct
        {
            __IM uint8_t BCST : 1;     /*!< [0..0] Blank Check Status Bit                                             */
            uint8_t           : 7;
        } FBCSTAT_b;
    };
    __IM uint8_t  RESERVED21;
    __IM uint16_t RESERVED22;

    union
    {
        __IM uint32_t FPSADDR;         /*!< (@ 0x000000D8) Programmed Area Start Address                              */

        struct
        {
            __IM uint32_t PSADR : 19;  /*!< [18..0] Programmed Area Start Address NOTE: Indicates address
                                        *   of the first programmed data which is found in 'Blank Check'
                                        *   command execution.                                                        */
            uint32_t : 13;
        } FPSADDR_b;
    };

    union
    {
        __IM uint32_t FAWMON;          /*!< (@ 0x000000DC) Flash Access Window Monitor                                */

        struct
        {
            __IM uint32_t FAWS : 11;   /*!< [10..0] Start Sector Address for Access Window NOTE: These bits
                                        *   indicate the start sector address for setting the access
                                        *   window that is located in the configuration area.                         */
            uint32_t           : 4;
            __IM uint32_t FSPR : 1;    /*!< [15..15] Protection Flag of programming the Access Window, Boot
                                        *   Flag and Temporary Boot Swap Control and 'Config Clear'
                                        *   command execution                                                         */
            __IM uint32_t FAWE : 11;   /*!< [26..16] End Sector Address for Access Window NOTE: These bits
                                        *   indicate the end sector address for setting the access
                                        *   window that is located in the configuration area.                         */
            uint32_t            : 4;
            __IM uint32_t BTFLG : 1;   /*!< [31..31] Flag of Start-Up area select for Boot Swap                       */
        } FAWMON_b;
    };

    union
    {
        __IOM uint16_t FCPSR;           /*!< (@ 0x000000E0) FCU Process Switch                                         */

        struct
        {
            __IOM uint16_t ESUSPMD : 1; /*!< [0..0] Erasure-Suspended Mode                                             */
            uint16_t               : 15;
        } FCPSR_b;
    };
    __IM uint16_t RESERVED23;

    union
    {
        __IOM uint16_t FPCKAR;         /*!< (@ 0x000000E4) Flash Sequencer Processing Clock Frequency Notification    */

        struct
        {
            __IOM uint16_t PCKA : 8;   /*!< [7..0] Flash Sequencer Processing Clock Frequency These bits
                                        *   can be written when FRDY bit in FSTATR register is '1'.
                                        *   Writing to this bit in FRDY = '0' is ignored. Writing to
                                        *   these bits is enabled only when this register is accessed
                                        *   in 16-bit size and H'1E is written to KEY bits.                           */
            __OM uint16_t KEY : 8;     /*!< [15..8] KEY Code                                                          */
        } FPCKAR_b;
    };
    __IM uint16_t RESERVED24;

    union
    {
        __IOM uint16_t FSUACR;         /*!< (@ 0x000000E8) Flash Start-Up Area Control Register                       */

        struct
        {
            __IOM uint16_t SAS : 2;    /*!< [1..0] Start Up Area Select These bits can be written when FRDY
                                        *   bit in FSTATR register is '1'. Writing to this bit in FRDY
                                        *   = '0' is ignored. Writing to these bits is enabled only
                                        *   when this register is accessed in 16-bit size and H'66
                                        *   is written to KEY bits.                                                   */
            uint16_t          : 6;
            __OM uint16_t KEY : 8;     /*!< [15..8] KEY Code                                                          */
        } FSUACR_b;
    };
    __IM uint16_t RESERVED25;
} R_FACI_HP_Type;                      /*!< Size = 236 (0xec)                                                         */

/* =========================================================================================================================== */
/* ================                                         R_FCACHE                                          ================ */
/* =========================================================================================================================== */

/**
 * @brief Flash Memory Cache (R_FCACHE)
 */

typedef struct                         /*!< (@ 0x4001C000) R_FCACHE Structure                                         */
{
    __IM uint16_t RESERVED[128];

    union
    {
        __IOM uint16_t FCACHEE;          /*!< (@ 0x00000100) Flash Cache Enable Register                                */

        struct
        {
            __IOM uint16_t FCACHEEN : 1; /*!< [0..0] FCACHE Enable                                                      */
            uint16_t                : 15;
        } FCACHEE_b;
    };
    __IM uint16_t RESERVED1;

    union
    {
        __IOM uint16_t FCACHEIV;         /*!< (@ 0x00000104) Flash Cache Invalidate Register                            */

        struct
        {
            __IOM uint16_t FCACHEIV : 1; /*!< [0..0] Flash Cache Invalidate Register                                    */
            uint16_t                : 15;
        } FCACHEIV_b;
    };
    __IM uint16_t RESERVED2[11];

    union
    {
        __IOM uint8_t FLWT;            /*!< (@ 0x0000011C) Flash Wait Cycle Register                                  */

        struct
        {
            __IOM uint8_t FLWT : 3;    /*!< [2..0] Flash Wait Cycle                                                   */
            uint8_t            : 5;
        } FLWT_b;
    };
    __IM uint8_t  RESERVED3;
    __IM uint16_t RESERVED4[17];

    union
    {
        __IOM uint16_t FSAR;             /*!< (@ 0x00000140) Flash Security Attribution Register                        */

        struct
        {
            __IOM uint16_t FLWTSA   : 1; /*!< [0..0] FLWT Security Attribution                                          */
            uint16_t                : 7;
            __IOM uint16_t FCKMHZSA : 1; /*!< [8..8] FCKMHZ Security Attribution                                        */
            uint16_t                : 7;
        } FSAR_b;
    };
} R_FCACHE_Type;                         /*!< Size = 322 (0x142)                                                        */

/* =========================================================================================================================== */
/* ================                                          R_GPT0                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief General PWM Timer (R_GPT0)
 */

typedef struct                         /*!< (@ 0x40169000) R_GPT0 Structure                                           */
{
    union
    {
        __IOM uint32_t GTWP;           /*!< (@ 0x00000000) General PWM Timer Write-Protection Register                */

        struct
        {
            __IOM uint32_t WP    : 1;  /*!< [0..0] Register Write Disable                                             */
            __IOM uint32_t STRWP : 1;  /*!< [1..1] GTSTR.CSTRT Bit Write Disable                                      */
            __IOM uint32_t STPWP : 1;  /*!< [2..2] GTSTP.CSTOP Bit Write Disable                                      */
            __IOM uint32_t CLRWP : 1;  /*!< [3..3] GTCLR.CCLR Bit Write Disable                                       */
            __IOM uint32_t CMNWP : 1;  /*!< [4..4] Common Register Write Disabled                                     */
            uint32_t             : 3;
            __OM uint32_t PRKEY  : 8;  /*!< [15..8] GTWP Key Code                                                     */
            uint32_t             : 16;
        } GTWP_b;
    };

    union
    {
        __IOM uint32_t GTSTR;           /*!< (@ 0x00000004) General PWM Timer Software Start Register                  */

        struct
        {
            __IOM uint32_t CSTRT0 : 1;  /*!< [0..0] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT1 : 1;  /*!< [1..1] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT2 : 1;  /*!< [2..2] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT3 : 1;  /*!< [3..3] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT4 : 1;  /*!< [4..4] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT5 : 1;  /*!< [5..5] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT6 : 1;  /*!< [6..6] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT7 : 1;  /*!< [7..7] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT8 : 1;  /*!< [8..8] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT9 : 1;  /*!< [9..9] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT10 : 1; /*!< [10..10] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT11 : 1; /*!< [11..11] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT12 : 1; /*!< [12..12] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT13 : 1; /*!< [13..13] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT14 : 1; /*!< [14..14] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT15 : 1; /*!< [15..15] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT16 : 1; /*!< [16..16] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT17 : 1; /*!< [17..17] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT18 : 1; /*!< [18..18] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT19 : 1; /*!< [19..19] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT20 : 1; /*!< [20..20] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT21 : 1; /*!< [21..21] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT22 : 1; /*!< [22..22] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT23 : 1; /*!< [23..23] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT24 : 1; /*!< [24..24] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT25 : 1; /*!< [25..25] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT26 : 1; /*!< [26..26] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT27 : 1; /*!< [27..27] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT28 : 1; /*!< [28..28] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT29 : 1; /*!< [29..29] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT30 : 1; /*!< [30..30] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT31 : 1; /*!< [31..31] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
        } GTSTR_b;
    };

    union
    {
        __IOM uint32_t GTSTP;           /*!< (@ 0x00000008) General PWM Timer Software Stop Register                   */

        struct
        {
            __IOM uint32_t CSTOP0 : 1;  /*!< [0..0] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP1 : 1;  /*!< [1..1] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP2 : 1;  /*!< [2..2] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP3 : 1;  /*!< [3..3] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP4 : 1;  /*!< [4..4] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP5 : 1;  /*!< [5..5] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP6 : 1;  /*!< [6..6] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP7 : 1;  /*!< [7..7] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP8 : 1;  /*!< [8..8] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP9 : 1;  /*!< [9..9] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP10 : 1; /*!< [10..10] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP11 : 1; /*!< [11..11] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP12 : 1; /*!< [12..12] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP13 : 1; /*!< [13..13] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP14 : 1; /*!< [14..14] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP15 : 1; /*!< [15..15] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP16 : 1; /*!< [16..16] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP17 : 1; /*!< [17..17] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP18 : 1; /*!< [18..18] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP19 : 1; /*!< [19..19] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP20 : 1; /*!< [20..20] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP21 : 1; /*!< [21..21] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP22 : 1; /*!< [22..22] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP23 : 1; /*!< [23..23] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP24 : 1; /*!< [24..24] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP25 : 1; /*!< [25..25] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP26 : 1; /*!< [26..26] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP27 : 1; /*!< [27..27] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP28 : 1; /*!< [28..28] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP29 : 1; /*!< [29..29] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP30 : 1; /*!< [30..30] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP31 : 1; /*!< [31..31] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
        } GTSTP_b;
    };

    union
    {
        __OM uint32_t GTCLR;           /*!< (@ 0x0000000C) General PWM Timer Software Clear Register                  */

        struct
        {
            __OM uint32_t CCLR0  : 1;  /*!< [0..0] Channel GTCNT Count Clear                                          */
            __OM uint32_t CCLR1  : 1;  /*!< [1..1] Channel GTCNT Count Clear                                          */
            __OM uint32_t CCLR2  : 1;  /*!< [2..2] Channel GTCNT Count Clear                                          */
            __OM uint32_t CCLR3  : 1;  /*!< [3..3] Channel GTCNT Count Clear                                          */
            __OM uint32_t CCLR4  : 1;  /*!< [4..4] Channel GTCNT Count Clear                                          */
            __OM uint32_t CCLR5  : 1;  /*!< [5..5] Channel GTCNT Count Clear                                          */
            __OM uint32_t CCLR6  : 1;  /*!< [6..6] Channel GTCNT Count Clear                                          */
            __OM uint32_t CCLR7  : 1;  /*!< [7..7] Channel GTCNT Count Clear                                          */
            __OM uint32_t CCLR8  : 1;  /*!< [8..8] Channel GTCNT Count Clear                                          */
            __OM uint32_t CCLR9  : 1;  /*!< [9..9] Channel GTCNT Count Clear                                          */
            __OM uint32_t CCLR10 : 1;  /*!< [10..10] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR11 : 1;  /*!< [11..11] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR12 : 1;  /*!< [12..12] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR13 : 1;  /*!< [13..13] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR14 : 1;  /*!< [14..14] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR15 : 1;  /*!< [15..15] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR16 : 1;  /*!< [16..16] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR17 : 1;  /*!< [17..17] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR18 : 1;  /*!< [18..18] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR19 : 1;  /*!< [19..19] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR20 : 1;  /*!< [20..20] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR21 : 1;  /*!< [21..21] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR22 : 1;  /*!< [22..22] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR23 : 1;  /*!< [23..23] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR24 : 1;  /*!< [24..24] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR25 : 1;  /*!< [25..25] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR26 : 1;  /*!< [26..26] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR27 : 1;  /*!< [27..27] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR28 : 1;  /*!< [28..28] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR29 : 1;  /*!< [29..29] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR30 : 1;  /*!< [30..30] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR31 : 1;  /*!< [31..31] Channel GTCNT Count Clear                                        */
        } GTCLR_b;
    };

    union
    {
        __IOM uint32_t GTSSR;            /*!< (@ 0x00000010) General PWM Timer Start Source Select Register             */

        struct
        {
            __IOM uint32_t SSGTRGAR : 1; /*!< [0..0] GTETRG Pin Rising Input Source Counter Start Enable                */
            __IOM uint32_t SSGTRGAF : 1; /*!< [1..1] GTETRG Pin Falling Input Source Counter Start Enable               */
            __IOM uint32_t SSGTRGBR : 1; /*!< [2..2] GTETRG Pin Rising Input Source Counter Start Enable                */
            __IOM uint32_t SSGTRGBF : 1; /*!< [3..3] GTETRG Pin Falling Input Source Counter Start Enable               */
            __IOM uint32_t SSGTRGCR : 1; /*!< [4..4] GTETRG Pin Rising Input Source Counter Start Enable                */
            __IOM uint32_t SSGTRGCF : 1; /*!< [5..5] GTETRG Pin Falling Input Source Counter Start Enable               */
            __IOM uint32_t SSGTRGDR : 1; /*!< [6..6] GTETRG Pin Rising Input Source Counter Start Enable                */
            __IOM uint32_t SSGTRGDF : 1; /*!< [7..7] GTETRG Pin Falling Input Source Counter Start Enable               */
            __IOM uint32_t SSCARBL  : 1; /*!< [8..8] GTIOCA Pin Rising Input during GTIOCB Value Low Source
                                          *   Counter Start Enable                                                      */
            __IOM uint32_t SSCARBH : 1;  /*!< [9..9] GTIOCA Pin Rising Input during GTIOCB Value High Source
                                          *   Counter Start Enable                                                      */
            __IOM uint32_t SSCAFBL : 1;  /*!< [10..10] GTIOCA Pin Falling Input during GTIOCB Value Low Source
                                          *   Counter Start Enable                                                      */
            __IOM uint32_t SSCAFBH : 1;  /*!< [11..11] GTIOCA Pin Falling Input during GTIOCB Value High Source
                                          *   Counter Start Enable                                                      */
            __IOM uint32_t SSCBRAL : 1;  /*!< [12..12] GTIOCB Pin Rising Input during GTIOCA Value Low Source
                                          *   Counter Start Enable                                                      */
            __IOM uint32_t SSCBRAH : 1;  /*!< [13..13] GTIOCB Pin Rising Input during GTIOCA Value High Source
                                          *   Counter Start Enable                                                      */
            __IOM uint32_t SSCBFAL : 1;  /*!< [14..14] GTIOCB Pin Falling Input during GTIOCA Value Low Source
                                          *   Counter Start Enable                                                      */
            __IOM uint32_t SSCBFAH : 1;  /*!< [15..15] GTIOCB Pin Falling Input during GTIOCA Value High Source
                                          *   Counter Start Enable                                                      */
            __IOM uint32_t SSELCA : 1;   /*!< [16..16] ELC_GPT Event Source Counter Start Enable                        */
            __IOM uint32_t SSELCB : 1;   /*!< [17..17] ELC_GPT Event Source Counter Start Enable                        */
            __IOM uint32_t SSELCC : 1;   /*!< [18..18] ELC_GPT Event Source Counter Start Enable                        */
            __IOM uint32_t SSELCD : 1;   /*!< [19..19] ELC_GPT Event Source Counter Start Enable                        */
            __IOM uint32_t SSELCE : 1;   /*!< [20..20] ELC_GPT Event Source Counter Start Enable                        */
            __IOM uint32_t SSELCF : 1;   /*!< [21..21] ELC_GPT Event Source Counter Start Enable                        */
            __IOM uint32_t SSELCG : 1;   /*!< [22..22] ELC_GPT Event Source Counter Start Enable                        */
            __IOM uint32_t SSELCH : 1;   /*!< [23..23] ELC_GPT Event Source Counter Start Enable                        */
            uint32_t              : 7;
            __IOM uint32_t CSTRT  : 1;   /*!< [31..31] Software Source Counter Start Enable                             */
        } GTSSR_b;
    };

    union
    {
        __IOM uint32_t GTPSR;            /*!< (@ 0x00000014) General PWM Timer Stop Source Select Register              */

        struct
        {
            __IOM uint32_t PSGTRGAR : 1; /*!< [0..0] GTETRG Pin Rising Input Source Counter Stop Enable                 */
            __IOM uint32_t PSGTRGAF : 1; /*!< [1..1] GTETRG Pin Falling Input Source Counter Stop Enable                */
            __IOM uint32_t PSGTRGBR : 1; /*!< [2..2] GTETRG Pin Rising Input Source Counter Stop Enable                 */
            __IOM uint32_t PSGTRGBF : 1; /*!< [3..3] GTETRG Pin Falling Input Source Counter Stop Enable                */
            __IOM uint32_t PSGTRGCR : 1; /*!< [4..4] GTETRG Pin Rising Input Source Counter Stop Enable                 */
            __IOM uint32_t PSGTRGCF : 1; /*!< [5..5] GTETRG Pin Falling Input Source Counter Stop Enable                */
            __IOM uint32_t PSGTRGDR : 1; /*!< [6..6] GTETRG Pin Rising Input Source Counter Stop Enable                 */
            __IOM uint32_t PSGTRGDF : 1; /*!< [7..7] GTETRG Pin Falling Input Source Counter Stop Enable                */
            __IOM uint32_t PSCARBL  : 1; /*!< [8..8] GTIOCA Pin Rising Input during GTIOCB Value Low Source
                                          *   Counter Stop Enable                                                       */
            __IOM uint32_t PSCARBH : 1;  /*!< [9..9] GTIOCA Pin Rising Input during GTIOCB Value High Source
                                          *   Counter Stop Enable                                                       */
            __IOM uint32_t PSCAFBL : 1;  /*!< [10..10] GTIOCA Pin Falling Input during GTIOCB Value Low Source
                                          *   Counter Stop Enable                                                       */
            __IOM uint32_t PSCAFBH : 1;  /*!< [11..11] GTIOCA Pin Falling Input during GTIOCB Value High Source
                                          *   Counter Stop Enable                                                       */
            __IOM uint32_t PSCBRAL : 1;  /*!< [12..12] GTIOCB Pin Rising Input during GTIOCA Value Low Source
                                          *   Counter Stop Enable                                                       */
            __IOM uint32_t PSCBRAH : 1;  /*!< [13..13] GTIOCB Pin Rising Input during GTIOCA Value High Source
                                          *   Counter Stop Enable                                                       */
            __IOM uint32_t PSCBFAL : 1;  /*!< [14..14] GTIOCB Pin Falling Input during GTIOCA Value Low Source
                                          *   Counter Stop Enable                                                       */
            __IOM uint32_t PSCBFAH : 1;  /*!< [15..15] GTIOCB Pin Falling Input during GTIOCA Value High Source
                                          *   Counter Stop Enable                                                       */
            __IOM uint32_t PSELCA : 1;   /*!< [16..16] ELC_GPTA Event Source Counter Stop Enable                        */
            __IOM uint32_t PSELCB : 1;   /*!< [17..17] ELC_GPTA Event Source Counter Stop Enable                        */
            __IOM uint32_t PSELCC : 1;   /*!< [18..18] ELC_GPTA Event Source Counter Stop Enable                        */
            __IOM uint32_t PSELCD : 1;   /*!< [19..19] ELC_GPTA Event Source Counter Stop Enable                        */
            __IOM uint32_t PSELCE : 1;   /*!< [20..20] ELC_GPTA Event Source Counter Stop Enable                        */
            __IOM uint32_t PSELCF : 1;   /*!< [21..21] ELC_GPTA Event Source Counter Stop Enable                        */
            __IOM uint32_t PSELCG : 1;   /*!< [22..22] ELC_GPTA Event Source Counter Stop Enable                        */
            __IOM uint32_t PSELCH : 1;   /*!< [23..23] ELC_GPTA Event Source Counter Stop Enable                        */
            uint32_t              : 7;
            __IOM uint32_t CSTOP  : 1;   /*!< [31..31] Software Source Counter Stop Enable                              */
        } GTPSR_b;
    };

    union
    {
        __IOM uint32_t GTCSR;            /*!< (@ 0x00000018) General PWM Timer Clear Source Select Register             */

        struct
        {
            __IOM uint32_t CSGTRGAR : 1; /*!< [0..0] GTETRG Pin Rising Input Source Counter Clear Enable                */
            __IOM uint32_t CSGTRGAF : 1; /*!< [1..1] GTETRG Pin Falling Input Source Counter Clear Enable               */
            __IOM uint32_t CSGTRGBR : 1; /*!< [2..2] GTETRG Pin Rising Input Source Counter Clear Enable                */
            __IOM uint32_t CSGTRGBF : 1; /*!< [3..3] GTETRG Pin Falling Input Source Counter Clear Enable               */
            __IOM uint32_t CSGTRGCR : 1; /*!< [4..4] GTETRG Pin Rising Input Source Counter Clear Enable                */
            __IOM uint32_t CSGTRGCF : 1; /*!< [5..5] GTETRG Pin Falling Input Source Counter Clear Enable               */
            __IOM uint32_t CSGTRGDR : 1; /*!< [6..6] GTETRG Pin Rising Input Source Counter Clear Enable                */
            __IOM uint32_t CSGTRGDF : 1; /*!< [7..7] GTETRG Pin Falling Input Source Counter Clear Enable               */
            __IOM uint32_t CSCARBL  : 1; /*!< [8..8] GTIOCA Pin Rising Input during GTIOCB Value Low Source
                                          *   Counter Clear Enable                                                      */
            __IOM uint32_t CSCARBH : 1;  /*!< [9..9] GTIOCA Pin Rising Input during GTIOCB Value High Source
                                          *   Counter Clear Enable                                                      */
            __IOM uint32_t CSCAFBL : 1;  /*!< [10..10] GTIOCA Pin Falling Input during GTIOCB Value Low Source
                                          *   Counter Clear Enable                                                      */
            __IOM uint32_t CSCAFBH : 1;  /*!< [11..11] GTIOCA Pin Falling Input during GTIOCB Value High Source
                                          *   Counter Clear Enable                                                      */
            __IOM uint32_t CSCBRAL : 1;  /*!< [12..12] GTIOCB Pin Rising Input during GTIOCA Value Low Source
                                          *   Counter Clear Enable                                                      */
            __IOM uint32_t CSCBRAH : 1;  /*!< [13..13] GTIOCB Pin Rising Input during GTIOCA Value High Source
                                          *   Counter Clear Enable                                                      */
            __IOM uint32_t CSCBFAL : 1;  /*!< [14..14] GTIOCB Pin Falling Input during GTIOCA Value Low Source
                                          *   Counter Clear Enable                                                      */
            __IOM uint32_t CSCBFAH : 1;  /*!< [15..15] GTIOCB Pin Falling Input during GTIOCA Value High Source
                                          *   Counter Clear Enable                                                      */
            __IOM uint32_t CSELCA : 1;   /*!< [16..16] ELC_GPTA Event Source Counter Clear Enable                       */
            __IOM uint32_t CSELCB : 1;   /*!< [17..17] ELC_GPTA Event Source Counter Clear Enable                       */
            __IOM uint32_t CSELCC : 1;   /*!< [18..18] ELC_GPTA Event Source Counter Clear Enable                       */
            __IOM uint32_t CSELCD : 1;   /*!< [19..19] ELC_GPTA Event Source Counter Clear Enable                       */
            __IOM uint32_t CSELCE : 1;   /*!< [20..20] ELC_GPTA Event Source Counter Clear Enable                       */
            __IOM uint32_t CSELCF : 1;   /*!< [21..21] ELC_GPTA Event Source Counter Clear Enable                       */
            __IOM uint32_t CSELCG : 1;   /*!< [22..22] ELC_GPTA Event Source Counter Clear Enable                       */
            __IOM uint32_t CSELCH : 1;   /*!< [23..23] ELC_GPTA Event Source Counter Clear Enable                       */
            __IOM uint32_t CSCMSC : 3;   /*!< [26..24] Compare Match/Input Capture/Synchronous counter clearing
                                          *   Source Counter Clear Enable.                                              */
            __IOM uint32_t CP1CCE : 1;   /*!< [27..27] Complementary PWM mode1 Crest Source Counter Clear
                                          *   Enable (This bit is only available in GPT324 to GPT329.
                                          *   In GPT320 to GPT323, this bit is read as 0. The write value
                                          *   should be 0.)                                                             */
            uint32_t            : 3;
            __IOM uint32_t CCLR : 1;     /*!< [31..31] Software Source Counter Clear Enable                             */
        } GTCSR_b;
    };

    union
    {
        __IOM uint32_t GTUPSR;           /*!< (@ 0x0000001C) General PWM Timer Up Count Source Select Register          */

        struct
        {
            __IOM uint32_t USGTRGAR : 1; /*!< [0..0] GTETRG Pin Rising Input Source Counter Count Up Enable             */
            __IOM uint32_t USGTRGAF : 1; /*!< [1..1] GTETRG Pin Falling Input Source Counter Count Up Enable            */
            __IOM uint32_t USGTRGBR : 1; /*!< [2..2] GTETRG Pin Rising Input Source Counter Count Up Enable             */
            __IOM uint32_t USGTRGBF : 1; /*!< [3..3] GTETRG Pin Falling Input Source Counter Count Up Enable            */
            __IOM uint32_t USGTRGCR : 1; /*!< [4..4] GTETRG Pin Rising Input Source Counter Count Up Enable             */
            __IOM uint32_t USGTRGCF : 1; /*!< [5..5] GTETRG Pin Falling Input Source Counter Count Up Enable            */
            __IOM uint32_t USGTRGDR : 1; /*!< [6..6] GTETRG Pin Rising Input Source Counter Count Up Enable             */
            __IOM uint32_t USGTRGDF : 1; /*!< [7..7] GTETRG Pin Falling Input Source Counter Count Up Enable            */
            __IOM uint32_t USCARBL  : 1; /*!< [8..8] GTIOCA Pin Rising Input during GTIOCB Value Low Source
                                          *   Counter Count Up Enable                                                   */
            __IOM uint32_t USCARBH : 1;  /*!< [9..9] GTIOCA Pin Rising Input during GTIOCB Value High Source
                                          *   Counter Count Up Enable                                                   */
            __IOM uint32_t USCAFBL : 1;  /*!< [10..10] GTIOCA Pin Falling Input during GTIOCB Value Low Source
                                          *   Counter Count Up Enable                                                   */
            __IOM uint32_t USCAFBH : 1;  /*!< [11..11] GTIOCA Pin Falling Input during GTIOCB Value High Source
                                          *   Counter Count Up Enable                                                   */
            __IOM uint32_t USCBRAL : 1;  /*!< [12..12] GTIOCB Pin Rising Input during GTIOCA Value Low Source
                                          *   Counter Count Up Enable                                                   */
            __IOM uint32_t USCBRAH : 1;  /*!< [13..13] GTIOCB Pin Rising Input during GTIOCA Value High Source
                                          *   Counter Count Up Enable                                                   */
            __IOM uint32_t USCBFAL : 1;  /*!< [14..14] GTIOCB Pin Falling Input during GTIOCA Value Low Source
                                          *   Counter Count Up Enable                                                   */
            __IOM uint32_t USCBFAH : 1;  /*!< [15..15] GTIOCB Pin Falling Input during GTIOCA Value High Source
                                          *   Counter Count Up Enable                                                   */
            __IOM uint32_t USELCA : 1;   /*!< [16..16] ELC_GPT Event Source Counter Count Up Enable                     */
            __IOM uint32_t USELCB : 1;   /*!< [17..17] ELC_GPT Event Source Counter Count Up Enable                     */
            __IOM uint32_t USELCC : 1;   /*!< [18..18] ELC_GPT Event Source Counter Count Up Enable                     */
            __IOM uint32_t USELCD : 1;   /*!< [19..19] ELC_GPT Event Source Counter Count Up Enable                     */
            __IOM uint32_t USELCE : 1;   /*!< [20..20] ELC_GPT Event Source Counter Count Up Enable                     */
            __IOM uint32_t USELCF : 1;   /*!< [21..21] ELC_GPT Event Source Counter Count Up Enable                     */
            __IOM uint32_t USELCG : 1;   /*!< [22..22] ELC_GPT Event Source Counter Count Up Enable                     */
            __IOM uint32_t USELCH : 1;   /*!< [23..23] ELC_GPT Event Source Counter Count Up Enable                     */
            __IOM uint32_t USILVL : 4;   /*!< [27..24] External Input Level Source Count-Up Enable                      */
            uint32_t              : 4;
        } GTUPSR_b;
    };

    union
    {
        __IOM uint32_t GTDNSR;           /*!< (@ 0x00000020) General PWM Timer Down Count Source Select Register        */

        struct
        {
            __IOM uint32_t DSGTRGAR : 1; /*!< [0..0] GTETRG Pin Rising Input Source Counter Count Down Enable           */
            __IOM uint32_t DSGTRGAF : 1; /*!< [1..1] GTETRG Pin Falling Input Source Counter Count Down Enable          */
            __IOM uint32_t DSGTRGBR : 1; /*!< [2..2] GTETRG Pin Rising Input Source Counter Count Down Enable           */
            __IOM uint32_t DSGTRGBF : 1; /*!< [3..3] GTETRG Pin Falling Input Source Counter Count Down Enable          */
            __IOM uint32_t DSGTRGCR : 1; /*!< [4..4] GTETRG Pin Rising Input Source Counter Count Down Enable           */
            __IOM uint32_t DSGTRGCF : 1; /*!< [5..5] GTETRG Pin Falling Input Source Counter Count Down Enable          */
            __IOM uint32_t DSGTRGDR : 1; /*!< [6..6] GTETRG Pin Rising Input Source Counter Count Down Enable           */
            __IOM uint32_t DSGTRGDF : 1; /*!< [7..7] GTETRG Pin Falling Input Source Counter Count Down Enable          */
            __IOM uint32_t DSCARBL  : 1; /*!< [8..8] GTIOCA Pin Rising Input during GTIOCB Value Low Source
                                          *   Counter Count Down Enable                                                 */
            __IOM uint32_t DSCARBH : 1;  /*!< [9..9] GTIOCA Pin Rising Input during GTIOCB Value High Source
                                          *   Counter Count Down Enable                                                 */
            __IOM uint32_t DSCAFBL : 1;  /*!< [10..10] GTIOCA Pin Falling Input during GTIOCB Value Low Source
                                          *   Counter Count Down Enable                                                 */
            __IOM uint32_t DSCAFBH : 1;  /*!< [11..11] GTIOCA Pin Falling Input during GTIOCB Value High Source
                                          *   Counter Count Down Enable                                                 */
            __IOM uint32_t DSCBRAL : 1;  /*!< [12..12] GTIOCB Pin Rising Input during GTIOCA Value Low Source
                                          *   Counter Count Down Enable                                                 */
            __IOM uint32_t DSCBRAH : 1;  /*!< [13..13] GTIOCB Pin Rising Input during GTIOCA Value High Source
                                          *   Counter Count Down Enable                                                 */
            __IOM uint32_t DSCBFAL : 1;  /*!< [14..14] GTIOCB Pin Falling Input during GTIOCA Value Low Source
                                          *   Counter Count Down Enable                                                 */
            __IOM uint32_t DSCBFAH : 1;  /*!< [15..15] GTIOCB Pin Falling Input during GTIOCA Value High Source
                                          *   Counter Count Down Enable                                                 */
            __IOM uint32_t DSELCA : 1;   /*!< [16..16] ELC_GPT Event Source Counter Count Down Enable                   */
            __IOM uint32_t DSELCB : 1;   /*!< [17..17] ELC_GPT Event Source Counter Count Down Enable                   */
            __IOM uint32_t DSELCC : 1;   /*!< [18..18] ELC_GPT Event Source Counter Count Down Enable                   */
            __IOM uint32_t DSELCD : 1;   /*!< [19..19] ELC_GPT Event Source Counter Count Down Enable                   */
            __IOM uint32_t DSELCE : 1;   /*!< [20..20] ELC_GPT Event Source Counter Count Down Enable                   */
            __IOM uint32_t DSELCF : 1;   /*!< [21..21] ELC_GPT Event Source Counter Count Down Enable                   */
            __IOM uint32_t DSELCG : 1;   /*!< [22..22] ELC_GPT Event Source Counter Count Down Enable                   */
            __IOM uint32_t DSELCH : 1;   /*!< [23..23] ELC_GPT Event Source Counter Count Down Enable                   */
            __IOM uint32_t DSILVL : 4;   /*!< [27..24] External Input Level Source Count-Down Enable                    */
            uint32_t              : 4;
        } GTDNSR_b;
    };

    union
    {
        __IOM uint32_t GTICASR;          /*!< (@ 0x00000024) General PWM Timer Input Capture Source Select
                                          *                  Register A                                                 */

        struct
        {
            __IOM uint32_t ASGTRGAR : 1; /*!< [0..0] GTETRG Pin Rising Input Source GTCCRA Input Capture Enable         */
            __IOM uint32_t ASGTRGAF : 1; /*!< [1..1] GTETRG Pin Falling Input Source GTCCRA Input Capture
                                          *   Enable                                                                    */
            __IOM uint32_t ASGTRGBR : 1; /*!< [2..2] GTETRG Pin Rising Input Source GTCCRA Input Capture Enable         */
            __IOM uint32_t ASGTRGBF : 1; /*!< [3..3] GTETRG Pin Falling Input Source GTCCRA Input Capture
                                          *   Enable                                                                    */
            __IOM uint32_t ASGTRGCR : 1; /*!< [4..4] GTETRG Pin Rising Input Source GTCCRA Input Capture Enable         */
            __IOM uint32_t ASGTRGCF : 1; /*!< [5..5] GTETRG Pin Falling Input Source GTCCRA Input Capture
                                          *   Enable                                                                    */
            __IOM uint32_t ASGTRGDR : 1; /*!< [6..6] GTETRG Pin Rising Input Source GTCCRA Input Capture Enable         */
            __IOM uint32_t ASGTRGDF : 1; /*!< [7..7] GTETRG Pin Falling Input Source GTCCRA Input Capture
                                          *   Enable                                                                    */
            __IOM uint32_t ASCARBL : 1;  /*!< [8..8] GTIOCA Pin Rising Input during GTIOCB Value Low Source
                                          *   GTCCRA Input Capture Enable                                               */
            __IOM uint32_t ASCARBH : 1;  /*!< [9..9] GTIOCA Pin Rising Input during GTIOCB Value High Source
                                          *   GTCCRA Input Capture Enable                                               */
            __IOM uint32_t ASCAFBL : 1;  /*!< [10..10] GTIOCA Pin Falling Input during GTIOCB Value Low Source
                                          *   GTCCRA Input Capture Enable                                               */
            __IOM uint32_t ASCAFBH : 1;  /*!< [11..11] GTIOCA Pin Falling Input during GTIOCB Value High Source
                                          *   GTCCRA Input Capture Enable                                               */
            __IOM uint32_t ASCBRAL : 1;  /*!< [12..12] GTIOCB Pin Rising Input during GTIOCA Value Low Source
                                          *   GTCCRA Input Capture Enable                                               */
            __IOM uint32_t ASCBRAH : 1;  /*!< [13..13] GTIOCB Pin Rising Input during GTIOCA Value High Source
                                          *   GTCCRA Input Capture Enable                                               */
            __IOM uint32_t ASCBFAL : 1;  /*!< [14..14] GTIOCB Pin Falling Input during GTIOCA Value Low Source
                                          *   GTCCRA Input Capture Enable                                               */
            __IOM uint32_t ASCBFAH : 1;  /*!< [15..15] GTIOCB Pin Falling Input during GTIOCA Value High Source
                                          *   GTCCRA Input Capture Enable                                               */
            __IOM uint32_t ASELCA : 1;   /*!< [16..16] ELC_GPT Event Source GTCCRA Input Capture Enable                 */
            __IOM uint32_t ASELCB : 1;   /*!< [17..17] ELC_GPT Event Source GTCCRA Input Capture Enable                 */
            __IOM uint32_t ASELCC : 1;   /*!< [18..18] ELC_GPT Event Source GTCCRA Input Capture Enable                 */
            __IOM uint32_t ASELCD : 1;   /*!< [19..19] ELC_GPT Event Source GTCCRA Input Capture Enable                 */
            __IOM uint32_t ASELCE : 1;   /*!< [20..20] ELC_GPT Event Source GTCCRA Input Capture Enable                 */
            __IOM uint32_t ASELCF : 1;   /*!< [21..21] ELC_GPT Event Source GTCCRA Input Capture Enable                 */
            __IOM uint32_t ASELCG : 1;   /*!< [22..22] ELC_GPT Event Source GTCCRA Input Capture Enable                 */
            __IOM uint32_t ASELCH : 1;   /*!< [23..23] ELC_GPT Event Source GTCCRA Input Capture Enable                 */
            uint32_t              : 8;
        } GTICASR_b;
    };

    union
    {
        __IOM uint32_t GTICBSR;          /*!< (@ 0x00000028) General PWM Timer Input Capture Source Select
                                          *                  Register B                                                 */

        struct
        {
            __IOM uint32_t BSGTRGAR : 1; /*!< [0..0] GTETRG Pin Rising Input Source GTCCRB Input Capture Enable         */
            __IOM uint32_t BSGTRGAF : 1; /*!< [1..1] GTETRG Pin Falling Input Source GTCCRB Input Capture
                                          *   Enable                                                                    */
            __IOM uint32_t BSGTRGBR : 1; /*!< [2..2] GTETRG Pin Rising Input Source GTCCRB Input Capture Enable         */
            __IOM uint32_t BSGTRGBF : 1; /*!< [3..3] GTETRG Pin Falling Input Source GTCCRB Input Capture
                                          *   Enable                                                                    */
            __IOM uint32_t BSGTRGCR : 1; /*!< [4..4] GTETRG Pin Rising Input Source GTCCRB Input Capture Enable         */
            __IOM uint32_t BSGTRGCF : 1; /*!< [5..5] GTETRG Pin Falling Input Source GTCCRB Input Capture
                                          *   Enable                                                                    */
            __IOM uint32_t BSGTRGDR : 1; /*!< [6..6] GTETRG Pin Rising Input Source GTCCRB Input Capture Enable         */
            __IOM uint32_t BSGTRGDF : 1; /*!< [7..7] GTETRG Pin Falling Input Source GTCCRB Input Capture
                                          *   Enable                                                                    */
            __IOM uint32_t BSCARBL : 1;  /*!< [8..8] GTIOCA Pin Rising Input during GTIOCB Value Low Source
                                          *   GTCCRB Input Capture Enable                                               */
            __IOM uint32_t BSCARBH : 1;  /*!< [9..9] GTIOCA Pin Rising Input during GTIOCB Value High Source
                                          *   GTCCRB Input Capture Enable                                               */
            __IOM uint32_t BSCAFBL : 1;  /*!< [10..10] GTIOCA Pin Falling Input during GTIOCB Value Low Source
                                          *   GTCCRB Input Capture Enable                                               */
            __IOM uint32_t BSCAFBH : 1;  /*!< [11..11] GTIOCA Pin Falling Input during GTIOCB Value High Source
                                          *   GTCCRB Input Capture Enable                                               */
            __IOM uint32_t BSCBRAL : 1;  /*!< [12..12] GTIOCB Pin Rising Input during GTIOCA Value Low Source
                                          *   GTCCRB Input Capture Enable                                               */
            __IOM uint32_t BSCBRAH : 1;  /*!< [13..13] GTIOCB Pin Rising Input during GTIOCA Value High Source
                                          *   GTCCRB Input Capture Enable                                               */
            __IOM uint32_t BSCBFAL : 1;  /*!< [14..14] GTIOCB Pin Falling Input during GTIOCA Value Low Source
                                          *   GTCCRB Input Capture Enable                                               */
            __IOM uint32_t BSCBFAH : 1;  /*!< [15..15] GTIOCB Pin Falling Input during GTIOCA Value High Source
                                          *   GTCCRB Input Capture Enable                                               */
            __IOM uint32_t BSELCA : 1;   /*!< [16..16] ELC_GPT Event Source GTCCRB Input Capture Enable                 */
            __IOM uint32_t BSELCB : 1;   /*!< [17..17] ELC_GPT Event Source GTCCRB Input Capture Enable                 */
            __IOM uint32_t BSELCC : 1;   /*!< [18..18] ELC_GPT Event Source GTCCRB Input Capture Enable                 */
            __IOM uint32_t BSELCD : 1;   /*!< [19..19] ELC_GPT Event Source GTCCRB Input Capture Enable                 */
            __IOM uint32_t BSELCE : 1;   /*!< [20..20] ELC_GPT Event Source GTCCRB Input Capture Enable                 */
            __IOM uint32_t BSELCF : 1;   /*!< [21..21] ELC_GPT Event Source GTCCRB Input Capture Enable                 */
            __IOM uint32_t BSELCG : 1;   /*!< [22..22] ELC_GPT Event Source GTCCRB Input Capture Enable                 */
            __IOM uint32_t BSELCH : 1;   /*!< [23..23] ELC_GPT Event Source GTCCRB Input Capture Enable                 */
            uint32_t              : 8;
        } GTICBSR_b;
    };

    union
    {
        __IOM uint32_t GTCR;            /*!< (@ 0x0000002C) General PWM Timer Control Register                         */

        struct
        {
            __IOM uint32_t CST     : 1; /*!< [0..0] Count Start                                                        */
            uint32_t               : 7;
            __IOM uint32_t ICDS    : 1; /*!< [8..8] Input Capture Operation Select During Count Stop                   */
            __IOM uint32_t SCGTIOC : 1; /*!< [9..9] GTIOC input Source Synchronous Clear Enable                        */
            __IOM uint32_t SSCGRP  : 2; /*!< [11..10] Synchronous Set/Clear Group Select                               */
            __IOM uint32_t CPSCD   : 1; /*!< [12..12] Complementary PWM Mode Synchronous Clear Disable                 */
            uint32_t               : 2;
            __IOM uint32_t SSCEN   : 1; /*!< [15..15] Synchronous Set/Clear Enable                                     */
            __IOM uint32_t MD      : 4; /*!< [19..16] Mode Select                                                      */
            uint32_t               : 3;
            __IOM uint32_t TPCS    : 4; /*!< [26..23] Timer Prescaler Select                                           */
            __IOM uint32_t CKEG    : 2; /*!< [28..27] Clock Edge Select                                                */
            uint32_t               : 3;
        } GTCR_b;
    };

    union
    {
        __IOM uint32_t GTUDDTYC;       /*!< (@ 0x00000030) General PWM Timer Count Direction and Duty Setting
                                        *                  Register                                                   */

        struct
        {
            __IOM uint32_t UD     : 1; /*!< [0..0] Count Direction Setting                                            */
            __IOM uint32_t UDF    : 1; /*!< [1..1] Forcible Count Direction Setting                                   */
            uint32_t              : 14;
            __IOM uint32_t OADTY  : 2; /*!< [17..16] GTIOCA Output Duty Setting                                       */
            __IOM uint32_t OADTYF : 1; /*!< [18..18] Forcible GTIOCA Output Duty Setting                              */
            __IOM uint32_t OADTYR : 1; /*!< [19..19] GTIOCA Output Value Selecting after Releasing 0 percent/100
                                        *   percent Duty Setting                                                      */
            uint32_t              : 4;
            __IOM uint32_t OBDTY  : 2; /*!< [25..24] GTIOCB Output Duty Setting                                       */
            __IOM uint32_t OBDTYF : 1; /*!< [26..26] Forcible GTIOCB Output Duty Setting                              */
            __IOM uint32_t OBDTYR : 1; /*!< [27..27] GTIOCB Output Value Selecting after Releasing 0 percent/100
                                        *   percent Duty Setting                                                      */
            uint32_t : 4;
        } GTUDDTYC_b;
    };

    union
    {
        __IOM uint32_t GTIOR;          /*!< (@ 0x00000034) General PWM Timer I/O Control Register                     */

        struct
        {
            __IOM uint32_t GTIOA  : 5; /*!< [4..0] GTIOCA Pin Function Select                                         */
            __IOM uint32_t CPSCIR : 1; /*!< [5..5] Complementary PWM Mode Initial Output at Synchronous
                                        *   Clear Disable.(This bit is only available in GPT324 to
                                        *   GPT329. In GPT320 to GPT323, this bit is read as 0. The
                                        *   write value should be 0.)                                                 */
            __IOM uint32_t OADFLT : 1; /*!< [6..6] GTIOCA Pin Output Value Setting at the Count Stop                  */
            __IOM uint32_t OAHLD  : 1; /*!< [7..7] GTIOCA Pin Output Setting at the Start/Stop Count                  */
            __IOM uint32_t OAE    : 1; /*!< [8..8] GTIOCA Pin Output Enable                                           */
            __IOM uint32_t OADF   : 2; /*!< [10..9] GTIOCA Pin Disable Value Setting                                  */
            __IOM uint32_t OAEOCD : 1; /*!< [11..11] GTCCRA Compare Match Cycle End Output Invalidate.(This
                                        *   bit is only available in GPT324 to GPT329. In GPT320 to
                                        *   GPT323, this bit is read as 0. The write value should be
                                        *   0.)                                                                       */
            __IOM uint32_t PSYE   : 1; /*!< [12..12] PWM Synchronous output Enable                                    */
            __IOM uint32_t NFAEN  : 1; /*!< [13..13] Noise Filter A Enable                                            */
            __IOM uint32_t NFCSA  : 2; /*!< [15..14] Noise Filter A Sampling Clock Select                             */
            __IOM uint32_t GTIOB  : 5; /*!< [20..16] GTIOCB Pin Function Select                                       */
            uint32_t              : 1;
            __IOM uint32_t OBDFLT : 1; /*!< [22..22] GTIOCB Pin Output Value Setting at the Count Stop                */
            __IOM uint32_t OBHLD  : 1; /*!< [23..23] GTIOCB Pin Output Setting at the Start/Stop Count                */
            __IOM uint32_t OBE    : 1; /*!< [24..24] GTIOCB Pin Output Enable                                         */
            __IOM uint32_t OBDF   : 2; /*!< [26..25] GTIOCB Pin Disable Value Setting                                 */
            __IOM uint32_t OBEOCD : 1; /*!< [27..27] GTCCRB Compare Match Cycle End Output Invalidate.(This
                                        *   bit is only available in GPT324 to GPT329. In GPT320 to
                                        *   GPT323, this bit is read as 0. The write value should be
                                        *   0.)                                                                       */
            uint32_t             : 1;
            __IOM uint32_t NFBEN : 1;  /*!< [29..29] Noise Filter B Enable                                            */
            __IOM uint32_t NFCSB : 2;  /*!< [31..30] Noise Filter B Sampling Clock Select                             */
        } GTIOR_b;
    };

    union
    {
        __IOM uint32_t GTINTAD;        /*!< (@ 0x00000038) General PWM Timer Interrupt Output Setting Register        */

        struct
        {
            uint32_t            : 8;
            __IOM uint32_t SCFA : 1;     /*!< [8..8] GTCCRn Register Compare Match/Input Capture Source Synchronous
                                          *   Clear Enable                                                              */
            __IOM uint32_t SCFB : 1;     /*!< [9..9] GTCCRn Register Compare Match/Input Capture Source Synchronous
                                          *   Clear Enable                                                              */
            __IOM uint32_t SCFC : 1;     /*!< [10..10] GTCCRn Register Compare Match/Input Capture Source
                                          *   Synchronous Clear Enable                                                  */
            __IOM uint32_t SCFD : 1;     /*!< [11..11] GTCCRn Register Compare Match/Input Capture Source
                                          *   Synchronous Clear Enable                                                  */
            __IOM uint32_t SCFE : 1;     /*!< [12..12] GTCCRn Register Compare Match/Input Capture Source
                                          *   Synchronous Clear Enable                                                  */
            __IOM uint32_t SCFF : 1;     /*!< [13..13] GTCCRn Register Compare Match/Input Capture Source
                                          *   Synchronous Clear Enable                                                  */
            __IOM uint32_t SCFPO    : 1; /*!< [14..14] Overflow Source Synchronous Clear Enable                         */
            __IOM uint32_t SCFPU    : 1; /*!< [15..15] Underflow Source Synchronous Clear Enable                        */
            __IOM uint32_t ADTRAUEN : 1; /*!< [16..16] GTADTRn Register Compare Match (Up-Counting) A/D Conversion
                                          *   Start Request Enable                                                      */
            __IOM uint32_t ADTRADEN : 1; /*!< [17..17] GTADTRn Register Compare Match (Down-Counting) A/D
                                          *   Conversion Start Request Enable                                           */
            __IOM uint32_t ADTRBUEN : 1; /*!< [18..18] GTADTRn Register Compare Match (Up-Counting) A/D Conversion
                                          *   Start Request Enable                                                      */
            __IOM uint32_t ADTRBDEN : 1; /*!< [19..19] GTADTRn Register Compare Match (Down-Counting) A/D
                                          *   Conversion Start Request Enable                                           */
            uint32_t               : 4;
            __IOM uint32_t GRP     : 2;  /*!< [25..24] Output Disable Source Select                                     */
            uint32_t               : 2;
            __IOM uint32_t GRPDTE  : 1;  /*!< [28..28] Dead Time Error Output Disable Request Enable                    */
            __IOM uint32_t GRPABH  : 1;  /*!< [29..29] Same Time Output Level High Disable Request Enable               */
            __IOM uint32_t GRPABL  : 1;  /*!< [30..30] Same Time Output Level Low Disable Request Enable                */
            __IOM uint32_t GTINTPC : 1;  /*!< [31..31] Period Count Function Finish Interrupt Enable                    */
        } GTINTAD_b;
    };

    union
    {
        __IOM uint32_t GTST;            /*!< (@ 0x0000003C) General PWM Timer Status Register                          */

        struct
        {
            __IOM uint32_t TCFA  : 1;   /*!< [0..0] Input Capture/Compare Match Flag A                                 */
            __IOM uint32_t TCFB  : 1;   /*!< [1..1] Input Capture/Compare Match Flag B                                 */
            __IOM uint32_t TCFC  : 1;   /*!< [2..2] Input Compare Match Flag C                                         */
            __IOM uint32_t TCFD  : 1;   /*!< [3..3] Input Compare Match Flag D                                         */
            __IOM uint32_t TCFE  : 1;   /*!< [4..4] Input Compare Match Flag E                                         */
            __IOM uint32_t TCFF  : 1;   /*!< [5..5] Input Compare Match Flag F                                         */
            __IOM uint32_t TCFPO : 1;   /*!< [6..6] Overflow Flag                                                      */
            __IOM uint32_t TCFPU : 1;   /*!< [7..7] Underflow Flag                                                     */
            __IM uint32_t  ITCNT : 3;   /*!< [10..8] GTCIV/GTCIU Interrupt Skipping Count Counter(Counter
                                         *   for counting the number of times a timer interrupt has
                                         *   been skipped.)                                                            */
            uint32_t               : 4;
            __IM uint32_t  TUCF    : 1; /*!< [15..15] Count Direction Flag                                             */
            __IOM uint32_t ADTRAUF : 1; /*!< [16..16] GTADTRA Compare Match (Up-Counting) A/D Converter Start
                                         *   Request Interrupt Enable                                                  */
            __IOM uint32_t ADTRADF : 1; /*!< [17..17] GTADTRA Compare Match(Down-Counting) A/D Convertor
                                         *   Start Request Flag                                                        */
            __IOM uint32_t ADTRBUF : 1; /*!< [18..18] GTADTRB Compare Match(Up-Counting) A/D Convertor Start
                                         *   Request Flag                                                              */
            __IOM uint32_t ADTRBDF : 1; /*!< [19..19] GTADTRB Compare Match(Down-Counting) A/D Convertor
                                         *   Start Request Flag                                                        */
            uint32_t             : 4;
            __IM uint32_t ODF    : 1;   /*!< [24..24] Output Disable Flag                                              */
            uint32_t             : 3;
            __IM uint32_t  DTEF  : 1;   /*!< [28..28] Dead Time Error Flag                                             */
            __IM uint32_t  OABHF : 1;   /*!< [29..29] Same Time Output Level High Disable Request Enable               */
            __IM uint32_t  OABLF : 1;   /*!< [30..30] Same Time Output Level Low Disable Request Enable                */
            __IOM uint32_t PCF   : 1;   /*!< [31..31] Period Count Function Finish Flag                                */
        } GTST_b;
    };

    union
    {
        __IOM uint32_t GTBER;           /*!< (@ 0x00000040) General PWM Timer Buffer Enable Register                   */

        struct
        {
            __IOM uint32_t BD0     : 1; /*!< [0..0] BD[0]: GTCCR Buffer Operation Disable                              */
            __IOM uint32_t BD1     : 1; /*!< [1..1] BD[1]: GTPR Buffer Operation Disable                               */
            __IOM uint32_t BD2     : 1; /*!< [2..2] BD[2]: GTADTR Buffer Operation DisableBD                           */
            __IOM uint32_t BD3     : 1; /*!< [3..3] BD[3]: GTDV Buffer Operation DisableBD[2]                          */
            uint32_t               : 4;
            __IOM uint32_t DBRTECA : 1; /*!< [8..8] GTCCRn Register Double Buffer Repeat Operation Enable              */
            uint32_t               : 1;
            __IOM uint32_t DBRTECB : 1; /*!< [10..10] GTCCRn Register Double Buffer Repeat Operation Enable            */
            uint32_t               : 5;
            __IOM uint32_t CCRA    : 2; /*!< [17..16] GTCCRA Buffer Operation                                          */
            __IOM uint32_t CCRB    : 2; /*!< [19..18] GTCCRB Buffer Operation                                          */
            __IOM uint32_t PR      : 2; /*!< [21..20] GTPR Buffer Operation                                            */
            __OM uint32_t  CCRSWT  : 1; /*!< [22..22] GTCCRA and GTCCRB Forcible Buffer OperationThis bit
                                         *   is read as 0.                                                             */
            uint32_t             : 1;
            __IOM uint32_t ADTTA : 2;   /*!< [25..24] GTADTRA Buffer Transfer Timing Select in the Triangle
                                         *   wavesNOTE: In the Saw waves, values other than 0 0: Transfer
                                         *   at an underflow (in down-counting) or overflow (in up-counting)
                                         *   is performed.                                                             */
            __IOM uint32_t ADTDA : 1;   /*!< [26..26] GTADTRA Double Buffer Operation                                  */
            uint32_t             : 1;
            __IOM uint32_t ADTTB : 2;   /*!< [29..28] GTADTRB Buffer Transfer Timing Select in the Triangle
                                         *   wavesNOTE: In the Saw waves, values other than 0 0: Transfer
                                         *   at an underflow (in down-counting) or overflow (in up-counting)
                                         *   is performed.                                                             */
            __IOM uint32_t ADTDB : 1;   /*!< [30..30] GTADTRB Double Buffer Operation                                  */
            uint32_t             : 1;
        } GTBER_b;
    };

    union
    {
        __IOM uint32_t GTITC;          /*!< (@ 0x00000044) General PWM Timer Interrupt and A/D Converter
                                        *                  Start Request Skipping Setting Register                    */

        struct
        {
            __IOM uint32_t ITLA  : 1;  /*!< [0..0] GTCCRA Compare Match/Input Capture Interrupt Link                  */
            __IOM uint32_t ITLB  : 1;  /*!< [1..1] GTCCRB Compare Match/Input Capture Interrupt Link                  */
            __IOM uint32_t ITLC  : 1;  /*!< [2..2] GTCCRC Compare Match Interrupt Link                                */
            __IOM uint32_t ITLD  : 1;  /*!< [3..3] GTCCRD Compare Match Interrupt Link                                */
            __IOM uint32_t ITLE  : 1;  /*!< [4..4] GTCCRE Compare Match Interrupt Link                                */
            __IOM uint32_t ITLF  : 1;  /*!< [5..5] GTCCRF Compare Match Interrupt Link                                */
            __IOM uint32_t IVTC  : 2;  /*!< [7..6] GPT_OVF/GPT_UDF Interrupt Skipping Function Select                 */
            __IOM uint32_t IVTT  : 3;  /*!< [10..8] GPT_OVF/GPT_UDF Interrupt Skipping Count Select                   */
            uint32_t             : 1;
            __IOM uint32_t ADTAL : 1;  /*!< [12..12] GTADTRA A/D Converter Start Request Link                         */
            uint32_t             : 1;
            __IOM uint32_t ADTBL : 1;  /*!< [14..14] GTADTRB A/D Converter Start Request Link                         */
            uint32_t             : 17;
        } GTITC_b;
    };

    union
    {
        __IOM uint32_t GTCNT;          /*!< (@ 0x00000048) General PWM Timer Counter                                  */

        struct
        {
            __IOM uint32_t GTCNT : 32; /*!< [31..0] Counter                                                           */
        } GTCNT_b;
    };

    union
    {
        __IOM uint32_t GTCCR[6];       /*!< (@ 0x0000004C) General PWM Timer Compare Capture Register                 */

        struct
        {
            __IOM uint32_t GTCCR : 32; /*!< [31..0] Compare Capture Register A                                        */
        } GTCCR_b[6];
    };

    union
    {
        __IOM uint32_t GTPR;           /*!< (@ 0x00000064) General PWM Timer Cycle Setting Register                   */

        struct
        {
            __IOM uint32_t GTPR : 32;  /*!< [31..0] Cycle Setting Register                                            */
        } GTPR_b;
    };

    union
    {
        __IOM uint32_t GTPBR;          /*!< (@ 0x00000068) General PWM Timer Cycle Setting Buffer Register            */

        struct
        {
            __IOM uint32_t GTPBR : 32; /*!< [31..0] Cycle Setting Buffer Register                                     */
        } GTPBR_b;
    };

    union
    {
        __IOM uint32_t GTPDBR;          /*!< (@ 0x0000006C) General PWM Timer Cycle Setting Double-Buffer
                                         *                  Register                                                   */

        struct
        {
            __IOM uint32_t GTPDBR : 32; /*!< [31..0] Cycle Setting Double-Buffer Register                              */
        } GTPDBR_b;
    };

    union
    {
        __IOM uint32_t GTADTRA;          /*!< (@ 0x00000070) A/D Converter Start Request Timing Register A              */

        struct
        {
            __IOM uint32_t GTADTRA : 32; /*!< [31..0] A/D Converter Start Request Timing Register A                     */
        } GTADTRA_b;
    };

    union
    {
        __IOM uint32_t GTADTBRA;          /*!< (@ 0x00000074) A/D Converter Start Request Timing Buffer Register
                                           *                  A                                                          */

        struct
        {
            __IOM uint32_t GTADTBRA : 32; /*!< [31..0] A/D Converter Start Request Timing Buffer Register A              */
        } GTADTBRA_b;
    };

    union
    {
        __IOM uint32_t GTADTDBRA;          /*!< (@ 0x00000078) A/D Converter Start Request Timing Double-Buffer
                                            *                  Register A                                                 */

        struct
        {
            __IOM uint32_t GTADTDBRA : 32; /*!< [31..0] A/D Converter Start Request Timing Double-Buffer Register
                                            *   A                                                                         */
        } GTADTDBRA_b;
    };

    union
    {
        __IOM uint32_t GTADTRB;          /*!< (@ 0x0000007C) A/D Converter Start Request Timing Register B              */

        struct
        {
            __IOM uint32_t GTADTRB : 32; /*!< [31..0] A/D Converter Start Request Timing Register B                     */
        } GTADTRB_b;
    };

    union
    {
        __IOM uint32_t GTADTBRB;          /*!< (@ 0x00000080) A/D Converter Start Request Timing Buffer Register
                                           *                  B                                                          */

        struct
        {
            __IOM uint32_t GTADTBRB : 32; /*!< [31..0] A/D Converter Start Request Timing Buffer Register B              */
        } GTADTBRB_b;
    };

    union
    {
        __IOM uint32_t GTADTDBRB;          /*!< (@ 0x00000084) A/D Converter Start Request Timing Double-Buffer
                                            *                  Register B                                                 */

        struct
        {
            __IOM uint32_t GTADTDBRB : 32; /*!< [31..0] A/D Converter Start Request Timing Double-Buffer Register
                                            *   B                                                                         */
        } GTADTDBRB_b;
    };

    union
    {
        __IOM uint32_t GTDTCR;         /*!< (@ 0x00000088) General PWM Timer Dead Time Control Register               */

        struct
        {
            __IOM uint32_t TDE   : 1;  /*!< [0..0] Negative-Phase Waveform Setting                                    */
            uint32_t             : 3;
            __IOM uint32_t TDBUE : 1;  /*!< [4..4] GTDVU Buffer Operation Enable                                      */
            __IOM uint32_t TDBDE : 1;  /*!< [5..5] GTDVD Buffer Operation Enable                                      */
            uint32_t             : 2;
            __IOM uint32_t TDFER : 1;  /*!< [8..8] GTDVD Setting                                                      */
            uint32_t             : 23;
        } GTDTCR_b;
    };

    union
    {
        __IOM uint32_t GTDVU;          /*!< (@ 0x0000008C) General PWM Timer Dead Time Value Register U               */

        struct
        {
            __IOM uint32_t GTDVU : 32; /*!< [31..0] Dead Time Value Register U                                        */
        } GTDVU_b;
    };

    union
    {
        __IOM uint32_t GTDVD;          /*!< (@ 0x00000090) General PWM Timer Dead Time Value Register D               */

        struct
        {
            __IOM uint32_t GTDVD : 32; /*!< [31..0] Dead Time Value Register D                                        */
        } GTDVD_b;
    };

    union
    {
        __IOM uint32_t GTDBU;          /*!< (@ 0x00000094) General PWM Timer Dead Time Buffer Register U              */

        struct
        {
            __IOM uint32_t GTDVU : 32; /*!< [31..0] Dead Time Buffer Register U                                       */
        } GTDBU_b;
    };

    union
    {
        __IOM uint32_t GTDBD;          /*!< (@ 0x00000098) General PWM Timer Dead Time Buffer Register D              */

        struct
        {
            __IOM uint32_t GTDBD : 32; /*!< [31..0] Dead Time Buffer Register D                                       */
        } GTDBD_b;
    };

    union
    {
        __IM uint32_t GTSOS;           /*!< (@ 0x0000009C) General PWM Timer Output Protection Function
                                        *                  Status Register                                            */

        struct
        {
            __IM uint32_t SOS : 2;     /*!< [1..0] Output Protection Function Status                                  */
            uint32_t          : 30;
        } GTSOS_b;
    };

    union
    {
        __IOM uint32_t GTSOTR;         /*!< (@ 0x000000A0) General PWM Timer Output Protection Function
                                        *                  Temporary Release Register                                 */

        struct
        {
            __IOM uint32_t SOTR : 1;   /*!< [0..0] Output Protection Function Temporary Release                       */
            uint32_t            : 31;
        } GTSOTR_b;
    };

    union
    {
        __IOM uint32_t GTADSMR;         /*!< (@ 0x000000A4) General PWM Timer A/D Conversion Start Request
                                         *                  Signal Monitoring Register                                 */

        struct
        {
            __IOM uint32_t ADSMS0  : 2; /*!< [1..0] A/D Conversion Start Request Signal Monitor 0 Selection            */
            uint32_t               : 6;
            __IOM uint32_t ADSMEN0 : 1; /*!< [8..8] A/D Conversion Start Request Signal Monitor 0 Output
                                         *   Enabling                                                                  */
            uint32_t               : 7;
            __IOM uint32_t ADSMS1  : 2; /*!< [17..16] A/D Conversion Start Request Signal Monitor 1 Selection          */
            uint32_t               : 6;
            __IOM uint32_t ADSMEN1 : 1; /*!< [24..24] A/D Conversion Start Request Signal Monitor 1 Output
                                         *   Enabling                                                                  */
            uint32_t : 7;
        } GTADSMR_b;
    };

    union
    {
        __IOM uint32_t GTEITC;            /*!< (@ 0x000000A8) General PWM Timer Extended Interrupt Skipping
                                           *                  Counter Control Register                                   */

        struct
        {
            __IOM uint32_t EIVTC1  : 2;   /*!< [1..0] Extended Interrupt Skipping Counter 1 Count Source Select          */
            uint32_t               : 2;
            __IOM uint32_t EIVTT1  : 4;   /*!< [7..4] Extended Interrupt Skipping 1 Skipping Count Setting               */
            uint32_t               : 4;
            __IM uint32_t  EITCNT1 : 4;   /*!< [15..12] Extended Interrupt Skipping Counter 1                            */
            __IOM uint32_t EIVTC2  : 2;   /*!< [17..16] Extended Interrupt Skipping Counter 2 Count Source
                                           *   select                                                                    */
            uint32_t                 : 2;
            __IOM uint32_t EIVTT2    : 4; /*!< [23..20] Extended Interrupt Skipping 2 Skipping Count Setting             */
            __IOM uint32_t EITCNT2IV : 4; /*!< [27..24] Extended Interrupt Skipping Counter 2 Initial Value              */
            __IM uint32_t  EITCNT2   : 4; /*!< [31..28] Extended Interrupt Skipping Counter 2                            */
        } GTEITC_b;
    };

    union
    {
        __IOM uint32_t GTEITLI1;       /*!< (@ 0x000000AC) General PWM Timer Extended Interrupt Skipping
                                        *                  Setting Register 1                                         */

        struct
        {
            __IOM uint32_t EITLA : 3;  /*!< [2..0] GTCCRA Register Compare Match/Input Capture Interrupt
                                        *   Extended Skipping Function Select                                         */
            uint32_t             : 1;
            __IOM uint32_t EITLB : 3;  /*!< [6..4] GTCCRB Register Compare Match/Input Capture Interrupt
                                        *   Extended Skipping Function Select                                         */
            uint32_t             : 1;
            __IOM uint32_t EITLC : 3;  /*!< [10..8] GTCCRC Register Compare Match Interrupt Extended Skipping
                                        *   Function Select                                                           */
            uint32_t             : 1;
            __IOM uint32_t EITLD : 3;  /*!< [14..12] GTCCRD Register Compare Match Interrupt Extended Skipping
                                        *   Function Select                                                           */
            uint32_t             : 1;
            __IOM uint32_t EITLE : 3;  /*!< [18..16] GTCCRE Register Compare Match Interrupt Extended Skipping
                                        *   Function Select                                                           */
            uint32_t             : 1;
            __IOM uint32_t EITLF : 3;  /*!< [22..20] GTCCRF Register Compare Match Interrupt Extended Skipping
                                        *   Function Select                                                           */
            uint32_t             : 1;
            __IOM uint32_t EITLV : 3;  /*!< [26..24] Overflow Interrupt Extended Skipping Function Select             */
            uint32_t             : 1;
            __IOM uint32_t EITLU : 3;  /*!< [30..28] Underflow Interrupt Extended Skipping Function Select            */
            uint32_t             : 1;
        } GTEITLI1_b;
    };

    union
    {
        __IOM uint32_t GTEITLI2;       /*!< (@ 0x000000B0) General PWM Timer Extended Interrupt Skipping
                                        *                  Setting Register 2                                         */

        struct
        {
            __IOM uint32_t EADTAL : 3; /*!< [2..0] GTADTRA Register A/D Conversion Start Request Extended
                                        *   Skipping Function Select                                                  */
            uint32_t              : 1;
            __IOM uint32_t EADTBL : 3; /*!< [6..4] GTADTRB Register A/D Conversion Start Request Extended
                                        *   Skipping Function Select                                                  */
            uint32_t : 25;
        } GTEITLI2_b;
    };

    union
    {
        __IOM uint32_t GTEITLB;         /*!< (@ 0x000000B4) General PWM Timer Extended Buffer Transfer Skipping
                                         *                  Setting Register                                           */

        struct
        {
            __IOM uint32_t EBTLCA : 3;  /*!< [2..0] GTCCRA Register Buffer Transfer Extended Skipping Function
                                         *   Select                                                                    */
            uint32_t              : 1;
            __IOM uint32_t EBTLCB : 3;  /*!< [6..4] GTCCRB Register Buffer Transfer Extended Skipping Function
                                         *   Select                                                                    */
            uint32_t              : 1;
            __IOM uint32_t EBTLPR : 3;  /*!< [10..8] GTPR Register Buffer Transfer Extended Skipping Function
                                         *   Select                                                                    */
            uint32_t               : 5;
            __IOM uint32_t EBTLADA : 3; /*!< [18..16] GTADTRA Register Buffer Transfer Extended Skipping
                                         *   Function Select                                                           */
            uint32_t               : 1;
            __IOM uint32_t EBTLADB : 3; /*!< [22..20] GTADTRB Register Buffer Transfer Extended Skipping
                                         *   Function Select                                                           */
            uint32_t               : 1;
            __IOM uint32_t EBTLDVU : 3; /*!< [26..24] GTDVU Register Buffer Transfer Extended Skipping Function
                                         *   Select                                                                    */
            uint32_t               : 1;
            __IOM uint32_t EBTLDVD : 3; /*!< [30..28] GTDVD Register Buffer Transfer Extended Skipping Function
                                         *   Select                                                                    */
            uint32_t : 1;
        } GTEITLB_b;
    };

    union
    {
        __IOM uint32_t GTICLF;           /*!< (@ 0x000000B8) General PWM Timer Inter Channel Logical Operation
                                          *                  Function Setting Register                                  */

        struct
        {
            __IOM uint32_t ICLFA    : 3; /*!< [2..0] GTIOCnA Output Logical Operation Function Select                   */
            uint32_t                : 1;
            __IOM uint32_t ICLFSELC : 6; /*!< [9..4] Inter Channel Signal C Select                                      */
            uint32_t                : 6;
            __IOM uint32_t ICLFB    : 3; /*!< [18..16] GTIOCnB Output Logical Operation Function Select                 */
            uint32_t                : 1;
            __IOM uint32_t ICLFSELD : 6; /*!< [25..20] Inter Channel Signal D Select                                    */
            uint32_t                : 6;
        } GTICLF_b;
    };

    union
    {
        __IOM uint32_t GTPC;           /*!< (@ 0x000000BC) General PWM Timer Period Count Register                    */

        struct
        {
            __IOM uint32_t PCEN : 1;   /*!< [0..0] Period Count Function Enable                                       */
            uint32_t            : 7;
            __IOM uint32_t ASTP : 1;   /*!< [8..8] Automatic Stop Function Enable                                     */
            uint32_t            : 7;
            __IOM uint32_t PCNT : 12;  /*!< [27..16] Period Counter                                                   */
            uint32_t            : 4;
        } GTPC_b;
    };
    __IM uint32_t RESERVED[4];

    union
    {
        __IOM uint32_t GTSECSR;         /*!< (@ 0x000000D0) General PWM Timer Operation Enable Bit Simultaneous
                                         *                  Control Channel Select Register                            */

        struct
        {
            __IOM uint32_t SECSEL0 : 1; /*!< [0..0] Channel 0 Operation Enable Bit Simultaneous Control Channel
                                         *   Select                                                                    */
            __IOM uint32_t SECSEL1 : 1; /*!< [1..1] Channel 1 Operation Enable Bit Simultaneous Control Channel
                                         *   Select                                                                    */
            __IOM uint32_t SECSEL2 : 1; /*!< [2..2] Channel 2 Operation Enable Bit Simultaneous Control Channel
                                         *   Select                                                                    */
            __IOM uint32_t SECSEL3 : 1; /*!< [3..3] Channel 3 Operation Enable Bit Simultaneous Control Channel
                                         *   Select                                                                    */
            __IOM uint32_t SECSEL4 : 1; /*!< [4..4] Channel 4 Operation Enable Bit Simultaneous Control Channel
                                         *   Select                                                                    */
            __IOM uint32_t SECSEL5 : 1; /*!< [5..5] Channel 5 Operation Enable Bit Simultaneous Control Channel
                                         *   Select                                                                    */
            __IOM uint32_t SECSEL6 : 1; /*!< [6..6] Channel 6 Operation Enable Bit Simultaneous Control Channel
                                         *   Select                                                                    */
            __IOM uint32_t SECSEL7 : 1; /*!< [7..7] Channel 7 Operation Enable Bit Simultaneous Control Channel
                                         *   Select                                                                    */
            __IOM uint32_t SECSEL8 : 1; /*!< [8..8] Channel 8 Operation Enable Bit Simultaneous Control Channel
                                         *   Select                                                                    */
            __IOM uint32_t SECSEL9 : 1; /*!< [9..9] Channel 9 Operation Enable Bit Simultaneous Control Channel
                                         *   Select                                                                    */
            uint32_t : 22;
        } GTSECSR_b;
    };

    union
    {
        __IOM uint32_t GTSECR;         /*!< (@ 0x000000D4) General PWM Timer Operation Enable Bit Simultaneous
                                        *                  Control Register                                           */

        struct
        {
            __IOM uint32_t SBDCE : 1;  /*!< [0..0] GTCCR Register Buffer Operation Simultaneous Enable                */
            __IOM uint32_t SBDPE : 1;  /*!< [1..1] GTPR Register Buffer Operation Simultaneous Enable                 */
            __IOM uint32_t SBDAE : 1;  /*!< [2..2] GTADTR Register Buffer Operation Simultaneous Enable               */
            __IOM uint32_t SBDDE : 1;  /*!< [3..3] GTDV Register Buffer Operation Simultaneous Enable                 */
            uint32_t             : 4;
            __IOM uint32_t SBDCD : 1;  /*!< [8..8] GTCCR Register Buffer Operation Simultaneous Disable               */
            __IOM uint32_t SBDPD : 1;  /*!< [9..9] GTPR Register Buffer Operation Simultaneous Disable                */
            __IOM uint32_t SBDAD : 1;  /*!< [10..10] GTADTR Register Buffer Operation Simultaneous Disable            */
            __IOM uint32_t SBDDD : 1;  /*!< [11..11] GTDV Register Buffer Operation Simultaneous Disable              */
            uint32_t             : 4;
            __IOM uint32_t SPCE  : 1;  /*!< [16..16] Period Count Function Simultaneous Enable                        */
            __IOM uint32_t SSCE  : 1;  /*!< [17..17] Synchronous Set/Clear Simultaneous Enable                        */
            uint32_t             : 6;
            __IOM uint32_t SPCD  : 1;  /*!< [24..24] Period Count Function Simultaneous Disable                       */
            __IOM uint32_t SSCD  : 1;  /*!< [25..25] Synchronous Set/Clear Simultaneous Disable                       */
            uint32_t             : 6;
        } GTSECR_b;
    };
    __IM uint32_t RESERVED1[2];

    union
    {
        __IOM uint32_t GTBER2;         /*!< (@ 0x000000E0) General PWM Timer Buffer Enable Register 2                 */

        struct
        {
            __IOM uint32_t CCTCA : 1;  /*!< [0..0] Counter Clear Source GTCCRA Register Buffer Transfer
                                        *   Disable                                                                   */
            __IOM uint32_t CCTCB : 1;  /*!< [1..1] Counter Clear Source GTCCRB Register Buffer Transfer
                                        *   Disable                                                                   */
            __IOM uint32_t CCTPR  : 1; /*!< [2..2] Counter Clear Source GTPR Register Buffer Transfer Disable         */
            __IOM uint32_t CCTADA : 1; /*!< [3..3] Counter Clear Source GTADTRA Register Buffer Transfer
                                        *   Disable                                                                   */
            __IOM uint32_t CCTADB : 1; /*!< [4..4] Counter Clear Source GTADTRB Register Buffer Transfer
                                        *   Disable                                                                   */
            __IOM uint32_t CCTDV : 1;  /*!< [5..5] Counter Clear Source GTDVU/GTDVD Register Buffer Transfer
                                        *   Disable                                                                   */
            uint32_t             : 2;
            __IOM uint32_t CMTCA : 2;  /*!< [9..8] Compare Match Source GTCCRA Register Buffer Transfer
                                        *   Enable                                                                    */
            __IOM uint32_t CMTCB : 2;  /*!< [11..10] Compare Match Source GTCCRB Register Buffer Transfer
                                        *   Enable                                                                    */
            uint32_t              : 1;
            __IOM uint32_t CMTADA : 1; /*!< [13..13] Compare Match Source GTADTRA Register Buffer Transfer
                                        *   Enable                                                                    */
            __IOM uint32_t CMTADB : 1; /*!< [14..14] Compare Match Source GTADTRA Register Buffer Transfer
                                        *   Enable                                                                    */
            uint32_t             : 1;
            __IOM uint32_t CPTCA : 1;  /*!< [16..16] Overflow/Underflow Source GTCCRA Register Buffer Transfer
                                        *   Disable                                                                   */
            __IOM uint32_t CPTCB : 1;  /*!< [17..17] Overflow/Underflow Source GTCCRB Register Buffer Transfer
                                        *   Disable                                                                   */
            __IOM uint32_t CPTPR : 1;  /*!< [18..18] Overflow/Underflow Source GTPR Register Buffer Transfer
                                        *   Disable                                                                   */
            __IOM uint32_t CPTADA : 1; /*!< [19..19] Overflow/Underflow Source GTADTRA Register Buffer Transfer
                                        *   Disable                                                                   */
            __IOM uint32_t CPTADB : 1; /*!< [20..20] Overflow/Underflow Source GTADTRB Register Buffer Transfer
                                        *   Disable                                                                   */
            __IOM uint32_t CPTDV : 1;  /*!< [21..21] Overflow/Underflow Source GTDVU/GTDVD Register Buffer
                                        *   Transfer Disable                                                          */
            uint32_t             : 2;
            __IOM uint32_t CP3DB : 1;  /*!< [24..24] Complementary PWM mode 3,4 Double Buffer select                  */
            __IOM uint32_t CPBTD : 1;  /*!< [25..25] Complementary PWM mode Buffer Transfer Disable                   */
            __IOM uint32_t OLTTA : 2;  /*!< [27..26] GTIOCnA Output Level Buffer Transfer Timing Select               */
            __IOM uint32_t OLTTB : 2;  /*!< [29..28] GTIOCnB Output Level Buffer Transfer Timing Select               */
            uint32_t             : 2;
        } GTBER2_b;
    };

    union
    {
        __IOM uint32_t GTOLBR;         /*!< (@ 0x000000E4) General PWM Timer Output Level Buffer Register             */

        struct
        {
            __IOM uint32_t GTIOAB : 5; /*!< [4..0] GTIOA buffer bits                                                  */
            uint32_t              : 11;
            __IOM uint32_t GTIOBB : 5; /*!< [20..16] GTIOBB buffer bits                                               */
            uint32_t              : 11;
        } GTOLBR_b;
    };
    __IM uint32_t RESERVED2;

    union
    {
        __IOM uint32_t GTICCR;         /*!< (@ 0x000000EC) General PWM Timer Inter Channel Cooperation Input
                                        *                  Capture Control Register                                   */

        struct
        {
            __IOM uint32_t ICAFA : 1;  /*!< [0..0] Forwarding GTCCRA register Compare Match/Input Capture
                                        *   to Other Channel GTCCRA Input Capture Source Enable                       */
            __IOM uint32_t ICAFB : 1;  /*!< [1..1] Forwarding GTCCRB register Compare Match/Input Capture
                                        *   to Other Channel GTCCRA Input Capture Source Enable                       */
            __IOM uint32_t ICAFC : 1;  /*!< [2..2] Forwarding GTCCRC register Compare Match Capture to Other
                                        *   Channel GTCCRA Input Capture Source Enable                                */
            __IOM uint32_t ICAFD : 1;  /*!< [3..3] Forwarding GTCCRD register Compare Match Capture to Other
                                        *   Channel GTCCRA Input Capture Source Enable                                */
            __IOM uint32_t ICAFE : 1;  /*!< [4..4] Forwarding GTCCRE register Compare Match Capture to Other
                                        *   Channel GTCCRA Input Capture Source Enable                                */
            __IOM uint32_t ICAFF : 1;  /*!< [5..5] Forwarding GTCCRF register Compare Match Capture to Other
                                        *   Channel GTCCRA Input Capture Source Enable                                */
            __IOM uint32_t ICAFPO : 1; /*!< [6..6] Forwarding Overflow to Other Channel GTCCRA Input Capture
                                        *   Source Enable                                                             */
            __IOM uint32_t ICAFPU : 1; /*!< [7..7] Forwarding Underflow to Other Channel GTCCRA Input Capture
                                        *   Source Enable                                                             */
            __IOM uint32_t ICACLK : 1; /*!< [8..8] Forwarding Count Clock to Other Channel GTCCRA Input
                                        *   Capture Source Enable                                                     */
            uint32_t              : 5;
            __IOM uint32_t ICAGRP : 2; /*!< [15..14] GTCCRA Input Capture Group Select                                */
            __IOM uint32_t ICBFA  : 1; /*!< [16..16] Forwarding GTCCRA register Compare Match/Input Capture
                                        *   to Other Channel GTCCRB Input Capture Source Enable                       */
            __IOM uint32_t ICBFB : 1;  /*!< [17..17] Forwarding GTCCRB register Compare Match/Input Capture
                                        *   to Other Channel GTCCRB Input Capture Source Enable                       */
            __IOM uint32_t ICBFC : 1;  /*!< [18..18] Forwarding GTCCRC register Compare Match Capture to
                                        *   Other Channel GTCCRB Input Capture Source Enable                          */
            __IOM uint32_t ICBFD : 1;  /*!< [19..19] Forwarding GTCCRD register Compare Match Capture to
                                        *   Other Channel GTCCRB Input Capture Source Enable                          */
            __IOM uint32_t ICBFE : 1;  /*!< [20..20] Forwarding GTCCRE register Compare Match Capture to
                                        *   Other Channel GTCCRb Input Capture Source Enable                          */
            __IOM uint32_t ICBFF : 1;  /*!< [21..21] Forwarding GTCCRF register Compare Match Capture to
                                        *   Other Channel GTCCRB Input Capture Source Enable                          */
            __IOM uint32_t ICBFPO : 1; /*!< [22..22] Forwarding Overflow to Other Channel GTCCRB Input Capture
                                        *   Source Enable                                                             */
            __IOM uint32_t ICBFPU : 1; /*!< [23..23] Forwarding Underflow to Other Channel GTCCRB Input
                                        *   Capture Source Enable                                                     */
            __IOM uint32_t ICBCLK : 1; /*!< [24..24] Forwarding Count Clock to Other Channel GTCCRB Input
                                        *   Capture Source Enable                                                     */
            uint32_t              : 5;
            __IOM uint32_t ICBGRP : 2; /*!< [31..30] GTCCRB Input Capture Group Select                                */
        } GTICCR_b;
    };
} R_GPT0_Type;                         /*!< Size = 240 (0xf0)                                                         */

/* =========================================================================================================================== */
/* ================                                         R_GPT_OPS                                         ================ */
/* =========================================================================================================================== */

/**
 * @brief Output Phase Switching for GPT (R_GPT_OPS)
 */

typedef struct                         /*!< (@ 0x40169A00) R_GPT_OPS Structure                                        */
{
    union
    {
        __IOM uint32_t OPSCR;          /*!< (@ 0x00000000) Output Phase Switching Control Register                    */

        struct
        {
            __IOM uint32_t UF : 1;     /*!< [0..0] Input Phase Soft Setting WFThis bit sets the input phase
                                        *   by the software settings.This bit setting is valid when
                                        *   the OPSCR.FB bit = 1.                                                     */
            __IOM uint32_t VF : 1;     /*!< [1..1] Input Phase Soft Setting VFThis bit sets the input phase
                                        *   by the software settings.This bit setting is valid when
                                        *   the OPSCR.FB bit = 1.                                                     */
            __IOM uint32_t WF : 1;     /*!< [2..2] Input Phase Soft Setting UFThis bit sets the input phase
                                        *   by the software settings.This bit setting is valid when
                                        *   the OPSCR.FB bit = 1.                                                     */
            uint32_t        : 1;
            __IM uint32_t U : 1;       /*!< [4..4] Input U-Phase MonitorThis bit monitors the state of the
                                        *   input phase.OPSCR.FB=0:External input monitoring by PCLKOPSCR.FB=1:Softwa
                                        *   e settings (UF/VF/WF)                                                     */
            __IM uint32_t V : 1;       /*!< [5..5] Input V-Phase MonitorThis bit monitors the state of the
                                        *   input phase.OPSCR.FB=0:External input monitoring by PCLKOPSCR.FB=1:Softwa
                                        *   e settings (UF/VF/WF)                                                     */
            __IM uint32_t W : 1;       /*!< [6..6] Input W-Phase MonitorThis bit monitors the state of the
                                        *   input phase.OPSCR.FB=0:External input monitoring by PCLKOPSCR.FB=1:Softwa
                                        *   e settings (UF/VF/WF)                                                     */
            uint32_t          : 1;
            __IOM uint32_t EN : 1;     /*!< [8..8] Enable-Phase Output Control                                        */
            uint32_t          : 7;
            __IOM uint32_t FB : 1;     /*!< [16..16] External Feedback Signal EnableThis bit selects the
                                        *   input phase from the software settings and external input.                */
            __IOM uint32_t P     : 1;  /*!< [17..17] Positive-Phase Output (P) Control                                */
            __IOM uint32_t N     : 1;  /*!< [18..18] Negative-Phase Output (N) Control                                */
            __IOM uint32_t INV   : 1;  /*!< [19..19] Invert-Phase Output Control                                      */
            __IOM uint32_t RV    : 1;  /*!< [20..20] Output phase rotation direction reversal                         */
            __IOM uint32_t ALIGN : 1;  /*!< [21..21] Input phase alignment                                            */
            uint32_t             : 2;
            __IOM uint32_t GRP   : 2;  /*!< [25..24] Output disabled source selection                                 */
            __IOM uint32_t GODF  : 1;  /*!< [26..26] Group output disable function                                    */
            uint32_t             : 2;
            __IOM uint32_t NFEN  : 1;  /*!< [29..29] External Input Noise Filter Enable                               */
            __IOM uint32_t NFCS  : 2;  /*!< [31..30] External Input Noise Filter Clock selectionNoise filter
                                        *   sampling clock setting of the external input.                             */
        } OPSCR_b;
    };
} R_GPT_OPS_Type;                      /*!< Size = 4 (0x4)                                                            */

/* =========================================================================================================================== */
/* ================                                        R_GPT_POEG0                                        ================ */
/* =========================================================================================================================== */

/**
 * @brief Port Output Enable for GPT (R_GPT_POEG0)
 */

typedef struct                         /*!< (@ 0x4008A000) R_GPT_POEG0 Structure                                      */
{
    union
    {
        __IOM uint32_t POEGG;          /*!< (@ 0x00000000) POEG Group Setting Register                                */

        struct
        {
            __IOM uint32_t PIDF  : 1;  /*!< [0..0] Port Input Detection Flag                                          */
            __IOM uint32_t IOCF  : 1;  /*!< [1..1] Real Time Overcurrent Detection Flag                               */
            __IOM uint32_t OSTPF : 1;  /*!< [2..2] Oscillation Stop Detection Flag                                    */
            __IOM uint32_t SSF   : 1;  /*!< [3..3] Software Stop Flag                                                 */
            __IOM uint32_t PIDE  : 1;  /*!< [4..4] Port Input Detection EnableNote: Can be modified only
                                        *   once after a reset.                                                       */
            __IOM uint32_t IOCE : 1;   /*!< [5..5] Enable for GPT Output-Disable RequestNote: Can be modified
                                        *   only once after a reset.                                                  */
            __IOM uint32_t OSTPE : 1;  /*!< [6..6] Oscillation Stop Detection EnableNote: Can be modified
                                        *   only once after a reset.                                                  */
            uint32_t             : 1;
            __IOM uint32_t CDRE0 : 1;  /*!< [8..8] Comparator Disable Request Enable. Note: Can be modified
                                        *   only once after a reset.                                                  */
            __IOM uint32_t CDRE1 : 1;  /*!< [9..9] Comparator Disable Request Enable. Note: Can be modified
                                        *   only once after a reset.                                                  */
            __IOM uint32_t CDRE2 : 1;  /*!< [10..10] Comparator Disable Request Enable. Note: Can be modified
                                        *   only once after a reset.                                                  */
            __IOM uint32_t CDRE3 : 1;  /*!< [11..11] Comparator Disable Request Enable. Note: Can be modified
                                        *   only once after a reset.                                                  */
            __IOM uint32_t CDRE4 : 1;  /*!< [12..12] Comparator Disable Request Enable. Note: Can be modified
                                        *   only once after a reset.                                                  */
            __IOM uint32_t CDRE5 : 1;  /*!< [13..13] Comparator Disable Request Enable. Note: Can be modified
                                        *   only once after a reset.                                                  */
            uint32_t            : 2;
            __IM uint32_t ST    : 1;   /*!< [16..16] GTETRG Input Status Flag                                         */
            uint32_t            : 11;
            __IOM uint32_t INV  : 1;   /*!< [28..28] GTETRG Input Reverse                                             */
            __IOM uint32_t NFEN : 1;   /*!< [29..29] Noise Filter Enable                                              */
            __IOM uint32_t NFCS : 2;   /*!< [31..30] Noise Filter Clock Select                                        */
        } POEGG_b;
    };
} R_GPT_POEG0_Type;                    /*!< Size = 4 (0x4)                                                            */

/* =========================================================================================================================== */
/* ================                                           R_ICU                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Interrupt Controller Unit (R_ICU)
 */

typedef struct                         /*!< (@ 0x40006000) R_ICU Structure                                            */
{
    union
    {
        __IOM uint8_t IRQCR[16];       /*!< (@ 0x00000000) IRQ Control Register [0..15]                               */

        struct
        {
            __IOM uint8_t IRQMD   : 2; /*!< [1..0] IRQ Detection Sense Select                                         */
            uint8_t               : 2;
            __IOM uint8_t FCLKSEL : 2; /*!< [5..4] IRQ Digital Filter Sampling Clock Select                           */
            uint8_t               : 1;
            __IOM uint8_t FLTEN   : 1; /*!< [7..7] IRQ Digital Filter Enable                                          */
        } IRQCR_b[16];
    };
    __IM uint32_t RESERVED[60];

    union
    {
        __IOM uint8_t NMICR;            /*!< (@ 0x00000100) NMI Pin Interrupt Control Register                         */

        struct
        {
            __IOM uint8_t NMIMD    : 1; /*!< [0..0] NMI Detection Set                                                  */
            uint8_t                : 3;
            __IOM uint8_t NFCLKSEL : 2; /*!< [5..4] NMI Digital Filter Sampling Clock Select                           */
            uint8_t                : 1;
            __IOM uint8_t NFLTEN   : 1; /*!< [7..7] NMI Digital Filter Enable                                          */
        } NMICR_b;
    };
    __IM uint8_t  RESERVED1;
    __IM uint16_t RESERVED2;
    __IM uint32_t RESERVED3[7];

    union
    {
        __IOM uint16_t NMIER;           /*!< (@ 0x00000120) Non-Maskable Interrupt Enable Register                     */

        struct
        {
            __IOM uint16_t IWDTEN  : 1; /*!< [0..0] IWDT Underflow/Refresh Error Interrupt Enable                      */
            __IOM uint16_t WDTEN   : 1; /*!< [1..1] WDT Underflow/Refresh Error Interrupt Enable                       */
            __IOM uint16_t LVD1EN  : 1; /*!< [2..2] Voltage-Monitoring 1 Interrupt Enable                              */
            __IOM uint16_t LVD2EN  : 1; /*!< [3..3] Voltage-Monitoring 2 Interrupt Enable                              */
            __IOM uint16_t VBATTEN : 1; /*!< [4..4] VBATT monitor Interrupt Enable                                     */
            uint16_t               : 1;
            __IOM uint16_t OSTEN   : 1; /*!< [6..6] Oscillation Stop Detection Interrupt Enable                        */
            __IOM uint16_t NMIEN   : 1; /*!< [7..7] NMI Pin Interrupt Enable                                           */
            __IOM uint16_t RPEEN   : 1; /*!< [8..8] RAM Parity Error Interrupt Enable                                  */
            __IOM uint16_t RECCEN  : 1; /*!< [9..9] RAM ECC Error Interrupt Enable                                     */
            __IOM uint16_t BUSSEN  : 1; /*!< [10..10] MPU Bus Slave Error Interrupt Enable                             */
            __IOM uint16_t BUSMEN  : 1; /*!< [11..11] MPU Bus Master Error Interrupt Enable                            */
            __IOM uint16_t SPEEN   : 1; /*!< [12..12] CPU Stack pointer monitor Interrupt Enable                       */
            __IOM uint16_t TZFEN   : 1; /*!< [13..13] TZFEN                                                            */
            uint16_t               : 1;
            __IOM uint16_t CPEEN   : 1; /*!< [15..15] CPEEN                                                            */
        } NMIER_b;
    };
    __IM uint16_t RESERVED4;
    __IM uint32_t RESERVED5[3];

    union
    {
        __IOM uint16_t NMICLR;          /*!< (@ 0x00000130) Non-Maskable Interrupt Status Clear Register               */

        struct
        {
            __OM uint16_t IWDTCLR  : 1; /*!< [0..0] IWDT Clear                                                         */
            __OM uint16_t WDTCLR   : 1; /*!< [1..1] WDT Clear                                                          */
            __OM uint16_t LVD1CLR  : 1; /*!< [2..2] LVD1 Clear                                                         */
            __OM uint16_t LVD2CLR  : 1; /*!< [3..3] LVD2 Clear                                                         */
            __OM uint16_t VBATTCLR : 1; /*!< [4..4] VBATT Clear                                                        */
            uint16_t               : 1;
            __OM uint16_t  OSTCLR  : 1; /*!< [6..6] OST Clear                                                          */
            __OM uint16_t  NMICLR  : 1; /*!< [7..7] NMI Clear                                                          */
            __OM uint16_t  RPECLR  : 1; /*!< [8..8] SRAM Parity Error Clear                                            */
            __OM uint16_t  RECCCLR : 1; /*!< [9..9] SRAM ECC Error Clear                                               */
            __OM uint16_t  BUSSCLR : 1; /*!< [10..10] Bus Slave Error Clear                                            */
            __OM uint16_t  BUSMCLR : 1; /*!< [11..11] Bus Master Error Clear                                           */
            __OM uint16_t  SPECLR  : 1; /*!< [12..12] CPU Stack Pointer Monitor Interrupt Clear                        */
            __IOM uint16_t TZFCLR  : 1; /*!< [13..13] TZFCLR                                                           */
            uint16_t               : 1;
            __IOM uint16_t CPECLR  : 1; /*!< [15..15] CPECLR                                                           */
        } NMICLR_b;
    };
    __IM uint16_t RESERVED6;
    __IM uint32_t RESERVED7[3];

    union
    {
        __IM uint16_t NMISR;           /*!< (@ 0x00000140) Non-Maskable Interrupt Status Register                     */

        struct
        {
            __IM uint16_t IWDTST  : 1; /*!< [0..0] IWDT Underflow/Refresh Error Status Flag                           */
            __IM uint16_t WDTST   : 1; /*!< [1..1] WDT Underflow/Refresh Error Status Flag                            */
            __IM uint16_t LVD1ST  : 1; /*!< [2..2] Voltage-Monitoring 1 Interrupt Status Flag                         */
            __IM uint16_t LVD2ST  : 1; /*!< [3..3] Voltage-Monitoring 2 Interrupt Status Flag                         */
            __IM uint16_t VBATTST : 1; /*!< [4..4] VBATT monitor Interrupt Status Flag                                */
            uint16_t              : 1;
            __IM uint16_t OSTST   : 1; /*!< [6..6] Oscillation Stop Detection Interrupt Status Flag                   */
            __IM uint16_t NMIST   : 1; /*!< [7..7] NMI Status Flag                                                    */
            __IM uint16_t RPEST   : 1; /*!< [8..8] RAM Parity Error Interrupt Status Flag                             */
            __IM uint16_t RECCST  : 1; /*!< [9..9] RAM ECC Error Interrupt Status Flag                                */
            __IM uint16_t BUSSST  : 1; /*!< [10..10] MPU Bus Slave Error Interrupt Status Flag                        */
            __IM uint16_t BUSMST  : 1; /*!< [11..11] MPU Bus Master Error Interrupt Status Flag                       */
            __IM uint16_t SPEST   : 1; /*!< [12..12] CPU Stack pointer monitor Interrupt Status Flag                  */
            __IM uint16_t TZFST   : 1; /*!< [13..13] TZFST                                                            */
            uint16_t              : 1;
            __IM uint16_t CPEST   : 1; /*!< [15..15] CPEST                                                            */
        } NMISR_b;
    };
    __IM uint16_t RESERVED8;
    __IM uint32_t RESERVED9[23];

    union
    {
        __IOM uint32_t WUPEN;                /*!< (@ 0x000001A0) Wake Up Interrupt Enable Register                          */

        struct
        {
            __IOM uint32_t IRQWUPEN0    : 1; /*!< [0..0] IRQ interrupt S/W standby returns enable                           */
            __IOM uint32_t IRQWUPEN1    : 1; /*!< [1..1] IRQ interrupt S/W standby returns enable                           */
            __IOM uint32_t IRQWUPEN2    : 1; /*!< [2..2] IRQ interrupt S/W standby returns enable                           */
            __IOM uint32_t IRQWUPEN3    : 1; /*!< [3..3] IRQ interrupt S/W standby returns enable                           */
            __IOM uint32_t IRQWUPEN4    : 1; /*!< [4..4] IRQ interrupt S/W standby returns enable                           */
            __IOM uint32_t IRQWUPEN5    : 1; /*!< [5..5] IRQ interrupt S/W standby returns enable                           */
            __IOM uint32_t IRQWUPEN6    : 1; /*!< [6..6] IRQ interrupt S/W standby returns enable                           */
            __IOM uint32_t IRQWUPEN7    : 1; /*!< [7..7] IRQ interrupt S/W standby returns enable                           */
            __IOM uint32_t IRQWUPEN8    : 1; /*!< [8..8] IRQ interrupt S/W standby returns enable                           */
            __IOM uint32_t IRQWUPEN9    : 1; /*!< [9..9] IRQ interrupt S/W standby returns enable                           */
            __IOM uint32_t IRQWUPEN10   : 1; /*!< [10..10] IRQ interrupt S/W standby returns enable                         */
            __IOM uint32_t IRQWUPEN11   : 1; /*!< [11..11] IRQ interrupt S/W standby returns enable                         */
            __IOM uint32_t IRQWUPEN12   : 1; /*!< [12..12] IRQ interrupt S/W standby returns enable                         */
            __IOM uint32_t IRQWUPEN13   : 1; /*!< [13..13] IRQ interrupt S/W standby returns enable                         */
            __IOM uint32_t IRQWUPEN14   : 1; /*!< [14..14] IRQ interrupt S/W standby returns enable                         */
            __IOM uint32_t IRQWUPEN15   : 1; /*!< [15..15] IRQ interrupt S/W standby returns enable                         */
            __IOM uint32_t IWDTWUPEN    : 1; /*!< [16..16] IWDT interrupt S/W standby returns enable                        */
            __IOM uint32_t KEYWUPEN     : 1; /*!< [17..17] Key interrupt S/W standby returns enable                         */
            __IOM uint32_t LVD1WUPEN    : 1; /*!< [18..18] LVD1 interrupt S/W standby returns enable                        */
            __IOM uint32_t LVD2WUPEN    : 1; /*!< [19..19] LVD2 interrupt S/W standby returns enable                        */
            __IOM uint32_t VBATTWUPEN   : 1; /*!< [20..20] VBATT monitor interrupt S/W standby returns enable               */
            uint32_t                    : 1;
            __IOM uint32_t ACMPHS0WUPEN : 1; /*!< [22..22] ACMPHS0 interrupt S/W standby returns enable bit                 */
            __IOM uint32_t ACMPLP0WUPEN : 1; /*!< [23..23] ACMPLP0 interrupt S/W standby returns enable                     */
            __IOM uint32_t RTCALMWUPEN  : 1; /*!< [24..24] RTC alarm interrupt S/W standby returns enable                   */
            __IOM uint32_t RTCPRDWUPEN  : 1; /*!< [25..25] RCT period interrupt S/W standby returns enable                  */
            __IOM uint32_t USBHSWUPEN   : 1; /*!< [26..26] USBHS interrupt S/W standby returns enable bit                   */
            __IOM uint32_t USBFSWUPEN   : 1; /*!< [27..27] USBFS interrupt S/W standby returns enable                       */
            __IOM uint32_t AGT1UDWUPEN  : 1; /*!< [28..28] AGT1 underflow interrupt S/W standby returns enable              */
            __IOM uint32_t AGT1CAWUPEN  : 1; /*!< [29..29] AGT1 compare match A interrupt S/W standby returns
                                              *   enable                                                                    */
            __IOM uint32_t AGT1CBWUPEN : 1;  /*!< [30..30] AGT1 compare match B interrupt S/W standby returns
                                              *   enable                                                                    */
            __IOM uint32_t IIC0WUPEN : 1;    /*!< [31..31] IIC0 address match interrupt S/W standby returns enable          */
        } WUPEN_b;
    };

    union
    {
        __IOM uint32_t WUPEN1;              /*!< (@ 0x000001A4) Wake Up interrupt enable register 1                        */

        struct
        {
            __IOM uint32_t AGT3UDWUPEN : 1; /*!< [0..0] AGT3 underflow interrupt S/W standby returns enable bit            */
            __IOM uint32_t AGT3CAWUPEN : 1; /*!< [1..1] AGT3 compare match A interrupt S/W standby returns enable
                                             *   bit                                                                       */
            __IOM uint32_t AGT3CBWUPEN : 1; /*!< [2..2] AGT3 compare match B interrupt S/W standby returns enable
                                             *   bit                                                                       */
            uint32_t : 29;
        } WUPEN1_b;
    };
    __IM uint32_t RESERVED10[6];

    union
    {
        __IOM uint8_t IELEN;            /*!< (@ 0x000001C0) ICU event Enable Register                                  */

        struct
        {
            __IOM uint8_t RTCINTEN : 1; /*!< [0..0] RTCALM and RTCPRD Interrupts Enable (when LPOPTEN bit
                                         *   = 1)                                                                      */
            __IOM uint8_t IELEN : 1;    /*!< [1..1] Parts Asynchronous Interrupts Enable except RTC (when
                                         *   LPOPTEN bit = 1)                                                          */
            uint8_t : 6;
        } IELEN_b;
    };
    __IM uint8_t  RESERVED11;
    __IM uint16_t RESERVED12;
    __IM uint32_t RESERVED13[15];

    union
    {
        __IOM uint16_t SELSR0;         /*!< (@ 0x00000200) Snooze Event Link Setting Register                         */

        struct
        {
            __IOM uint16_t SELS : 9;   /*!< [8..0] SYS Event Link Select                                              */
            uint16_t            : 7;
        } SELSR0_b;
    };
    __IM uint16_t RESERVED14;
    __IM uint32_t RESERVED15[31];

    union
    {
        __IOM uint32_t DELSR[8];       /*!< (@ 0x00000280) DMAC Event Link Setting Register                           */

        struct
        {
            __IOM uint32_t DELS : 9;   /*!< [8..0] Event selection to DMAC Start request                              */
            uint32_t            : 7;
            __IOM uint32_t IR   : 1;   /*!< [16..16] Interrupt Status Flag for DMAC NOTE: Writing 1 to the
                                        *   IR flag is prohibited.                                                    */
            uint32_t : 15;
        } DELSR_b[8];
    };
    __IM uint32_t RESERVED16[24];

    union
    {
        __IOM uint32_t IELSR[96];      /*!< (@ 0x00000300) ICU Event Link Setting Register [0..95]                    */

        struct
        {
            __IOM uint32_t IELS : 9;   /*!< [8..0] ICU Event selection to NVICSet the number for the event
                                        *   signal to be linked .                                                     */
            uint32_t            : 7;
            __IOM uint32_t IR   : 1;   /*!< [16..16] Interrupt Status Flag                                            */
            uint32_t            : 7;
            __IOM uint32_t DTCE : 1;   /*!< [24..24] DTC Activation Enable                                            */
            uint32_t            : 7;
        } IELSR_b[96];
    };
} R_ICU_Type;                          /*!< Size = 1152 (0x480)                                                       */

/* =========================================================================================================================== */
/* ================                                          R_IIC0                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief I2C Bus Interface (R_IIC0)
 */

typedef struct                         /*!< (@ 0x4009F000) R_IIC0 Structure                                           */
{
    union
    {
        __IOM uint8_t ICCR1;           /*!< (@ 0x00000000) I2C Bus Control Register 1                                 */

        struct
        {
            __IM uint8_t  SDAI   : 1;  /*!< [0..0] SDA Line Monitor                                                   */
            __IM uint8_t  SCLI   : 1;  /*!< [1..1] SCL Line Monitor                                                   */
            __IOM uint8_t SDAO   : 1;  /*!< [2..2] SDA Output Control/Monitor                                         */
            __IOM uint8_t SCLO   : 1;  /*!< [3..3] SCL Output Control/Monitor                                         */
            __IOM uint8_t SOWP   : 1;  /*!< [4..4] SCLO/SDAO Write Protect                                            */
            __IOM uint8_t CLO    : 1;  /*!< [5..5] Extra SCL Clock Cycle Output                                       */
            __IOM uint8_t IICRST : 1;  /*!< [6..6] I2C Bus Interface Internal ResetNote:If an internal reset
                                        *   is initiated using the IICRST bit for a bus hang-up occurred
                                        *   during communication with the master device in slave mode,
                                        *   the states may become different between the slave device
                                        *   and the master device (due to the difference in the bit
                                        *   counter information).                                                     */
            __IOM uint8_t ICE : 1;     /*!< [7..7] I2C Bus Interface Enable                                           */
        } ICCR1_b;
    };

    union
    {
        __IOM uint8_t ICCR2;           /*!< (@ 0x00000001) I2C Bus Control Register 2                                 */

        struct
        {
            uint8_t          : 1;
            __IOM uint8_t ST : 1;      /*!< [1..1] Start Condition Issuance RequestSet the ST bit to 1 (start
                                        *   condition issuance request) when the BBSY flag is set to
                                        *   0 (bus free state).                                                       */
            __IOM uint8_t RS : 1;      /*!< [2..2] Restart Condition Issuance RequestNote: Do not set the
                                        *   RS bit to 1 while issuing a stop condition.                               */
            __IOM uint8_t SP : 1;      /*!< [3..3] Stop Condition Issuance RequestNote: Writing to the SP
                                        *   bit is not possible while the setting of the BBSY flag
                                        *   is 0 (bus free state).Note: Do not set the SP bit to 1
                                        *   while a restart condition is being issued.                                */
            uint8_t            : 1;
            __IOM uint8_t TRS  : 1;    /*!< [5..5] Transmit/Receive Mode                                              */
            __IOM uint8_t MST  : 1;    /*!< [6..6] Master/Slave Mode                                                  */
            __IM uint8_t  BBSY : 1;    /*!< [7..7] Bus Busy Detection Flag                                            */
        } ICCR2_b;
    };

    union
    {
        __IOM uint8_t ICMR1;           /*!< (@ 0x00000002) I2C Bus Mode Register 1                                    */

        struct
        {
            __IOM uint8_t BC   : 3;    /*!< [2..0] Bit Counter                                                        */
            __OM uint8_t  BCWP : 1;    /*!< [3..3] BC Write Protect(This bit is read as 1.)                           */
            __IOM uint8_t CKS  : 3;    /*!< [6..4] Internal Reference Clock (fIIC) Selection ( fIIC = PCLKB
                                        *   / 2^CKS )                                                                 */
            __IOM uint8_t MTWP : 1;    /*!< [7..7] MST/TRS Write Protect                                              */
        } ICMR1_b;
    };

    union
    {
        __IOM uint8_t ICMR2;           /*!< (@ 0x00000003) I2C Bus Mode Register 2                                    */

        struct
        {
            __IOM uint8_t TMOS : 1;    /*!< [0..0] Timeout Detection Time Select                                      */
            __IOM uint8_t TMOL : 1;    /*!< [1..1] Timeout L Count Control                                            */
            __IOM uint8_t TMOH : 1;    /*!< [2..2] Timeout H Count Control                                            */
            uint8_t            : 1;
            __IOM uint8_t SDDL : 3;    /*!< [6..4] SDA Output Delay Counter                                           */
            __IOM uint8_t DLCS : 1;    /*!< [7..7] SDA Output Delay Clock Source Select                               */
        } ICMR2_b;
    };

    union
    {
        __IOM uint8_t ICMR3;           /*!< (@ 0x00000004) I2C Bus Mode Register 3                                    */

        struct
        {
            __IOM uint8_t NF    : 2;   /*!< [1..0] Noise Filter Stage Selection                                       */
            __IM uint8_t  ACKBR : 1;   /*!< [2..2] Receive Acknowledge                                                */
            __IOM uint8_t ACKBT : 1;   /*!< [3..3] Transmit Acknowledge                                               */
            __IOM uint8_t ACKWP : 1;   /*!< [4..4] ACKBT Write Protect                                                */
            __IOM uint8_t RDRFS : 1;   /*!< [5..5] RDRF Flag Set Timing Selection                                     */
            __IOM uint8_t WAIT  : 1;   /*!< [6..6] WAITNote: When the value of the WAIT bit is to be read,
                                        *   be sure to read the ICDRR beforehand.                                     */
            __IOM uint8_t SMBS : 1;    /*!< [7..7] SMBus/I2C Bus Selection                                            */
        } ICMR3_b;
    };

    union
    {
        __IOM uint8_t ICFER;           /*!< (@ 0x00000005) I2C Bus Function Enable Register                           */

        struct
        {
            __IOM uint8_t TMOE  : 1;   /*!< [0..0] Timeout Function Enable                                            */
            __IOM uint8_t MALE  : 1;   /*!< [1..1] Master Arbitration-Lost Detection Enable                           */
            __IOM uint8_t NALE  : 1;   /*!< [2..2] NACK Transmission Arbitration-Lost Detection Enable                */
            __IOM uint8_t SALE  : 1;   /*!< [3..3] Slave Arbitration-Lost Detection Enable                            */
            __IOM uint8_t NACKE : 1;   /*!< [4..4] NACK Reception Transfer Suspension Enable                          */
            __IOM uint8_t NFE   : 1;   /*!< [5..5] Digital Noise Filter Circuit Enable                                */
            __IOM uint8_t SCLE  : 1;   /*!< [6..6] SCL Synchronous Circuit Enable                                     */
            __IOM uint8_t FMPE  : 1;   /*!< [7..7] Fast-mode Plus Enable                                              */
        } ICFER_b;
    };

    union
    {
        __IOM uint8_t ICSER;           /*!< (@ 0x00000006) I2C Bus Status Enable Register                             */

        struct
        {
            __IOM uint8_t SAR0E : 1;   /*!< [0..0] Slave Address Register 0 Enable                                    */
            __IOM uint8_t SAR1E : 1;   /*!< [1..1] Slave Address Register 1 Enable                                    */
            __IOM uint8_t SAR2E : 1;   /*!< [2..2] Slave Address Register 2 Enable                                    */
            __IOM uint8_t GCAE  : 1;   /*!< [3..3] General Call Address Enable                                        */
            uint8_t             : 1;
            __IOM uint8_t DIDE  : 1;   /*!< [5..5] Device-ID Address Detection Enable                                 */
            uint8_t             : 1;
            __IOM uint8_t HOAE  : 1;   /*!< [7..7] Host Address Enable                                                */
        } ICSER_b;
    };

    union
    {
        __IOM uint8_t ICIER;           /*!< (@ 0x00000007) I2C Bus Interrupt Enable Register                          */

        struct
        {
            __IOM uint8_t TMOIE : 1;   /*!< [0..0] Timeout Interrupt Request Enable                                   */
            __IOM uint8_t ALIE  : 1;   /*!< [1..1] Arbitration-Lost Interrupt Request Enable                          */
            __IOM uint8_t STIE  : 1;   /*!< [2..2] Start Condition Detection Interrupt Request Enable                 */
            __IOM uint8_t SPIE  : 1;   /*!< [3..3] Stop Condition Detection Interrupt Request Enable                  */
            __IOM uint8_t NAKIE : 1;   /*!< [4..4] NACK Reception Interrupt Request Enable                            */
            __IOM uint8_t RIE   : 1;   /*!< [5..5] Receive Data Full Interrupt Request Enable                         */
            __IOM uint8_t TEIE  : 1;   /*!< [6..6] Transmit End Interrupt Request Enable                              */
            __IOM uint8_t TIE   : 1;   /*!< [7..7] Transmit Data Empty Interrupt Request Enable                       */
        } ICIER_b;
    };

    union
    {
        __IOM uint8_t ICSR1;           /*!< (@ 0x00000008) I2C Bus Status Register 1                                  */

        struct
        {
            __IOM uint8_t AAS0 : 1;    /*!< [0..0] Slave Address 0 Detection Flag                                     */
            __IOM uint8_t AAS1 : 1;    /*!< [1..1] Slave Address 1 Detection Flag                                     */
            __IOM uint8_t AAS2 : 1;    /*!< [2..2] Slave Address 2 Detection Flag                                     */
            __IOM uint8_t GCA  : 1;    /*!< [3..3] General Call Address Detection Flag                                */
            uint8_t            : 1;
            __IOM uint8_t DID  : 1;    /*!< [5..5] Device-ID Address Detection Flag                                   */
            uint8_t            : 1;
            __IOM uint8_t HOA  : 1;    /*!< [7..7] Host Address Detection Flag                                        */
        } ICSR1_b;
    };

    union
    {
        __IOM uint8_t ICSR2;           /*!< (@ 0x00000009) I2C Bus Status Register 2                                  */

        struct
        {
            __IOM uint8_t TMOF  : 1;   /*!< [0..0] Timeout Detection Flag                                             */
            __IOM uint8_t AL    : 1;   /*!< [1..1] Arbitration-Lost Flag                                              */
            __IOM uint8_t START : 1;   /*!< [2..2] Start Condition Detection Flag                                     */
            __IOM uint8_t STOP  : 1;   /*!< [3..3] Stop Condition Detection Flag                                      */
            __IOM uint8_t NACKF : 1;   /*!< [4..4] NACK Detection Flag                                                */
            __IOM uint8_t RDRF  : 1;   /*!< [5..5] Receive Data Full Flag                                             */
            __IOM uint8_t TEND  : 1;   /*!< [6..6] Transmit End Flag                                                  */
            __IM uint8_t  TDRE  : 1;   /*!< [7..7] Transmit Data Empty Flag                                           */
        } ICSR2_b;
    };
    __IOM R_IIC0_SAR_Type SAR[3];      /*!< (@ 0x0000000A) Slave Address Registers                                    */

    union
    {
        __IOM uint8_t ICBRL;           /*!< (@ 0x00000010) I2C Bus Bit Rate Low-Level Register                        */

        struct
        {
            __IOM uint8_t BRL : 5;     /*!< [4..0] Bit Rate Low-Level Period(Low-level period of SCL clock)           */
            uint8_t           : 3;
        } ICBRL_b;
    };

    union
    {
        __IOM uint8_t ICBRH;           /*!< (@ 0x00000011) I2C Bus Bit Rate High-Level Register                       */

        struct
        {
            __IOM uint8_t BRH : 5;     /*!< [4..0] Bit Rate High-Level Period(High-level period of SCL clock)         */
            uint8_t           : 3;
        } ICBRH_b;
    };

    union
    {
        __IOM uint8_t ICDRT;           /*!< (@ 0x00000012) I2C Bus Transmit Data Register                             */

        struct
        {
            __IOM uint8_t ICDRT : 8;   /*!< [7..0] 8-bit read-write register that stores transmit data.               */
        } ICDRT_b;
    };

    union
    {
        __IM uint8_t ICDRR;            /*!< (@ 0x00000013) I2C Bus Receive Data Register                              */

        struct
        {
            __IM uint8_t ICDRR : 8;    /*!< [7..0] 8-bit register that stores the received data                       */
        } ICDRR_b;
    };
    __IM uint8_t RESERVED[2];

    union
    {
        __IOM uint8_t ICWUR;           /*!< (@ 0x00000016) I2C Bus Wake Up Unit Register                              */

        struct
        {
            __IOM uint8_t WUAFA : 1;   /*!< [0..0] Wakeup Analog Filter Additional Selection                          */
            uint8_t             : 3;
            __IOM uint8_t WUACK : 1;   /*!< [4..4] ACK bit for Wakeup Mode                                            */
            __IOM uint8_t WUF   : 1;   /*!< [5..5] Wakeup Event Occurrence Flag                                       */
            __IOM uint8_t WUIE  : 1;   /*!< [6..6] Wakeup Interrupt Request Enable                                    */
            __IOM uint8_t WUE   : 1;   /*!< [7..7] Wakeup Function Enable                                             */
        } ICWUR_b;
    };

    union
    {
        __IOM uint8_t ICWUR2;          /*!< (@ 0x00000017) I2C Bus Wake up Unit Register 2                            */

        struct
        {
            __IM uint8_t WUSEN  : 1;   /*!< [0..0] Wake-up Function Synchronous Enable                                */
            __IM uint8_t WUASYF : 1;   /*!< [1..1] Wake-up Function Asynchronous Operation Status Flag                */
            __IM uint8_t WUSYF  : 1;   /*!< [2..2] Wake-up Function Synchronous Operation Status Flag                 */
            uint8_t             : 5;
        } ICWUR2_b;
    };
} R_IIC0_Type;                         /*!< Size = 24 (0x18)                                                          */

/* =========================================================================================================================== */
/* ================                                          R_IWDT                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Independent Watchdog Timer (R_IWDT)
 */

typedef struct                         /*!< (@ 0x40083200) R_IWDT Structure                                           */
{
    union
    {
        __IOM uint8_t IWDTRR;          /*!< (@ 0x00000000) IWDT Refresh Register                                      */

        struct
        {
            __IOM uint8_t IWDTRR : 8;  /*!< [7..0] The counter is refreshed by writing 0x00 and then writing
                                        *   0xFF to this register.                                                    */
        } IWDTRR_b;
    };
    __IM uint8_t RESERVED;

    union
    {
        __IOM uint16_t IWDTCR;         /*!< (@ 0x00000002) IWDT Control Register                                      */

        struct
        {
            __IOM uint16_t TOPS : 2;   /*!< [1..0] Timeout Period Selection                                           */
            uint16_t            : 2;
            __IOM uint16_t CKS  : 4;   /*!< [7..4] Clock Division Ratio Selection                                     */
            __IOM uint16_t RPES : 2;   /*!< [9..8] Window End Position Selection                                      */
            uint16_t            : 2;
            __IOM uint16_t RPSS : 2;   /*!< [13..12] Window Start Position Selection                                  */
            uint16_t            : 2;
        } IWDTCR_b;
    };

    union
    {
        __IOM uint16_t IWDTSR;          /*!< (@ 0x00000004) IWDT Status Register                                       */

        struct
        {
            __IM uint16_t  CNTVAL : 14; /*!< [13..0] Down-Counter Value                                                */
            __IOM uint16_t UNDFF  : 1;  /*!< [14..14] Underflow Flag                                                   */
            __IOM uint16_t REFEF  : 1;  /*!< [15..15] Refresh Error Flag                                               */
        } IWDTSR_b;
    };

    union
    {
        __IOM uint8_t IWDTRCR;         /*!< (@ 0x00000006) IWDT Reset Control Register                                */

        struct
        {
            uint8_t               : 7;
            __IOM uint8_t RSTIRQS : 1; /*!< [7..7] Reset Interrupt Request Selection                                  */
        } IWDTRCR_b;
    };
    __IM uint8_t RESERVED1;

    union
    {
        __IOM uint8_t IWDTCSTPR;       /*!< (@ 0x00000008) IWDT Count Stop Control Register                           */

        struct
        {
            uint8_t              : 7;
            __IOM uint8_t SLCSTP : 1;  /*!< [7..7] Sleep-Mode Count Stop Control                                      */
        } IWDTCSTPR_b;
    };
    __IM uint8_t  RESERVED2;
    __IM uint16_t RESERVED3;
} R_IWDT_Type;                         /*!< Size = 12 (0xc)                                                           */

/* =========================================================================================================================== */
/* ================                                          R_I3C0                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief I3C Bus Interface (R_I3C0)
 */

typedef struct                         /*!< (@ 0x4011F000) R_I3C0 Structure                                           */
{
    union
    {
        __IOM uint32_t PRTS;           /*!< (@ 0x00000000) Protocol Selection Register                                */

        struct
        {
            __IOM uint32_t PRTMD : 1;  /*!< [0..0] Protocol Mode                                                      */
            uint32_t             : 31;
        } PRTS_b;
    };
    __IM uint32_t RESERVED[3];

    union
    {
        __IOM uint32_t CECTL;          /*!< (@ 0x00000010) Clock Enable Control Resisters                             */

        struct
        {
            __IOM uint32_t CLKE : 1;   /*!< [0..0] Clock Enable                                                       */
            uint32_t            : 31;
        } CECTL_b;
    };

    union
    {
        __IOM uint32_t BCTL;             /*!< (@ 0x00000014) Bus Control Register                                       */

        struct
        {
            __IOM uint32_t INCBA    : 1; /*!< [0..0] Include I3C Broadcast Address                                      */
            uint32_t                : 6;
            __IOM uint32_t BMDS     : 1; /*!< [7..7] Bus Mode Selection                                                 */
            __IOM uint32_t HJACKCTL : 1; /*!< [8..8] Hot-Join Acknowledge Control                                       */
            uint32_t                : 20;
            __IOM uint32_t ABT      : 1; /*!< [29..29] Abort                                                            */
            __IOM uint32_t RSM      : 1; /*!< [30..30] Resume                                                           */
            __IOM uint32_t BUSE     : 1; /*!< [31..31] Bus Enable                                                       */
        } BCTL_b;
    };

    union
    {
        __IOM uint32_t MSDVAD;         /*!< (@ 0x00000018) Master Device Address Register                             */

        struct
        {
            uint32_t              : 16;
            __IOM uint32_t MDYAD  : 7; /*!< [22..16] Master Dynamic Address                                           */
            uint32_t              : 8;
            __IOM uint32_t MDYADV : 1; /*!< [31..31] Master Dynamic Address Valid                                     */
        } MSDVAD_b;
    };
    __IM uint32_t RESERVED1;

    union
    {
        __IOM uint32_t RSTCTL;          /*!< (@ 0x00000020) Reset Control Register                                     */

        struct
        {
            __IOM uint32_t RI3CRST : 1; /*!< [0..0] I3C Software Reset                                                 */
            __IOM uint32_t CMDQRST : 1; /*!< [1..1] Command Queue Software Reset                                       */
            __IOM uint32_t RSPQRST : 1; /*!< [2..2] Response Queue Software Reset                                      */
            __IOM uint32_t TDBRST  : 1; /*!< [3..3] Transmit Data Buffer Software Reset                                */
            __IOM uint32_t RDBRST  : 1; /*!< [4..4] Receive Data Buffer Software Reset                                 */
            __IOM uint32_t IBIQRST : 1; /*!< [5..5] IBI Queue Software Reset                                           */
            __IOM uint32_t RSQRST  : 1; /*!< [6..6] Receive Status Queue Software Reset                                */
            uint32_t               : 9;
            __IOM uint32_t INTLRST : 1; /*!< [16..16] Internal Software Reset                                          */
            uint32_t               : 15;
        } RSTCTL_b;
    };

    union
    {
        __IOM uint32_t PRSST;          /*!< (@ 0x00000024) Present State Register                                     */

        struct
        {
            uint32_t              : 2;
            __IOM uint32_t CRMS   : 1; /*!< [2..2] Current Master                                                     */
            uint32_t              : 1;
            __IM uint32_t TRMD    : 1; /*!< [4..4] Transmit/Receive Mode                                              */
            uint32_t              : 2;
            __OM uint32_t PRSSTWP : 1; /*!< [7..7] Present State Write Protect                                        */
            uint32_t              : 24;
        } PRSST_b;
    };
    __IM uint32_t RESERVED2[2];

    union
    {
        __IOM uint32_t INST;           /*!< (@ 0x00000030) Internal Status Register                                   */

        struct
        {
            uint32_t            : 10;
            __IOM uint32_t INEF : 1;   /*!< [10..10] Internal Error Flag                                              */
            uint32_t            : 21;
        } INST_b;
    };

    union
    {
        __IOM uint32_t INSTE;          /*!< (@ 0x00000034) Internal Status Enable Register                            */

        struct
        {
            uint32_t            : 10;
            __IOM uint32_t INEE : 1;   /*!< [10..10] Internal Error Enable                                            */
            uint32_t            : 21;
        } INSTE_b;
    };

    union
    {
        __IOM uint32_t INIE;           /*!< (@ 0x00000038) Internal Interrupt Enable Register                         */

        struct
        {
            uint32_t             : 10;
            __IOM uint32_t INEIE : 1;  /*!< [10..10] Internal Error Interrupt Enable                                  */
            uint32_t             : 21;
        } INIE_b;
    };

    union
    {
        __IOM uint32_t INSTFC;         /*!< (@ 0x0000003C) Internal Status Force Register                             */

        struct
        {
            uint32_t            : 10;
            __OM uint32_t INEFC : 1;   /*!< [10..10] Internal Error Force                                             */
            uint32_t            : 21;
        } INSTFC_b;
    };
    __IM uint32_t RESERVED3;

    union
    {
        __IM uint32_t DVCT;            /*!< (@ 0x00000044) Device Characteristic Table Register                       */

        struct
        {
            uint32_t          : 19;
            __IM uint32_t IDX : 5;     /*!< [23..19] DCT Table Index                                                  */
            uint32_t          : 8;
        } DVCT_b;
    };
    __IM uint32_t RESERVED4[4];

    union
    {
        __IOM uint32_t IBINCTL;          /*!< (@ 0x00000058) IBI Notify Control Register                                */

        struct
        {
            __IOM uint32_t NRHJCTL  : 1; /*!< [0..0] Notify Rejected Hot-Join Control                                   */
            __IOM uint32_t NRMRCTL  : 1; /*!< [1..1] Notify Rejected Master Request Control                             */
            uint32_t                : 1;
            __IOM uint32_t NRSIRCTL : 1; /*!< [3..3] Notify Rejected Slave Interrupt Request Control                    */
            uint32_t                : 28;
        } IBINCTL_b;
    };
    __IM uint32_t RESERVED5;

    union
    {
        __IOM uint32_t BFCTL;          /*!< (@ 0x00000060) Bus Function Control Register                              */

        struct
        {
            __IOM uint32_t MALE   : 1; /*!< [0..0] Master Arbitration-Lost Detection Enable                           */
            __IOM uint32_t NALE   : 1; /*!< [1..1] NACK Transmission Arbitration-Lost Detection Enable                */
            __IOM uint32_t SALE   : 1; /*!< [2..2] Slave Arbitration-Lost Detection Enable                            */
            uint32_t              : 5;
            __IOM uint32_t SCSYNE : 1; /*!< [8..8] SCL Synchronous Circuit Enable                                     */
            uint32_t              : 3;
            __IOM uint32_t SMBS   : 1; /*!< [12..12] SMBus/I2C Bus Selection                                          */
            uint32_t              : 1;
            __IOM uint32_t FMPE   : 1; /*!< [14..14] Fast-mode Plus Enable                                            */
            __IOM uint32_t HSME   : 1; /*!< [15..15] High Speed Mode Enable                                           */
            uint32_t              : 16;
        } BFCTL_b;
    };

    union
    {
        __IOM uint32_t SVCTL;          /*!< (@ 0x00000064) Slave Control Register                                     */

        struct
        {
            __IOM uint32_t GCAE  : 1;  /*!< [0..0] General Call Address Enable                                        */
            uint32_t             : 4;
            __IOM uint32_t HSMCE : 1;  /*!< [5..5] Hs-mode Master Code Enable                                         */
            __IOM uint32_t DVIDE : 1;  /*!< [6..6] Device-ID Address Enable                                           */
            uint32_t             : 8;
            __IOM uint32_t HOAE  : 1;  /*!< [15..15] Host Address Enable                                              */
            __IOM uint32_t SVAEn : 1;  /*!< [16..16] Slave Address Enable n (n = 0)                                   */
            uint32_t             : 15;
        } SVCTL_b;
    };
    __IM uint32_t RESERVED6[2];

    union
    {
        __IOM uint32_t REFCKCTL;        /*!< (@ 0x00000070) Reference Clock Control Register                           */

        struct
        {
            __IOM uint32_t IREFCKS : 3; /*!< [2..0] Internal Reference Clock Selection                                 */
            uint32_t               : 29;
        } REFCKCTL_b;
    };

    union
    {
        __IOM uint32_t STDBR;          /*!< (@ 0x00000074) Standard Bit Rate Register                                 */

        struct
        {
            __IOM uint32_t SBRLO  : 8; /*!< [7..0] Count value of the Low-level period of SCL clock                   */
            __IOM uint32_t SBRHO  : 8; /*!< [15..8] Count value of the High-level period of SCL clock                 */
            __IOM uint32_t SBRLP  : 6; /*!< [21..16] Standard Bit Rate Low-level Period Push-Pull                     */
            uint32_t              : 2;
            __IOM uint32_t SBRHP  : 6; /*!< [29..24] Standard Bit Rate High-Level Period Push-Pull                    */
            uint32_t              : 1;
            __IOM uint32_t DSBRPO : 1; /*!< [31..31] Double the Standard Bit Rate Period for Open-Drain               */
        } STDBR_b;
    };

    union
    {
        __IOM uint32_t EXTBR;          /*!< (@ 0x00000078) Extended Bit Rate Register                                 */

        struct
        {
            __IOM uint32_t EBRLO : 8;  /*!< [7..0] Extended Bit Rate Low-Level Period Open-Drain                      */
            __IOM uint32_t EBRHO : 8;  /*!< [15..8] Extended Bit Rate High-Level Period Open-Drain                    */
            __IOM uint32_t EBRLP : 6;  /*!< [21..16] Extended Bit Rate Low-Level Period Push-Pull                     */
            uint32_t             : 2;
            __IOM uint32_t EBRHP : 6;  /*!< [29..24] Extended Bit Rate Low-Level Period Push-Pull                     */
            uint32_t             : 2;
        } EXTBR_b;
    };

    union
    {
        __IOM uint32_t BFRECDT;        /*!< (@ 0x0000007C) Bus Free Condition Detection Time Register                 */

        struct
        {
            __IOM uint32_t FRECYC : 9; /*!< [8..0] Bus Free Condition Detection Cycle                                 */
            uint32_t              : 23;
        } BFRECDT_b;
    };

    union
    {
        __IOM uint32_t BAVLCDT;        /*!< (@ 0x00000080) Bus Available Condition Detection Time Register            */

        struct
        {
            __IOM uint32_t AVLCYC : 9; /*!< [8..0] Bus Available Condition Detection Cycle                            */
            uint32_t              : 23;
        } BAVLCDT_b;
    };

    union
    {
        __IOM uint32_t BIDLCDT;         /*!< (@ 0x00000084) Bus Idle Condition Detection Time Register                 */

        struct
        {
            __IOM uint32_t IDLCYC : 18; /*!< [17..0] Bus Idle Condition Detection Cycle                                */
            uint32_t              : 14;
        } BIDLCDT_b;
    };

    union
    {
        __IOM uint32_t OUTCTL;         /*!< (@ 0x00000088) Output Control Register                                    */

        struct
        {
            __IOM uint32_t SDOC   : 1; /*!< [0..0] SDA Output Control                                                 */
            __IOM uint32_t SCOC   : 1; /*!< [1..1] SCL Output Control                                                 */
            __OM uint32_t  SOCWP  : 1; /*!< [2..2] SCL/SDA Output Control Write Protect                               */
            uint32_t              : 1;
            __IOM uint32_t EXCYC  : 1; /*!< [4..4] Extra SCL Clock Cycle Output                                       */
            uint32_t              : 3;
            __IOM uint32_t SDOD   : 3; /*!< [10..8] SDA Output Delay                                                  */
            uint32_t              : 4;
            __IOM uint32_t SDODCS : 1; /*!< [15..15] SDA Output Delay Clock Source Selection                          */
            uint32_t              : 16;
        } OUTCTL_b;
    };

    union
    {
        __IOM uint32_t INCTL;          /*!< (@ 0x0000008C) Input Control Register                                     */

        struct
        {
            __IOM uint32_t DNFS : 4;   /*!< [3..0] Digital Noise Filter Stage Selection                               */
            __IOM uint32_t DNFE : 1;   /*!< [4..4] Digital Noise Filter Circuit Enable                                */
            uint32_t            : 27;
        } INCTL_b;
    };

    union
    {
        __IOM uint32_t TMOCTL;         /*!< (@ 0x00000090) Timeout Control Register                                   */

        struct
        {
            __IOM uint32_t TODTS  : 2; /*!< [1..0] Timeout Detection Time Selection                                   */
            uint32_t              : 2;
            __IOM uint32_t TOLCTL : 1; /*!< [4..4] Timeout L Count Control                                            */
            __IOM uint32_t TOHCTL : 1; /*!< [5..5] Timeout H Count Control                                            */
            __IOM uint32_t TOMDS  : 2; /*!< [7..6] Timeout Operation Mode Selection                                   */
            uint32_t              : 24;
        } TMOCTL_b;
    };
    __IM uint32_t RESERVED7;

    union
    {
        __IOM uint32_t WUCTL;           /*!< (@ 0x00000098) Wake Up Unit Control Register                              */

        struct
        {
            __IOM uint32_t WUACKS  : 1; /*!< [0..0] Wake-Up Acknowledge Selection                                      */
            uint32_t               : 3;
            __IOM uint32_t WUANFS  : 1; /*!< [4..4] Wake-Up Analog Noise Filter Selection                              */
            uint32_t               : 1;
            __IOM uint32_t WUFSYNE : 1; /*!< [6..6] Wake-Up function PCLKA Synchronous Enable                          */
            __IOM uint32_t WUFE    : 1; /*!< [7..7] Wake-Up function Enable.                                           */
            uint32_t               : 24;
        } WUCTL_b;
    };
    __IM uint32_t RESERVED8;

    union
    {
        __IOM uint32_t ACKCTL;         /*!< (@ 0x000000A0) Acknowledge Control Register                               */

        struct
        {
            __IM uint32_t  ACKR   : 1; /*!< [0..0] Acknowledge Reception                                              */
            __IOM uint32_t ACKT   : 1; /*!< [1..1] Acknowledge Transmission                                           */
            __OM uint32_t  ACKTWP : 1; /*!< [2..2] ACKT Write Protect                                                 */
            uint32_t              : 29;
        } ACKCTL_b;
    };

    union
    {
        __IOM uint32_t SCSTRCTL;       /*!< (@ 0x000000A4) SCL Stretch Control Register                               */

        struct
        {
            __IOM uint32_t ACKTWE : 1; /*!< [0..0] Acknowledge Transmission Wait Enable                               */
            __IOM uint32_t RWE    : 1; /*!< [1..1] Receive Wait Enable                                                */
            uint32_t              : 30;
        } SCSTRCTL_b;
    };
    __IM uint32_t RESERVED9[2];

    union
    {
        __IOM uint32_t SCSTLCTL;        /*!< (@ 0x000000B0) SCL Stalling Control Register                              */

        struct
        {
            __IOM uint32_t STLCYC : 16; /*!< [15..0] Stalling Cycle                                                    */
            uint32_t              : 12;
            __IOM uint32_t AAPE   : 1;  /*!< [28..28] Assigend Address Phase Enable                                    */
            __IOM uint32_t TRAPE  : 1;  /*!< [29..29] Transition Phase Enable                                          */
            __IOM uint32_t PARPE  : 1;  /*!< [30..30] Parity Phase Enable                                              */
            __IOM uint32_t ACKPE  : 1;  /*!< [31..31] ACK phase Enable                                                 */
        } SCSTLCTL_b;
    };
    __IM uint32_t RESERVED10[3];

    union
    {
        __IOM uint32_t SVTDLG0;        /*!< (@ 0x000000C0) Slave Transfer Data Length Register 0                      */

        struct
        {
            uint32_t             : 16;
            __IOM uint32_t STDLG : 16; /*!< [31..16] Slave Transfer Data Length                                       */
        } SVTDLG0_b;
    };
    __IM uint32_t RESERVED11[31];

    union
    {
        __IOM uint32_t CNDCTL;         /*!< (@ 0x00000140) Condition Control Register                                 */

        struct
        {
            __IOM uint32_t STCND : 1;  /*!< [0..0] START (S) Condition Issuance                                       */
            __IOM uint32_t SRCND : 1;  /*!< [1..1] Repeated START (Sr) Condition Issuance                             */
            __IOM uint32_t SPCND : 1;  /*!< [2..2] STOP (P) Condition Issuance                                        */
            uint32_t             : 29;
        } CNDCTL_b;
    };
    __IM uint32_t  RESERVED12[3];
    __OM uint32_t  NCMDQP;             /*!< (@ 0x00000150) Normal Command Queue Port Register                         */
    __IM uint32_t  NRSPQP;             /*!< (@ 0x00000154) Normal Response Queue Port Register                        */
    __IOM uint32_t NTDTBP0;            /*!< (@ 0x00000158) Normal Transfer Data Buffer Port Register 0                */
    __IM uint32_t  RESERVED13[8];
    __IOM uint32_t NIBIQP;             /*!< (@ 0x0000017C) Normal IBI Queue Port Register                             */
    __IM uint32_t  NRSQP;              /*!< (@ 0x00000180) Normal Receive Status Queue Port Register                  */
    __IM uint32_t  RESERVED14[3];

    union
    {
        __IOM uint32_t NQTHCTL;         /*!< (@ 0x00000190) Normal Queue Threshold Control Register                    */

        struct
        {
            __IOM uint32_t CMDQTH  : 8; /*!< [7..0] Normal Command Ready Queue Threshold                               */
            __IOM uint32_t RSPQTH  : 8; /*!< [15..8] Normal Response Queue Threshold                                   */
            __IOM uint32_t IBIDSSZ : 8; /*!< [23..16] Normal IBI Data Segment Size                                     */
            __IOM uint32_t IBIQTH  : 8; /*!< [31..24] Normal IBI Queue Threshold                                       */
        } NQTHCTL_b;
    };

    union
    {
        __IOM uint32_t NTBTHCTL0;      /*!< (@ 0x00000194) Normal Transfer Data Buffer Threshold Control
                                        *                  Register 0                                                 */

        struct
        {
            __IOM uint32_t TXDBTH : 3; /*!< [2..0] Normal Transmit Data Buffer Threshold                              */
            uint32_t              : 5;
            __IOM uint32_t RXDBTH : 3; /*!< [10..8] Normal Receive Data Buffer Threshold                              */
            uint32_t              : 5;
            __IOM uint32_t TXSTTH : 3; /*!< [18..16] Normal Tx Start Threshold                                        */
            uint32_t              : 5;
            __IOM uint32_t RXSTTH : 3; /*!< [26..24] Normal Rx Start Threshold                                        */
            uint32_t              : 5;
        } NTBTHCTL0_b;
    };
    __IM uint32_t RESERVED15[10];

    union
    {
        __IOM uint32_t NRQTHCTL;       /*!< (@ 0x000001C0) Normal Receive Status Queue Threshold Control
                                        *                  Register                                                   */

        struct
        {
            __IOM uint32_t RSQTH : 8;  /*!< [7..0] Normal Receive Status Queue Threshold                              */
            uint32_t             : 24;
        } NRQTHCTL_b;
    };
    __IM uint32_t RESERVED16[3];

    union
    {
        __IOM uint32_t BST;             /*!< (@ 0x000001D0) Bus Status Register                                        */

        struct
        {
            __IOM uint32_t STCNDDF : 1; /*!< [0..0] START condition Detection Flag                                     */
            __IOM uint32_t SPCNDDF : 1; /*!< [1..1] STOP condition Detection Flag                                      */
            __IOM uint32_t HDREXDF : 1; /*!< [2..2] HDR Exit Pattern Detection Flag                                    */
            uint32_t               : 1;
            __IOM uint32_t NACKDF  : 1; /*!< [4..4] NACK Detection Flag                                                */
            uint32_t               : 3;
            __IOM uint32_t TENDF   : 1; /*!< [8..8] Transmit End Flag                                                  */
            uint32_t               : 7;
            __IOM uint32_t ALF     : 1; /*!< [16..16] Arbitration Lost Flag                                            */
            uint32_t               : 3;
            __IOM uint32_t TODF    : 1; /*!< [20..20] Timeout Detection Flag                                           */
            uint32_t               : 11;
        } BST_b;
    };

    union
    {
        __IOM uint32_t BSTE;            /*!< (@ 0x000001D4) Bus Status Enable Register                                 */

        struct
        {
            __IOM uint32_t STCNDDE : 1; /*!< [0..0] START condition Detection Enable                                   */
            __IOM uint32_t SPCNDDE : 1; /*!< [1..1] STOP condition Detection Enable                                    */
            __IOM uint32_t HDREXDE : 1; /*!< [2..2] HDR Exit Pattern Detection Enable                                  */
            uint32_t               : 1;
            __IOM uint32_t NACKDE  : 1; /*!< [4..4] NACK Detection Enable                                              */
            uint32_t               : 3;
            __IOM uint32_t TENDE   : 1; /*!< [8..8] Transmit End Enable                                                */
            uint32_t               : 7;
            __IOM uint32_t ALE     : 1; /*!< [16..16] Arbitration Lost Enable                                          */
            uint32_t               : 3;
            __IOM uint32_t TODE    : 1; /*!< [20..20] Timeout Detection Enable                                         */
            uint32_t               : 11;
        } BSTE_b;
    };

    union
    {
        __IOM uint32_t BIE;              /*!< (@ 0x000001D8) Bus Interrupt Enable Register                              */

        struct
        {
            __IOM uint32_t STCNDDIE : 1; /*!< [0..0] START condition Detection Interrupt Enable                         */
            __IOM uint32_t SPCNDDIE : 1; /*!< [1..1] STOP condition Detection Interrupt Enable                          */
            __IOM uint32_t HDREXDIE : 1; /*!< [2..2] HDR Exit Pattern Detection Interrupt Enable                        */
            uint32_t                : 1;
            __IOM uint32_t NACKDIE  : 1; /*!< [4..4] NACK Detection Interrupt Enable                                    */
            uint32_t                : 3;
            __IOM uint32_t TENDIE   : 1; /*!< [8..8] Transmit End Interrupt Enable                                      */
            uint32_t                : 7;
            __IOM uint32_t ALIE     : 1; /*!< [16..16] Arbitration Lost Interrupt Enable                                */
            uint32_t                : 3;
            __IOM uint32_t TODIE    : 1; /*!< [20..20] Timeout Detection Interrupt Enable                               */
            uint32_t                : 11;
        } BIE_b;
    };

    union
    {
        __IOM uint32_t BSTFC;           /*!< (@ 0x000001DC) Bus Status Force Register                                  */

        struct
        {
            __OM uint32_t STCNDDFC : 1; /*!< [0..0] START condition Detection Force                                    */
            __OM uint32_t SPCNDDFC : 1; /*!< [1..1] STOP condition Detection Force                                     */
            __OM uint32_t HDREXDFC : 1; /*!< [2..2] HDR Exit Pattern Detection Force                                   */
            uint32_t               : 1;
            __OM uint32_t NACKDFC  : 1; /*!< [4..4] NACK Detection Force                                               */
            uint32_t               : 3;
            __OM uint32_t TENDFC   : 1; /*!< [8..8] Transmit End Force                                                 */
            uint32_t               : 7;
            __OM uint32_t ALFC     : 1; /*!< [16..16] Arbitration Lost Force                                           */
            uint32_t               : 3;
            __OM uint32_t TODFC    : 1; /*!< [20..20] Timeout Detection Force                                          */
            uint32_t               : 11;
        } BSTFC_b;
    };

    union
    {
        __IOM uint32_t NTST;            /*!< (@ 0x000001E0) Normal Transfer Status Register                            */

        struct
        {
            __IOM uint32_t TDBEF0  : 1; /*!< [0..0] Normal Transmit Data Buffer Empty Flag 0                           */
            __IOM uint32_t RDBFF0  : 1; /*!< [1..1] Normal Receive Data Buffer Full Flag 0                             */
            __IOM uint32_t IBIQEFF : 1; /*!< [2..2] Normal IBI Queue Empty/Full Flag                                   */
            __IOM uint32_t CMDQEF  : 1; /*!< [3..3] Normal Command Queue Empty Flag                                    */
            __IOM uint32_t RSPQFF  : 1; /*!< [4..4] Normal Response Queue Full Flag                                    */
            __IOM uint32_t TABTF   : 1; /*!< [5..5] Normal Transfer Abort Flag                                         */
            uint32_t               : 3;
            __IOM uint32_t TEF     : 1; /*!< [9..9] Normal Transfer Error Flag                                         */
            uint32_t               : 10;
            __IOM uint32_t RSQFF   : 1; /*!< [20..20] Normal Receive Status Queue Full Flag                            */
            uint32_t               : 11;
        } NTST_b;
    };

    union
    {
        __IOM uint32_t NTSTE;           /*!< (@ 0x000001E4) Normal Transfer Status Enable Register                     */

        struct
        {
            __IOM uint32_t TDBEE0  : 1; /*!< [0..0] Normal Transmit Data Buffer Empty Enable 0                         */
            __IOM uint32_t RDBFE0  : 1; /*!< [1..1] Normal Receive Data Buffer Full Enable 0                           */
            __IOM uint32_t IBIQEFE : 1; /*!< [2..2] Normal IBI Queue Empty/Full Enable                                 */
            __IOM uint32_t CMDQEE  : 1; /*!< [3..3] Normal Command Queue Empty Enable                                  */
            __IOM uint32_t RSPQFE  : 1; /*!< [4..4] Normal Response Queue Full Enable                                  */
            __IOM uint32_t TABTE   : 1; /*!< [5..5] Normal Transfer Abort Enable                                       */
            uint32_t               : 3;
            __IOM uint32_t TEE     : 1; /*!< [9..9] Normal Transfer Error Enable                                       */
            uint32_t               : 10;
            __IOM uint32_t RSQFE   : 1; /*!< [20..20] Normal Receive Status Queue Full Enable                          */
            uint32_t               : 11;
        } NTSTE_b;
    };

    union
    {
        __IOM uint32_t NTIE;             /*!< (@ 0x000001E8) Normal Transfer Interrupt Enable Register                  */

        struct
        {
            __IOM uint32_t TDBEIE0  : 1; /*!< [0..0] Normal Transmit Data Buffer Empty Interrupt Enable 0               */
            __IOM uint32_t RDBFIE0  : 1; /*!< [1..1] Normal Receive Data Buffer Full Interrupt Enable 0                 */
            __IOM uint32_t IBIQEFIE : 1; /*!< [2..2] Normal IBI Queue Empty/Full Interrupt Enable                       */
            __IOM uint32_t CMDQEIE  : 1; /*!< [3..3] Normal Command Queue Empty Interrupt Enable                        */
            __IOM uint32_t RSPQFIE  : 1; /*!< [4..4] Normal Response Queue Full Interrupt Enable                        */
            __IOM uint32_t TABTIE   : 1; /*!< [5..5] Normal Transfer Abort Interrupt Enable                             */
            uint32_t                : 3;
            __IOM uint32_t TEIE     : 1; /*!< [9..9] Normal Transfer Error Interrupt Enable                             */
            uint32_t                : 10;
            __IOM uint32_t RSQFIE   : 1; /*!< [20..20] Normal Receive Status Queue Full Interrupt Enable                */
            uint32_t                : 11;
        } NTIE_b;
    };

    union
    {
        __IOM uint32_t NTSTFC;          /*!< (@ 0x000001EC) Normal Transfer Status Force Register                      */

        struct
        {
            __OM uint32_t TDBEFC0  : 1; /*!< [0..0] Normal Transmit Data Buffer Empty Force 0                          */
            __OM uint32_t RDBFFC0  : 1; /*!< [1..1] Normal Receive Data Buffer Full Force 0                            */
            __OM uint32_t IBIQEFFC : 1; /*!< [2..2] Normal IBI Queue Empty/Full Force                                  */
            __OM uint32_t CMDQEFC  : 1; /*!< [3..3] Normal Command Queue Empty Force                                   */
            __OM uint32_t RSPQFFC  : 1; /*!< [4..4] Normal Response Queue Full Force                                   */
            __OM uint32_t TABTFC   : 1; /*!< [5..5] Normal Transfer Abort Force                                        */
            uint32_t               : 3;
            __OM uint32_t TEFC     : 1; /*!< [9..9] Normal Transfer Error Force                                        */
            uint32_t               : 10;
            __OM uint32_t RSQFFC   : 1; /*!< [20..20] Normal Receive Status Queue Full Force                           */
            uint32_t               : 11;
        } NTSTFC_b;
    };
    __IM uint32_t RESERVED17[8];

    union
    {
        __IM uint32_t BCST;            /*!< (@ 0x00000210) Bus Condition Status Register                              */

        struct
        {
            __IM uint32_t BFREF : 1;   /*!< [0..0] Bus Free Detection Flag                                            */
            __IM uint32_t BAVLF : 1;   /*!< [1..1] Bus Available Detection Flag                                       */
            __IM uint32_t BIDLF : 1;   /*!< [2..2] Bus Idle Detection Flag                                            */
            uint32_t            : 29;
        } BCST_b;
    };

    union
    {
        __IOM uint32_t SVST;           /*!< (@ 0x00000214) Slave Status Register                                      */

        struct
        {
            __IOM uint32_t GCAF  : 1;  /*!< [0..0] General Call Address Detection Flag                                */
            uint32_t             : 4;
            __IOM uint32_t HSMCF : 1;  /*!< [5..5] Hs-mode Master Code Detection Flag                                 */
            __IOM uint32_t DVIDF : 1;  /*!< [6..6] Device-ID Address Detection Flag                                   */
            uint32_t             : 8;
            __IOM uint32_t HOAF  : 1;  /*!< [15..15] Host Address Detection Flag                                      */
            __IOM uint32_t SVAFn : 1;  /*!< [16..16] Slave Address Detection Flag n (n = 0)                           */
            uint32_t             : 15;
        } SVST_b;
    };

    union
    {
        __IOM uint32_t WUST;            /*!< (@ 0x00000218) Wake Up Unit Control Register                              */

        struct
        {
            __IOM uint32_t WUASYNF : 1; /*!< [0..0] Wake-up function asynchronous operation status flag.               */
            uint32_t               : 31;
        } WUST_b;
    };
    __IM uint32_t RESERVED18[2];

    union
    {
        __IOM uint32_t DATBAS0;         /*!< (@ 0x00000224) Device Address Table Basic Register 0                      */

        struct
        {
            __IOM uint32_t DVSTAD  : 7; /*!< [6..0] Device Static Address                                              */
            uint32_t               : 5;
            __IOM uint32_t DVIBIPL : 1; /*!< [12..12] Device IBI Payload                                               */
            __IOM uint32_t DVSIRRJ : 1; /*!< [13..13] Device In-Band Slave Interrupt Request Reject                    */
            __IOM uint32_t DVMRRJ  : 1; /*!< [14..14] Device In-Band Master Request Reject                             */
            __IOM uint32_t DVIBITS : 1; /*!< [15..15] Device IBI Time-stamp                                            */
            __IOM uint32_t DVDYAD  : 8; /*!< [23..16] Device I3C Dynamic Address                                       */
            uint32_t               : 5;
            __IOM uint32_t DVNACK  : 2; /*!< [30..29] Device NACK Retry Count                                          */
            __IOM uint32_t DVTYP   : 1; /*!< [31..31] Device Type                                                      */
        } DATBAS0_b;
    };
    __IM uint32_t RESERVED19;

    union
    {
        __IOM uint32_t DATBAS1;         /*!< (@ 0x0000022C) Device Address Table Basic Register 1                      */

        struct
        {
            __IOM uint32_t DVSTAD  : 7; /*!< [6..0] Device Static Address                                              */
            uint32_t               : 5;
            __IOM uint32_t DVIBIPL : 1; /*!< [12..12] Device IBI Payload                                               */
            __IOM uint32_t DVSIRRJ : 1; /*!< [13..13] Device In-Band Slave Interrupt Request Reject                    */
            __IOM uint32_t DVMRRJ  : 1; /*!< [14..14] Device In-Band Master Request Reject                             */
            __IOM uint32_t DVIBITS : 1; /*!< [15..15] Device IBI Time-stamp                                            */
            __IOM uint32_t DVDYAD  : 8; /*!< [23..16] Device I3C Dynamic Address                                       */
            uint32_t               : 5;
            __IOM uint32_t DVNACK  : 2; /*!< [30..29] Device NACK Retry Count                                          */
            __IOM uint32_t DVTYP   : 1; /*!< [31..31] Device Type                                                      */
        } DATBAS1_b;
    };
    __IM uint32_t RESERVED20;

    union
    {
        __IOM uint32_t DATBAS2;         /*!< (@ 0x00000234) Device Address Table Basic Register 2                      */

        struct
        {
            __IOM uint32_t DVSTAD  : 7; /*!< [6..0] Device Static Address                                              */
            uint32_t               : 5;
            __IOM uint32_t DVIBIPL : 1; /*!< [12..12] Device IBI Payload                                               */
            __IOM uint32_t DVSIRRJ : 1; /*!< [13..13] Device In-Band Slave Interrupt Request Reject                    */
            __IOM uint32_t DVMRRJ  : 1; /*!< [14..14] Device In-Band Master Request Reject                             */
            __IOM uint32_t DVIBITS : 1; /*!< [15..15] Device IBI Time-stamp                                            */
            __IOM uint32_t DVDYAD  : 8; /*!< [23..16] Device I3C Dynamic Address                                       */
            uint32_t               : 5;
            __IOM uint32_t DVNACK  : 2; /*!< [30..29] Device NACK Retry Count                                          */
            __IOM uint32_t DVTYP   : 1; /*!< [31..31] Device Type                                                      */
        } DATBAS2_b;
    };
    __IM uint32_t RESERVED21;

    union
    {
        __IOM uint32_t DATBAS3;         /*!< (@ 0x0000023C) Device Address Table Basic Register 3                      */

        struct
        {
            __IOM uint32_t DVSTAD  : 7; /*!< [6..0] Device Static Address                                              */
            uint32_t               : 5;
            __IOM uint32_t DVIBIPL : 1; /*!< [12..12] Device IBI Payload                                               */
            __IOM uint32_t DVSIRRJ : 1; /*!< [13..13] Device In-Band Slave Interrupt Request Reject                    */
            __IOM uint32_t DVMRRJ  : 1; /*!< [14..14] Device In-Band Master Request Reject                             */
            __IOM uint32_t DVIBITS : 1; /*!< [15..15] Device IBI Time-stamp                                            */
            __IOM uint32_t DVDYAD  : 8; /*!< [23..16] Device I3C Dynamic Address                                       */
            uint32_t               : 5;
            __IOM uint32_t DVNACK  : 2; /*!< [30..29] Device NACK Retry Count                                          */
            __IOM uint32_t DVTYP   : 1; /*!< [31..31] Device Type                                                      */
        } DATBAS3_b;
    };
    __IM uint32_t RESERVED22[24];

    union
    {
        __IOM uint32_t EXDATBAS;       /*!< (@ 0x000002A0) Extended Device Address Table Basic Register               */

        struct
        {
            __IOM uint32_t EDSTAD : 7; /*!< [6..0] Extended Device Static Address                                     */
            uint32_t              : 9;
            __IOM uint32_t EDDYAD : 8; /*!< [23..16] Extended Device I3C Dynamic Address                              */
            uint32_t              : 5;
            __IOM uint32_t EDNACK : 2; /*!< [30..29] Extended Device NACK Retry Count                                 */
            __IOM uint32_t EDTYP  : 1; /*!< [31..31] Extended Device Type                                             */
        } EXDATBAS_b;
    };
    __IM uint32_t RESERVED23[3];

    union
    {
        __IOM uint32_t SDATBAS0;         /*!< (@ 0x000002B0) Slave Device Address Table Basic Register 0                */

        struct
        {
            __IOM uint32_t SDSTAD  : 10; /*!< [9..0] Slave Device Static Address                                        */
            __IOM uint32_t SDADLS  : 1;  /*!< [10..10] Slave Device Address Length Selection                            */
            uint32_t               : 1;
            __IOM uint32_t SDIBIPL : 1;  /*!< [12..12] Slave Device IBI Payload                                         */
            uint32_t               : 3;
            __IOM uint32_t SDDYAD  : 7;  /*!< [22..16] Slave Device I3C Dynamic Address                                 */
            uint32_t               : 9;
        } SDATBAS0_b;
    };

    union
    {
        __IOM uint32_t SDATBAS1;         /*!< (@ 0x000002B4) Slave Device Address Table Basic Register 1                */

        struct
        {
            __IOM uint32_t SDSTAD  : 10; /*!< [9..0] Slave Device Static Address                                        */
            __IOM uint32_t SDADLS  : 1;  /*!< [10..10] Slave Device Address Length Selection                            */
            uint32_t               : 1;
            __IOM uint32_t SDIBIPL : 1;  /*!< [12..12] Slave Device IBI Payload                                         */
            uint32_t               : 3;
            __IOM uint32_t SDDYAD  : 7;  /*!< [22..16] Slave Device I3C Dynamic Address                                 */
            uint32_t               : 9;
        } SDATBAS1_b;
    };

    union
    {
        __IOM uint32_t SDATBAS2;         /*!< (@ 0x000002B8) Slave Device Address Table Basic Register 2                */

        struct
        {
            __IOM uint32_t SDSTAD  : 10; /*!< [9..0] Slave Device Static Address                                        */
            __IOM uint32_t SDADLS  : 1;  /*!< [10..10] Slave Device Address Length Selection                            */
            uint32_t               : 1;
            __IOM uint32_t SDIBIPL : 1;  /*!< [12..12] Slave Device IBI Payload                                         */
            uint32_t               : 3;
            __IOM uint32_t SDDYAD  : 7;  /*!< [22..16] Slave Device I3C Dynamic Address                                 */
            uint32_t               : 9;
        } SDATBAS2_b;
    };
    __IM uint32_t RESERVED24[5];

    union
    {
        __IOM uint32_t MSDCT0;         /*!< (@ 0x000002D0) Master Device Characteristic Table Register 0              */

        struct
        {
            uint32_t              : 8;
            __IOM uint32_t RBCR0  : 1; /*!< [8..8] Max Data Speed Limitation                                          */
            __IOM uint32_t RBCR1  : 1; /*!< [9..9] IBI Request Capable                                                */
            __IOM uint32_t RBCR2  : 1; /*!< [10..10] IBI Payload                                                      */
            __IOM uint32_t RBCR3  : 1; /*!< [11..11] Offline Capable                                                  */
            uint32_t              : 2;
            __IOM uint32_t RBCR76 : 2; /*!< [15..14] Device Role                                                      */
            uint32_t              : 16;
        } MSDCT0_b;
    };

    union
    {
        __IOM uint32_t MSDCT1;         /*!< (@ 0x000002D4) Master Device Characteristic Table Register 1              */

        struct
        {
            uint32_t              : 8;
            __IOM uint32_t RBCR0  : 1; /*!< [8..8] Max Data Speed Limitation                                          */
            __IOM uint32_t RBCR1  : 1; /*!< [9..9] IBI Request Capable                                                */
            __IOM uint32_t RBCR2  : 1; /*!< [10..10] IBI Payload                                                      */
            __IOM uint32_t RBCR3  : 1; /*!< [11..11] Offline Capable                                                  */
            uint32_t              : 2;
            __IOM uint32_t RBCR76 : 2; /*!< [15..14] Device Role                                                      */
            uint32_t              : 16;
        } MSDCT1_b;
    };

    union
    {
        __IOM uint32_t MSDCT2;         /*!< (@ 0x000002D8) Master Device Characteristic Table Register 2              */

        struct
        {
            uint32_t              : 8;
            __IOM uint32_t RBCR0  : 1; /*!< [8..8] Max Data Speed Limitation                                          */
            __IOM uint32_t RBCR1  : 1; /*!< [9..9] IBI Request Capable                                                */
            __IOM uint32_t RBCR2  : 1; /*!< [10..10] IBI Payload                                                      */
            __IOM uint32_t RBCR3  : 1; /*!< [11..11] Offline Capable                                                  */
            uint32_t              : 2;
            __IOM uint32_t RBCR76 : 2; /*!< [15..14] Device Role                                                      */
            uint32_t              : 16;
        } MSDCT2_b;
    };

    union
    {
        __IOM uint32_t MSDCT3;         /*!< (@ 0x000002DC) Master Device Characteristic Table Register 3              */

        struct
        {
            uint32_t              : 8;
            __IOM uint32_t RBCR0  : 1; /*!< [8..8] Max Data Speed Limitation                                          */
            __IOM uint32_t RBCR1  : 1; /*!< [9..9] IBI Request Capable                                                */
            __IOM uint32_t RBCR2  : 1; /*!< [10..10] IBI Payload                                                      */
            __IOM uint32_t RBCR3  : 1; /*!< [11..11] Offline Capable                                                  */
            uint32_t              : 2;
            __IOM uint32_t RBCR76 : 2; /*!< [15..14] Device Role                                                      */
            uint32_t              : 16;
        } MSDCT3_b;
    };
    __IM uint32_t RESERVED25[16];

    union
    {
        __IOM uint32_t SVDCT;          /*!< (@ 0x00000320) Slave Device Characteristic Table Register                 */

        struct
        {
            __IOM uint32_t TDCR   : 8; /*!< [7..0] Transfar Device Characteristic Register                            */
            __IOM uint32_t TBCR0  : 1; /*!< [8..8] Max Data Speed Limitation                                          */
            __IOM uint32_t TBCR1  : 1; /*!< [9..9] IBI Request Capable                                                */
            __IOM uint32_t TBCR2  : 1; /*!< [10..10] IBI Payload                                                      */
            __IOM uint32_t TBCR3  : 1; /*!< [11..11] Offline Capable                                                  */
            uint32_t              : 2;
            __IOM uint32_t TBCR76 : 2; /*!< [15..14] Device Role                                                      */
            uint32_t              : 16;
        } SVDCT_b;
    };
    __IOM uint32_t SDCTPIDL;           /*!< (@ 0x00000324) Slave Device Characteristic Table Provisional
                                        *                  ID Low Register                                            */
    __IOM uint32_t SDCTPIDH;           /*!< (@ 0x00000328) Slave Device Characteristic Table Provisional
                                        *                  ID High Register                                           */
    __IM uint32_t RESERVED26;

    union
    {
        __IM uint32_t SVDVAD0;         /*!< (@ 0x00000330) Slave Device Address Register 0                            */

        struct
        {
            uint32_t             : 16;
            __IM uint32_t SVAD   : 10; /*!< [25..16] Slave Address                                                    */
            uint32_t             : 1;
            __IM uint32_t SADLG  : 1;  /*!< [27..27] Slave Address Length                                             */
            uint32_t             : 2;
            __IM uint32_t SSTADV : 1;  /*!< [30..30] Slave Static Address Valid                                       */
            __IM uint32_t SDYADV : 1;  /*!< [31..31] Slave Dynamic Address Valid                                      */
        } SVDVAD0_b;
    };
    __IM uint32_t RESERVED27[7];

    union
    {
        __IOM uint32_t CSECMD;         /*!< (@ 0x00000350) CCC Slave Events Command Register                          */

        struct
        {
            __IOM uint32_t SVIRQE : 1; /*!< [0..0] Slave Interrupt Requests Enable                                    */
            __IOM uint32_t MSRQE  : 1; /*!< [1..1] Mastership Requests Enable                                         */
            uint32_t              : 1;
            __IOM uint32_t HJEVE  : 1; /*!< [3..3] Hot-Join Event Enable                                              */
            uint32_t              : 28;
        } CSECMD_b;
    };

    union
    {
        __IOM uint32_t CEACTST;        /*!< (@ 0x00000354) CCC Enter Activity State Register                          */

        struct
        {
            __IOM uint32_t ACTST : 4;  /*!< [3..0] Activity State                                                     */
            uint32_t             : 28;
        } CEACTST_b;
    };

    union
    {
        __IOM uint32_t CMWLG;          /*!< (@ 0x00000358) CCC Max Write Length Register                              */

        struct
        {
            __IOM uint32_t MWLG : 16;  /*!< [15..0] Max Write Length                                                  */
            uint32_t            : 16;
        } CMWLG_b;
    };

    union
    {
        __IOM uint32_t CMRLG;           /*!< (@ 0x0000035C) CCC Max Read Length Register                               */

        struct
        {
            __IOM uint32_t MRLG   : 16; /*!< [15..0] Max Read Length                                                   */
            __IOM uint32_t IBIPSZ : 8;  /*!< [23..16] IBI Payload Size                                                 */
            uint32_t              : 8;
        } CMRLG_b;
    };

    union
    {
        __IM uint32_t CETSTMD;         /*!< (@ 0x00000360) CCC Enter Test Mode Register                               */

        struct
        {
            __IM uint32_t TSTMD : 8;   /*!< [7..0] Test Mode                                                          */
            uint32_t            : 24;
        } CETSTMD_b;
    };

    union
    {
        __IOM uint32_t CGDVST;         /*!< (@ 0x00000364) CCC Get Device Status Register                             */

        struct
        {
            __IOM uint32_t PNDINT : 4; /*!< [3..0] Pending Interrupt                                                  */
            uint32_t              : 1;
            __IOM uint32_t PRTE   : 1; /*!< [5..5] Protocol Error                                                     */
            __IOM uint32_t ACTMD  : 2; /*!< [7..6] Slave Device's current Activity Mode                               */
            __IOM uint32_t VDRSV  : 8; /*!< [15..8] Vendor Reserved                                                   */
            uint32_t              : 16;
        } CGDVST_b;
    };

    union
    {
        __IOM uint32_t CMDSPW;         /*!< (@ 0x00000368) CCC Max Data Speed W (Write) Register                      */

        struct
        {
            __IOM uint32_t MSWDR : 3;  /*!< [2..0] Maximum Sustained Write Data Rate                                  */
            uint32_t             : 29;
        } CMDSPW_b;
    };

    union
    {
        __IOM uint32_t CMDSPR;         /*!< (@ 0x0000036C) CCC Max Data Speed R (Read) Register                       */

        struct
        {
            __IOM uint32_t MSRDR  : 3; /*!< [2..0] Maximum Sustained Read Data Rate                                   */
            __IOM uint32_t CDTTIM : 3; /*!< [5..3] Clock to Data Turnaround Time (TSCO)                               */
            uint32_t              : 26;
        } CMDSPR_b;
    };

    union
    {
        __IOM uint32_t CMDSPT;          /*!< (@ 0x00000370) CCC Max Data Speed T (Turnaround) Register                 */

        struct
        {
            __IOM uint32_t MRTTIM : 24; /*!< [23..0] Maximum Read Turnaround Time                                      */
            uint32_t              : 7;
            __IOM uint32_t MRTE   : 1;  /*!< [31..31] Maximum Read Turnaround Time Enable                              */
        } CMDSPT_b;
    };

    union
    {
        __IOM uint32_t CETSM;          /*!< (@ 0x00000374) CCC Exchange Timing Support Information M (Mode)
                                        *                  Register                                                   */

        struct
        {
            uint32_t            : 8;
            __IOM uint32_t FREQ : 8;   /*!< [15..8] Frequency Byte                                                    */
            __IOM uint32_t INAC : 8;   /*!< [23..16] Inaccuracy Byte                                                  */
            uint32_t            : 8;
        } CETSM_b;
    };
    __IM uint32_t RESERVED28[2];

    union
    {
        __IOM uint32_t BITCNT;         /*!< (@ 0x00000380) Bit Count Register                                         */

        struct
        {
            __IOM uint32_t BCNT  : 5;  /*!< [4..0] Bit Counter                                                        */
            uint32_t             : 2;
            __OM uint32_t BCNTWP : 1;  /*!< [7..7] BCNT Write Protect                                                 */
            uint32_t             : 24;
        } BITCNT_b;
    };
    __IM uint32_t RESERVED29[4];

    union
    {
        __IM uint32_t NQSTLV;          /*!< (@ 0x00000394) Normal Queue Status Level Register                         */

        struct
        {
            __IM uint32_t CMDQFLV : 8; /*!< [7..0] Normal Command Queue Free Level                                    */
            __IM uint32_t RSPQLV  : 8; /*!< [15..8] Normal Response Queue Level                                       */
            __IM uint32_t IBIQLV  : 8; /*!< [23..16] Normal IBI Queue Level                                           */
            __IM uint32_t IBISCNT : 5; /*!< [28..24] Normal IBI Status Count                                          */
            uint32_t              : 3;
        } NQSTLV_b;
    };

    union
    {
        __IM uint32_t NDBSTLV0;        /*!< (@ 0x00000398) Normal Data Buffer Status Level Register                   */

        struct
        {
            __IM uint32_t TDBFLV : 8;  /*!< [7..0] Normal Transmit Data Buffer Free Level                             */
            __IM uint32_t RDBLV  : 8;  /*!< [15..8] Normal Receive Data Buffer Level                                  */
            uint32_t             : 16;
        } NDBSTLV0_b;
    };
    __IM uint32_t RESERVED30[9];

    union
    {
        __IM uint32_t NRSQSTLV;        /*!< (@ 0x000003C0) Normal Receive Status Queue Status Level Register          */

        struct
        {
            __IM uint32_t RSQLV : 8;   /*!< [7..0] Normal Receive Status Queue Level                                  */
            uint32_t            : 24;
        } NRSQSTLV_b;
    };
    __IM uint32_t RESERVED31[2];

    union
    {
        __IM uint32_t PRSTDBG;         /*!< (@ 0x000003CC) Present State Debug Register                               */

        struct
        {
            __IM uint32_t SCILV : 1;   /*!< [0..0] SCL Line Signal Level                                              */
            __IM uint32_t SDILV : 1;   /*!< [1..1] SDA Line Signal Level                                              */
            __IM uint32_t SCOLV : 1;   /*!< [2..2] SCL Output Level                                                   */
            __IM uint32_t SDOLV : 1;   /*!< [3..3] SDA Output Level                                                   */
            uint32_t            : 28;
        } PRSTDBG_b;
    };

    union
    {
        __IM uint32_t MSERRCNT;        /*!< (@ 0x000003D0) Master Error Counters Register                             */

        struct
        {
            __IM uint32_t M2ECNT : 8;  /*!< [7..0] M2 Error Counter                                                   */
            uint32_t             : 24;
        } MSERRCNT_b;
    };
} R_I3C0_Type;                         /*!< Size = 980 (0x3d4)                                                        */

/* =========================================================================================================================== */
/* ================                                        R_MPU_MMPU                                         ================ */
/* =========================================================================================================================== */

/**
 * @brief Bus Master MPU (R_MPU_MMPU)
 */

typedef struct                          /*!< (@ 0x40000000) R_MPU_MMPU Structure                                       */
{
    __IOM R_MPU_MMPU_MMPU_Type MMPU[3]; /*!< (@ 0x00000000) Bus Master MPU Registers                                   */
} R_MPU_MMPU_Type;                      /*!< Size = 3072 (0xc00)                                                       */

/* =========================================================================================================================== */
/* ================                                        R_MPU_SMPU                                         ================ */
/* =========================================================================================================================== */

/**
 * @brief Bus Slave MPU (R_MPU_SMPU)
 */

typedef struct                           /*!< (@ 0x40000C00) R_MPU_SMPU Structure                                       */
{
    union
    {
        __IOM uint16_t SMPUCTL;          /*!< (@ 0x00000000) Slave MPU Control Register                                 */

        struct
        {
            __IOM uint16_t OAD     : 1;  /*!< [0..0] Master Group enable                                                */
            __IOM uint16_t PROTECT : 1;  /*!< [1..1] Protection of register                                             */
            uint16_t               : 6;
            __OM uint16_t KEY      : 8;  /*!< [15..8] Key Code This bit is used to enable or disable rewriting
                                          *   of the PROTECT and OAD bit.                                               */
        } SMPUCTL_b;
    };
    __IM uint16_t              RESERVED[7];
    __IOM R_MPU_SMPU_SMPU_Type SMPU[10]; /*!< (@ 0x00000010) Access Control Structure for MBIU                          */
} R_MPU_SMPU_Type;                       /*!< Size = 56 (0x38)                                                          */

/* =========================================================================================================================== */
/* ================                                        R_MPU_SPMON                                        ================ */
/* =========================================================================================================================== */

/**
 * @brief CPU Stack Pointer Monitor (R_MPU_SPMON)
 */

typedef struct                         /*!< (@ 0x40000D00) R_MPU_SPMON Structure                                      */
{
    __IOM R_MPU_SPMON_SP_Type SP[2];   /*!< (@ 0x00000000) Stack Pointer Monitor                                      */
} R_MPU_SPMON_Type;                    /*!< Size = 32 (0x20)                                                          */

/* =========================================================================================================================== */
/* ================                                          R_MSTP                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief System-Module Stop (R_MSTP)
 */

typedef struct                          /*!< (@ 0x40084000) R_MSTP Structure                                           */
{
    union
    {
        __IOM uint32_t MSTPCRA;         /*!< (@ 0x00000000) Module Stop Control Register A                             */

        struct
        {
            __IOM uint32_t MSTPA0  : 1; /*!< [0..0] Module stop bit 0. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA1  : 1; /*!< [1..1] Module stop bit 1. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA2  : 1; /*!< [2..2] Module stop bit 2. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA3  : 1; /*!< [3..3] Module stop bit 3. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA4  : 1; /*!< [4..4] Module stop bit 4. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA5  : 1; /*!< [5..5] Module stop bit 5. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA6  : 1; /*!< [6..6] Module stop bit 6. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA7  : 1; /*!< [7..7] Module stop bit 7. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA8  : 1; /*!< [8..8] Module stop bit 8. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA9  : 1; /*!< [9..9] Module stop bit 9. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA10 : 1; /*!< [10..10] Module stop bit 10. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA11 : 1; /*!< [11..11] Module stop bit 11. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA12 : 1; /*!< [12..12] Module stop bit 12. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA13 : 1; /*!< [13..13] Module stop bit 13. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA14 : 1; /*!< [14..14] Module stop bit 14. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA15 : 1; /*!< [15..15] Module stop bit 15. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA16 : 1; /*!< [16..16] Module stop bit 16. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA17 : 1; /*!< [17..17] Module stop bit 17. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA18 : 1; /*!< [18..18] Module stop bit 18. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA19 : 1; /*!< [19..19] Module stop bit 19. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA20 : 1; /*!< [20..20] Module stop bit 20. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA21 : 1; /*!< [21..21] Module stop bit 21. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA22 : 1; /*!< [22..22] Module stop bit 22. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA23 : 1; /*!< [23..23] Module stop bit 23. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA24 : 1; /*!< [24..24] Module stop bit 24. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA25 : 1; /*!< [25..25] Module stop bit 25. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA26 : 1; /*!< [26..26] Module stop bit 26. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA27 : 1; /*!< [27..27] Module stop bit 27. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA28 : 1; /*!< [28..28] Module stop bit 28. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA29 : 1; /*!< [29..29] Module stop bit 29. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA30 : 1; /*!< [30..30] Module stop bit 30. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA31 : 1; /*!< [31..31] Module stop bit 31. See device hardware manual for
                                         *   usage.                                                                    */
        } MSTPCRA_b;
    };

    union
    {
        __IOM uint32_t MSTPCRB;         /*!< (@ 0x00000004) Module Stop Control Register B                             */

        struct
        {
            __IOM uint32_t MSTPB0  : 1; /*!< [0..0] Module stop bit 0. See device hardware manual for usage.           */
            __IOM uint32_t MSTPB1  : 1; /*!< [1..1] Module stop bit 1. See device hardware manual for usage.           */
            __IOM uint32_t MSTPB2  : 1; /*!< [2..2] Module stop bit 2. See device hardware manual for usage.           */
            __IOM uint32_t MSTPB3  : 1; /*!< [3..3] Module stop bit 3. See device hardware manual for usage.           */
            __IOM uint32_t MSTPB4  : 1; /*!< [4..4] Module stop bit 4. See device hardware manual for usage.           */
            __IOM uint32_t MSTPB5  : 1; /*!< [5..5] Module stop bit 5. See device hardware manual for usage.           */
            __IOM uint32_t MSTPB6  : 1; /*!< [6..6] Module stop bit 6. See device hardware manual for usage.           */
            __IOM uint32_t MSTPB7  : 1; /*!< [7..7] Module stop bit 7. See device hardware manual for usage.           */
            __IOM uint32_t MSTPB8  : 1; /*!< [8..8] Module stop bit 8. See device hardware manual for usage.           */
            __IOM uint32_t MSTPB9  : 1; /*!< [9..9] Module stop bit 9. See device hardware manual for usage.           */
            __IOM uint32_t MSTPB10 : 1; /*!< [10..10] Module stop bit 10. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB11 : 1; /*!< [11..11] Module stop bit 11. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB12 : 1; /*!< [12..12] Module stop bit 12. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB13 : 1; /*!< [13..13] Module stop bit 13. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB14 : 1; /*!< [14..14] Module stop bit 14. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB15 : 1; /*!< [15..15] Module stop bit 15. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB16 : 1; /*!< [16..16] Module stop bit 16. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB17 : 1; /*!< [17..17] Module stop bit 17. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB18 : 1; /*!< [18..18] Module stop bit 18. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB19 : 1; /*!< [19..19] Module stop bit 19. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB20 : 1; /*!< [20..20] Module stop bit 20. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB21 : 1; /*!< [21..21] Module stop bit 21. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB22 : 1; /*!< [22..22] Module stop bit 22. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB23 : 1; /*!< [23..23] Module stop bit 23. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB24 : 1; /*!< [24..24] Module stop bit 24. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB25 : 1; /*!< [25..25] Module stop bit 25. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB26 : 1; /*!< [26..26] Module stop bit 26. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB27 : 1; /*!< [27..27] Module stop bit 27. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB28 : 1; /*!< [28..28] Module stop bit 28. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB29 : 1; /*!< [29..29] Module stop bit 29. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB30 : 1; /*!< [30..30] Module stop bit 30. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB31 : 1; /*!< [31..31] Module stop bit 31. See device hardware manual for
                                         *   usage.                                                                    */
        } MSTPCRB_b;
    };

    union
    {
        __IOM uint32_t MSTPCRC;         /*!< (@ 0x00000008) Module Stop Control Register C                             */

        struct
        {
            __IOM uint32_t MSTPC0  : 1; /*!< [0..0] Module stop bit 0. See device hardware manual for usage.           */
            __IOM uint32_t MSTPC1  : 1; /*!< [1..1] Module stop bit 1. See device hardware manual for usage.           */
            __IOM uint32_t MSTPC2  : 1; /*!< [2..2] Module stop bit 2. See device hardware manual for usage.           */
            __IOM uint32_t MSTPC3  : 1; /*!< [3..3] Module stop bit 3. See device hardware manual for usage.           */
            __IOM uint32_t MSTPC4  : 1; /*!< [4..4] Module stop bit 4. See device hardware manual for usage.           */
            __IOM uint32_t MSTPC5  : 1; /*!< [5..5] Module stop bit 5. See device hardware manual for usage.           */
            __IOM uint32_t MSTPC6  : 1; /*!< [6..6] Module stop bit 6. See device hardware manual for usage.           */
            __IOM uint32_t MSTPC7  : 1; /*!< [7..7] Module stop bit 7. See device hardware manual for usage.           */
            __IOM uint32_t MSTPC8  : 1; /*!< [8..8] Module stop bit 8. See device hardware manual for usage.           */
            __IOM uint32_t MSTPC9  : 1; /*!< [9..9] Module stop bit 9. See device hardware manual for usage.           */
            __IOM uint32_t MSTPC10 : 1; /*!< [10..10] Module stop bit 10. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC11 : 1; /*!< [11..11] Module stop bit 11. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC12 : 1; /*!< [12..12] Module stop bit 12. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC13 : 1; /*!< [13..13] Module stop bit 13. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC14 : 1; /*!< [14..14] Module stop bit 14. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC15 : 1; /*!< [15..15] Module stop bit 15. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC16 : 1; /*!< [16..16] Module stop bit 16. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC17 : 1; /*!< [17..17] Module stop bit 17. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC18 : 1; /*!< [18..18] Module stop bit 18. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC19 : 1; /*!< [19..19] Module stop bit 19. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC20 : 1; /*!< [20..20] Module stop bit 20. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC21 : 1; /*!< [21..21] Module stop bit 21. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC22 : 1; /*!< [22..22] Module stop bit 22. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC23 : 1; /*!< [23..23] Module stop bit 23. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC24 : 1; /*!< [24..24] Module stop bit 24. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC25 : 1; /*!< [25..25] Module stop bit 25. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC26 : 1; /*!< [26..26] Module stop bit 26. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC27 : 1; /*!< [27..27] Module stop bit 27. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC28 : 1; /*!< [28..28] Module stop bit 28. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC29 : 1; /*!< [29..29] Module stop bit 29. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC30 : 1; /*!< [30..30] Module stop bit 30. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC31 : 1; /*!< [31..31] Module stop bit 31. See device hardware manual for
                                         *   usage.                                                                    */
        } MSTPCRC_b;
    };

    union
    {
        __IOM uint32_t MSTPCRD;         /*!< (@ 0x0000000C) Module Stop Control Register D                             */

        struct
        {
            __IOM uint32_t MSTPD0  : 1; /*!< [0..0] Module stop bit 0. See device hardware manual for usage.           */
            __IOM uint32_t MSTPD1  : 1; /*!< [1..1] Module stop bit 1. See device hardware manual for usage.           */
            __IOM uint32_t MSTPD2  : 1; /*!< [2..2] Module stop bit 2. See device hardware manual for usage.           */
            __IOM uint32_t MSTPD3  : 1; /*!< [3..3] Module stop bit 3. See device hardware manual for usage.           */
            __IOM uint32_t MSTPD4  : 1; /*!< [4..4] Module stop bit 4. See device hardware manual for usage.           */
            __IOM uint32_t MSTPD5  : 1; /*!< [5..5] Module stop bit 5. See device hardware manual for usage.           */
            __IOM uint32_t MSTPD6  : 1; /*!< [6..6] Module stop bit 6. See device hardware manual for usage.           */
            __IOM uint32_t MSTPD7  : 1; /*!< [7..7] Module stop bit 7. See device hardware manual for usage.           */
            __IOM uint32_t MSTPD8  : 1; /*!< [8..8] Module stop bit 8. See device hardware manual for usage.           */
            __IOM uint32_t MSTPD9  : 1; /*!< [9..9] Module stop bit 9. See device hardware manual for usage.           */
            __IOM uint32_t MSTPD10 : 1; /*!< [10..10] Module stop bit 10. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD11 : 1; /*!< [11..11] Module stop bit 11. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD12 : 1; /*!< [12..12] Module stop bit 12. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD13 : 1; /*!< [13..13] Module stop bit 13. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD14 : 1; /*!< [14..14] Module stop bit 14. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD15 : 1; /*!< [15..15] Module stop bit 15. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD16 : 1; /*!< [16..16] Module stop bit 16. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD17 : 1; /*!< [17..17] Module stop bit 17. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD18 : 1; /*!< [18..18] Module stop bit 18. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD19 : 1; /*!< [19..19] Module stop bit 19. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD20 : 1; /*!< [20..20] Module stop bit 20. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD21 : 1; /*!< [21..21] Module stop bit 21. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD22 : 1; /*!< [22..22] Module stop bit 22. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD23 : 1; /*!< [23..23] Module stop bit 23. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD24 : 1; /*!< [24..24] Module stop bit 24. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD25 : 1; /*!< [25..25] Module stop bit 25. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD26 : 1; /*!< [26..26] Module stop bit 26. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD27 : 1; /*!< [27..27] Module stop bit 27. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD28 : 1; /*!< [28..28] Module stop bit 28. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD29 : 1; /*!< [29..29] Module stop bit 29. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD30 : 1; /*!< [30..30] Module stop bit 30. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD31 : 1; /*!< [31..31] Module stop bit 31. See device hardware manual for
                                         *   usage.                                                                    */
        } MSTPCRD_b;
    };

    union
    {
        __IOM uint32_t MSTPCRE;         /*!< (@ 0x00000010) Module Stop Control Register E                             */

        struct
        {
            __IOM uint32_t MSTPE0  : 1; /*!< [0..0] Module stop bit 0. See device hardware manual for usage.           */
            __IOM uint32_t MSTPE1  : 1; /*!< [1..1] Module stop bit 1. See device hardware manual for usage.           */
            __IOM uint32_t MSTPE2  : 1; /*!< [2..2] Module stop bit 2. See device hardware manual for usage.           */
            __IOM uint32_t MSTPE3  : 1; /*!< [3..3] Module stop bit 3. See device hardware manual for usage.           */
            __IOM uint32_t MSTPE4  : 1; /*!< [4..4] Module stop bit 4. See device hardware manual for usage.           */
            __IOM uint32_t MSTPE5  : 1; /*!< [5..5] Module stop bit 5. See device hardware manual for usage.           */
            __IOM uint32_t MSTPE6  : 1; /*!< [6..6] Module stop bit 6. See device hardware manual for usage.           */
            __IOM uint32_t MSTPE7  : 1; /*!< [7..7] Module stop bit 7. See device hardware manual for usage.           */
            __IOM uint32_t MSTPE8  : 1; /*!< [8..8] Module stop bit 8. See device hardware manual for usage.           */
            __IOM uint32_t MSTPE9  : 1; /*!< [9..9] Module stop bit 9. See device hardware manual for usage.           */
            __IOM uint32_t MSTPE10 : 1; /*!< [10..10] Module stop bit 10. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPE11 : 1; /*!< [11..11] Module stop bit 11. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPE12 : 1; /*!< [12..12] Module stop bit 12. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPE13 : 1; /*!< [13..13] Module stop bit 13. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPE14 : 1; /*!< [14..14] Module stop bit 14. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPE15 : 1; /*!< [15..15] Module stop bit 15. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPE16 : 1; /*!< [16..16] Module stop bit 16. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPE17 : 1; /*!< [17..17] Module stop bit 17. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPE18 : 1; /*!< [18..18] Module stop bit 18. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPE19 : 1; /*!< [19..19] Module stop bit 19. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPE20 : 1; /*!< [20..20] Module stop bit 20. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPE21 : 1; /*!< [21..21] Module stop bit 21. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPE22 : 1; /*!< [22..22] Module stop bit 22. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPE23 : 1; /*!< [23..23] Module stop bit 23. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPE24 : 1; /*!< [24..24] Module stop bit 24. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPE25 : 1; /*!< [25..25] Module stop bit 25. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPE26 : 1; /*!< [26..26] Module stop bit 26. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPE27 : 1; /*!< [27..27] Module stop bit 27. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPE28 : 1; /*!< [28..28] Module stop bit 28. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPE29 : 1; /*!< [29..29] Module stop bit 29. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPE30 : 1; /*!< [30..30] Module stop bit 30. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPE31 : 1; /*!< [31..31] Module stop bit 31. See device hardware manual for
                                         *   usage.                                                                    */
        } MSTPCRE_b;
    };
} R_MSTP_Type;                          /*!< Size = 20 (0x14)                                                          */

/* =========================================================================================================================== */
/* ================                                          R_PORT0                                          ================ */
/* =========================================================================================================================== */

/**
 * @brief I/O Ports (R_PORT0)
 */

typedef struct                         /*!< (@ 0x40080000) R_PORT0 Structure                                          */
{
    union
    {
        union
        {
            __IOM uint32_t PCNTR1;        /*!< (@ 0x00000000) Port Control Register 1                                    */

            struct
            {
                __IOM uint32_t PDR  : 16; /*!< [15..0] Pmn Direction                                                     */
                __IOM uint32_t PODR : 16; /*!< [31..16] Pmn Output Data                                                  */
            } PCNTR1_b;
        };

        struct
        {
            union
            {
                __IOM uint16_t PODR;           /*!< (@ 0x00000000) Output data register                                       */

                struct
                {
                    __IOM uint16_t PODR0  : 1; /*!< [0..0] Pmn Output Data                                                    */
                    __IOM uint16_t PODR1  : 1; /*!< [1..1] Pmn Output Data                                                    */
                    __IOM uint16_t PODR2  : 1; /*!< [2..2] Pmn Output Data                                                    */
                    __IOM uint16_t PODR3  : 1; /*!< [3..3] Pmn Output Data                                                    */
                    __IOM uint16_t PODR4  : 1; /*!< [4..4] Pmn Output Data                                                    */
                    __IOM uint16_t PODR5  : 1; /*!< [5..5] Pmn Output Data                                                    */
                    __IOM uint16_t PODR6  : 1; /*!< [6..6] Pmn Output Data                                                    */
                    __IOM uint16_t PODR7  : 1; /*!< [7..7] Pmn Output Data                                                    */
                    __IOM uint16_t PODR8  : 1; /*!< [8..8] Pmn Output Data                                                    */
                    __IOM uint16_t PODR9  : 1; /*!< [9..9] Pmn Output Data                                                    */
                    __IOM uint16_t PODR10 : 1; /*!< [10..10] Pmn Output Data                                                  */
                    __IOM uint16_t PODR11 : 1; /*!< [11..11] Pmn Output Data                                                  */
                    __IOM uint16_t PODR12 : 1; /*!< [12..12] Pmn Output Data                                                  */
                    __IOM uint16_t PODR13 : 1; /*!< [13..13] Pmn Output Data                                                  */
                    __IOM uint16_t PODR14 : 1; /*!< [14..14] Pmn Output Data                                                  */
                    __IOM uint16_t PODR15 : 1; /*!< [15..15] Pmn Output Data                                                  */
                } PODR_b;
            };

            union
            {
                __IOM uint16_t PDR;           /*!< (@ 0x00000002) Data direction register                                    */

                struct
                {
                    __IOM uint16_t PDR0  : 1; /*!< [0..0] Pmn Direction                                                      */
                    __IOM uint16_t PDR1  : 1; /*!< [1..1] Pmn Direction                                                      */
                    __IOM uint16_t PDR2  : 1; /*!< [2..2] Pmn Direction                                                      */
                    __IOM uint16_t PDR3  : 1; /*!< [3..3] Pmn Direction                                                      */
                    __IOM uint16_t PDR4  : 1; /*!< [4..4] Pmn Direction                                                      */
                    __IOM uint16_t PDR5  : 1; /*!< [5..5] Pmn Direction                                                      */
                    __IOM uint16_t PDR6  : 1; /*!< [6..6] Pmn Direction                                                      */
                    __IOM uint16_t PDR7  : 1; /*!< [7..7] Pmn Direction                                                      */
                    __IOM uint16_t PDR8  : 1; /*!< [8..8] Pmn Direction                                                      */
                    __IOM uint16_t PDR9  : 1; /*!< [9..9] Pmn Direction                                                      */
                    __IOM uint16_t PDR10 : 1; /*!< [10..10] Pmn Direction                                                    */
                    __IOM uint16_t PDR11 : 1; /*!< [11..11] Pmn Direction                                                    */
                    __IOM uint16_t PDR12 : 1; /*!< [12..12] Pmn Direction                                                    */
                    __IOM uint16_t PDR13 : 1; /*!< [13..13] Pmn Direction                                                    */
                    __IOM uint16_t PDR14 : 1; /*!< [14..14] Pmn Direction                                                    */
                    __IOM uint16_t PDR15 : 1; /*!< [15..15] Pmn Direction                                                    */
                } PDR_b;
            };
        };
    };

    union
    {
        union
        {
            __IM uint32_t PCNTR2;        /*!< (@ 0x00000004) Port Control Register 2                                    */

            struct
            {
                __IM uint32_t PIDR : 16; /*!< [15..0] Pmn Input Data                                                    */
                __IM uint32_t EIDR : 16; /*!< [31..16] Pmn Event Input Data                                             */
            } PCNTR2_b;
        };

        struct
        {
            union
            {
                __IM uint16_t EIDR;           /*!< (@ 0x00000004) Event input data register                                  */

                struct
                {
                    __IM uint16_t EIDR0  : 1; /*!< [0..0] Pmn Event Input Data                                               */
                    __IM uint16_t EIDR1  : 1; /*!< [1..1] Pmn Event Input Data                                               */
                    __IM uint16_t EIDR2  : 1; /*!< [2..2] Pmn Event Input Data                                               */
                    __IM uint16_t EIDR3  : 1; /*!< [3..3] Pmn Event Input Data                                               */
                    __IM uint16_t EIDR4  : 1; /*!< [4..4] Pmn Event Input Data                                               */
                    __IM uint16_t EIDR5  : 1; /*!< [5..5] Pmn Event Input Data                                               */
                    __IM uint16_t EIDR6  : 1; /*!< [6..6] Pmn Event Input Data                                               */
                    __IM uint16_t EIDR7  : 1; /*!< [7..7] Pmn Event Input Data                                               */
                    __IM uint16_t EIDR8  : 1; /*!< [8..8] Pmn Event Input Data                                               */
                    __IM uint16_t EIDR9  : 1; /*!< [9..9] Pmn Event Input Data                                               */
                    __IM uint16_t EIDR10 : 1; /*!< [10..10] Pmn Event Input Data                                             */
                    __IM uint16_t EIDR11 : 1; /*!< [11..11] Pmn Event Input Data                                             */
                    __IM uint16_t EIDR12 : 1; /*!< [12..12] Pmn Event Input Data                                             */
                    __IM uint16_t EIDR13 : 1; /*!< [13..13] Pmn Event Input Data                                             */
                    __IM uint16_t EIDR14 : 1; /*!< [14..14] Pmn Event Input Data                                             */
                    __IM uint16_t EIDR15 : 1; /*!< [15..15] Pmn Event Input Data                                             */
                } EIDR_b;
            };

            union
            {
                __IM uint16_t PIDR;           /*!< (@ 0x00000006) Input data register                                        */

                struct
                {
                    __IM uint16_t PIDR0  : 1; /*!< [0..0] Pmn Input Data                                                     */
                    __IM uint16_t PIDR1  : 1; /*!< [1..1] Pmn Input Data                                                     */
                    __IM uint16_t PIDR2  : 1; /*!< [2..2] Pmn Input Data                                                     */
                    __IM uint16_t PIDR3  : 1; /*!< [3..3] Pmn Input Data                                                     */
                    __IM uint16_t PIDR4  : 1; /*!< [4..4] Pmn Input Data                                                     */
                    __IM uint16_t PIDR5  : 1; /*!< [5..5] Pmn Input Data                                                     */
                    __IM uint16_t PIDR6  : 1; /*!< [6..6] Pmn Input Data                                                     */
                    __IM uint16_t PIDR7  : 1; /*!< [7..7] Pmn Input Data                                                     */
                    __IM uint16_t PIDR8  : 1; /*!< [8..8] Pmn Input Data                                                     */
                    __IM uint16_t PIDR9  : 1; /*!< [9..9] Pmn Input Data                                                     */
                    __IM uint16_t PIDR10 : 1; /*!< [10..10] Pmn Input Data                                                   */
                    __IM uint16_t PIDR11 : 1; /*!< [11..11] Pmn Input Data                                                   */
                    __IM uint16_t PIDR12 : 1; /*!< [12..12] Pmn Input Data                                                   */
                    __IM uint16_t PIDR13 : 1; /*!< [13..13] Pmn Input Data                                                   */
                    __IM uint16_t PIDR14 : 1; /*!< [14..14] Pmn Input Data                                                   */
                    __IM uint16_t PIDR15 : 1; /*!< [15..15] Pmn Input Data                                                   */
                } PIDR_b;
            };
        };
    };

    union
    {
        union
        {
            __OM uint32_t PCNTR3;        /*!< (@ 0x00000008) Port Control Register 3                                    */

            struct
            {
                __OM uint32_t POSR : 16; /*!< [15..0] Pmn Output Set                                                    */
                __OM uint32_t PORR : 16; /*!< [31..16] Pmn Output Reset                                                 */
            } PCNTR3_b;
        };

        struct
        {
            union
            {
                __OM uint16_t PORR;           /*!< (@ 0x00000008) Output set register                                        */

                struct
                {
                    __OM uint16_t PORR0  : 1; /*!< [0..0] Pmn Output Reset                                                   */
                    __OM uint16_t PORR1  : 1; /*!< [1..1] Pmn Output Reset                                                   */
                    __OM uint16_t PORR2  : 1; /*!< [2..2] Pmn Output Reset                                                   */
                    __OM uint16_t PORR3  : 1; /*!< [3..3] Pmn Output Reset                                                   */
                    __OM uint16_t PORR4  : 1; /*!< [4..4] Pmn Output Reset                                                   */
                    __OM uint16_t PORR5  : 1; /*!< [5..5] Pmn Output Reset                                                   */
                    __OM uint16_t PORR6  : 1; /*!< [6..6] Pmn Output Reset                                                   */
                    __OM uint16_t PORR7  : 1; /*!< [7..7] Pmn Output Reset                                                   */
                    __OM uint16_t PORR8  : 1; /*!< [8..8] Pmn Output Reset                                                   */
                    __OM uint16_t PORR9  : 1; /*!< [9..9] Pmn Output Reset                                                   */
                    __OM uint16_t PORR10 : 1; /*!< [10..10] Pmn Output Reset                                                 */
                    __OM uint16_t PORR11 : 1; /*!< [11..11] Pmn Output Reset                                                 */
                    __OM uint16_t PORR12 : 1; /*!< [12..12] Pmn Output Reset                                                 */
                    __OM uint16_t PORR13 : 1; /*!< [13..13] Pmn Output Reset                                                 */
                    __OM uint16_t PORR14 : 1; /*!< [14..14] Pmn Output Reset                                                 */
                    __OM uint16_t PORR15 : 1; /*!< [15..15] Pmn Output Reset                                                 */
                } PORR_b;
            };

            union
            {
                __OM uint16_t POSR;           /*!< (@ 0x0000000A) Output reset register                                      */

                struct
                {
                    __OM uint16_t POSR0  : 1; /*!< [0..0] Pmn Output Set                                                     */
                    __OM uint16_t POSR1  : 1; /*!< [1..1] Pmn Output Set                                                     */
                    __OM uint16_t POSR2  : 1; /*!< [2..2] Pmn Output Set                                                     */
                    __OM uint16_t POSR3  : 1; /*!< [3..3] Pmn Output Set                                                     */
                    __OM uint16_t POSR4  : 1; /*!< [4..4] Pmn Output Set                                                     */
                    __OM uint16_t POSR5  : 1; /*!< [5..5] Pmn Output Set                                                     */
                    __OM uint16_t POSR6  : 1; /*!< [6..6] Pmn Output Set                                                     */
                    __OM uint16_t POSR7  : 1; /*!< [7..7] Pmn Output Set                                                     */
                    __OM uint16_t POSR8  : 1; /*!< [8..8] Pmn Output Set                                                     */
                    __OM uint16_t POSR9  : 1; /*!< [9..9] Pmn Output Set                                                     */
                    __OM uint16_t POSR10 : 1; /*!< [10..10] Pmn Output Set                                                   */
                    __OM uint16_t POSR11 : 1; /*!< [11..11] Pmn Output Set                                                   */
                    __OM uint16_t POSR12 : 1; /*!< [12..12] Pmn Output Set                                                   */
                    __OM uint16_t POSR13 : 1; /*!< [13..13] Pmn Output Set                                                   */
                    __OM uint16_t POSR14 : 1; /*!< [14..14] Pmn Output Set                                                   */
                    __OM uint16_t POSR15 : 1; /*!< [15..15] Pmn Output Set                                                   */
                } POSR_b;
            };
        };
    };

    union
    {
        union
        {
            __IOM uint32_t PCNTR4;        /*!< (@ 0x0000000C) Port Control Register 4                                    */

            struct
            {
                __IOM uint32_t EOSR : 16; /*!< [15..0] Pmn Event Output Set                                              */
                __IOM uint32_t EORR : 16; /*!< [31..16] Pmn Event Output Reset                                           */
            } PCNTR4_b;
        };

        struct
        {
            union
            {
                __IOM uint16_t EORR;           /*!< (@ 0x0000000C) Event output set register                                  */

                struct
                {
                    __IOM uint16_t EORR0  : 1; /*!< [0..0] Pmn Event Output Reset                                             */
                    __IOM uint16_t EORR1  : 1; /*!< [1..1] Pmn Event Output Reset                                             */
                    __IOM uint16_t EORR2  : 1; /*!< [2..2] Pmn Event Output Reset                                             */
                    __IOM uint16_t EORR3  : 1; /*!< [3..3] Pmn Event Output Reset                                             */
                    __IOM uint16_t EORR4  : 1; /*!< [4..4] Pmn Event Output Reset                                             */
                    __IOM uint16_t EORR5  : 1; /*!< [5..5] Pmn Event Output Reset                                             */
                    __IOM uint16_t EORR6  : 1; /*!< [6..6] Pmn Event Output Reset                                             */
                    __IOM uint16_t EORR7  : 1; /*!< [7..7] Pmn Event Output Reset                                             */
                    __IOM uint16_t EORR8  : 1; /*!< [8..8] Pmn Event Output Reset                                             */
                    __IOM uint16_t EORR9  : 1; /*!< [9..9] Pmn Event Output Reset                                             */
                    __IOM uint16_t EORR10 : 1; /*!< [10..10] Pmn Event Output Reset                                           */
                    __IOM uint16_t EORR11 : 1; /*!< [11..11] Pmn Event Output Reset                                           */
                    __IOM uint16_t EORR12 : 1; /*!< [12..12] Pmn Event Output Reset                                           */
                    __IOM uint16_t EORR13 : 1; /*!< [13..13] Pmn Event Output Reset                                           */
                    __IOM uint16_t EORR14 : 1; /*!< [14..14] Pmn Event Output Reset                                           */
                    __IOM uint16_t EORR15 : 1; /*!< [15..15] Pmn Event Output Reset                                           */
                } EORR_b;
            };

            union
            {
                __IOM uint16_t EOSR;           /*!< (@ 0x0000000E) Event output reset register                                */

                struct
                {
                    __IOM uint16_t EOSR0  : 1; /*!< [0..0] Pmn Event Output Set                                               */
                    __IOM uint16_t EOSR1  : 1; /*!< [1..1] Pmn Event Output Set                                               */
                    __IOM uint16_t EOSR2  : 1; /*!< [2..2] Pmn Event Output Set                                               */
                    __IOM uint16_t EOSR3  : 1; /*!< [3..3] Pmn Event Output Set                                               */
                    __IOM uint16_t EOSR4  : 1; /*!< [4..4] Pmn Event Output Set                                               */
                    __IOM uint16_t EOSR5  : 1; /*!< [5..5] Pmn Event Output Set                                               */
                    __IOM uint16_t EOSR6  : 1; /*!< [6..6] Pmn Event Output Set                                               */
                    __IOM uint16_t EOSR7  : 1; /*!< [7..7] Pmn Event Output Set                                               */
                    __IOM uint16_t EOSR8  : 1; /*!< [8..8] Pmn Event Output Set                                               */
                    __IOM uint16_t EOSR9  : 1; /*!< [9..9] Pmn Event Output Set                                               */
                    __IOM uint16_t EOSR10 : 1; /*!< [10..10] Pmn Event Output Set                                             */
                    __IOM uint16_t EOSR11 : 1; /*!< [11..11] Pmn Event Output Set                                             */
                    __IOM uint16_t EOSR12 : 1; /*!< [12..12] Pmn Event Output Set                                             */
                    __IOM uint16_t EOSR13 : 1; /*!< [13..13] Pmn Event Output Set                                             */
                    __IOM uint16_t EOSR14 : 1; /*!< [14..14] Pmn Event Output Set                                             */
                    __IOM uint16_t EOSR15 : 1; /*!< [15..15] Pmn Event Output Set                                             */
                } EOSR_b;
            };
        };
    };
} R_PORT0_Type;                        /*!< Size = 16 (0x10)                                                          */

/* =========================================================================================================================== */
/* ================                                           R_PFS                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief I/O Ports-PFS (R_PFS)
 */

typedef struct                           /*!< (@ 0x40080800) R_PFS Structure                                            */
{
    union
    {
        __IOM R_PFS_PORT_Type  PORT[15]; /*!< (@ 0x00000000) Port [0..14]                                               */
        __IOM R_PFS_VLSEL_Type VLSEL;    /*!< (@ 0x00000000) VLSEL                                                      */
    };
} R_PFS_Type;                            /*!< Size = 960 (0x3c0)                                                        */

/* =========================================================================================================================== */
/* ================                                          R_PMISC                                          ================ */
/* =========================================================================================================================== */

/**
 * @brief I/O Ports-MISC (R_PMISC)
 */

typedef struct                         /*!< (@ 0x40080D00) R_PMISC Structure                                          */
{
    union
    {
        __IOM uint8_t PFENET;          /*!< (@ 0x00000000) Ethernet Control Register                                  */

        struct
        {
            uint8_t                : 4;
            __IOM uint8_t PHYMODE0 : 1; /*!< [4..4] Ethernet Mode Setting ch0                                          */
            __IOM uint8_t PHYMODE1 : 1; /*!< [5..5] Ethernet Mode Setting ch1                                          */
            uint8_t                : 2;
        } PFENET_b;
    };
    __IM uint8_t RESERVED[2];

    union
    {
        __IOM uint8_t PWPR;            /*!< (@ 0x00000003) Write-Protect Register                                     */

        struct
        {
            uint8_t             : 6;
            __IOM uint8_t PFSWE : 1;   /*!< [6..6] PmnPFS Register Write                                              */
            __IOM uint8_t B0WI  : 1;   /*!< [7..7] PFSWE Bit Write Disable                                            */
        } PWPR_b;
    };
    __IM uint8_t RESERVED1;

    union
    {
        __IOM uint8_t PWPRS;           /*!< (@ 0x00000005) Write-Protect Register for Secure                          */

        struct
        {
            uint8_t             : 6;
            __IOM uint8_t PFSWE : 1;    /*!< [6..6] PmnPFS Register Write                                              */
            __IOM uint8_t B0WI  : 1;    /*!< [7..7] PFSWE Bit Write Disable                                            */
        } PWPRS_b;
    };
    __IM uint16_t            RESERVED2[5];
    __IOM R_PMISC_PMSAR_Type PMSAR[12]; /*!< (@ 0x00000010) Port Security Attribution Register                         */
} R_PMISC_Type;                         /*!< Size = 40 (0x28)                                                          */

/* =========================================================================================================================== */
/* ================                                           R_RTC                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Reset Control (R_RTC)
 */

typedef struct                         /*!< (@ 0x40083000) R_RTC Structure                                            */
{
    __IM uint8_t  RESERVED[34];
    __IOM uint8_t RCR1;                /*!< (@ 0x00000022) Reset Control Register 1                                   */
    __IM uint8_t  RESERVED1;

    union
    {
        __IOM uint8_t RCR2;            /*!< (@ 0x00000024) Reset Control Register 2                                   */

        struct
        {
            uint8_t             : 1;
            __IOM uint8_t RESET : 1;   /*!< [1..1] Software Reset                                                     */
            uint8_t             : 6;
        } RCR2_b;
    };
    __IM uint8_t RESERVED2[3];

    union
    {
        __IOM uint8_t RCR4;            /*!< (@ 0x00000028) Reset Control Register 4                                   */

        struct
        {
            __IOM uint8_t RCKSEL : 1;  /*!< [0..0] Count Source Select                                                */
            uint8_t              : 7;
        } RCR4_b;
    };
    __IM uint8_t           RESERVED3[23];
    __IOM R_RTC_RTCCR_Type RTCCR[2];   /*!< (@ 0x00000040) AGTIO I/O direction control register                       */
} R_RTC_Type;                          /*!< Size = 68 (0x44)                                                          */

/* =========================================================================================================================== */
/* ================                                          R_SCI0                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Serial Communications Interface (R_SCI0)
 */

typedef struct                         /*!< (@ 0x40118000) R_SCI0 Structure                                           */
{
    union
    {
        union
        {
            __IOM uint8_t SMR;          /*!< (@ 0x00000000) Serial Mode Register (SCMR.SMIF = 0)                       */

            struct
            {
                __IOM uint8_t CKS  : 2; /*!< [1..0] Clock Select                                                       */
                __IOM uint8_t MP   : 1; /*!< [2..2] Multi-Processor Mode(Valid only in asynchronous mode)              */
                __IOM uint8_t STOP : 1; /*!< [3..3] Stop Bit Length(Valid only in asynchronous mode)                   */
                __IOM uint8_t PM   : 1; /*!< [4..4] Parity Mode (Valid only when the PE bit is 1)                      */
                __IOM uint8_t PE   : 1; /*!< [5..5] Parity Enable(Valid only in asynchronous mode)                     */
                __IOM uint8_t CHR  : 1; /*!< [6..6] Character Length(Valid only in asynchronous mode)                  */
                __IOM uint8_t CM   : 1; /*!< [7..7] Communication Mode                                                 */
            } SMR_b;
        };

        union
        {
            __IOM uint8_t SMR_SMCI;    /*!< (@ 0x00000000) Serial mode register (SCMR.SMIF = 1)                       */

            struct
            {
                __IOM uint8_t CKS : 2; /*!< [1..0] Clock Select                                                       */
                __IOM uint8_t BCP : 2; /*!< [3..2] Base Clock Pulse(Valid only in asynchronous mode)                  */
                __IOM uint8_t PM  : 1; /*!< [4..4] Parity Mode (Valid only when the PE bit is 1)                      */
                __IOM uint8_t PE  : 1; /*!< [5..5] Parity Enable(Valid only in asynchronous mode)                     */
                __IOM uint8_t BLK : 1; /*!< [6..6] Block Transfer Mode                                                */
                __IOM uint8_t GM  : 1; /*!< [7..7] GSM Mode                                                           */
            } SMR_SMCI_b;
        };
    };

    union
    {
        __IOM uint8_t BRR;             /*!< (@ 0x00000001) Bit Rate Register                                          */

        struct
        {
            __IOM uint8_t BRR : 8;     /*!< [7..0] BRR is an 8-bit register that adjusts the bit rate.                */
        } BRR_b;
    };

    union
    {
        union
        {
            __IOM uint8_t SCR;          /*!< (@ 0x00000002) Serial Control Register (SCMR.SMIF = 0)                    */

            struct
            {
                __IOM uint8_t CKE  : 2; /*!< [1..0] Clock Enable                                                       */
                __IOM uint8_t TEIE : 1; /*!< [2..2] Transmit End Interrupt Enable                                      */
                __IOM uint8_t MPIE : 1; /*!< [3..3] Multi-Processor Interrupt Enable(Valid in asynchronous
                                         *   mode when SMR.MP = 1)                                                     */
                __IOM uint8_t RE  : 1;  /*!< [4..4] Receive Enable                                                     */
                __IOM uint8_t TE  : 1;  /*!< [5..5] Transmit Enable                                                    */
                __IOM uint8_t RIE : 1;  /*!< [6..6] Receive Interrupt Enable                                           */
                __IOM uint8_t TIE : 1;  /*!< [7..7] Transmit Interrupt Enable                                          */
            } SCR_b;
        };

        union
        {
            __IOM uint8_t SCR_SMCI;     /*!< (@ 0x00000002) Serial Control Register (SCMR.SMIF =1)                     */

            struct
            {
                __IOM uint8_t CKE  : 2; /*!< [1..0] Clock Enable                                                       */
                __IOM uint8_t TEIE : 1; /*!< [2..2] Transmit End Interrupt Enable                                      */
                __IOM uint8_t MPIE : 1; /*!< [3..3] Multi-Processor Interrupt Enable                                   */
                __IOM uint8_t RE   : 1; /*!< [4..4] Receive Enable                                                     */
                __IOM uint8_t TE   : 1; /*!< [5..5] Transmit Enable                                                    */
                __IOM uint8_t RIE  : 1; /*!< [6..6] Receive Interrupt Enable                                           */
                __IOM uint8_t TIE  : 1; /*!< [7..7] Transmit Interrupt Enable                                          */
            } SCR_SMCI_b;
        };
    };

    union
    {
        __IOM uint8_t TDR;             /*!< (@ 0x00000003) Transmit Data Register                                     */

        struct
        {
            __IOM uint8_t TDR : 8;     /*!< [7..0] TDR is an 8-bit register that stores transmit data.                */
        } TDR_b;
    };

    union
    {
        union
        {
            __IOM uint8_t SSR;          /*!< (@ 0x00000004) Serial Status Register(SCMR.SMIF = 0 and FCR.FM=0)         */

            struct
            {
                __IOM uint8_t MPBT : 1; /*!< [0..0] Multi-Processor Bit Transfer                                       */
                __IM uint8_t  MPB  : 1; /*!< [1..1] Multi-Processor                                                    */
                __IM uint8_t  TEND : 1; /*!< [2..2] Transmit End Flag                                                  */
                __IOM uint8_t PER  : 1; /*!< [3..3] Parity Error Flag                                                  */
                __IOM uint8_t FER  : 1; /*!< [4..4] Framing Error Flag                                                 */
                __IOM uint8_t ORER : 1; /*!< [5..5] Overrun Error Flag                                                 */
                __IOM uint8_t RDRF : 1; /*!< [6..6] Receive Data Full Flag                                             */
                __IOM uint8_t TDRE : 1; /*!< [7..7] Transmit Data Empty Flag                                           */
            } SSR_b;
        };

        union
        {
            __IOM uint8_t SSR_FIFO;     /*!< (@ 0x00000004) Serial Status Register(SCMR.SMIF = 0 and FCR.FM=1)         */

            struct
            {
                __IOM uint8_t DR : 1;   /*!< [0..0] Receive Data Ready flag(Valid only in asynchronous mode(including
                                         *   multi-processor) and FIFO selected)                                       */
                uint8_t            : 1;
                __IOM uint8_t TEND : 1; /*!< [2..2] Transmit End Flag                                                  */
                __IOM uint8_t PER  : 1; /*!< [3..3] Parity Error Flag                                                  */
                __IOM uint8_t FER  : 1; /*!< [4..4] Framing Error Flag                                                 */
                __IOM uint8_t ORER : 1; /*!< [5..5] Overrun Error Flag                                                 */
                __IOM uint8_t RDF  : 1; /*!< [6..6] Receive FIFO data full flag                                        */
                __IOM uint8_t TDFE : 1; /*!< [7..7] Transmit FIFO data empty flag                                      */
            } SSR_FIFO_b;
        };

        union
        {
            __IOM uint8_t SSR_SMCI;     /*!< (@ 0x00000004) Serial Status Register(SCMR.SMIF = 1)                      */

            struct
            {
                __IOM uint8_t MPBT : 1; /*!< [0..0] Multi-Processor Bit TransferThis bit should be 0 in smart
                                         *   card interface mode.                                                      */
                __IM uint8_t MPB : 1;   /*!< [1..1] Multi-ProcessorThis bit should be 0 in smart card interface
                                         *   mode.                                                                     */
                __IM uint8_t  TEND : 1; /*!< [2..2] Transmit End Flag                                                  */
                __IOM uint8_t PER  : 1; /*!< [3..3] Parity Error Flag                                                  */
                __IOM uint8_t ERS  : 1; /*!< [4..4] Error Signal Status Flag                                           */
                __IOM uint8_t ORER : 1; /*!< [5..5] Overrun Error Flag                                                 */
                __IOM uint8_t RDRF : 1; /*!< [6..6] Receive Data Full Flag                                             */
                __IOM uint8_t TDRE : 1; /*!< [7..7] Transmit Data Empty Flag                                           */
            } SSR_SMCI_b;
        };
    };

    union
    {
        __IM uint8_t RDR;              /*!< (@ 0x00000005) Receive Data Register                                      */

        struct
        {
            __IM uint8_t RDR : 8;      /*!< [7..0] RDR is an 8-bit register that stores receive data.                 */
        } RDR_b;
    };

    union
    {
        __IOM uint8_t SCMR;            /*!< (@ 0x00000006) Smart Card Mode Register                                   */

        struct
        {
            __IOM uint8_t SMIF : 1;    /*!< [0..0] Smart Card Interface Mode Select                                   */
            uint8_t            : 1;
            __IOM uint8_t SINV : 1;    /*!< [2..2] Transmitted/Received Data InvertSet this bit to 0 if
                                        *   operation is to be in simple I2C mode.                                    */
            __IOM uint8_t SDIR : 1;    /*!< [3..3] Transmitted/Received Data Transfer DirectionNOTE: The
                                        *   setting is invalid and a fixed data length of 8 bits is
                                        *   used in modes other than asynchronous mode.Set this bit
                                        *   to 1 if operation is to be in simple I2C mode.                            */
            __IOM uint8_t CHR1 : 1;    /*!< [4..4] Character Length 1(Only valid in asynchronous mode)                */
            uint8_t            : 2;
            __IOM uint8_t BCP2 : 1;    /*!< [7..7] Base Clock Pulse 2Selects the number of base clock cycles
                                        *   in combination with the SMR.BCP[1:0] bits                                 */
        } SCMR_b;
    };

    union
    {
        __IOM uint8_t SEMR;            /*!< (@ 0x00000007) Serial Extended Mode Register                              */

        struct
        {
            __IOM uint8_t ACS0 : 1;    /*!< [0..0] Asynchronous Mode Clock Source Select (Valid only in
                                        *   asynchronous mode).                                                       */
            __IOM uint8_t PADIS : 1;   /*!< [1..1] Preamble function Disable (Valid only in asynchronous
                                        *   mode).                                                                    */
            __IOM uint8_t BRME  : 1;   /*!< [2..2] Bit Rate Modulation Enable                                         */
            __IOM uint8_t ABCSE : 1;   /*!< [3..3] Asynchronous Mode Extended Base Clock Select 1(Valid
                                        *   only in asynchronous mode and SCR.CKE[1]=0)                               */
            __IOM uint8_t ABCS : 1;    /*!< [4..4] Asynchronous Mode Base Clock Select(Valid only in asynchronous
                                        *   mode)                                                                     */
            __IOM uint8_t NFEN : 1;    /*!< [5..5] Digital Noise Filter Function Enable(The NFEN bit should
                                        *   be 0 without simple I2C mode and asynchronous mode.)In
                                        *   asynchronous mode, for RXDn input only. In simple I2C mode,
                                        *   for RXDn/TxDn input.                                                      */
            __IOM uint8_t BGDM : 1;    /*!< [6..6] Baud Rate Generator Double-Speed Mode Select(Only valid
                                        *   the CKE[1] bit in SCR is 0 in asynchronous mode).                         */
            __IOM uint8_t RXDESEL : 1; /*!< [7..7] Asynchronous Start Bit Edge Detection Select(Valid only
                                        *   in asynchronous mode)                                                     */
        } SEMR_b;
    };

    union
    {
        __IOM uint8_t SNFR;            /*!< (@ 0x00000008) Noise Filter Setting Register                              */

        struct
        {
            __IOM uint8_t NFCS : 3;    /*!< [2..0] Noise Filter Clock Select                                          */
            uint8_t            : 5;
        } SNFR_b;
    };

    union
    {
        __IOM uint8_t SIMR1;           /*!< (@ 0x00000009) I2C Mode Register 1                                        */

        struct
        {
            __IOM uint8_t IICM  : 1;   /*!< [0..0] Simple I2C Mode Select                                             */
            uint8_t             : 2;
            __IOM uint8_t IICDL : 5;   /*!< [7..3] SDA Delay Output SelectCycles below are of the clock
                                        *   signal from the on-chip baud rate generator.                              */
        } SIMR1_b;
    };

    union
    {
        __IOM uint8_t SIMR2;           /*!< (@ 0x0000000A) I2C Mode Register 2                                        */

        struct
        {
            __IOM uint8_t IICINTM : 1; /*!< [0..0] I2C Interrupt Mode Select                                          */
            __IOM uint8_t IICCSC  : 1; /*!< [1..1] Clock Synchronization                                              */
            uint8_t               : 3;
            __IOM uint8_t IICACKT : 1; /*!< [5..5] ACK Transmission Data                                              */
            uint8_t               : 2;
        } SIMR2_b;
    };

    union
    {
        __IOM uint8_t SIMR3;              /*!< (@ 0x0000000B) I2C Mode Register 3                                        */

        struct
        {
            __IOM uint8_t IICSTAREQ  : 1; /*!< [0..0] Start Condition Generation                                         */
            __IOM uint8_t IICRSTAREQ : 1; /*!< [1..1] Restart Condition Generation                                       */
            __IOM uint8_t IICSTPREQ  : 1; /*!< [2..2] Stop Condition Generation                                          */
            __IOM uint8_t IICSTIF    : 1; /*!< [3..3] Issuing of Start, Restart, or Stop Condition Completed
                                           *   Flag(When 0 is written to IICSTIF, it is cleared to 0.)                   */
            __IOM uint8_t IICSDAS : 2;    /*!< [5..4] SDA Output Select                                                  */
            __IOM uint8_t IICSCLS : 2;    /*!< [7..6] SCL Output Select                                                  */
        } SIMR3_b;
    };

    union
    {
        __IM uint8_t SISR;             /*!< (@ 0x0000000C) I2C Status Register                                        */

        struct
        {
            __IM uint8_t IICACKR : 1;  /*!< [0..0] ACK Reception Data Flag                                            */
            uint8_t              : 7;
        } SISR_b;
    };

    union
    {
        __IOM uint8_t SPMR;            /*!< (@ 0x0000000D) SPI Mode Register                                          */

        struct
        {
            __IOM uint8_t SSE    : 1;  /*!< [0..0] SSn Pin Function Enable                                            */
            __IOM uint8_t CTSE   : 1;  /*!< [1..1] CTS Enable                                                         */
            __IOM uint8_t MSS    : 1;  /*!< [2..2] Master Slave Select                                                */
            __IOM uint8_t CSTPEN : 1;  /*!< [3..3] CTS external pin Enable                                            */
            __IOM uint8_t MFF    : 1;  /*!< [4..4] Mode Fault Flag                                                    */
            uint8_t              : 1;
            __IOM uint8_t CKPOL  : 1;  /*!< [6..6] Clock Polarity Select                                              */
            __IOM uint8_t CKPH   : 1;  /*!< [7..7] Clock Phase Select                                                 */
        } SPMR_b;
    };

    union
    {
        union
        {
            __IOM uint16_t TDRHL;         /*!< (@ 0x0000000E) Transmit 9-bit Data Register                               */

            struct
            {
                __OM uint16_t TDRHL : 16; /*!< [15..0] TDRHL is a 16-bit register that stores transmit data.             */
            } TDRHL_b;
        };

        union
        {
            __OM uint16_t FTDRHL;       /*!< (@ 0x0000000E) Transmit FIFO Data Register HL                             */

            struct
            {
                __OM uint16_t TDAT : 9; /*!< [8..0] Serial transmit data (Valid only in asynchronous mode(including
                                         *   multi-processor) or clock synchronous mode, and FIFO selected)            */
                __OM uint16_t MPBT : 1; /*!< [9..9] Multi-processor transfer bit flag(Valid only in asynchronous
                                         *   mode and SMR.MP=1 and FIFO selected)                                      */
                uint16_t : 6;
            } FTDRHL_b;
        };

        struct
        {
            union
            {
                __OM uint8_t FTDRH;         /*!< (@ 0x0000000E) Transmit FIFO Data Register H                              */

                struct
                {
                    __OM uint8_t TDATH : 1; /*!< [0..0] Serial transmit data (b8) (Valid only in asynchronous
                                             *   mode(including multi-processor) or clock synchronous mode,
                                             *   and FIFO selected)                                                        */
                    __OM uint8_t MPBT : 1;  /*!< [1..1] Multi-processor transfer bit flag(Valid only in asynchronous
                                             *   mode and SMR.MP=1 and FIFO selected)                                      */
                    uint8_t : 6;
                } FTDRH_b;
            };

            union
            {
                __OM uint8_t FTDRL;         /*!< (@ 0x0000000F) Transmit FIFO Data Register L                              */

                struct
                {
                    __OM uint8_t TDATL : 8; /*!< [7..0] Serial transmit data(b7-b0) (Valid only in asynchronous
                                             *   mode(including multi-processor) or clock synchronous mode,
                                             *   and FIFO selected)                                                        */
                } FTDRL_b;
            };
        };
    };

    union
    {
        union
        {
            __IM uint16_t RDRHL;          /*!< (@ 0x00000010) Receive 9-bit Data Register                                */

            struct
            {
                __IM uint16_t RDRHL : 16; /*!< [15..0] RDRHL is an 16-bit register that stores receive data.             */
            } RDRHL_b;
        };

        union
        {
            __IM uint16_t FRDRHL;       /*!< (@ 0x00000010) Receive FIFO Data Register HL                              */

            struct
            {
                __IM uint16_t RDAT : 9; /*!< [8..0] Serial receive data(Valid only in asynchronous mode(including
                                         *   multi-processor) or clock synchronous mode, and FIFO selected)            */
                __IM uint16_t MPB : 1;  /*!< [9..9] Multi-processor bit flag(Valid only in asynchronous mode
                                         *   with SMR.MP=1 and FIFO selected) It can read multi-processor
                                         *   bit corresponded to serial receive data(RDATA[8:0])                       */
                __IM uint16_t DR   : 1; /*!< [10..10] Receive data ready flag(It is same as SSR.DR)                    */
                __IM uint16_t PER  : 1; /*!< [11..11] Parity error flag                                                */
                __IM uint16_t FER  : 1; /*!< [12..12] Framing error flag                                               */
                __IM uint16_t ORER : 1; /*!< [13..13] Overrun error flag(It is same as SSR.ORER)                       */
                __IM uint16_t RDF  : 1; /*!< [14..14] Receive FIFO data full flag(It is same as SSR.RDF)               */
                uint16_t           : 1;
            } FRDRHL_b;
        };

        struct
        {
            union
            {
                __IM uint8_t FRDRH;         /*!< (@ 0x00000010) Receive FIFO Data Register H                               */

                struct
                {
                    __IM uint8_t RDATH : 1; /*!< [0..0] Serial receive data(b8)(Valid only in asynchronous mode(including
                                             *   multi-processor) or clock synchronous mode, and FIFO selected)            */
                    __IM uint8_t MPB : 1;   /*!< [1..1] Multi-processor bit flag(Valid only in asynchronous mode
                                             *   with SMR.MP=1 and FIFO selected) It can read multi-processor
                                             *   bit corresponded to serial receive data(RDATA[8:0])                       */
                    __IM uint8_t DR   : 1;  /*!< [2..2] Receive data ready flag(It is same as SSR.DR)                      */
                    __IM uint8_t PER  : 1;  /*!< [3..3] Parity error flag                                                  */
                    __IM uint8_t FER  : 1;  /*!< [4..4] Framing error flag                                                 */
                    __IM uint8_t ORER : 1;  /*!< [5..5] Overrun error flag(It is same as SSR.ORER)                         */
                    __IM uint8_t RDF  : 1;  /*!< [6..6] Receive FIFO data full flag(It is same as SSR.RDF)                 */
                    uint8_t           : 1;
                } FRDRH_b;
            };

            union
            {
                __IM uint8_t FRDRL;         /*!< (@ 0x00000011) Receive FIFO Data Register L                               */

                struct
                {
                    __IM uint8_t RDATL : 8; /*!< [7..0] Serial receive data(Valid only in asynchronous mode(including
                                             *   multi-processor) or clock synchronous mode, and FIFO selected)NOTE:
                                             *   When reading both of FRDRH register and FRDRL register,
                                             *   please read by an order of the FRDRH register and the FRDRL
                                             *   register.                                                                 */
                } FRDRL_b;
            };
        };
    };

    union
    {
        __IOM uint8_t MDDR;            /*!< (@ 0x00000012) Modulation Duty Register                                   */

        struct
        {
            __IOM uint8_t MDDR : 8;    /*!< [7..0] MDDR corrects the bit rate adjusted by the BRR register.           */
        } MDDR_b;
    };

    union
    {
        __IOM uint8_t DCCR;            /*!< (@ 0x00000013) Data Compare Match Control Register                        */

        struct
        {
            __IOM uint8_t DCMF  : 1;   /*!< [0..0] Data Compare Match Flag                                            */
            uint8_t             : 2;
            __IOM uint8_t DPER  : 1;   /*!< [3..3] Data Compare Match Parity Error Flag                               */
            __IOM uint8_t DFER  : 1;   /*!< [4..4] Data Compare Match Framing Error Flag                              */
            uint8_t             : 1;
            __IOM uint8_t IDSEL : 1;   /*!< [6..6] ID frame select(Valid only in asynchronous mode(including
                                        *   multi-processor)                                                          */
            __IOM uint8_t DCME : 1;    /*!< [7..7] Data Compare Match Enable(Valid only in asynchronous
                                        *   mode(including multi-processor)                                           */
        } DCCR_b;
    };

    union
    {
        __IOM uint16_t FCR;            /*!< (@ 0x00000014) FIFO Control Register                                      */

        struct
        {
            __IOM uint16_t FM : 1;     /*!< [0..0] FIFO Mode Select(Valid only in asynchronous mode(including
                                        *   multi-processor) or clock synchronous mode)                               */
            __IOM uint16_t RFRST : 1;  /*!< [1..1] Receive FIFO Data Register Reset(Valid only in FCR.FM=1)           */
            __IOM uint16_t TFRST : 1;  /*!< [2..2] Transmit FIFO Data Register Reset(Valid only in FCR.FM=1)          */
            __IOM uint16_t DRES  : 1;  /*!< [3..3] Receive data ready error select bit(When detecting a
                                        *   reception data ready, the interrupt request is selected.)                 */
            __IOM uint16_t TTRG : 4;   /*!< [7..4] Transmit FIFO data trigger number(Valid only in asynchronous
                                        *   mode(including multi-processor) or clock synchronous mode)                */
            __IOM uint16_t RTRG : 4;   /*!< [11..8] Receive FIFO data trigger number(Valid only in asynchronous
                                        *   mode(including multi-processor) or clock synchronous mode)                */
            __IOM uint16_t RSTRG : 4;  /*!< [15..12] RTS Output Active Trigger Number Select(Valid only
                                        *   in asynchronous mode(including multi-processor) or clock
                                        *   synchronous mode)                                                         */
        } FCR_b;
    };

    union
    {
        __IM uint16_t FDR;             /*!< (@ 0x00000016) FIFO Data Count Register                                   */

        struct
        {
            __IM uint16_t R : 5;       /*!< [4..0] Receive FIFO Data CountIndicate the quantity of receive
                                        *   data stored in FRDRH and FRDRL(Valid only in asynchronous
                                        *   mode(including multi-processor) or clock synchronous mode,
                                        *   while FCR.FM=1)                                                           */
            uint16_t        : 3;
            __IM uint16_t T : 5;       /*!< [12..8] Transmit FIFO Data CountIndicate the quantity of non-transmit
                                        *   data stored in FTDRH and FTDRL(Valid only in asynchronous
                                        *   mode(including multi-processor) or clock synchronous mode,
                                        *   while FCR.FM=1)                                                           */
            uint16_t : 3;
        } FDR_b;
    };

    union
    {
        __IM uint16_t LSR;             /*!< (@ 0x00000018) Line Status Register                                       */

        struct
        {
            __IM uint16_t ORER : 1;    /*!< [0..0] Overrun Error Flag (Valid only in asynchronous mode(including
                                        *   multi-processor) or clock synchronous mode, and FIFO selected)            */
            uint16_t           : 1;
            __IM uint16_t FNUM : 5;    /*!< [6..2] Framing Error CountIndicates the quantity of data with
                                        *   a framing error among the receive data stored in the receive
                                        *   FIFO data register (FRDRH and FRDRL).                                     */
            uint16_t           : 1;
            __IM uint16_t PNUM : 5;    /*!< [12..8] Parity Error CountIndicates the quantity of data with
                                        *   a parity error among the receive data stored in the receive
                                        *   FIFO data register (FRDRH and FRDRL).                                     */
            uint16_t : 3;
        } LSR_b;
    };

    union
    {
        __IOM uint16_t CDR;            /*!< (@ 0x0000001A) Compare Match Data Register                                */

        struct
        {
            __IOM uint16_t CMPD : 9;   /*!< [8..0] Compare Match DataCompare data pattern for address match
                                        *   wake-up function                                                          */
            uint16_t : 7;
        } CDR_b;
    };

    union
    {
        __IOM uint8_t SPTR;            /*!< (@ 0x0000001C) Serial Port Register                                       */

        struct
        {
            __IM uint8_t RXDMON : 1;   /*!< [0..0] Serial input data monitor bit(The state of the RXD terminal
                                        *   is shown.)                                                                */
            __IOM uint8_t SPB2DT : 1;  /*!< [1..1] Serial port break data select bit(The output level of
                                        *   TxD terminal is selected when SCR.TE = 0.)                                */
            __IOM uint8_t SPB2IO : 1;  /*!< [2..2] Serial port break I/O bit(It's selected whether the value
                                        *   of SPB2DT is output to TxD terminal.)                                     */
            uint8_t            : 1;
            __IOM uint8_t RINV : 1;    /*!< [4..4] RXD invert bit                                                     */
            __IOM uint8_t TINV : 1;    /*!< [5..5] TXD invert bit                                                     */
            __IOM uint8_t ASEN : 1;    /*!< [6..6] Adjust receive sampling timing enable                              */
            __IOM uint8_t ATEN : 1;    /*!< [7..7] Adjust transmit timing enable                                      */
        } SPTR_b;
    };

    union
    {
        __IOM uint8_t ACTR;            /*!< (@ 0x0000001D) Adjustment Communication Timing Register                   */

        struct
        {
            __IOM uint8_t AST : 3;     /*!< [2..0] Adjustment value for receive Sampling Timing                       */
            __IOM uint8_t AJD : 1;     /*!< [3..3] Adjustment Direction for receive sampling timing                   */
            __IOM uint8_t ATT : 3;     /*!< [6..4] Adjustment value for Transmit timing                               */
            __IOM uint8_t AET : 1;     /*!< [7..7] Adjustment edge for transmit timing                                */
        } ACTR_b;
    };
    __IM uint16_t RESERVED;

    union
    {
        __IOM uint8_t ESMER;           /*!< (@ 0x00000020) Extended Serial Module Enable Register                     */

        struct
        {
            __IOM uint8_t ESME : 1;    /*!< [0..0] Extended Serial Mode Enable                                        */
            uint8_t            : 7;
        } ESMER_b;
    };

    union
    {
        __IOM uint8_t CR0;             /*!< (@ 0x00000021) Control Register 0                                         */

        struct
        {
            uint8_t             : 1;
            __IM uint8_t  SFSF  : 1;   /*!< [1..1] Start Frame Status Flag                                            */
            __IM uint8_t  RXDSF : 1;   /*!< [2..2] RXDXn Input Status Flag                                            */
            __IOM uint8_t BRME  : 1;   /*!< [3..3] Bit Rate Measurement Enable                                        */
            uint8_t             : 4;
        } CR0_b;
    };

    union
    {
        __IOM uint8_t CR1;             /*!< (@ 0x00000022) Control Register 1                                         */

        struct
        {
            __IOM uint8_t BFE   : 1;   /*!< [0..0] Break Field Enable                                                 */
            __IOM uint8_t CF0RE : 1;   /*!< [1..1] Control Field 0 Reception Enable                                   */
            __IOM uint8_t CF1DS : 2;   /*!< [3..2] Control Field 1 Data Register Select                               */
            __IOM uint8_t PIBE  : 1;   /*!< [4..4] Priority Interrupt Bit Enable                                      */
            __IOM uint8_t PIBS  : 3;   /*!< [7..5] Priority Interrupt Bit Select                                      */
        } CR1_b;
    };

    union
    {
        __IOM uint8_t CR2;             /*!< (@ 0x00000023) Control Register 2                                         */

        struct
        {
            __IOM uint8_t DFCS : 3;    /*!< [2..0] RXDXn Signal Digital Filter Clock Select                           */
            uint8_t            : 1;
            __IOM uint8_t BCCS : 2;    /*!< [5..4] Bus Collision Detection Clock Select                               */
            __IOM uint8_t RTS  : 2;    /*!< [7..6] RXDXn Reception Sampling Timing Select                             */
        } CR2_b;
    };

    union
    {
        __IOM uint8_t CR3;             /*!< (@ 0x00000024) Control Register 3                                         */

        struct
        {
            __IOM uint8_t SDST : 1;    /*!< [0..0] Start Frame Detection Start                                        */
            uint8_t            : 7;
        } CR3_b;
    };

    union
    {
        __IOM uint8_t PCR;             /*!< (@ 0x00000025) Port Control Register                                      */

        struct
        {
            __IOM uint8_t TXDXPS : 1;  /*!< [0..0] TXDXn Signal Polarity Select                                       */
            __IOM uint8_t RXDXPS : 1;  /*!< [1..1] RXDXn Signal Polarity Select                                       */
            uint8_t              : 2;
            __IOM uint8_t SHARPS : 1;  /*!< [4..4] TXDXn/RXDXn Pin Multiplexing Select                                */
            uint8_t              : 3;
        } PCR_b;
    };

    union
    {
        __IOM uint8_t ICR;             /*!< (@ 0x00000026) Interrupt Control Register                                 */

        struct
        {
            __IOM uint8_t BFDIE  : 1;  /*!< [0..0] Break Field Low Width Detected Interrupt Enable                    */
            __IOM uint8_t CF0MIE : 1;  /*!< [1..1] Control Field 0 Match Detected Interrupt Enable                    */
            __IOM uint8_t CF1MIE : 1;  /*!< [2..2] Control Field 1 Match Detected Interrupt Enable                    */
            __IOM uint8_t PIBDIE : 1;  /*!< [3..3] Priority Interrupt Bit Detected Interrupt Enable                   */
            __IOM uint8_t BCDIE  : 1;  /*!< [4..4] Bus Collision Detected Interrupt Enable                            */
            __IOM uint8_t AEDIE  : 1;  /*!< [5..5] Valid Edge Detected Interrupt Enable                               */
            uint8_t              : 2;
        } ICR_b;
    };

    union
    {
        __IM uint8_t STR;              /*!< (@ 0x00000027) Status Register                                            */

        struct
        {
            __IM uint8_t BFDF  : 1;    /*!< [0..0] Break Field Low Width Detection Flag                               */
            __IM uint8_t CF0MF : 1;    /*!< [1..1] Control Field 0 Match Flag                                         */
            __IM uint8_t CF1MF : 1;    /*!< [2..2] Control Field 1 Match Flag                                         */
            __IM uint8_t PIBDF : 1;    /*!< [3..3] Priority Interrupt Bit Detection Flag                              */
            __IM uint8_t BCDF  : 1;    /*!< [4..4] Bus Collision Detected Flag                                        */
            __IM uint8_t AEDF  : 1;    /*!< [5..5] Valid Edge Detection Flag                                          */
            uint8_t            : 2;
        } STR_b;
    };

    union
    {
        __IOM uint8_t STCR;            /*!< (@ 0x00000028) Status Clear Register                                      */

        struct
        {
            __IOM uint8_t BFDCL  : 1;  /*!< [0..0] BFDF Clear                                                         */
            __IOM uint8_t CF0MCL : 1;  /*!< [1..1] CF0MF Clear                                                        */
            __IOM uint8_t CF1MCL : 1;  /*!< [2..2] CF1MF Clear                                                        */
            __IOM uint8_t PIBDCL : 1;  /*!< [3..3] PIBDF Clear                                                        */
            __IOM uint8_t BCDCL  : 1;  /*!< [4..4] BCDF Clear                                                         */
            __IOM uint8_t AEDCL  : 1;  /*!< [5..5] AEDF Clear                                                         */
            uint8_t              : 2;
        } STCR_b;
    };
    __IOM uint8_t CF0DR;               /*!< (@ 0x00000029) Control Field 0 Data Register                              */

    union
    {
        __IOM uint8_t CF0CR;           /*!< (@ 0x0000002A) Control Field 0 Compare Enable Register                    */

        struct
        {
            __IOM uint8_t CF0CE0 : 1;  /*!< [0..0] Control Field 0 Bit 0 Compare Enable                               */
            __IOM uint8_t CF0CE1 : 1;  /*!< [1..1] Control Field 1 Bit 0 Compare Enable                               */
            __IOM uint8_t CF0CE2 : 1;  /*!< [2..2] Control Field 2 Bit 0 Compare Enable                               */
            __IOM uint8_t CF0CE3 : 1;  /*!< [3..3] Control Field 3 Bit 0 Compare Enable                               */
            __IOM uint8_t CF0CE4 : 1;  /*!< [4..4] Control Field 4 Bit 0 Compare Enable                               */
            __IOM uint8_t CF0CE5 : 1;  /*!< [5..5] Control Field 5 Bit 0 Compare Enable                               */
            __IOM uint8_t CF0CE6 : 1;  /*!< [6..6] Control Field 6 Bit 0 Compare Enable                               */
            __IOM uint8_t CF0CE7 : 1;  /*!< [7..7] Control Field 7 Bit 0 Compare Enable                               */
        } CF0CR_b;
    };
    __IOM uint8_t CF0RR;               /*!< (@ 0x0000002B) Control Field 0 Receive Data Register                      */
    __IOM uint8_t PCF1DR;              /*!< (@ 0x0000002C) Primary Control Field 1 Data Register                      */
    __IOM uint8_t SCF1DR;              /*!< (@ 0x0000002D) Secondary Control Field 1 Data Register                    */

    union
    {
        __IOM uint8_t CF1CR;           /*!< (@ 0x0000002E) Control Field 1 Compare Enable Register                    */

        struct
        {
            __IOM uint8_t CF1CE0 : 1;  /*!< [0..0] Control Field 1 Bit 0 Compare Enable                               */
            __IOM uint8_t CF1CE1 : 1;  /*!< [1..1] Control Field 1 Bit 1 Compare Enable                               */
            __IOM uint8_t CF1CE2 : 1;  /*!< [2..2] Control Field 1 Bit 2 Compare Enable                               */
            __IOM uint8_t CF1CE3 : 1;  /*!< [3..3] Control Field 1 Bit 3 Compare Enable                               */
            __IOM uint8_t CF1CE4 : 1;  /*!< [4..4] Control Field 1 Bit 4 Compare Enable                               */
            __IOM uint8_t CF1CE5 : 1;  /*!< [5..5] Control Field 1 Bit 5 Compare Enable                               */
            __IOM uint8_t CF1CE6 : 1;  /*!< [6..6] Control Field 1 Bit 6 Compare Enable                               */
            __IOM uint8_t CF1CE7 : 1;  /*!< [7..7] Control Field 1 Bit 7 Compare Enable                               */
        } CF1CR_b;
    };
    __IOM uint8_t CF1RR;               /*!< (@ 0x0000002F) Control Field 1 Receive Data Register                      */

    union
    {
        __IOM uint8_t TCR;             /*!< (@ 0x00000030) Timer Control Register                                     */

        struct
        {
            __IOM uint8_t TCST : 1;    /*!< [0..0] Timer Count Start                                                  */
            uint8_t            : 7;
        } TCR_b;
    };

    union
    {
        __IOM uint8_t TMR;             /*!< (@ 0x00000031) Timer Mode Register                                        */

        struct
        {
            __IOM uint8_t TOMS : 2;    /*!< [1..0] Timer Operating Mode Select                                        */
            uint8_t            : 1;
            __IOM uint8_t TWRC : 1;    /*!< [3..3] Counter Write Control                                              */
            __IOM uint8_t TCSS : 3;    /*!< [6..4] Timer Count Clock Source Select                                    */
            uint8_t            : 1;
        } TMR_b;
    };
    __IOM uint8_t TPRE;                /*!< (@ 0x00000032) Timer Prescaler Register                                   */
    __IOM uint8_t TCNT;                /*!< (@ 0x00000033) Timer Count Register                                       */
} R_SCI0_Type;                         /*!< Size = 52 (0x34)                                                          */

/* =========================================================================================================================== */
/* ================                                          R_SPI0                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Serial Peripheral Interface (R_SPI0)
 */

typedef struct                         /*!< (@ 0x4011A000) R_SPI0 Structure                                           */
{
    union
    {
        __IOM uint8_t SPCR;            /*!< (@ 0x00000000) SPI Control Register                                       */

        struct
        {
            __IOM uint8_t SPMS   : 1;  /*!< [0..0] SPI Mode Select                                                    */
            __IOM uint8_t TXMD   : 1;  /*!< [1..1] Communications Operating Mode Select                               */
            __IOM uint8_t MODFEN : 1;  /*!< [2..2] Mode Fault Error Detection Enable                                  */
            __IOM uint8_t MSTR   : 1;  /*!< [3..3] SPI Master/Slave Mode Select                                       */
            __IOM uint8_t SPEIE  : 1;  /*!< [4..4] SPI Error Interrupt Enable                                         */
            __IOM uint8_t SPTIE  : 1;  /*!< [5..5] Transmit Buffer Empty Interrupt Enable                             */
            __IOM uint8_t SPE    : 1;  /*!< [6..6] SPI Function Enable                                                */
            __IOM uint8_t SPRIE  : 1;  /*!< [7..7] SPI Receive Buffer Full Interrupt Enable                           */
        } SPCR_b;
    };

    union
    {
        __IOM uint8_t SSLP;            /*!< (@ 0x00000001) SPI Slave Select Polarity Register                         */

        struct
        {
            __IOM uint8_t SSL0P : 1;   /*!< [0..0] SSL0 Signal Polarity Setting                                       */
            __IOM uint8_t SSL1P : 1;   /*!< [1..1] SSL1 Signal Polarity Setting                                       */
            __IOM uint8_t SSL2P : 1;   /*!< [2..2] SSL2 Signal Polarity Setting                                       */
            __IOM uint8_t SSL3P : 1;   /*!< [3..3] SSL3 Signal Polarity Setting                                       */
            __IOM uint8_t SSL4P : 1;   /*!< [4..4] SSL4 Signal Polarity Setting                                       */
            __IOM uint8_t SSL5P : 1;   /*!< [5..5] SSL5 Signal Polarity Setting                                       */
            __IOM uint8_t SSL6P : 1;   /*!< [6..6] SSL6 Signal Polarity Setting                                       */
            __IOM uint8_t SSL7P : 1;   /*!< [7..7] SSL7 Signal Polarity Setting                                       */
        } SSLP_b;
    };

    union
    {
        __IOM uint8_t SPPCR;           /*!< (@ 0x00000002) SPI Pin Control Register                                   */

        struct
        {
            __IOM uint8_t SPLP  : 1;   /*!< [0..0] SPI Loopback                                                       */
            __IOM uint8_t SPLP2 : 1;   /*!< [1..1] SPI Loopback 2                                                     */
            uint8_t             : 2;
            __IOM uint8_t MOIFV : 1;   /*!< [4..4] MOSI Idle Fixed Value                                              */
            __IOM uint8_t MOIFE : 1;   /*!< [5..5] MOSI Idle Value Fixing Enable                                      */
            uint8_t             : 2;
        } SPPCR_b;
    };

    union
    {
        __IOM uint8_t SPSR;            /*!< (@ 0x00000003) SPI Status Register                                        */

        struct
        {
            __IOM uint8_t OVRF  : 1;   /*!< [0..0] Overrun Error Flag                                                 */
            __IM uint8_t  IDLNF : 1;   /*!< [1..1] SPI Idle Flag                                                      */
            __IOM uint8_t MODF  : 1;   /*!< [2..2] Mode Fault Error Flag                                              */
            __IOM uint8_t PERF  : 1;   /*!< [3..3] Parity Error Flag                                                  */
            __IOM uint8_t UDRF  : 1;   /*!< [4..4] Underrun Error Flag(When MODF is 0, This bit is invalid.)          */
            __IOM uint8_t SPTEF : 1;   /*!< [5..5] SPI Transmit Buffer Empty Flag                                     */
            __IOM uint8_t CENDF : 1;   /*!< [6..6] Communication End Flag                                             */
            __IOM uint8_t SPRF  : 1;   /*!< [7..7] SPI Receive Buffer Full Flag                                       */
        } SPSR_b;
    };

    union
    {
        __IOM uint32_t SPDR;           /*!< (@ 0x00000004) SPI Data Register                                          */
        __IOM uint16_t SPDR_HA;        /*!< (@ 0x00000004) SPI Data Register ( halfword access )                      */
        __IOM uint8_t  SPDR_BY;        /*!< (@ 0x00000004) SPI Data Register ( byte access )                          */
    };

    union
    {
        __IOM uint8_t SPSCR;           /*!< (@ 0x00000008) SPI Sequence Control Register                              */

        struct
        {
            __IOM uint8_t SPSLN : 3;   /*!< [2..0] RSPI Sequence Length SpecificationThe order in which
                                        *   the SPCMD0 to SPCMD07 registers are to be referenced is
                                        *   changed in accordance with the sequence length that is
                                        *   set in these bits. The relationship among the setting of
                                        *   these bits, sequence length, and SPCMD0 to SPCMD7 registers
                                        *   referenced by the RSPI is shown above. However, the RSPI
                                        *   in slave mode always references SPCMD0.                                   */
            uint8_t : 5;
        } SPSCR_b;
    };

    union
    {
        __IM uint8_t SPSSR;            /*!< (@ 0x00000009) SPI Sequence Status Register                               */

        struct
        {
            __IM uint8_t SPCP  : 3;    /*!< [2..0] RSPI Command Pointer                                               */
            uint8_t            : 1;
            __IM uint8_t SPECM : 3;    /*!< [6..4] RSPI Error Command                                                 */
            uint8_t            : 1;
        } SPSSR_b;
    };

    union
    {
        __IOM uint8_t SPBR;            /*!< (@ 0x0000000A) SPI Bit Rate Register                                      */

        struct
        {
            __IOM uint8_t SPR : 8;     /*!< [7..0] SPBR sets the bit rate in master mode.                             */
        } SPBR_b;
    };

    union
    {
        __IOM uint8_t SPDCR;           /*!< (@ 0x0000000B) SPI Data Control Register                                  */

        struct
        {
            __IOM uint8_t SPFC   : 2;  /*!< [1..0] Number of Frames Specification                                     */
            __IOM uint8_t SLSEL  : 2;  /*!< [3..2] SSL Pin Output Select                                              */
            __IOM uint8_t SPRDTD : 1;  /*!< [4..4] SPI Receive/Transmit Data Selection                                */
            __IOM uint8_t SPLW   : 1;  /*!< [5..5] SPI Word Access/Halfword Access Specification                      */
            __IOM uint8_t SPBYT  : 1;  /*!< [6..6] SPI Byte Access Specification                                      */
            uint8_t              : 1;
        } SPDCR_b;
    };

    union
    {
        __IOM uint8_t SPCKD;           /*!< (@ 0x0000000C) SPI Clock Delay Register                                   */

        struct
        {
            __IOM uint8_t SCKDL : 3;   /*!< [2..0] RSPCK Delay Setting                                                */
            uint8_t             : 5;
        } SPCKD_b;
    };

    union
    {
        __IOM uint8_t SSLND;           /*!< (@ 0x0000000D) SPI Slave Select Negation Delay Register                   */

        struct
        {
            __IOM uint8_t SLNDL : 3;   /*!< [2..0] SSL Negation Delay Setting                                         */
            uint8_t             : 5;
        } SSLND_b;
    };

    union
    {
        __IOM uint8_t SPND;            /*!< (@ 0x0000000E) SPI Next-Access Delay Register                             */

        struct
        {
            __IOM uint8_t SPNDL : 3;   /*!< [2..0] SPI Next-Access Delay Setting                                      */
            uint8_t             : 5;
        } SPND_b;
    };

    union
    {
        __IOM uint8_t SPCR2;           /*!< (@ 0x0000000F) SPI Control Register 2                                     */

        struct
        {
            __IOM uint8_t SPPE   : 1;  /*!< [0..0] Parity Enable                                                      */
            __IOM uint8_t SPOE   : 1;  /*!< [1..1] Parity Mode                                                        */
            __IOM uint8_t SPIIE  : 1;  /*!< [2..2] SPI Idle Interrupt Enable                                          */
            __IOM uint8_t PTE    : 1;  /*!< [3..3] Parity Self-Testing                                                */
            __IOM uint8_t SCKASE : 1;  /*!< [4..4] RSPCK Auto-Stop Function Enable                                    */
            __IOM uint8_t SPTDDL : 3;  /*!< [7..5] RSPI Transmit Data Delay                                           */
        } SPCR2_b;
    };

    union
    {
        __IOM uint16_t SPCMD[8];       /*!< (@ 0x00000010) SPI Command Register [0..7]                                */

        struct
        {
            __IOM uint16_t CPHA   : 1; /*!< [0..0] RSPCK Phase Setting                                                */
            __IOM uint16_t CPOL   : 1; /*!< [1..1] RSPCK Polarity Setting                                             */
            __IOM uint16_t BRDV   : 2; /*!< [3..2] Bit Rate Division Setting                                          */
            __IOM uint16_t SSLA   : 3; /*!< [6..4] SSL Signal Assertion Setting                                       */
            __IOM uint16_t SSLKP  : 1; /*!< [7..7] SSL Signal Level Keeping                                           */
            __IOM uint16_t SPB    : 4; /*!< [11..8] SPI Data Length Setting                                           */
            __IOM uint16_t LSBF   : 1; /*!< [12..12] SPI LSB First                                                    */
            __IOM uint16_t SPNDEN : 1; /*!< [13..13] SPI Next-Access Delay Enable                                     */
            __IOM uint16_t SLNDEN : 1; /*!< [14..14] SSL Negation Delay Setting Enable                                */
            __IOM uint16_t SCKDEN : 1; /*!< [15..15] RSPCK Delay Setting Enable                                       */
        } SPCMD_b[8];
    };

    union
    {
        __IOM uint8_t SPDCR2;          /*!< (@ 0x00000020) SPI Data Control Register 2                                */

        struct
        {
            __IOM uint8_t BYSW : 1;    /*!< [0..0] Byte Swap Operating Mode Select                                    */
            __IOM uint8_t SINV : 1;    /*!< [1..1] Serial data invert bit                                             */
            uint8_t            : 6;
        } SPDCR2_b;
    };

    union
    {
        __IOM uint8_t SPCR3;           /*!< (@ 0x00000021) RSPI Control Register 3                                    */

        struct
        {
            __IOM uint8_t ETXMD  : 1;  /*!< [0..0] Extended Communication Mode Select                                 */
            __IOM uint8_t BFDS   : 1;  /*!< [1..1] Between Burst Transfer Frames Delay Select                         */
            uint8_t              : 2;
            __IOM uint8_t CENDIE : 1;  /*!< [4..4] RSPI Communication End Interrupt Enable                            */
            uint8_t              : 3;
        } SPCR3_b;
    };
    __IM uint16_t RESERVED;
    __IM uint32_t RESERVED1[6];
    __IM uint16_t RESERVED2;

    union
    {
        __IOM uint16_t SPPR;           /*!< (@ 0x0000003E) RSPI Parameter Read Register                               */

        struct
        {
            uint16_t              : 4;
            __IOM uint16_t BUFWID : 1; /*!< [4..4] Buffer Width check                                                 */
            uint16_t              : 3;
            __IOM uint16_t BUFNUM : 3; /*!< [10..8] Buffer Number check                                               */
            uint16_t              : 1;
            __IOM uint16_t CMDNUM : 4; /*!< [15..12] Command Number check                                             */
        } SPPR_b;
    };
} R_SPI0_Type;                         /*!< Size = 64 (0x40)                                                          */

/* =========================================================================================================================== */
/* ================                                          R_SRAM                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief SRAM (R_SRAM)
 */

typedef struct                         /*!< (@ 0x40002000) R_SRAM Structure                                           */
{
    union
    {
        __IOM uint8_t PARIOAD;         /*!< (@ 0x00000000) SRAM Parity Error Operation After Detection Register       */

        struct
        {
            __IOM uint8_t OAD : 1;     /*!< [0..0] Operation after Detection                                          */
            uint8_t           : 7;
        } PARIOAD_b;
    };
    __IM uint8_t RESERVED[3];

    union
    {
        __IOM uint8_t SRAMPRCR;         /*!< (@ 0x00000004) SRAM Protection Register                                   */

        struct
        {
            __IOM uint8_t SRAMPRCR : 1; /*!< [0..0] Register Write Control                                             */
            __OM uint8_t  KW       : 7; /*!< [7..1] Write Key Code                                                     */
        } SRAMPRCR_b;
    };
    __IM uint8_t  RESERVED1[3];
    __IOM uint8_t SRAMWTSC;             /*!< (@ 0x00000008) RAM Wait State Control Register                            */
    __IM uint8_t  RESERVED2[3];

    union
    {
        __IOM uint8_t SRAMPRCR2;         /*!< (@ 0x0000000C) SRAM Protection Register 2                                 */

        struct
        {
            __IOM uint8_t SRAMPRCR2 : 1; /*!< [0..0] Register Write Control                                             */
            __OM uint8_t  KW        : 7; /*!< [7..1] Write Key Code                                                     */
        } SRAMPRCR2_b;
    };
    __IM uint8_t RESERVED3[179];

    union
    {
        __IOM uint8_t ECCMODE;         /*!< (@ 0x000000C0) ECC Operating Mode Control Register                        */

        struct
        {
            __IOM uint8_t ECCMOD : 2;  /*!< [1..0] ECC Operating Mode Select                                          */
            uint8_t              : 6;
        } ECCMODE_b;
    };

    union
    {
        __IOM uint8_t ECC2STS;         /*!< (@ 0x000000C1) ECC 2-Bit Error Status Register                            */

        struct
        {
            __IOM uint8_t ECC2ERR : 1; /*!< [0..0] ECC 2-Bit Error Status                                             */
            uint8_t               : 7;
        } ECC2STS_b;
    };

    union
    {
        __IOM uint8_t ECC1STSEN;       /*!< (@ 0x000000C2) ECC 1-Bit Error Information Update Enable Register         */

        struct
        {
            __IOM uint8_t E1STSEN : 1; /*!< [0..0] ECC 1-Bit Error Information Update Enable                          */
            uint8_t               : 7;
        } ECC1STSEN_b;
    };

    union
    {
        __IOM uint8_t ECC1STS;         /*!< (@ 0x000000C3) ECC 1-Bit Error Status Register                            */

        struct
        {
            __IOM uint8_t ECC1ERR : 1; /*!< [0..0] ECC 1-Bit Error Status                                             */
            uint8_t               : 7;
        } ECC1STS_b;
    };

    union
    {
        __IOM uint8_t ECCPRCR;         /*!< (@ 0x000000C4) ECC Protection Register                                    */

        struct
        {
            __IOM uint8_t ECCPRCR : 1; /*!< [0..0] Register Write Control                                             */
            __OM uint8_t  KW      : 7; /*!< [7..1] Write Key Code                                                     */
        } ECCPRCR_b;
    };
    __IM uint8_t RESERVED4[11];

    union
    {
        __IOM uint8_t ECCPRCR2;         /*!< (@ 0x000000D0) ECC Protection Register 2                                  */

        struct
        {
            __IOM uint8_t ECCPRCR2 : 1; /*!< [0..0] Register Write Control                                             */
            __OM uint8_t  KW2      : 7; /*!< [7..1] Write Key Code                                                     */
        } ECCPRCR2_b;
    };
    __IM uint8_t RESERVED5[3];

    union
    {
        __IOM uint8_t ECCETST;         /*!< (@ 0x000000D4) ECC Test Control Register                                  */

        struct
        {
            __IOM uint8_t TSTBYP : 1;  /*!< [0..0] ECC Bypass Select                                                  */
            uint8_t              : 7;
        } ECCETST_b;
    };
    __IM uint8_t RESERVED6[3];

    union
    {
        __IOM uint8_t ECCOAD;          /*!< (@ 0x000000D8) SRAM ECC Error Operation After Detection Register          */

        struct
        {
            __IOM uint8_t OAD : 1;     /*!< [0..0] Operation after Detection                                          */
            uint8_t           : 7;
        } ECCOAD_b;
    };
} R_SRAM_Type;                         /*!< Size = 217 (0xd9)                                                         */

/* =========================================================================================================================== */
/* ================                                          R_BUS_B                                          ================ */
/* =========================================================================================================================== */

/**
 * @brief Bus Interface (R_BUS_B)
 */

typedef struct                          /*!< (@ 0x40003000) R_BUS_B Structure                                          */
{
    __IOM R_BUS_B_CSa_Type CSa[8];      /*!< (@ 0x00000000) CS Registers                                               */
    __IM uint32_t          RESERVED[480];
    __IOM R_BUS_B_CSb_Type CSb[8];      /*!< (@ 0x00000800) CS Registers                                               */

    union
    {
        __IOM uint16_t CSRECEN;         /*!< (@ 0x00000880) CS Recovery Cycle Insertion Enable Register                */

        struct
        {
            __IOM uint16_t RCVEN0  : 1; /*!< [0..0] Separate Bus Recovery Cycle Insertion Enable                       */
            __IOM uint16_t RCVEN1  : 1; /*!< [1..1] Separate Bus Recovery Cycle Insertion Enable                       */
            __IOM uint16_t RCVEN2  : 1; /*!< [2..2] Separate Bus Recovery Cycle Insertion Enable                       */
            __IOM uint16_t RCVEN3  : 1; /*!< [3..3] Separate Bus Recovery Cycle Insertion Enable                       */
            __IOM uint16_t RCVEN4  : 1; /*!< [4..4] Separate Bus Recovery Cycle Insertion Enable                       */
            __IOM uint16_t RCVEN5  : 1; /*!< [5..5] Separate Bus Recovery Cycle Insertion Enable                       */
            __IOM uint16_t RCVEN6  : 1; /*!< [6..6] Separate Bus Recovery Cycle Insertion Enable                       */
            __IOM uint16_t RCVEN7  : 1; /*!< [7..7] Separate Bus Recovery Cycle Insertion Enable                       */
            __IOM uint16_t RCVENM0 : 1; /*!< [8..8] Multiplexed Bus Recovery Cycle Insertion Enable                    */
            __IOM uint16_t RCVENM1 : 1; /*!< [9..9] Multiplexed Bus Recovery Cycle Insertion Enable                    */
            __IOM uint16_t RCVENM2 : 1; /*!< [10..10] Multiplexed Bus Recovery Cycle Insertion Enable                  */
            __IOM uint16_t RCVENM3 : 1; /*!< [11..11] Multiplexed Bus Recovery Cycle Insertion Enable                  */
            __IOM uint16_t RCVENM4 : 1; /*!< [12..12] Multiplexed Bus Recovery Cycle Insertion Enable                  */
            __IOM uint16_t RCVENM5 : 1; /*!< [13..13] Multiplexed Bus Recovery Cycle Insertion Enable                  */
            __IOM uint16_t RCVENM6 : 1; /*!< [14..14] Multiplexed Bus Recovery Cycle Insertion Enable                  */
            __IOM uint16_t RCVENM7 : 1; /*!< [15..15] Multiplexed Bus Recovery Cycle Insertion Enable                  */
        } CSRECEN_b;
    };
    __IM uint16_t RESERVED1;
    __IM uint32_t RESERVED2[543];

    union
    {
        __IOM uint16_t BUSSCNTFHBIU;   /*!< (@ 0x00001100) Slave Bus Control Register                                 */

        struct
        {
            __IOM uint16_t ARBS : 2;   /*!< [1..0] Arbitration Select for three masters                               */
            uint16_t            : 14;
        } BUSSCNTFHBIU_b;
    };
    __IM uint16_t RESERVED3;

    union
    {
        __IOM uint16_t BUSSCNTFLBIU;   /*!< (@ 0x00001104) Slave Bus Control Register                                 */

        struct
        {
            __IOM uint16_t ARBS : 2;   /*!< [1..0] Arbitration Select for three masters                               */
            uint16_t            : 14;
        } BUSSCNTFLBIU_b;
    };
    __IM uint16_t RESERVED4;
    __IM uint32_t RESERVED5[2];

    union
    {
        __IOM uint16_t BUSSCNTS0BIU;   /*!< (@ 0x00001110) Slave Bus Control Register                                 */

        struct
        {
            __IOM uint16_t ARBS : 2;   /*!< [1..0] Arbitration Select for three masters                               */
            uint16_t            : 14;
        } BUSSCNTS0BIU_b;
    };
    __IM uint16_t RESERVED6;
    __IM uint32_t RESERVED7[3];

    union
    {
        __IOM uint16_t BUSSCNTPSBIU;   /*!< (@ 0x00001120) Slave Bus Control Register                                 */

        struct
        {
            __IOM uint16_t ARBS : 1;   /*!< [0..0] Arbitration Select for two masters                                 */
            uint16_t            : 15;
        } BUSSCNTPSBIU_b;
    };
    __IM uint16_t RESERVED8;
    __IM uint32_t RESERVED9[3];

    union
    {
        __IOM uint16_t BUSSCNTPLBIU;   /*!< (@ 0x00001130) Slave Bus Control Register                                 */

        struct
        {
            __IOM uint16_t ARBS : 1;   /*!< [0..0] Arbitration Select for two masters                                 */
            uint16_t            : 15;
        } BUSSCNTPLBIU_b;
    };
    __IM uint16_t RESERVED10;

    union
    {
        __IOM uint16_t BUSSCNTPHBIU;   /*!< (@ 0x00001134) Slave Bus Control Register                                 */

        struct
        {
            __IOM uint16_t ARBS : 1;   /*!< [0..0] Arbitration Select for two masters                                 */
            uint16_t            : 15;
        } BUSSCNTPHBIU_b;
    };
    __IM uint16_t RESERVED11;
    __IM uint32_t RESERVED12[2];

    union
    {
        __IOM uint16_t BUSSCNTEQBIU;   /*!< (@ 0x00001140) Slave Bus Control Register                                 */

        struct
        {
            __IOM uint16_t ARBS : 2;   /*!< [1..0] Arbitration Select for three masters                               */
            uint16_t            : 14;
        } BUSSCNTEQBIU_b;
    };
    __IM uint16_t RESERVED13;

    union
    {
        __IOM uint16_t BUSSCNTEOBIU;   /*!< (@ 0x00001144) Slave Bus Control Register                                 */

        struct
        {
            __IOM uint16_t ARBS : 2;   /*!< [1..0] Arbitration Select for three masters                               */
            uint16_t            : 14;
        } BUSSCNTEOBIU_b;
    };
    __IM uint16_t RESERVED14;

    union
    {
        __IOM uint16_t BUSSCNTECBIU;   /*!< (@ 0x00001148) Slave Bus Control Register                                 */

        struct
        {
            __IOM uint16_t ARBS : 2;   /*!< [1..0] Arbitration Select for three masters                               */
            uint16_t            : 14;
        } BUSSCNTECBIU_b;
    };
    __IM uint16_t                RESERVED15;
    __IM uint32_t                RESERVED16[429];
    __IOM R_BUS_B_BUSERR_Type    BUSERR[4];    /*!< (@ 0x00001800) Bus Error Registers                                        */
    __IM uint32_t                RESERVED17[48];
    __IOM R_BUS_B_BUSTZFERR_Type BUSTZFERR[4]; /*!< (@ 0x00001900) Bus TZF Error Registers                                    */
    __IM uint32_t                RESERVED18[48];

    union
    {
        __IM uint8_t BUS1ERRSTAT;       /*!< (@ 0x00001A00) BUS Error Status Register 1                                */

        struct
        {
            __IM uint8_t SLERRSTAT : 1; /*!< [0..0] Slave bus Error Status                                             */
            __IM uint8_t STERRSTAT : 1; /*!< [1..1] Slave TrustZone filter Error Status                                */
            uint8_t                : 1;
            __IM uint8_t MMERRSTAT : 1; /*!< [3..3] Master MPU Error Status                                            */
            __IM uint8_t ILERRSTAT : 1; /*!< [4..4] Illegal address access Error Status                                */
            uint8_t                : 3;
        } BUS1ERRSTAT_b;
    };
    __IM uint8_t  RESERVED19;
    __IM uint16_t RESERVED20;
    __IM uint32_t RESERVED21;

    union
    {
        __IOM uint8_t BUS1ERRCLR;       /*!< (@ 0x00001A08) BUS Error Clear Register 1                                 */

        struct
        {
            __IOM uint8_t SLERRCLR : 1; /*!< [0..0] Slave bus Error Clear                                              */
            __IOM uint8_t STERRCLR : 1; /*!< [1..1] Slave TrustZone filter Error Clear                                 */
            uint8_t                : 1;
            __IOM uint8_t MMERRCLR : 1; /*!< [3..3] Master MPU Error Clear                                             */
            __IOM uint8_t ILERRCLR : 1; /*!< [4..4] Illegal Address Access Error Clear                                 */
            uint8_t                : 3;
        } BUS1ERRCLR_b;
    };
    __IM uint8_t  RESERVED22;
    __IM uint16_t RESERVED23;
    __IM uint32_t RESERVED24;

    union
    {
        __IM uint8_t BUS2ERRSTAT;       /*!< (@ 0x00001A10) BUS Error Status Register 2                                */

        struct
        {
            __IM uint8_t SLERRSTAT : 1; /*!< [0..0] Slave bus Error Status                                             */
            __IM uint8_t STERRSTAT : 1; /*!< [1..1] Slave TrustZone filter Error Status                                */
            uint8_t                : 1;
            __IM uint8_t MMERRSTAT : 1; /*!< [3..3] Master MPU Error Status                                            */
            __IM uint8_t ILERRSTAT : 1; /*!< [4..4] Illegal address access Error Status                                */
            uint8_t                : 3;
        } BUS2ERRSTAT_b;
    };
    __IM uint8_t  RESERVED25;
    __IM uint16_t RESERVED26;
    __IM uint32_t RESERVED27;

    union
    {
        __IOM uint8_t BUS2ERRCLR;       /*!< (@ 0x00001A18) BUS Error Clear Register 2                                 */

        struct
        {
            __IOM uint8_t SLERRCLR : 1; /*!< [0..0] Slave bus Error Clear                                              */
            __IOM uint8_t STERRCLR : 1; /*!< [1..1] Slave TrustZone filter Error Clear                                 */
            uint8_t                : 1;
            __IOM uint8_t MMERRCLR : 1; /*!< [3..3] Master MPU Error Clear                                             */
            __IOM uint8_t ILERRCLR : 1; /*!< [4..4] Illegal Address Access Error Clear                                 */
            uint8_t                : 3;
        } BUS2ERRCLR_b;
    };
    __IM uint8_t  RESERVED28;
    __IM uint16_t RESERVED29;
    __IM uint32_t RESERVED30;

    union
    {
        __IM uint8_t BUS3ERRSTAT;       /*!< (@ 0x00001A20) BUS Error Status Register 3                                */

        struct
        {
            __IM uint8_t SLERRSTAT : 1; /*!< [0..0] Slave bus Error Status                                             */
            __IM uint8_t STERRSTAT : 1; /*!< [1..1] Slave TrustZone filter Error Status                                */
            uint8_t                : 1;
            __IM uint8_t MMERRSTAT : 1; /*!< [3..3] Master MPU Error Status                                            */
            __IM uint8_t ILERRSTAT : 1; /*!< [4..4] Illegal address access Error Status                                */
            uint8_t                : 3;
        } BUS3ERRSTAT_b;
    };
    __IM uint8_t  RESERVED31;
    __IM uint16_t RESERVED32;

    union
    {
        __IM uint8_t DMACDTCERRSTAT;    /*!< (@ 0x00001A24) DMAC/DTC Error Status Register                             */

        struct
        {
            __IM uint8_t MTERRSTAT : 1; /*!< [0..0] Master TrustZone Filter Error Status                               */
            uint8_t                : 7;
        } DMACDTCERRSTAT_b;
    };
    __IM uint8_t  RESERVED33;
    __IM uint16_t RESERVED34;

    union
    {
        __IOM uint8_t BUS3ERRCLR;       /*!< (@ 0x00001A28) BUS Error Clear Register 3                                 */

        struct
        {
            __IOM uint8_t SLERRCLR : 1; /*!< [0..0] Slave bus Error Clear                                              */
            __IOM uint8_t STERRCLR : 1; /*!< [1..1] Slave TrustZone filter Error Clear                                 */
            uint8_t                : 1;
            __IOM uint8_t MMERRCLR : 1; /*!< [3..3] Master MPU Error Clear                                             */
            __IOM uint8_t ILERRCLR : 1; /*!< [4..4] Illegal Address Access Error Clear                                 */
            uint8_t                : 3;
        } BUS3ERRCLR_b;
    };
    __IM uint8_t  RESERVED35;
    __IM uint16_t RESERVED36;

    union
    {
        __IOM uint8_t DMACDTCERRCLR;    /*!< (@ 0x00001A2C) DMAC/DTC Error Clear Register                              */

        struct
        {
            __IOM uint8_t MTERRCLR : 1; /*!< [0..0] Master TrustZone filter Error Clear                                */
            uint8_t                : 7;
        } DMACDTCERRCLR_b;
    };
    __IM uint8_t  RESERVED37;
    __IM uint16_t RESERVED38;

    union
    {
        __IM uint8_t BUS4ERRSTAT;       /*!< (@ 0x00001A30) BUS Error Status Register 4                                */

        struct
        {
            __IM uint8_t SLERRSTAT : 1; /*!< [0..0] Slave bus Error Status                                             */
            __IM uint8_t STERRSTAT : 1; /*!< [1..1] Slave TrustZone filter Error Status                                */
            uint8_t                : 1;
            __IM uint8_t MMERRSTAT : 1; /*!< [3..3] Master MPU Error Status                                            */
            __IM uint8_t ILERRSTAT : 1; /*!< [4..4] Illegal address access Error Status                                */
            uint8_t                : 3;
        } BUS4ERRSTAT_b;
    };
    __IM uint8_t  RESERVED39;
    __IM uint16_t RESERVED40;
    __IM uint32_t RESERVED41;

    union
    {
        __IOM uint8_t BUS4ERRCLR;       /*!< (@ 0x00001A38) BUS Error Clear Register 4                                 */

        struct
        {
            __IOM uint8_t SLERRCLR : 1; /*!< [0..0] Slave bus Error Clear                                              */
            __IOM uint8_t STERRCLR : 1; /*!< [1..1] Slave TrustZone filter Error Clear                                 */
            uint8_t                : 1;
            __IOM uint8_t MMERRCLR : 1; /*!< [3..3] Master MPU Error Clear                                             */
            __IOM uint8_t ILERRCLR : 1; /*!< [4..4] Illegal Address Access Error Clear                                 */
            uint8_t                : 3;
        } BUS4ERRCLR_b;
    };
    __IM uint8_t  RESERVED42;
    __IM uint16_t RESERVED43;
} R_BUS_B_Type;                        /*!< Size = 6716 (0x1a3c)                                                      */

/* =========================================================================================================================== */
/* ================                                         R_SYSTEM                                          ================ */
/* =========================================================================================================================== */

/**
 * @brief System Pins (R_SYSTEM)
 */

typedef struct                         /*!< (@ 0x4001E000) R_SYSTEM Structure                                         */
{
    __IM uint32_t RESERVED[3];

    union
    {
        __IOM uint16_t SBYCR;          /*!< (@ 0x0000000C) Standby Control Register                                   */

        struct
        {
            uint16_t            : 14;
            __IOM uint16_t OPE  : 1;   /*!< [14..14] Output Port Enable                                               */
            __IOM uint16_t SSBY : 1;   /*!< [15..15] Software Standby                                                 */
        } SBYCR_b;
    };
    __IM uint16_t RESERVED1;
    __IM uint32_t RESERVED2[3];

    union
    {
        __IOM uint32_t MSTPCRA;         /*!< (@ 0x0000001C) Module Stop Control Register A                             */

        struct
        {
            __IOM uint32_t MSTPA0  : 1; /*!< [0..0] Module Stop bit 0. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA1  : 1; /*!< [1..1] Module Stop bit 1. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA2  : 1; /*!< [2..2] Module Stop bit 2. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA3  : 1; /*!< [3..3] Module Stop bit 3. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA4  : 1; /*!< [4..4] Module Stop bit 4. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA5  : 1; /*!< [5..5] Module Stop bit 5. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA6  : 1; /*!< [6..6] Module Stop bit 6. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA7  : 1; /*!< [7..7] Module Stop bit 7. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA8  : 1; /*!< [8..8] Module Stop bit 8. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA9  : 1; /*!< [9..9] Module Stop bit 9. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA10 : 1; /*!< [10..10] Module Stop bit 10. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA11 : 1; /*!< [11..11] Module Stop bit 11. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA12 : 1; /*!< [12..12] Module Stop bit 12. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA13 : 1; /*!< [13..13] Module Stop bit 13. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA14 : 1; /*!< [14..14] Module Stop bit 14. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA15 : 1; /*!< [15..15] Module Stop bit 15. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA16 : 1; /*!< [16..16] Module Stop bit 16. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA17 : 1; /*!< [17..17] Module Stop bit 17. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA18 : 1; /*!< [18..18] Module Stop bit 18. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA19 : 1; /*!< [19..19] Module Stop bit 19. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA20 : 1; /*!< [20..20] Module Stop bit 20. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA21 : 1; /*!< [21..21] Module Stop bit 21. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA22 : 1; /*!< [22..22] Module Stop bit 22. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA23 : 1; /*!< [23..23] Module Stop bit 23. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA24 : 1; /*!< [24..24] Module Stop bit 24. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA25 : 1; /*!< [25..25] Module Stop bit 25. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA26 : 1; /*!< [26..26] Module Stop bit 26. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA27 : 1; /*!< [27..27] Module Stop bit 27. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA28 : 1; /*!< [28..28] Module Stop bit 28. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA29 : 1; /*!< [29..29] Module Stop bit 29. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA30 : 1; /*!< [30..30] Module Stop bit 30. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA31 : 1; /*!< [31..31] Module Stop bit 31. See device hardware manual for
                                         *   usage.                                                                    */
        } MSTPCRA_b;
    };

    union
    {
        __IOM uint32_t SCKDIVCR;       /*!< (@ 0x00000020) System Clock Division Control Register                     */

        struct
        {
            __IOM uint32_t PCKD : 3;   /*!< [2..0] Peripheral Module Clock D (PCLKD) Select                           */
            uint32_t            : 1;
            __IOM uint32_t PCKC : 3;   /*!< [6..4] Peripheral Module Clock C (PCLKC) Select                           */
            uint32_t            : 1;
            __IOM uint32_t PCKB : 3;   /*!< [10..8] Peripheral Module Clock B (PCLKB) Select                          */
            uint32_t            : 1;
            __IOM uint32_t PCKA : 3;   /*!< [14..12] Peripheral Module Clock A (PCLKA) Select                         */
            uint32_t            : 1;
            __IOM uint32_t BCK  : 3;   /*!< [18..16] External Bus Clock (BCLK) Select                                 */
            uint32_t            : 5;
            __IOM uint32_t ICK  : 3;   /*!< [26..24] System Clock (ICLK) Select                                       */
            uint32_t            : 1;
            __IOM uint32_t FCK  : 3;   /*!< [30..28] Flash IF Clock (FCLK) Select                                     */
            uint32_t            : 1;
        } SCKDIVCR_b;
    };

    union
    {
        __IOM uint8_t SCKDIVCR2;       /*!< (@ 0x00000024) System Clock Division Control Register 2                   */

        struct
        {
            uint8_t           : 4;
            __IOM uint8_t UCK : 3;     /*!< [6..4] USB Clock (UCLK) Select                                            */
            uint8_t           : 1;
        } SCKDIVCR2_b;
    };
    __IM uint8_t RESERVED3;

    union
    {
        __IOM uint8_t SCKSCR;          /*!< (@ 0x00000026) System Clock Source Control Register                       */

        struct
        {
            __IOM uint8_t CKSEL : 3;   /*!< [2..0] Clock Source Select                                                */
            uint8_t             : 5;
        } SCKSCR_b;
    };
    __IM uint8_t RESERVED4;

    union
    {
        __IOM uint16_t PLLCCR;           /*!< (@ 0x00000028) PLL Clock Control Register                                 */

        struct
        {
            __IOM uint16_t PLIDIV   : 2; /*!< [1..0] PLL Input Frequency Division Ratio Select                          */
            uint16_t                : 2;
            __IOM uint16_t PLSRCSEL : 1; /*!< [4..4] PLL Clock Source Select                                            */
            uint16_t                : 3;
            __IOM uint16_t PLLMUL   : 6; /*!< [13..8] PLL Frequency Multiplication Factor Select [PLL Frequency
                                          *   Multiplication Factor] = (PLLUMUL+1) / 2 Range: 0x23 -
                                          *   0x3B for example 010011: x10.0 010100: x10.5 010101: x11.0
                                          *   : 011100: x14.5 011101: x15.0 011110: x15.5 : 111010: x29.5
                                          *   111011: x30.0                                                             */
            uint16_t : 2;
        } PLLCCR_b;
    };

    union
    {
        __IOM uint8_t PLLCR;           /*!< (@ 0x0000002A) PLL Control Register                                       */

        struct
        {
            __IOM uint8_t PLLSTP : 1;  /*!< [0..0] PLL Stop Control                                                   */
            uint8_t              : 7;
        } PLLCR_b;
    };

    union
    {
        __IOM uint8_t PLLCCR2;         /*!< (@ 0x0000002B) PLL Clock Control Register2                                */

        struct
        {
            __IOM uint8_t PLLMUL : 5;  /*!< [4..0] PLL Frequency Multiplication Factor Select                         */
            uint8_t              : 1;
            __IOM uint8_t PLODIV : 2;  /*!< [7..6] PLL Output Frequency Division Ratio Select                         */
        } PLLCCR2_b;
    };
    __IM uint32_t RESERVED5;

    union
    {
        __IOM uint8_t BCKCR;           /*!< (@ 0x00000030) External Bus Clock Control Register                        */

        struct
        {
            __IOM uint8_t BCLKDIV : 1; /*!< [0..0] BCLK Pin Output Select                                             */
            uint8_t               : 7;
        } BCKCR_b;
    };

    union
    {
        __IOM uint8_t MEMWAIT;         /*!< (@ 0x00000031) Memory Wait Cycle Control Register                         */

        struct
        {
            __IOM uint8_t MEMWAIT : 1; /*!< [0..0] Memory Wait Cycle SelectNote: Writing 0 to the MEMWAIT
                                        *   is prohibited when SCKDIVCR.ICK selects division by 1 and
                                        *   SCKSCR.CKSEL[2:0] bits select thesystem clock source that
                                        *   is faster than 32 MHz (ICLK > 32 MHz).                                    */
            uint8_t : 7;
        } MEMWAIT_b;
    };

    union
    {
        __IOM uint8_t MOSCCR;          /*!< (@ 0x00000032) Main Clock Oscillator Control Register                     */

        struct
        {
            __IOM uint8_t MOSTP : 1;   /*!< [0..0] Main Clock Oscillator Stop                                         */
            uint8_t             : 7;
        } MOSCCR_b;
    };
    __IM uint8_t  RESERVED6;
    __IM uint16_t RESERVED7;

    union
    {
        __IOM uint8_t HOCOCR;          /*!< (@ 0x00000036) High-Speed On-Chip Oscillator Control Register             */

        struct
        {
            __IOM uint8_t HCSTP : 1;   /*!< [0..0] HOCO Stop                                                          */
            uint8_t             : 7;
        } HOCOCR_b;
    };
    __IM uint8_t RESERVED8;

    union
    {
        __IOM uint8_t MOCOCR;          /*!< (@ 0x00000038) Middle-Speed On-Chip Oscillator Control Register           */

        struct
        {
            __IOM uint8_t MCSTP : 1;   /*!< [0..0] MOCO Stop                                                          */
            uint8_t             : 7;
        } MOCOCR_b;
    };

    union
    {
        __IOM uint8_t FLLCR1;          /*!< (@ 0x00000039) FLL Control Register 1                                     */

        struct
        {
            __IOM uint8_t FLLEN : 1;   /*!< [0..0] FLL Enable                                                         */
            uint8_t             : 7;
        } FLLCR1_b;
    };

    union
    {
        __IOM uint16_t FLLCR2;           /*!< (@ 0x0000003A) FLL Control Register 2                                     */

        struct
        {
            __IOM uint16_t FLLCNTL : 11; /*!< [10..0] FLL Multiplication ControlMultiplication ratio of the
                                          *   FLL reference clock select                                                */
            uint16_t : 5;
        } FLLCR2_b;
    };

    union
    {
        __IM uint8_t OSCSF;            /*!< (@ 0x0000003C) Oscillation Stabilization Flag Register                    */

        struct
        {
            __IM uint8_t HOCOSF : 1;   /*!< [0..0] HOCO Clock Oscillation Stabilization FlagNOTE: The HOCOSF
                                        *   bit value after a reset is 1 when the OFS1.HOCOEN bit is
                                        *   0. It is 0 when the OFS1.HOCOEN bit is 1.                                 */
            uint8_t             : 2;
            __IM uint8_t MOSCSF : 1;   /*!< [3..3] Main Clock Oscillation Stabilization Flag                          */
            uint8_t             : 1;
            __IM uint8_t PLLSF  : 1;   /*!< [5..5] PLL Clock Oscillation Stabilization Flag                           */
            __IM uint8_t PLL2SF : 1;   /*!< [6..6] PLL2 Clock Oscillation Stabilization Flag                          */
            uint8_t             : 1;
        } OSCSF_b;
    };
    __IM uint8_t RESERVED9;

    union
    {
        __IOM uint8_t CKOCR;           /*!< (@ 0x0000003E) Clock Out Control Register                                 */

        struct
        {
            __IOM uint8_t CKOSEL : 3;  /*!< [2..0] Clock out source select                                            */
            uint8_t              : 1;
            __IOM uint8_t CKODIV : 3;  /*!< [6..4] Clock out input frequency Division Select                          */
            __IOM uint8_t CKOEN  : 1;  /*!< [7..7] Clock out enable                                                   */
        } CKOCR_b;
    };

    union
    {
        __IOM uint8_t TRCKCR;          /*!< (@ 0x0000003F) Trace Clock Control Register                               */

        struct
        {
            __IOM uint8_t TRCK   : 4;  /*!< [3..0] Trace Clock operating frequency select                             */
            uint8_t              : 3;
            __IOM uint8_t TRCKEN : 1;  /*!< [7..7] Trace Clock operating Enable                                       */
        } TRCKCR_b;
    };

    union
    {
        __IOM uint8_t OSTDCR;          /*!< (@ 0x00000040) Oscillation Stop Detection Control Register                */

        struct
        {
            __IOM uint8_t OSTDIE : 1;  /*!< [0..0] Oscillation Stop Detection Interrupt Enable                        */
            uint8_t              : 6;
            __IOM uint8_t OSTDE  : 1;  /*!< [7..7] Oscillation Stop Detection Function Enable                         */
        } OSTDCR_b;
    };

    union
    {
        __IOM uint8_t OSTDSR;          /*!< (@ 0x00000041) Oscillation Stop Detection Status Register                 */

        struct
        {
            __IOM uint8_t OSTDF : 1;   /*!< [0..0] Oscillation Stop Detection Flag                                    */
            uint8_t             : 7;
        } OSTDSR_b;
    };
    __IM uint16_t RESERVED10;
    __IM uint32_t RESERVED11;

    union
    {
        __IOM uint16_t PLL2CCR;           /*!< (@ 0x00000048) PLL2 Clock Control Register                                */

        struct
        {
            __IOM uint16_t PL2IDIV   : 2; /*!< [1..0] PLL2 Input Frequency Division Ratio Select                         */
            uint16_t                 : 2;
            __IOM uint16_t PL2SRCSEL : 1; /*!< [4..4] PLL2 Clock Source Select                                           */
            uint16_t                 : 3;
            __IOM uint16_t PLL2MUL   : 6; /*!< [13..8] PLL2 Frequency Multiplication Factor Select                       */
            uint16_t                 : 2;
        } PLL2CCR_b;
    };

    union
    {
        __IOM uint8_t PLL2CR;          /*!< (@ 0x0000004A) PLL2 Control Register                                      */

        struct
        {
            __IOM uint8_t PLL2STP : 1; /*!< [0..0] PLL2 Stop Control                                                  */
            uint8_t               : 7;
        } PLL2CR_b;
    };
    __IM uint8_t RESERVED12;

    union
    {
        __IOM uint8_t LPOPT;             /*!< (@ 0x0000004C) Lower Power Operation Control Register                     */

        struct
        {
            __IOM uint8_t MPUDIS : 1;    /*!< [0..0] MPU Clock Disable Control. Stop the MPU operate clock
                                          *   (valid only when LPOPTEN = 1)                                             */
            __IOM uint8_t DCLKDIS   : 2; /*!< [2..1] Debug Clock Disable Control                                        */
            __IOM uint8_t BPFCLKDIS : 1; /*!< [3..3] BPF Clock Disable Control. Stop the Flash register R/W
                                          *   clock (valid only when LPOPT.LPOPTEN = 1)                                 */
            uint8_t               : 3;
            __IOM uint8_t LPOPTEN : 1;   /*!< [7..7] Lower Power Operation Enable                                       */
        } LPOPT_b;
    };
    __IM uint8_t  RESERVED13;
    __IM uint16_t RESERVED14;

    union
    {
        __IOM uint8_t SLCDSCKCR;         /*!< (@ 0x00000050) Segment LCD Source Clock Control Register                  */

        struct
        {
            __IOM uint8_t LCDSCKSEL : 3; /*!< [2..0] LCD Source Clock (LCDSRCCLK) Select                                */
            uint8_t                 : 4;
            __IOM uint8_t LCDSCKEN  : 1; /*!< [7..7] LCD Source Clock Out Enable                                        */
        } SLCDSCKCR_b;
    };
    __IM uint8_t RESERVED15;

    union
    {
        __IOM uint8_t EBCKOCR;         /*!< (@ 0x00000052) External Bus Clock Output Control Register                 */

        struct
        {
            __IOM uint8_t EBCKOEN : 1; /*!< [0..0] BCLK Pin Output Control                                            */
            uint8_t               : 7;
        } EBCKOCR_b;
    };

    union
    {
        __IOM uint8_t SDCKOCR;         /*!< (@ 0x00000053) SDRAM Clock Output Control Register                        */

        struct
        {
            __IOM uint8_t SDCKOEN : 1; /*!< [0..0] SDCLK Pin Output Control                                           */
            uint8_t               : 7;
        } SDCKOCR_b;
    };
    __IM uint32_t RESERVED16[3];
    __IM uint8_t  RESERVED17;

    union
    {
        __IOM uint8_t MOCOUTCR;         /*!< (@ 0x00000061) MOCO User Trimming Control Register                        */

        struct
        {
            __IOM uint8_t MOCOUTRM : 8; /*!< [7..0] MOCO User Trimming 1000_0000 : -128 1000_0001 : -127
                                         *   1000_0010 : -126 . . . 1111_1111 : -1 0000_0000 : Center
                                         *   Code 0000_0001 : +1 . . . 0111_1101 : +125 0111_1110 :
                                         +126 0111_1111 : +127These bits are added to original MOCO
                                         *   trimming bits                                                             */
        } MOCOUTCR_b;
    };

    union
    {
        __IOM uint8_t HOCOUTCR;         /*!< (@ 0x00000062) HOCO User Trimming Control Register                        */

        struct
        {
            __IOM uint8_t HOCOUTRM : 8; /*!< [7..0] HOCO User Trimming 1000_0000 : -128 1000_0001 : -127
                                         *   1000_0010 : -126 . . . 1111_1111 : -1 0000_0000 : Center
                                         *   Code 0000_0001 : +1 . . . 0111_1101 : +125 0111_1110 :
                                         +126 0111_1111 : +127These bits are added to original HOCO
                                         *   trimming bits                                                             */
        } HOCOUTCR_b;
    };
    __IM uint8_t  RESERVED18;
    __IM uint32_t RESERVED19[2];

    union
    {
        __IOM uint8_t USBCKDIVCR;       /*!< (@ 0x0000006C) USB Clock Division Control Register                        */

        struct
        {
            __IOM uint8_t USBCKDIV : 3; /*!< [2..0] USB Clock (USBCLK) Division Select                                 */
            uint8_t                : 5;
        } USBCKDIVCR_b;
    };

    union
    {
        union
        {
            __IOM uint8_t OCTACKDIVCR;       /*!< (@ 0x0000006D) Octal-SPI Clock Division Control Register                  */

            struct
            {
                __IOM uint8_t OCTACKDIV : 3; /*!< [2..0] Octal-SPI Clock (OCTACLK) Division Select                          */
                uint8_t                 : 5;
            } OCTACKDIVCR_b;
        };

        union
        {
            __IOM uint8_t SCISPICKDIVCR;       /*!< (@ 0x0000006D) SCI SPI Clock Division Control Register                    */

            struct
            {
                __IOM uint8_t SCISPICKDIV : 3; /*!< [2..0] SCI SPI Clock (SCISPICLK) Division Select                          */
                uint8_t                   : 5;
            } SCISPICKDIVCR_b;
        };
    };

    union
    {
        __IOM uint8_t CANFDCKDIVCR;       /*!< (@ 0x0000006E) CANFD Clock Division Control Register                      */

        struct
        {
            __IOM uint8_t CANFDCKDIV : 3; /*!< [2..0] CANFD Clock (CANFDCLK) Division Select                             */
            uint8_t                  : 5;
        } CANFDCKDIVCR_b;
    };

    union
    {
        union
        {
            __IOM uint8_t GPTCKDIVCR;       /*!< (@ 0x0000006F) GPT Clock Division Control Register                        */

            struct
            {
                __IOM uint8_t GPTCKDIV : 3; /*!< [2..0] GPT Clock (GPTCLK) Division Select                                 */
                uint8_t                : 5;
            } GPTCKDIVCR_b;
        };

        union
        {
            __IOM uint8_t USB60CKDIVCR;       /*!< (@ 0x0000006F) USB60 Clock Division Control Register                      */

            struct
            {
                __IOM uint8_t USB60CKDIV : 3; /*!< [2..0] USB clock (USB60CLK) Division Select                               */
                uint8_t                  : 5;
            } USB60CKDIVCR_b;
        };
    };

    union
    {
        union
        {
            __IOM uint8_t CECCKDIVCR;       /*!< (@ 0x00000070) CEC Clock Division Control Register                        */

            struct
            {
                __IOM uint8_t CECCKDIV : 3; /*!< [2..0] CEC clock (CECCLK) Division Select                                 */
                uint8_t                : 5;
            } CECCKDIVCR_b;
        };

        union
        {
            __IOM uint8_t IICCKDIVCR;       /*!< (@ 0x00000070) IIC Clock Division Control Register                        */

            struct
            {
                __IOM uint8_t IICCKDIV : 3; /*!< [2..0] IIC Clock (IICCLK) Division Select                                 */
                uint8_t                : 5;
            } IICCKDIVCR_b;
        };
    };

    union
    {
        __IOM uint8_t I3CCKDIVCR;       /*!< (@ 0x00000071) I3C clock Division control register                        */

        struct
        {
            __IOM uint8_t I3CCKDIV : 3; /*!< [2..0] I3C clock (I3CCLK) Division Select                                 */
            uint8_t                : 5;
        } I3CCKDIVCR_b;
    };
    __IM uint16_t RESERVED20;

    union
    {
        __IOM uint8_t USBCKCR;           /*!< (@ 0x00000074) USB Clock Control Register                                 */

        struct
        {
            __IOM uint8_t USBCKSEL  : 3; /*!< [2..0] USB Clock (USBCLK) Source Select                                   */
            uint8_t                 : 3;
            __IOM uint8_t USBCKSREQ : 1; /*!< [6..6] USB Clock (USBCLK) Switching Request                               */
            __IM uint8_t  USBCKSRDY : 1; /*!< [7..7] USB Clock (USBCLK) Switching Ready state flag                      */
        } USBCKCR_b;
    };

    union
    {
        union
        {
            __IOM uint8_t OCTACKCR;           /*!< (@ 0x00000075) Octal-SPI Clock Control Register                           */

            struct
            {
                __IOM uint8_t OCTACKSEL  : 3; /*!< [2..0] Octal-SPI Clock (OCTACLK) Source Select                            */
                uint8_t                  : 3;
                __IOM uint8_t OCTACKSREQ : 1; /*!< [6..6] Octal-SPI Clock (OCTACLK) Switching Request                        */
                __IM uint8_t  OCTACKSRDY : 1; /*!< [7..7] Octal-SPI Clock (OCTACLK) Switching Ready state flag               */
            } OCTACKCR_b;
        };

        union
        {
            __IOM uint8_t SCISPICKCR;           /*!< (@ 0x00000075) SCI SPI Clock Control Register                             */

            struct
            {
                __IOM uint8_t SCISPICKSEL  : 3; /*!< [2..0] SCI SPI Clock (SCISPICLK) Source Select                            */
                uint8_t                    : 3;
                __IOM uint8_t SCISPICKSREQ : 1; /*!< [6..6] SCI SPI Clock (SCISPICLK) Switching Request                        */
                __IM uint8_t  SCISPICKSRDY : 1; /*!< [7..7] SCI SPI Clock (SCISPICLK) Switching Ready state flag               */
            } SCISPICKCR_b;
        };
    };

    union
    {
        __IOM uint8_t CANFDCKCR;           /*!< (@ 0x00000076) CANFD Clock Control Register                               */

        struct
        {
            __IOM uint8_t CANFDCKSEL  : 3; /*!< [2..0] CANFD Clock (CANFDCLK) Source Select                               */
            uint8_t                   : 3;
            __IOM uint8_t CANFDCKSREQ : 1; /*!< [6..6] CANFD Clock (CANFDCLK) Switching Request                           */
            __IM uint8_t  CANFDCKSRDY : 1; /*!< [7..7] CANFD Clock (CANFDCLK) Switching Ready state flag                  */
        } CANFDCKCR_b;
    };

    union
    {
        union
        {
            __IOM uint8_t GPTCKCR;           /*!< (@ 0x00000077) GPT Clock Control Register                                 */

            struct
            {
                __IOM uint8_t GPTCKSEL  : 3; /*!< [2..0] GPT Clock (GPTCLK) Source Select                                   */
                uint8_t                 : 3;
                __IOM uint8_t GPTCKSREQ : 1; /*!< [6..6] GPT Clock (GPTCLK) Switching Request                               */
                __IM uint8_t  GPTCKSRDY : 1; /*!< [7..7] GPT Clock (GPTCLK) Switching Ready state flag                      */
            } GPTCKCR_b;
        };

        union
        {
            __IOM uint8_t USB60CKCR;           /*!< (@ 0x00000077) USB60 clock control register                               */

            struct
            {
                __IOM uint8_t USB60CKSEL  : 4; /*!< [3..0] USB clock (USB60CLK) Source Select                                 */
                uint8_t                   : 2;
                __IOM uint8_t USB60CKSREQ : 1; /*!< [6..6] USB clock (USB60CLK) Switching Request                             */
                __IOM uint8_t USB60CKSRDY : 1; /*!< [7..7] USB clock (USB60CLK) Switching Ready state flag                    */
            } USB60CKCR_b;
        };
    };

    union
    {
        union
        {
            __IOM uint8_t CECCKCR;           /*!< (@ 0x00000078) CEC Clock Control Register                                 */

            struct
            {
                __IOM uint8_t CECCKSEL  : 3; /*!< [2..0] CEC clock (CECCLK) Source Select                                   */
                uint8_t                 : 3;
                __IOM uint8_t CECCKSREQ : 1; /*!< [6..6] CEC clock (CECCLK) Switching Request                               */
                __IM uint8_t  CECCKSRDY : 1; /*!< [7..7] CEC clock (CECCLK) Switching Ready state flag                      */
            } CECCKCR_b;
        };

        union
        {
            __IOM uint8_t IICCKCR;           /*!< (@ 0x00000078) IIC Clock Control Register                                 */

            struct
            {
                __IOM uint8_t IICCKSEL  : 3; /*!< [2..0] IIC Clock (IICCLK) Source Select                                   */
                uint8_t                 : 3;
                __IOM uint8_t IICCKSREQ : 1; /*!< [6..6] IIC Clock (IICCLK) Switching Request                               */
                __IM uint8_t  IICCKSRDY : 1; /*!< [7..7] IIC Clock (IICCLK) Switching Ready state flag                      */
            } IICCKCR_b;
        };
    };

    union
    {
        __IOM uint8_t I3CCKCR;           /*!< (@ 0x00000079) I3C Clock Control Register                                 */

        struct
        {
            __IOM uint8_t I3CCKSEL  : 3; /*!< [2..0] I3C clock (I3CCLK) source select                                   */
            uint8_t                 : 3;
            __IOM uint8_t I3CCKSREQ : 1; /*!< [6..6] I3C clock (I3CCLK) switching request                               */
            __IM uint8_t  I3CCKSRDY : 1; /*!< [7..7] I3C clock (I3CCLK) switching ready state flag                      */
        } I3CCKCR_b;
    };
    __IM uint16_t RESERVED21;
    __IM uint32_t RESERVED22[3];

    union
    {
        __IOM uint32_t SNZREQCR1;         /*!< (@ 0x00000088) Snooze Request Control Register 1                          */

        struct
        {
            __IOM uint32_t SNZREQEN0 : 1; /*!< [0..0] Enable AGT3 underflow snooze request                               */
            __IOM uint32_t SNZREQEN1 : 1; /*!< [1..1] Enable AGT3 underflow snooze request                               */
            __IOM uint32_t SNZREQEN2 : 1; /*!< [2..2] Enable AGT3 underflow snooze request                               */
            uint32_t                 : 29;
        } SNZREQCR1_b;
    };
    __IM uint32_t RESERVED23;
    __IM uint16_t RESERVED24;

    union
    {
        __IOM uint8_t SNZCR;            /*!< (@ 0x00000092) Snooze Control Register                                    */

        struct
        {
            __IOM uint8_t RXDREQEN : 1; /*!< [0..0] RXD0 Snooze Request Enable NOTE: Do not set to 1 other
                                         *   than in asynchronous mode.                                                */
            __IOM uint8_t SNZDTCEN : 1; /*!< [1..1] DTC Enable in Snooze Mode                                          */
            uint8_t                : 5;
            __IOM uint8_t SNZE     : 1; /*!< [7..7] Snooze Mode Enable                                                 */
        } SNZCR_b;
    };
    __IM uint8_t RESERVED25;

    union
    {
        __IOM uint8_t SNZEDCR;           /*!< (@ 0x00000094) Snooze End Control Register                                */

        struct
        {
            __IOM uint8_t AGT1UNFED : 1; /*!< [0..0] AGT1 underflow Snooze End Enable                                   */
            __IOM uint8_t DTCZRED   : 1; /*!< [1..1] Last DTC transmission completion Snooze End Enable                 */
            __IOM uint8_t DTCNZRED  : 1; /*!< [2..2] Not Last DTC transmission completion Snooze End Enable             */
            __IOM uint8_t AD0MATED  : 1; /*!< [3..3] AD compare match 0 Snooze End Enable                               */
            __IOM uint8_t AD0UMTED  : 1; /*!< [4..4] AD compare mismatch 0 Snooze End Enable                            */
            __IOM uint8_t AD1MATED  : 1; /*!< [5..5] AD compare match 1 Snooze End Enable                               */
            __IOM uint8_t AD1UMTED  : 1; /*!< [6..6] AD compare mismatch 1 Snooze End Enable                            */
            __IOM uint8_t SCI0UMTED : 1; /*!< [7..7] SCI0 address unmatch Snooze End EnableNote: Do not set
                                          *   to 1 other than in asynchronous mode.                                     */
        } SNZEDCR_b;
    };

    union
    {
        __IOM uint8_t SNZEDCR1;          /*!< (@ 0x00000095) Snooze End Control Register 1                              */

        struct
        {
            __IOM uint8_t AGT3UNFED : 1; /*!< [0..0] AGT3 underflow Snooze End Enable                                   */
            uint8_t                 : 7;
        } SNZEDCR1_b;
    };
    __IM uint16_t RESERVED26;

    union
    {
        __IOM uint32_t SNZREQCR;           /*!< (@ 0x00000098) Snooze Request Control Register                            */

        struct
        {
            __IOM uint32_t SNZREQEN0  : 1; /*!< [0..0] Snooze Request Enable 0Enable IRQ 0 pin snooze request             */
            __IOM uint32_t SNZREQEN1  : 1; /*!< [1..1] Snooze Request Enable 0Enable IRQ 1 pin snooze request             */
            __IOM uint32_t SNZREQEN2  : 1; /*!< [2..2] Snooze Request Enable 0Enable IRQ 2 pin snooze request             */
            __IOM uint32_t SNZREQEN3  : 1; /*!< [3..3] Snooze Request Enable 0Enable IRQ 3 pin snooze request             */
            __IOM uint32_t SNZREQEN4  : 1; /*!< [4..4] Snooze Request Enable 0Enable IRQ 4 pin snooze request             */
            __IOM uint32_t SNZREQEN5  : 1; /*!< [5..5] Snooze Request Enable 0Enable IRQ 5 pin snooze request             */
            __IOM uint32_t SNZREQEN6  : 1; /*!< [6..6] Snooze Request Enable 0Enable IRQ 6 pin snooze request             */
            __IOM uint32_t SNZREQEN7  : 1; /*!< [7..7] Snooze Request Enable 0Enable IRQ 7 pin snooze request             */
            __IOM uint32_t SNZREQEN8  : 1; /*!< [8..8] Snooze Request Enable 0Enable IRQ 8 pin snooze request             */
            __IOM uint32_t SNZREQEN9  : 1; /*!< [9..9] Snooze Request Enable 0Enable IRQ 9 pin snooze request             */
            __IOM uint32_t SNZREQEN10 : 1; /*!< [10..10] Snooze Request Enable 0Enable IRQ 10 pin snooze request          */
            __IOM uint32_t SNZREQEN11 : 1; /*!< [11..11] Snooze Request Enable 0Enable IRQ 11 pin snooze request          */
            __IOM uint32_t SNZREQEN12 : 1; /*!< [12..12] Snooze Request Enable 0Enable IRQ 12 pin snooze request          */
            __IOM uint32_t SNZREQEN13 : 1; /*!< [13..13] Snooze Request Enable 0Enable IRQ 13 pin snooze request          */
            __IOM uint32_t SNZREQEN14 : 1; /*!< [14..14] Snooze Request Enable 0Enable IRQ 14 pin snooze request          */
            __IOM uint32_t SNZREQEN15 : 1; /*!< [15..15] Snooze Request Enable 0Enable IRQ 15 pin snooze request          */
            uint32_t                  : 1;
            __IOM uint32_t SNZREQEN17 : 1; /*!< [17..17] Snooze Request Enable 17Enable KR snooze request                 */
            uint32_t                  : 4;
            __IOM uint32_t SNZREQEN22 : 1; /*!< [22..22] Snooze Request Enable 22Enable Comparator-HS0 snooze
                                            *   request                                                                   */
            __IOM uint32_t SNZREQEN23 : 1; /*!< [23..23] Snooze Request Enable 23Enable Comparator-LP0 snooze
                                            *   request                                                                   */
            __IOM uint32_t SNZREQEN24 : 1; /*!< [24..24] Snooze Request Enable 24Enable RTC alarm snooze request          */
            __IOM uint32_t SNZREQEN25 : 1; /*!< [25..25] Snooze Request Enable 25Enable RTC period snooze request         */
            uint32_t                  : 2;
            __IOM uint32_t SNZREQEN28 : 1; /*!< [28..28] Snooze Request Enable 28Enable AGT1 underflow snooze
                                            *   request                                                                   */
            __IOM uint32_t SNZREQEN29 : 1; /*!< [29..29] Snooze Request Enable 29Enable AGT1 compare match A
                                            *   snooze request                                                            */
            __IOM uint32_t SNZREQEN30 : 1; /*!< [30..30] Snooze Request Enable 30Enable AGT1 compare match B
                                            *   snooze request                                                            */
            uint32_t : 1;
        } SNZREQCR_b;
    };
    __IM uint16_t RESERVED27;

    union
    {
        __IOM uint8_t FLSTOP;          /*!< (@ 0x0000009E) Flash Operation Control Register                           */

        struct
        {
            __IOM uint8_t FLSTOP : 1;  /*!< [0..0] Selecting ON/OFF of the Flash Memory Operation                     */
            uint8_t              : 3;
            __IOM uint8_t FLSTPF : 1;  /*!< [4..4] Flash Memory Operation Status Flag                                 */
            uint8_t              : 3;
        } FLSTOP_b;
    };

    union
    {
        __IOM uint8_t PSMCR;           /*!< (@ 0x0000009F) Power Save Memory Control Register                         */

        struct
        {
            __IOM uint8_t PSMC : 2;    /*!< [1..0] Power save memory control.                                         */
            uint8_t            : 6;
        } PSMCR_b;
    };

    union
    {
        __IOM uint8_t OPCCR;           /*!< (@ 0x000000A0) Operating Power Control Register                           */

        struct
        {
            __IOM uint8_t OPCM   : 2;  /*!< [1..0] Operating Power Control Mode Select                                */
            uint8_t              : 2;
            __IM uint8_t OPCMTSF : 1;  /*!< [4..4] Operating Power Control Mode Transition Status Flag                */
            uint8_t              : 3;
        } OPCCR_b;
    };
    __IM uint8_t RESERVED28;

    union
    {
        __IOM uint8_t MOSCWTCR;        /*!< (@ 0x000000A2) Main Clock Oscillator Wait Control Register                */

        struct
        {
            __IOM uint8_t MSTS : 4;    /*!< [3..0] Main clock oscillator wait time setting                            */
            uint8_t            : 4;
        } MOSCWTCR_b;
    };
    __IM uint8_t RESERVED29[2];

    union
    {
        __IOM uint8_t HOCOWTCR;        /*!< (@ 0x000000A5) High-speed on-chip oscillator wait control register        */

        struct
        {
            __IOM uint8_t HSTS : 3;    /*!< [2..0] HOCO wait time settingWaiting time (sec) = setting of
                                        *   the HSTS[2:0] bits/fLOCO(Trimmed) + 3/fLOC(Untrimmed)                     */
            uint8_t : 5;
        } HOCOWTCR_b;
    };
    __IM uint16_t RESERVED30[2];

    union
    {
        __IOM uint8_t SOPCCR;          /*!< (@ 0x000000AA) Sub Operating Power Control Register                       */

        struct
        {
            __IOM uint8_t SOPCM   : 1; /*!< [0..0] Sub Operating Power Control Mode Select                            */
            uint8_t               : 3;
            __IM uint8_t SOPCMTSF : 1; /*!< [4..4] Sub Operating Power Control Mode Transition Status Flag            */
            uint8_t               : 3;
        } SOPCCR_b;
    };
    __IM uint8_t  RESERVED31;
    __IM uint32_t RESERVED32[5];

    union
    {
        __IOM uint16_t RSTSR1;         /*!< (@ 0x000000C0) Reset Status Register 1                                    */

        struct
        {
            __IOM uint16_t IWDTRF : 1; /*!< [0..0] Independent Watchdog Timer Reset Detect FlagNOTE: Writable
                                        *   only to clear the flag. Confirm the value is 1 and then
                                        *   write 0.                                                                  */
            __IOM uint16_t WDTRF : 1;  /*!< [1..1] Watchdog Timer Reset Detect FlagNOTE: Writable only to
                                        *   clear the flag. Confirm the value is 1 and then write 0.                  */
            __IOM uint16_t SWRF : 1;   /*!< [2..2] Software Reset Detect FlagNOTE: Writable only to clear
                                        *   the flag. Confirm the value is 1 and then write 0.                        */
            uint16_t             : 5;
            __IOM uint16_t RPERF : 1;  /*!< [8..8] RAM Parity Error Reset Detect FlagNOTE: Writable only
                                        *   to clear the flag. Confirm the value is 1 and then write
                                        *   0.                                                                        */
            __IOM uint16_t REERF : 1;  /*!< [9..9] RAM ECC Error Reset Detect FlagNOTE: Writable only to
                                        *   clear the flag. Confirm the value is 1 and then write 0.                  */
            __IOM uint16_t BUSSRF : 1; /*!< [10..10] Bus Slave MPU Reset Detect FlagNOTE: Writable only
                                        *   to clear the flag. Confirm the value is 1 and then write
                                        *   0.                                                                        */
            __IOM uint16_t BUSMRF : 1; /*!< [11..11] Bus Master MPU Reset Detect FlagNOTE: Writable only
                                        *   to clear the flag. Confirm the value is 1 and then write
                                        *   0.                                                                        */
            __IOM uint16_t SPERF : 1;  /*!< [12..12] SP Error Reset Detect FlagNOTE: Writable only to clear
                                        *   the flag. Confirm the value is 1 and then write 0.                        */
            __IOM uint16_t TZERF : 1;  /*!< [13..13] Trust Zone Error Reset Detect Flag                               */
            uint16_t             : 1;
            __IOM uint16_t CPERF : 1;  /*!< [15..15] Cache Parity Error Reset Detect Flag                             */
        } RSTSR1_b;
    };
    __IM uint16_t RESERVED33;
    __IM uint32_t RESERVED34[3];

    union
    {
        __IOM uint8_t USBCKCR_ALT;       /*!< (@ 0x000000D0) USB Clock Control Register                                 */

        struct
        {
            __IOM uint8_t USBCLKSEL : 1; /*!< [0..0] The USBCLKSEL bit selects the source of the USB clock
                                          *   (UCLK).                                                                   */
            uint8_t : 7;
        } USBCKCR_ALT_b;
    };

    union
    {
        __IOM uint8_t SDADCCKCR;          /*!< (@ 0x000000D1) 24-bit Sigma-Delta A/D Converter Clock Control
                                           *                  Register                                                   */

        struct
        {
            __IOM uint8_t SDADCCKSEL : 1; /*!< [0..0] 24-bit Sigma-Delta A/D Converter Clock Select                      */
            uint8_t                  : 6;
            __IOM uint8_t SDADCCKEN  : 1; /*!< [7..7] 24-bit Sigma-Delta A/D Converter Clock Enable                      */
        } SDADCCKCR_b;
    };
    __IM uint16_t RESERVED35;
    __IM uint32_t RESERVED36[3];

    union
    {
        __IOM uint8_t LVD1CR1;         /*!< (@ 0x000000E0) Voltage Monitor 1 Circuit Control Register 1               */

        struct
        {
            __IOM uint8_t IDTSEL : 2;  /*!< [1..0] Voltage Monitor Interrupt Generation Condition Select              */
            __IOM uint8_t IRQSEL : 1;  /*!< [2..2] Voltage Monitor Interrupt Type Select                              */
            uint8_t              : 5;
        } LVD1CR1_b;
    };

    union
    {
        __IOM uint8_t LVD1SR;          /*!< (@ 0x000000E1) Voltage Monitor 1 Circuit Status Register                  */

        struct
        {
            __IOM uint8_t DET : 1;     /*!< [0..0] Voltage Monitor Voltage Change Detection Flag NOTE: Only
                                        *   0 can be written to this bit. After writing 0 to this bit,
                                        *   it takes 2 system clock cycles for the bit to be read as
                                        *   0.                                                                        */
            __IM uint8_t MON : 1;      /*!< [1..1] Voltage Monitor 1 Signal Monitor Flag                              */
            uint8_t          : 6;
        } LVD1SR_b;
    };

    union
    {
        __IOM uint8_t LVD2CR1;         /*!< (@ 0x000000E2) Voltage Monitor 2 Circuit Control Register 1               */

        struct
        {
            __IOM uint8_t IDTSEL : 2;  /*!< [1..0] Voltage Monitor Interrupt Generation Condition Select              */
            __IOM uint8_t IRQSEL : 1;  /*!< [2..2] Voltage Monitor Interrupt Type Select                              */
            uint8_t              : 5;
        } LVD2CR1_b;
    };

    union
    {
        __IOM uint8_t LVD2SR;          /*!< (@ 0x000000E3) Voltage Monitor 2 Circuit Status Register                  */

        struct
        {
            __IOM uint8_t DET : 1;     /*!< [0..0] Voltage Monitor Voltage Change Detection Flag NOTE: Only
                                        *   0 can be written to this bit. After writing 0 to this bit,
                                        *   it takes 2 system clock cycles for the bit to be read as
                                        *   0.                                                                        */
            __IM uint8_t MON : 1;      /*!< [1..1] Voltage Monitor 1 Signal Monitor Flag                              */
            uint8_t          : 6;
        } LVD2SR_b;
    };
    __IM uint32_t RESERVED37[183];

    union
    {
        __IOM uint32_t CGFSAR;           /*!< (@ 0x000003C0) Clock Generation Function Security Attribute
                                          *                  Register                                                   */

        struct
        {
            __IOM uint32_t NONSEC00 : 1; /*!< [0..0] Non Secure Attribute bit 00                                        */
            uint32_t                : 1;
            __IOM uint32_t NONSEC02 : 1; /*!< [2..2] Non Secure Attribute bit 02                                        */
            __IOM uint32_t NONSEC03 : 1; /*!< [3..3] Non Secure Attribute bit 03                                        */
            __IOM uint32_t NONSEC04 : 1; /*!< [4..4] Non Secure Attribute bit 04                                        */
            __IOM uint32_t NONSEC05 : 1; /*!< [5..5] Non Secure Attribute bit 05                                        */
            __IOM uint32_t NONSEC06 : 1; /*!< [6..6] Non Secure Attribute bit 06                                        */
            __IOM uint32_t NONSEC07 : 1; /*!< [7..7] Non Secure Attribute bit 07                                        */
            __IOM uint32_t NONSEC08 : 1; /*!< [8..8] Non Secure Attribute bit 08                                        */
            __IOM uint32_t NONSEC09 : 1; /*!< [9..9] Non Secure Attribute bit 09                                        */
            uint32_t                : 1;
            __IOM uint32_t NONSEC11 : 1; /*!< [11..11] Non Secure Attribute bit 11                                      */
            __IOM uint32_t NONSEC12 : 1; /*!< [12..12] Non Secure Attribute bit 12                                      */
            uint32_t                : 3;
            __IOM uint32_t NONSEC16 : 1; /*!< [16..16] Non Secure Attribute bit 16                                      */
            __IOM uint32_t NONSEC17 : 1; /*!< [17..17] Non Secure Attribute bit 17                                      */
            uint32_t                : 14;
        } CGFSAR_b;
    };
    __IM uint32_t RESERVED38;

    union
    {
        __IOM uint32_t LPMSAR;          /*!< (@ 0x000003C8) Low Power Mode Security Attribution Register               */

        struct
        {
            __IOM uint32_t NONSEC0 : 1; /*!< [0..0] Non Secure Attribute bit 0                                         */
            uint32_t               : 1;
            __IOM uint32_t NONSEC2 : 1; /*!< [2..2] Non Secure Attribute bit 2                                         */
            uint32_t               : 1;
            __IOM uint32_t NONSEC4 : 1; /*!< [4..4] Non Secure Attribute bit 4                                         */
            uint32_t               : 3;
            __IOM uint32_t NONSEC8 : 1; /*!< [8..8] Non Secure Attribute bit 8                                         */
            __IOM uint32_t NONSEC9 : 1; /*!< [9..9] Non Secure Attribute bit 9                                         */
            uint32_t               : 22;
        } LPMSAR_b;
    };

    union
    {
        union
        {
            __IOM uint32_t LVDSAR;          /*!< (@ 0x000003CC) Low Voltage Detection Security Attribution Register        */

            struct
            {
                __IOM uint32_t NONSEC0 : 1; /*!< [0..0] Non Secure Attribute bit 0                                         */
                __IOM uint32_t NONSEC1 : 1; /*!< [1..1] Non Secure Attribute bit 1                                         */
                uint32_t               : 30;
            } LVDSAR_b;
        };

        union
        {
            __IOM uint32_t RSTSAR;          /*!< (@ 0x000003CC) Reset Security Attribution Register                        */

            struct
            {
                __IOM uint32_t NONSEC0 : 1; /*!< [0..0] Non Secure Attribute bit 0                                         */
                __IOM uint32_t NONSEC1 : 1; /*!< [1..1] Non Secure Attribute bit 1                                         */
                __IOM uint32_t NONSEC2 : 1; /*!< [2..2] Non Secure Attribute bit 2                                         */
                uint32_t               : 29;
            } RSTSAR_b;
        };
    };

    union
    {
        __IOM uint32_t BBFSAR;           /*!< (@ 0x000003D0) Battery Backup Function Security Attribute Register        */

        struct
        {
            __IOM uint32_t NONSEC0  : 1; /*!< [0..0] Non Secure Attribute bit 0                                         */
            __IOM uint32_t NONSEC1  : 1; /*!< [1..1] Non Secure Attribute bit 1                                         */
            __IOM uint32_t NONSEC2  : 1; /*!< [2..2] Non Secure Attribute bit 2                                         */
            uint32_t                : 13;
            __IOM uint32_t NONSEC16 : 1; /*!< [16..16] Non Secure Attribute bit 16                                      */
            __IOM uint32_t NONSEC17 : 1; /*!< [17..17] Non Secure Attribute bit 17                                      */
            __IOM uint32_t NONSEC18 : 1; /*!< [18..18] Non Secure Attribute bit 18                                      */
            __IOM uint32_t NONSEC19 : 1; /*!< [19..19] Non Secure Attribute bit 19                                      */
            __IOM uint32_t NONSEC20 : 1; /*!< [20..20] Non Secure Attribute bit 20                                      */
            __IOM uint32_t NONSEC21 : 1; /*!< [21..21] Non Secure Attribute bit 21                                      */
            __IOM uint32_t NONSEC22 : 1; /*!< [22..22] Non Secure Attribute bit 22                                      */
            __IOM uint32_t NONSEC23 : 1; /*!< [23..23] Non Secure Attribute bit 23                                      */
            uint32_t                : 8;
        } BBFSAR_b;
    };
    __IM uint32_t RESERVED39[3];

    union
    {
        __IOM uint32_t DPFSAR;          /*!< (@ 0x000003E0) Deep Standby Interrupt Factor Security Attribution
                                         *                  Register                                                   */

        struct
        {
            __IOM uint32_t DPFSA0 : 1;  /*!< [0..0] Deep Standby Interrupt Factor Security Attribute bit
                                         *   0                                                                         */
            __IOM uint32_t DPFSA1 : 1;  /*!< [1..1] Deep Standby Interrupt Factor Security Attribute bit
                                         *   1                                                                         */
            __IOM uint32_t DPFSA2 : 1;  /*!< [2..2] Deep Standby Interrupt Factor Security Attribute bit
                                         *   2                                                                         */
            __IOM uint32_t DPFSA3 : 1;  /*!< [3..3] Deep Standby Interrupt Factor Security Attribute bit
                                         *   3                                                                         */
            __IOM uint32_t DPFSA4 : 1;  /*!< [4..4] Deep Standby Interrupt Factor Security Attribute bit
                                         *   4                                                                         */
            __IOM uint32_t DPFSA5 : 1;  /*!< [5..5] Deep Standby Interrupt Factor Security Attribute bit
                                         *   5                                                                         */
            __IOM uint32_t DPFSA6 : 1;  /*!< [6..6] Deep Standby Interrupt Factor Security Attribute bit
                                         *   6                                                                         */
            __IOM uint32_t DPFSA7 : 1;  /*!< [7..7] Deep Standby Interrupt Factor Security Attribute bit
                                         *   7                                                                         */
            __IOM uint32_t DPFSA8 : 1;  /*!< [8..8] Deep Standby Interrupt Factor Security Attribute bit
                                         *   8                                                                         */
            __IOM uint32_t DPFSA9 : 1;  /*!< [9..9] Deep Standby Interrupt Factor Security Attribute bit
                                         *   9                                                                         */
            __IOM uint32_t DPFSA10 : 1; /*!< [10..10] Deep Standby Interrupt Factor Security Attribute bit
                                         *   10                                                                        */
            __IOM uint32_t DPFSA11 : 1; /*!< [11..11] Deep Standby Interrupt Factor Security Attribute bit
                                         *   11                                                                        */
            __IOM uint32_t DPFSA12 : 1; /*!< [12..12] Deep Standby Interrupt Factor Security Attribute bit
                                         *   12                                                                        */
            __IOM uint32_t DPFSA13 : 1; /*!< [13..13] Deep Standby Interrupt Factor Security Attribute bit
                                         *   13                                                                        */
            __IOM uint32_t DPFSA14 : 1; /*!< [14..14] Deep Standby Interrupt Factor Security Attribute bit
                                         *   14                                                                        */
            __IOM uint32_t DPFSA15 : 1; /*!< [15..15] Deep Standby Interrupt Factor Security Attribute bit
                                         *   15                                                                        */
            __IOM uint32_t DPFSA16 : 1; /*!< [16..16] Deep Standby Interrupt Factor Security Attribute bit
                                         *   16                                                                        */
            __IOM uint32_t DPFSA17 : 1; /*!< [17..17] Deep Standby Interrupt Factor Security Attribute bit
                                         *   17                                                                        */
            __IOM uint32_t DPFSA18 : 1; /*!< [18..18] Deep Standby Interrupt Factor Security Attribute bit
                                         *   18                                                                        */
            __IOM uint32_t DPFSA19 : 1; /*!< [19..19] Deep Standby Interrupt Factor Security Attribute bit
                                         *   19                                                                        */
            __IOM uint32_t DPFSA20 : 1; /*!< [20..20] Deep Standby Interrupt Factor Security Attribute bit
                                         *   20                                                                        */
            uint32_t               : 3;
            __IOM uint32_t DPFSA24 : 1; /*!< [24..24] Deep Standby Interrupt Factor Security Attribute bit
                                         *   24                                                                        */
            uint32_t               : 1;
            __IOM uint32_t DPFSA26 : 1; /*!< [26..26] Deep Standby Interrupt Factor Security Attribute bit
                                         *   26                                                                        */
            __IOM uint32_t DPFSA27 : 1; /*!< [27..27] Deep Standby Interrupt Factor Security Attribute bit
                                         *   27                                                                        */
            uint32_t : 4;
        } DPFSAR_b;
    };
    __IM uint32_t RESERVED40[6];
    __IM uint16_t RESERVED41;

    union
    {
        __IOM uint16_t PRCR;           /*!< (@ 0x000003FE) Protect Register                                           */

        struct
        {
            __IOM uint16_t PRC0 : 1;   /*!< [0..0] Enables writing to the registers related to the clock
                                        *   generation circuit.                                                       */
            __IOM uint16_t PRC1 : 1;   /*!< [1..1] Enables writing to the registers related to the operating
                                        *   modes, the low power consumption modes and the battery
                                        *   backup function.                                                          */
            uint16_t            : 1;
            __IOM uint16_t PRC3 : 1;   /*!< [3..3] Enables writing to the registers related to the LVD.               */
            __IOM uint16_t PRC4 : 1;   /*!< [4..4] PRC4                                                               */
            uint16_t            : 3;
            __OM uint16_t PRKEY : 8;   /*!< [15..8] PRKEY Key Code                                                    */
        } PRCR_b;
    };

    union
    {
        __IOM uint8_t DPSBYCR;         /*!< (@ 0x00000400) Deep Standby Control Register                              */

        struct
        {
            __IOM uint8_t DEEPCUT : 2; /*!< [1..0] Power-Supply Control                                               */
            uint8_t               : 4;
            __IOM uint8_t IOKEEP  : 1; /*!< [6..6] I/O Port Retention                                                 */
            __IOM uint8_t DPSBY   : 1; /*!< [7..7] Deep Software Standby                                              */
        } DPSBYCR_b;
    };

    union
    {
        __IOM uint8_t DPSWCR;          /*!< (@ 0x00000401) Deep Standby Wait Control Register                         */

        struct
        {
            __IOM uint8_t WTSTS : 6;   /*!< [5..0] Deep Software Wait Standby Time Setting Bit                        */
            uint8_t             : 2;
        } DPSWCR_b;
    };

    union
    {
        __IOM uint8_t DPSIER0;         /*!< (@ 0x00000402) Deep Standby Interrupt Enable Register 0                   */

        struct
        {
            __IOM uint8_t DIRQ0E : 1;  /*!< [0..0] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ1E : 1;  /*!< [1..1] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ2E : 1;  /*!< [2..2] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ3E : 1;  /*!< [3..3] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ4E : 1;  /*!< [4..4] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ5E : 1;  /*!< [5..5] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ6E : 1;  /*!< [6..6] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ7E : 1;  /*!< [7..7] IRQ-DS Pin Enable                                                  */
        } DPSIER0_b;
    };

    union
    {
        __IOM uint8_t DPSIER1;         /*!< (@ 0x00000403) Deep Standby Interrupt Enable Register 1                   */

        struct
        {
            __IOM uint8_t DIRQ8E  : 1; /*!< [0..0] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ9E  : 1; /*!< [1..1] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ10E : 1; /*!< [2..2] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ11E : 1; /*!< [3..3] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ12E : 1; /*!< [4..4] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ13E : 1; /*!< [5..5] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ14E : 1; /*!< [6..6] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ15E : 1; /*!< [7..7] IRQ-DS Pin Enable                                                  */
        } DPSIER1_b;
    };

    union
    {
        __IOM uint8_t DPSIER2;          /*!< (@ 0x00000404) Deep Standby Interrupt Enable Register 2                   */

        struct
        {
            __IOM uint8_t DLVD1IE  : 1; /*!< [0..0] LVD1 Deep Standby Cancel Signal Enable                             */
            __IOM uint8_t DLVD2IE  : 1; /*!< [1..1] LVD2 Deep Standby Cancel Signal Enable                             */
            __IOM uint8_t DTRTCIIE : 1; /*!< [2..2] RTC Interval interrupt Deep Standby Cancel Signal Enable           */
            __IOM uint8_t DRTCAIE  : 1; /*!< [3..3] RTC Alarm interrupt Deep Standby Cancel Signal Enable              */
            __IOM uint8_t DNMIE    : 1; /*!< [4..4] NMI Pin Enable                                                     */
            uint8_t                : 3;
        } DPSIER2_b;
    };

    union
    {
        __IOM uint8_t DPSIER3;          /*!< (@ 0x00000405) Deep Standby Interrupt Enable Register 3                   */

        struct
        {
            __IOM uint8_t DUSBFSIE : 1; /*!< [0..0] USBFS Suspend/Resume Deep Standby Cancel Signal Enable             */
            __IOM uint8_t DUSBHSIE : 1; /*!< [1..1] USBHS Suspend/Resume Deep Standby Cancel Signal Enable             */
            __IOM uint8_t DAGT1IE  : 1; /*!< [2..2] AGT1 Underflow Deep Standby Cancel Signal Enable                   */
            __IOM uint8_t DAGT3IE  : 1; /*!< [3..3] AGT3 Underflow Deep Standby Cancel Signal Enable                   */
            uint8_t                : 4;
        } DPSIER3_b;
    };

    union
    {
        __IOM uint8_t DPSIFR0;         /*!< (@ 0x00000406) Deep Standby Interrupt Flag Register 0                     */

        struct
        {
            __IOM uint8_t DIRQ0F : 1;  /*!< [0..0] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ1F : 1;  /*!< [1..1] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ2F : 1;  /*!< [2..2] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ3F : 1;  /*!< [3..3] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ4F : 1;  /*!< [4..4] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ5F : 1;  /*!< [5..5] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ6F : 1;  /*!< [6..6] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ7F : 1;  /*!< [7..7] IRQ-DS Pin Deep Standby Cancel Flag                                */
        } DPSIFR0_b;
    };

    union
    {
        __IOM uint8_t DPSIFR1;         /*!< (@ 0x00000407) Deep Standby Interrupt Flag Register 1                     */

        struct
        {
            __IOM uint8_t DIRQ8F  : 1; /*!< [0..0] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ9F  : 1; /*!< [1..1] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ10F : 1; /*!< [2..2] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ11F : 1; /*!< [3..3] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ12F : 1; /*!< [4..4] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ13F : 1; /*!< [5..5] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ14F : 1; /*!< [6..6] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ15F : 1; /*!< [7..7] IRQ-DS Pin Deep Standby Cancel Flag                                */
        } DPSIFR1_b;
    };

    union
    {
        __IOM uint8_t DPSIFR2;          /*!< (@ 0x00000408) Deep Standby Interrupt Flag Register 2                     */

        struct
        {
            __IOM uint8_t DLVD1IF  : 1; /*!< [0..0] LVD1 Deep Standby Cancel Flag                                      */
            __IOM uint8_t DLVD2IF  : 1; /*!< [1..1] LVD2 Deep Standby Cancel Flag                                      */
            __IOM uint8_t DTRTCIIF : 1; /*!< [2..2] RTC Interval interrupt Deep Standby Cancel Flag                    */
            __IOM uint8_t DRTCAIF  : 1; /*!< [3..3] RTC Alarm interrupt Deep Standby Cancel Flag                       */
            __IOM uint8_t DNMIF    : 1; /*!< [4..4] NMI Pin Deep Standby Cancel Flag                                   */
            uint8_t                : 3;
        } DPSIFR2_b;
    };

    union
    {
        __IOM uint8_t DPSIFR3;          /*!< (@ 0x00000409) Deep Standby Interrupt Flag Register 3                     */

        struct
        {
            __IOM uint8_t DUSBFSIF : 1; /*!< [0..0] USBFS Suspend/Resume Deep Standby Cancel Flag                      */
            __IOM uint8_t DUSBHSIF : 1; /*!< [1..1] USBHS Suspend/Resume Deep Standby Cancel Flag                      */
            __IOM uint8_t DAGT1IF  : 1; /*!< [2..2] AGT1 Underflow Deep Standby Cancel Flag                            */
            __IOM uint8_t DAGT3IF  : 1; /*!< [3..3] AGT3 Underflow Deep Standby Cancel Flag                            */
            uint8_t                : 4;
        } DPSIFR3_b;
    };

    union
    {
        __IOM uint8_t DPSIEGR0;        /*!< (@ 0x0000040A) Deep Standby Interrupt Edge Register 0                     */

        struct
        {
            __IOM uint8_t DIRQ0EG : 1; /*!< [0..0] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ1EG : 1; /*!< [1..1] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ2EG : 1; /*!< [2..2] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ3EG : 1; /*!< [3..3] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ4EG : 1; /*!< [4..4] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ5EG : 1; /*!< [5..5] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ6EG : 1; /*!< [6..6] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ7EG : 1; /*!< [7..7] IRQ-DS Pin Edge Select                                             */
        } DPSIEGR0_b;
    };

    union
    {
        __IOM uint8_t DPSIEGR1;        /*!< (@ 0x0000040B) Deep Standby Interrupt Edge Register 1                     */

        struct
        {
            __IOM uint8_t DIRQ0EG : 1; /*!< [0..0] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ1EG : 1; /*!< [1..1] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ2EG : 1; /*!< [2..2] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ3EG : 1; /*!< [3..3] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ4EG : 1; /*!< [4..4] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ5EG : 1; /*!< [5..5] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ6EG : 1; /*!< [6..6] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ7EG : 1; /*!< [7..7] IRQ-DS Pin Edge Select                                             */
        } DPSIEGR1_b;
    };

    union
    {
        __IOM uint8_t DPSIEGR2;         /*!< (@ 0x0000040C) Deep Standby Interrupt Edge Register 2                     */

        struct
        {
            __IOM uint8_t DLVD1IEG : 1; /*!< [0..0] LVD1 Edge Select                                                   */
            __IOM uint8_t DLVD2IEG : 1; /*!< [1..1] LVD2 Edge Select                                                   */
            uint8_t                : 2;
            __IOM uint8_t DNMIEG   : 1; /*!< [4..4] NMI Pin Edge Select                                                */
            uint8_t                : 3;
        } DPSIEGR2_b;
    };
    __IM uint8_t RESERVED42;

    union
    {
        __IOM uint8_t SYOCDCR;         /*!< (@ 0x0000040E) System Control OCD Control Register                        */

        struct
        {
            __IOM uint8_t DOCDF : 1;   /*!< [0..0] Deep Standby OCD flag                                              */
            uint8_t             : 6;
            __IOM uint8_t DBGEN : 1;   /*!< [7..7] Debugger Enable bit                                                */
        } SYOCDCR_b;
    };

    union
    {
        __IOM uint8_t STCONR;          /*!< (@ 0x0000040F) Standby Condition Register                                 */

        struct
        {
            __IOM uint8_t STCON : 2;   /*!< [1..0] SSTBY condition bit                                                */
            uint8_t             : 6;
        } STCONR_b;
    };

    union
    {
        __IOM uint8_t RSTSR0;          /*!< (@ 0x00000410) Reset Status Register 0                                    */

        struct
        {
            __IOM uint8_t PORF : 1;    /*!< [0..0] Power-On Reset Detect FlagNOTE: Writable only to clear
                                        *   the flag. Confirm the value is 1 and then write 0.                        */
            __IOM uint8_t LVD0RF : 1;  /*!< [1..1] Voltage Monitor 0 Reset Detect FlagNOTE: Writable only
                                        *   to clear the flag. Confirm the value is 1 and then write
                                        *   0.                                                                        */
            __IOM uint8_t LVD1RF : 1;  /*!< [2..2] Voltage Monitor 1 Reset Detect FlagNOTE: Writable only
                                        *   to clear the flag. Confirm the value is 1 and then write
                                        *   0.                                                                        */
            __IOM uint8_t LVD2RF : 1;  /*!< [3..3] Voltage Monitor 2 Reset Detect FlagNOTE: Writable only
                                        *   to clear the flag. Confirm the value is 1 and then write
                                        *   0.                                                                        */
            uint8_t               : 3;
            __IOM uint8_t DPSRSTF : 1; /*!< [7..7] Deep Software Standby Reset FlagNOTE: Writable only to
                                        *   clear the flag. Confirm the value is 1 and then write 0.                  */
        } RSTSR0_b;
    };

    union
    {
        __IOM uint8_t RSTSR2;          /*!< (@ 0x00000411) Reset Status Register 2                                    */

        struct
        {
            __IOM uint8_t CWSF : 1;    /*!< [0..0] Cold/Warm Start Determination Flag                                 */
            uint8_t            : 7;
        } RSTSR2_b;
    };
    __IM uint8_t RESERVED43;

    union
    {
        __IOM uint8_t MOMCR;           /*!< (@ 0x00000413) Main Clock Oscillator Mode Oscillation Control
                                        *                  Register                                                   */

        struct
        {
            uint8_t                 : 3;
            __IOM uint8_t MODRV1    : 1; /*!< [3..3] Main Clock Oscillator Drive Capability 1 Switching                 */
            __IOM uint8_t MODRV0    : 2; /*!< [5..4] Main Clock Oscillator Drive Capability 0 Switching                 */
            __IOM uint8_t MOSEL     : 1; /*!< [6..6] Main Clock Oscillator Switching                                    */
            __IOM uint8_t AUTODRVEN : 1; /*!< [7..7] Main Clock Oscillator Drive Capability Auto Switching
                                          *   Enable                                                                    */
        } MOMCR_b;
    };
    __IM uint16_t RESERVED44;

    union
    {
        __IOM uint8_t FWEPROR;         /*!< (@ 0x00000416) Flash P/E Protect Register                                 */

        struct
        {
            __IOM uint8_t FLWE : 2;    /*!< [1..0] Flash Programming and Erasure                                      */
            uint8_t            : 6;
        } FWEPROR_b;
    };

    union
    {
        union
        {
            __IOM uint8_t LVCMPCR;     /*!< (@ 0x00000417) Voltage Monitor Circuit Control Register                   */

            struct
            {
                uint8_t             : 5;
                __IOM uint8_t LVD1E : 1; /*!< [5..5] Voltage Detection 1 Enable                                         */
                __IOM uint8_t LVD2E : 1; /*!< [6..6] Voltage Detection 2 Enable                                         */
                uint8_t             : 1;
            } LVCMPCR_b;
        };

        union
        {
            __IOM uint8_t LVD1CMPCR;       /*!< (@ 0x00000417) Voltage Monitoring 1 Comparator Control Register           */

            struct
            {
                __IOM uint8_t LVD1LVL : 5; /*!< [4..0] Voltage Detection 1 Level Select (Standard voltage during
                                            *   drop in voltage)                                                          */
                uint8_t             : 2;
                __IOM uint8_t LVD1E : 1;   /*!< [7..7] Voltage Detection 1 Enable                                         */
            } LVD1CMPCR_b;
        };
    };

    union
    {
        union
        {
            __IOM uint8_t LVDLVLR;         /*!< (@ 0x00000418) Voltage Detection Level Select Register                    */

            struct
            {
                __IOM uint8_t LVD1LVL : 5; /*!< [4..0] Voltage Detection 1 Level Select (Standard voltage during
                                            *   fall in voltage)                                                          */
                __IOM uint8_t LVD2LVL : 3; /*!< [7..5] Voltage Detection 2 Level Select (Standard voltage during
                                            *   fall in voltage)                                                          */
            } LVDLVLR_b;
        };

        union
        {
            __IOM uint8_t LVD2CMPCR;       /*!< (@ 0x00000418) Voltage Monitoring 2 Comparator Control Register           */

            struct
            {
                __IOM uint8_t LVD2LVL : 3; /*!< [2..0] Voltage Detection 2 Level Select (Standard voltage during
                                            *   drop in voltage)                                                          */
                uint8_t             : 4;
                __IOM uint8_t LVD2E : 1;   /*!< [7..7] Voltage Detection 2 Enable                                         */
            } LVD2CMPCR_b;
        };
    };
    __IM uint8_t RESERVED45;

    union
    {
        __IOM uint8_t LVD1CR0;         /*!< (@ 0x0000041A) Voltage Monitor 1 Circuit Control Register 0               */

        struct
        {
            __IOM uint8_t RIE   : 1;   /*!< [0..0] Voltage Monitor Interrupt/Reset Enable                             */
            __IOM uint8_t DFDIS : 1;   /*!< [1..1] Voltage Monitor Digital Filter Disable Mode Select                 */
            __IOM uint8_t CMPE  : 1;   /*!< [2..2] Voltage Monitor Circuit Comparison Result Output Enable            */
            uint8_t             : 1;
            __IOM uint8_t FSAMP : 2;   /*!< [5..4] Sampling Clock Select                                              */
            __IOM uint8_t RI    : 1;   /*!< [6..6] Voltage Monitor Circuit Mode Select                                */
            __IOM uint8_t RN    : 1;   /*!< [7..7] Voltage Monitor Reset Negate Select                                */
        } LVD1CR0_b;
    };

    union
    {
        __IOM uint8_t LVD2CR0;         /*!< (@ 0x0000041B) Voltage Monitor 2 Circuit Control Register 0               */

        struct
        {
            __IOM uint8_t RIE   : 1;   /*!< [0..0] Voltage Monitor Interrupt/Reset Enable                             */
            __IOM uint8_t DFDIS : 1;   /*!< [1..1] Voltage Monitor Digital Filter Disable Mode Select                 */
            __IOM uint8_t CMPE  : 1;   /*!< [2..2] Voltage Monitor Circuit Comparison Result Output Enable            */
            uint8_t             : 1;
            __IOM uint8_t FSAMP : 2;   /*!< [5..4] Sampling Clock Select                                              */
            __IOM uint8_t RI    : 1;   /*!< [6..6] Voltage Monitor Circuit Mode Select                                */
            __IOM uint8_t RN    : 1;   /*!< [7..7] Voltage Monitor Reset Negate Select                                */
        } LVD2CR0_b;
    };
    __IM uint8_t RESERVED46;

    union
    {
        __IOM uint8_t VBATTMNSELR;        /*!< (@ 0x0000041D) Battery Backup Voltage Monitor Function Select
                                           *                  Register                                                   */

        struct
        {
            __IOM uint8_t VBATTMNSEL : 1; /*!< [0..0] VBATT Low Voltage Detect Function Select Bit                       */
            uint8_t                  : 7;
        } VBATTMNSELR_b;
    };

    union
    {
        __IM uint8_t VBATTMONR;        /*!< (@ 0x0000041E) Battery Backup Voltage Monitor Register                    */

        struct
        {
            __IM uint8_t VBATTMON : 1; /*!< [0..0] VBATT Voltage Monitor Bit                                          */
            uint8_t               : 7;
        } VBATTMONR_b;
    };

    union
    {
        __IOM uint8_t VBTCR1;           /*!< (@ 0x0000041F) VBATT Control Register1                                    */

        struct
        {
            __IOM uint8_t BPWSWSTP : 1; /*!< [0..0] Battery Power supply Switch Stop                                   */
            uint8_t                : 7;
        } VBTCR1_b;
    };
    __IM uint32_t RESERVED47[8];

    union
    {
        union
        {
            __IOM uint8_t DCDCCTL;         /*!< (@ 0x00000440) DCDC/LDO Control Register                                  */

            struct
            {
                __IOM uint8_t DCDCON  : 1; /*!< [0..0] LDO/DCDC on/off Control bit                                        */
                __IOM uint8_t OCPEN   : 1; /*!< [1..1] DCDC OCP Function Enable bit                                       */
                uint8_t               : 2;
                __IOM uint8_t STOPZA  : 1; /*!< [4..4] DCDC IO Buffer Power Control bit                                   */
                __IOM uint8_t LCBOOST : 1; /*!< [5..5] LDO LCBOOST Mode Control bit                                       */
                __IOM uint8_t FST     : 1; /*!< [6..6] DCDC Fast Startup                                                  */
                __IOM uint8_t PD      : 1; /*!< [7..7] DCDC VREF Generate Disable bit                                     */
            } DCDCCTL_b;
        };

        union
        {
            __IOM uint8_t LDOSCR;          /*!< (@ 0x00000440) LDO Stop Control Register                                  */

            struct
            {
                __IOM uint8_t LDOSTP0 : 1; /*!< [0..0] LDO0 Stop                                                          */
                __IOM uint8_t LDOSTP1 : 1; /*!< [1..1] LDO1 Stop                                                          */
                uint8_t               : 6;
            } LDOSCR_b;
        };
    };

    union
    {
        __IOM uint8_t VCCSEL;          /*!< (@ 0x00000441) Voltage Level Selection Control Register                   */

        struct
        {
            __IOM uint8_t VCCSEL : 2;  /*!< [1..0] DCDC Working Voltage Level Selection                               */
            uint8_t              : 6;
        } VCCSEL_b;
    };
    __IM uint16_t RESERVED48;

    union
    {
        __IOM uint8_t PL2LDOSCR;         /*!< (@ 0x00000444) PLL2-LDO Stop Control Register                             */

        struct
        {
            __IOM uint8_t PL2LDOSTP : 1; /*!< [0..0] LDO0 Stop                                                          */
            uint8_t                 : 7;
        } PL2LDOSCR_b;
    };
    __IM uint8_t  RESERVED49;
    __IM uint16_t RESERVED50;
    __IM uint32_t RESERVED51[14];

    union
    {
        __IOM uint8_t SOSCCR;          /*!< (@ 0x00000480) Sub-Clock Oscillator Control Register                      */

        struct
        {
            __IOM uint8_t SOSTP : 1;   /*!< [0..0] Sub-Clock Oscillator Stop                                          */
            uint8_t             : 7;
        } SOSCCR_b;
    };

    union
    {
        __IOM uint8_t SOMCR;           /*!< (@ 0x00000481) Sub Clock Oscillator Mode Control Register                 */

        struct
        {
            __IOM uint8_t SODRV : 2;   /*!< [1..0] Sub-Clock Oscillator Drive Capability Switching                    */
            uint8_t             : 6;
        } SOMCR_b;
    };
    __IM uint16_t RESERVED52;
    __IM uint32_t RESERVED53[3];

    union
    {
        __IOM uint8_t LOCOCR;          /*!< (@ 0x00000490) Low-Speed On-Chip Oscillator Control Register              */

        struct
        {
            __IOM uint8_t LCSTP : 1;   /*!< [0..0] LOCO Stop                                                          */
            uint8_t             : 7;
        } LOCOCR_b;
    };
    __IM uint8_t RESERVED54;

    union
    {
        __IOM uint8_t LOCOUTCR;         /*!< (@ 0x00000492) LOCO User Trimming Control Register                        */

        struct
        {
            __IOM uint8_t LOCOUTRM : 8; /*!< [7..0] LOCO User Trimming 1000_0000 : -128 1000_0001 : -127
                                         *   1000_0010 : -126 . . . 1111_1111 : -1 0000_0000 : Center
                                         *   Code 0000_0001 : +1 . . . 0111_1101 : +125 0111_1110 :
                                         +126 0111_1111 : +127These bits are added to original LOCO
                                         *   trimming bits                                                             */
        } LOCOUTCR_b;
    };
    __IM uint8_t  RESERVED55;
    __IM uint32_t RESERVED56[7];

    union
    {
        __IOM uint8_t VBTCR2;          /*!< (@ 0x000004B0) VBATT Control Register2                                    */

        struct
        {
            uint8_t                 : 4;
            __IOM uint8_t VBTLVDEN  : 1; /*!< [4..4] VBATT Pin Low Voltage Detect Enable Bit                            */
            uint8_t                 : 1;
            __IOM uint8_t VBTLVDLVL : 2; /*!< [7..6] VBATT Pin Voltage Low Voltage Detect Level Select Bit              */
        } VBTCR2_b;
    };

    union
    {
        __IOM uint8_t VBTSR;           /*!< (@ 0x000004B1) VBATT Status Register                                      */

        struct
        {
            __IOM uint8_t VBTRDF  : 1; /*!< [0..0] VBAT_R Reset Detect Flag                                           */
            __IOM uint8_t VBTBLDF : 1; /*!< [1..1] VBATT Battery Low voltage Detect Flag                              */
            uint8_t               : 2;
            __IM uint8_t VBTRVLD  : 1; /*!< [4..4] VBATT_R Valid                                                      */
            uint8_t               : 3;
        } VBTSR_b;
    };

    union
    {
        __IOM uint8_t VBTCMPCR;        /*!< (@ 0x000004B2) VBATT Comparator Control Register                          */

        struct
        {
            __IOM uint8_t VBTCMPE : 1; /*!< [0..0] VBATT pin low voltage detect circuit output enable                 */
            uint8_t               : 7;
        } VBTCMPCR_b;
    };
    __IM uint8_t RESERVED57;

    union
    {
        __IOM uint8_t VBTLVDICR;          /*!< (@ 0x000004B4) VBATT Pin Low Voltage Detect Interrupt Control
                                           *                  Register                                                   */

        struct
        {
            __IOM uint8_t VBTLVDIE   : 1; /*!< [0..0] VBATT Pin Low Voltage Detect Interrupt Enable bit                  */
            __IOM uint8_t VBTLVDISEL : 1; /*!< [1..1] Pin Low Voltage Detect Interrupt Select bit                        */
            uint8_t                  : 6;
        } VBTLVDICR_b;
    };
    __IM uint8_t RESERVED58;

    union
    {
        __IOM uint8_t VBTWCTLR;        /*!< (@ 0x000004B6) VBATT Wakeup function Control Register                     */

        struct
        {
            __IOM uint8_t VWEN : 1;    /*!< [0..0] VBATT wakeup enable                                                */
            uint8_t            : 7;
        } VBTWCTLR_b;
    };
    __IM uint8_t RESERVED59;

    union
    {
        __IOM uint8_t VBTWCH0OTSR;     /*!< (@ 0x000004B8) VBATT Wakeup I/O 0 Output Trigger Select Register          */

        struct
        {
            uint8_t                  : 1;
            __IOM uint8_t CH0VCH1TE  : 1; /*!< [1..1] VBATWIO0 Output VBATWIO1 Trigger Enable                            */
            __IOM uint8_t CH0VCH2TE  : 1; /*!< [2..2] VBATWIO0 Output VBATWIO2 Trigger Enable                            */
            __IOM uint8_t CH0VRTCTE  : 1; /*!< [3..3] VBATWIO0 Output RTC Periodic Signal Enable                         */
            __IOM uint8_t CH0VRTCATE : 1; /*!< [4..4] VBATWIO0 Output RTC Alarm Signal Enable                            */
            __IOM uint8_t CH0VAGTUTE : 1; /*!< [5..5] CH0 Output AGT(ch1) underflow Signal Enable                        */
            uint8_t                  : 2;
        } VBTWCH0OTSR_b;
    };

    union
    {
        __IOM uint8_t VBTWCH1OTSR;        /*!< (@ 0x000004B9) VBATT Wakeup I/O 1 Output Trigger Select Register          */

        struct
        {
            __IOM uint8_t CH1VCH0TE  : 1; /*!< [0..0] VBATWIO1 Output VBATWIO0 Trigger Enable                            */
            uint8_t                  : 1;
            __IOM uint8_t CH1VCH2TE  : 1; /*!< [2..2] VBATWIO1 Output VBATWIO2 Trigger Enable                            */
            __IOM uint8_t CH1VRTCTE  : 1; /*!< [3..3] VBATWIO1 Output RTC Periodic Signal Enable                         */
            __IOM uint8_t CH1VRTCATE : 1; /*!< [4..4] VBATWIO1 Output RTC Alarm Signal Enable                            */
            __IOM uint8_t CH1VAGTUTE : 1; /*!< [5..5] CH1 Output AGT(ch1) underflow Signal Enable                        */
            uint8_t                  : 2;
        } VBTWCH1OTSR_b;
    };

    union
    {
        __IOM uint8_t VBTWCH2OTSR;        /*!< (@ 0x000004BA) VBATT Wakeup I/O 2 Output Trigger Select Register          */

        struct
        {
            __IOM uint8_t CH2VCH0TE  : 1; /*!< [0..0] VBATWIO2 Output VBATWIO0 Trigger Enable                            */
            __IOM uint8_t CH2VCH1TE  : 1; /*!< [1..1] VBATWIO2 Output VBATWIO1 Trigger Enable                            */
            uint8_t                  : 1;
            __IOM uint8_t CH2VRTCTE  : 1; /*!< [3..3] VBATWIO2 Output RTC Periodic Signal Enable                         */
            __IOM uint8_t CH2VRTCATE : 1; /*!< [4..4] VBATWIO2 Output RTC Alarm Signal Enable                            */
            __IOM uint8_t CH2VAGTUTE : 1; /*!< [5..5] CH2 Output AGT(CH2) underflow Signal Enable                        */
            uint8_t                  : 2;
        } VBTWCH2OTSR_b;
    };

    union
    {
        __IOM uint8_t VBTICTLR;         /*!< (@ 0x000004BB) VBATT Input Control Register                               */

        struct
        {
            __IOM uint8_t VCH0INEN : 1; /*!< [0..0] RTCIC0 Input Enable                                                */
            __IOM uint8_t VCH1INEN : 1; /*!< [1..1] RTCIC1 Input Enable                                                */
            __IOM uint8_t VCH2INEN : 1; /*!< [2..2] RTCIC2 Input Enable                                                */
            uint8_t                : 5;
        } VBTICTLR_b;
    };

    union
    {
        __IOM uint8_t VBTOCTLR;          /*!< (@ 0x000004BC) VBATT Output Control Register                              */

        struct
        {
            __IOM uint8_t VCH0OEN   : 1; /*!< [0..0] VBATT Wakeup I/O 0 Output Enable                                   */
            __IOM uint8_t VCH1OEN   : 1; /*!< [1..1] VBATT Wakeup I/O 1 Output Enable                                   */
            __IOM uint8_t VCH2OEN   : 1; /*!< [2..2] VBATT Wakeup I/O 2 Output Enable                                   */
            __IOM uint8_t VOUT0LSEL : 1; /*!< [3..3] VBATT Wakeup I/O 0 Output Level Selection                          */
            __IOM uint8_t VCOU1LSEL : 1; /*!< [4..4] VBATT Wakeup I/O 1 Output Level Selection                          */
            __IOM uint8_t VOUT2LSEL : 1; /*!< [5..5] VBATT Wakeup I/O 2 Output Level Selection                          */
            uint8_t                 : 2;
        } VBTOCTLR_b;
    };

    union
    {
        __IOM uint8_t VBTWTER;         /*!< (@ 0x000004BD) VBATT Wakeup Trigger source Enable Register                */

        struct
        {
            __IOM uint8_t VCH0E  : 1;  /*!< [0..0] VBATWIO0 Pin Enable                                                */
            __IOM uint8_t VCH1E  : 1;  /*!< [1..1] VBATWIO1 Pin Enable                                                */
            __IOM uint8_t VCH2E  : 1;  /*!< [2..2] VBATWIO2 Pin Enable                                                */
            __IOM uint8_t VRTCIE : 1;  /*!< [3..3] RTC Periodic Signal Enable                                         */
            __IOM uint8_t VRTCAE : 1;  /*!< [4..4] RTC Alarm Signal Enable                                            */
            __IOM uint8_t VAGTUE : 1;  /*!< [5..5] AGT(ch1) underflow Signal Enable                                   */
            uint8_t              : 2;
        } VBTWTER_b;
    };

    union
    {
        __IOM uint8_t VBTWEGR;         /*!< (@ 0x000004BE) VBATT Wakeup Trigger source Edge Register                  */

        struct
        {
            __IOM uint8_t VCH0EG : 1;  /*!< [0..0] VBATWIO0 Wakeup Trigger Source Edge Select                         */
            __IOM uint8_t VCH1EG : 1;  /*!< [1..1] VBATWIO1 Wakeup Trigger Source Edge Select                         */
            __IOM uint8_t VCH2EG : 1;  /*!< [2..2] VBATWIO2 Wakeup Trigger Source Edge Select                         */
            uint8_t              : 5;
        } VBTWEGR_b;
    };

    union
    {
        __IOM uint8_t VBTWFR;          /*!< (@ 0x000004BF) VBATT Wakeup trigger source Flag Register                  */

        struct
        {
            __IOM uint8_t VCH0F  : 1;  /*!< [0..0] VBATWIO0 Wakeup Trigger Flag                                       */
            __IOM uint8_t VCH1F  : 1;  /*!< [1..1] VBATWIO1 Wakeup Trigger Flag                                       */
            __IOM uint8_t VCH2F  : 1;  /*!< [2..2] VBATWIO2 Wakeup Trigger Flag                                       */
            __IOM uint8_t VRTCIF : 1;  /*!< [3..3] VBATT RTC-Interval Wakeup Trigger Flag                             */
            __IOM uint8_t VRTCAF : 1;  /*!< [4..4] VBATT RTC-Alarm Wakeup Trigger Flag                                */
            __IOM uint8_t VAGTUF : 1;  /*!< [5..5] AGT(ch1) underflow VBATT Wakeup Trigger Flag                       */
            uint8_t              : 2;
        } VBTWFR_b;
    };

    union
    {
        __IOM uint8_t VBTBER;          /*!< (@ 0x000004C0) VBATT Backup Enable Register                               */

        struct
        {
            uint8_t            : 3;
            __IOM uint8_t VBAE : 1;    /*!< [3..3] VBATT backup register access enable bit                            */
            uint8_t            : 4;
        } VBTBER_b;
    };
    __IM uint8_t  RESERVED60;
    __IM uint16_t RESERVED61;
    __IM uint32_t RESERVED62[15];

    union
    {
        __IOM uint8_t VBTBKR[512];     /*!< (@ 0x00000500) VBATT Backup Register [0..511]                             */

        struct
        {
            __IOM uint8_t VBTBKR : 8;  /*!< [7..0] VBTBKR is a 512-byte readable/writable register to store
                                        *   data powered by VBATT.The value of this register is retained
                                        *   even when VCC is not powered but VBATT is powered.VBTBKR
                                        *   is initialized by VBATT selected voltage power-on-reset.                  */
        } VBTBKR_b[512];
    };
} R_SYSTEM_Type;                       /*!< Size = 1792 (0x700)                                                       */

/* =========================================================================================================================== */
/* ================                                          R_TRNG                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief True Random Number Generator (R_TRNG)
 */

typedef struct                         /*!< (@ 0x40162000) R_TRNG Structure                                           */
{
    union
    {
        __IM uint8_t TRNGSDR;          /*!< (@ 0x00000000) TRNG SEED Data Register                                    */

        struct
        {
            __IM uint8_t SDATA : 8;    /*!< [7..0] When RDRDY bit is 1, these bits hold the generated SEED.
                                        *   When RDRDY bit is 0, these bits are read as 00h.The SEED
                                        *   is generated as 32-bit data. When TRNGSDR is read 4 times
                                        *   while RDRDY = 1, SEED reading is completed and RDRDY bit
                                        *   changes to 0                                                              */
        } TRNGSDR_b;
    };
    __IM uint8_t RESERVED;

    union
    {
        __IOM uint8_t TRNGSCR0;        /*!< (@ 0x00000002) TRNG SEED Command Register 0                               */

        struct
        {
            uint8_t               : 2;
            __OM uint8_t  SGSTART : 1; /*!< [2..2] SEED Generation Start                                              */
            __IOM uint8_t SGCEN   : 1; /*!< [3..3] SEED Generation Circuit Enable                                     */
            uint8_t               : 3;
            __IM uint8_t RDRDY    : 1; /*!< [7..7] When SEED geenration is completed, this bit changes to
                                        *   0                                                                         */
        } TRNGSCR0_b;
    };

    union
    {
        __IOM uint8_t TRNGSCR1;        /*!< (@ 0x00000003) TRNG SEED Command Register 1                               */

        struct
        {
            __IOM uint8_t INTEN : 1;   /*!< [0..0] TRNG Interrupt Enable                                              */
            uint8_t             : 7;
        } TRNGSCR1_b;
    };
} R_TRNG_Type;                         /*!< Size = 4 (0x4)                                                            */

/* =========================================================================================================================== */
/* ================                                         R_TSN_CAL                                         ================ */
/* =========================================================================================================================== */

/**
 * @brief Temperature Sensor (R_TSN_CAL)
 */

typedef struct                         /*!< (@ 0x407FB17C) R_TSN_CAL Structure                                        */
{
    union
    {
        __IM uint32_t TSCDR;           /*!< (@ 0x00000000) Temperature Sensor 32 bit Calibration Data Register        */

        struct
        {
            __IM uint32_t TSCDR : 32;  /*!< [31..0] The 32 bit TSCDR register stores temperature sensor
                                        *   calibration converted value.                                              */
        } TSCDR_b;
    };
} R_TSN_CAL_Type;                      /*!< Size = 4 (0x4)                                                            */

/* =========================================================================================================================== */
/* ================                                        R_TSN_CTRL                                         ================ */
/* =========================================================================================================================== */

/**
 * @brief Temperature Sensor (R_TSN_CTRL)
 */

typedef struct                         /*!< (@ 0x400F3000) R_TSN_CTRL Structure                                       */
{
    union
    {
        __IOM uint8_t TSCR;            /*!< (@ 0x00000000) Temperature Sensor Control Register                        */

        struct
        {
            uint8_t            : 4;
            __IOM uint8_t TSOE : 1;    /*!< [4..4] Temperature Sensor Enable                                          */
            uint8_t            : 2;
            __IOM uint8_t TSEN : 1;    /*!< [7..7] Temperature Sensor Output Enable                                   */
        } TSCR_b;
    };
} R_TSN_CTRL_Type;                     /*!< Size = 1 (0x1)                                                            */

/* =========================================================================================================================== */
/* ================                                         R_USB_FS0                                         ================ */
/* =========================================================================================================================== */

/**
 * @brief USB 2.0 Module (R_USB_FS0)
 */

typedef struct                         /*!< (@ 0x40090000) R_USB_FS0 Structure                                        */
{
    union
    {
        __IOM uint16_t SYSCFG;         /*!< (@ 0x00000000) System Configuration Control Register                      */

        struct
        {
            __IOM uint16_t USBE  : 1;  /*!< [0..0] USB Operation Enable                                               */
            uint16_t             : 2;
            __IOM uint16_t DMRPU : 1;  /*!< [3..3] D- Line Resistor Control                                           */
            __IOM uint16_t DPRPU : 1;  /*!< [4..4] D+ Line Resistor Control                                           */
            __IOM uint16_t DRPD  : 1;  /*!< [5..5] D+/D- Line Resistor Control                                        */
            __IOM uint16_t DCFM  : 1;  /*!< [6..6] Controller Function Select                                         */
            uint16_t             : 1;
            __IOM uint16_t CNEN  : 1;  /*!< [8..8] CNEN Single End Receiver Enable                                    */
            uint16_t             : 1;
            __IOM uint16_t SCKE  : 1;  /*!< [10..10] USB Clock Enable                                                 */
            uint16_t             : 5;
        } SYSCFG_b;
    };

    union
    {
        __IOM uint16_t BUSWAIT;        /*!< (@ 0x00000002) CPU Bus Wait Register                                      */

        struct
        {
            __IOM uint16_t BWAIT : 4;  /*!< [3..0] CPU Bus Access Wait Specification BWAIT waits (BWAIT+2
                                        *   access cycles)                                                            */
            uint16_t : 12;
        } BUSWAIT_b;
    };

    union
    {
        __IM uint16_t SYSSTS0;         /*!< (@ 0x00000004) System Configuration Status Register 0                     */

        struct
        {
            __IM uint16_t LNST  : 2;   /*!< [1..0] USB Data Line Status Monitor                                       */
            __IM uint16_t IDMON : 1;   /*!< [2..2] External ID0 Input Pin Monitor                                     */
            uint16_t            : 2;
            __IM uint16_t SOFEA : 1;   /*!< [5..5] SOF Active Monitor While Host Controller Function is
                                        *   Selected.                                                                 */
            __IM uint16_t HTACT  : 1;  /*!< [6..6] USB Host Sequencer Status Monitor                                  */
            uint16_t             : 7;
            __IM uint16_t OVCMON : 2;  /*!< [15..14] External USB0_OVRCURA/ USB0_OVRCURB Input Pin MonitorThe
                                        *   OCVMON[1] bit indicates the status of the USBHS_OVRCURA
                                        *   pin. The OCVMON[0] bit indicates the status of the USBHS_OVRCURB
                                        *   pin.                                                                      */
        } SYSSTS0_b;
    };

    union
    {
        __IM uint16_t PLLSTA;          /*!< (@ 0x00000006) PLL Status Register                                        */

        struct
        {
            __IM uint16_t PLLLOCK : 1; /*!< [0..0] PLL Lock Flag                                                      */
            uint16_t              : 15;
        } PLLSTA_b;
    };

    union
    {
        __IOM uint16_t DVSTCTR0;        /*!< (@ 0x00000008) Device State Control Register 0                            */

        struct
        {
            __IM uint16_t RHST     : 3; /*!< [2..0] USB Bus Reset Status                                               */
            uint16_t               : 1;
            __IOM uint16_t UACT    : 1; /*!< [4..4] USB Bus Enable                                                     */
            __IOM uint16_t RESUME  : 1; /*!< [5..5] Resume Output                                                      */
            __IOM uint16_t USBRST  : 1; /*!< [6..6] USB Bus Reset Output                                               */
            __IOM uint16_t RWUPE   : 1; /*!< [7..7] Wakeup Detection Enable                                            */
            __IOM uint16_t WKUP    : 1; /*!< [8..8] Wakeup Output                                                      */
            __IOM uint16_t VBUSEN  : 1; /*!< [9..9] USB_VBUSEN Output Pin Control                                      */
            __IOM uint16_t EXICEN  : 1; /*!< [10..10] USB_EXICEN Output Pin Control                                    */
            __IOM uint16_t HNPBTOA : 1; /*!< [11..11] Host Negotiation Protocol (HNP) Control This bit is
                                         *   used when switching from device B to device A while in
                                         *   OTG mode. If the HNPBTOA bit is 1, the internal function
                                         *   control keeps the suspended state until the HNP processing
                                         *   ends even though SYSCFG.DPRPU = 0 or SYSCFG.DCFM = 1 is
                                         *   set.                                                                      */
            uint16_t : 4;
        } DVSTCTR0_b;
    };
    __IM uint16_t RESERVED;

    union
    {
        __IOM uint16_t TESTMODE;       /*!< (@ 0x0000000C) USB Test Mode Register                                     */

        struct
        {
            __IOM uint16_t UTST : 4;   /*!< [3..0] Test Mode                                                          */
            uint16_t            : 12;
        } TESTMODE_b;
    };
    __IM uint16_t RESERVED1;
    __IM uint32_t RESERVED2;

    union
    {
        __IOM uint32_t CFIFO;          /*!< (@ 0x00000014) CFIFO Port Register                                        */

        struct
        {
            union
            {
                __IOM uint16_t CFIFOL;  /*!< (@ 0x00000014) CFIFO Port Register L                                      */
                __IOM uint8_t  CFIFOLL; /*!< (@ 0x00000014) CFIFO Port Register LL                                     */
            };

            union
            {
                __IOM uint16_t CFIFOH; /*!< (@ 0x00000016) CFIFO Port Register H                                      */

                struct
                {
                    __IM uint8_t  RESERVED3;
                    __IOM uint8_t CFIFOHH; /*!< (@ 0x00000017) CFIFO Port Register HH                                     */
                };
            };
        };
    };

    union
    {
        __IOM uint32_t D0FIFO;         /*!< (@ 0x00000018) D0FIFO Port Register                                       */

        struct
        {
            union
            {
                __IOM uint16_t D0FIFOL;  /*!< (@ 0x00000018) D0FIFO Port Register L                                     */
                __IOM uint8_t  D0FIFOLL; /*!< (@ 0x00000018) D0FIFO Port Register LL                                    */
            };

            union
            {
                __IOM uint16_t D0FIFOH; /*!< (@ 0x0000001A) D0FIFO Port Register H                                     */

                struct
                {
                    __IM uint8_t  RESERVED4;
                    __IOM uint8_t D0FIFOHH; /*!< (@ 0x0000001B) D0FIFO Port Register HH                                    */
                };
            };
        };
    };

    union
    {
        __IOM uint32_t D1FIFO;         /*!< (@ 0x0000001C) D1FIFO Port Register                                       */

        struct
        {
            union
            {
                __IOM uint16_t D1FIFOL;  /*!< (@ 0x0000001C) D1FIFO Port Register L                                     */
                __IOM uint8_t  D1FIFOLL; /*!< (@ 0x0000001C) D1FIFO Port Register LL                                    */
            };

            union
            {
                __IOM uint16_t D1FIFOH; /*!< (@ 0x0000001E) D1FIFO Port Register H                                     */

                struct
                {
                    __IM uint8_t  RESERVED5;
                    __IOM uint8_t D1FIFOHH; /*!< (@ 0x0000001F) D1FIFO Port Register HH                                    */
                };
            };
        };
    };

    union
    {
        __IOM uint16_t CFIFOSEL;        /*!< (@ 0x00000020) CFIFO Port Select Register                                 */

        struct
        {
            __IOM uint16_t CURPIPE : 4; /*!< [3..0] CFIFO Port Access Pipe Specification                               */
            uint16_t               : 1;
            __IOM uint16_t ISEL    : 1; /*!< [5..5] CFIFO Port Access Direction When DCP is Selected                   */
            uint16_t               : 2;
            __IOM uint16_t BIGEND  : 1; /*!< [8..8] CFIFO Port Endian Control                                          */
            uint16_t               : 1;
            __IOM uint16_t MBW     : 2; /*!< [11..10] CFIFO Port Access Bit Width                                      */
            uint16_t               : 2;
            __IOM uint16_t REW     : 1; /*!< [14..14] Buffer Pointer Rewind                                            */
            __IOM uint16_t RCNT    : 1; /*!< [15..15] Read Count Mode                                                  */
        } CFIFOSEL_b;
    };

    union
    {
        __IOM uint16_t CFIFOCTR;       /*!< (@ 0x00000022) CFIFO Port Control Register                                */

        struct
        {
            __IM uint16_t DTLN : 12;   /*!< [11..0] Receive Data LengthIndicates the length of the receive
                                        *   data.                                                                     */
            uint16_t            : 1;
            __IM uint16_t  FRDY : 1;   /*!< [13..13] FIFO Port Ready                                                  */
            __IOM uint16_t BCLR : 1;   /*!< [14..14] CPU Buffer ClearNote: Only 0 can be read.                        */
            __IOM uint16_t BVAL : 1;   /*!< [15..15] Buffer Memory Valid Flag                                         */
        } CFIFOCTR_b;
    };
    __IM uint32_t RESERVED6;

    union
    {
        __IOM uint16_t D0FIFOSEL;       /*!< (@ 0x00000028) D0FIFO Port Select Register                                */

        struct
        {
            __IOM uint16_t CURPIPE : 4; /*!< [3..0] FIFO Port Access Pipe Specification                                */
            uint16_t               : 4;
            __IOM uint16_t BIGEND  : 1; /*!< [8..8] FIFO Port Endian Control                                           */
            uint16_t               : 1;
            __IOM uint16_t MBW     : 2; /*!< [11..10] FIFO Port Access Bit Width                                       */
            __IOM uint16_t DREQE   : 1; /*!< [12..12] DMA/DTC Transfer Request Enable                                  */
            __IOM uint16_t DCLRM   : 1; /*!< [13..13] Auto Buffer Memory Clear Mode Accessed after Specified
                                         *   Pipe Data is Read                                                         */
            __IOM uint16_t REW  : 1;    /*!< [14..14] Buffer Pointer RewindNote: Only 0 can be read.                   */
            __IOM uint16_t RCNT : 1;    /*!< [15..15] Read Count Mode                                                  */
        } D0FIFOSEL_b;
    };

    union
    {
        __IOM uint16_t D0FIFOCTR;      /*!< (@ 0x0000002A) D0FIFO Port Control Register                               */

        struct
        {
            __IM uint16_t DTLN : 12;   /*!< [11..0] Receive Data LengthIndicates the length of the receive
                                        *   data.                                                                     */
            uint16_t            : 1;
            __IM uint16_t  FRDY : 1;   /*!< [13..13] FIFO Port Ready                                                  */
            __IOM uint16_t BCLR : 1;   /*!< [14..14] CPU Buffer ClearNote: Only 0 can be read.                        */
            __IOM uint16_t BVAL : 1;   /*!< [15..15] Buffer Memory Valid Flag                                         */
        } D0FIFOCTR_b;
    };

    union
    {
        __IOM uint16_t D1FIFOSEL;       /*!< (@ 0x0000002C) D1FIFO Port Select Register                                */

        struct
        {
            __IOM uint16_t CURPIPE : 4; /*!< [3..0] FIFO Port Access Pipe Specification                                */
            uint16_t               : 4;
            __IOM uint16_t BIGEND  : 1; /*!< [8..8] FIFO Port Endian Control                                           */
            uint16_t               : 1;
            __IOM uint16_t MBW     : 2; /*!< [11..10] FIFO Port Access Bit Width                                       */
            __IOM uint16_t DREQE   : 1; /*!< [12..12] DMA/DTC Transfer Request Enable                                  */
            __IOM uint16_t DCLRM   : 1; /*!< [13..13] Auto Buffer Memory Clear Mode Accessed after Specified
                                         *   Pipe Data is Read                                                         */
            __IOM uint16_t REW  : 1;    /*!< [14..14] Buffer Pointer Rewind                                            */
            __IOM uint16_t RCNT : 1;    /*!< [15..15] Read Count Mode                                                  */
        } D1FIFOSEL_b;
    };

    union
    {
        __IOM uint16_t D1FIFOCTR;      /*!< (@ 0x0000002E) D1FIFO Port Control Register                               */

        struct
        {
            __IM uint16_t DTLN : 12;   /*!< [11..0] Receive Data LengthIndicates the length of the receive
                                        *   data.                                                                     */
            uint16_t            : 1;
            __IM uint16_t  FRDY : 1;   /*!< [13..13] FIFO Port Ready                                                  */
            __IOM uint16_t BCLR : 1;   /*!< [14..14] CPU Buffer ClearNote: Only 0 can be read.                        */
            __IOM uint16_t BVAL : 1;   /*!< [15..15] Buffer Memory Valid Flag                                         */
        } D1FIFOCTR_b;
    };

    union
    {
        __IOM uint16_t INTENB0;        /*!< (@ 0x00000030) Interrupt Enable Register 0                                */

        struct
        {
            uint16_t             : 8;
            __IOM uint16_t BRDYE : 1;  /*!< [8..8] Buffer Ready Interrupt Enable                                      */
            __IOM uint16_t NRDYE : 1;  /*!< [9..9] Buffer Not Ready Response Interrupt Enable                         */
            __IOM uint16_t BEMPE : 1;  /*!< [10..10] Buffer Empty Interrupt Enable                                    */
            __IOM uint16_t CTRE  : 1;  /*!< [11..11] Control Transfer Stage Transition Interrupt Enable               */
            __IOM uint16_t DVSE  : 1;  /*!< [12..12] Device State Transition Interrupt Enable                         */
            __IOM uint16_t SOFE  : 1;  /*!< [13..13] Frame Number Update Interrupt Enable                             */
            __IOM uint16_t RSME  : 1;  /*!< [14..14] Resume Interrupt Enable                                          */
            __IOM uint16_t VBSE  : 1;  /*!< [15..15] VBUS Interrupt Enable                                            */
        } INTENB0_b;
    };

    union
    {
        __IOM uint16_t INTENB1;            /*!< (@ 0x00000032) Interrupt Enable Register 1                                */

        struct
        {
            __IOM uint16_t PDDETINTE0 : 1; /*!< [0..0] PDDETINT0 Detection Interrupt Enable                               */
            uint16_t                  : 3;
            __IOM uint16_t SACKE      : 1; /*!< [4..4] Setup Transaction Normal Response Interrupt Enable                 */
            __IOM uint16_t SIGNE      : 1; /*!< [5..5] Setup Transaction Error Interrupt Enable                           */
            __IOM uint16_t EOFERRE    : 1; /*!< [6..6] EOF Error Detection Interrupt Enable                               */
            uint16_t                  : 4;
            __IOM uint16_t ATTCHE     : 1; /*!< [11..11] Connection Detection Interrupt Enable                            */
            __IOM uint16_t DTCHE      : 1; /*!< [12..12] Disconnection Detection Interrupt Enable                         */
            uint16_t                  : 1;
            __IOM uint16_t BCHGE      : 1; /*!< [14..14] USB Bus Change Interrupt Enable                                  */
            __IOM uint16_t OVRCRE     : 1; /*!< [15..15] Overcurrent Input Change Interrupt Enable                        */
        } INTENB1_b;
    };
    __IM uint16_t RESERVED7;

    union
    {
        __IOM uint16_t BRDYENB;            /*!< (@ 0x00000036) BRDY Interrupt Enable Register                             */

        struct
        {
            __IOM uint16_t PIPE0BRDYE : 1; /*!< [0..0] BRDY Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE1BRDYE : 1; /*!< [1..1] BRDY Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE2BRDYE : 1; /*!< [2..2] BRDY Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE3BRDYE : 1; /*!< [3..3] BRDY Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE4BRDYE : 1; /*!< [4..4] BRDY Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE5BRDYE : 1; /*!< [5..5] BRDY Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE6BRDYE : 1; /*!< [6..6] BRDY Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE7BRDYE : 1; /*!< [7..7] BRDY Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE8BRDYE : 1; /*!< [8..8] BRDY Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE9BRDYE : 1; /*!< [9..9] BRDY Interrupt Enable for PIPE                                     */
            uint16_t                  : 6;
        } BRDYENB_b;
    };

    union
    {
        __IOM uint16_t NRDYENB;            /*!< (@ 0x00000038) NRDY Interrupt Enable Register                             */

        struct
        {
            __IOM uint16_t PIPE0NRDYE : 1; /*!< [0..0] NRDY Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE1NRDYE : 1; /*!< [1..1] NRDY Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE2NRDYE : 1; /*!< [2..2] NRDY Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE3NRDYE : 1; /*!< [3..3] NRDY Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE4NRDYE : 1; /*!< [4..4] NRDY Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE5NRDYE : 1; /*!< [5..5] NRDY Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE6NRDYE : 1; /*!< [6..6] NRDY Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE7NRDYE : 1; /*!< [7..7] NRDY Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE8NRDYE : 1; /*!< [8..8] NRDY Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE9NRDYE : 1; /*!< [9..9] NRDY Interrupt Enable for PIPE                                     */
            uint16_t                  : 6;
        } NRDYENB_b;
    };

    union
    {
        __IOM uint16_t BEMPENB;            /*!< (@ 0x0000003A) BEMP Interrupt Enable Register                             */

        struct
        {
            __IOM uint16_t PIPE0BEMPE : 1; /*!< [0..0] BEMP Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE1BEMPE : 1; /*!< [1..1] BEMP Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE2BEMPE : 1; /*!< [2..2] BEMP Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE3BEMPE : 1; /*!< [3..3] BEMP Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE4BEMPE : 1; /*!< [4..4] BEMP Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE5BEMPE : 1; /*!< [5..5] BEMP Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE6BEMPE : 1; /*!< [6..6] BEMP Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE7BEMPE : 1; /*!< [7..7] BEMP Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE8BEMPE : 1; /*!< [8..8] BEMP Interrupt Enable for PIPE                                     */
            __IOM uint16_t PIPE9BEMPE : 1; /*!< [9..9] BEMP Interrupt Enable for PIPE                                     */
            uint16_t                  : 6;
        } BEMPENB_b;
    };

    union
    {
        __IOM uint16_t SOFCFG;         /*!< (@ 0x0000003C) SOF Output Configuration Register                          */

        struct
        {
            uint16_t                : 4;
            __IM uint16_t  EDGESTS  : 1; /*!< [4..4] Edge Interrupt Output Status Monitor                               */
            __IOM uint16_t INTL     : 1; /*!< [5..5] Interrupt Output Sense Select                                      */
            __IOM uint16_t BRDYM    : 1; /*!< [6..6] BRDY Interrupt Status Clear Timing                                 */
            uint16_t                : 1;
            __IOM uint16_t TRNENSEL : 1; /*!< [8..8] Transaction-Enabled Time Select                                    */
            uint16_t                : 7;
        } SOFCFG_b;
    };

    union
    {
        __IOM uint16_t PHYSET;           /*!< (@ 0x0000003E) PHY Setting Register                                       */

        struct
        {
            __IOM uint16_t DIRPD    : 1; /*!< [0..0] Power-Down Control                                                 */
            __IOM uint16_t PLLRESET : 1; /*!< [1..1] PLL Reset Control                                                  */
            uint16_t                : 1;
            __IOM uint16_t CDPEN    : 1; /*!< [3..3] Charging Downstream Port Enable                                    */
            __IOM uint16_t CLKSEL   : 2; /*!< [5..4] Input System Clock Frequency                                       */
            uint16_t                : 2;
            __IOM uint16_t REPSEL   : 2; /*!< [9..8] Terminating Resistance Adjustment Cycle                            */
            uint16_t                : 1;
            __IOM uint16_t REPSTART : 1; /*!< [11..11] Forcibly Start Terminating Resistance Adjustment                 */
            uint16_t                : 3;
            __IOM uint16_t HSEB     : 1; /*!< [15..15] CL-Only Mode                                                     */
        } PHYSET_b;
    };

    union
    {
        __IOM uint16_t INTSTS0;        /*!< (@ 0x00000040) Interrupt Status Register 0                                */

        struct
        {
            __IM uint16_t  CTSQ  : 3;  /*!< [2..0] Control Transfer Stage                                             */
            __IOM uint16_t VALID : 1;  /*!< [3..3] USB Request Reception                                              */
            __IM uint16_t  DVSQ  : 3;  /*!< [6..4] Device State                                                       */
            __IM uint16_t  VBSTS : 1;  /*!< [7..7] VBUS Input Status                                                  */
            __IM uint16_t  BRDY  : 1;  /*!< [8..8] Buffer Ready Interrupt Status                                      */
            __IM uint16_t  NRDY  : 1;  /*!< [9..9] Buffer Not Ready Interrupt Status                                  */
            __IM uint16_t  BEMP  : 1;  /*!< [10..10] Buffer Empty Interrupt Status                                    */
            __IOM uint16_t CTRT  : 1;  /*!< [11..11] Control Transfer Stage Transition Interrupt Status               */
            __IOM uint16_t DVST  : 1;  /*!< [12..12] Device State Transition Interrupt Status                         */
            __IOM uint16_t SOFR  : 1;  /*!< [13..13] Frame Number Refresh Interrupt Status                            */
            __IOM uint16_t RESM  : 1;  /*!< [14..14] Resume Interrupt Status                                          */
            __IOM uint16_t VBINT : 1;  /*!< [15..15] VBUS Interrupt Status                                            */
        } INTSTS0_b;
    };

    union
    {
        __IOM uint16_t INTSTS1;           /*!< (@ 0x00000042) Interrupt Status Register 1                                */

        struct
        {
            __IOM uint16_t PDDETINT0 : 1; /*!< [0..0] PDDET0 Detection Interrupt Status                                  */
            uint16_t                 : 3;
            __IOM uint16_t SACK      : 1; /*!< [4..4] Setup Transaction Normal Response Interrupt Status                 */
            __IOM uint16_t SIGN      : 1; /*!< [5..5] Setup Transaction Error Interrupt Status                           */
            __IOM uint16_t EOFERR    : 1; /*!< [6..6] EOF Error Detection Interrupt Status                               */
            uint16_t                 : 1;
            __IOM uint16_t LPMEND    : 1; /*!< [8..8] LPM Transaction End Interrupt Status                               */
            __IOM uint16_t L1RSMEND  : 1; /*!< [9..9] L1 Resume End Interrupt Status                                     */
            uint16_t                 : 1;
            __IOM uint16_t ATTCH     : 1; /*!< [11..11] ATTCH Interrupt Status                                           */
            __IOM uint16_t DTCH      : 1; /*!< [12..12] USB Disconnection Detection Interrupt Status                     */
            uint16_t                 : 1;
            __IOM uint16_t BCHG      : 1; /*!< [14..14] USB Bus Change Interrupt Status                                  */
            __IOM uint16_t OVRCR     : 1; /*!< [15..15] Overcurrent Input Change Interrupt Status                        */
        } INTSTS1_b;
    };
    __IM uint16_t RESERVED8;

    union
    {
        __IOM uint16_t BRDYSTS;           /*!< (@ 0x00000046) BRDY Interrupt Status Register                             */

        struct
        {
            __IOM uint16_t PIPE0BRDY : 1; /*!< [0..0] BRDY Interrupt Status for PIPE                                     */
            __IOM uint16_t PIPE1BRDY : 1; /*!< [1..1] BRDY Interrupt Status for PIPE                                     */
            __IOM uint16_t PIPE2BRDY : 1; /*!< [2..2] BRDY Interrupt Status for PIPE                                     */
            __IOM uint16_t PIPE3BRDY : 1; /*!< [3..3] BRDY Interrupt Status for PIPE                                     */
            __IOM uint16_t PIPE4BRDY : 1; /*!< [4..4] BRDY Interrupt Status for PIPE                                     */
            __IOM uint16_t PIPE5BRDY : 1; /*!< [5..5] BRDY Interrupt Status for PIPE                                     */
            __IOM uint16_t PIPE6BRDY : 1; /*!< [6..6] BRDY Interrupt Status for PIPE                                     */
            __IOM uint16_t PIPE7BRDY : 1; /*!< [7..7] BRDY Interrupt Status for PIPE                                     */
            __IOM uint16_t PIPE8BRDY : 1; /*!< [8..8] BRDY Interrupt Status for PIPE                                     */
            __IOM uint16_t PIPE9BRDY : 1; /*!< [9..9] BRDY Interrupt Status for PIPE                                     */
            uint16_t                 : 6;
        } BRDYSTS_b;
    };

    union
    {
        __IOM uint16_t NRDYSTS;           /*!< (@ 0x00000048) NRDY Interrupt Status Register                             */

        struct
        {
            __IOM uint16_t PIPE0NRDY : 1; /*!< [0..0] NRDY Interrupt Status for PIPE                                     */
            __IOM uint16_t PIPE1NRDY : 1; /*!< [1..1] NRDY Interrupt Status for PIPE                                     */
            __IOM uint16_t PIPE2NRDY : 1; /*!< [2..2] NRDY Interrupt Status for PIPE                                     */
            __IOM uint16_t PIPE3NRDY : 1; /*!< [3..3] NRDY Interrupt Status for PIPE                                     */
            __IOM uint16_t PIPE4NRDY : 1; /*!< [4..4] NRDY Interrupt Status for PIPE                                     */
            __IOM uint16_t PIPE5NRDY : 1; /*!< [5..5] NRDY Interrupt Status for PIPE                                     */
            __IOM uint16_t PIPE6NRDY : 1; /*!< [6..6] NRDY Interrupt Status for PIPE                                     */
            __IOM uint16_t PIPE7NRDY : 1; /*!< [7..7] NRDY Interrupt Status for PIPE                                     */
            __IOM uint16_t PIPE8NRDY : 1; /*!< [8..8] NRDY Interrupt Status for PIPE                                     */
            __IOM uint16_t PIPE9NRDY : 1; /*!< [9..9] NRDY Interrupt Status for PIPE                                     */
            uint16_t                 : 6;
        } NRDYSTS_b;
    };

    union
    {
        __IOM uint16_t BEMPSTS;           /*!< (@ 0x0000004A) BEMP Interrupt Status Register                             */

        struct
        {
            __IOM uint16_t PIPE0BEMP : 1; /*!< [0..0] BEMP Interrupt Status for PIPE                                     */
            __IOM uint16_t PIPE1BEMP : 1; /*!< [1..1] BEMP Interrupt Status for PIPE                                     */
            __IOM uint16_t PIPE2BEMP : 1; /*!< [2..2] BEMP Interrupt Status for PIPE                                     */
            __IOM uint16_t PIPE3BEMP : 1; /*!< [3..3] BEMP Interrupt Status for PIPE                                     */
            __IOM uint16_t PIPE4BEMP : 1; /*!< [4..4] BEMP Interrupt Status for PIPE                                     */
            __IOM uint16_t PIPE5BEMP : 1; /*!< [5..5] BEMP Interrupt Status for PIPE                                     */
            __IOM uint16_t PIPE6BEMP : 1; /*!< [6..6] BEMP Interrupt Status for PIPE                                     */
            __IOM uint16_t PIPE7BEMP : 1; /*!< [7..7] BEMP Interrupt Status for PIPE                                     */
            __IOM uint16_t PIPE8BEMP : 1; /*!< [8..8] BEMP Interrupt Status for PIPE                                     */
            __IOM uint16_t PIPE9BEMP : 1; /*!< [9..9] BEMP Interrupt Status for PIPE                                     */
            uint16_t                 : 6;
        } BEMPSTS_b;
    };

    union
    {
        __IOM uint16_t FRMNUM;         /*!< (@ 0x0000004C) Frame Number Register                                      */

        struct
        {
            __IM uint16_t FRNM  : 11;  /*!< [10..0] Frame NumberLatest frame number                                   */
            uint16_t            : 3;
            __IOM uint16_t CRCE : 1;   /*!< [14..14] Receive Data Error                                               */
            __IOM uint16_t OVRN : 1;   /*!< [15..15] Overrun/Underrun Detection Status                                */
        } FRMNUM_b;
    };

    union
    {
        __IOM uint16_t UFRMNUM;        /*!< (@ 0x0000004E) uFrame Number Register                                     */

        struct
        {
            __IM uint16_t UFRNM  : 3;  /*!< [2..0] MicroframeIndicate the microframe number.                          */
            uint16_t             : 12;
            __IOM uint16_t DVCHG : 1;  /*!< [15..15] Device State Change                                              */
        } UFRMNUM_b;
    };

    union
    {
        __IOM uint16_t USBADDR;           /*!< (@ 0x00000050) USB Address Register                                       */

        struct
        {
            __IM uint16_t USBADDR : 7;    /*!< [6..0] USB Address In device controller mode, these flags indicate
                                           *   the USB address assigned by the host when the USBHS processed
                                           *   the SET_ADDRESS request successfully.                                     */
            uint16_t                 : 1;
            __IOM uint16_t STSRECOV0 : 3; /*!< [10..8] Status Recovery                                                   */
            uint16_t                 : 5;
        } USBADDR_b;
    };
    __IM uint16_t RESERVED9;

    union
    {
        __IOM uint16_t USBREQ;                /*!< (@ 0x00000054) USB Request Type Register                                  */

        struct
        {
            __IOM uint16_t BMREQUESTTYPE : 8; /*!< [7..0] Request TypeThese bits store the USB request bmRequestType
                                               *   value.                                                                    */
            __IOM uint16_t BREQUEST : 8;      /*!< [15..8] RequestThese bits store the USB request bRequest value.           */
        } USBREQ_b;
    };

    union
    {
        __IOM uint16_t USBVAL;          /*!< (@ 0x00000056) USB Request Value Register                                 */

        struct
        {
            __IOM uint16_t WVALUE : 16; /*!< [15..0] ValueThese bits store the USB request Value value.                */
        } USBVAL_b;
    };

    union
    {
        __IOM uint16_t USBINDX;         /*!< (@ 0x00000058) USB Request Index Register                                 */

        struct
        {
            __IOM uint16_t WINDEX : 16; /*!< [15..0] IndexThese bits store the USB request wIndex value.               */
        } USBINDX_b;
    };

    union
    {
        __IOM uint16_t USBLENG;          /*!< (@ 0x0000005A) USB Request Length Register                                */

        struct
        {
            __IOM uint16_t WLENGTH : 16; /*!< [15..0] LengthThese bits store the USB request wLength value.             */
        } USBLENG_b;
    };

    union
    {
        __IOM uint16_t DCPCFG;         /*!< (@ 0x0000005C) DCP Configuration Register                                 */

        struct
        {
            uint16_t              : 4;
            __IOM uint16_t DIR    : 1; /*!< [4..4] Transfer Direction                                                 */
            uint16_t              : 2;
            __IOM uint16_t SHTNAK : 1; /*!< [7..7] Pipe Disabled at End of Transfer                                   */
            __IOM uint16_t CNTMD  : 1; /*!< [8..8] Continuous Transfer Mode                                           */
            uint16_t              : 7;
        } DCPCFG_b;
    };

    union
    {
        __IOM uint16_t DCPMAXP;        /*!< (@ 0x0000005E) DCP Maximum Packet Size Register                           */

        struct
        {
            __IOM uint16_t MXPS : 7;   /*!< [6..0] Maximum Packet SizeThese bits set the maximum amount
                                        *   of data (maximum packet size) in payloads for the DCP.                    */
            uint16_t              : 5;
            __IOM uint16_t DEVSEL : 4; /*!< [15..12] Device Select                                                    */
        } DCPMAXP_b;
    };

    union
    {
        __IOM uint16_t DCPCTR;           /*!< (@ 0x00000060) DCP Control Register                                       */

        struct
        {
            __IOM uint16_t PID      : 2; /*!< [1..0] Response PID                                                       */
            __IOM uint16_t CCPL     : 1; /*!< [2..2] Control Transfer End Enable                                        */
            uint16_t                : 2;
            __IM uint16_t  PBUSY    : 1; /*!< [5..5] Pipe Busy                                                          */
            __IM uint16_t  SQMON    : 1; /*!< [6..6] Sequence Toggle Bit Monitor                                        */
            __IOM uint16_t SQSET    : 1; /*!< [7..7] Sequence Toggle Bit Set                                            */
            __IOM uint16_t SQCLR    : 1; /*!< [8..8] Sequence Toggle Bit Clear                                          */
            uint16_t                : 2;
            __IOM uint16_t SUREQCLR : 1; /*!< [11..11] SUREQ Bit Clear                                                  */
            uint16_t                : 2;
            __IOM uint16_t SUREQ    : 1; /*!< [14..14] Setup Token Transmission                                         */
            __IM uint16_t  BSTS     : 1; /*!< [15..15] Buffer Status                                                    */
        } DCPCTR_b;
    };
    __IM uint16_t RESERVED10;

    union
    {
        __IOM uint16_t PIPESEL;         /*!< (@ 0x00000064) Pipe Window Select Register                                */

        struct
        {
            __IOM uint16_t PIPESEL : 4; /*!< [3..0] Pipe Window Select                                                 */
            uint16_t               : 12;
        } PIPESEL_b;
    };
    __IM uint16_t RESERVED11;

    union
    {
        __IOM uint16_t PIPECFG;        /*!< (@ 0x00000068) Pipe Configuration Register                                */

        struct
        {
            __IOM uint16_t EPNUM : 4;  /*!< [3..0] Endpoint NumberThese bits specify the endpoint number
                                        *   for the selected pipe.Setting 0000b means unused pipe.                    */
            __IOM uint16_t DIR    : 1; /*!< [4..4] Transfer Direction                                                 */
            uint16_t              : 2;
            __IOM uint16_t SHTNAK : 1; /*!< [7..7] Pipe Disabled at End of Transfer                                   */
            uint16_t              : 1;
            __IOM uint16_t DBLB   : 1; /*!< [9..9] Double Buffer Mode                                                 */
            __IOM uint16_t BFRE   : 1; /*!< [10..10] BRDY Interrupt Operation Specification                           */
            uint16_t              : 3;
            __IOM uint16_t TYPE   : 2; /*!< [15..14] Transfer Type                                                    */
        } PIPECFG_b;
    };
    __IM uint16_t RESERVED12;

    union
    {
        __IOM uint16_t PIPEMAXP;       /*!< (@ 0x0000006C) Pipe Maximum Packet Size Register                          */

        struct
        {
            __IOM uint16_t MXPS : 9;   /*!< [8..0] Maximum Packet SizePIPE1 and PIPE2: 1 byte (001h) to
                                        *   256 bytes (100h)PIPE3 to PIPE5: 8 bytes (008h), 16 bytes
                                        *   (010h), 32 bytes (020h), 64 bytes (040h) (Bits [8:7] and
                                        *   [2:0] are not provided.)PIPE6 to PIPE9: 1 byte (001h) to
                                        *   64 bytes (040h) (Bits [8:7] are not provided.)                            */
            uint16_t              : 3;
            __IOM uint16_t DEVSEL : 4; /*!< [15..12] Device Select                                                    */
        } PIPEMAXP_b;
    };

    union
    {
        __IOM uint16_t PIPEPERI;       /*!< (@ 0x0000006E) Pipe Cycle Control Register                                */

        struct
        {
            __IOM uint16_t IITV : 3;   /*!< [2..0] Interval Error Detection IntervalSpecifies the interval
                                        *   error detection timing for the selected pipe in terms of
                                        *   frames, which is expressed as nth power of 2.                             */
            uint16_t            : 9;
            __IOM uint16_t IFIS : 1;   /*!< [12..12] Isochronous IN Buffer Flush                                      */
            uint16_t            : 3;
        } PIPEPERI_b;
    };

    union
    {
        __IOM uint16_t PIPE_CTR[9];    /*!< (@ 0x00000070) Pipe [0..8] Control Register                               */

        struct
        {
            __IOM uint16_t PID    : 2; /*!< [1..0] Response PID                                                       */
            uint16_t              : 3;
            __IM uint16_t  PBUSY  : 1; /*!< [5..5] Pipe Busy                                                          */
            __IM uint16_t  SQMON  : 1; /*!< [6..6] Sequence Toggle Bit Confirmation                                   */
            __IOM uint16_t SQSET  : 1; /*!< [7..7] Sequence Toggle Bit Set                                            */
            __IOM uint16_t SQCLR  : 1; /*!< [8..8] Sequence Toggle Bit Clear                                          */
            __IOM uint16_t ACLRM  : 1; /*!< [9..9] Auto Buffer Clear Mode                                             */
            __IOM uint16_t ATREPM : 1; /*!< [10..10] Auto Response Mode                                               */
            uint16_t              : 1;
            __IM uint16_t CSSTS   : 1; /*!< [12..12] CSSTS StatusThis bit indicates the CSPLIT status of
                                        *   Split Transaction of the relevant pipe                                    */
            __IOM uint16_t CSCLR : 1;  /*!< [13..13] CSPLIT Status ClearSet this bit to 1 when clearing
                                        *   the CSSTS bit of the relevant pipe                                        */
            __IM uint16_t INBUFM : 1;  /*!< [14..14] Transmit Buffer Monitor                                          */
            __IM uint16_t BSTS   : 1;  /*!< [15..15] Buffer Status                                                    */
        } PIPE_CTR_b[9];
    };
    __IM uint16_t                RESERVED13;
    __IM uint32_t                RESERVED14[3];
    __IOM R_USB_FS0_PIPE_TR_Type PIPE_TR[5]; /*!< (@ 0x00000090) Pipe Transaction Counter Registers                         */
    __IM uint32_t                RESERVED15[3];

    union
    {
        __IOM uint16_t USBBCCTRL0;         /*!< (@ 0x000000B0) BC Control Register 0                                      */

        struct
        {
            __IOM uint16_t RPDME0     : 1; /*!< [0..0] D- Pin Pull-Down Control                                           */
            __IOM uint16_t IDPSRCE0   : 1; /*!< [1..1] D+ Pin IDPSRC Output Control                                       */
            __IOM uint16_t IDMSINKE0  : 1; /*!< [2..2] D- Pin 0.6 V Input Detection (Comparator and Sink) Control         */
            __IOM uint16_t VDPSRCE0   : 1; /*!< [3..3] D+ Pin VDPSRC (0.6 V) Output Control                               */
            __IOM uint16_t IDPSINKE0  : 1; /*!< [4..4] D+ Pin 0.6 V Input Detection (Comparator and Sink) Control         */
            __IOM uint16_t VDMSRCE0   : 1; /*!< [5..5] D- Pin VDMSRC (0.6 V) Output Control                               */
            uint16_t                  : 1;
            __IOM uint16_t BATCHGE0   : 1; /*!< [7..7] BC (Battery Charger) Function Ch0 General Enable Control           */
            __IM uint16_t  CHGDETSTS0 : 1; /*!< [8..8] D- Pin 0.6 V Input Detection Status                                */
            __IM uint16_t  PDDETSTS0  : 1; /*!< [9..9] D+ Pin 0.6 V Input Detection Status                                */
            uint16_t                  : 6;
        } USBBCCTRL0_b;
    };
    __IM uint16_t RESERVED16;
    __IM uint32_t RESERVED17[4];

    union
    {
        __IOM uint16_t UCKSEL;          /*!< (@ 0x000000C4) USB Clock Selection Register                               */

        struct
        {
            __IOM uint16_t UCKSELC : 1; /*!< [0..0] USB Clock Selection                                                */
            uint16_t               : 15;
        } UCKSEL_b;
    };
    __IM uint16_t RESERVED18;
    __IM uint32_t RESERVED19;

    union
    {
        __IOM uint16_t USBMC;           /*!< (@ 0x000000CC) USB Module Control Register                                */

        struct
        {
            __IOM uint16_t VDDUSBE : 1; /*!< [0..0] USB Reference Power Supply Circuit On/Off Control                  */
            uint16_t               : 6;
            __IOM uint16_t VDCEN   : 1; /*!< [7..7] USB Regulator On/Off Control                                       */
            uint16_t               : 8;
        } USBMC_b;
    };
    __IM uint16_t RESERVED20;

    union
    {
        __IOM uint16_t DEVADD[10];     /*!< (@ 0x000000D0) Device Address Configuration Register                      */

        struct
        {
            uint16_t               : 6;
            __IOM uint16_t USBSPD  : 2; /*!< [7..6] Transfer Speed of Communication Target Device                      */
            __IOM uint16_t HUBPORT : 3; /*!< [10..8] Communication Target Connecting Hub Port                          */
            __IOM uint16_t UPPHUB  : 4; /*!< [14..11] Communication Target Connecting Hub Register                     */
            uint16_t               : 1;
        } DEVADD_b[10];
    };
    __IM uint32_t RESERVED21[3];

    union
    {
        __IOM uint32_t PHYSLEW;         /*!< (@ 0x000000F0) PHY Cross Point Adjustment Register                        */

        struct
        {
            __IOM uint32_t SLEWR00 : 1; /*!< [0..0] Receiver Cross Point Adjustment 00                                 */
            __IOM uint32_t SLEWR01 : 1; /*!< [1..1] Receiver Cross Point Adjustment 01                                 */
            __IOM uint32_t SLEWF00 : 1; /*!< [2..2] Receiver Cross Point Adjustment 00                                 */
            __IOM uint32_t SLEWF01 : 1; /*!< [3..3] Receiver Cross Point Adjustment 01                                 */
            uint32_t               : 28;
        } PHYSLEW_b;
    };
    __IM uint32_t RESERVED22[3];

    union
    {
        __IOM uint16_t LPCTRL;         /*!< (@ 0x00000100) Low Power Control Register                                 */

        struct
        {
            uint16_t             : 7;
            __IOM uint16_t HWUPM : 1;  /*!< [7..7] Resume Return Mode Setting                                         */
            uint16_t             : 8;
        } LPCTRL_b;
    };

    union
    {
        __IOM uint16_t LPSTS;          /*!< (@ 0x00000102) Low Power Status Register                                  */

        struct
        {
            uint16_t                : 14;
            __IOM uint16_t SUSPENDM : 1; /*!< [14..14] UTMI SuspendM Control                                            */
            uint16_t                : 1;
        } LPSTS_b;
    };
    __IM uint32_t RESERVED23[15];

    union
    {
        __IOM uint16_t BCCTRL;           /*!< (@ 0x00000140) Battery Charging Control Register                          */

        struct
        {
            __IOM uint16_t IDPSRCE  : 1; /*!< [0..0] IDPSRC Control                                                     */
            __IOM uint16_t IDMSINKE : 1; /*!< [1..1] IDMSINK Control                                                    */
            __IOM uint16_t VDPSRCE  : 1; /*!< [2..2] VDPSRC Control                                                     */
            __IOM uint16_t IDPSINKE : 1; /*!< [3..3] IDPSINK Control                                                    */
            __IOM uint16_t VDMSRCE  : 1; /*!< [4..4] VDMSRC Control                                                     */
            __IOM uint16_t DCPMODE  : 1; /*!< [5..5] DCP Mode Control                                                   */
            uint16_t                : 2;
            __IM uint16_t CHGDETSTS : 1; /*!< [8..8] CHGDET Status                                                      */
            __IM uint16_t PDDETSTS  : 1; /*!< [9..9] PDDET Status                                                       */
            uint16_t                : 6;
        } BCCTRL_b;
    };
    __IM uint16_t RESERVED24;

    union
    {
        __IOM uint16_t PL1CTRL1;         /*!< (@ 0x00000144) Function L1 Control Register 1                             */

        struct
        {
            __IOM uint16_t L1RESPEN : 1; /*!< [0..0] L1 Response Enable                                                 */
            __IOM uint16_t L1RESPMD : 2; /*!< [2..1] L1 Response Mode                                                   */
            __IOM uint16_t L1NEGOMD : 1; /*!< [3..3] L1 Response Negotiation Control.NOTE: This bit is valid
                                          *   only when the L1RESPMD[1:0] value is 2'b11.                               */
            __IM uint16_t DVSQ : 4;      /*!< [7..4] DVSQ Extension.DVSQ[3] is Mirror of DVSQ[2:0] in INTSTS0.Indicates
                                          *   the L1 state together with the device state bits DVSQ[2:0].               */
            __IOM uint16_t HIRDTHR : 4;  /*!< [11..8] L1 Response Negotiation Threshold ValueHIRD threshold
                                          *   value used for L1NEGOMD.The format is the same as the HIRD
                                          *   field in HL1CTRL.                                                         */
            uint16_t               : 2;
            __IOM uint16_t L1EXTMD : 1;  /*!< [14..14] PHY Control Mode at L1 Return                                    */
            uint16_t               : 1;
        } PL1CTRL1_b;
    };

    union
    {
        __IOM uint16_t PL1CTRL2;       /*!< (@ 0x00000146) Function L1 Control Register 2                             */

        struct
        {
            uint16_t               : 8;
            __IOM uint16_t HIRDMON : 4; /*!< [11..8] HIRD Value Monitor                                                */
            __IOM uint16_t RWEMON  : 1; /*!< [12..12] RWE Value Monitor                                                */
            uint16_t               : 3;
        } PL1CTRL2_b;
    };

    union
    {
        __IOM uint16_t HL1CTRL1;         /*!< (@ 0x00000148) Host L1 Control Register 1                                 */

        struct
        {
            __IOM uint16_t L1REQ    : 1; /*!< [0..0] L1 Transition Request                                              */
            __IM uint16_t  L1STATUS : 2; /*!< [2..1] L1 Request Completion Status                                       */
            uint16_t                : 13;
        } HL1CTRL1_b;
    };

    union
    {
        __IOM uint16_t HL1CTRL2;       /*!< (@ 0x0000014A) Host L1 Control Register 2                                 */

        struct
        {
            __IOM uint16_t L1ADDR : 4; /*!< [3..0] LPM Token DeviceAddressThese bits specify the value to
                                        *   be set in the ADDR field of LPM token.                                    */
            uint16_t             : 4;
            __IOM uint16_t HIRD  : 4;  /*!< [11..8] LPM Token HIRD                                                    */
            __IOM uint16_t L1RWE : 1;  /*!< [12..12] LPM Token L1 RemoteWake EnableThese bits specify the
                                        *   value to be set in the RWE field of LPM token.                            */
            uint16_t            : 2;
            __IOM uint16_t BESL : 1;   /*!< [15..15] BESL & Alternate HIRDThis bit selects the K-State drive
                                        *   period at the time of L1 Resume.                                          */
        } HL1CTRL2_b;
    };
    __IM uint32_t RESERVED25[5];

    union
    {
        __IM uint32_t DPUSR0R;         /*!< (@ 0x00000160) Deep Standby USB Transceiver Control/Pin Monitor
                                        *                  Register                                                   */

        struct
        {
            uint32_t              : 20;
            __IM uint32_t DOVCAHM : 1;  /*!< [20..20] OVRCURA InputIndicates OVRCURA input signal on the
                                         *   HS side of USB port.                                                      */
            __IM uint32_t DOVCBHM : 1;  /*!< [21..21] OVRCURB InputIndicates OVRCURB input signal on the
                                         *   HS side of USB port.                                                      */
            uint32_t               : 1;
            __IM uint32_t DVBSTSHM : 1; /*!< [23..23] VBUS InputIndicates VBUS input signal on the HS side
                                         *   of USB port.                                                              */
            uint32_t : 8;
        } DPUSR0R_b;
    };

    union
    {
        __IOM uint32_t DPUSR1R;        /*!< (@ 0x00000164) Deep Standby USB Suspend/Resume Interrupt Register         */

        struct
        {
            uint32_t                : 4;
            __IOM uint32_t DOVCAHE  : 1; /*!< [4..4] OVRCURA Interrupt Enable Clear                                     */
            __IOM uint32_t DOVCBHE  : 1; /*!< [5..5] OVRCURB Interrupt Enable Clear                                     */
            uint32_t                : 1;
            __IOM uint32_t DVBSTSHE : 1; /*!< [7..7] VBUS Interrupt Enable/Clear                                        */
            uint32_t                : 12;
            __IM uint32_t DOVCAH    : 1; /*!< [20..20] Indication of Return from OVRCURA Interrupt Source               */
            __IM uint32_t DOVCBH    : 1; /*!< [21..21] Indication of Return from OVRCURB Interrupt Source               */
            uint32_t                : 1;
            __IM uint32_t DVBSTSH   : 1; /*!< [23..23] Indication of Return from VBUS Interrupt Source                  */
            uint32_t                : 8;
        } DPUSR1R_b;
    };

    union
    {
        __IOM uint16_t DPUSR2R;        /*!< (@ 0x00000168) Deep Standby USB Suspend/Resume Interrupt Register         */

        struct
        {
            __IM uint16_t DPINT : 1;   /*!< [0..0] Indication of Return from DP Interrupt Source                      */
            __IM uint16_t DMINT : 1;   /*!< [1..1] Indication of Return from DM Interrupt Source                      */
            uint16_t            : 2;
            __IM uint16_t DPVAL : 1;   /*!< [4..4] DP InputIndicates DP input signal on the HS side of USB
                                        *   port.                                                                     */
            __IM uint16_t DMVAL : 1;   /*!< [5..5] DM InputIndicates DM input signal on the HS side of USB
                                        *   port.                                                                     */
            uint16_t              : 2;
            __IOM uint16_t DPINTE : 1; /*!< [8..8] DP Interrupt Enable Clear                                          */
            __IOM uint16_t DMINTE : 1; /*!< [9..9] DM Interrupt Enable Clear                                          */
            uint16_t              : 6;
        } DPUSR2R_b;
    };

    union
    {
        __IOM uint16_t DPUSRCR;          /*!< (@ 0x0000016A) Deep Standby USB Suspend/Resume Command Register           */

        struct
        {
            __IOM uint16_t FIXPHY   : 1; /*!< [0..0] USB Transceiver Control Fix                                        */
            __IOM uint16_t FIXPHYPD : 1; /*!< [1..1] USB Transceiver Control Fix for PLL                                */
            uint16_t                : 14;
        } DPUSRCR_b;
    };
    __IM uint32_t RESERVED26[165];

    union
    {
        __IOM uint32_t DPUSR0R_FS;      /*!< (@ 0x00000400) Deep Software Standby USB Transceiver Control/Pin
                                         *                  Monitor Register                                           */

        struct
        {
            __IOM uint32_t SRPC0   : 1; /*!< [0..0] USB Single End Receiver Control                                    */
            __IOM uint32_t RPUE0   : 1; /*!< [1..1] DP Pull-Up Resistor Control                                        */
            uint32_t               : 1;
            __IOM uint32_t DRPD0   : 1; /*!< [3..3] D+/D- Pull-Down Resistor Control                                   */
            __IOM uint32_t FIXPHY0 : 1; /*!< [4..4] USB Transceiver Output Fix                                         */
            uint32_t               : 11;
            __IM uint32_t DP0      : 1; /*!< [16..16] USB0 D+ InputIndicates the D+ input signal of the USB.           */
            __IM uint32_t DM0      : 1; /*!< [17..17] USB D-InputIndicates the D- input signal of the USB.             */
            uint32_t               : 2;
            __IM uint32_t DOVCA0   : 1; /*!< [20..20] USB OVRCURA InputIndicates the OVRCURA input signal
                                         *   of the USB.                                                               */
            __IM uint32_t DOVCB0 : 1;   /*!< [21..21] USB OVRCURB InputIndicates the OVRCURB input signal
                                         *   of the USB.                                                               */
            uint32_t              : 1;
            __IM uint32_t DVBSTS0 : 1;  /*!< [23..23] USB VBUS InputIndicates the VBUS input signal of the
                                         *   USB.                                                                      */
            uint32_t : 8;
        } DPUSR0R_FS_b;
    };

    union
    {
        __IOM uint32_t DPUSR1R_FS;        /*!< (@ 0x00000404) Deep Software Standby USB Suspend/Resume Interrupt
                                           *                  Register                                                   */

        struct
        {
            __IOM uint32_t DPINTE0   : 1; /*!< [0..0] USB DP Interrupt Enable/Clear                                      */
            __IOM uint32_t DMINTE0   : 1; /*!< [1..1] USB DM Interrupt Enable/Clear                                      */
            uint32_t                 : 2;
            __IOM uint32_t DOVRCRAE0 : 1; /*!< [4..4] USB OVRCURA Interrupt Enable/Clear                                 */
            __IOM uint32_t DOVRCRBE0 : 1; /*!< [5..5] USB OVRCURB Interrupt Enable/Clear                                 */
            uint32_t                 : 1;
            __IOM uint32_t DVBSE0    : 1; /*!< [7..7] USB VBUS Interrupt Enable/Clear                                    */
            uint32_t                 : 8;
            __IM uint32_t DPINT0     : 1; /*!< [16..16] USB DP Interrupt Source Recovery                                 */
            __IM uint32_t DMINT0     : 1; /*!< [17..17] USB DM Interrupt Source Recovery                                 */
            uint32_t                 : 2;
            __IM uint32_t DOVRCRA0   : 1; /*!< [20..20] USB OVRCURA Interrupt Source Recovery                            */
            __IM uint32_t DOVRCRB0   : 1; /*!< [21..21] USB OVRCURB Interrupt Source Recovery                            */
            uint32_t                 : 1;
            __IM uint32_t DVBINT0    : 1; /*!< [23..23] USB VBUS Interrupt Source Recovery                               */
            uint32_t                 : 8;
        } DPUSR1R_FS_b;
    };
} R_USB_FS0_Type;                         /*!< Size = 1032 (0x408)                                                       */

/* =========================================================================================================================== */
/* ================                                           R_WDT                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Watchdog Timer (R_WDT)
 */

typedef struct                         /*!< (@ 0x40083400) R_WDT Structure                                            */
{
    union
    {
        __IOM uint8_t WDTRR;           /*!< (@ 0x00000000) WDT Refresh Register                                       */

        struct
        {
            __IOM uint8_t WDTRR : 8;   /*!< [7..0] WDTRR is an 8-bit register that refreshes the down-counter
                                        *   of the WDT.                                                               */
        } WDTRR_b;
    };
    __IM uint8_t RESERVED;

    union
    {
        __IOM uint16_t WDTCR;          /*!< (@ 0x00000002) WDT Control Register                                       */

        struct
        {
            __IOM uint16_t TOPS : 2;   /*!< [1..0] Timeout Period Selection                                           */
            uint16_t            : 2;
            __IOM uint16_t CKS  : 4;   /*!< [7..4] Clock Division Ratio Selection                                     */
            __IOM uint16_t RPES : 2;   /*!< [9..8] Window End Position Selection                                      */
            uint16_t            : 2;
            __IOM uint16_t RPSS : 2;   /*!< [13..12] Window Start Position Selection                                  */
            uint16_t            : 2;
        } WDTCR_b;
    };

    union
    {
        __IOM uint16_t WDTSR;           /*!< (@ 0x00000004) WDT Status Register                                        */

        struct
        {
            __IM uint16_t  CNTVAL : 14; /*!< [13..0] Down-Counter Value                                                */
            __IOM uint16_t UNDFF  : 1;  /*!< [14..14] Underflow Flag                                                   */
            __IOM uint16_t REFEF  : 1;  /*!< [15..15] Refresh Error Flag                                               */
        } WDTSR_b;
    };

    union
    {
        __IOM uint8_t WDTRCR;          /*!< (@ 0x00000006) WDT Reset Control Register                                 */

        struct
        {
            uint8_t               : 7;
            __IOM uint8_t RSTIRQS : 1; /*!< [7..7] Reset Interrupt Request Selection                                  */
        } WDTRCR_b;
    };
    __IM uint8_t RESERVED1;

    union
    {
        __IOM uint8_t WDTCSTPR;        /*!< (@ 0x00000008) WDT Count Stop Control Register                            */

        struct
        {
            uint8_t              : 7;
            __IOM uint8_t SLCSTP : 1;  /*!< [7..7] Sleep-Mode Count Stop Control                                      */
        } WDTCSTPR_b;
    };
    __IM uint8_t  RESERVED2;
    __IM uint16_t RESERVED3;
} R_WDT_Type;                          /*!< Size = 12 (0xc)                                                           */

/* =========================================================================================================================== */
/* ================                                           R_TZF                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief TrustZone Filter (R_TZF)
 */

typedef struct                         /*!< (@ 0x40000E00) R_TZF Structure                                            */
{
    union
    {
        __IOM uint16_t TZFOAD;         /*!< (@ 0x00000000) TrustZone Filter Operation After Detection Register        */

        struct
        {
            __IOM uint16_t OAD : 1;    /*!< [0..0] Operation after detection                                          */
            uint16_t           : 7;
            __OM uint16_t KEY  : 8;    /*!< [15..8] KeyCode                                                           */
        } TZFOAD_b;
    };
    __IM uint16_t RESERVED;

    union
    {
        __IOM uint16_t TZFPT;           /*!< (@ 0x00000004) TrustZone Filter Protect Register                          */

        struct
        {
            __IOM uint16_t PROTECT : 1; /*!< [0..0] Protection of register                                             */
            uint16_t               : 7;
            __OM uint16_t KEY      : 8; /*!< [15..8] KeyCode                                                           */
        } TZFPT_b;
    };
    __IM uint16_t RESERVED1;
    __IM uint32_t RESERVED2[94];

    union
    {
        __IOM uint32_t TZFSAR;         /*!< (@ 0x00000180) TrustZone Filter Security Attribution Register             */

        struct
        {
            __IOM uint32_t TZFSA0 : 1; /*!< [0..0] Security attributes of registers for TrustZone Filter              */
            uint32_t              : 31;
        } TZFSAR_b;
    };
} R_TZF_Type;                          /*!< Size = 388 (0x184)                                                        */

/* =========================================================================================================================== */
/* ================                                          R_CACHE                                          ================ */
/* =========================================================================================================================== */

/**
 * @brief R_CACHE (R_CACHE)
 */

typedef struct                         /*!< (@ 0x40007000) R_CACHE Structure                                          */
{
    union
    {
        __IOM uint32_t CCACTL;         /*!< (@ 0x00000000) C-Cache Control Register                                   */

        struct
        {
            __IOM uint32_t ENC : 1;    /*!< [0..0] C-Cache Enable                                                     */
            uint32_t           : 31;
        } CCACTL_b;
    };

    union
    {
        __IOM uint32_t CCAFCT;         /*!< (@ 0x00000004) C-Cache Flush Control Register                             */

        struct
        {
            __IOM uint32_t FC : 1;     /*!< [0..0] C-Cache Flush                                                      */
            uint32_t          : 31;
        } CCAFCT_b;
    };

    union
    {
        __IOM uint32_t CCALCF;         /*!< (@ 0x00000008) C-Cache Line Configuration Register                        */

        struct
        {
            __IOM uint32_t CC : 2;     /*!< [1..0] C-Cache Line Size                                                  */
            uint32_t          : 30;
        } CCALCF_b;
    };
    __IM uint32_t RESERVED[13];

    union
    {
        __IOM uint32_t SCACTL;         /*!< (@ 0x00000040) S-Cache Control Register                                   */

        struct
        {
            __IOM uint32_t ENS : 1;    /*!< [0..0] S-Cache Enable                                                     */
            uint32_t           : 31;
        } SCACTL_b;
    };

    union
    {
        __IOM uint32_t SCAFCT;         /*!< (@ 0x00000044) S-Cache Flush Control Register                             */

        struct
        {
            __IOM uint32_t FS : 1;     /*!< [0..0] S-Cache Flush                                                      */
            uint32_t          : 31;
        } SCAFCT_b;
    };

    union
    {
        __IOM uint32_t SCALCF;         /*!< (@ 0x00000048) S-Cache Line Configuration Register                        */

        struct
        {
            __IOM uint32_t CS : 2;     /*!< [1..0] S-Cache Line Size                                                  */
            uint32_t          : 30;
        } SCALCF_b;
    };
    __IM uint32_t RESERVED1[109];

    union
    {
        __IOM uint32_t CAPOAD;         /*!< (@ 0x00000200) Cache Parity Error Operation After Detection
                                        *                  Register                                                   */

        struct
        {
            __IOM uint32_t OAD : 1;    /*!< [0..0] Operation after Detection                                          */
            uint32_t           : 31;
        } CAPOAD_b;
    };

    union
    {
        __IOM uint32_t CAPRCR;         /*!< (@ 0x00000204) Cache Protection Register                                  */

        struct
        {
            __IOM uint32_t PRCR : 1;   /*!< [0..0] Register Write Control                                             */
            __IOM uint32_t KW   : 7;   /*!< [7..1] Write key code                                                     */
            uint32_t            : 24;
        } CAPRCR_b;
    };
} R_CACHE_Type;                        /*!< Size = 520 (0x208)                                                        */

/* =========================================================================================================================== */
/* ================                                          R_CPSCU                                          ================ */
/* =========================================================================================================================== */

/**
 * @brief CPU System Security Control Unit (R_CPSCU)
 */

typedef struct                           /*!< (@ 0x40008000) R_CPSCU Structure                                          */
{
    union
    {
        __IOM uint32_t CSAR;             /*!< (@ 0x00000000) Cache Security Attribution Register                        */

        struct
        {
            __IOM uint32_t CACHESA  : 1; /*!< [0..0] Security Attributes of Registers for Cache Control                 */
            __IOM uint32_t CACHELSA : 1; /*!< [1..1] Security Attributes of Registers for Cache Line Configuration      */
            __IOM uint32_t CACHEESA : 1; /*!< [2..2] Security Attributes of Registers for Cache Error                   */
            uint32_t                : 29;
        } CSAR_b;
    };
    __IM uint32_t RESERVED[3];

    union
    {
        __IOM uint32_t SRAMSAR;         /*!< (@ 0x00000010) SRAM Security Attribution Register                         */

        struct
        {
            __IOM uint32_t SRAMSA0 : 1; /*!< [0..0] Security attributes of registers for SRAM Protection               */
            __IOM uint32_t SRAMSA1 : 1; /*!< [1..1] Security attributes of registers for SRAM Protection
                                         *   2                                                                         */
            __IOM uint32_t SRAMSA2 : 1; /*!< [2..2] Security attributes of registers for ECC Relation                  */
            uint32_t               : 29;
        } SRAMSAR_b;
    };

    union
    {
        __IOM uint32_t STBRAMSAR;       /*!< (@ 0x00000014) Standby RAM memory Security Attribution Register           */

        struct
        {
            __IOM uint32_t NSBSTBR : 4; /*!< [3..0] Security attributes of each region for Standby RAM                 */
            uint32_t               : 28;
        } STBRAMSAR_b;
    };
    __IM uint32_t RESERVED1[6];

    union
    {
        __IOM uint32_t DTCSAR;          /*!< (@ 0x00000030) DTC Controller Security Attribution Register               */

        struct
        {
            __IOM uint32_t DTCSTSA : 1; /*!< [0..0] DTC Security Attribution                                           */
            uint32_t               : 31;
        } DTCSAR_b;
    };

    union
    {
        __IOM uint32_t DMACSAR;         /*!< (@ 0x00000034) DMAC Controller Security Attribution Register              */

        struct
        {
            __IOM uint32_t DMASTSA : 1; /*!< [0..0] DMAST Security Attribution                                         */
            uint32_t               : 31;
        } DMACSAR_b;
    };
    __IM uint32_t RESERVED2[2];

    union
    {
        __IOM uint32_t ICUSARA;           /*!< (@ 0x00000040) ICU Security Attribution Register A                        */

        struct
        {
            __IOM uint32_t SAIRQCRn : 16; /*!< [15..0] Security Attributes of registers for the IRQCRn registers         */
            uint32_t                : 16;
        } ICUSARA_b;
    };

    union
    {
        __IOM uint32_t ICUSARB;        /*!< (@ 0x00000044) ICU Security Attribution Register B                        */

        struct
        {
            __IOM uint32_t SANMI : 1;  /*!< [0..0] Security Attributes of nonmaskable interrupt                       */
            uint32_t             : 31;
        } ICUSARB_b;
    };

    union
    {
        __IOM uint32_t ICUSARC;         /*!< (@ 0x00000048) ICU Security Attribution Register C                        */

        struct
        {
            __IOM uint32_t SADMACn : 8; /*!< [7..0] Security Attributes of registers for DMAC channel                  */
            uint32_t               : 24;
        } ICUSARC_b;
    };

    union
    {
        __IOM uint32_t ICUSARD;          /*!< (@ 0x0000004C) ICU Security Attribution Register D                        */

        struct
        {
            __IOM uint32_t SASELSR0 : 1; /*!< [0..0] Security Attributes of registers for SELSR0                        */
            uint32_t                : 31;
        } ICUSARD_b;
    };

    union
    {
        __IOM uint32_t ICUSARE;        /*!< (@ 0x00000050) ICU Security Attribution Register E                        */

        struct
        {
            uint32_t                   : 16;
            __IOM uint32_t SAIWDTWUP   : 1; /*!< [16..16] Security Attributes of registers for WUPEN0.b 16                 */
            uint32_t                   : 1;
            __IOM uint32_t SALVD1WUP   : 1; /*!< [18..18] Security Attributes of registers for WUPEN0.b 18                 */
            __IOM uint32_t SALVD2WUP   : 1; /*!< [19..19] Security Attributes of registers for WUPEN0.b 19                 */
            __IOM uint32_t SAVBATTWUP  : 1; /*!< [20..20] Security Attributes of registers for WUPEN0.b 20                 */
            uint32_t                   : 3;
            __IOM uint32_t SARTCALMWUP : 1; /*!< [24..24] Security Attributes of registers for WUPEN0.b 24                 */
            __IOM uint32_t SARTCPRDWUP : 1; /*!< [25..25] Security Attributes of registers for WUPEN0.b 25                 */
            uint32_t                   : 1;
            __IOM uint32_t SAUSBFS0WUP : 1; /*!< [27..27] Security Attributes of registers for WUPEN0.b 27                 */
            __IOM uint32_t SAAGT1UDWUP : 1; /*!< [28..28] Security Attributes of registers for WUPEN0.b 28                 */
            __IOM uint32_t SAAGT1CAWUP : 1; /*!< [29..29] Security Attributes of registers for WUPEN0.b 29                 */
            __IOM uint32_t SAAGT1CBWUP : 1; /*!< [30..30] Security Attributes of registers for WUPEN0.b 30                 */
            __IOM uint32_t SAIIC0WUP   : 1; /*!< [31..31] Security Attributes of registers for WUPEN0.b 31                 */
        } ICUSARE_b;
    };

    union
    {
        __IOM uint32_t ICUSARF;              /*!< (@ 0x00000054) ICU Security Attribution Register F                        */

        struct
        {
            __IOM uint32_t SAAGT3UDWUP  : 1; /*!< [0..0] Security Attributes of registers for WUPEN1.b 0                    */
            __IOM uint32_t SAAGT3CAWUP  : 1; /*!< [1..1] Security Attributes of registers for WUPEN1.b 1                    */
            __IOM uint32_t SAAGT3CBWUP  : 1; /*!< [2..2] Security Attributes of registers for WUPEN1.b 2                    */
            __IOM uint32_t SACOMPHS0WUP : 1; /*!< [3..3] Security attributes of registers for WUPEN1.b 3                    */
            uint32_t                    : 4;
            __IOM uint32_t SAULP0UWUP   : 1; /*!< [8..8] Security attributes of registers for WUPEN1.b 8                    */
            __IOM uint32_t SAULP0AWUP   : 1; /*!< [9..9] Security attributes of registers for WUPEN1.b 9                    */
            __IOM uint32_t SAULP0BWUP   : 1; /*!< [10..10] Security Attributes of registers for WUPEN1.b 10                 */
            __IOM uint32_t SAI3CWUP     : 1; /*!< [11..11] Security Attributes of registers for WUPEN1.b 11                 */
            __IOM uint32_t SAULP1UWUP   : 1; /*!< [12..12] Security Attributes of registers for WUPEN1.b 12                 */
            __IOM uint32_t SAULP1AWUP   : 1; /*!< [13..13] Security Attributes of registers for WUPEN1.b 13                 */
            __IOM uint32_t SAULP1BWUP   : 1; /*!< [14..14] Security Attributes of registers for WUPEN1.b 14                 */
            uint32_t                    : 17;
        } ICUSARF_b;
    };
    __IM uint32_t RESERVED3[6];

    union
    {
        __IOM uint32_t ICUSARG;           /*!< (@ 0x00000070) ICU Security Attribution Register G                        */

        struct
        {
            __IOM uint32_t SAIELSRn : 32; /*!< [31..0] Security Attributes of registers for IELSR31 to IELSR0            */
        } ICUSARG_b;
    };

    union
    {
        __IOM uint32_t ICUSARH;           /*!< (@ 0x00000074) ICU Security Attribution Register H                        */

        struct
        {
            __IOM uint32_t SAIELSRn : 32; /*!< [31..0] Security Attributes of registers for IELSR63 to IELSR32           */
        } ICUSARH_b;
    };

    union
    {
        __IOM uint32_t ICUSARI;           /*!< (@ 0x00000078) ICU Security Attribution Register I                        */

        struct
        {
            __IOM uint32_t SAIELSRn : 32; /*!< [31..0] Security Attributes of registers for IELSR95 to IELSR64           */
        } ICUSARI_b;
    };
    __IM uint32_t RESERVED4[33];

    union
    {
        __IOM uint32_t BUSSARA;        /*!< (@ 0x00000100) Bus Security Attribution Register A                        */

        struct
        {
            __IOM uint32_t BUSSA0 : 1; /*!< [0..0] BUS Security Attribution A0                                        */
            uint32_t              : 31;
        } BUSSARA_b;
    };

    union
    {
        __IOM uint32_t BUSSARB;        /*!< (@ 0x00000104) Bus Security Attribution Register B                        */

        struct
        {
            __IOM uint32_t BUSSB0 : 1; /*!< [0..0] BUS Security Attribution B0                                        */
            uint32_t              : 31;
        } BUSSARB_b;
    };
    __IM uint32_t RESERVED5[10];

    union
    {
        __IOM uint32_t MMPUSARA;         /*!< (@ 0x00000130) Master Memory Protection Unit Security Attribution
                                          *                  Register A                                                 */

        struct
        {
            __IOM uint32_t MMPUAnSA : 8; /*!< [7..0] MMPUAn Security Attribution (n = 0 to 7)                           */
            uint32_t                : 24;
        } MMPUSARA_b;
    };

    union
    {
        __IOM uint32_t MMPUSARB;         /*!< (@ 0x00000134) Master Memory Protection Unit Security Attribution
                                          *                  Register B                                                 */

        struct
        {
            __IOM uint32_t MMPUB0SA : 1; /*!< [0..0] MMPUB0 Security Attribution                                        */
            uint32_t                : 31;
        } MMPUSARB_b;
    };
    __IM uint32_t RESERVED6[26];

    union
    {
        __IOM uint32_t DMASARA;          /*!< (@ 0x000001A0) ICU Security Attribution Register C                        */

        struct
        {
            __IOM uint32_t DMASARAn : 8; /*!< [7..0] Security attributes of output and registers for DMAC
                                          *   channel                                                                   */
            uint32_t : 24;
        } DMASARA_b;
    };
    __IM uint32_t RESERVED7[3];

    union
    {
        __IOM uint32_t CPUDSAR;         /*!< (@ 0x000001B0) CPU Debug Security Attribution Register                    */

        struct
        {
            __IOM uint32_t CPUDSA0 : 1; /*!< [0..0] CPU Debug Security Attribution 0                                   */
            uint32_t               : 31;
        } CPUDSAR_b;
    };
    __IM uint32_t RESERVED8[275];

    union
    {
        __IOM uint32_t TEVTRCR;        /*!< (@ 0x00000600) Trusted Event Route Control Register                       */

        struct
        {
            __IOM uint32_t TEVTE : 1;  /*!< [0..0] Trusted Event Route Control Register for IELSRn, DELSRn
                                        *   and ELCSRn                                                                */
            uint32_t : 31;
        } TEVTRCR_b;
    };
} R_CPSCU_Type;                        /*!< Size = 1540 (0x604)                                                       */

/* =========================================================================================================================== */
/* ================                                           R_TFU                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Trigonometric Function Unit (TFU) (R_TFU)
 */

typedef struct                         /*!< (@ 0x40021000) R_TFU Structure                                            */
{
    __IM uint32_t RESERVED[2];

    union
    {
        __IM uint8_t TRGSTS;           /*!< (@ 0x00000008) Trigonometric Status Register                              */

        struct
        {
            __IM uint8_t BSYF : 1;     /*!< [0..0] Calculation in progress flag                                       */
            __IM uint8_t ERRF : 1;     /*!< [1..1] Input error flag                                                   */
            uint8_t           : 6;
        } TRGSTS_b;
    };
    __IM uint8_t  RESERVED1;
    __IM uint16_t RESERVED2;
    __IM uint32_t RESERVED3;

    union
    {
        __IOM float SCDT0;             /*!< (@ 0x00000010) TBD                                                        */

        struct
        {
            __IOM uint32_t SCDT0 : 32; /*!< [31..0] TBD                                                               */
        } SCDT0_b;
    };

    union
    {
        __IOM float SCDT1;             /*!< (@ 0x00000014) TBD                                                        */

        struct
        {
            __IOM uint32_t SCDT1 : 32; /*!< [31..0] TBD                                                               */
        } SCDT1_b;
    };

    union
    {
        __IOM float ATDT0;             /*!< (@ 0x00000018) TBD                                                        */

        struct
        {
            __IOM uint32_t ATDT0 : 32; /*!< [31..0] TBD                                                               */
        } ATDT0_b;
    };

    union
    {
        __IOM float ATDT1;             /*!< (@ 0x0000001C) TBD                                                        */

        struct
        {
            __IOM uint32_t ATDT1 : 32; /*!< [31..0] TBD                                                               */
        } ATDT1_b;
    };
} R_TFU_Type;                          /*!< Size = 32 (0x20)                                                          */

/* =========================================================================================================================== */
/* ================                                          R_AGTX0                                          ================ */
/* =========================================================================================================================== */

/**
 * @brief Asynchronous General Purpose Timer (R_AGTX0)
 */

typedef struct                          /*!< (@ 0x400E8000) R_AGTX0 Structure                                          */
{
    union
    {
        __IOM R_AGTX0_AGT32_Type AGT32; /*!< (@ 0x00000000) AGTW (32-bit) peripheral registers                         */
        __IOM R_AGTX0_AGT16_Type AGT16; /*!< (@ 0x00000000) AGT (16-bit) peripheral registers                          */
    };
} R_AGTX0_Type;                         /*!< Size = 20 (0x14)                                                          */

/* =========================================================================================================================== */
/* ================                                          R_FLAD                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Data Flash (R_FLAD)
 */

typedef struct                         /*!< (@ 0x407FC000) R_FLAD Structure                                           */
{
    __IM uint8_t RESERVED[64];

    union
    {
        __IOM uint8_t FCKMHZ;          /*!< (@ 0x00000040) Data Flash Access Frequency Register                       */

        struct
        {
            __IOM uint8_t FCKMHZ : 8;  /*!< [7..0] Data Flash Access Frequency Register                               */
        } FCKMHZ_b;
    };
} R_FLAD_Type;                         /*!< Size = 65 (0x41)                                                          */

/** @} */ /* End of group Device_Peripheral_peripherals */

/* =========================================================================================================================== */
/* ================                          Device Specific Peripheral Address Map                           ================ */
/* =========================================================================================================================== */

/** @addtogroup Device_Peripheral_peripheralAddr
 * @{
 */

 #define R_ACMPHS0_BASE        0x400F4000UL
 #define R_ACMPHS1_BASE        0x400F4100UL
 #define R_ACMPHS2_BASE        0x400F4200UL
 #define R_ACMPHS3_BASE        0x400F4300UL
 #define R_ACMPHS4_BASE        0x400F4400UL
 #define R_ACMPHS5_BASE        0x400F4500UL
 #define R_ADC0_BASE           0x40170000UL
 #define R_ADC1_BASE           0x40170200UL
 #define R_PSCU_BASE           0x400E0000UL
 #define R_BUS_BASE            0x40003000UL
 #define R_CAC_BASE            0x40083600UL
 #define R_CANFD_BASE          0x400B0000UL
 #define R_CANFD1_BASE         0x400B2000UL
 #define R_CRC_BASE            0x40108000UL
 #define R_DAC_BASE            0x40171000UL
 #define R_DEBUG_BASE          0x4001B000UL
 #define R_DMA_BASE            0x40005200UL
 #define R_DMAC0_BASE          0x40005000UL
 #define R_DMAC1_BASE          0x40005040UL
 #define R_DMAC2_BASE          0x40005080UL
 #define R_DMAC3_BASE          0x400050C0UL
 #define R_DMAC4_BASE          0x40005100UL
 #define R_DMAC5_BASE          0x40005140UL
 #define R_DMAC6_BASE          0x40005180UL
 #define R_DMAC7_BASE          0x400051C0UL
 #define R_DOC_BASE            0x40109000UL
 #define R_DTC_BASE            0x40005400UL
 #define R_ELC_BASE            0x40082000UL
 #define R_FACI_HP_CMD_BASE    0x407E0000UL
 #define R_FACI_HP_BASE        0x407FE000UL
 #define R_FCACHE_BASE         0x4001C000UL
 #define R_GPT0_BASE           0x40169000UL
 #define R_GPT1_BASE           0x40169100UL
 #define R_GPT2_BASE           0x40169200UL
 #define R_GPT3_BASE           0x40169300UL
 #define R_GPT4_BASE           0x40169400UL
 #define R_GPT5_BASE           0x40169500UL
 #define R_GPT6_BASE           0x40169600UL
 #define R_GPT7_BASE           0x40169700UL
 #define R_GPT8_BASE           0x40169800UL
 #define R_GPT9_BASE           0x40169900UL
 #define R_GPT10_BASE          0x40169A00UL
 #define R_GPT11_BASE          0x40169B00UL
 #define R_GPT12_BASE          0x40169C00UL
 #define R_GPT13_BASE          0x40169D00UL
 #define R_GPT_OPS_BASE        0x40169A00UL
 #define R_GPT_POEG0_BASE      0x4008A000UL
 #define R_GPT_POEG1_BASE      0x4008A100UL
 #define R_GPT_POEG2_BASE      0x4008A200UL
 #define R_GPT_POEG3_BASE      0x4008A300UL
 #define R_ICU_BASE            0x40006000UL
 #define R_IIC0_BASE           0x4009F000UL
 #define R_IIC1_BASE           0x4009F100UL
 #define R_IIC2_BASE           0x4009F200UL
 #define R_IWDT_BASE           0x40083200UL
 #define R_I3C0_BASE           0x4011F000UL
 #define R_I3C1_BASE           0x4011F400UL
 #define R_MPU_MMPU_BASE       0x40000000UL
 #define R_MPU_SMPU_BASE       0x40000C00UL
 #define R_MPU_SPMON_BASE      0x40000D00UL
 #define R_MSTP_BASE           0x40084000UL
 #define R_PORT0_BASE          0x40080000UL
 #define R_PORT1_BASE          0x40080020UL
 #define R_PORT2_BASE          0x40080040UL
 #define R_PORT3_BASE          0x40080060UL
 #define R_PORT4_BASE          0x40080080UL
 #define R_PORT5_BASE          0x400800A0UL
 #define R_PORT6_BASE          0x400800C0UL
 #define R_PORT7_BASE          0x400800E0UL
 #define R_PORT8_BASE          0x40080100UL
 #define R_PORT9_BASE          0x40080120UL
 #define R_PORT10_BASE         0x40080140UL
 #define R_PORT11_BASE         0x40080160UL
 #define R_PORT12_BASE         0x40080180UL
 #define R_PORT13_BASE         0x400801A0UL
 #define R_PORT14_BASE         0x400801C0UL
 #define R_PFS_BASE            0x40080800UL
 #define R_PMISC_BASE          0x40080D00UL
 #define R_RTC_BASE            0x40083000UL
 #define R_SCI0_BASE           0x40118000UL
 #define R_SCI1_BASE           0x40118100UL
 #define R_SCI2_BASE           0x40118200UL
 #define R_SCI3_BASE           0x40118300UL
 #define R_SCI4_BASE           0x40118400UL
 #define R_SCI5_BASE           0x40118500UL
 #define R_SCI6_BASE           0x40118600UL
 #define R_SCI7_BASE           0x40118700UL
 #define R_SCI8_BASE           0x40118800UL
 #define R_SCI9_BASE           0x40118900UL
 #define R_SPI0_BASE           0x4011A000UL
 #define R_SPI1_BASE           0x4011A100UL
 #define R_SRAM_BASE           0x40002000UL
 #define R_BUS_B_BASE          0x40003000UL
 #define R_SYSTEM_BASE         0x4001E000UL
 #define R_TRNG_BASE           0x40162000UL
 #define R_TSN_CAL_BASE        0x407FB17CUL
 #define R_TSN_CTRL_BASE       0x400F3000UL
 #define R_USB_FS0_BASE        0x40090000UL
 #define R_WDT_BASE            0x40083400UL
 #define R_TZF_BASE            0x40000E00UL
 #define R_CACHE_BASE          0x40007000UL
 #define R_CPSCU_BASE          0x40008000UL
 #define R_TFU_BASE            0x40021000UL
 #define R_AGTX0_BASE          0x400E8000UL
 #define R_AGTX1_BASE          0x400E8100UL
 #define R_AGTX2_BASE          0x400E8200UL
 #define R_AGTX3_BASE          0x400E8300UL
 #define R_AGTX4_BASE          0x400E8400UL
 #define R_AGTX5_BASE          0x400E8500UL
 #define R_AGTX6_BASE          0x400E8600UL
 #define R_AGTX7_BASE          0x400E8700UL
 #define R_AGTX8_BASE          0x400E8800UL
 #define R_AGTX9_BASE          0x400E8900UL
 #define R_FLAD_BASE           0x407FC000UL

/** @} */ /* End of group Device_Peripheral_peripheralAddr */

/* =========================================================================================================================== */
/* ================                                  Peripheral declaration                                   ================ */
/* =========================================================================================================================== */

/** @addtogroup Device_Peripheral_declaration
 * @{
 */

 #define R_ACMPHS0        ((R_ACMPHS0_Type *) R_ACMPHS0_BASE)
 #define R_ACMPHS1        ((R_ACMPHS0_Type *) R_ACMPHS1_BASE)
 #define R_ACMPHS2        ((R_ACMPHS0_Type *) R_ACMPHS2_BASE)
 #define R_ACMPHS3        ((R_ACMPHS0_Type *) R_ACMPHS3_BASE)
 #define R_ACMPHS4        ((R_ACMPHS0_Type *) R_ACMPHS4_BASE)
 #define R_ACMPHS5        ((R_ACMPHS0_Type *) R_ACMPHS5_BASE)
 #define R_ADC0           ((R_ADC0_Type *) R_ADC0_BASE)
 #define R_ADC1           ((R_ADC0_Type *) R_ADC1_BASE)
 #define R_PSCU           ((R_PSCU_Type *) R_PSCU_BASE)

/* #define R_BUS                       ((R_BUS_Type*)             R_BUS_BASE) */
 #define R_CAC            ((R_CAC_Type *) R_CAC_BASE)
 #define R_CANFD          ((R_CANFD_Type *) R_CANFD_BASE)
 #define R_CANFD0         ((R_CANFD_Type *) R_CANFD_BASE)
 #define R_CANFD1         ((R_CANFD_Type *) R_CANFD1_BASE)
 #define R_CRC            ((R_CRC_Type *) R_CRC_BASE)
 #define R_DAC            ((R_DAC_Type *) R_DAC_BASE)
 #define R_DEBUG          ((R_DEBUG_Type *) R_DEBUG_BASE)
 #define R_DMA            ((R_DMA_Type *) R_DMA_BASE)
 #define R_DMAC0          ((R_DMAC0_Type *) R_DMAC0_BASE)
 #define R_DMAC1          ((R_DMAC0_Type *) R_DMAC1_BASE)
 #define R_DMAC2          ((R_DMAC0_Type *) R_DMAC2_BASE)
 #define R_DMAC3          ((R_DMAC0_Type *) R_DMAC3_BASE)
 #define R_DMAC4          ((R_DMAC0_Type *) R_DMAC4_BASE)
 #define R_DMAC5          ((R_DMAC0_Type *) R_DMAC5_BASE)
 #define R_DMAC6          ((R_DMAC0_Type *) R_DMAC6_BASE)
 #define R_DMAC7          ((R_DMAC0_Type *) R_DMAC7_BASE)
 #define R_DOC            ((R_DOC_Type *) R_DOC_BASE)
 #define R_DTC            ((R_DTC_Type *) R_DTC_BASE)
 #define R_ELC            ((R_ELC_Type *) R_ELC_BASE)
 #define R_FACI_HP_CMD    ((R_FACI_HP_CMD_Type *) R_FACI_HP_CMD_BASE)
 #define R_FACI_HP        ((R_FACI_HP_Type *) R_FACI_HP_BASE)
 #define R_FCACHE         ((R_FCACHE_Type *) R_FCACHE_BASE)
 #define R_GPT0           ((R_GPT0_Type *) R_GPT0_BASE)
 #define R_GPT1           ((R_GPT0_Type *) R_GPT1_BASE)
 #define R_GPT2           ((R_GPT0_Type *) R_GPT2_BASE)
 #define R_GPT3           ((R_GPT0_Type *) R_GPT3_BASE)
 #define R_GPT4           ((R_GPT0_Type *) R_GPT4_BASE)
 #define R_GPT5           ((R_GPT0_Type *) R_GPT5_BASE)
 #define R_GPT6           ((R_GPT0_Type *) R_GPT6_BASE)
 #define R_GPT7           ((R_GPT0_Type *) R_GPT7_BASE)
 #define R_GPT8           ((R_GPT0_Type *) R_GPT8_BASE)
 #define R_GPT9           ((R_GPT0_Type *) R_GPT9_BASE)
 #define R_GPT10          ((R_GPT0_Type *) R_GPT10_BASE)
 #define R_GPT11          ((R_GPT0_Type *) R_GPT11_BASE)
 #define R_GPT12          ((R_GPT0_Type *) R_GPT12_BASE)
 #define R_GPT13          ((R_GPT0_Type *) R_GPT13_BASE)
 #define R_GPT_OPS        ((R_GPT_OPS_Type *) R_GPT_OPS_BASE)
 #define R_GPT_POEG0      ((R_GPT_POEG0_Type *) R_GPT_POEG0_BASE)
 #define R_GPT_POEG1      ((R_GPT_POEG0_Type *) R_GPT_POEG1_BASE)
 #define R_GPT_POEG2      ((R_GPT_POEG0_Type *) R_GPT_POEG2_BASE)
 #define R_GPT_POEG3      ((R_GPT_POEG0_Type *) R_GPT_POEG3_BASE)
 #define R_ICU            ((R_ICU_Type *) R_ICU_BASE)
 #define R_IIC0           ((R_IIC0_Type *) R_IIC0_BASE)
 #define R_IIC1           ((R_IIC0_Type *) R_IIC1_BASE)
 #define R_IIC2           ((R_IIC0_Type *) R_IIC2_BASE)
 #define R_IWDT           ((R_IWDT_Type *) R_IWDT_BASE)
 #define R_I3C0           ((R_I3C0_Type *) R_I3C0_BASE)
 #define R_I3C1           ((R_I3C0_Type *) R_I3C1_BASE)
 #define R_MPU_MMPU       ((R_MPU_MMPU_Type *) R_MPU_MMPU_BASE)
 #define R_MPU_SMPU       ((R_MPU_SMPU_Type *) R_MPU_SMPU_BASE)
 #define R_MPU_SPMON      ((R_MPU_SPMON_Type *) R_MPU_SPMON_BASE)
 #define R_MSTP           ((R_MSTP_Type *) R_MSTP_BASE)
 #define R_PORT0          ((R_PORT0_Type *) R_PORT0_BASE)
 #define R_PORT1          ((R_PORT0_Type *) R_PORT1_BASE)
 #define R_PORT2          ((R_PORT0_Type *) R_PORT2_BASE)
 #define R_PORT3          ((R_PORT0_Type *) R_PORT3_BASE)
 #define R_PORT4          ((R_PORT0_Type *) R_PORT4_BASE)
 #define R_PORT5          ((R_PORT0_Type *) R_PORT5_BASE)
 #define R_PORT6          ((R_PORT0_Type *) R_PORT6_BASE)
 #define R_PORT7          ((R_PORT0_Type *) R_PORT7_BASE)
 #define R_PORT8          ((R_PORT0_Type *) R_PORT8_BASE)
 #define R_PORT9          ((R_PORT0_Type *) R_PORT9_BASE)
 #define R_PORT10         ((R_PORT0_Type *) R_PORT10_BASE)
 #define R_PORT11         ((R_PORT0_Type *) R_PORT11_BASE)
 #define R_PORT12         ((R_PORT0_Type *) R_PORT12_BASE)
 #define R_PORT13         ((R_PORT0_Type *) R_PORT13_BASE)
 #define R_PORT14         ((R_PORT0_Type *) R_PORT14_BASE)
 #define R_PFS            ((R_PFS_Type *) R_PFS_BASE)
 #define R_PMISC          ((R_PMISC_Type *) R_PMISC_BASE)
 #define R_RTC            ((R_RTC_Type *) R_RTC_BASE)
 #define R_SCI0           ((R_SCI0_Type *) R_SCI0_BASE)
 #define R_SCI1           ((R_SCI0_Type *) R_SCI1_BASE)
 #define R_SCI2           ((R_SCI0_Type *) R_SCI2_BASE)
 #define R_SCI3           ((R_SCI0_Type *) R_SCI3_BASE)
 #define R_SCI4           ((R_SCI0_Type *) R_SCI4_BASE)
 #define R_SCI5           ((R_SCI0_Type *) R_SCI5_BASE)
 #define R_SCI6           ((R_SCI0_Type *) R_SCI6_BASE)
 #define R_SCI7           ((R_SCI0_Type *) R_SCI7_BASE)
 #define R_SCI8           ((R_SCI0_Type *) R_SCI8_BASE)
 #define R_SCI9           ((R_SCI0_Type *) R_SCI9_BASE)
 #define R_SPI0           ((R_SPI0_Type *) R_SPI0_BASE)
 #define R_SPI1           ((R_SPI0_Type *) R_SPI1_BASE)
 #define R_SRAM           ((R_SRAM_Type *) R_SRAM_BASE)
 #define R_BUS            ((R_BUS_B_Type *) R_BUS_B_BASE)
 #define R_SYSTEM         ((R_SYSTEM_Type *) R_SYSTEM_BASE)
 #define R_TRNG           ((R_TRNG_Type *) R_TRNG_BASE)
 #define R_TSN_CAL        ((R_TSN_CAL_Type *) R_TSN_CAL_BASE)
 #define R_TSN_CTRL       ((R_TSN_CTRL_Type *) R_TSN_CTRL_BASE)
 #define R_USB_FS0        ((R_USB_FS0_Type *) R_USB_FS0_BASE)
 #define R_WDT            ((R_WDT_Type *) R_WDT_BASE)
 #define R_TZF            ((R_TZF_Type *) R_TZF_BASE)
 #define R_CACHE          ((R_CACHE_Type *) R_CACHE_BASE)
 #define R_CPSCU          ((R_CPSCU_Type *) R_CPSCU_BASE)
 #define R_TFU            ((R_TFU_Type *) R_TFU_BASE)
 #define R_AGTX0          ((R_AGTX0_Type *) R_AGTX0_BASE)
 #define R_AGTX1          ((R_AGTX0_Type *) R_AGTX1_BASE)
 #define R_AGTX2          ((R_AGTX0_Type *) R_AGTX2_BASE)
 #define R_AGTX3          ((R_AGTX0_Type *) R_AGTX3_BASE)
 #define R_AGTX4          ((R_AGTX0_Type *) R_AGTX4_BASE)
 #define R_AGTX5          ((R_AGTX0_Type *) R_AGTX5_BASE)
 #define R_AGTX6          ((R_AGTX0_Type *) R_AGTX6_BASE)
 #define R_AGTX7          ((R_AGTX0_Type *) R_AGTX7_BASE)
 #define R_AGTX8          ((R_AGTX0_Type *) R_AGTX8_BASE)
 #define R_AGTX9          ((R_AGTX0_Type *) R_AGTX9_BASE)
 #define R_FLAD           ((R_FLAD_Type *) R_FLAD_BASE)

/** @} */ /* End of group Device_Peripheral_declaration */

/* =========================================  End of section using anonymous unions  ========================================= */
 #if defined(__CC_ARM)
  #pragma pop
 #elif defined(__ICCARM__)

/* leave anonymous unions enabled */
 #elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic pop
 #elif defined(__GNUC__)

/* anonymous unions are enabled by default */
 #elif defined(__TMS470__)

/* anonymous unions are enabled by default */
 #elif defined(__TASKING__)
  #pragma warning restore
 #elif defined(__CSMC__)

/* anonymous unions are enabled by default */
 #endif

/* =========================================================================================================================== */
/* ================                                 Pos/Mask Cluster Section                                  ================ */
/* =========================================================================================================================== */

/** @addtogroup PosMask_clusters
 * @{
 */

/* =========================================================================================================================== */
/* ================                                            CSa                                            ================ */
/* =========================================================================================================================== */

/* ==========================================================  MOD  ========================================================== */
 #define R_BUS_CSa_MOD_PRMOD_Pos        (15UL)         /*!< PRMOD (Bit 15)                                        */
 #define R_BUS_CSa_MOD_PRMOD_Msk        (0x8000UL)     /*!< PRMOD (Bitfield-Mask: 0x01)                           */
 #define R_BUS_CSa_MOD_PWENB_Pos        (9UL)          /*!< PWENB (Bit 9)                                         */
 #define R_BUS_CSa_MOD_PWENB_Msk        (0x200UL)      /*!< PWENB (Bitfield-Mask: 0x01)                           */
 #define R_BUS_CSa_MOD_PRENB_Pos        (8UL)          /*!< PRENB (Bit 8)                                         */
 #define R_BUS_CSa_MOD_PRENB_Msk        (0x100UL)      /*!< PRENB (Bitfield-Mask: 0x01)                           */
 #define R_BUS_CSa_MOD_EWENB_Pos        (3UL)          /*!< EWENB (Bit 3)                                         */
 #define R_BUS_CSa_MOD_EWENB_Msk        (0x8UL)        /*!< EWENB (Bitfield-Mask: 0x01)                           */
 #define R_BUS_CSa_MOD_WRMOD_Pos        (0UL)          /*!< WRMOD (Bit 0)                                         */
 #define R_BUS_CSa_MOD_WRMOD_Msk        (0x1UL)        /*!< WRMOD (Bitfield-Mask: 0x01)                           */
/* =========================================================  WCR1  ========================================================== */
 #define R_BUS_CSa_WCR1_CSRWAIT_Pos     (24UL)         /*!< CSRWAIT (Bit 24)                                      */
 #define R_BUS_CSa_WCR1_CSRWAIT_Msk     (0x1f000000UL) /*!< CSRWAIT (Bitfield-Mask: 0x1f)                         */
 #define R_BUS_CSa_WCR1_CSWWAIT_Pos     (16UL)         /*!< CSWWAIT (Bit 16)                                      */
 #define R_BUS_CSa_WCR1_CSWWAIT_Msk     (0x1f0000UL)   /*!< CSWWAIT (Bitfield-Mask: 0x1f)                         */
 #define R_BUS_CSa_WCR1_CSPRWAIT_Pos    (8UL)          /*!< CSPRWAIT (Bit 8)                                      */
 #define R_BUS_CSa_WCR1_CSPRWAIT_Msk    (0x700UL)      /*!< CSPRWAIT (Bitfield-Mask: 0x07)                        */
 #define R_BUS_CSa_WCR1_CSPWWAIT_Pos    (0UL)          /*!< CSPWWAIT (Bit 0)                                      */
 #define R_BUS_CSa_WCR1_CSPWWAIT_Msk    (0x7UL)        /*!< CSPWWAIT (Bitfield-Mask: 0x07)                        */
/* =========================================================  WCR2  ========================================================== */
 #define R_BUS_CSa_WCR2_CSON_Pos        (28UL)         /*!< CSON (Bit 28)                                         */
 #define R_BUS_CSa_WCR2_CSON_Msk        (0x70000000UL) /*!< CSON (Bitfield-Mask: 0x07)                            */
 #define R_BUS_CSa_WCR2_WDON_Pos        (24UL)         /*!< WDON (Bit 24)                                         */
 #define R_BUS_CSa_WCR2_WDON_Msk        (0x7000000UL)  /*!< WDON (Bitfield-Mask: 0x07)                            */
 #define R_BUS_CSa_WCR2_WRON_Pos        (20UL)         /*!< WRON (Bit 20)                                         */
 #define R_BUS_CSa_WCR2_WRON_Msk        (0x700000UL)   /*!< WRON (Bitfield-Mask: 0x07)                            */
 #define R_BUS_CSa_WCR2_RDON_Pos        (16UL)         /*!< RDON (Bit 16)                                         */
 #define R_BUS_CSa_WCR2_RDON_Msk        (0x70000UL)    /*!< RDON (Bitfield-Mask: 0x07)                            */
 #define R_BUS_CSa_WCR2_AWAIT_Pos       (12UL)         /*!< AWAIT (Bit 12)                                        */
 #define R_BUS_CSa_WCR2_AWAIT_Msk       (0x3000UL)     /*!< AWAIT (Bitfield-Mask: 0x03)                           */
 #define R_BUS_CSa_WCR2_WDOFF_Pos       (8UL)          /*!< WDOFF (Bit 8)                                         */
 #define R_BUS_CSa_WCR2_WDOFF_Msk       (0x700UL)      /*!< WDOFF (Bitfield-Mask: 0x07)                           */
 #define R_BUS_CSa_WCR2_CSWOFF_Pos      (4UL)          /*!< CSWOFF (Bit 4)                                        */
 #define R_BUS_CSa_WCR2_CSWOFF_Msk      (0x70UL)       /*!< CSWOFF (Bitfield-Mask: 0x07)                          */
 #define R_BUS_CSa_WCR2_CSROFF_Pos      (0UL)          /*!< CSROFF (Bit 0)                                        */
 #define R_BUS_CSa_WCR2_CSROFF_Msk      (0x7UL)        /*!< CSROFF (Bitfield-Mask: 0x07)                          */

/* =========================================================================================================================== */
/* ================                                            CSb                                            ================ */
/* =========================================================================================================================== */

/* ==========================================================  CR  =========================================================== */
 #define R_BUS_CSb_CR_MPXEN_Pos    (12UL)     /*!< MPXEN (Bit 12)                                        */
 #define R_BUS_CSb_CR_MPXEN_Msk    (0x1000UL) /*!< MPXEN (Bitfield-Mask: 0x01)                           */
 #define R_BUS_CSb_CR_EMODE_Pos    (8UL)      /*!< EMODE (Bit 8)                                         */
 #define R_BUS_CSb_CR_EMODE_Msk    (0x100UL)  /*!< EMODE (Bitfield-Mask: 0x01)                           */
 #define R_BUS_CSb_CR_BSIZE_Pos    (4UL)      /*!< BSIZE (Bit 4)                                         */
 #define R_BUS_CSb_CR_BSIZE_Msk    (0x30UL)   /*!< BSIZE (Bitfield-Mask: 0x03)                           */
 #define R_BUS_CSb_CR_EXENB_Pos    (0UL)      /*!< EXENB (Bit 0)                                         */
 #define R_BUS_CSb_CR_EXENB_Msk    (0x1UL)    /*!< EXENB (Bitfield-Mask: 0x01)                           */
/* ==========================================================  REC  ========================================================== */
 #define R_BUS_CSb_REC_WRCV_Pos    (8UL)      /*!< WRCV (Bit 8)                                          */
 #define R_BUS_CSb_REC_WRCV_Msk    (0xf00UL)  /*!< WRCV (Bitfield-Mask: 0x0f)                            */
 #define R_BUS_CSb_REC_RRCV_Pos    (0UL)      /*!< RRCV (Bit 0)                                          */
 #define R_BUS_CSb_REC_RRCV_Msk    (0xfUL)    /*!< RRCV (Bitfield-Mask: 0x0f)                            */

/* =========================================================================================================================== */
/* ================                                           SDRAM                                           ================ */
/* =========================================================================================================================== */

/* =========================================================  SDCCR  ========================================================= */
 #define R_BUS_SDRAM_SDCCR_BSIZE_Pos     (4UL)       /*!< BSIZE (Bit 4)                                         */
 #define R_BUS_SDRAM_SDCCR_BSIZE_Msk     (0x30UL)    /*!< BSIZE (Bitfield-Mask: 0x03)                           */
 #define R_BUS_SDRAM_SDCCR_EXENB_Pos     (0UL)       /*!< EXENB (Bit 0)                                         */
 #define R_BUS_SDRAM_SDCCR_EXENB_Msk     (0x1UL)     /*!< EXENB (Bitfield-Mask: 0x01)                           */
/* ========================================================  SDCMOD  ========================================================= */
 #define R_BUS_SDRAM_SDCMOD_EMODE_Pos    (0UL)       /*!< EMODE (Bit 0)                                         */
 #define R_BUS_SDRAM_SDCMOD_EMODE_Msk    (0x1UL)     /*!< EMODE (Bitfield-Mask: 0x01)                           */
/* ========================================================  SDAMOD  ========================================================= */
 #define R_BUS_SDRAM_SDAMOD_BE_Pos       (0UL)       /*!< BE (Bit 0)                                            */
 #define R_BUS_SDRAM_SDAMOD_BE_Msk       (0x1UL)     /*!< BE (Bitfield-Mask: 0x01)                              */
/* ========================================================  SDSELF  ========================================================= */
 #define R_BUS_SDRAM_SDSELF_SFEN_Pos     (0UL)       /*!< SFEN (Bit 0)                                          */
 #define R_BUS_SDRAM_SDSELF_SFEN_Msk     (0x1UL)     /*!< SFEN (Bitfield-Mask: 0x01)                            */
/* ========================================================  SDRFCR  ========================================================= */
 #define R_BUS_SDRAM_SDRFCR_REFW_Pos     (12UL)      /*!< REFW (Bit 12)                                         */
 #define R_BUS_SDRAM_SDRFCR_REFW_Msk     (0xf000UL)  /*!< REFW (Bitfield-Mask: 0x0f)                            */
 #define R_BUS_SDRAM_SDRFCR_RFC_Pos      (0UL)       /*!< RFC (Bit 0)                                           */
 #define R_BUS_SDRAM_SDRFCR_RFC_Msk      (0xfffUL)   /*!< RFC (Bitfield-Mask: 0xfff)                            */
/* ========================================================  SDRFEN  ========================================================= */
 #define R_BUS_SDRAM_SDRFEN_RFEN_Pos     (0UL)       /*!< RFEN (Bit 0)                                          */
 #define R_BUS_SDRAM_SDRFEN_RFEN_Msk     (0x1UL)     /*!< RFEN (Bitfield-Mask: 0x01)                            */
/* =========================================================  SDICR  ========================================================= */
 #define R_BUS_SDRAM_SDICR_INIRQ_Pos     (0UL)       /*!< INIRQ (Bit 0)                                         */
 #define R_BUS_SDRAM_SDICR_INIRQ_Msk     (0x1UL)     /*!< INIRQ (Bitfield-Mask: 0x01)                           */
/* =========================================================  SDIR  ========================================================== */
 #define R_BUS_SDRAM_SDIR_PRC_Pos        (8UL)       /*!< PRC (Bit 8)                                           */
 #define R_BUS_SDRAM_SDIR_PRC_Msk        (0x700UL)   /*!< PRC (Bitfield-Mask: 0x07)                             */
 #define R_BUS_SDRAM_SDIR_ARFC_Pos       (4UL)       /*!< ARFC (Bit 4)                                          */
 #define R_BUS_SDRAM_SDIR_ARFC_Msk       (0xf0UL)    /*!< ARFC (Bitfield-Mask: 0x0f)                            */
 #define R_BUS_SDRAM_SDIR_ARFI_Pos       (0UL)       /*!< ARFI (Bit 0)                                          */
 #define R_BUS_SDRAM_SDIR_ARFI_Msk       (0xfUL)     /*!< ARFI (Bitfield-Mask: 0x0f)                            */
/* =========================================================  SDADR  ========================================================= */
 #define R_BUS_SDRAM_SDADR_MXC_Pos       (0UL)       /*!< MXC (Bit 0)                                           */
 #define R_BUS_SDRAM_SDADR_MXC_Msk       (0x3UL)     /*!< MXC (Bitfield-Mask: 0x03)                             */
/* =========================================================  SDTR  ========================================================== */
 #define R_BUS_SDRAM_SDTR_RAS_Pos        (16UL)      /*!< RAS (Bit 16)                                          */
 #define R_BUS_SDRAM_SDTR_RAS_Msk        (0x70000UL) /*!< RAS (Bitfield-Mask: 0x07)                             */
 #define R_BUS_SDRAM_SDTR_RCD_Pos        (12UL)      /*!< RCD (Bit 12)                                          */
 #define R_BUS_SDRAM_SDTR_RCD_Msk        (0x3000UL)  /*!< RCD (Bitfield-Mask: 0x03)                             */
 #define R_BUS_SDRAM_SDTR_RP_Pos         (9UL)       /*!< RP (Bit 9)                                            */
 #define R_BUS_SDRAM_SDTR_RP_Msk         (0xe00UL)   /*!< RP (Bitfield-Mask: 0x07)                              */
 #define R_BUS_SDRAM_SDTR_WR_Pos         (8UL)       /*!< WR (Bit 8)                                            */
 #define R_BUS_SDRAM_SDTR_WR_Msk         (0x100UL)   /*!< WR (Bitfield-Mask: 0x01)                              */
 #define R_BUS_SDRAM_SDTR_CL_Pos         (0UL)       /*!< CL (Bit 0)                                            */
 #define R_BUS_SDRAM_SDTR_CL_Msk         (0x7UL)     /*!< CL (Bitfield-Mask: 0x07)                              */
/* =========================================================  SDMOD  ========================================================= */
 #define R_BUS_SDRAM_SDMOD_MR_Pos        (0UL)       /*!< MR (Bit 0)                                            */
 #define R_BUS_SDRAM_SDMOD_MR_Msk        (0x7fffUL)  /*!< MR (Bitfield-Mask: 0x7fff)                            */
/* =========================================================  SDSR  ========================================================== */
 #define R_BUS_SDRAM_SDSR_SRFST_Pos      (4UL)       /*!< SRFST (Bit 4)                                         */
 #define R_BUS_SDRAM_SDSR_SRFST_Msk      (0x10UL)    /*!< SRFST (Bitfield-Mask: 0x01)                           */
 #define R_BUS_SDRAM_SDSR_INIST_Pos      (3UL)       /*!< INIST (Bit 3)                                         */
 #define R_BUS_SDRAM_SDSR_INIST_Msk      (0x8UL)     /*!< INIST (Bitfield-Mask: 0x01)                           */
 #define R_BUS_SDRAM_SDSR_MRSST_Pos      (0UL)       /*!< MRSST (Bit 0)                                         */
 #define R_BUS_SDRAM_SDSR_MRSST_Msk      (0x1UL)     /*!< MRSST (Bitfield-Mask: 0x01)                           */

/* =========================================================================================================================== */
/* ================                                          BUSERR                                           ================ */
/* =========================================================================================================================== */

/* ==========================================================  ADD  ========================================================== */
 #define R_BUS_BUSERR_ADD_BERAD_Pos       (0UL)          /*!< BERAD (Bit 0)                                         */
 #define R_BUS_BUSERR_ADD_BERAD_Msk       (0xffffffffUL) /*!< BERAD (Bitfield-Mask: 0xffffffff)                     */
/* =========================================================  STAT  ========================================================== */
 #define R_BUS_BUSERR_STAT_ERRSTAT_Pos    (7UL)          /*!< ERRSTAT (Bit 7)                                       */
 #define R_BUS_BUSERR_STAT_ERRSTAT_Msk    (0x80UL)       /*!< ERRSTAT (Bitfield-Mask: 0x01)                         */
 #define R_BUS_BUSERR_STAT_ACCSTAT_Pos    (0UL)          /*!< ACCSTAT (Bit 0)                                       */
 #define R_BUS_BUSERR_STAT_ACCSTAT_Msk    (0x1UL)        /*!< ACCSTAT (Bitfield-Mask: 0x01)                         */

/* =========================================================================================================================== */
/* ================                                           BUSM                                            ================ */
/* =========================================================================================================================== */

/* ==========================================================  CNT  ========================================================== */
 #define R_BUS_BUSM_CNT_IERES_Pos    (15UL)     /*!< IERES (Bit 15)                                        */
 #define R_BUS_BUSM_CNT_IERES_Msk    (0x8000UL) /*!< IERES (Bitfield-Mask: 0x01)                           */

/* =========================================================================================================================== */
/* ================                                           BUSS                                            ================ */
/* =========================================================================================================================== */

/* ==========================================================  CNT  ========================================================== */
 #define R_BUS_BUSS_CNT_ARBMET_Pos    (4UL)    /*!< ARBMET (Bit 4)                                        */
 #define R_BUS_BUSS_CNT_ARBMET_Msk    (0x30UL) /*!< ARBMET (Bitfield-Mask: 0x03)                          */

/* =========================================================================================================================== */
/* ================                                           CFDC                                            ================ */
/* =========================================================================================================================== */

/* =========================================================  NCFG  ========================================================== */
 #define R_CANFD_CFDC_NCFG_NBRP_Pos      (0UL)          /*!< NBRP (Bit 0)                                          */
 #define R_CANFD_CFDC_NCFG_NBRP_Msk      (0x3ffUL)      /*!< NBRP (Bitfield-Mask: 0x3ff)                           */
 #define R_CANFD_CFDC_NCFG_NSJW_Pos      (10UL)         /*!< NSJW (Bit 10)                                         */
 #define R_CANFD_CFDC_NCFG_NSJW_Msk      (0x1fc00UL)    /*!< NSJW (Bitfield-Mask: 0x7f)                            */
 #define R_CANFD_CFDC_NCFG_NTSEG1_Pos    (17UL)         /*!< NTSEG1 (Bit 17)                                       */
 #define R_CANFD_CFDC_NCFG_NTSEG1_Msk    (0x1fe0000UL)  /*!< NTSEG1 (Bitfield-Mask: 0xff)                          */
 #define R_CANFD_CFDC_NCFG_NTSEG2_Pos    (25UL)         /*!< NTSEG2 (Bit 25)                                       */
 #define R_CANFD_CFDC_NCFG_NTSEG2_Msk    (0xfe000000UL) /*!< NTSEG2 (Bitfield-Mask: 0x7f)                          */
/* ==========================================================  CTR  ========================================================== */
 #define R_CANFD_CFDC_CTR_CHMDC_Pos      (0UL)          /*!< CHMDC (Bit 0)                                         */
 #define R_CANFD_CFDC_CTR_CHMDC_Msk      (0x3UL)        /*!< CHMDC (Bitfield-Mask: 0x03)                           */
 #define R_CANFD_CFDC_CTR_CSLPR_Pos      (2UL)          /*!< CSLPR (Bit 2)                                         */
 #define R_CANFD_CFDC_CTR_CSLPR_Msk      (0x4UL)        /*!< CSLPR (Bitfield-Mask: 0x01)                           */
 #define R_CANFD_CFDC_CTR_RTBO_Pos       (3UL)          /*!< RTBO (Bit 3)                                          */
 #define R_CANFD_CFDC_CTR_RTBO_Msk       (0x8UL)        /*!< RTBO (Bitfield-Mask: 0x01)                            */
 #define R_CANFD_CFDC_CTR_BEIE_Pos       (8UL)          /*!< BEIE (Bit 8)                                          */
 #define R_CANFD_CFDC_CTR_BEIE_Msk       (0x100UL)      /*!< BEIE (Bitfield-Mask: 0x01)                            */
 #define R_CANFD_CFDC_CTR_EWIE_Pos       (9UL)          /*!< EWIE (Bit 9)                                          */
 #define R_CANFD_CFDC_CTR_EWIE_Msk       (0x200UL)      /*!< EWIE (Bitfield-Mask: 0x01)                            */
 #define R_CANFD_CFDC_CTR_EPIE_Pos       (10UL)         /*!< EPIE (Bit 10)                                         */
 #define R_CANFD_CFDC_CTR_EPIE_Msk       (0x400UL)      /*!< EPIE (Bitfield-Mask: 0x01)                            */
 #define R_CANFD_CFDC_CTR_BOEIE_Pos      (11UL)         /*!< BOEIE (Bit 11)                                        */
 #define R_CANFD_CFDC_CTR_BOEIE_Msk      (0x800UL)      /*!< BOEIE (Bitfield-Mask: 0x01)                           */
 #define R_CANFD_CFDC_CTR_BORIE_Pos      (12UL)         /*!< BORIE (Bit 12)                                        */
 #define R_CANFD_CFDC_CTR_BORIE_Msk      (0x1000UL)     /*!< BORIE (Bitfield-Mask: 0x01)                           */
 #define R_CANFD_CFDC_CTR_OLIE_Pos       (13UL)         /*!< OLIE (Bit 13)                                         */
 #define R_CANFD_CFDC_CTR_OLIE_Msk       (0x2000UL)     /*!< OLIE (Bitfield-Mask: 0x01)                            */
 #define R_CANFD_CFDC_CTR_BLIE_Pos       (14UL)         /*!< BLIE (Bit 14)                                         */
 #define R_CANFD_CFDC_CTR_BLIE_Msk       (0x4000UL)     /*!< BLIE (Bitfield-Mask: 0x01)                            */
 #define R_CANFD_CFDC_CTR_ALIE_Pos       (15UL)         /*!< ALIE (Bit 15)                                         */
 #define R_CANFD_CFDC_CTR_ALIE_Msk       (0x8000UL)     /*!< ALIE (Bitfield-Mask: 0x01)                            */
 #define R_CANFD_CFDC_CTR_TAIE_Pos       (16UL)         /*!< TAIE (Bit 16)                                         */
 #define R_CANFD_CFDC_CTR_TAIE_Msk       (0x10000UL)    /*!< TAIE (Bitfield-Mask: 0x01)                            */
 #define R_CANFD_CFDC_CTR_EOCOIE_Pos     (17UL)         /*!< EOCOIE (Bit 17)                                       */
 #define R_CANFD_CFDC_CTR_EOCOIE_Msk     (0x20000UL)    /*!< EOCOIE (Bitfield-Mask: 0x01)                          */
 #define R_CANFD_CFDC_CTR_SOCOIE_Pos     (18UL)         /*!< SOCOIE (Bit 18)                                       */
 #define R_CANFD_CFDC_CTR_SOCOIE_Msk     (0x40000UL)    /*!< SOCOIE (Bitfield-Mask: 0x01)                          */
 #define R_CANFD_CFDC_CTR_TDCVFIE_Pos    (19UL)         /*!< TDCVFIE (Bit 19)                                      */
 #define R_CANFD_CFDC_CTR_TDCVFIE_Msk    (0x80000UL)    /*!< TDCVFIE (Bitfield-Mask: 0x01)                         */
 #define R_CANFD_CFDC_CTR_BOM_Pos        (21UL)         /*!< BOM (Bit 21)                                          */
 #define R_CANFD_CFDC_CTR_BOM_Msk        (0x600000UL)   /*!< BOM (Bitfield-Mask: 0x03)                             */
 #define R_CANFD_CFDC_CTR_ERRD_Pos       (23UL)         /*!< ERRD (Bit 23)                                         */
 #define R_CANFD_CFDC_CTR_ERRD_Msk       (0x800000UL)   /*!< ERRD (Bitfield-Mask: 0x01)                            */
 #define R_CANFD_CFDC_CTR_CTME_Pos       (24UL)         /*!< CTME (Bit 24)                                         */
 #define R_CANFD_CFDC_CTR_CTME_Msk       (0x1000000UL)  /*!< CTME (Bitfield-Mask: 0x01)                            */
 #define R_CANFD_CFDC_CTR_CTMS_Pos       (25UL)         /*!< CTMS (Bit 25)                                         */
 #define R_CANFD_CFDC_CTR_CTMS_Msk       (0x6000000UL)  /*!< CTMS (Bitfield-Mask: 0x03)                            */
 #define R_CANFD_CFDC_CTR_CRCT_Pos       (30UL)         /*!< CRCT (Bit 30)                                         */
 #define R_CANFD_CFDC_CTR_CRCT_Msk       (0x40000000UL) /*!< CRCT (Bitfield-Mask: 0x01)                            */
 #define R_CANFD_CFDC_CTR_ROM_Pos        (31UL)         /*!< ROM (Bit 31)                                          */
 #define R_CANFD_CFDC_CTR_ROM_Msk        (0x80000000UL) /*!< ROM (Bitfield-Mask: 0x01)                             */
/* ==========================================================  STS  ========================================================== */
 #define R_CANFD_CFDC_STS_CRSTSTS_Pos    (0UL)          /*!< CRSTSTS (Bit 0)                                       */
 #define R_CANFD_CFDC_STS_CRSTSTS_Msk    (0x1UL)        /*!< CRSTSTS (Bitfield-Mask: 0x01)                         */
 #define R_CANFD_CFDC_STS_CHLTSTS_Pos    (1UL)          /*!< CHLTSTS (Bit 1)                                       */
 #define R_CANFD_CFDC_STS_CHLTSTS_Msk    (0x2UL)        /*!< CHLTSTS (Bitfield-Mask: 0x01)                         */
 #define R_CANFD_CFDC_STS_CSLPSTS_Pos    (2UL)          /*!< CSLPSTS (Bit 2)                                       */
 #define R_CANFD_CFDC_STS_CSLPSTS_Msk    (0x4UL)        /*!< CSLPSTS (Bitfield-Mask: 0x01)                         */
 #define R_CANFD_CFDC_STS_EPSTS_Pos      (3UL)          /*!< EPSTS (Bit 3)                                         */
 #define R_CANFD_CFDC_STS_EPSTS_Msk      (0x8UL)        /*!< EPSTS (Bitfield-Mask: 0x01)                           */
 #define R_CANFD_CFDC_STS_BOSTS_Pos      (4UL)          /*!< BOSTS (Bit 4)                                         */
 #define R_CANFD_CFDC_STS_BOSTS_Msk      (0x10UL)       /*!< BOSTS (Bitfield-Mask: 0x01)                           */
 #define R_CANFD_CFDC_STS_TRMSTS_Pos     (5UL)          /*!< TRMSTS (Bit 5)                                        */
 #define R_CANFD_CFDC_STS_TRMSTS_Msk     (0x20UL)       /*!< TRMSTS (Bitfield-Mask: 0x01)                          */
 #define R_CANFD_CFDC_STS_RECSTS_Pos     (6UL)          /*!< RECSTS (Bit 6)                                        */
 #define R_CANFD_CFDC_STS_RECSTS_Msk     (0x40UL)       /*!< RECSTS (Bitfield-Mask: 0x01)                          */
 #define R_CANFD_CFDC_STS_COMSTS_Pos     (7UL)          /*!< COMSTS (Bit 7)                                        */
 #define R_CANFD_CFDC_STS_COMSTS_Msk     (0x80UL)       /*!< COMSTS (Bitfield-Mask: 0x01)                          */
 #define R_CANFD_CFDC_STS_ESIF_Pos       (8UL)          /*!< ESIF (Bit 8)                                          */
 #define R_CANFD_CFDC_STS_ESIF_Msk       (0x100UL)      /*!< ESIF (Bitfield-Mask: 0x01)                            */
 #define R_CANFD_CFDC_STS_REC_Pos        (16UL)         /*!< REC (Bit 16)                                          */
 #define R_CANFD_CFDC_STS_REC_Msk        (0xff0000UL)   /*!< REC (Bitfield-Mask: 0xff)                             */
 #define R_CANFD_CFDC_STS_TEC_Pos        (24UL)         /*!< TEC (Bit 24)                                          */
 #define R_CANFD_CFDC_STS_TEC_Msk        (0xff000000UL) /*!< TEC (Bitfield-Mask: 0xff)                             */
/* =========================================================  ERFL  ========================================================== */
 #define R_CANFD_CFDC_ERFL_BEF_Pos       (0UL)          /*!< BEF (Bit 0)                                           */
 #define R_CANFD_CFDC_ERFL_BEF_Msk       (0x1UL)        /*!< BEF (Bitfield-Mask: 0x01)                             */
 #define R_CANFD_CFDC_ERFL_EWF_Pos       (1UL)          /*!< EWF (Bit 1)                                           */
 #define R_CANFD_CFDC_ERFL_EWF_Msk       (0x2UL)        /*!< EWF (Bitfield-Mask: 0x01)                             */
 #define R_CANFD_CFDC_ERFL_EPF_Pos       (2UL)          /*!< EPF (Bit 2)                                           */
 #define R_CANFD_CFDC_ERFL_EPF_Msk       (0x4UL)        /*!< EPF (Bitfield-Mask: 0x01)                             */
 #define R_CANFD_CFDC_ERFL_BOEF_Pos      (3UL)          /*!< BOEF (Bit 3)                                          */
 #define R_CANFD_CFDC_ERFL_BOEF_Msk      (0x8UL)        /*!< BOEF (Bitfield-Mask: 0x01)                            */
 #define R_CANFD_CFDC_ERFL_BORF_Pos      (4UL)          /*!< BORF (Bit 4)                                          */
 #define R_CANFD_CFDC_ERFL_BORF_Msk      (0x10UL)       /*!< BORF (Bitfield-Mask: 0x01)                            */
 #define R_CANFD_CFDC_ERFL_OVLF_Pos      (5UL)          /*!< OVLF (Bit 5)                                          */
 #define R_CANFD_CFDC_ERFL_OVLF_Msk      (0x20UL)       /*!< OVLF (Bitfield-Mask: 0x01)                            */
 #define R_CANFD_CFDC_ERFL_BLF_Pos       (6UL)          /*!< BLF (Bit 6)                                           */
 #define R_CANFD_CFDC_ERFL_BLF_Msk       (0x40UL)       /*!< BLF (Bitfield-Mask: 0x01)                             */
 #define R_CANFD_CFDC_ERFL_ALF_Pos       (7UL)          /*!< ALF (Bit 7)                                           */
 #define R_CANFD_CFDC_ERFL_ALF_Msk       (0x80UL)       /*!< ALF (Bitfield-Mask: 0x01)                             */
 #define R_CANFD_CFDC_ERFL_SERR_Pos      (8UL)          /*!< SERR (Bit 8)                                          */
 #define R_CANFD_CFDC_ERFL_SERR_Msk      (0x100UL)      /*!< SERR (Bitfield-Mask: 0x01)                            */
 #define R_CANFD_CFDC_ERFL_FERR_Pos      (9UL)          /*!< FERR (Bit 9)                                          */
 #define R_CANFD_CFDC_ERFL_FERR_Msk      (0x200UL)      /*!< FERR (Bitfield-Mask: 0x01)                            */
 #define R_CANFD_CFDC_ERFL_AERR_Pos      (10UL)         /*!< AERR (Bit 10)                                         */
 #define R_CANFD_CFDC_ERFL_AERR_Msk      (0x400UL)      /*!< AERR (Bitfield-Mask: 0x01)                            */
 #define R_CANFD_CFDC_ERFL_CERR_Pos      (11UL)         /*!< CERR (Bit 11)                                         */
 #define R_CANFD_CFDC_ERFL_CERR_Msk      (0x800UL)      /*!< CERR (Bitfield-Mask: 0x01)                            */
 #define R_CANFD_CFDC_ERFL_B1ERR_Pos     (12UL)         /*!< B1ERR (Bit 12)                                        */
 #define R_CANFD_CFDC_ERFL_B1ERR_Msk     (0x1000UL)     /*!< B1ERR (Bitfield-Mask: 0x01)                           */
 #define R_CANFD_CFDC_ERFL_B0ERR_Pos     (13UL)         /*!< B0ERR (Bit 13)                                        */
 #define R_CANFD_CFDC_ERFL_B0ERR_Msk     (0x2000UL)     /*!< B0ERR (Bitfield-Mask: 0x01)                           */
 #define R_CANFD_CFDC_ERFL_ADERR_Pos     (14UL)         /*!< ADERR (Bit 14)                                        */
 #define R_CANFD_CFDC_ERFL_ADERR_Msk     (0x4000UL)     /*!< ADERR (Bitfield-Mask: 0x01)                           */
 #define R_CANFD_CFDC_ERFL_CRCREG_Pos    (16UL)         /*!< CRCREG (Bit 16)                                       */
 #define R_CANFD_CFDC_ERFL_CRCREG_Msk    (0x7fff0000UL) /*!< CRCREG (Bitfield-Mask: 0x7fff)                        */

/* =========================================================================================================================== */
/* ================                                           CFDC2                                           ================ */
/* =========================================================================================================================== */

/* =========================================================  DCFG  ========================================================== */
 #define R_CANFD_CFDC2_DCFG_DBRP_Pos       (0UL)          /*!< DBRP (Bit 0)                                          */
 #define R_CANFD_CFDC2_DCFG_DBRP_Msk       (0xffUL)       /*!< DBRP (Bitfield-Mask: 0xff)                            */
 #define R_CANFD_CFDC2_DCFG_DTSEG1_Pos     (8UL)          /*!< DTSEG1 (Bit 8)                                        */
 #define R_CANFD_CFDC2_DCFG_DTSEG1_Msk     (0x1f00UL)     /*!< DTSEG1 (Bitfield-Mask: 0x1f)                          */
 #define R_CANFD_CFDC2_DCFG_DTSEG2_Pos     (16UL)         /*!< DTSEG2 (Bit 16)                                       */
 #define R_CANFD_CFDC2_DCFG_DTSEG2_Msk     (0xf0000UL)    /*!< DTSEG2 (Bitfield-Mask: 0x0f)                          */
 #define R_CANFD_CFDC2_DCFG_DSJW_Pos       (24UL)         /*!< DSJW (Bit 24)                                         */
 #define R_CANFD_CFDC2_DCFG_DSJW_Msk       (0xf000000UL)  /*!< DSJW (Bitfield-Mask: 0x0f)                            */
/* =========================================================  FDCFG  ========================================================= */
 #define R_CANFD_CFDC2_FDCFG_EOCCFG_Pos    (0UL)          /*!< EOCCFG (Bit 0)                                        */
 #define R_CANFD_CFDC2_FDCFG_EOCCFG_Msk    (0x7UL)        /*!< EOCCFG (Bitfield-Mask: 0x07)                          */
 #define R_CANFD_CFDC2_FDCFG_TDCOC_Pos     (8UL)          /*!< TDCOC (Bit 8)                                         */
 #define R_CANFD_CFDC2_FDCFG_TDCOC_Msk     (0x100UL)      /*!< TDCOC (Bitfield-Mask: 0x01)                           */
 #define R_CANFD_CFDC2_FDCFG_TDCE_Pos      (9UL)          /*!< TDCE (Bit 9)                                          */
 #define R_CANFD_CFDC2_FDCFG_TDCE_Msk      (0x200UL)      /*!< TDCE (Bitfield-Mask: 0x01)                            */
 #define R_CANFD_CFDC2_FDCFG_ESIC_Pos      (10UL)         /*!< ESIC (Bit 10)                                         */
 #define R_CANFD_CFDC2_FDCFG_ESIC_Msk      (0x400UL)      /*!< ESIC (Bitfield-Mask: 0x01)                            */
 #define R_CANFD_CFDC2_FDCFG_TDCO_Pos      (16UL)         /*!< TDCO (Bit 16)                                         */
 #define R_CANFD_CFDC2_FDCFG_TDCO_Msk      (0xff0000UL)   /*!< TDCO (Bitfield-Mask: 0xff)                            */
 #define R_CANFD_CFDC2_FDCFG_FDOE_Pos      (28UL)         /*!< FDOE (Bit 28)                                         */
 #define R_CANFD_CFDC2_FDCFG_FDOE_Msk      (0x10000000UL) /*!< FDOE (Bitfield-Mask: 0x01)                            */
 #define R_CANFD_CFDC2_FDCFG_REFE_Pos      (29UL)         /*!< REFE (Bit 29)                                         */
 #define R_CANFD_CFDC2_FDCFG_REFE_Msk      (0x20000000UL) /*!< REFE (Bitfield-Mask: 0x01)                            */
 #define R_CANFD_CFDC2_FDCFG_CLOE_Pos      (30UL)         /*!< CLOE (Bit 30)                                         */
 #define R_CANFD_CFDC2_FDCFG_CLOE_Msk      (0x40000000UL) /*!< CLOE (Bitfield-Mask: 0x01)                            */
/* =========================================================  FDCTR  ========================================================= */
 #define R_CANFD_CFDC2_FDCTR_EOCCLR_Pos    (0UL)          /*!< EOCCLR (Bit 0)                                        */
 #define R_CANFD_CFDC2_FDCTR_EOCCLR_Msk    (0x1UL)        /*!< EOCCLR (Bitfield-Mask: 0x01)                          */
 #define R_CANFD_CFDC2_FDCTR_SOCCLR_Pos    (1UL)          /*!< SOCCLR (Bit 1)                                        */
 #define R_CANFD_CFDC2_FDCTR_SOCCLR_Msk    (0x2UL)        /*!< SOCCLR (Bitfield-Mask: 0x01)                          */
/* =========================================================  FDSTS  ========================================================= */
 #define R_CANFD_CFDC2_FDSTS_TDCR_Pos      (0UL)          /*!< TDCR (Bit 0)                                          */
 #define R_CANFD_CFDC2_FDSTS_TDCR_Msk      (0xffUL)       /*!< TDCR (Bitfield-Mask: 0xff)                            */
 #define R_CANFD_CFDC2_FDSTS_EOCO_Pos      (8UL)          /*!< EOCO (Bit 8)                                          */
 #define R_CANFD_CFDC2_FDSTS_EOCO_Msk      (0x100UL)      /*!< EOCO (Bitfield-Mask: 0x01)                            */
 #define R_CANFD_CFDC2_FDSTS_SOCO_Pos      (9UL)          /*!< SOCO (Bit 9)                                          */
 #define R_CANFD_CFDC2_FDSTS_SOCO_Msk      (0x200UL)      /*!< SOCO (Bitfield-Mask: 0x01)                            */
 #define R_CANFD_CFDC2_FDSTS_TDCVF_Pos     (15UL)         /*!< TDCVF (Bit 15)                                        */
 #define R_CANFD_CFDC2_FDSTS_TDCVF_Msk     (0x8000UL)     /*!< TDCVF (Bitfield-Mask: 0x01)                           */
 #define R_CANFD_CFDC2_FDSTS_EOC_Pos       (16UL)         /*!< EOC (Bit 16)                                          */
 #define R_CANFD_CFDC2_FDSTS_EOC_Msk       (0xff0000UL)   /*!< EOC (Bitfield-Mask: 0xff)                             */
 #define R_CANFD_CFDC2_FDSTS_SOC_Pos       (24UL)         /*!< SOC (Bit 24)                                          */
 #define R_CANFD_CFDC2_FDSTS_SOC_Msk       (0xff000000UL) /*!< SOC (Bitfield-Mask: 0xff)                             */
/* =========================================================  FDCRC  ========================================================= */
 #define R_CANFD_CFDC2_FDCRC_CRCREG_Pos    (0UL)          /*!< CRCREG (Bit 0)                                        */
 #define R_CANFD_CFDC2_FDCRC_CRCREG_Msk    (0x1fffffUL)   /*!< CRCREG (Bitfield-Mask: 0x1fffff)                      */
 #define R_CANFD_CFDC2_FDCRC_SCNT_Pos      (24UL)         /*!< SCNT (Bit 24)                                         */
 #define R_CANFD_CFDC2_FDCRC_SCNT_Msk      (0xf000000UL)  /*!< SCNT (Bitfield-Mask: 0x0f)                            */

/* =========================================================================================================================== */
/* ================                                          CFDGAFL                                          ================ */
/* =========================================================================================================================== */

/* ==========================================================  ID  =========================================================== */
 #define R_CANFD_CFDGAFL_ID_GAFLID_Pos      (0UL)          /*!< GAFLID (Bit 0)                                        */
 #define R_CANFD_CFDGAFL_ID_GAFLID_Msk      (0x1fffffffUL) /*!< GAFLID (Bitfield-Mask: 0x1fffffff)                    */
 #define R_CANFD_CFDGAFL_ID_GAFLLB_Pos      (29UL)         /*!< GAFLLB (Bit 29)                                       */
 #define R_CANFD_CFDGAFL_ID_GAFLLB_Msk      (0x20000000UL) /*!< GAFLLB (Bitfield-Mask: 0x01)                          */
 #define R_CANFD_CFDGAFL_ID_GAFLRTR_Pos     (30UL)         /*!< GAFLRTR (Bit 30)                                      */
 #define R_CANFD_CFDGAFL_ID_GAFLRTR_Msk     (0x40000000UL) /*!< GAFLRTR (Bitfield-Mask: 0x01)                         */
 #define R_CANFD_CFDGAFL_ID_GAFLIDE_Pos     (31UL)         /*!< GAFLIDE (Bit 31)                                      */
 #define R_CANFD_CFDGAFL_ID_GAFLIDE_Msk     (0x80000000UL) /*!< GAFLIDE (Bitfield-Mask: 0x01)                         */
/* ===========================================================  M  =========================================================== */
 #define R_CANFD_CFDGAFL_M_GAFLIDM_Pos      (0UL)          /*!< GAFLIDM (Bit 0)                                       */
 #define R_CANFD_CFDGAFL_M_GAFLIDM_Msk      (0x1fffffffUL) /*!< GAFLIDM (Bitfield-Mask: 0x1fffffff)                   */
 #define R_CANFD_CFDGAFL_M_GAFLIFL1_Pos     (29UL)         /*!< GAFLIFL1 (Bit 29)                                     */
 #define R_CANFD_CFDGAFL_M_GAFLIFL1_Msk     (0x20000000UL) /*!< GAFLIFL1 (Bitfield-Mask: 0x01)                        */
 #define R_CANFD_CFDGAFL_M_GAFLRTRM_Pos     (30UL)         /*!< GAFLRTRM (Bit 30)                                     */
 #define R_CANFD_CFDGAFL_M_GAFLRTRM_Msk     (0x40000000UL) /*!< GAFLRTRM (Bitfield-Mask: 0x01)                        */
 #define R_CANFD_CFDGAFL_M_GAFLIDEM_Pos     (31UL)         /*!< GAFLIDEM (Bit 31)                                     */
 #define R_CANFD_CFDGAFL_M_GAFLIDEM_Msk     (0x80000000UL) /*!< GAFLIDEM (Bitfield-Mask: 0x01)                        */
/* ==========================================================  P0  =========================================================== */
 #define R_CANFD_CFDGAFL_P0_GAFLDLC_Pos     (0UL)          /*!< GAFLDLC (Bit 0)                                       */
 #define R_CANFD_CFDGAFL_P0_GAFLDLC_Msk     (0xfUL)        /*!< GAFLDLC (Bitfield-Mask: 0x0f)                         */
 #define R_CANFD_CFDGAFL_P0_GAFLIFL0_Pos    (7UL)          /*!< GAFLIFL0 (Bit 7)                                      */
 #define R_CANFD_CFDGAFL_P0_GAFLIFL0_Msk    (0x80UL)       /*!< GAFLIFL0 (Bitfield-Mask: 0x01)                        */
 #define R_CANFD_CFDGAFL_P0_GAFLRMDP_Pos    (8UL)          /*!< GAFLRMDP (Bit 8)                                      */
 #define R_CANFD_CFDGAFL_P0_GAFLRMDP_Msk    (0x1f00UL)     /*!< GAFLRMDP (Bitfield-Mask: 0x1f)                        */
 #define R_CANFD_CFDGAFL_P0_GAFLRMV_Pos     (15UL)         /*!< GAFLRMV (Bit 15)                                      */
 #define R_CANFD_CFDGAFL_P0_GAFLRMV_Msk     (0x8000UL)     /*!< GAFLRMV (Bitfield-Mask: 0x01)                         */
 #define R_CANFD_CFDGAFL_P0_GAFLPTR_Pos     (16UL)         /*!< GAFLPTR (Bit 16)                                      */
 #define R_CANFD_CFDGAFL_P0_GAFLPTR_Msk     (0xffff0000UL) /*!< GAFLPTR (Bitfield-Mask: 0xffff)                       */
/* ==========================================================  P1  =========================================================== */
 #define R_CANFD_CFDGAFL_P1_GAFLFDP_Pos     (0UL)          /*!< GAFLFDP (Bit 0)                                       */
 #define R_CANFD_CFDGAFL_P1_GAFLFDP_Msk     (0x1ffUL)      /*!< GAFLFDP (Bitfield-Mask: 0x1ff)                        */

/* =========================================================================================================================== */
/* ================                                          CFDTHL                                           ================ */
/* =========================================================================================================================== */

/* =========================================================  ACC0  ========================================================== */
 #define R_CANFD_CFDTHL_ACC0_BT_Pos      (0UL)          /*!< BT (Bit 0)                                            */
 #define R_CANFD_CFDTHL_ACC0_BT_Msk      (0x7UL)        /*!< BT (Bitfield-Mask: 0x07)                              */
 #define R_CANFD_CFDTHL_ACC0_BN_Pos      (3UL)          /*!< BN (Bit 3)                                            */
 #define R_CANFD_CFDTHL_ACC0_BN_Msk      (0x3f8UL)      /*!< BN (Bitfield-Mask: 0x7f)                              */
 #define R_CANFD_CFDTHL_ACC0_TMTS_Pos    (16UL)         /*!< TMTS (Bit 16)                                         */
 #define R_CANFD_CFDTHL_ACC0_TMTS_Msk    (0xffff0000UL) /*!< TMTS (Bitfield-Mask: 0xffff)                          */
/* =========================================================  ACC1  ========================================================== */
 #define R_CANFD_CFDTHL_ACC1_TID_Pos     (0UL)          /*!< TID (Bit 0)                                           */
 #define R_CANFD_CFDTHL_ACC1_TID_Msk     (0xffffUL)     /*!< TID (Bitfield-Mask: 0xffff)                           */
 #define R_CANFD_CFDTHL_ACC1_TIFL_Pos    (16UL)         /*!< TIFL (Bit 16)                                         */
 #define R_CANFD_CFDTHL_ACC1_TIFL_Msk    (0x30000UL)    /*!< TIFL (Bitfield-Mask: 0x03)                            */

/* =========================================================================================================================== */
/* ================                                           CFDRF                                           ================ */
/* =========================================================================================================================== */

/* ==========================================================  ID  =========================================================== */
 #define R_CANFD_CFDRF_ID_RFID_Pos        (0UL)          /*!< RFID (Bit 0)                                          */
 #define R_CANFD_CFDRF_ID_RFID_Msk        (0x1fffffffUL) /*!< RFID (Bitfield-Mask: 0x1fffffff)                      */
 #define R_CANFD_CFDRF_ID_RFRTR_Pos       (30UL)         /*!< RFRTR (Bit 30)                                        */
 #define R_CANFD_CFDRF_ID_RFRTR_Msk       (0x40000000UL) /*!< RFRTR (Bitfield-Mask: 0x01)                           */
 #define R_CANFD_CFDRF_ID_RFIDE_Pos       (31UL)         /*!< RFIDE (Bit 31)                                        */
 #define R_CANFD_CFDRF_ID_RFIDE_Msk       (0x80000000UL) /*!< RFIDE (Bitfield-Mask: 0x01)                           */
/* ==========================================================  PTR  ========================================================== */
 #define R_CANFD_CFDRF_PTR_RFTS_Pos       (0UL)          /*!< RFTS (Bit 0)                                          */
 #define R_CANFD_CFDRF_PTR_RFTS_Msk       (0xffffUL)     /*!< RFTS (Bitfield-Mask: 0xffff)                          */
 #define R_CANFD_CFDRF_PTR_RFDLC_Pos      (28UL)         /*!< RFDLC (Bit 28)                                        */
 #define R_CANFD_CFDRF_PTR_RFDLC_Msk      (0xf0000000UL) /*!< RFDLC (Bitfield-Mask: 0x0f)                           */
/* =========================================================  FDSTS  ========================================================= */
 #define R_CANFD_CFDRF_FDSTS_RFESI_Pos    (0UL)          /*!< RFESI (Bit 0)                                         */
 #define R_CANFD_CFDRF_FDSTS_RFESI_Msk    (0x1UL)        /*!< RFESI (Bitfield-Mask: 0x01)                           */
 #define R_CANFD_CFDRF_FDSTS_RFBRS_Pos    (1UL)          /*!< RFBRS (Bit 1)                                         */
 #define R_CANFD_CFDRF_FDSTS_RFBRS_Msk    (0x2UL)        /*!< RFBRS (Bitfield-Mask: 0x01)                           */
 #define R_CANFD_CFDRF_FDSTS_RFFDF_Pos    (2UL)          /*!< RFFDF (Bit 2)                                         */
 #define R_CANFD_CFDRF_FDSTS_RFFDF_Msk    (0x4UL)        /*!< RFFDF (Bitfield-Mask: 0x01)                           */
 #define R_CANFD_CFDRF_FDSTS_RFIFL_Pos    (8UL)          /*!< RFIFL (Bit 8)                                         */
 #define R_CANFD_CFDRF_FDSTS_RFIFL_Msk    (0x300UL)      /*!< RFIFL (Bitfield-Mask: 0x03)                           */
 #define R_CANFD_CFDRF_FDSTS_RFPTR_Pos    (16UL)         /*!< RFPTR (Bit 16)                                        */
 #define R_CANFD_CFDRF_FDSTS_RFPTR_Msk    (0xffff0000UL) /*!< RFPTR (Bitfield-Mask: 0xffff)                         */
/* ==========================================================  DF  =========================================================== */
 #define R_CANFD_CFDRF_DF_RFDB_Pos        (0UL)          /*!< RFDB (Bit 0)                                          */
 #define R_CANFD_CFDRF_DF_RFDB_Msk        (0xffUL)       /*!< RFDB (Bitfield-Mask: 0xff)                            */

/* =========================================================================================================================== */
/* ================                                           CFDCF                                           ================ */
/* =========================================================================================================================== */

/* ==========================================================  ID  =========================================================== */
 #define R_CANFD_CFDCF_ID_CFID_Pos        (0UL)          /*!< CFID (Bit 0)                                          */
 #define R_CANFD_CFDCF_ID_CFID_Msk        (0x1fffffffUL) /*!< CFID (Bitfield-Mask: 0x1fffffff)                      */
 #define R_CANFD_CFDCF_ID_CFRTR_Pos       (30UL)         /*!< CFRTR (Bit 30)                                        */
 #define R_CANFD_CFDCF_ID_CFRTR_Msk       (0x40000000UL) /*!< CFRTR (Bitfield-Mask: 0x01)                           */
 #define R_CANFD_CFDCF_ID_CFIDE_Pos       (31UL)         /*!< CFIDE (Bit 31)                                        */
 #define R_CANFD_CFDCF_ID_CFIDE_Msk       (0x80000000UL) /*!< CFIDE (Bitfield-Mask: 0x01)                           */
/* ==========================================================  PTR  ========================================================== */
 #define R_CANFD_CFDCF_PTR_CFTS_Pos       (0UL)          /*!< CFTS (Bit 0)                                          */
 #define R_CANFD_CFDCF_PTR_CFTS_Msk       (0xffffUL)     /*!< CFTS (Bitfield-Mask: 0xffff)                          */
 #define R_CANFD_CFDCF_PTR_CFDLC_Pos      (28UL)         /*!< CFDLC (Bit 28)                                        */
 #define R_CANFD_CFDCF_PTR_CFDLC_Msk      (0xf0000000UL) /*!< CFDLC (Bitfield-Mask: 0x0f)                           */
/* =========================================================  FDSTS  ========================================================= */
 #define R_CANFD_CFDCF_FDSTS_CFESI_Pos    (0UL)          /*!< CFESI (Bit 0)                                         */
 #define R_CANFD_CFDCF_FDSTS_CFESI_Msk    (0x1UL)        /*!< CFESI (Bitfield-Mask: 0x01)                           */
 #define R_CANFD_CFDCF_FDSTS_CFBRS_Pos    (1UL)          /*!< CFBRS (Bit 1)                                         */
 #define R_CANFD_CFDCF_FDSTS_CFBRS_Msk    (0x2UL)        /*!< CFBRS (Bitfield-Mask: 0x01)                           */
 #define R_CANFD_CFDCF_FDSTS_CFFDF_Pos    (2UL)          /*!< CFFDF (Bit 2)                                         */
 #define R_CANFD_CFDCF_FDSTS_CFFDF_Msk    (0x4UL)        /*!< CFFDF (Bitfield-Mask: 0x01)                           */
 #define R_CANFD_CFDCF_FDSTS_CFIFL_Pos    (8UL)          /*!< CFIFL (Bit 8)                                         */
 #define R_CANFD_CFDCF_FDSTS_CFIFL_Msk    (0x300UL)      /*!< CFIFL (Bitfield-Mask: 0x03)                           */
 #define R_CANFD_CFDCF_FDSTS_CFPTR_Pos    (16UL)         /*!< CFPTR (Bit 16)                                        */
 #define R_CANFD_CFDCF_FDSTS_CFPTR_Msk    (0xffff0000UL) /*!< CFPTR (Bitfield-Mask: 0xffff)                         */
/* ==========================================================  DF  =========================================================== */
 #define R_CANFD_CFDCF_DF_CFDB_Pos        (0UL)          /*!< CFDB (Bit 0)                                          */
 #define R_CANFD_CFDCF_DF_CFDB_Msk        (0xffUL)       /*!< CFDB (Bitfield-Mask: 0xff)                            */

/* =========================================================================================================================== */
/* ================                                           CFDTM                                           ================ */
/* =========================================================================================================================== */

/* ==========================================================  ID  =========================================================== */
 #define R_CANFD_CFDTM_ID_TMID_Pos        (0UL)          /*!< TMID (Bit 0)                                          */
 #define R_CANFD_CFDTM_ID_TMID_Msk        (0x1fffffffUL) /*!< TMID (Bitfield-Mask: 0x1fffffff)                      */
 #define R_CANFD_CFDTM_ID_TMRTR_Pos       (30UL)         /*!< TMRTR (Bit 30)                                        */
 #define R_CANFD_CFDTM_ID_TMRTR_Msk       (0x40000000UL) /*!< TMRTR (Bitfield-Mask: 0x01)                           */
 #define R_CANFD_CFDTM_ID_TMIDE_Pos       (31UL)         /*!< TMIDE (Bit 31)                                        */
 #define R_CANFD_CFDTM_ID_TMIDE_Msk       (0x80000000UL) /*!< TMIDE (Bitfield-Mask: 0x01)                           */
/* ==========================================================  PTR  ========================================================== */
 #define R_CANFD_CFDTM_PTR_TMTS_Pos       (0UL)          /*!< TMTS (Bit 0)                                          */
 #define R_CANFD_CFDTM_PTR_TMTS_Msk       (0xffffUL)     /*!< TMTS (Bitfield-Mask: 0xffff)                          */
 #define R_CANFD_CFDTM_PTR_TMDLC_Pos      (28UL)         /*!< TMDLC (Bit 28)                                        */
 #define R_CANFD_CFDTM_PTR_TMDLC_Msk      (0xf0000000UL) /*!< TMDLC (Bitfield-Mask: 0x0f)                           */
/* =========================================================  FDCTR  ========================================================= */
 #define R_CANFD_CFDTM_FDCTR_TMESI_Pos    (0UL)          /*!< TMESI (Bit 0)                                         */
 #define R_CANFD_CFDTM_FDCTR_TMESI_Msk    (0x1UL)        /*!< TMESI (Bitfield-Mask: 0x01)                           */
 #define R_CANFD_CFDTM_FDCTR_TMBRS_Pos    (1UL)          /*!< TMBRS (Bit 1)                                         */
 #define R_CANFD_CFDTM_FDCTR_TMBRS_Msk    (0x2UL)        /*!< TMBRS (Bitfield-Mask: 0x01)                           */
 #define R_CANFD_CFDTM_FDCTR_TMFDF_Pos    (2UL)          /*!< TMFDF (Bit 2)                                         */
 #define R_CANFD_CFDTM_FDCTR_TMFDF_Msk    (0x4UL)        /*!< TMFDF (Bitfield-Mask: 0x01)                           */
 #define R_CANFD_CFDTM_FDCTR_TMIFL_Pos    (8UL)          /*!< TMIFL (Bit 8)                                         */
 #define R_CANFD_CFDTM_FDCTR_TMIFL_Msk    (0x300UL)      /*!< TMIFL (Bitfield-Mask: 0x03)                           */
 #define R_CANFD_CFDTM_FDCTR_TMPTR_Pos    (16UL)         /*!< TMPTR (Bit 16)                                        */
 #define R_CANFD_CFDTM_FDCTR_TMPTR_Msk    (0xffff0000UL) /*!< TMPTR (Bitfield-Mask: 0xffff)                         */
/* ==========================================================  DF  =========================================================== */
 #define R_CANFD_CFDTM_DF_TMDB_Pos        (0UL)          /*!< TMDB (Bit 0)                                          */
 #define R_CANFD_CFDTM_DF_TMDB_Msk        (0xffUL)       /*!< TMDB (Bitfield-Mask: 0xff)                            */

/* =========================================================================================================================== */
/* ================                                            RM                                             ================ */
/* =========================================================================================================================== */

/* ==========================================================  ID  =========================================================== */
 #define R_CANFD_CFDRM_RM_ID_RMID_Pos        (0UL)          /*!< RMID (Bit 0)                                          */
 #define R_CANFD_CFDRM_RM_ID_RMID_Msk        (0x1fffffffUL) /*!< RMID (Bitfield-Mask: 0x1fffffff)                      */
 #define R_CANFD_CFDRM_RM_ID_RMRTR_Pos       (30UL)         /*!< RMRTR (Bit 30)                                        */
 #define R_CANFD_CFDRM_RM_ID_RMRTR_Msk       (0x40000000UL) /*!< RMRTR (Bitfield-Mask: 0x01)                           */
 #define R_CANFD_CFDRM_RM_ID_RMIDE_Pos       (31UL)         /*!< RMIDE (Bit 31)                                        */
 #define R_CANFD_CFDRM_RM_ID_RMIDE_Msk       (0x80000000UL) /*!< RMIDE (Bitfield-Mask: 0x01)                           */
/* ==========================================================  PTR  ========================================================== */
 #define R_CANFD_CFDRM_RM_PTR_RMTS_Pos       (0UL)          /*!< RMTS (Bit 0)                                          */
 #define R_CANFD_CFDRM_RM_PTR_RMTS_Msk       (0xffffUL)     /*!< RMTS (Bitfield-Mask: 0xffff)                          */
 #define R_CANFD_CFDRM_RM_PTR_RMDLC_Pos      (28UL)         /*!< RMDLC (Bit 28)                                        */
 #define R_CANFD_CFDRM_RM_PTR_RMDLC_Msk      (0xf0000000UL) /*!< RMDLC (Bitfield-Mask: 0x0f)                           */
/* =========================================================  FDSTS  ========================================================= */
 #define R_CANFD_CFDRM_RM_FDSTS_RMESI_Pos    (0UL)          /*!< RMESI (Bit 0)                                         */
 #define R_CANFD_CFDRM_RM_FDSTS_RMESI_Msk    (0x1UL)        /*!< RMESI (Bitfield-Mask: 0x01)                           */
 #define R_CANFD_CFDRM_RM_FDSTS_RMBRS_Pos    (1UL)          /*!< RMBRS (Bit 1)                                         */
 #define R_CANFD_CFDRM_RM_FDSTS_RMBRS_Msk    (0x2UL)        /*!< RMBRS (Bitfield-Mask: 0x01)                           */
 #define R_CANFD_CFDRM_RM_FDSTS_RMFDF_Pos    (2UL)          /*!< RMFDF (Bit 2)                                         */
 #define R_CANFD_CFDRM_RM_FDSTS_RMFDF_Msk    (0x4UL)        /*!< RMFDF (Bitfield-Mask: 0x01)                           */
 #define R_CANFD_CFDRM_RM_FDSTS_RMIFL_Pos    (8UL)          /*!< RMIFL (Bit 8)                                         */
 #define R_CANFD_CFDRM_RM_FDSTS_RMIFL_Msk    (0x300UL)      /*!< RMIFL (Bitfield-Mask: 0x03)                           */
 #define R_CANFD_CFDRM_RM_FDSTS_RMPTR_Pos    (16UL)         /*!< RMPTR (Bit 16)                                        */
 #define R_CANFD_CFDRM_RM_FDSTS_RMPTR_Msk    (0xffff0000UL) /*!< RMPTR (Bitfield-Mask: 0xffff)                         */
/* ==========================================================  DF  =========================================================== */
 #define R_CANFD_CFDRM_RM_DF_RMDB_Pos        (0UL)          /*!< RMDB (Bit 0)                                          */
 #define R_CANFD_CFDRM_RM_DF_RMDB_Msk        (0xffUL)       /*!< RMDB (Bitfield-Mask: 0xff)                            */

/* =========================================================================================================================== */
/* ================                                           CFDRM                                           ================ */
/* =========================================================================================================================== */

/* =========================================================================================================================== */
/* ================                                          ELSEGR                                           ================ */
/* =========================================================================================================================== */

/* ==========================================================  BY  =========================================================== */
 #define R_ELC_ELSEGR_BY_WI_Pos     (7UL)    /*!< WI (Bit 7)                                            */
 #define R_ELC_ELSEGR_BY_WI_Msk     (0x80UL) /*!< WI (Bitfield-Mask: 0x01)                              */
 #define R_ELC_ELSEGR_BY_WE_Pos     (6UL)    /*!< WE (Bit 6)                                            */
 #define R_ELC_ELSEGR_BY_WE_Msk     (0x40UL) /*!< WE (Bitfield-Mask: 0x01)                              */
 #define R_ELC_ELSEGR_BY_SEG_Pos    (0UL)    /*!< SEG (Bit 0)                                           */
 #define R_ELC_ELSEGR_BY_SEG_Msk    (0x1UL)  /*!< SEG (Bitfield-Mask: 0x01)                             */

/* =========================================================================================================================== */
/* ================                                           ELSR                                            ================ */
/* =========================================================================================================================== */

/* ==========================================================  HA  =========================================================== */
 #define R_ELC_ELSR_HA_ELS_Pos    (0UL)     /*!< ELS (Bit 0)                                           */
 #define R_ELC_ELSR_HA_ELS_Msk    (0x1ffUL) /*!< ELS (Bitfield-Mask: 0x1ff)                            */

/* =========================================================================================================================== */
/* ================                                            SAR                                            ================ */
/* =========================================================================================================================== */

/* ===========================================================  L  =========================================================== */
 #define R_IIC0_SAR_L_SVA_Pos     (0UL)    /*!< SVA (Bit 0)                                           */
 #define R_IIC0_SAR_L_SVA_Msk     (0xffUL) /*!< SVA (Bitfield-Mask: 0xff)                             */
/* ===========================================================  U  =========================================================== */
 #define R_IIC0_SAR_U_SVA9_Pos    (2UL)    /*!< SVA9 (Bit 2)                                          */
 #define R_IIC0_SAR_U_SVA9_Msk    (0x4UL)  /*!< SVA9 (Bitfield-Mask: 0x01)                            */
 #define R_IIC0_SAR_U_SVA8_Pos    (1UL)    /*!< SVA8 (Bit 1)                                          */
 #define R_IIC0_SAR_U_SVA8_Msk    (0x2UL)  /*!< SVA8 (Bitfield-Mask: 0x01)                            */
 #define R_IIC0_SAR_U_FS_Pos      (0UL)    /*!< FS (Bit 0)                                            */
 #define R_IIC0_SAR_U_FS_Msk      (0x1UL)  /*!< FS (Bitfield-Mask: 0x01)                              */

/* =========================================================================================================================== */
/* ================                                          REGION                                           ================ */
/* =========================================================================================================================== */

/* ===========================================================  C  =========================================================== */
 #define R_MPU_MMPU_MMPU_REGION_C_WP_Pos         (2UL)          /*!< WP (Bit 2)                                            */
 #define R_MPU_MMPU_MMPU_REGION_C_WP_Msk         (0x4UL)        /*!< WP (Bitfield-Mask: 0x01)                              */
 #define R_MPU_MMPU_MMPU_REGION_C_RP_Pos         (1UL)          /*!< RP (Bit 1)                                            */
 #define R_MPU_MMPU_MMPU_REGION_C_RP_Msk         (0x2UL)        /*!< RP (Bitfield-Mask: 0x01)                              */
 #define R_MPU_MMPU_MMPU_REGION_C_ENABLE_Pos     (0UL)          /*!< ENABLE (Bit 0)                                        */
 #define R_MPU_MMPU_MMPU_REGION_C_ENABLE_Msk     (0x1UL)        /*!< ENABLE (Bitfield-Mask: 0x01)                          */
/* ===========================================================  S  =========================================================== */
 #define R_MPU_MMPU_MMPU_REGION_S_MMPUSmn_Pos    (0UL)          /*!< MMPUSmn (Bit 0)                                       */
 #define R_MPU_MMPU_MMPU_REGION_S_MMPUSmn_Msk    (0xffffffffUL) /*!< MMPUSmn (Bitfield-Mask: 0xffffffff)                   */
/* ===========================================================  E  =========================================================== */
 #define R_MPU_MMPU_MMPU_REGION_E_MMPUEmn_Pos    (0UL)          /*!< MMPUEmn (Bit 0)                                       */
 #define R_MPU_MMPU_MMPU_REGION_E_MMPUEmn_Msk    (0xffffffffUL) /*!< MMPUEmn (Bitfield-Mask: 0xffffffff)                   */

/* =========================================================================================================================== */
/* ================                                           MMPU                                            ================ */
/* =========================================================================================================================== */

/* ==========================================================  CTL  ========================================================== */
 #define R_MPU_MMPU_MMPU_CTL_KEY_Pos       (8UL)      /*!< KEY (Bit 8)                                           */
 #define R_MPU_MMPU_MMPU_CTL_KEY_Msk       (0xff00UL) /*!< KEY (Bitfield-Mask: 0xff)                             */
 #define R_MPU_MMPU_MMPU_CTL_OAD_Pos       (1UL)      /*!< OAD (Bit 1)                                           */
 #define R_MPU_MMPU_MMPU_CTL_OAD_Msk       (0x2UL)    /*!< OAD (Bitfield-Mask: 0x01)                             */
 #define R_MPU_MMPU_MMPU_CTL_ENABLE_Pos    (0UL)      /*!< ENABLE (Bit 0)                                        */
 #define R_MPU_MMPU_MMPU_CTL_ENABLE_Msk    (0x1UL)    /*!< ENABLE (Bitfield-Mask: 0x01)                          */
/* ==========================================================  PT  =========================================================== */
 #define R_MPU_MMPU_MMPU_PT_KEY_Pos        (8UL)      /*!< KEY (Bit 8)                                           */
 #define R_MPU_MMPU_MMPU_PT_KEY_Msk        (0xff00UL) /*!< KEY (Bitfield-Mask: 0xff)                             */
 #define R_MPU_MMPU_MMPU_PT_PROTECT_Pos    (0UL)      /*!< PROTECT (Bit 0)                                       */
 #define R_MPU_MMPU_MMPU_PT_PROTECT_Msk    (0x1UL)    /*!< PROTECT (Bitfield-Mask: 0x01)                         */

/* =========================================================================================================================== */
/* ================                                           SMPU                                            ================ */
/* =========================================================================================================================== */

/* ===========================================================  R  =========================================================== */
 #define R_MPU_SMPU_SMPU_R_WPSRAMHS_Pos    (15UL)     /*!< WPSRAMHS (Bit 15)                                     */
 #define R_MPU_SMPU_SMPU_R_WPSRAMHS_Msk    (0x8000UL) /*!< WPSRAMHS (Bitfield-Mask: 0x01)                        */
 #define R_MPU_SMPU_SMPU_R_RPSRAMHS_Pos    (14UL)     /*!< RPSRAMHS (Bit 14)                                     */
 #define R_MPU_SMPU_SMPU_R_RPSRAMHS_Msk    (0x4000UL) /*!< RPSRAMHS (Bitfield-Mask: 0x01)                        */
 #define R_MPU_SMPU_SMPU_R_WPFLI_Pos       (13UL)     /*!< WPFLI (Bit 13)                                        */
 #define R_MPU_SMPU_SMPU_R_WPFLI_Msk       (0x2000UL) /*!< WPFLI (Bitfield-Mask: 0x01)                           */
 #define R_MPU_SMPU_SMPU_R_RPFLI_Pos       (12UL)     /*!< RPFLI (Bit 12)                                        */
 #define R_MPU_SMPU_SMPU_R_RPFLI_Msk       (0x1000UL) /*!< RPFLI (Bitfield-Mask: 0x01)                           */
 #define R_MPU_SMPU_SMPU_R_WPGRPC_Pos      (7UL)      /*!< WPGRPC (Bit 7)                                        */
 #define R_MPU_SMPU_SMPU_R_WPGRPC_Msk      (0x80UL)   /*!< WPGRPC (Bitfield-Mask: 0x01)                          */
 #define R_MPU_SMPU_SMPU_R_RPGRPC_Pos      (6UL)      /*!< RPGRPC (Bit 6)                                        */
 #define R_MPU_SMPU_SMPU_R_RPGRPC_Msk      (0x40UL)   /*!< RPGRPC (Bitfield-Mask: 0x01)                          */
 #define R_MPU_SMPU_SMPU_R_WPGRPB_Pos      (5UL)      /*!< WPGRPB (Bit 5)                                        */
 #define R_MPU_SMPU_SMPU_R_WPGRPB_Msk      (0x20UL)   /*!< WPGRPB (Bitfield-Mask: 0x01)                          */
 #define R_MPU_SMPU_SMPU_R_RPGRPB_Pos      (4UL)      /*!< RPGRPB (Bit 4)                                        */
 #define R_MPU_SMPU_SMPU_R_RPGRPB_Msk      (0x10UL)   /*!< RPGRPB (Bitfield-Mask: 0x01)                          */
 #define R_MPU_SMPU_SMPU_R_WPGRPA_Pos      (3UL)      /*!< WPGRPA (Bit 3)                                        */
 #define R_MPU_SMPU_SMPU_R_WPGRPA_Msk      (0x8UL)    /*!< WPGRPA (Bitfield-Mask: 0x01)                          */
 #define R_MPU_SMPU_SMPU_R_RPGRPA_Pos      (2UL)      /*!< RPGRPA (Bit 2)                                        */
 #define R_MPU_SMPU_SMPU_R_RPGRPA_Msk      (0x4UL)    /*!< RPGRPA (Bitfield-Mask: 0x01)                          */

/* =========================================================================================================================== */
/* ================                                            SP                                             ================ */
/* =========================================================================================================================== */

/* ==========================================================  OAD  ========================================================== */
 #define R_MPU_SPMON_SP_OAD_KEY_Pos        (8UL)          /*!< KEY (Bit 8)                                           */
 #define R_MPU_SPMON_SP_OAD_KEY_Msk        (0xff00UL)     /*!< KEY (Bitfield-Mask: 0xff)                             */
 #define R_MPU_SPMON_SP_OAD_OAD_Pos        (0UL)          /*!< OAD (Bit 0)                                           */
 #define R_MPU_SPMON_SP_OAD_OAD_Msk        (0x1UL)        /*!< OAD (Bitfield-Mask: 0x01)                             */
/* ==========================================================  CTL  ========================================================== */
 #define R_MPU_SPMON_SP_CTL_ERROR_Pos      (8UL)          /*!< ERROR (Bit 8)                                         */
 #define R_MPU_SPMON_SP_CTL_ERROR_Msk      (0x100UL)      /*!< ERROR (Bitfield-Mask: 0x01)                           */
 #define R_MPU_SPMON_SP_CTL_ENABLE_Pos     (0UL)          /*!< ENABLE (Bit 0)                                        */
 #define R_MPU_SPMON_SP_CTL_ENABLE_Msk     (0x1UL)        /*!< ENABLE (Bitfield-Mask: 0x01)                          */
/* ==========================================================  PT  =========================================================== */
 #define R_MPU_SPMON_SP_PT_KEY_Pos         (8UL)          /*!< KEY (Bit 8)                                           */
 #define R_MPU_SPMON_SP_PT_KEY_Msk         (0xff00UL)     /*!< KEY (Bitfield-Mask: 0xff)                             */
 #define R_MPU_SPMON_SP_PT_PROTECT_Pos     (0UL)          /*!< PROTECT (Bit 0)                                       */
 #define R_MPU_SPMON_SP_PT_PROTECT_Msk     (0x1UL)        /*!< PROTECT (Bitfield-Mask: 0x01)                         */
/* ==========================================================  SA  =========================================================== */
 #define R_MPU_SPMON_SP_SA_MSPMPUSA_Pos    (0UL)          /*!< MSPMPUSA (Bit 0)                                      */
 #define R_MPU_SPMON_SP_SA_MSPMPUSA_Msk    (0xffffffffUL) /*!< MSPMPUSA (Bitfield-Mask: 0xffffffff)                  */
/* ==========================================================  EA  =========================================================== */
 #define R_MPU_SPMON_SP_EA_MSPMPUEA_Pos    (0UL)          /*!< MSPMPUEA (Bit 0)                                      */
 #define R_MPU_SPMON_SP_EA_MSPMPUEA_Msk    (0xffffffffUL) /*!< MSPMPUEA (Bitfield-Mask: 0xffffffff)                  */

/* =========================================================================================================================== */
/* ================                                            PIN                                            ================ */
/* =========================================================================================================================== */

/* =======================================================  PmnPFS_BY  ======================================================= */
 #define R_PFS_PORT_PIN_PmnPFS_BY_NCODR_Pos    (6UL)          /*!< NCODR (Bit 6)                                         */
 #define R_PFS_PORT_PIN_PmnPFS_BY_NCODR_Msk    (0x40UL)       /*!< NCODR (Bitfield-Mask: 0x01)                           */
 #define R_PFS_PORT_PIN_PmnPFS_BY_PIM_Pos      (5UL)          /*!< PIM (Bit 5)                                           */
 #define R_PFS_PORT_PIN_PmnPFS_BY_PIM_Msk      (0x20UL)       /*!< PIM (Bitfield-Mask: 0x01)                             */
 #define R_PFS_PORT_PIN_PmnPFS_BY_PCR_Pos      (4UL)          /*!< PCR (Bit 4)                                           */
 #define R_PFS_PORT_PIN_PmnPFS_BY_PCR_Msk      (0x10UL)       /*!< PCR (Bitfield-Mask: 0x01)                             */
 #define R_PFS_PORT_PIN_PmnPFS_BY_PDR_Pos      (2UL)          /*!< PDR (Bit 2)                                           */
 #define R_PFS_PORT_PIN_PmnPFS_BY_PDR_Msk      (0x4UL)        /*!< PDR (Bitfield-Mask: 0x01)                             */
 #define R_PFS_PORT_PIN_PmnPFS_BY_PIDR_Pos     (1UL)          /*!< PIDR (Bit 1)                                          */
 #define R_PFS_PORT_PIN_PmnPFS_BY_PIDR_Msk     (0x2UL)        /*!< PIDR (Bitfield-Mask: 0x01)                            */
 #define R_PFS_PORT_PIN_PmnPFS_BY_PODR_Pos     (0UL)          /*!< PODR (Bit 0)                                          */
 #define R_PFS_PORT_PIN_PmnPFS_BY_PODR_Msk     (0x1UL)        /*!< PODR (Bitfield-Mask: 0x01)                            */
/* =======================================================  PmnPFS_HA  ======================================================= */
 #define R_PFS_PORT_PIN_PmnPFS_HA_NCODR_Pos    (6UL)          /*!< NCODR (Bit 6)                                         */
 #define R_PFS_PORT_PIN_PmnPFS_HA_NCODR_Msk    (0x40UL)       /*!< NCODR (Bitfield-Mask: 0x01)                           */
 #define R_PFS_PORT_PIN_PmnPFS_HA_PIM_Pos      (5UL)          /*!< PIM (Bit 5)                                           */
 #define R_PFS_PORT_PIN_PmnPFS_HA_PIM_Msk      (0x20UL)       /*!< PIM (Bitfield-Mask: 0x01)                             */
 #define R_PFS_PORT_PIN_PmnPFS_HA_PCR_Pos      (4UL)          /*!< PCR (Bit 4)                                           */
 #define R_PFS_PORT_PIN_PmnPFS_HA_PCR_Msk      (0x10UL)       /*!< PCR (Bitfield-Mask: 0x01)                             */
 #define R_PFS_PORT_PIN_PmnPFS_HA_PDR_Pos      (2UL)          /*!< PDR (Bit 2)                                           */
 #define R_PFS_PORT_PIN_PmnPFS_HA_PDR_Msk      (0x4UL)        /*!< PDR (Bitfield-Mask: 0x01)                             */
 #define R_PFS_PORT_PIN_PmnPFS_HA_PIDR_Pos     (1UL)          /*!< PIDR (Bit 1)                                          */
 #define R_PFS_PORT_PIN_PmnPFS_HA_PIDR_Msk     (0x2UL)        /*!< PIDR (Bitfield-Mask: 0x01)                            */
 #define R_PFS_PORT_PIN_PmnPFS_HA_PODR_Pos     (0UL)          /*!< PODR (Bit 0)                                          */
 #define R_PFS_PORT_PIN_PmnPFS_HA_PODR_Msk     (0x1UL)        /*!< PODR (Bitfield-Mask: 0x01)                            */
 #define R_PFS_PORT_PIN_PmnPFS_HA_ASEL_Pos     (15UL)         /*!< ASEL (Bit 15)                                         */
 #define R_PFS_PORT_PIN_PmnPFS_HA_ASEL_Msk     (0x8000UL)     /*!< ASEL (Bitfield-Mask: 0x01)                            */
 #define R_PFS_PORT_PIN_PmnPFS_HA_ISEL_Pos     (14UL)         /*!< ISEL (Bit 14)                                         */
 #define R_PFS_PORT_PIN_PmnPFS_HA_ISEL_Msk     (0x4000UL)     /*!< ISEL (Bitfield-Mask: 0x01)                            */
 #define R_PFS_PORT_PIN_PmnPFS_HA_EOFR_Pos     (12UL)         /*!< EOFR (Bit 12)                                         */
 #define R_PFS_PORT_PIN_PmnPFS_HA_EOFR_Msk     (0x3000UL)     /*!< EOFR (Bitfield-Mask: 0x03)                            */
 #define R_PFS_PORT_PIN_PmnPFS_HA_DSCR_Pos     (10UL)         /*!< DSCR (Bit 10)                                         */
 #define R_PFS_PORT_PIN_PmnPFS_HA_DSCR_Msk     (0xc00UL)      /*!< DSCR (Bitfield-Mask: 0x03)                            */
/* ========================================================  PmnPFS  ========================================================= */
 #define R_PFS_PORT_PIN_PmnPFS_NCODR_Pos       (6UL)          /*!< NCODR (Bit 6)                                         */
 #define R_PFS_PORT_PIN_PmnPFS_NCODR_Msk       (0x40UL)       /*!< NCODR (Bitfield-Mask: 0x01)                           */
 #define R_PFS_PORT_PIN_PmnPFS_PIM_Pos         (5UL)          /*!< PIM (Bit 5)                                           */
 #define R_PFS_PORT_PIN_PmnPFS_PIM_Msk         (0x20UL)       /*!< PIM (Bitfield-Mask: 0x01)                             */
 #define R_PFS_PORT_PIN_PmnPFS_PCR_Pos         (4UL)          /*!< PCR (Bit 4)                                           */
 #define R_PFS_PORT_PIN_PmnPFS_PCR_Msk         (0x10UL)       /*!< PCR (Bitfield-Mask: 0x01)                             */
 #define R_PFS_PORT_PIN_PmnPFS_PDR_Pos         (2UL)          /*!< PDR (Bit 2)                                           */
 #define R_PFS_PORT_PIN_PmnPFS_PDR_Msk         (0x4UL)        /*!< PDR (Bitfield-Mask: 0x01)                             */
 #define R_PFS_PORT_PIN_PmnPFS_PIDR_Pos        (1UL)          /*!< PIDR (Bit 1)                                          */
 #define R_PFS_PORT_PIN_PmnPFS_PIDR_Msk        (0x2UL)        /*!< PIDR (Bitfield-Mask: 0x01)                            */
 #define R_PFS_PORT_PIN_PmnPFS_PODR_Pos        (0UL)          /*!< PODR (Bit 0)                                          */
 #define R_PFS_PORT_PIN_PmnPFS_PODR_Msk        (0x1UL)        /*!< PODR (Bitfield-Mask: 0x01)                            */
 #define R_PFS_PORT_PIN_PmnPFS_ASEL_Pos        (15UL)         /*!< ASEL (Bit 15)                                         */
 #define R_PFS_PORT_PIN_PmnPFS_ASEL_Msk        (0x8000UL)     /*!< ASEL (Bitfield-Mask: 0x01)                            */
 #define R_PFS_PORT_PIN_PmnPFS_ISEL_Pos        (14UL)         /*!< ISEL (Bit 14)                                         */
 #define R_PFS_PORT_PIN_PmnPFS_ISEL_Msk        (0x4000UL)     /*!< ISEL (Bitfield-Mask: 0x01)                            */
 #define R_PFS_PORT_PIN_PmnPFS_EOFR_Pos        (12UL)         /*!< EOFR (Bit 12)                                         */
 #define R_PFS_PORT_PIN_PmnPFS_EOFR_Msk        (0x3000UL)     /*!< EOFR (Bitfield-Mask: 0x03)                            */
 #define R_PFS_PORT_PIN_PmnPFS_DSCR_Pos        (10UL)         /*!< DSCR (Bit 10)                                         */
 #define R_PFS_PORT_PIN_PmnPFS_DSCR_Msk        (0xc00UL)      /*!< DSCR (Bitfield-Mask: 0x03)                            */
 #define R_PFS_PORT_PIN_PmnPFS_PSEL_Pos        (24UL)         /*!< PSEL (Bit 24)                                         */
 #define R_PFS_PORT_PIN_PmnPFS_PSEL_Msk        (0x1f000000UL) /*!< PSEL (Bitfield-Mask: 0x1f)                            */
 #define R_PFS_PORT_PIN_PmnPFS_PMR_Pos         (16UL)         /*!< PMR (Bit 16)                                          */
 #define R_PFS_PORT_PIN_PmnPFS_PMR_Msk         (0x10000UL)    /*!< PMR (Bitfield-Mask: 0x01)                             */

/* =========================================================================================================================== */
/* ================                                           PORT                                            ================ */
/* =========================================================================================================================== */

/* =========================================================================================================================== */
/* ================                                           VLSEL                                           ================ */
/* =========================================================================================================================== */

/* ========================================================  VL1SEL  ========================================================= */
 #define R_PFS_VLSEL_VL1SEL_SELVL_Pos    (0UL)   /*!< SELVL (Bit 0)                                         */
 #define R_PFS_VLSEL_VL1SEL_SELVL_Msk    (0x1UL) /*!< SELVL (Bitfield-Mask: 0x01)                           */

/* =========================================================================================================================== */
/* ================                                           PMSAR                                           ================ */
/* =========================================================================================================================== */

/* =========================================================  PMSAR  ========================================================= */

/* =========================================================================================================================== */
/* ================                                           RTCCR                                           ================ */
/* =========================================================================================================================== */

/* =========================================================  RTCCR  ========================================================= */
 #define R_RTC_RTCCR_RTCCR_TCEN_Pos    (7UL)    /*!< TCEN (Bit 7)                                          */
 #define R_RTC_RTCCR_RTCCR_TCEN_Msk    (0x80UL) /*!< TCEN (Bitfield-Mask: 0x01)                            */

/* =========================================================================================================================== */
/* ================                                            CSa                                            ================ */
/* =========================================================================================================================== */

/* ==========================================================  MOD  ========================================================== */
 #define R_BUS_B_CSa_MOD_PRMOD_Pos        (15UL)         /*!< PRMOD (Bit 15)                                        */
 #define R_BUS_B_CSa_MOD_PRMOD_Msk        (0x8000UL)     /*!< PRMOD (Bitfield-Mask: 0x01)                           */
 #define R_BUS_B_CSa_MOD_PWENB_Pos        (9UL)          /*!< PWENB (Bit 9)                                         */
 #define R_BUS_B_CSa_MOD_PWENB_Msk        (0x200UL)      /*!< PWENB (Bitfield-Mask: 0x01)                           */
 #define R_BUS_B_CSa_MOD_PRENB_Pos        (8UL)          /*!< PRENB (Bit 8)                                         */
 #define R_BUS_B_CSa_MOD_PRENB_Msk        (0x100UL)      /*!< PRENB (Bitfield-Mask: 0x01)                           */
 #define R_BUS_B_CSa_MOD_EWENB_Pos        (3UL)          /*!< EWENB (Bit 3)                                         */
 #define R_BUS_B_CSa_MOD_EWENB_Msk        (0x8UL)        /*!< EWENB (Bitfield-Mask: 0x01)                           */
 #define R_BUS_B_CSa_MOD_WRMOD_Pos        (0UL)          /*!< WRMOD (Bit 0)                                         */
 #define R_BUS_B_CSa_MOD_WRMOD_Msk        (0x1UL)        /*!< WRMOD (Bitfield-Mask: 0x01)                           */
/* =========================================================  WCR1  ========================================================== */
 #define R_BUS_B_CSa_WCR1_CSRWAIT_Pos     (24UL)         /*!< CSRWAIT (Bit 24)                                      */
 #define R_BUS_B_CSa_WCR1_CSRWAIT_Msk     (0x1f000000UL) /*!< CSRWAIT (Bitfield-Mask: 0x1f)                         */
 #define R_BUS_B_CSa_WCR1_CSWWAIT_Pos     (16UL)         /*!< CSWWAIT (Bit 16)                                      */
 #define R_BUS_B_CSa_WCR1_CSWWAIT_Msk     (0x1f0000UL)   /*!< CSWWAIT (Bitfield-Mask: 0x1f)                         */
 #define R_BUS_B_CSa_WCR1_CSPRWAIT_Pos    (8UL)          /*!< CSPRWAIT (Bit 8)                                      */
 #define R_BUS_B_CSa_WCR1_CSPRWAIT_Msk    (0x700UL)      /*!< CSPRWAIT (Bitfield-Mask: 0x07)                        */
 #define R_BUS_B_CSa_WCR1_CSPWWAIT_Pos    (0UL)          /*!< CSPWWAIT (Bit 0)                                      */
 #define R_BUS_B_CSa_WCR1_CSPWWAIT_Msk    (0x7UL)        /*!< CSPWWAIT (Bitfield-Mask: 0x07)                        */
/* =========================================================  WCR2  ========================================================== */
 #define R_BUS_B_CSa_WCR2_CSON_Pos        (28UL)         /*!< CSON (Bit 28)                                         */
 #define R_BUS_B_CSa_WCR2_CSON_Msk        (0x70000000UL) /*!< CSON (Bitfield-Mask: 0x07)                            */
 #define R_BUS_B_CSa_WCR2_WDON_Pos        (24UL)         /*!< WDON (Bit 24)                                         */
 #define R_BUS_B_CSa_WCR2_WDON_Msk        (0x7000000UL)  /*!< WDON (Bitfield-Mask: 0x07)                            */
 #define R_BUS_B_CSa_WCR2_WRON_Pos        (20UL)         /*!< WRON (Bit 20)                                         */
 #define R_BUS_B_CSa_WCR2_WRON_Msk        (0x700000UL)   /*!< WRON (Bitfield-Mask: 0x07)                            */
 #define R_BUS_B_CSa_WCR2_RDON_Pos        (16UL)         /*!< RDON (Bit 16)                                         */
 #define R_BUS_B_CSa_WCR2_RDON_Msk        (0x70000UL)    /*!< RDON (Bitfield-Mask: 0x07)                            */
 #define R_BUS_B_CSa_WCR2_AWAIT_Pos       (12UL)         /*!< AWAIT (Bit 12)                                        */
 #define R_BUS_B_CSa_WCR2_AWAIT_Msk       (0x3000UL)     /*!< AWAIT (Bitfield-Mask: 0x03)                           */
 #define R_BUS_B_CSa_WCR2_WDOFF_Pos       (8UL)          /*!< WDOFF (Bit 8)                                         */
 #define R_BUS_B_CSa_WCR2_WDOFF_Msk       (0x700UL)      /*!< WDOFF (Bitfield-Mask: 0x07)                           */
 #define R_BUS_B_CSa_WCR2_CSWOFF_Pos      (4UL)          /*!< CSWOFF (Bit 4)                                        */
 #define R_BUS_B_CSa_WCR2_CSWOFF_Msk      (0x70UL)       /*!< CSWOFF (Bitfield-Mask: 0x07)                          */
 #define R_BUS_B_CSa_WCR2_CSROFF_Pos      (0UL)          /*!< CSROFF (Bit 0)                                        */
 #define R_BUS_B_CSa_WCR2_CSROFF_Msk      (0x7UL)        /*!< CSROFF (Bitfield-Mask: 0x07)                          */

/* =========================================================================================================================== */
/* ================                                            CSb                                            ================ */
/* =========================================================================================================================== */

/* ==========================================================  CR  =========================================================== */
 #define R_BUS_B_CSb_CR_MPXEN_Pos    (12UL)     /*!< MPXEN (Bit 12)                                        */
 #define R_BUS_B_CSb_CR_MPXEN_Msk    (0x1000UL) /*!< MPXEN (Bitfield-Mask: 0x01)                           */
 #define R_BUS_B_CSb_CR_EMODE_Pos    (8UL)      /*!< EMODE (Bit 8)                                         */
 #define R_BUS_B_CSb_CR_EMODE_Msk    (0x100UL)  /*!< EMODE (Bitfield-Mask: 0x01)                           */
 #define R_BUS_B_CSb_CR_BSIZE_Pos    (4UL)      /*!< BSIZE (Bit 4)                                         */
 #define R_BUS_B_CSb_CR_BSIZE_Msk    (0x30UL)   /*!< BSIZE (Bitfield-Mask: 0x03)                           */
 #define R_BUS_B_CSb_CR_EXENB_Pos    (0UL)      /*!< EXENB (Bit 0)                                         */
 #define R_BUS_B_CSb_CR_EXENB_Msk    (0x1UL)    /*!< EXENB (Bitfield-Mask: 0x01)                           */
/* ==========================================================  REC  ========================================================== */
 #define R_BUS_B_CSb_REC_WRCV_Pos    (8UL)      /*!< WRCV (Bit 8)                                          */
 #define R_BUS_B_CSb_REC_WRCV_Msk    (0xf00UL)  /*!< WRCV (Bitfield-Mask: 0x0f)                            */
 #define R_BUS_B_CSb_REC_RRCV_Pos    (0UL)      /*!< RRCV (Bit 0)                                          */
 #define R_BUS_B_CSb_REC_RRCV_Msk    (0xfUL)    /*!< RRCV (Bitfield-Mask: 0x0f)                            */

/* =========================================================================================================================== */
/* ================                                          BUSERR                                           ================ */
/* =========================================================================================================================== */

/* ==========================================================  ADD  ========================================================== */
 #define R_BUS_B_BUSERR_ADD_BERAD_Pos       (0UL)          /*!< BERAD (Bit 0)                                         */
 #define R_BUS_B_BUSERR_ADD_BERAD_Msk       (0xffffffffUL) /*!< BERAD (Bitfield-Mask: 0xffffffff)                     */
/* =========================================================  ERRRW  ========================================================= */
 #define R_BUS_B_BUSERR_ERRRW_RWSTAT_Pos    (0UL)          /*!< RWSTAT (Bit 0)                                        */
 #define R_BUS_B_BUSERR_ERRRW_RWSTAT_Msk    (0x1UL)        /*!< RWSTAT (Bitfield-Mask: 0x01)                          */

/* =========================================================================================================================== */
/* ================                                         BUSTZFERR                                         ================ */
/* =========================================================================================================================== */

/* ========================================================  TZFADD  ========================================================= */
 #define R_BUS_B_BUSTZFERR_TZFADD_BTZFERAD_Pos     (0UL)          /*!< BTZFERAD (Bit 0)                                      */
 #define R_BUS_B_BUSTZFERR_TZFADD_BTZFERAD_Msk     (0xffffffffUL) /*!< BTZFERAD (Bitfield-Mask: 0xffffffff)                  */
/* =======================================================  TZFERRRW  ======================================================== */
 #define R_BUS_B_BUSTZFERR_TZFERRRW_TRWSTAT_Pos    (0UL)          /*!< TRWSTAT (Bit 0)                                       */
 #define R_BUS_B_BUSTZFERR_TZFERRRW_TRWSTAT_Msk    (0x1UL)        /*!< TRWSTAT (Bitfield-Mask: 0x01)                         */

/* =========================================================================================================================== */
/* ================                                          PIPE_TR                                          ================ */
/* =========================================================================================================================== */

/* ===========================================================  E  =========================================================== */
 #define R_USB_FS0_PIPE_TR_E_TRENB_Pos     (9UL)      /*!< TRENB (Bit 9)                                         */
 #define R_USB_FS0_PIPE_TR_E_TRENB_Msk     (0x200UL)  /*!< TRENB (Bitfield-Mask: 0x01)                           */
 #define R_USB_FS0_PIPE_TR_E_TRCLR_Pos     (8UL)      /*!< TRCLR (Bit 8)                                         */
 #define R_USB_FS0_PIPE_TR_E_TRCLR_Msk     (0x100UL)  /*!< TRCLR (Bitfield-Mask: 0x01)                           */
/* ===========================================================  N  =========================================================== */
 #define R_USB_FS0_PIPE_TR_N_TRNCNT_Pos    (0UL)      /*!< TRNCNT (Bit 0)                                        */
 #define R_USB_FS0_PIPE_TR_N_TRNCNT_Msk    (0xffffUL) /*!< TRNCNT (Bitfield-Mask: 0xffff)                        */

/* =========================================================================================================================== */
/* ================                                           CTRL                                            ================ */
/* =========================================================================================================================== */

/* =========================================================  AGTCR  ========================================================= */
 #define R_AGTX0_AGT16_CTRL_AGTCR_TCMBF_Pos          (7UL)    /*!< TCMBF (Bit 7)                                         */
 #define R_AGTX0_AGT16_CTRL_AGTCR_TCMBF_Msk          (0x80UL) /*!< TCMBF (Bitfield-Mask: 0x01)                           */
 #define R_AGTX0_AGT16_CTRL_AGTCR_TCMAF_Pos          (6UL)    /*!< TCMAF (Bit 6)                                         */
 #define R_AGTX0_AGT16_CTRL_AGTCR_TCMAF_Msk          (0x40UL) /*!< TCMAF (Bitfield-Mask: 0x01)                           */
 #define R_AGTX0_AGT16_CTRL_AGTCR_TUNDF_Pos          (5UL)    /*!< TUNDF (Bit 5)                                         */
 #define R_AGTX0_AGT16_CTRL_AGTCR_TUNDF_Msk          (0x20UL) /*!< TUNDF (Bitfield-Mask: 0x01)                           */
 #define R_AGTX0_AGT16_CTRL_AGTCR_TEDGF_Pos          (4UL)    /*!< TEDGF (Bit 4)                                         */
 #define R_AGTX0_AGT16_CTRL_AGTCR_TEDGF_Msk          (0x10UL) /*!< TEDGF (Bitfield-Mask: 0x01)                           */
 #define R_AGTX0_AGT16_CTRL_AGTCR_TSTOP_Pos          (2UL)    /*!< TSTOP (Bit 2)                                         */
 #define R_AGTX0_AGT16_CTRL_AGTCR_TSTOP_Msk          (0x4UL)  /*!< TSTOP (Bitfield-Mask: 0x01)                           */
 #define R_AGTX0_AGT16_CTRL_AGTCR_TCSTF_Pos          (1UL)    /*!< TCSTF (Bit 1)                                         */
 #define R_AGTX0_AGT16_CTRL_AGTCR_TCSTF_Msk          (0x2UL)  /*!< TCSTF (Bitfield-Mask: 0x01)                           */
 #define R_AGTX0_AGT16_CTRL_AGTCR_TSTART_Pos         (0UL)    /*!< TSTART (Bit 0)                                        */
 #define R_AGTX0_AGT16_CTRL_AGTCR_TSTART_Msk         (0x1UL)  /*!< TSTART (Bitfield-Mask: 0x01)                          */
/* ========================================================  AGTMR1  ========================================================= */
 #define R_AGTX0_AGT16_CTRL_AGTMR1_TCK_Pos           (4UL)    /*!< TCK (Bit 4)                                           */
 #define R_AGTX0_AGT16_CTRL_AGTMR1_TCK_Msk           (0x70UL) /*!< TCK (Bitfield-Mask: 0x07)                             */
 #define R_AGTX0_AGT16_CTRL_AGTMR1_TEDGPL_Pos        (3UL)    /*!< TEDGPL (Bit 3)                                        */
 #define R_AGTX0_AGT16_CTRL_AGTMR1_TEDGPL_Msk        (0x8UL)  /*!< TEDGPL (Bitfield-Mask: 0x01)                          */
 #define R_AGTX0_AGT16_CTRL_AGTMR1_TMOD_Pos          (0UL)    /*!< TMOD (Bit 0)                                          */
 #define R_AGTX0_AGT16_CTRL_AGTMR1_TMOD_Msk          (0x7UL)  /*!< TMOD (Bitfield-Mask: 0x07)                            */
/* ========================================================  AGTMR2  ========================================================= */
 #define R_AGTX0_AGT16_CTRL_AGTMR2_LPM_Pos           (7UL)    /*!< LPM (Bit 7)                                           */
 #define R_AGTX0_AGT16_CTRL_AGTMR2_LPM_Msk           (0x80UL) /*!< LPM (Bitfield-Mask: 0x01)                             */
 #define R_AGTX0_AGT16_CTRL_AGTMR2_CKS_Pos           (0UL)    /*!< CKS (Bit 0)                                           */
 #define R_AGTX0_AGT16_CTRL_AGTMR2_CKS_Msk           (0x7UL)  /*!< CKS (Bitfield-Mask: 0x07)                             */
/* =====================================================  AGTIOSEL_ALT  ====================================================== */
 #define R_AGTX0_AGT16_CTRL_AGTIOSEL_ALT_TIES_Pos    (4UL)    /*!< TIES (Bit 4)                                          */
 #define R_AGTX0_AGT16_CTRL_AGTIOSEL_ALT_TIES_Msk    (0x10UL) /*!< TIES (Bitfield-Mask: 0x01)                            */
 #define R_AGTX0_AGT16_CTRL_AGTIOSEL_ALT_SEL_Pos     (0UL)    /*!< SEL (Bit 0)                                           */
 #define R_AGTX0_AGT16_CTRL_AGTIOSEL_ALT_SEL_Msk     (0x3UL)  /*!< SEL (Bitfield-Mask: 0x03)                             */
/* ========================================================  AGTIOC  ========================================================= */
 #define R_AGTX0_AGT16_CTRL_AGTIOC_TIOGT_Pos         (6UL)    /*!< TIOGT (Bit 6)                                         */
 #define R_AGTX0_AGT16_CTRL_AGTIOC_TIOGT_Msk         (0xc0UL) /*!< TIOGT (Bitfield-Mask: 0x03)                           */
 #define R_AGTX0_AGT16_CTRL_AGTIOC_TIPF_Pos          (4UL)    /*!< TIPF (Bit 4)                                          */
 #define R_AGTX0_AGT16_CTRL_AGTIOC_TIPF_Msk          (0x30UL) /*!< TIPF (Bitfield-Mask: 0x03)                            */
 #define R_AGTX0_AGT16_CTRL_AGTIOC_TOE_Pos           (2UL)    /*!< TOE (Bit 2)                                           */
 #define R_AGTX0_AGT16_CTRL_AGTIOC_TOE_Msk           (0x4UL)  /*!< TOE (Bitfield-Mask: 0x01)                             */
 #define R_AGTX0_AGT16_CTRL_AGTIOC_TEDGSEL_Pos       (0UL)    /*!< TEDGSEL (Bit 0)                                       */
 #define R_AGTX0_AGT16_CTRL_AGTIOC_TEDGSEL_Msk       (0x1UL)  /*!< TEDGSEL (Bitfield-Mask: 0x01)                         */
/* ========================================================  AGTISR  ========================================================= */
 #define R_AGTX0_AGT16_CTRL_AGTISR_EEPS_Pos          (2UL)    /*!< EEPS (Bit 2)                                          */
 #define R_AGTX0_AGT16_CTRL_AGTISR_EEPS_Msk          (0x4UL)  /*!< EEPS (Bitfield-Mask: 0x01)                            */
/* ========================================================  AGTCMSR  ======================================================== */
 #define R_AGTX0_AGT16_CTRL_AGTCMSR_TOPOLB_Pos       (6UL)    /*!< TOPOLB (Bit 6)                                        */
 #define R_AGTX0_AGT16_CTRL_AGTCMSR_TOPOLB_Msk       (0x40UL) /*!< TOPOLB (Bitfield-Mask: 0x01)                          */
 #define R_AGTX0_AGT16_CTRL_AGTCMSR_TOEB_Pos         (5UL)    /*!< TOEB (Bit 5)                                          */
 #define R_AGTX0_AGT16_CTRL_AGTCMSR_TOEB_Msk         (0x20UL) /*!< TOEB (Bitfield-Mask: 0x01)                            */
 #define R_AGTX0_AGT16_CTRL_AGTCMSR_TCMEB_Pos        (4UL)    /*!< TCMEB (Bit 4)                                         */
 #define R_AGTX0_AGT16_CTRL_AGTCMSR_TCMEB_Msk        (0x10UL) /*!< TCMEB (Bitfield-Mask: 0x01)                           */
 #define R_AGTX0_AGT16_CTRL_AGTCMSR_TOPOLA_Pos       (2UL)    /*!< TOPOLA (Bit 2)                                        */
 #define R_AGTX0_AGT16_CTRL_AGTCMSR_TOPOLA_Msk       (0x4UL)  /*!< TOPOLA (Bitfield-Mask: 0x01)                          */
 #define R_AGTX0_AGT16_CTRL_AGTCMSR_TOEA_Pos         (1UL)    /*!< TOEA (Bit 1)                                          */
 #define R_AGTX0_AGT16_CTRL_AGTCMSR_TOEA_Msk         (0x2UL)  /*!< TOEA (Bitfield-Mask: 0x01)                            */
 #define R_AGTX0_AGT16_CTRL_AGTCMSR_TCMEA_Pos        (0UL)    /*!< TCMEA (Bit 0)                                         */
 #define R_AGTX0_AGT16_CTRL_AGTCMSR_TCMEA_Msk        (0x1UL)  /*!< TCMEA (Bitfield-Mask: 0x01)                           */
/* =======================================================  AGTIOSEL  ======================================================== */
 #define R_AGTX0_AGT16_CTRL_AGTIOSEL_TIES_Pos        (4UL)    /*!< TIES (Bit 4)                                          */
 #define R_AGTX0_AGT16_CTRL_AGTIOSEL_TIES_Msk        (0x10UL) /*!< TIES (Bitfield-Mask: 0x01)                            */
 #define R_AGTX0_AGT16_CTRL_AGTIOSEL_SEL_Pos         (0UL)    /*!< SEL (Bit 0)                                           */
 #define R_AGTX0_AGT16_CTRL_AGTIOSEL_SEL_Msk         (0x3UL)  /*!< SEL (Bitfield-Mask: 0x03)                             */

/* =========================================================================================================================== */
/* ================                                           AGT16                                           ================ */
/* =========================================================================================================================== */

/* ==========================================================  AGT  ========================================================== */
 #define R_AGTX0_AGT16_AGT_AGT_Pos          (0UL)      /*!< AGT (Bit 0)                                           */
 #define R_AGTX0_AGT16_AGT_AGT_Msk          (0xffffUL) /*!< AGT (Bitfield-Mask: 0xffff)                           */
/* ========================================================  AGTCMA  ========================================================= */
 #define R_AGTX0_AGT16_AGTCMA_AGTCMA_Pos    (0UL)      /*!< AGTCMA (Bit 0)                                        */
 #define R_AGTX0_AGT16_AGTCMA_AGTCMA_Msk    (0xffffUL) /*!< AGTCMA (Bitfield-Mask: 0xffff)                        */
/* ========================================================  AGTCMB  ========================================================= */
 #define R_AGTX0_AGT16_AGTCMB_AGTCMB_Pos    (0UL)      /*!< AGTCMB (Bit 0)                                        */
 #define R_AGTX0_AGT16_AGTCMB_AGTCMB_Msk    (0xffffUL) /*!< AGTCMB (Bitfield-Mask: 0xffff)                        */

/* =========================================================================================================================== */
/* ================                                           AGT32                                           ================ */
/* =========================================================================================================================== */

/* ==========================================================  AGT  ========================================================== */
 #define R_AGTX0_AGT32_AGT_AGT_Pos          (0UL)          /*!< AGT (Bit 0)                                           */
 #define R_AGTX0_AGT32_AGT_AGT_Msk          (0xffffffffUL) /*!< AGT (Bitfield-Mask: 0xffffffff)                       */
/* ========================================================  AGTCMA  ========================================================= */
 #define R_AGTX0_AGT32_AGTCMA_AGTCMA_Pos    (0UL)          /*!< AGTCMA (Bit 0)                                        */
 #define R_AGTX0_AGT32_AGTCMA_AGTCMA_Msk    (0xffffffffUL) /*!< AGTCMA (Bitfield-Mask: 0xffffffff)                    */
/* ========================================================  AGTCMB  ========================================================= */
 #define R_AGTX0_AGT32_AGTCMB_AGTCMB_Pos    (0UL)          /*!< AGTCMB (Bit 0)                                        */
 #define R_AGTX0_AGT32_AGTCMB_AGTCMB_Msk    (0xffffffffUL) /*!< AGTCMB (Bitfield-Mask: 0xffffffff)                    */

/** @} */ /* End of group PosMask_clusters */

/* =========================================================================================================================== */
/* ================                                Pos/Mask Peripheral Section                                ================ */
/* =========================================================================================================================== */

/** @addtogroup PosMask_peripherals
 * @{
 */

/* =========================================================================================================================== */
/* ================                                         R_ACMPHS0                                         ================ */
/* =========================================================================================================================== */

/* ========================================================  CMPCTL  ========================================================= */
 #define R_ACMPHS0_CMPCTL_HCMPON_Pos     (7UL)    /*!< HCMPON (Bit 7)                                        */
 #define R_ACMPHS0_CMPCTL_HCMPON_Msk     (0x80UL) /*!< HCMPON (Bitfield-Mask: 0x01)                          */
 #define R_ACMPHS0_CMPCTL_CDFS_Pos       (5UL)    /*!< CDFS (Bit 5)                                          */
 #define R_ACMPHS0_CMPCTL_CDFS_Msk       (0x60UL) /*!< CDFS (Bitfield-Mask: 0x03)                            */
 #define R_ACMPHS0_CMPCTL_CEG_Pos        (3UL)    /*!< CEG (Bit 3)                                           */
 #define R_ACMPHS0_CMPCTL_CEG_Msk        (0x18UL) /*!< CEG (Bitfield-Mask: 0x03)                             */
 #define R_ACMPHS0_CMPCTL_CSTEN_Pos      (2UL)    /*!< CSTEN (Bit 2)                                         */
 #define R_ACMPHS0_CMPCTL_CSTEN_Msk      (0x4UL)  /*!< CSTEN (Bitfield-Mask: 0x01)                           */
 #define R_ACMPHS0_CMPCTL_COE_Pos        (1UL)    /*!< COE (Bit 1)                                           */
 #define R_ACMPHS0_CMPCTL_COE_Msk        (0x2UL)  /*!< COE (Bitfield-Mask: 0x01)                             */
 #define R_ACMPHS0_CMPCTL_CINV_Pos       (0UL)    /*!< CINV (Bit 0)                                          */
 #define R_ACMPHS0_CMPCTL_CINV_Msk       (0x1UL)  /*!< CINV (Bitfield-Mask: 0x01)                            */
/* ========================================================  CMPSEL0  ======================================================== */
 #define R_ACMPHS0_CMPSEL0_CMPSEL_Pos    (0UL)    /*!< CMPSEL (Bit 0)                                        */
 #define R_ACMPHS0_CMPSEL0_CMPSEL_Msk    (0xfUL)  /*!< CMPSEL (Bitfield-Mask: 0x0f)                          */
/* ========================================================  CMPSEL1  ======================================================== */
 #define R_ACMPHS0_CMPSEL1_CRVS_Pos      (0UL)    /*!< CRVS (Bit 0)                                          */
 #define R_ACMPHS0_CMPSEL1_CRVS_Msk      (0x3fUL) /*!< CRVS (Bitfield-Mask: 0x3f)                            */
/* ========================================================  CMPMON  ========================================================= */
 #define R_ACMPHS0_CMPMON_CMPMON_Pos     (0UL)    /*!< CMPMON (Bit 0)                                        */
 #define R_ACMPHS0_CMPMON_CMPMON_Msk     (0x1UL)  /*!< CMPMON (Bitfield-Mask: 0x01)                          */
/* =========================================================  CPIOC  ========================================================= */
 #define R_ACMPHS0_CPIOC_VREFEN_Pos      (7UL)    /*!< VREFEN (Bit 7)                                        */
 #define R_ACMPHS0_CPIOC_VREFEN_Msk      (0x80UL) /*!< VREFEN (Bitfield-Mask: 0x01)                          */
 #define R_ACMPHS0_CPIOC_CPOE_Pos        (0UL)    /*!< CPOE (Bit 0)                                          */
 #define R_ACMPHS0_CPIOC_CPOE_Msk        (0x1UL)  /*!< CPOE (Bitfield-Mask: 0x01)                            */

/* =========================================================================================================================== */
/* ================                                          R_ADC0                                           ================ */
/* =========================================================================================================================== */

/* =========================================================  ADCSR  ========================================================= */
 #define R_ADC0_ADCSR_ADST_Pos              (15UL)      /*!< ADST (Bit 15)                                         */
 #define R_ADC0_ADCSR_ADST_Msk              (0x8000UL)  /*!< ADST (Bitfield-Mask: 0x01)                            */
 #define R_ADC0_ADCSR_ADCS_Pos              (13UL)      /*!< ADCS (Bit 13)                                         */
 #define R_ADC0_ADCSR_ADCS_Msk              (0x6000UL)  /*!< ADCS (Bitfield-Mask: 0x03)                            */
 #define R_ADC0_ADCSR_ADHSC_Pos             (10UL)      /*!< ADHSC (Bit 10)                                        */
 #define R_ADC0_ADCSR_ADHSC_Msk             (0x400UL)   /*!< ADHSC (Bitfield-Mask: 0x01)                           */
 #define R_ADC0_ADCSR_TRGE_Pos              (9UL)       /*!< TRGE (Bit 9)                                          */
 #define R_ADC0_ADCSR_TRGE_Msk              (0x200UL)   /*!< TRGE (Bitfield-Mask: 0x01)                            */
 #define R_ADC0_ADCSR_EXTRG_Pos             (8UL)       /*!< EXTRG (Bit 8)                                         */
 #define R_ADC0_ADCSR_EXTRG_Msk             (0x100UL)   /*!< EXTRG (Bitfield-Mask: 0x01)                           */
 #define R_ADC0_ADCSR_DBLE_Pos              (7UL)       /*!< DBLE (Bit 7)                                          */
 #define R_ADC0_ADCSR_DBLE_Msk              (0x80UL)    /*!< DBLE (Bitfield-Mask: 0x01)                            */
 #define R_ADC0_ADCSR_GBADIE_Pos            (6UL)       /*!< GBADIE (Bit 6)                                        */
 #define R_ADC0_ADCSR_GBADIE_Msk            (0x40UL)    /*!< GBADIE (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADCSR_DBLANS_Pos            (0UL)       /*!< DBLANS (Bit 0)                                        */
 #define R_ADC0_ADCSR_DBLANS_Msk            (0x1fUL)    /*!< DBLANS (Bitfield-Mask: 0x1f)                          */
 #define R_ADC0_ADCSR_ADIE_Pos              (12UL)      /*!< ADIE (Bit 12)                                         */
 #define R_ADC0_ADCSR_ADIE_Msk              (0x1000UL)  /*!< ADIE (Bitfield-Mask: 0x01)                            */
/* ========================================================  ADANSA  ========================================================= */
 #define R_ADC0_ADANSA_ANSA_Pos             (0UL)       /*!< ANSA (Bit 0)                                          */
 #define R_ADC0_ADANSA_ANSA_Msk             (0x1UL)     /*!< ANSA (Bitfield-Mask: 0x01)                            */
/* =========================================================  ADADS  ========================================================= */
 #define R_ADC0_ADADS_ADS_Pos               (0UL)       /*!< ADS (Bit 0)                                           */
 #define R_ADC0_ADADS_ADS_Msk               (0x1UL)     /*!< ADS (Bitfield-Mask: 0x01)                             */
/* =========================================================  ADADC  ========================================================= */
 #define R_ADC0_ADADC_ADC_Pos               (0UL)       /*!< ADC (Bit 0)                                           */
 #define R_ADC0_ADADC_ADC_Msk               (0x7UL)     /*!< ADC (Bitfield-Mask: 0x07)                             */
 #define R_ADC0_ADADC_AVEE_Pos              (7UL)       /*!< AVEE (Bit 7)                                          */
 #define R_ADC0_ADADC_AVEE_Msk              (0x80UL)    /*!< AVEE (Bitfield-Mask: 0x01)                            */
/* =========================================================  ADCER  ========================================================= */
 #define R_ADC0_ADCER_ADRFMT_Pos            (15UL)      /*!< ADRFMT (Bit 15)                                       */
 #define R_ADC0_ADCER_ADRFMT_Msk            (0x8000UL)  /*!< ADRFMT (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADCER_ADINV_Pos             (14UL)      /*!< ADINV (Bit 14)                                        */
 #define R_ADC0_ADCER_ADINV_Msk             (0x4000UL)  /*!< ADINV (Bitfield-Mask: 0x01)                           */
 #define R_ADC0_ADCER_DIAGM_Pos             (11UL)      /*!< DIAGM (Bit 11)                                        */
 #define R_ADC0_ADCER_DIAGM_Msk             (0x800UL)   /*!< DIAGM (Bitfield-Mask: 0x01)                           */
 #define R_ADC0_ADCER_DIAGLD_Pos            (10UL)      /*!< DIAGLD (Bit 10)                                       */
 #define R_ADC0_ADCER_DIAGLD_Msk            (0x400UL)   /*!< DIAGLD (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADCER_DIAGVAL_Pos           (8UL)       /*!< DIAGVAL (Bit 8)                                       */
 #define R_ADC0_ADCER_DIAGVAL_Msk           (0x300UL)   /*!< DIAGVAL (Bitfield-Mask: 0x03)                         */
 #define R_ADC0_ADCER_ACE_Pos               (5UL)       /*!< ACE (Bit 5)                                           */
 #define R_ADC0_ADCER_ACE_Msk               (0x20UL)    /*!< ACE (Bitfield-Mask: 0x01)                             */
 #define R_ADC0_ADCER_ADPRC_Pos             (1UL)       /*!< ADPRC (Bit 1)                                         */
 #define R_ADC0_ADCER_ADPRC_Msk             (0x6UL)     /*!< ADPRC (Bitfield-Mask: 0x03)                           */
 #define R_ADC0_ADCER_DCE_Pos               (4UL)       /*!< DCE (Bit 4)                                           */
 #define R_ADC0_ADCER_DCE_Msk               (0x10UL)    /*!< DCE (Bitfield-Mask: 0x01)                             */
/* ========================================================  ADSTRGR  ======================================================== */
 #define R_ADC0_ADSTRGR_TRSA_Pos            (8UL)       /*!< TRSA (Bit 8)                                          */
 #define R_ADC0_ADSTRGR_TRSA_Msk            (0x3f00UL)  /*!< TRSA (Bitfield-Mask: 0x3f)                            */
 #define R_ADC0_ADSTRGR_TRSB_Pos            (0UL)       /*!< TRSB (Bit 0)                                          */
 #define R_ADC0_ADSTRGR_TRSB_Msk            (0x3fUL)    /*!< TRSB (Bitfield-Mask: 0x3f)                            */
/* ========================================================  ADEXICR  ======================================================== */
 #define R_ADC0_ADEXICR_OCSB_Pos            (11UL)      /*!< OCSB (Bit 11)                                         */
 #define R_ADC0_ADEXICR_OCSB_Msk            (0x800UL)   /*!< OCSB (Bitfield-Mask: 0x01)                            */
 #define R_ADC0_ADEXICR_TSSB_Pos            (10UL)      /*!< TSSB (Bit 10)                                         */
 #define R_ADC0_ADEXICR_TSSB_Msk            (0x400UL)   /*!< TSSB (Bitfield-Mask: 0x01)                            */
 #define R_ADC0_ADEXICR_OCSA_Pos            (9UL)       /*!< OCSA (Bit 9)                                          */
 #define R_ADC0_ADEXICR_OCSA_Msk            (0x200UL)   /*!< OCSA (Bitfield-Mask: 0x01)                            */
 #define R_ADC0_ADEXICR_TSSA_Pos            (8UL)       /*!< TSSA (Bit 8)                                          */
 #define R_ADC0_ADEXICR_TSSA_Msk            (0x100UL)   /*!< TSSA (Bitfield-Mask: 0x01)                            */
 #define R_ADC0_ADEXICR_OCSAD_Pos           (1UL)       /*!< OCSAD (Bit 1)                                         */
 #define R_ADC0_ADEXICR_OCSAD_Msk           (0x2UL)     /*!< OCSAD (Bitfield-Mask: 0x01)                           */
 #define R_ADC0_ADEXICR_TSSAD_Pos           (0UL)       /*!< TSSAD (Bit 0)                                         */
 #define R_ADC0_ADEXICR_TSSAD_Msk           (0x1UL)     /*!< TSSAD (Bitfield-Mask: 0x01)                           */
 #define R_ADC0_ADEXICR_EXSEL_Pos           (14UL)      /*!< EXSEL (Bit 14)                                        */
 #define R_ADC0_ADEXICR_EXSEL_Msk           (0x4000UL)  /*!< EXSEL (Bitfield-Mask: 0x01)                           */
 #define R_ADC0_ADEXICR_EXOEN_Pos           (15UL)      /*!< EXOEN (Bit 15)                                        */
 #define R_ADC0_ADEXICR_EXOEN_Msk           (0x8000UL)  /*!< EXOEN (Bitfield-Mask: 0x01)                           */
/* ========================================================  ADANSB  ========================================================= */
 #define R_ADC0_ADANSB_ANSB_Pos             (0UL)       /*!< ANSB (Bit 0)                                          */
 #define R_ADC0_ADANSB_ANSB_Msk             (0x1UL)     /*!< ANSB (Bitfield-Mask: 0x01)                            */
/* ========================================================  ADDBLDR  ======================================================== */
 #define R_ADC0_ADDBLDR_ADDBLDR_Pos         (0UL)       /*!< ADDBLDR (Bit 0)                                       */
 #define R_ADC0_ADDBLDR_ADDBLDR_Msk         (0xffffUL)  /*!< ADDBLDR (Bitfield-Mask: 0xffff)                       */
/* ========================================================  ADTSDR  ========================================================= */
 #define R_ADC0_ADTSDR_ADTSDR_Pos           (0UL)       /*!< ADTSDR (Bit 0)                                        */
 #define R_ADC0_ADTSDR_ADTSDR_Msk           (0xffffUL)  /*!< ADTSDR (Bitfield-Mask: 0xffff)                        */
/* ========================================================  ADOCDR  ========================================================= */
 #define R_ADC0_ADOCDR_ADOCDR_Pos           (0UL)       /*!< ADOCDR (Bit 0)                                        */
 #define R_ADC0_ADOCDR_ADOCDR_Msk           (0xffffUL)  /*!< ADOCDR (Bitfield-Mask: 0xffff)                        */
/* ======================================================  ADRD_RIGHT  ======================================================= */
 #define R_ADC0_ADRD_RIGHT_DIAGST_Pos       (14UL)      /*!< DIAGST (Bit 14)                                       */
 #define R_ADC0_ADRD_RIGHT_DIAGST_Msk       (0xc000UL)  /*!< DIAGST (Bitfield-Mask: 0x03)                          */
 #define R_ADC0_ADRD_RIGHT_AD_Pos           (0UL)       /*!< AD (Bit 0)                                            */
 #define R_ADC0_ADRD_RIGHT_AD_Msk           (0x3fffUL)  /*!< AD (Bitfield-Mask: 0x3fff)                            */
/* =======================================================  ADRD_LEFT  ======================================================= */
 #define R_ADC0_ADRD_LEFT_AD_Pos            (2UL)       /*!< AD (Bit 2)                                            */
 #define R_ADC0_ADRD_LEFT_AD_Msk            (0xfffcUL)  /*!< AD (Bitfield-Mask: 0x3fff)                            */
 #define R_ADC0_ADRD_LEFT_DIAGST_Pos        (0UL)       /*!< DIAGST (Bit 0)                                        */
 #define R_ADC0_ADRD_LEFT_DIAGST_Msk        (0x3UL)     /*!< DIAGST (Bitfield-Mask: 0x03)                          */
/* =========================================================  ADDR  ========================================================== */
 #define R_ADC0_ADDR_ADDR_Pos               (0UL)       /*!< ADDR (Bit 0)                                          */
 #define R_ADC0_ADDR_ADDR_Msk               (0xffffUL)  /*!< ADDR (Bitfield-Mask: 0xffff)                          */
/* ========================================================  ADSHCR  ========================================================= */
 #define R_ADC0_ADSHCR_SHANS2_Pos           (10UL)      /*!< SHANS2 (Bit 10)                                       */
 #define R_ADC0_ADSHCR_SHANS2_Msk           (0x400UL)   /*!< SHANS2 (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADSHCR_SHANS1_Pos           (9UL)       /*!< SHANS1 (Bit 9)                                        */
 #define R_ADC0_ADSHCR_SHANS1_Msk           (0x200UL)   /*!< SHANS1 (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADSHCR_SHANS0_Pos           (8UL)       /*!< SHANS0 (Bit 8)                                        */
 #define R_ADC0_ADSHCR_SHANS0_Msk           (0x100UL)   /*!< SHANS0 (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADSHCR_SSTSH_Pos            (0UL)       /*!< SSTSH (Bit 0)                                         */
 #define R_ADC0_ADSHCR_SSTSH_Msk            (0xffUL)    /*!< SSTSH (Bitfield-Mask: 0xff)                           */
/* ========================================================  ADDISCR  ======================================================== */
 #define R_ADC0_ADDISCR_CHARGE_Pos          (4UL)       /*!< CHARGE (Bit 4)                                        */
 #define R_ADC0_ADDISCR_CHARGE_Msk          (0x10UL)    /*!< CHARGE (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADDISCR_ADNDIS_Pos          (0UL)       /*!< ADNDIS (Bit 0)                                        */
 #define R_ADC0_ADDISCR_ADNDIS_Msk          (0xfUL)     /*!< ADNDIS (Bitfield-Mask: 0x0f)                          */
/* ========================================================  ADSHMSR  ======================================================== */
 #define R_ADC0_ADSHMSR_SHMD_Pos            (0UL)       /*!< SHMD (Bit 0)                                          */
 #define R_ADC0_ADSHMSR_SHMD_Msk            (0x1UL)     /*!< SHMD (Bitfield-Mask: 0x01)                            */
/* ========================================================  ADACSR  ========================================================= */
 #define R_ADC0_ADACSR_ADSAC_Pos            (1UL)       /*!< ADSAC (Bit 1)                                         */
 #define R_ADC0_ADACSR_ADSAC_Msk            (0x2UL)     /*!< ADSAC (Bitfield-Mask: 0x01)                           */
/* ========================================================  ADGSPCR  ======================================================== */
 #define R_ADC0_ADGSPCR_GBRP_Pos            (15UL)      /*!< GBRP (Bit 15)                                         */
 #define R_ADC0_ADGSPCR_GBRP_Msk            (0x8000UL)  /*!< GBRP (Bitfield-Mask: 0x01)                            */
 #define R_ADC0_ADGSPCR_GBRSCN_Pos          (1UL)       /*!< GBRSCN (Bit 1)                                        */
 #define R_ADC0_ADGSPCR_GBRSCN_Msk          (0x2UL)     /*!< GBRSCN (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADGSPCR_PGS_Pos             (0UL)       /*!< PGS (Bit 0)                                           */
 #define R_ADC0_ADGSPCR_PGS_Msk             (0x1UL)     /*!< PGS (Bitfield-Mask: 0x01)                             */
 #define R_ADC0_ADGSPCR_GBEXTRG_Pos         (8UL)       /*!< GBEXTRG (Bit 8)                                       */
 #define R_ADC0_ADGSPCR_GBEXTRG_Msk         (0x100UL)   /*!< GBEXTRG (Bitfield-Mask: 0x01)                         */
/* =========================================================  ADICR  ========================================================= */
 #define R_ADC0_ADICR_ADIC_Pos              (0UL)       /*!< ADIC (Bit 0)                                          */
 #define R_ADC0_ADICR_ADIC_Msk              (0x3UL)     /*!< ADIC (Bitfield-Mask: 0x03)                            */
/* =======================================================  ADDBLDRA  ======================================================== */
 #define R_ADC0_ADDBLDRA_ADDBLDRA_Pos       (0UL)       /*!< ADDBLDRA (Bit 0)                                      */
 #define R_ADC0_ADDBLDRA_ADDBLDRA_Msk       (0xffffUL)  /*!< ADDBLDRA (Bitfield-Mask: 0xffff)                      */
/* =======================================================  ADDBLDRB  ======================================================== */
 #define R_ADC0_ADDBLDRB_ADDBLDRB_Pos       (0UL)       /*!< ADDBLDRB (Bit 0)                                      */
 #define R_ADC0_ADDBLDRB_ADDBLDRB_Msk       (0xffffUL)  /*!< ADDBLDRB (Bitfield-Mask: 0xffff)                      */
/* ======================================================  ADHVREFCNT  ======================================================= */
 #define R_ADC0_ADHVREFCNT_ADSLP_Pos        (7UL)       /*!< ADSLP (Bit 7)                                         */
 #define R_ADC0_ADHVREFCNT_ADSLP_Msk        (0x80UL)    /*!< ADSLP (Bitfield-Mask: 0x01)                           */
 #define R_ADC0_ADHVREFCNT_LVSEL_Pos        (4UL)       /*!< LVSEL (Bit 4)                                         */
 #define R_ADC0_ADHVREFCNT_LVSEL_Msk        (0x10UL)    /*!< LVSEL (Bitfield-Mask: 0x01)                           */
 #define R_ADC0_ADHVREFCNT_HVSEL_Pos        (0UL)       /*!< HVSEL (Bit 0)                                         */
 #define R_ADC0_ADHVREFCNT_HVSEL_Msk        (0x3UL)     /*!< HVSEL (Bitfield-Mask: 0x03)                           */
/* =======================================================  ADWINMON  ======================================================== */
 #define R_ADC0_ADWINMON_MONCMPB_Pos        (5UL)       /*!< MONCMPB (Bit 5)                                       */
 #define R_ADC0_ADWINMON_MONCMPB_Msk        (0x20UL)    /*!< MONCMPB (Bitfield-Mask: 0x01)                         */
 #define R_ADC0_ADWINMON_MONCMPA_Pos        (4UL)       /*!< MONCMPA (Bit 4)                                       */
 #define R_ADC0_ADWINMON_MONCMPA_Msk        (0x10UL)    /*!< MONCMPA (Bitfield-Mask: 0x01)                         */
 #define R_ADC0_ADWINMON_MONCOMB_Pos        (0UL)       /*!< MONCOMB (Bit 0)                                       */
 #define R_ADC0_ADWINMON_MONCOMB_Msk        (0x1UL)     /*!< MONCOMB (Bitfield-Mask: 0x01)                         */
/* ========================================================  ADCMPCR  ======================================================== */
 #define R_ADC0_ADCMPCR_CMPAIE_Pos          (15UL)      /*!< CMPAIE (Bit 15)                                       */
 #define R_ADC0_ADCMPCR_CMPAIE_Msk          (0x8000UL)  /*!< CMPAIE (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADCMPCR_WCMPE_Pos           (14UL)      /*!< WCMPE (Bit 14)                                        */
 #define R_ADC0_ADCMPCR_WCMPE_Msk           (0x4000UL)  /*!< WCMPE (Bitfield-Mask: 0x01)                           */
 #define R_ADC0_ADCMPCR_CMPBIE_Pos          (13UL)      /*!< CMPBIE (Bit 13)                                       */
 #define R_ADC0_ADCMPCR_CMPBIE_Msk          (0x2000UL)  /*!< CMPBIE (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADCMPCR_CMPAE_Pos           (11UL)      /*!< CMPAE (Bit 11)                                        */
 #define R_ADC0_ADCMPCR_CMPAE_Msk           (0x800UL)   /*!< CMPAE (Bitfield-Mask: 0x01)                           */
 #define R_ADC0_ADCMPCR_CMPBE_Pos           (9UL)       /*!< CMPBE (Bit 9)                                         */
 #define R_ADC0_ADCMPCR_CMPBE_Msk           (0x200UL)   /*!< CMPBE (Bitfield-Mask: 0x01)                           */
 #define R_ADC0_ADCMPCR_CMPAB_Pos           (0UL)       /*!< CMPAB (Bit 0)                                         */
 #define R_ADC0_ADCMPCR_CMPAB_Msk           (0x3UL)     /*!< CMPAB (Bitfield-Mask: 0x03)                           */
/* ======================================================  ADCMPANSER  ======================================================= */
 #define R_ADC0_ADCMPANSER_CMPOCA_Pos       (1UL)       /*!< CMPOCA (Bit 1)                                        */
 #define R_ADC0_ADCMPANSER_CMPOCA_Msk       (0x2UL)     /*!< CMPOCA (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADCMPANSER_CMPTSA_Pos       (0UL)       /*!< CMPTSA (Bit 0)                                        */
 #define R_ADC0_ADCMPANSER_CMPTSA_Msk       (0x1UL)     /*!< CMPTSA (Bitfield-Mask: 0x01)                          */
/* =======================================================  ADCMPLER  ======================================================== */
 #define R_ADC0_ADCMPLER_CMPLOCA_Pos        (1UL)       /*!< CMPLOCA (Bit 1)                                       */
 #define R_ADC0_ADCMPLER_CMPLOCA_Msk        (0x2UL)     /*!< CMPLOCA (Bitfield-Mask: 0x01)                         */
 #define R_ADC0_ADCMPLER_CMPLTSA_Pos        (0UL)       /*!< CMPLTSA (Bit 0)                                       */
 #define R_ADC0_ADCMPLER_CMPLTSA_Msk        (0x1UL)     /*!< CMPLTSA (Bitfield-Mask: 0x01)                         */
/* =======================================================  ADCMPANSR  ======================================================= */
 #define R_ADC0_ADCMPANSR_CMPCHA_Pos        (0UL)       /*!< CMPCHA (Bit 0)                                        */
 #define R_ADC0_ADCMPANSR_CMPCHA_Msk        (0x1UL)     /*!< CMPCHA (Bitfield-Mask: 0x01)                          */
/* ========================================================  ADCMPLR  ======================================================== */
 #define R_ADC0_ADCMPLR_CMPLCHA_Pos         (0UL)       /*!< CMPLCHA (Bit 0)                                       */
 #define R_ADC0_ADCMPLR_CMPLCHA_Msk         (0x1UL)     /*!< CMPLCHA (Bitfield-Mask: 0x01)                         */
/* =======================================================  ADCMPDR0  ======================================================== */
 #define R_ADC0_ADCMPDR0_ADCMPDR0_Pos       (0UL)       /*!< ADCMPDR0 (Bit 0)                                      */
 #define R_ADC0_ADCMPDR0_ADCMPDR0_Msk       (0xffffUL)  /*!< ADCMPDR0 (Bitfield-Mask: 0xffff)                      */
/* =======================================================  ADCMPDR1  ======================================================== */
 #define R_ADC0_ADCMPDR1_ADCMPDR1_Pos       (0UL)       /*!< ADCMPDR1 (Bit 0)                                      */
 #define R_ADC0_ADCMPDR1_ADCMPDR1_Msk       (0xffffUL)  /*!< ADCMPDR1 (Bitfield-Mask: 0xffff)                      */
/* ========================================================  ADCMPSR  ======================================================== */
 #define R_ADC0_ADCMPSR_CMPSTCHA_Pos        (0UL)       /*!< CMPSTCHA (Bit 0)                                      */
 #define R_ADC0_ADCMPSR_CMPSTCHA_Msk        (0x1UL)     /*!< CMPSTCHA (Bitfield-Mask: 0x01)                        */
/* =======================================================  ADCMPSER  ======================================================== */
 #define R_ADC0_ADCMPSER_CMPSTOCA_Pos       (1UL)       /*!< CMPSTOCA (Bit 1)                                      */
 #define R_ADC0_ADCMPSER_CMPSTOCA_Msk       (0x2UL)     /*!< CMPSTOCA (Bitfield-Mask: 0x01)                        */
 #define R_ADC0_ADCMPSER_CMPSTTSA_Pos       (0UL)       /*!< CMPSTTSA (Bit 0)                                      */
 #define R_ADC0_ADCMPSER_CMPSTTSA_Msk       (0x1UL)     /*!< CMPSTTSA (Bitfield-Mask: 0x01)                        */
/* =======================================================  ADCMPBNSR  ======================================================= */
 #define R_ADC0_ADCMPBNSR_CMPLB_Pos         (7UL)       /*!< CMPLB (Bit 7)                                         */
 #define R_ADC0_ADCMPBNSR_CMPLB_Msk         (0x80UL)    /*!< CMPLB (Bitfield-Mask: 0x01)                           */
 #define R_ADC0_ADCMPBNSR_CMPCHB_Pos        (0UL)       /*!< CMPCHB (Bit 0)                                        */
 #define R_ADC0_ADCMPBNSR_CMPCHB_Msk        (0x3fUL)    /*!< CMPCHB (Bitfield-Mask: 0x3f)                          */
/* =======================================================  ADWINLLB  ======================================================== */
 #define R_ADC0_ADWINLLB_ADWINLLB_Pos       (0UL)       /*!< ADWINLLB (Bit 0)                                      */
 #define R_ADC0_ADWINLLB_ADWINLLB_Msk       (0xffffUL)  /*!< ADWINLLB (Bitfield-Mask: 0xffff)                      */
/* =======================================================  ADWINULB  ======================================================== */
 #define R_ADC0_ADWINULB_ADWINULB_Pos       (0UL)       /*!< ADWINULB (Bit 0)                                      */
 #define R_ADC0_ADWINULB_ADWINULB_Msk       (0xffffUL)  /*!< ADWINULB (Bitfield-Mask: 0xffff)                      */
/* =======================================================  ADCMPBSR  ======================================================== */
 #define R_ADC0_ADCMPBSR_CMPSTB_Pos         (0UL)       /*!< CMPSTB (Bit 0)                                        */
 #define R_ADC0_ADCMPBSR_CMPSTB_Msk         (0x1UL)     /*!< CMPSTB (Bitfield-Mask: 0x01)                          */
/* ========================================================  ADSSTRL  ======================================================== */
 #define R_ADC0_ADSSTRL_SST_Pos             (0UL)       /*!< SST (Bit 0)                                           */
 #define R_ADC0_ADSSTRL_SST_Msk             (0xffUL)    /*!< SST (Bitfield-Mask: 0xff)                             */
/* ========================================================  ADSSTRT  ======================================================== */
 #define R_ADC0_ADSSTRT_SST_Pos             (0UL)       /*!< SST (Bit 0)                                           */
 #define R_ADC0_ADSSTRT_SST_Msk             (0xffUL)    /*!< SST (Bitfield-Mask: 0xff)                             */
/* ========================================================  ADSSTRO  ======================================================== */
 #define R_ADC0_ADSSTRO_SST_Pos             (0UL)       /*!< SST (Bit 0)                                           */
 #define R_ADC0_ADSSTRO_SST_Msk             (0xffUL)    /*!< SST (Bitfield-Mask: 0xff)                             */
/* ========================================================  ADSSTR  ========================================================= */
 #define R_ADC0_ADSSTR_SST_Pos              (0UL)       /*!< SST (Bit 0)                                           */
 #define R_ADC0_ADSSTR_SST_Msk              (0xffUL)    /*!< SST (Bitfield-Mask: 0xff)                             */
/* ========================================================  ADPGACR  ======================================================== */
 #define R_ADC0_ADPGACR_P002GEN_Pos         (11UL)      /*!< P002GEN (Bit 11)                                      */
 #define R_ADC0_ADPGACR_P002GEN_Msk         (0x800UL)   /*!< P002GEN (Bitfield-Mask: 0x01)                         */
 #define R_ADC0_ADPGACR_P002ENAMP_Pos       (10UL)      /*!< P002ENAMP (Bit 10)                                    */
 #define R_ADC0_ADPGACR_P002ENAMP_Msk       (0x400UL)   /*!< P002ENAMP (Bitfield-Mask: 0x01)                       */
 #define R_ADC0_ADPGACR_P002SEL1_Pos        (9UL)       /*!< P002SEL1 (Bit 9)                                      */
 #define R_ADC0_ADPGACR_P002SEL1_Msk        (0x200UL)   /*!< P002SEL1 (Bitfield-Mask: 0x01)                        */
 #define R_ADC0_ADPGACR_P002SEL0_Pos        (8UL)       /*!< P002SEL0 (Bit 8)                                      */
 #define R_ADC0_ADPGACR_P002SEL0_Msk        (0x100UL)   /*!< P002SEL0 (Bitfield-Mask: 0x01)                        */
 #define R_ADC0_ADPGACR_P001GEN_Pos         (7UL)       /*!< P001GEN (Bit 7)                                       */
 #define R_ADC0_ADPGACR_P001GEN_Msk         (0x80UL)    /*!< P001GEN (Bitfield-Mask: 0x01)                         */
 #define R_ADC0_ADPGACR_P001ENAMP_Pos       (6UL)       /*!< P001ENAMP (Bit 6)                                     */
 #define R_ADC0_ADPGACR_P001ENAMP_Msk       (0x40UL)    /*!< P001ENAMP (Bitfield-Mask: 0x01)                       */
 #define R_ADC0_ADPGACR_P001SEL1_Pos        (5UL)       /*!< P001SEL1 (Bit 5)                                      */
 #define R_ADC0_ADPGACR_P001SEL1_Msk        (0x20UL)    /*!< P001SEL1 (Bitfield-Mask: 0x01)                        */
 #define R_ADC0_ADPGACR_P001SEL0_Pos        (4UL)       /*!< P001SEL0 (Bit 4)                                      */
 #define R_ADC0_ADPGACR_P001SEL0_Msk        (0x10UL)    /*!< P001SEL0 (Bitfield-Mask: 0x01)                        */
 #define R_ADC0_ADPGACR_P000GEN_Pos         (3UL)       /*!< P000GEN (Bit 3)                                       */
 #define R_ADC0_ADPGACR_P000GEN_Msk         (0x8UL)     /*!< P000GEN (Bitfield-Mask: 0x01)                         */
 #define R_ADC0_ADPGACR_P000ENAMP_Pos       (2UL)       /*!< P000ENAMP (Bit 2)                                     */
 #define R_ADC0_ADPGACR_P000ENAMP_Msk       (0x4UL)     /*!< P000ENAMP (Bitfield-Mask: 0x01)                       */
 #define R_ADC0_ADPGACR_P000SEL1_Pos        (1UL)       /*!< P000SEL1 (Bit 1)                                      */
 #define R_ADC0_ADPGACR_P000SEL1_Msk        (0x2UL)     /*!< P000SEL1 (Bitfield-Mask: 0x01)                        */
 #define R_ADC0_ADPGACR_P000SEL0_Pos        (0UL)       /*!< P000SEL0 (Bit 0)                                      */
 #define R_ADC0_ADPGACR_P000SEL0_Msk        (0x1UL)     /*!< P000SEL0 (Bitfield-Mask: 0x01)                        */
 #define R_ADC0_ADPGACR_P003SEL0_Pos        (12UL)      /*!< P003SEL0 (Bit 12)                                     */
 #define R_ADC0_ADPGACR_P003SEL0_Msk        (0x1000UL)  /*!< P003SEL0 (Bitfield-Mask: 0x01)                        */
 #define R_ADC0_ADPGACR_P003SEL1_Pos        (13UL)      /*!< P003SEL1 (Bit 13)                                     */
 #define R_ADC0_ADPGACR_P003SEL1_Msk        (0x2000UL)  /*!< P003SEL1 (Bitfield-Mask: 0x01)                        */
 #define R_ADC0_ADPGACR_P003ENAMP_Pos       (14UL)      /*!< P003ENAMP (Bit 14)                                    */
 #define R_ADC0_ADPGACR_P003ENAMP_Msk       (0x4000UL)  /*!< P003ENAMP (Bitfield-Mask: 0x01)                       */
 #define R_ADC0_ADPGACR_P003GEN_Pos         (15UL)      /*!< P003GEN (Bit 15)                                      */
 #define R_ADC0_ADPGACR_P003GEN_Msk         (0x8000UL)  /*!< P003GEN (Bitfield-Mask: 0x01)                         */
/* =========================================================  ADRD  ========================================================== */
 #define R_ADC0_ADRD_AD_Pos                 (0UL)       /*!< AD (Bit 0)                                            */
 #define R_ADC0_ADRD_AD_Msk                 (0xffffUL)  /*!< AD (Bitfield-Mask: 0xffff)                            */
/* =========================================================  ADRST  ========================================================= */
 #define R_ADC0_ADRST_DIAGST_Pos            (0UL)       /*!< DIAGST (Bit 0)                                        */
 #define R_ADC0_ADRST_DIAGST_Msk            (0x3UL)     /*!< DIAGST (Bitfield-Mask: 0x03)                          */
/* ======================================================  VREFAMPCNT  ======================================================= */
 #define R_ADC0_VREFAMPCNT_VREFADCG_Pos     (1UL)       /*!< VREFADCG (Bit 1)                                      */
 #define R_ADC0_VREFAMPCNT_VREFADCG_Msk     (0x6UL)     /*!< VREFADCG (Bitfield-Mask: 0x03)                        */
 #define R_ADC0_VREFAMPCNT_VREFADCEN_Pos    (3UL)       /*!< VREFADCEN (Bit 3)                                     */
 #define R_ADC0_VREFAMPCNT_VREFADCEN_Msk    (0x8UL)     /*!< VREFADCEN (Bitfield-Mask: 0x01)                       */
 #define R_ADC0_VREFAMPCNT_ADSLP_Pos        (7UL)       /*!< ADSLP (Bit 7)                                         */
 #define R_ADC0_VREFAMPCNT_ADSLP_Msk        (0x80UL)    /*!< ADSLP (Bitfield-Mask: 0x01)                           */
 #define R_ADC0_VREFAMPCNT_OLDETEN_Pos      (0UL)       /*!< OLDETEN (Bit 0)                                       */
 #define R_ADC0_VREFAMPCNT_OLDETEN_Msk      (0x1UL)     /*!< OLDETEN (Bitfield-Mask: 0x01)                         */
 #define R_ADC0_VREFAMPCNT_BGREN_Pos        (4UL)       /*!< BGREN (Bit 4)                                         */
 #define R_ADC0_VREFAMPCNT_BGREN_Msk        (0x10UL)    /*!< BGREN (Bitfield-Mask: 0x01)                           */
/* =======================================================  ADCALEXE  ======================================================== */
 #define R_ADC0_ADCALEXE_CALEXE_Pos         (7UL)       /*!< CALEXE (Bit 7)                                        */
 #define R_ADC0_ADCALEXE_CALEXE_Msk         (0x80UL)    /*!< CALEXE (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADCALEXE_CALMON_Pos         (6UL)       /*!< CALMON (Bit 6)                                        */
 #define R_ADC0_ADCALEXE_CALMON_Msk         (0x40UL)    /*!< CALMON (Bitfield-Mask: 0x01)                          */
/* ========================================================  ADANIM  ========================================================= */
 #define R_ADC0_ADANIM_ANIM_Pos             (0UL)       /*!< ANIM (Bit 0)                                          */
 #define R_ADC0_ADANIM_ANIM_Msk             (0x1UL)     /*!< ANIM (Bitfield-Mask: 0x01)                            */
/* =======================================================  ADPGAGS0  ======================================================== */
 #define R_ADC0_ADPGAGS0_P002GAIN_Pos       (8UL)       /*!< P002GAIN (Bit 8)                                      */
 #define R_ADC0_ADPGAGS0_P002GAIN_Msk       (0xf00UL)   /*!< P002GAIN (Bitfield-Mask: 0x0f)                        */
 #define R_ADC0_ADPGAGS0_P001GAIN_Pos       (4UL)       /*!< P001GAIN (Bit 4)                                      */
 #define R_ADC0_ADPGAGS0_P001GAIN_Msk       (0xf0UL)    /*!< P001GAIN (Bitfield-Mask: 0x0f)                        */
 #define R_ADC0_ADPGAGS0_P000GAIN_Pos       (0UL)       /*!< P000GAIN (Bit 0)                                      */
 #define R_ADC0_ADPGAGS0_P000GAIN_Msk       (0xfUL)     /*!< P000GAIN (Bitfield-Mask: 0x0f)                        */
 #define R_ADC0_ADPGAGS0_P003GAIN_Pos       (12UL)      /*!< P003GAIN (Bit 12)                                     */
 #define R_ADC0_ADPGAGS0_P003GAIN_Msk       (0xf000UL)  /*!< P003GAIN (Bitfield-Mask: 0x0f)                        */
/* =======================================================  ADPGADCR0  ======================================================= */
 #define R_ADC0_ADPGADCR0_P003DG_Pos        (12UL)      /*!< P003DG (Bit 12)                                       */
 #define R_ADC0_ADPGADCR0_P003DG_Msk        (0x3000UL)  /*!< P003DG (Bitfield-Mask: 0x03)                          */
 #define R_ADC0_ADPGADCR0_P002DEN_Pos       (11UL)      /*!< P002DEN (Bit 11)                                      */
 #define R_ADC0_ADPGADCR0_P002DEN_Msk       (0x800UL)   /*!< P002DEN (Bitfield-Mask: 0x01)                         */
 #define R_ADC0_ADPGADCR0_P002DG_Pos        (8UL)       /*!< P002DG (Bit 8)                                        */
 #define R_ADC0_ADPGADCR0_P002DG_Msk        (0x300UL)   /*!< P002DG (Bitfield-Mask: 0x03)                          */
 #define R_ADC0_ADPGADCR0_P001DEN_Pos       (7UL)       /*!< P001DEN (Bit 7)                                       */
 #define R_ADC0_ADPGADCR0_P001DEN_Msk       (0x80UL)    /*!< P001DEN (Bitfield-Mask: 0x01)                         */
 #define R_ADC0_ADPGADCR0_P001DG_Pos        (4UL)       /*!< P001DG (Bit 4)                                        */
 #define R_ADC0_ADPGADCR0_P001DG_Msk        (0x30UL)    /*!< P001DG (Bitfield-Mask: 0x03)                          */
 #define R_ADC0_ADPGADCR0_P000DEN_Pos       (3UL)       /*!< P000DEN (Bit 3)                                       */
 #define R_ADC0_ADPGADCR0_P000DEN_Msk       (0x8UL)     /*!< P000DEN (Bitfield-Mask: 0x01)                         */
 #define R_ADC0_ADPGADCR0_P000DG_Pos        (0UL)       /*!< P000DG (Bit 0)                                        */
 #define R_ADC0_ADPGADCR0_P000DG_Msk        (0x3UL)     /*!< P000DG (Bitfield-Mask: 0x03)                          */
 #define R_ADC0_ADPGADCR0_P003DEN_Pos       (15UL)      /*!< P003DEN (Bit 15)                                      */
 #define R_ADC0_ADPGADCR0_P003DEN_Msk       (0x8000UL)  /*!< P003DEN (Bitfield-Mask: 0x01)                         */
/* =========================================================  ADREF  ========================================================= */
 #define R_ADC0_ADREF_ADF_Pos               (0UL)       /*!< ADF (Bit 0)                                           */
 #define R_ADC0_ADREF_ADF_Msk               (0x1UL)     /*!< ADF (Bitfield-Mask: 0x01)                             */
 #define R_ADC0_ADREF_ADSCACT_Pos           (7UL)       /*!< ADSCACT (Bit 7)                                       */
 #define R_ADC0_ADREF_ADSCACT_Msk           (0x80UL)    /*!< ADSCACT (Bitfield-Mask: 0x01)                         */
/* ========================================================  ADEXREF  ======================================================== */
 #define R_ADC0_ADEXREF_GBADF_Pos           (0UL)       /*!< GBADF (Bit 0)                                         */
 #define R_ADC0_ADEXREF_GBADF_Msk           (0x1UL)     /*!< GBADF (Bitfield-Mask: 0x01)                           */
/* =======================================================  ADAMPOFF  ======================================================== */
 #define R_ADC0_ADAMPOFF_OPOFF_Pos          (0UL)       /*!< OPOFF (Bit 0)                                         */
 #define R_ADC0_ADAMPOFF_OPOFF_Msk          (0xffUL)    /*!< OPOFF (Bitfield-Mask: 0xff)                           */
/* ========================================================  ADTSTPR  ======================================================== */
 #define R_ADC0_ADTSTPR_PRO_Pos             (0UL)       /*!< PRO (Bit 0)                                           */
 #define R_ADC0_ADTSTPR_PRO_Msk             (0x1UL)     /*!< PRO (Bitfield-Mask: 0x01)                             */
 #define R_ADC0_ADTSTPR_B0WI_Pos            (1UL)       /*!< B0WI (Bit 1)                                          */
 #define R_ADC0_ADTSTPR_B0WI_Msk            (0x2UL)     /*!< B0WI (Bitfield-Mask: 0x01)                            */
/* =======================================================  ADDDACER  ======================================================== */
 #define R_ADC0_ADDDACER_WRION_Pos          (0UL)       /*!< WRION (Bit 0)                                         */
 #define R_ADC0_ADDDACER_WRION_Msk          (0x1fUL)    /*!< WRION (Bitfield-Mask: 0x1f)                           */
 #define R_ADC0_ADDDACER_WRIOFF_Pos         (8UL)       /*!< WRIOFF (Bit 8)                                        */
 #define R_ADC0_ADDDACER_WRIOFF_Msk         (0x1f00UL)  /*!< WRIOFF (Bitfield-Mask: 0x1f)                          */
 #define R_ADC0_ADDDACER_ADHS_Pos           (15UL)      /*!< ADHS (Bit 15)                                         */
 #define R_ADC0_ADDDACER_ADHS_Msk           (0x8000UL)  /*!< ADHS (Bitfield-Mask: 0x01)                            */
/* =======================================================  ADEXTSTR  ======================================================== */
 #define R_ADC0_ADEXTSTR_SHTEST_Pos         (0UL)       /*!< SHTEST (Bit 0)                                        */
 #define R_ADC0_ADEXTSTR_SHTEST_Msk         (0x7UL)     /*!< SHTEST (Bitfield-Mask: 0x07)                          */
 #define R_ADC0_ADEXTSTR_SWTST_Pos          (4UL)       /*!< SWTST (Bit 4)                                         */
 #define R_ADC0_ADEXTSTR_SWTST_Msk          (0x30UL)    /*!< SWTST (Bitfield-Mask: 0x03)                           */
 #define R_ADC0_ADEXTSTR_SHTRM_Pos          (8UL)       /*!< SHTRM (Bit 8)                                         */
 #define R_ADC0_ADEXTSTR_SHTRM_Msk          (0x300UL)   /*!< SHTRM (Bitfield-Mask: 0x03)                           */
 #define R_ADC0_ADEXTSTR_ADTRM3_Pos         (11UL)      /*!< ADTRM3 (Bit 11)                                       */
 #define R_ADC0_ADEXTSTR_ADTRM3_Msk         (0x800UL)   /*!< ADTRM3 (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADEXTSTR_ADTRM2_Pos         (12UL)      /*!< ADTRM2 (Bit 12)                                       */
 #define R_ADC0_ADEXTSTR_ADTRM2_Msk         (0x3000UL)  /*!< ADTRM2 (Bitfield-Mask: 0x03)                          */
 #define R_ADC0_ADEXTSTR_ADTRM1_Pos         (14UL)      /*!< ADTRM1 (Bit 14)                                       */
 #define R_ADC0_ADEXTSTR_ADTRM1_Msk         (0xc000UL)  /*!< ADTRM1 (Bitfield-Mask: 0x03)                          */
/* ========================================================  ADTSTRA  ======================================================== */
 #define R_ADC0_ADTSTRA_ATBUSSEL_Pos        (0UL)       /*!< ATBUSSEL (Bit 0)                                      */
 #define R_ADC0_ADTSTRA_ATBUSSEL_Msk        (0x1UL)     /*!< ATBUSSEL (Bitfield-Mask: 0x01)                        */
 #define R_ADC0_ADTSTRA_TSTSWREF_Pos        (1UL)       /*!< TSTSWREF (Bit 1)                                      */
 #define R_ADC0_ADTSTRA_TSTSWREF_Msk        (0xeUL)     /*!< TSTSWREF (Bitfield-Mask: 0x07)                        */
 #define R_ADC0_ADTSTRA_OCSW_Pos            (5UL)       /*!< OCSW (Bit 5)                                          */
 #define R_ADC0_ADTSTRA_OCSW_Msk            (0x20UL)    /*!< OCSW (Bitfield-Mask: 0x01)                            */
 #define R_ADC0_ADTSTRA_TSSW_Pos            (6UL)       /*!< TSSW (Bit 6)                                          */
 #define R_ADC0_ADTSTRA_TSSW_Msk            (0x40UL)    /*!< TSSW (Bitfield-Mask: 0x01)                            */
 #define R_ADC0_ADTSTRA_ADTEST_AD_Pos       (8UL)       /*!< ADTEST_AD (Bit 8)                                     */
 #define R_ADC0_ADTSTRA_ADTEST_AD_Msk       (0xf00UL)   /*!< ADTEST_AD (Bitfield-Mask: 0x0f)                       */
 #define R_ADC0_ADTSTRA_ADTEST_IO_Pos       (12UL)      /*!< ADTEST_IO (Bit 12)                                    */
 #define R_ADC0_ADTSTRA_ADTEST_IO_Msk       (0xf000UL)  /*!< ADTEST_IO (Bitfield-Mask: 0x0f)                       */
/* ========================================================  ADTSTRB  ======================================================== */
 #define R_ADC0_ADTSTRB_ADVAL_Pos           (0UL)       /*!< ADVAL (Bit 0)                                         */
 #define R_ADC0_ADTSTRB_ADVAL_Msk           (0x7fffUL)  /*!< ADVAL (Bitfield-Mask: 0x7fff)                         */
/* ========================================================  ADTSTRC  ======================================================== */
 #define R_ADC0_ADTSTRC_ADMD_Pos            (0UL)       /*!< ADMD (Bit 0)                                          */
 #define R_ADC0_ADTSTRC_ADMD_Msk            (0xffUL)    /*!< ADMD (Bitfield-Mask: 0xff)                            */
 #define R_ADC0_ADTSTRC_SYNCERR_Pos         (12UL)      /*!< SYNCERR (Bit 12)                                      */
 #define R_ADC0_ADTSTRC_SYNCERR_Msk         (0x1000UL)  /*!< SYNCERR (Bitfield-Mask: 0x01)                         */
/* ========================================================  ADTSTRD  ======================================================== */
 #define R_ADC0_ADTSTRD_ADVAL16_Pos         (0UL)       /*!< ADVAL16 (Bit 0)                                       */
 #define R_ADC0_ADTSTRD_ADVAL16_Msk         (0x1UL)     /*!< ADVAL16 (Bitfield-Mask: 0x01)                         */
/* =======================================================  ADSWTSTR0  ======================================================= */
 #define R_ADC0_ADSWTSTR0_CHSW00_Pos        (0UL)       /*!< CHSW00 (Bit 0)                                        */
 #define R_ADC0_ADSWTSTR0_CHSW00_Msk        (0x1UL)     /*!< CHSW00 (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADSWTSTR0_CHSW01_Pos        (1UL)       /*!< CHSW01 (Bit 1)                                        */
 #define R_ADC0_ADSWTSTR0_CHSW01_Msk        (0x2UL)     /*!< CHSW01 (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADSWTSTR0_CHSW02_Pos        (2UL)       /*!< CHSW02 (Bit 2)                                        */
 #define R_ADC0_ADSWTSTR0_CHSW02_Msk        (0x4UL)     /*!< CHSW02 (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADSWTSTR0_CHSW03_Pos        (3UL)       /*!< CHSW03 (Bit 3)                                        */
 #define R_ADC0_ADSWTSTR0_CHSW03_Msk        (0x8UL)     /*!< CHSW03 (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADSWTSTR0_CHSW04_Pos        (4UL)       /*!< CHSW04 (Bit 4)                                        */
 #define R_ADC0_ADSWTSTR0_CHSW04_Msk        (0x10UL)    /*!< CHSW04 (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADSWTSTR0_CHSW05_Pos        (5UL)       /*!< CHSW05 (Bit 5)                                        */
 #define R_ADC0_ADSWTSTR0_CHSW05_Msk        (0x20UL)    /*!< CHSW05 (Bitfield-Mask: 0x01)                          */
/* =======================================================  ADSWTSTR1  ======================================================= */
 #define R_ADC0_ADSWTSTR1_CHSW16_Pos        (0UL)       /*!< CHSW16 (Bit 0)                                        */
 #define R_ADC0_ADSWTSTR1_CHSW16_Msk        (0x1UL)     /*!< CHSW16 (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADSWTSTR1_CHSW17_Pos        (1UL)       /*!< CHSW17 (Bit 1)                                        */
 #define R_ADC0_ADSWTSTR1_CHSW17_Msk        (0x2UL)     /*!< CHSW17 (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADSWTSTR1_CHSW18_Pos        (2UL)       /*!< CHSW18 (Bit 2)                                        */
 #define R_ADC0_ADSWTSTR1_CHSW18_Msk        (0x4UL)     /*!< CHSW18 (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADSWTSTR1_CHSW19_Pos        (3UL)       /*!< CHSW19 (Bit 3)                                        */
 #define R_ADC0_ADSWTSTR1_CHSW19_Msk        (0x8UL)     /*!< CHSW19 (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADSWTSTR1_CHSW20_Pos        (4UL)       /*!< CHSW20 (Bit 4)                                        */
 #define R_ADC0_ADSWTSTR1_CHSW20_Msk        (0x10UL)    /*!< CHSW20 (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADSWTSTR1_CHSW21_Pos        (5UL)       /*!< CHSW21 (Bit 5)                                        */
 #define R_ADC0_ADSWTSTR1_CHSW21_Msk        (0x20UL)    /*!< CHSW21 (Bitfield-Mask: 0x01)                          */
/* =======================================================  ADSWTSTR2  ======================================================= */
 #define R_ADC0_ADSWTSTR2_EX0SW_Pos         (0UL)       /*!< EX0SW (Bit 0)                                         */
 #define R_ADC0_ADSWTSTR2_EX0SW_Msk         (0x1UL)     /*!< EX0SW (Bitfield-Mask: 0x01)                           */
 #define R_ADC0_ADSWTSTR2_EX1SW_Pos         (1UL)       /*!< EX1SW (Bit 1)                                         */
 #define R_ADC0_ADSWTSTR2_EX1SW_Msk         (0x2UL)     /*!< EX1SW (Bitfield-Mask: 0x01)                           */
 #define R_ADC0_ADSWTSTR2_SHBYPS0_Pos       (4UL)       /*!< SHBYPS0 (Bit 4)                                       */
 #define R_ADC0_ADSWTSTR2_SHBYPS0_Msk       (0x10UL)    /*!< SHBYPS0 (Bitfield-Mask: 0x01)                         */
 #define R_ADC0_ADSWTSTR2_SHBYPS1_Pos       (5UL)       /*!< SHBYPS1 (Bit 5)                                       */
 #define R_ADC0_ADSWTSTR2_SHBYPS1_Msk       (0x20UL)    /*!< SHBYPS1 (Bitfield-Mask: 0x01)                         */
 #define R_ADC0_ADSWTSTR2_SHBYPS2_Pos       (6UL)       /*!< SHBYPS2 (Bit 6)                                       */
 #define R_ADC0_ADSWTSTR2_SHBYPS2_Msk       (0x40UL)    /*!< SHBYPS2 (Bitfield-Mask: 0x01)                         */
 #define R_ADC0_ADSWTSTR2_GRP0SW_Pos        (8UL)       /*!< GRP0SW (Bit 8)                                        */
 #define R_ADC0_ADSWTSTR2_GRP0SW_Msk        (0x100UL)   /*!< GRP0SW (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADSWTSTR2_GRP1SW_Pos        (9UL)       /*!< GRP1SW (Bit 9)                                        */
 #define R_ADC0_ADSWTSTR2_GRP1SW_Msk        (0x200UL)   /*!< GRP1SW (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADSWTSTR2_GRP2SW_Pos        (10UL)      /*!< GRP2SW (Bit 10)                                       */
 #define R_ADC0_ADSWTSTR2_GRP2SW_Msk        (0x400UL)   /*!< GRP2SW (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADSWTSTR2_GRP3SW_Pos        (11UL)      /*!< GRP3SW (Bit 11)                                       */
 #define R_ADC0_ADSWTSTR2_GRP3SW_Msk        (0x800UL)   /*!< GRP3SW (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADSWTSTR2_GRPEX1SW_Pos      (12UL)      /*!< GRPEX1SW (Bit 12)                                     */
 #define R_ADC0_ADSWTSTR2_GRPEX1SW_Msk      (0x1000UL)  /*!< GRPEX1SW (Bitfield-Mask: 0x01)                        */
/* ========================================================  ADSWCR  ========================================================= */
 #define R_ADC0_ADSWCR_ADSWREF_Pos          (0UL)       /*!< ADSWREF (Bit 0)                                       */
 #define R_ADC0_ADSWCR_ADSWREF_Msk          (0x7UL)     /*!< ADSWREF (Bitfield-Mask: 0x07)                         */
 #define R_ADC0_ADSWCR_SHSWREF_Pos          (4UL)       /*!< SHSWREF (Bit 4)                                       */
 #define R_ADC0_ADSWCR_SHSWREF_Msk          (0x70UL)    /*!< SHSWREF (Bitfield-Mask: 0x07)                         */
/* ========================================================  ADGSCS  ========================================================= */
 #define R_ADC0_ADGSCS_CHSELGB_Pos          (0UL)       /*!< CHSELGB (Bit 0)                                       */
 #define R_ADC0_ADGSCS_CHSELGB_Msk          (0xffUL)    /*!< CHSELGB (Bitfield-Mask: 0xff)                         */
 #define R_ADC0_ADGSCS_CHSELGA_Pos          (8UL)       /*!< CHSELGA (Bit 8)                                       */
 #define R_ADC0_ADGSCS_CHSELGA_Msk          (0xff00UL)  /*!< CHSELGA (Bitfield-Mask: 0xff)                         */
/* =========================================================  ADSER  ========================================================= */
 #define R_ADC0_ADSER_SMPEX_Pos             (7UL)       /*!< SMPEX (Bit 7)                                         */
 #define R_ADC0_ADSER_SMPEX_Msk             (0x80UL)    /*!< SMPEX (Bitfield-Mask: 0x01)                           */
/* ========================================================  ADBUF0  ========================================================= */
 #define R_ADC0_ADBUF0_ADBUF_Pos            (0UL)       /*!< ADBUF (Bit 0)                                         */
 #define R_ADC0_ADBUF0_ADBUF_Msk            (0xffffUL)  /*!< ADBUF (Bitfield-Mask: 0xffff)                         */
/* ========================================================  ADBUF1  ========================================================= */
 #define R_ADC0_ADBUF1_ADBUF_Pos            (0UL)       /*!< ADBUF (Bit 0)                                         */
 #define R_ADC0_ADBUF1_ADBUF_Msk            (0xffffUL)  /*!< ADBUF (Bitfield-Mask: 0xffff)                         */
/* ========================================================  ADBUF2  ========================================================= */
 #define R_ADC0_ADBUF2_ADBUF_Pos            (0UL)       /*!< ADBUF (Bit 0)                                         */
 #define R_ADC0_ADBUF2_ADBUF_Msk            (0xffffUL)  /*!< ADBUF (Bitfield-Mask: 0xffff)                         */
/* ========================================================  ADBUF3  ========================================================= */
 #define R_ADC0_ADBUF3_ADBUF_Pos            (0UL)       /*!< ADBUF (Bit 0)                                         */
 #define R_ADC0_ADBUF3_ADBUF_Msk            (0xffffUL)  /*!< ADBUF (Bitfield-Mask: 0xffff)                         */
/* ========================================================  ADBUF4  ========================================================= */
 #define R_ADC0_ADBUF4_ADBUF_Pos            (0UL)       /*!< ADBUF (Bit 0)                                         */
 #define R_ADC0_ADBUF4_ADBUF_Msk            (0xffffUL)  /*!< ADBUF (Bitfield-Mask: 0xffff)                         */
/* ========================================================  ADBUF5  ========================================================= */
 #define R_ADC0_ADBUF5_ADBUF_Pos            (0UL)       /*!< ADBUF (Bit 0)                                         */
 #define R_ADC0_ADBUF5_ADBUF_Msk            (0xffffUL)  /*!< ADBUF (Bitfield-Mask: 0xffff)                         */
/* ========================================================  ADBUF6  ========================================================= */
 #define R_ADC0_ADBUF6_ADBUF_Pos            (0UL)       /*!< ADBUF (Bit 0)                                         */
 #define R_ADC0_ADBUF6_ADBUF_Msk            (0xffffUL)  /*!< ADBUF (Bitfield-Mask: 0xffff)                         */
/* ========================================================  ADBUF7  ========================================================= */
 #define R_ADC0_ADBUF7_ADBUF_Pos            (0UL)       /*!< ADBUF (Bit 0)                                         */
 #define R_ADC0_ADBUF7_ADBUF_Msk            (0xffffUL)  /*!< ADBUF (Bitfield-Mask: 0xffff)                         */
/* ========================================================  ADBUF8  ========================================================= */
 #define R_ADC0_ADBUF8_ADBUF_Pos            (0UL)       /*!< ADBUF (Bit 0)                                         */
 #define R_ADC0_ADBUF8_ADBUF_Msk            (0xffffUL)  /*!< ADBUF (Bitfield-Mask: 0xffff)                         */
/* ========================================================  ADBUF9  ========================================================= */
 #define R_ADC0_ADBUF9_ADBUF_Pos            (0UL)       /*!< ADBUF (Bit 0)                                         */
 #define R_ADC0_ADBUF9_ADBUF_Msk            (0xffffUL)  /*!< ADBUF (Bitfield-Mask: 0xffff)                         */
/* ========================================================  ADBUF10  ======================================================== */
 #define R_ADC0_ADBUF10_ADBUF_Pos           (0UL)       /*!< ADBUF (Bit 0)                                         */
 #define R_ADC0_ADBUF10_ADBUF_Msk           (0xffffUL)  /*!< ADBUF (Bitfield-Mask: 0xffff)                         */
/* ========================================================  ADBUF11  ======================================================== */
 #define R_ADC0_ADBUF11_ADBUF_Pos           (0UL)       /*!< ADBUF (Bit 0)                                         */
 #define R_ADC0_ADBUF11_ADBUF_Msk           (0xffffUL)  /*!< ADBUF (Bitfield-Mask: 0xffff)                         */
/* ========================================================  ADBUF12  ======================================================== */
 #define R_ADC0_ADBUF12_ADBUF_Pos           (0UL)       /*!< ADBUF (Bit 0)                                         */
 #define R_ADC0_ADBUF12_ADBUF_Msk           (0xffffUL)  /*!< ADBUF (Bitfield-Mask: 0xffff)                         */
/* ========================================================  ADBUF13  ======================================================== */
 #define R_ADC0_ADBUF13_ADBUF_Pos           (0UL)       /*!< ADBUF (Bit 0)                                         */
 #define R_ADC0_ADBUF13_ADBUF_Msk           (0xffffUL)  /*!< ADBUF (Bitfield-Mask: 0xffff)                         */
/* ========================================================  ADBUF14  ======================================================== */
 #define R_ADC0_ADBUF14_ADBUF_Pos           (0UL)       /*!< ADBUF (Bit 0)                                         */
 #define R_ADC0_ADBUF14_ADBUF_Msk           (0xffffUL)  /*!< ADBUF (Bitfield-Mask: 0xffff)                         */
/* ========================================================  ADBUF15  ======================================================== */
 #define R_ADC0_ADBUF15_ADBUF_Pos           (0UL)       /*!< ADBUF (Bit 0)                                         */
 #define R_ADC0_ADBUF15_ADBUF_Msk           (0xffffUL)  /*!< ADBUF (Bitfield-Mask: 0xffff)                         */
/* ========================================================  ADBUFEN  ======================================================== */
 #define R_ADC0_ADBUFEN_BUFEN_Pos           (0UL)       /*!< BUFEN (Bit 0)                                         */
 #define R_ADC0_ADBUFEN_BUFEN_Msk           (0x1UL)     /*!< BUFEN (Bitfield-Mask: 0x01)                           */
/* =======================================================  ADBUFPTR  ======================================================== */
 #define R_ADC0_ADBUFPTR_BUFPTR_Pos         (0UL)       /*!< BUFPTR (Bit 0)                                        */
 #define R_ADC0_ADBUFPTR_BUFPTR_Msk         (0xfUL)     /*!< BUFPTR (Bitfield-Mask: 0x0f)                          */
 #define R_ADC0_ADBUFPTR_PTROVF_Pos         (4UL)       /*!< PTROVF (Bit 4)                                        */
 #define R_ADC0_ADBUFPTR_PTROVF_Msk         (0x10UL)    /*!< PTROVF (Bitfield-Mask: 0x01)                          */
/* =======================================================  ADPGADBS0  ======================================================= */
 #define R_ADC0_ADPGADBS0_P0BIAS_Pos        (0UL)       /*!< P0BIAS (Bit 0)                                        */
 #define R_ADC0_ADPGADBS0_P0BIAS_Msk        (0x1UL)     /*!< P0BIAS (Bitfield-Mask: 0x01)                          */
/* =======================================================  ADPGADBS1  ======================================================= */
 #define R_ADC0_ADPGADBS1_P3BIAS_Pos        (0UL)       /*!< P3BIAS (Bit 0)                                        */
 #define R_ADC0_ADPGADBS1_P3BIAS_Msk        (0x1UL)     /*!< P3BIAS (Bitfield-Mask: 0x01)                          */
/* =======================================================  ADREFMON  ======================================================== */
 #define R_ADC0_ADREFMON_PGAMON_Pos         (0UL)       /*!< PGAMON (Bit 0)                                        */
 #define R_ADC0_ADREFMON_PGAMON_Msk         (0x7UL)     /*!< PGAMON (Bitfield-Mask: 0x07)                          */
 #define R_ADC0_ADREFMON_MONSEL_Pos         (16UL)      /*!< MONSEL (Bit 16)                                       */
 #define R_ADC0_ADREFMON_MONSEL_Msk         (0xf0000UL) /*!< MONSEL (Bitfield-Mask: 0x0f)                          */

/* =========================================================================================================================== */
/* ================                                          R_PSCU                                           ================ */
/* =========================================================================================================================== */

/* =========================================================  PSARB  ========================================================= */
 #define R_PSCU_PSARB_PSARB1_Pos     (1UL)          /*!< PSARB1 (Bit 1)                                        */
 #define R_PSCU_PSARB_PSARB1_Msk     (0x2UL)        /*!< PSARB1 (Bitfield-Mask: 0x01)                          */
 #define R_PSCU_PSARB_PSARB2_Pos     (2UL)          /*!< PSARB2 (Bit 2)                                        */
 #define R_PSCU_PSARB_PSARB2_Msk     (0x4UL)        /*!< PSARB2 (Bitfield-Mask: 0x01)                          */
 #define R_PSCU_PSARB_PSARB3_Pos     (3UL)          /*!< PSARB3 (Bit 3)                                        */
 #define R_PSCU_PSARB_PSARB3_Msk     (0x8UL)        /*!< PSARB3 (Bitfield-Mask: 0x01)                          */
 #define R_PSCU_PSARB_PSARB6_Pos     (6UL)          /*!< PSARB6 (Bit 6)                                        */
 #define R_PSCU_PSARB_PSARB6_Msk     (0x40UL)       /*!< PSARB6 (Bitfield-Mask: 0x01)                          */
 #define R_PSCU_PSARB_PSARB7_Pos     (7UL)          /*!< PSARB7 (Bit 7)                                        */
 #define R_PSCU_PSARB_PSARB7_Msk     (0x80UL)       /*!< PSARB7 (Bitfield-Mask: 0x01)                          */
 #define R_PSCU_PSARB_PSARB8_Pos     (8UL)          /*!< PSARB8 (Bit 8)                                        */
 #define R_PSCU_PSARB_PSARB8_Msk     (0x100UL)      /*!< PSARB8 (Bitfield-Mask: 0x01)                          */
 #define R_PSCU_PSARB_PSARB9_Pos     (9UL)          /*!< PSARB9 (Bit 9)                                        */
 #define R_PSCU_PSARB_PSARB9_Msk     (0x200UL)      /*!< PSARB9 (Bitfield-Mask: 0x01)                          */
 #define R_PSCU_PSARB_PSARB11_Pos    (11UL)         /*!< PSARB11 (Bit 11)                                      */
 #define R_PSCU_PSARB_PSARB11_Msk    (0x800UL)      /*!< PSARB11 (Bitfield-Mask: 0x01)                         */
 #define R_PSCU_PSARB_PSARB12_Pos    (12UL)         /*!< PSARB12 (Bit 12)                                      */
 #define R_PSCU_PSARB_PSARB12_Msk    (0x1000UL)     /*!< PSARB12 (Bitfield-Mask: 0x01)                         */
 #define R_PSCU_PSARB_PSARB15_Pos    (15UL)         /*!< PSARB15 (Bit 15)                                      */
 #define R_PSCU_PSARB_PSARB15_Msk    (0x8000UL)     /*!< PSARB15 (Bitfield-Mask: 0x01)                         */
 #define R_PSCU_PSARB_PSARB16_Pos    (16UL)         /*!< PSARB16 (Bit 16)                                      */
 #define R_PSCU_PSARB_PSARB16_Msk    (0x10000UL)    /*!< PSARB16 (Bitfield-Mask: 0x01)                         */
 #define R_PSCU_PSARB_PSARB18_Pos    (18UL)         /*!< PSARB18 (Bit 18)                                      */
 #define R_PSCU_PSARB_PSARB18_Msk    (0x40000UL)    /*!< PSARB18 (Bitfield-Mask: 0x01)                         */
 #define R_PSCU_PSARB_PSARB19_Pos    (19UL)         /*!< PSARB19 (Bit 19)                                      */
 #define R_PSCU_PSARB_PSARB19_Msk    (0x80000UL)    /*!< PSARB19 (Bitfield-Mask: 0x01)                         */
 #define R_PSCU_PSARB_PSARB22_Pos    (22UL)         /*!< PSARB22 (Bit 22)                                      */
 #define R_PSCU_PSARB_PSARB22_Msk    (0x400000UL)   /*!< PSARB22 (Bitfield-Mask: 0x01)                         */
 #define R_PSCU_PSARB_PSARB23_Pos    (23UL)         /*!< PSARB23 (Bit 23)                                      */
 #define R_PSCU_PSARB_PSARB23_Msk    (0x800000UL)   /*!< PSARB23 (Bitfield-Mask: 0x01)                         */
 #define R_PSCU_PSARB_PSARB24_Pos    (24UL)         /*!< PSARB24 (Bit 24)                                      */
 #define R_PSCU_PSARB_PSARB24_Msk    (0x1000000UL)  /*!< PSARB24 (Bitfield-Mask: 0x01)                         */
 #define R_PSCU_PSARB_PSARB25_Pos    (25UL)         /*!< PSARB25 (Bit 25)                                      */
 #define R_PSCU_PSARB_PSARB25_Msk    (0x2000000UL)  /*!< PSARB25 (Bitfield-Mask: 0x01)                         */
 #define R_PSCU_PSARB_PSARB26_Pos    (26UL)         /*!< PSARB26 (Bit 26)                                      */
 #define R_PSCU_PSARB_PSARB26_Msk    (0x4000000UL)  /*!< PSARB26 (Bitfield-Mask: 0x01)                         */
 #define R_PSCU_PSARB_PSARB27_Pos    (27UL)         /*!< PSARB27 (Bit 27)                                      */
 #define R_PSCU_PSARB_PSARB27_Msk    (0x8000000UL)  /*!< PSARB27 (Bitfield-Mask: 0x01)                         */
 #define R_PSCU_PSARB_PSARB28_Pos    (28UL)         /*!< PSARB28 (Bit 28)                                      */
 #define R_PSCU_PSARB_PSARB28_Msk    (0x10000000UL) /*!< PSARB28 (Bitfield-Mask: 0x01)                         */
 #define R_PSCU_PSARB_PSARB29_Pos    (29UL)         /*!< PSARB29 (Bit 29)                                      */
 #define R_PSCU_PSARB_PSARB29_Msk    (0x20000000UL) /*!< PSARB29 (Bitfield-Mask: 0x01)                         */
 #define R_PSCU_PSARB_PSARB30_Pos    (30UL)         /*!< PSARB30 (Bit 30)                                      */
 #define R_PSCU_PSARB_PSARB30_Msk    (0x40000000UL) /*!< PSARB30 (Bitfield-Mask: 0x01)                         */
 #define R_PSCU_PSARB_PSARB31_Pos    (31UL)         /*!< PSARB31 (Bit 31)                                      */
 #define R_PSCU_PSARB_PSARB31_Msk    (0x80000000UL) /*!< PSARB31 (Bitfield-Mask: 0x01)                         */
/* =========================================================  PSARC  ========================================================= */
 #define R_PSCU_PSARC_PSARC0_Pos     (0UL)          /*!< PSARC0 (Bit 0)                                        */
 #define R_PSCU_PSARC_PSARC0_Msk     (0x1UL)        /*!< PSARC0 (Bitfield-Mask: 0x01)                          */
 #define R_PSCU_PSARC_PSARC1_Pos     (1UL)          /*!< PSARC1 (Bit 1)                                        */
 #define R_PSCU_PSARC_PSARC1_Msk     (0x2UL)        /*!< PSARC1 (Bitfield-Mask: 0x01)                          */
 #define R_PSCU_PSARC_PSARC3_Pos     (3UL)          /*!< PSARC3 (Bit 3)                                        */
 #define R_PSCU_PSARC_PSARC3_Msk     (0x8UL)        /*!< PSARC3 (Bitfield-Mask: 0x01)                          */
 #define R_PSCU_PSARC_PSARC8_Pos     (8UL)          /*!< PSARC8 (Bit 8)                                        */
 #define R_PSCU_PSARC_PSARC8_Msk     (0x100UL)      /*!< PSARC8 (Bitfield-Mask: 0x01)                          */
 #define R_PSCU_PSARC_PSARC12_Pos    (12UL)         /*!< PSARC12 (Bit 12)                                      */
 #define R_PSCU_PSARC_PSARC12_Msk    (0x1000UL)     /*!< PSARC12 (Bitfield-Mask: 0x01)                         */
 #define R_PSCU_PSARC_PSARC13_Pos    (13UL)         /*!< PSARC13 (Bit 13)                                      */
 #define R_PSCU_PSARC_PSARC13_Msk    (0x2000UL)     /*!< PSARC13 (Bitfield-Mask: 0x01)                         */
 #define R_PSCU_PSARC_PSARC20_Pos    (20UL)         /*!< PSARC20 (Bit 20)                                      */
 #define R_PSCU_PSARC_PSARC20_Msk    (0x100000UL)   /*!< PSARC20 (Bitfield-Mask: 0x01)                         */
 #define R_PSCU_PSARC_PSARC27_Pos    (27UL)         /*!< PSARC27 (Bit 27)                                      */
 #define R_PSCU_PSARC_PSARC27_Msk    (0x8000000UL)  /*!< PSARC27 (Bitfield-Mask: 0x01)                         */
 #define R_PSCU_PSARC_PSARC31_Pos    (31UL)         /*!< PSARC31 (Bit 31)                                      */
 #define R_PSCU_PSARC_PSARC31_Msk    (0x80000000UL) /*!< PSARC31 (Bitfield-Mask: 0x01)                         */
/* =========================================================  PSARD  ========================================================= */
 #define R_PSCU_PSARD_PSARD0_Pos     (0UL)          /*!< PSARD0 (Bit 0)                                        */
 #define R_PSCU_PSARD_PSARD0_Msk     (0x1UL)        /*!< PSARD0 (Bitfield-Mask: 0x01)                          */
 #define R_PSCU_PSARD_PSARD1_Pos     (1UL)          /*!< PSARD1 (Bit 1)                                        */
 #define R_PSCU_PSARD_PSARD1_Msk     (0x2UL)        /*!< PSARD1 (Bitfield-Mask: 0x01)                          */
 #define R_PSCU_PSARD_PSARD2_Pos     (2UL)          /*!< PSARD2 (Bit 2)                                        */
 #define R_PSCU_PSARD_PSARD2_Msk     (0x4UL)        /*!< PSARD2 (Bitfield-Mask: 0x01)                          */
 #define R_PSCU_PSARD_PSARD3_Pos     (3UL)          /*!< PSARD3 (Bit 3)                                        */
 #define R_PSCU_PSARD_PSARD3_Msk     (0x8UL)        /*!< PSARD3 (Bitfield-Mask: 0x01)                          */
 #define R_PSCU_PSARD_PSARD11_Pos    (11UL)         /*!< PSARD11 (Bit 11)                                      */
 #define R_PSCU_PSARD_PSARD11_Msk    (0x800UL)      /*!< PSARD11 (Bitfield-Mask: 0x01)                         */
 #define R_PSCU_PSARD_PSARD12_Pos    (12UL)         /*!< PSARD12 (Bit 12)                                      */
 #define R_PSCU_PSARD_PSARD12_Msk    (0x1000UL)     /*!< PSARD12 (Bitfield-Mask: 0x01)                         */
 #define R_PSCU_PSARD_PSARD13_Pos    (13UL)         /*!< PSARD13 (Bit 13)                                      */
 #define R_PSCU_PSARD_PSARD13_Msk    (0x2000UL)     /*!< PSARD13 (Bitfield-Mask: 0x01)                         */
 #define R_PSCU_PSARD_PSARD14_Pos    (14UL)         /*!< PSARD14 (Bit 14)                                      */
 #define R_PSCU_PSARD_PSARD14_Msk    (0x4000UL)     /*!< PSARD14 (Bitfield-Mask: 0x01)                         */
 #define R_PSCU_PSARD_PSARD15_Pos    (15UL)         /*!< PSARD15 (Bit 15)                                      */
 #define R_PSCU_PSARD_PSARD15_Msk    (0x8000UL)     /*!< PSARD15 (Bitfield-Mask: 0x01)                         */
 #define R_PSCU_PSARD_PSARD16_Pos    (16UL)         /*!< PSARD16 (Bit 16)                                      */
 #define R_PSCU_PSARD_PSARD16_Msk    (0x10000UL)    /*!< PSARD16 (Bitfield-Mask: 0x01)                         */
 #define R_PSCU_PSARD_PSARD19_Pos    (19UL)         /*!< PSARD19 (Bit 19)                                      */
 #define R_PSCU_PSARD_PSARD19_Msk    (0x80000UL)    /*!< PSARD19 (Bitfield-Mask: 0x01)                         */
 #define R_PSCU_PSARD_PSARD20_Pos    (20UL)         /*!< PSARD20 (Bit 20)                                      */
 #define R_PSCU_PSARD_PSARD20_Msk    (0x100000UL)   /*!< PSARD20 (Bitfield-Mask: 0x01)                         */
 #define R_PSCU_PSARD_PSARD22_Pos    (22UL)         /*!< PSARD22 (Bit 22)                                      */
 #define R_PSCU_PSARD_PSARD22_Msk    (0x400000UL)   /*!< PSARD22 (Bitfield-Mask: 0x01)                         */
 #define R_PSCU_PSARD_PSARD25_Pos    (25UL)         /*!< PSARD25 (Bit 25)                                      */
 #define R_PSCU_PSARD_PSARD25_Msk    (0x2000000UL)  /*!< PSARD25 (Bitfield-Mask: 0x01)                         */
 #define R_PSCU_PSARD_PSARD26_Pos    (26UL)         /*!< PSARD26 (Bit 26)                                      */
 #define R_PSCU_PSARD_PSARD26_Msk    (0x4000000UL)  /*!< PSARD26 (Bitfield-Mask: 0x01)                         */
 #define R_PSCU_PSARD_PSARD27_Pos    (27UL)         /*!< PSARD27 (Bit 27)                                      */
 #define R_PSCU_PSARD_PSARD27_Msk    (0x8000000UL)  /*!< PSARD27 (Bitfield-Mask: 0x01)                         */
 #define R_PSCU_PSARD_PSARD28_Pos    (28UL)         /*!< PSARD28 (Bit 28)                                      */
 #define R_PSCU_PSARD_PSARD28_Msk    (0x10000000UL) /*!< PSARD28 (Bitfield-Mask: 0x01)                         */
/* =========================================================  PSARE  ========================================================= */
 #define R_PSCU_PSARE_PSARE0_Pos     (0UL)          /*!< PSARE0 (Bit 0)                                        */
 #define R_PSCU_PSARE_PSARE0_Msk     (0x1UL)        /*!< PSARE0 (Bitfield-Mask: 0x01)                          */
 #define R_PSCU_PSARE_PSARE1_Pos     (1UL)          /*!< PSARE1 (Bit 1)                                        */
 #define R_PSCU_PSARE_PSARE1_Msk     (0x2UL)        /*!< PSARE1 (Bitfield-Mask: 0x01)                          */
 #define R_PSCU_PSARE_PSARE2_Pos     (2UL)          /*!< PSARE2 (Bit 2)                                        */
 #define R_PSCU_PSARE_PSARE2_Msk     (0x4UL)        /*!< PSARE2 (Bitfield-Mask: 0x01)                          */
 #define R_PSCU_PSARE_PSARE14_Pos    (14UL)         /*!< PSARE14 (Bit 14)                                      */
 #define R_PSCU_PSARE_PSARE14_Msk    (0x4000UL)     /*!< PSARE14 (Bitfield-Mask: 0x01)                         */
 #define R_PSCU_PSARE_PSARE15_Pos    (15UL)         /*!< PSARE15 (Bit 15)                                      */
 #define R_PSCU_PSARE_PSARE15_Msk    (0x8000UL)     /*!< PSARE15 (Bitfield-Mask: 0x01)                         */
 #define R_PSCU_PSARE_PSARE22_Pos    (22UL)         /*!< PSARE22 (Bit 22)                                      */
 #define R_PSCU_PSARE_PSARE22_Msk    (0x400000UL)   /*!< PSARE22 (Bitfield-Mask: 0x01)                         */
 #define R_PSCU_PSARE_PSARE23_Pos    (23UL)         /*!< PSARE23 (Bit 23)                                      */
 #define R_PSCU_PSARE_PSARE23_Msk    (0x800000UL)   /*!< PSARE23 (Bitfield-Mask: 0x01)                         */
 #define R_PSCU_PSARE_PSARE24_Pos    (24UL)         /*!< PSARE24 (Bit 24)                                      */
 #define R_PSCU_PSARE_PSARE24_Msk    (0x1000000UL)  /*!< PSARE24 (Bitfield-Mask: 0x01)                         */
 #define R_PSCU_PSARE_PSARE25_Pos    (25UL)         /*!< PSARE25 (Bit 25)                                      */
 #define R_PSCU_PSARE_PSARE25_Msk    (0x2000000UL)  /*!< PSARE25 (Bitfield-Mask: 0x01)                         */
 #define R_PSCU_PSARE_PSARE26_Pos    (26UL)         /*!< PSARE26 (Bit 26)                                      */
 #define R_PSCU_PSARE_PSARE26_Msk    (0x4000000UL)  /*!< PSARE26 (Bitfield-Mask: 0x01)                         */
 #define R_PSCU_PSARE_PSARE27_Pos    (27UL)         /*!< PSARE27 (Bit 27)                                      */
 #define R_PSCU_PSARE_PSARE27_Msk    (0x8000000UL)  /*!< PSARE27 (Bitfield-Mask: 0x01)                         */
 #define R_PSCU_PSARE_PSARE28_Pos    (28UL)         /*!< PSARE28 (Bit 28)                                      */
 #define R_PSCU_PSARE_PSARE28_Msk    (0x10000000UL) /*!< PSARE28 (Bitfield-Mask: 0x01)                         */
 #define R_PSCU_PSARE_PSARE29_Pos    (29UL)         /*!< PSARE29 (Bit 29)                                      */
 #define R_PSCU_PSARE_PSARE29_Msk    (0x20000000UL) /*!< PSARE29 (Bitfield-Mask: 0x01)                         */
 #define R_PSCU_PSARE_PSARE30_Pos    (30UL)         /*!< PSARE30 (Bit 30)                                      */
 #define R_PSCU_PSARE_PSARE30_Msk    (0x40000000UL) /*!< PSARE30 (Bitfield-Mask: 0x01)                         */
 #define R_PSCU_PSARE_PSARE31_Pos    (31UL)         /*!< PSARE31 (Bit 31)                                      */
 #define R_PSCU_PSARE_PSARE31_Msk    (0x80000000UL) /*!< PSARE31 (Bitfield-Mask: 0x01)                         */
/* =========================================================  MSSAR  ========================================================= */
 #define R_PSCU_MSSAR_MSSAR0_Pos     (0UL)          /*!< MSSAR0 (Bit 0)                                        */
 #define R_PSCU_MSSAR_MSSAR0_Msk     (0x1UL)        /*!< MSSAR0 (Bitfield-Mask: 0x01)                          */
 #define R_PSCU_MSSAR_MSSAR1_Pos     (1UL)          /*!< MSSAR1 (Bit 1)                                        */
 #define R_PSCU_MSSAR_MSSAR1_Msk     (0x2UL)        /*!< MSSAR1 (Bitfield-Mask: 0x01)                          */
 #define R_PSCU_MSSAR_MSSAR2_Pos     (2UL)          /*!< MSSAR2 (Bit 2)                                        */
 #define R_PSCU_MSSAR_MSSAR2_Msk     (0x4UL)        /*!< MSSAR2 (Bitfield-Mask: 0x01)                          */
 #define R_PSCU_MSSAR_MSSAR3_Pos     (3UL)          /*!< MSSAR3 (Bit 3)                                        */
 #define R_PSCU_MSSAR_MSSAR3_Msk     (0x8UL)        /*!< MSSAR3 (Bitfield-Mask: 0x01)                          */
/* =======================================================  CFSAMONA  ======================================================== */
 #define R_PSCU_CFSAMONA_CFS2_Pos    (15UL)         /*!< CFS2 (Bit 15)                                         */
 #define R_PSCU_CFSAMONA_CFS2_Msk    (0xff8000UL)   /*!< CFS2 (Bitfield-Mask: 0x1ff)                           */
/* =======================================================  CFSAMONB  ======================================================== */
 #define R_PSCU_CFSAMONB_CFS1_Pos    (10UL)         /*!< CFS1 (Bit 10)                                         */
 #define R_PSCU_CFSAMONB_CFS1_Msk    (0xfffc00UL)   /*!< CFS1 (Bitfield-Mask: 0x3fff)                          */
/* ========================================================  DFSAMON  ======================================================== */
 #define R_PSCU_DFSAMON_DFS_Pos      (10UL)         /*!< DFS (Bit 10)                                          */
 #define R_PSCU_DFSAMON_DFS_Msk      (0xfc00UL)     /*!< DFS (Bitfield-Mask: 0x3f)                             */
/* ========================================================  SSAMONA  ======================================================== */
 #define R_PSCU_SSAMONA_SS2_Pos      (13UL)         /*!< SS2 (Bit 13)                                          */
 #define R_PSCU_SSAMONA_SS2_Msk      (0x1fe000UL)   /*!< SS2 (Bitfield-Mask: 0xff)                             */
/* ========================================================  SSAMONB  ======================================================== */
 #define R_PSCU_SSAMONB_SS1_Pos      (10UL)         /*!< SS1 (Bit 10)                                          */
 #define R_PSCU_SSAMONB_SS1_Msk      (0x1ffc00UL)   /*!< SS1 (Bitfield-Mask: 0x7ff)                            */
/* ========================================================  DLMMON  ========================================================= */
 #define R_PSCU_DLMMON_DLMMON_Pos    (0UL)          /*!< DLMMON (Bit 0)                                        */
 #define R_PSCU_DLMMON_DLMMON_Msk    (0xfUL)        /*!< DLMMON (Bitfield-Mask: 0x0f)                          */

/* =========================================================================================================================== */
/* ================                                           R_BUS                                           ================ */
/* =================================================================================================