/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.internal;

import com.google.inject.Module;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.api.Dependency;
import org.apache.maven.api.Node;
import org.apache.maven.api.PathScope;
import org.apache.maven.api.PathType;
import org.apache.maven.api.Project;
import org.apache.maven.api.Session;
import org.apache.maven.api.plugin.Log;
import org.apache.maven.api.plugin.descriptor.Resolution;
import org.apache.maven.api.services.DependencyResolver;
import org.apache.maven.api.services.DependencyResolverResult;
import org.apache.maven.api.services.PathScopeRegistry;
import org.apache.maven.api.xml.XmlNode;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.classrealm.ClassRealmManager;
import org.apache.maven.di.Injector;
import org.apache.maven.di.Key;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.scope.internal.MojoExecutionScope;
import org.apache.maven.execution.scope.internal.MojoExecutionScopeModule;
import org.apache.maven.internal.impl.DefaultLog;
import org.apache.maven.internal.impl.DefaultMojoExecution;
import org.apache.maven.internal.impl.InternalMavenSession;
import org.apache.maven.internal.impl.SisuDiBridgeModule;
import org.apache.maven.internal.xml.XmlPlexusConfiguration;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.ContextEnabled;
import org.apache.maven.plugin.DebugConfigurationListener;
import org.apache.maven.plugin.ExtensionRealmCache;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.MavenPluginManager;
import org.apache.maven.plugin.MavenPluginPrerequisitesChecker;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoNotFoundException;
import org.apache.maven.plugin.PluginArtifactsCache;
import org.apache.maven.plugin.PluginConfigurationException;
import org.apache.maven.plugin.PluginContainerException;
import org.apache.maven.plugin.PluginDescriptorCache;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginIncompatibleException;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.PluginParameterException;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.plugin.PluginParameterExpressionEvaluatorV4;
import org.apache.maven.plugin.PluginRealmCache;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.PluginValidationManager;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptorBuilder;
import org.apache.maven.plugin.internal.MavenPluginConfigurationValidator;
import org.apache.maven.plugin.internal.MavenPluginValidator;
import org.apache.maven.plugin.internal.MojoLogWrapper;
import org.apache.maven.plugin.internal.PluginConfigurationModule;
import org.apache.maven.plugin.internal.PluginDependenciesResolver;
import org.apache.maven.plugin.internal.ValidatingConfigurationListener;
import org.apache.maven.plugin.version.DefaultPluginVersionRequest;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.plugin.version.PluginVersionResolver;
import org.apache.maven.project.ExtensionDescriptor;
import org.apache.maven.project.ExtensionDescriptorBuilder;
import org.apache.maven.project.MavenProject;
import org.apache.maven.session.scope.internal.SessionScope;
import org.apache.maven.session.scope.internal.SessionScopeModule;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.composition.CycleDetectedInComponentGraphException;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ComponentConfigurator;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.configuration.DefaultPlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.util.filter.AndDependencyFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class DefaultMavenPluginManager
implements MavenPluginManager {
    public static final String KEY_EXTENSIONS_REALMS = DefaultMavenPluginManager.class.getName() + "/extensionsRealms";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final PlexusContainer container;
    private final ClassRealmManager classRealmManager;
    private final PluginDescriptorCache pluginDescriptorCache;
    private final PluginRealmCache pluginRealmCache;
    private final PluginDependenciesResolver pluginDependenciesResolver;
    private final ExtensionRealmCache extensionRealmCache;
    private final PluginVersionResolver pluginVersionResolver;
    private final PluginArtifactsCache pluginArtifactsCache;
    private final MavenPluginValidator pluginValidator;
    private final List<MavenPluginConfigurationValidator> configurationValidators;
    private final PluginValidationManager pluginValidationManager;
    private final List<MavenPluginPrerequisitesChecker> prerequisitesCheckers;
    private final ExtensionDescriptorBuilder extensionDescriptorBuilder = new ExtensionDescriptorBuilder();
    private final PluginDescriptorBuilder builder = new PluginDescriptorBuilder();

    @Inject
    public DefaultMavenPluginManager(PlexusContainer container, ClassRealmManager classRealmManager, PluginDescriptorCache pluginDescriptorCache, PluginRealmCache pluginRealmCache, PluginDependenciesResolver pluginDependenciesResolver, ExtensionRealmCache extensionRealmCache, PluginVersionResolver pluginVersionResolver, PluginArtifactsCache pluginArtifactsCache, MavenPluginValidator pluginValidator, List<MavenPluginConfigurationValidator> configurationValidators, PluginValidationManager pluginValidationManager, List<MavenPluginPrerequisitesChecker> prerequisitesCheckers) {
        this.container = container;
        this.classRealmManager = classRealmManager;
        this.pluginDescriptorCache = pluginDescriptorCache;
        this.pluginRealmCache = pluginRealmCache;
        this.pluginDependenciesResolver = pluginDependenciesResolver;
        this.extensionRealmCache = extensionRealmCache;
        this.pluginVersionResolver = pluginVersionResolver;
        this.pluginArtifactsCache = pluginArtifactsCache;
        this.pluginValidator = pluginValidator;
        this.configurationValidators = configurationValidators;
        this.pluginValidationManager = pluginValidationManager;
        this.prerequisitesCheckers = prerequisitesCheckers;
    }

    @Override
    public PluginDescriptor getPluginDescriptor(Plugin plugin, List<RemoteRepository> repositories, RepositorySystemSession session) throws PluginResolutionException, PluginDescriptorParsingException, InvalidPluginDescriptorException {
        PluginDescriptorCache.Key cacheKey = this.pluginDescriptorCache.createKey(plugin, repositories, session);
        PluginDescriptor pluginDescriptor = this.pluginDescriptorCache.get(cacheKey, () -> {
            boolean isBlankVersion;
            org.eclipse.aether.artifact.Artifact artifact = this.pluginDependenciesResolver.resolve(plugin, repositories, session);
            Artifact pluginArtifact = RepositoryUtils.toArtifact(artifact);
            PluginDescriptor descriptor = this.extractPluginDescriptor(pluginArtifact, plugin);
            boolean bl = isBlankVersion = descriptor.getRequiredMavenVersion() == null || descriptor.getRequiredMavenVersion().trim().isEmpty();
            if (isBlankVersion) {
                descriptor.setRequiredMavenVersion(artifact.getProperty("requiredMavenVersion", null));
            }
            return descriptor;
        });
        pluginDescriptor.setPlugin(plugin);
        return pluginDescriptor;
    }

    /*
     * Unable to fully structure code
     */
    private PluginDescriptor extractPluginDescriptor(Artifact pluginArtifact, Plugin plugin) throws PluginDescriptorParsingException, InvalidPluginDescriptorException {
        pluginDescriptor = null;
        pluginFile = pluginArtifact.getFile();
        try {
            if (pluginFile.isFile()) {
                pluginJar = new JarFile(pluginFile, false);
                try {
                    pluginDescriptorEntry = pluginJar.getEntry(this.getPluginDescriptorLocation());
                    if (pluginDescriptorEntry == null) ** GOTO lbl17
                    pluginDescriptor = this.parsePluginDescriptor((PluginDescriptorBuilder.StreamSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/io/InputStream;, lambda$extractPluginDescriptor$0(java.util.jar.JarFile java.util.zip.ZipEntry ), ()Ljava/io/InputStream;)((JarFile)pluginJar, (ZipEntry)pluginDescriptorEntry), plugin, pluginFile.getAbsolutePath());
                }
                finally {
                    pluginJar.close();
                }
            } else {
                pluginXml = new File(pluginFile, this.getPluginDescriptorLocation());
                if (pluginXml.isFile()) {
                    pluginDescriptor = this.parsePluginDescriptor((PluginDescriptorBuilder.StreamSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/io/InputStream;, lambda$extractPluginDescriptor$1(java.io.File ), ()Ljava/io/InputStream;)((File)pluginXml), plugin, pluginXml.getAbsolutePath());
                }
            }
lbl17:
            // 5 sources

            if (pluginDescriptor == null) {
                throw new IOException("No plugin descriptor found at " + this.getPluginDescriptorLocation());
            }
        }
        catch (IOException e) {
            throw new PluginDescriptorParsingException(plugin, pluginFile.getAbsolutePath(), e);
        }
        errors = new ArrayList<String>();
        this.pluginValidator.validate(pluginArtifact, pluginDescriptor, errors);
        if (!errors.isEmpty()) {
            throw new InvalidPluginDescriptorException("Invalid plugin descriptor for " + plugin.getId() + " (" + String.valueOf(pluginFile) + ")", errors);
        }
        pluginDescriptor.setPluginArtifact(pluginArtifact);
        return pluginDescriptor;
    }

    private String getPluginDescriptorLocation() {
        return "META-INF/maven/plugin.xml";
    }

    private PluginDescriptor parsePluginDescriptor(PluginDescriptorBuilder.StreamSupplier is, Plugin plugin, String descriptorLocation) throws PluginDescriptorParsingException {
        try {
            return this.builder.build(is, descriptorLocation);
        }
        catch (PlexusConfigurationException e) {
            throw new PluginDescriptorParsingException(plugin, descriptorLocation, e);
        }
    }

    @Override
    public MojoDescriptor getMojoDescriptor(Plugin plugin, String goal, List<RemoteRepository> repositories, RepositorySystemSession session) throws MojoNotFoundException, PluginResolutionException, PluginDescriptorParsingException, InvalidPluginDescriptorException {
        PluginDescriptor pluginDescriptor = this.getPluginDescriptor(plugin, repositories, session);
        MojoDescriptor mojoDescriptor = pluginDescriptor.getMojo(goal);
        if (mojoDescriptor == null) {
            throw new MojoNotFoundException(goal, pluginDescriptor);
        }
        return mojoDescriptor;
    }

    @Override
    public void checkPrerequisites(PluginDescriptor pluginDescriptor) throws PluginIncompatibleException {
        ArrayList prerequisiteExceptions = new ArrayList();
        this.prerequisitesCheckers.forEach(c -> {
            try {
                c.accept(pluginDescriptor);
            }
            catch (IllegalStateException e) {
                prerequisiteExceptions.add(e);
            }
        });
        if (!prerequisiteExceptions.isEmpty()) {
            String messages = prerequisiteExceptions.stream().map(Throwable::getMessage).collect(Collectors.joining(", "));
            PluginIncompatibleException pie = new PluginIncompatibleException(pluginDescriptor.getPlugin(), "The plugin " + pluginDescriptor.getId() + " has unmet prerequisites: " + messages, (Throwable)prerequisiteExceptions.get(0));
            prerequisiteExceptions.stream().skip(1L).forEach(pie::addSuppressed);
            throw pie;
        }
    }

    @Override
    @Deprecated
    public void checkRequiredMavenVersion(PluginDescriptor pluginDescriptor) throws PluginIncompatibleException {
        this.checkPrerequisites(pluginDescriptor);
    }

    @Override
    public void setupPluginRealm(PluginDescriptor pluginDescriptor, MavenSession session, ClassLoader parent, List<String> imports, DependencyFilter filter) throws PluginResolutionException, PluginContainerException {
        Plugin plugin = pluginDescriptor.getPlugin();
        MavenProject project = session.getCurrentProject();
        if (plugin.isExtensions()) {
            ExtensionRealmCache.CacheRecord extensionRecord;
            try {
                RepositorySystemSession repositorySession = session.getRepositorySession();
                extensionRecord = this.setupExtensionsRealm(project, plugin, repositorySession);
            }
            catch (PluginManagerException e) {
                throw new IllegalStateException(e);
            }
            ClassRealm pluginRealm = extensionRecord.getRealm();
            List<Artifact> pluginArtifacts = extensionRecord.getArtifacts();
            for (ComponentDescriptor componentDescriptor : pluginDescriptor.getComponents()) {
                componentDescriptor.setRealm(pluginRealm);
            }
            pluginDescriptor.setClassRealm(pluginRealm);
            pluginDescriptor.setArtifacts(pluginArtifacts);
        } else {
            boolean v4api = pluginDescriptor.getMojos().stream().anyMatch(MojoDescriptor::isV4Api);
            Map<String, ClassLoader> foreignImports = this.calcImports(project, parent, imports, v4api);
            PluginRealmCache.Key cacheKey = this.pluginRealmCache.createKey(plugin, parent, foreignImports, filter, project.getRemotePluginRepositories(), session.getRepositorySession());
            PluginRealmCache.CacheRecord cacheRecord = this.pluginRealmCache.get(cacheKey, () -> {
                this.createPluginRealm(pluginDescriptor, session, parent, foreignImports, filter);
                return new PluginRealmCache.CacheRecord(pluginDescriptor.getClassRealm(), pluginDescriptor.getArtifacts());
            });
            pluginDescriptor.setClassRealm(cacheRecord.getRealm());
            pluginDescriptor.setArtifacts(new ArrayList<Artifact>(cacheRecord.getArtifacts()));
            for (ComponentDescriptor componentDescriptor : pluginDescriptor.getComponents()) {
                componentDescriptor.setRealm(cacheRecord.getRealm());
            }
            this.pluginRealmCache.register(project, cacheKey, cacheRecord);
        }
    }

    private void createPluginRealm(PluginDescriptor pluginDescriptor, MavenSession session, ClassLoader parent, Map<String, ClassLoader> foreignImports, DependencyFilter filter) throws PluginResolutionException, PluginContainerException {
        Plugin plugin = Objects.requireNonNull(pluginDescriptor.getPlugin(), "pluginDescriptor.plugin cannot be null");
        Artifact pluginArtifact = Objects.requireNonNull(pluginDescriptor.getPluginArtifact(), "pluginDescriptor.pluginArtifact cannot be null");
        MavenProject project = session.getCurrentProject();
        RepositorySystemSession repositorySession = session.getRepositorySession();
        DependencyFilter dependencyFilter = project.getExtensionDependencyFilter();
        dependencyFilter = AndDependencyFilter.newInstance((DependencyFilter)dependencyFilter, (DependencyFilter)filter);
        DependencyResult result = this.pluginDependenciesResolver.resolvePlugin(plugin, RepositoryUtils.toArtifact(pluginArtifact), dependencyFilter, project.getRemotePluginRepositories(), repositorySession);
        List<Artifact> pluginArtifacts = this.toMavenArtifacts(result);
        ClassRealm pluginRealm = this.classRealmManager.createPluginRealm(plugin, parent, null, foreignImports, this.toAetherArtifacts(pluginArtifacts));
        this.discoverPluginComponents(pluginRealm, plugin, pluginDescriptor);
        pluginDescriptor.setDependencyNode(result.getRoot());
        pluginDescriptor.setClassRealm(pluginRealm);
        pluginDescriptor.setArtifacts(pluginArtifacts);
    }

    private void discoverPluginComponents(ClassRealm pluginRealm, Plugin plugin, PluginDescriptor pluginDescriptor) throws PluginContainerException {
        ClassLoader prevTccl = Thread.currentThread().getContextClassLoader();
        try {
            if (pluginDescriptor != null) {
                for (MojoDescriptor mojo : pluginDescriptor.getMojos()) {
                    if (mojo.isV4Api()) continue;
                    mojo.setRealm(pluginRealm);
                    this.container.addComponentDescriptor((ComponentDescriptor)mojo);
                }
            }
            Thread.currentThread().setContextClassLoader((ClassLoader)pluginRealm);
            ((DefaultPlexusContainer)this.container).discoverComponents(pluginRealm, new Module[]{new SessionScopeModule((SessionScope)((Object)this.container.lookup(SessionScope.class))), new MojoExecutionScopeModule((MojoExecutionScope)this.container.lookup(MojoExecutionScope.class)), new PluginConfigurationModule(plugin.getDelegate()), new SisuDiBridgeModule(true)});
        }
        catch (CycleDetectedInComponentGraphException | ComponentLookupException e) {
            throw new PluginContainerException(plugin, pluginRealm, "Error in component graph of plugin " + plugin.getId() + ": " + e.getMessage(), e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevTccl);
        }
    }

    private List<org.eclipse.aether.artifact.Artifact> toAetherArtifacts(List<Artifact> pluginArtifacts) {
        return new ArrayList<org.eclipse.aether.artifact.Artifact>(RepositoryUtils.toArtifacts(pluginArtifacts));
    }

    private List<Artifact> toMavenArtifacts(DependencyResult dependencyResult) {
        return dependencyResult.getDependencyNodeResults().stream().filter(n -> n.getArtifact().getPath() != null).map(n -> RepositoryUtils.toArtifact(n.getDependency())).toList();
    }

    private Map<String, ClassLoader> calcImports(MavenProject project, ClassLoader parent, List<String> imports, boolean v4api) {
        HashMap<String, ClassLoader> foreignImports = new HashMap<String, ClassLoader>();
        ClassRealm projectRealm = project.getClassRealm();
        if (projectRealm != null) {
            foreignImports.put("", (ClassLoader)projectRealm);
        } else {
            foreignImports.put("", (ClassLoader)(v4api ? this.classRealmManager.getMaven4ApiRealm() : this.classRealmManager.getMavenApiRealm()));
        }
        if (parent != null && imports != null) {
            for (String parentImport : imports) {
                foreignImports.put(parentImport, parent);
            }
        }
        return foreignImports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getConfiguredMojo(Class<T> mojoInterface, MavenSession session, MojoExecution mojoExecution) throws PluginConfigurationException, PluginContainerException {
        MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
        PluginDescriptor pluginDescriptor = mojoDescriptor.getPluginDescriptor();
        ClassRealm pluginRealm = pluginDescriptor.getClassRealm();
        if (pluginRealm == null) {
            try {
                this.setupPluginRealm(pluginDescriptor, session, null, null, null);
            }
            catch (PluginResolutionException e) {
                String msg = "Cannot setup plugin realm [mojoDescriptor=" + mojoDescriptor.getId() + ", pluginDescriptor=" + pluginDescriptor.getId() + "]";
                throw new PluginConfigurationException(pluginDescriptor, msg, e);
            }
            pluginRealm = pluginDescriptor.getClassRealm();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Loading mojo " + mojoDescriptor.getId() + " from plugin realm " + String.valueOf(pluginRealm));
        }
        ClassRealm oldLookupRealm = this.container.setLookupRealm(pluginRealm);
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader((ClassLoader)pluginRealm);
        try {
            if (mojoDescriptor.isV4Api()) {
                T t = this.loadV4Mojo(mojoInterface, session, mojoExecution, mojoDescriptor, pluginDescriptor, pluginRealm);
                return t;
            }
            T t = this.loadV3Mojo(mojoInterface, session, mojoExecution, mojoDescriptor, pluginDescriptor, pluginRealm);
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
            this.container.setLookupRealm(oldLookupRealm);
        }
    }

    private <T> T loadV4Mojo(Class<T> mojoInterface, MavenSession session, MojoExecution mojoExecution, MojoDescriptor mojoDescriptor, PluginDescriptor pluginDescriptor, ClassRealm pluginRealm) throws PluginContainerException, PluginConfigurationException {
        T mojo;
        InternalMavenSession sessionV4 = InternalMavenSession.from(session.getSession());
        Project project = sessionV4.getProject(session.getCurrentProject());
        DefaultMojoExecution execution = new DefaultMojoExecution(sessionV4, mojoExecution);
        DefaultLog log = new DefaultLog(LoggerFactory.getLogger((String)mojoExecution.getMojoDescriptor().getFullGoalName()));
        try {
            Injector injector = Injector.create();
            injector.discover((ClassLoader)pluginRealm);
            injector.bindInstance(Session.class, (Object)sessionV4);
            injector.bindInstance(Project.class, (Object)project);
            injector.bindInstance(org.apache.maven.api.MojoExecution.class, (Object)execution);
            injector.bindInstance(Log.class, (Object)log);
            mojo = mojoInterface.cast(injector.getInstance(Key.of((Class)mojoDescriptor.getImplementationClass(), (Object)mojoDescriptor.getRoleHint())));
        }
        catch (Exception e) {
            throw new PluginContainerException(mojoDescriptor, pluginRealm, "Unable to lookup Mojo", (Throwable)e);
        }
        XmlNode dom = mojoExecution.getConfiguration() != null ? mojoExecution.getConfiguration().getDom() : null;
        Object pomConfiguration = dom == null ? new DefaultPlexusConfiguration("configuration") : XmlPlexusConfiguration.toPlexusConfiguration((XmlNode)dom);
        PluginParameterExpressionEvaluatorV4 expressionEvaluator = new PluginParameterExpressionEvaluatorV4((Session)sessionV4, project, execution);
        for (MavenPluginConfigurationValidator validator : this.configurationValidators) {
            validator.validate(session, mojoDescriptor, mojo.getClass(), (PlexusConfiguration)pomConfiguration, (ExpressionEvaluator)expressionEvaluator);
        }
        this.populateMojoExecutionFields(mojo, mojoExecution.getExecutionId(), mojoDescriptor, pluginRealm, (PlexusConfiguration)pomConfiguration, (ExpressionEvaluator)expressionEvaluator);
        for (Resolution resolution : mojoDescriptor.getMojoDescriptorV4().getResolutions()) {
            Field field = null;
            for (Class<?> clazz = mojo.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
                try {
                    field = clazz.getDeclaredField(resolution.getField());
                    break;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    continue;
                }
            }
            if (field == null) {
                throw new PluginConfigurationException(pluginDescriptor, "Unable to find field '" + resolution.getField() + "' annotated with @Resolution");
            }
            field.setAccessible(true);
            String pathScope = resolution.getPathScope();
            Object result = null;
            if (pathScope != null && !pathScope.isEmpty()) {
                Type t;
                Type type;
                PathScope ps = (PathScope)((PathScopeRegistry)sessionV4.getService(PathScopeRegistry.class)).require(pathScope);
                DependencyResolverResult res = ((DependencyResolver)sessionV4.getService(DependencyResolver.class)).resolve((Session)sessionV4, project, ps);
                if (field.getType() == DependencyResolverResult.class) {
                    result = res;
                } else if (field.getType() == Node.class) {
                    result = res.getRoot();
                } else if (field.getType() == List.class && (type = field.getGenericType()) instanceof ParameterizedType) {
                    ParameterizedType pt = (ParameterizedType)type;
                    t = pt.getActualTypeArguments()[0];
                    if (t == Node.class) {
                        result = res.getNodes();
                    } else if (t == Path.class) {
                        result = res.getPaths();
                    }
                } else if (field.getType() == Map.class && (t = field.getGenericType()) instanceof ParameterizedType) {
                    ParameterizedType ptv;
                    ParameterizedType pt = (ParameterizedType)t;
                    Type k = pt.getActualTypeArguments()[0];
                    Type v = pt.getActualTypeArguments()[1];
                    if (k == PathType.class && v instanceof ParameterizedType && (ptv = (ParameterizedType)v).getRawType() == List.class && ptv.getActualTypeArguments()[0] == Path.class) {
                        result = res.getDispatchedPaths();
                    } else if (k == Dependency.class && v == Path.class) {
                        result = res.getDependencies();
                    }
                }
            } else {
                DependencyResolverResult res = ((DependencyResolver)sessionV4.getService(DependencyResolver.class)).collect((Session)sessionV4, project, PathScope.MAIN_RUNTIME);
                if (field.getType() == DependencyResolverResult.class) {
                    result = res;
                } else if (field.getType() == Node.class) {
                    result = res.getRoot();
                }
            }
            if (result == null) {
                throw new PluginConfigurationException(pluginDescriptor, "Unable to inject field '" + resolution.getField() + "' annotated with @Dependencies. Unsupported type " + String.valueOf(field.getGenericType()));
            }
            try {
                field.set(mojo, result);
            }
            catch (IllegalAccessException e) {
                throw new PluginConfigurationException(pluginDescriptor, "Unable to inject field '" + resolution.getField() + "' annotated with @Dependencies", e);
            }
        }
        return mojo;
    }

    private <T> T loadV3Mojo(Class<T> mojoInterface, MavenSession session, MojoExecution mojoExecution, MojoDescriptor mojoDescriptor, PluginDescriptor pluginDescriptor, ClassRealm pluginRealm) throws PluginContainerException, PluginConfigurationException {
        Object mojo;
        try {
            mojo = this.container.lookup(mojoInterface, mojoDescriptor.getRoleHint());
        }
        catch (ComponentLookupException e) {
            Throwable cause;
            for (cause = e.getCause(); cause != null && !(cause instanceof LinkageError) && !(cause instanceof ClassNotFoundException); cause = cause.getCause()) {
            }
            if (cause instanceof NoClassDefFoundError || cause instanceof ClassNotFoundException) {
                ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
                PrintStream ps = new PrintStream(os);
                ps.println("Unable to load the mojo '" + mojoDescriptor.getGoal() + "' in the plugin '" + pluginDescriptor.getId() + "'. A required class is missing: " + cause.getMessage());
                pluginRealm.display(ps);
                throw new PluginContainerException(mojoDescriptor, pluginRealm, os.toString(), cause);
            }
            if (cause instanceof LinkageError) {
                ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
                PrintStream ps = new PrintStream(os);
                ps.println("Unable to load the mojo '" + mojoDescriptor.getGoal() + "' in the plugin '" + pluginDescriptor.getId() + "' due to an API incompatibility: " + ((Object)((Object)e)).getClass().getName() + ": " + cause.getMessage());
                pluginRealm.display(ps);
                throw new PluginContainerException(mojoDescriptor, pluginRealm, os.toString(), cause);
            }
            throw new PluginContainerException(mojoDescriptor, pluginRealm, "Unable to load the mojo '" + mojoDescriptor.getGoal() + "' (or one of its required components) from the plugin '" + pluginDescriptor.getId() + "'", e);
        }
        if (mojo instanceof ContextEnabled) {
            ContextEnabled contextEnabledMojo = (ContextEnabled)mojo;
            MavenProject project = session.getCurrentProject();
            Map<String, Object> pluginContext = session.getPluginContext(pluginDescriptor, project);
            if (pluginContext != null) {
                pluginContext.put("project", project);
                pluginContext.put("pluginDescriptor", pluginDescriptor);
                contextEnabledMojo.setPluginContext(pluginContext);
            }
        }
        if (mojo instanceof Mojo) {
            Mojo mojoInstance = (Mojo)mojo;
            Logger mojoLogger = LoggerFactory.getLogger((String)mojoDescriptor.getImplementation());
            mojoInstance.setLog((org.apache.maven.plugin.logging.Log)new MojoLogWrapper(mojoLogger));
        }
        if (mojo instanceof Contextualizable) {
            this.pluginValidationManager.reportPluginMojoValidationIssue(PluginValidationManager.IssueLocality.EXTERNAL, session, mojoDescriptor, mojo.getClass(), "Mojo implements `Contextualizable` interface from Plexus Container, which is EOL.");
        }
        XmlNode dom = mojoExecution.getConfiguration() != null ? mojoExecution.getConfiguration().getDom() : null;
        Object pomConfiguration = dom == null ? new DefaultPlexusConfiguration("configuration") : XmlPlexusConfiguration.toPlexusConfiguration((XmlNode)dom);
        PluginParameterExpressionEvaluator expressionEvaluator = new PluginParameterExpressionEvaluator(session, mojoExecution);
        for (MavenPluginConfigurationValidator validator : this.configurationValidators) {
            validator.validate(session, mojoDescriptor, mojo.getClass(), (PlexusConfiguration)pomConfiguration, (ExpressionEvaluator)expressionEvaluator);
        }
        this.populateMojoExecutionFields(mojo, mojoExecution.getExecutionId(), mojoDescriptor, pluginRealm, (PlexusConfiguration)pomConfiguration, (ExpressionEvaluator)expressionEvaluator);
        return (T)mojo;
    }

    private void populateMojoExecutionFields(Object mojo, String executionId, MojoDescriptor mojoDescriptor, ClassRealm pluginRealm, PlexusConfiguration configuration, ExpressionEvaluator expressionEvaluator) throws PluginConfigurationException {
        ComponentConfigurator configurator = null;
        String configuratorId = mojoDescriptor.getComponentConfigurator();
        if (configuratorId == null || configuratorId.isEmpty()) {
            configuratorId = mojoDescriptor.isV4Api() ? "enhanced" : "basic";
        }
        try {
            configurator = (ComponentConfigurator)this.container.lookup(ComponentConfigurator.class, configuratorId);
            DebugConfigurationListener listener = new DebugConfigurationListener(this.logger);
            ValidatingConfigurationListener validator = new ValidatingConfigurationListener(mojo, mojoDescriptor, listener);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Configuring mojo execution '" + mojoDescriptor.getId() + ":" + executionId + "' with " + configuratorId + " configurator -->");
            }
            configurator.configureComponent(mojo, configuration, expressionEvaluator, pluginRealm, (ConfigurationListener)validator);
            this.logger.debug("-- end configuration --");
            Collection<Parameter> missingParameters = validator.getMissingParameters();
            if (!missingParameters.isEmpty()) {
                if ("basic".equals(configuratorId)) {
                    throw new PluginParameterException(mojoDescriptor, new ArrayList<Parameter>(missingParameters));
                }
                this.validateParameters(mojoDescriptor, configuration, expressionEvaluator);
            }
        }
        catch (ComponentConfigurationException e) {
            String message = "Unable to parse configuration of mojo " + mojoDescriptor.getId();
            if (e.getFailedConfiguration() != null) {
                message = message + " for parameter " + e.getFailedConfiguration().getName();
            }
            message = message + ": " + e.getMessage();
            throw new PluginConfigurationException(mojoDescriptor.getPluginDescriptor(), message, e);
        }
        catch (ComponentLookupException e) {
            throw new PluginConfigurationException(mojoDescriptor.getPluginDescriptor(), "Unable to retrieve component configurator " + configuratorId + " for configuration of mojo " + mojoDescriptor.getId(), e);
        }
        catch (NoClassDefFoundError e) {
            ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
            PrintStream ps = new PrintStream(os);
            ps.println("A required class was missing during configuration of mojo " + mojoDescriptor.getId() + ": " + e.getMessage());
            pluginRealm.display(ps);
            throw new PluginConfigurationException(mojoDescriptor.getPluginDescriptor(), os.toString(), e);
        }
        catch (LinkageError e) {
            ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
            PrintStream ps = new PrintStream(os);
            ps.println("An API incompatibility was encountered during configuration of mojo " + mojoDescriptor.getId() + ": " + e.getClass().getName() + ": " + e.getMessage());
            pluginRealm.display(ps);
            throw new PluginConfigurationException(mojoDescriptor.getPluginDescriptor(), os.toString(), e);
        }
        finally {
            if (configurator != null) {
                try {
                    this.container.release((Object)configurator);
                }
                catch (ComponentLifecycleException e) {
                    this.logger.debug("Failed to release mojo configurator - ignoring.");
                }
            }
        }
    }

    private void validateParameters(MojoDescriptor mojoDescriptor, PlexusConfiguration configuration, ExpressionEvaluator expressionEvaluator) throws ComponentConfigurationException, PluginParameterException {
        if (mojoDescriptor.getParameters() == null) {
            return;
        }
        ArrayList<Parameter> invalidParameters = new ArrayList<Parameter>();
        for (Parameter parameter : mojoDescriptor.getParameters()) {
            if (!parameter.isRequired()) continue;
            Object value = null;
            PlexusConfiguration config = configuration.getChild(parameter.getName(), false);
            if (config != null) {
                String expression = config.getValue(null);
                try {
                    value = expressionEvaluator.evaluate(expression);
                    if (value == null) {
                        value = config.getAttribute("default-value", null);
                    }
                }
                catch (ExpressionEvaluationException e) {
                    String msg = "Error evaluating the expression '" + expression + "' for configuration value '" + configuration.getName() + "'";
                    throw new ComponentConfigurationException(configuration, msg, (Throwable)e);
                }
            }
            if (value != null || config != null && config.getChildCount() > 0) continue;
            invalidParameters.add(parameter);
        }
        if (!invalidParameters.isEmpty()) {
            throw new PluginParameterException(mojoDescriptor, invalidParameters);
        }
    }

    @Override
    public void releaseMojo(Object mojo, MojoExecution mojoExecution) {
        if (mojo != null) {
            try {
                this.container.release(mojo);
            }
            catch (ComponentLifecycleException e) {
                String goalExecId = mojoExecution.getGoal();
                if (mojoExecution.getExecutionId() != null) {
                    this.logger.debug("Error releasing mojo for {} {execution: {}}", new Object[]{goalExecId, mojoExecution.getExecutionId(), e});
                }
                this.logger.debug("Error releasing mojo for {}", (Object)goalExecId, (Object)e);
            }
        }
    }

    @Override
    public ExtensionRealmCache.CacheRecord setupExtensionsRealm(MavenProject project, Plugin plugin, RepositorySystemSession session) throws PluginManagerException {
        List<Artifact> artifacts;
        PluginArtifactsCache.CacheRecord recordArtifacts;
        String pluginKey;
        ExtensionRealmCache.CacheRecord extensionRecord;
        HashMap<String, ExtensionRealmCache.CacheRecord> pluginRealms = (HashMap<String, ExtensionRealmCache.CacheRecord>)project.getContextValue(KEY_EXTENSIONS_REALMS);
        if (pluginRealms == null) {
            pluginRealms = new HashMap<String, ExtensionRealmCache.CacheRecord>();
            project.setContextValue(KEY_EXTENSIONS_REALMS, pluginRealms);
        }
        if ((extensionRecord = (ExtensionRealmCache.CacheRecord)pluginRealms.get(pluginKey = plugin.getId())) != null) {
            return extensionRecord;
        }
        List<RemoteRepository> repositories = project.getRemotePluginRepositories();
        if (plugin.getVersion() == null) {
            DefaultPluginVersionRequest versionRequest = new DefaultPluginVersionRequest(plugin, session, repositories);
            try {
                plugin.setVersion(this.pluginVersionResolver.resolve(versionRequest).getVersion());
            }
            catch (PluginVersionResolutionException e) {
                throw new PluginManagerException(plugin, e.getMessage(), (Throwable)e);
            }
        }
        PluginArtifactsCache.Key cacheKey = this.pluginArtifactsCache.createKey(plugin, null, repositories, session);
        try {
            recordArtifacts = this.pluginArtifactsCache.get(cacheKey);
        }
        catch (PluginResolutionException e) {
            throw new PluginManagerException(plugin, e.getMessage(), (Throwable)e);
        }
        if (recordArtifacts != null) {
            artifacts = recordArtifacts.getArtifacts();
        } else {
            try {
                artifacts = this.resolveExtensionArtifacts(plugin, repositories, session);
                recordArtifacts = this.pluginArtifactsCache.put(cacheKey, artifacts);
            }
            catch (PluginResolutionException e) {
                this.pluginArtifactsCache.put(cacheKey, e);
                this.pluginArtifactsCache.register(project, cacheKey, recordArtifacts);
                throw new PluginManagerException(plugin, e.getMessage(), (Throwable)e);
            }
        }
        this.pluginArtifactsCache.register(project, cacheKey, recordArtifacts);
        ExtensionRealmCache.Key extensionKey = this.extensionRealmCache.createKey(artifacts);
        extensionRecord = this.extensionRealmCache.get(extensionKey);
        if (extensionRecord == null) {
            ClassRealm extensionRealm = this.classRealmManager.createExtensionRealm(plugin, this.toAetherArtifacts(artifacts));
            PluginDescriptor pluginDescriptor = null;
            if (plugin.isExtensions() && !artifacts.isEmpty()) {
                try {
                    pluginDescriptor = this.extractPluginDescriptor(artifacts.get(0), plugin);
                }
                catch (InvalidPluginDescriptorException | PluginDescriptorParsingException exception) {
                    // empty catch block
                }
            }
            this.discoverPluginComponents(extensionRealm, plugin, pluginDescriptor);
            ExtensionDescriptor extensionDescriptor = null;
            Artifact extensionArtifact = artifacts.get(0);
            try {
                extensionDescriptor = this.extensionDescriptorBuilder.build(extensionArtifact.getFile());
            }
            catch (IOException e) {
                String message = "Invalid extension descriptor for " + plugin.getId() + ": " + e.getMessage();
                if (this.logger.isDebugEnabled()) {
                    this.logger.error(message, (Throwable)e);
                }
                this.logger.error(message);
            }
            extensionRecord = this.extensionRealmCache.put(extensionKey, extensionRealm, extensionDescriptor, artifacts);
        }
        this.extensionRealmCache.register(project, extensionKey, extensionRecord);
        pluginRealms.put(pluginKey, extensionRecord);
        return extensionRecord;
    }

    private List<Artifact> resolveExtensionArtifacts(Plugin extensionPlugin, List<RemoteRepository> repositories, RepositorySystemSession session) throws PluginResolutionException {
        DependencyResult root = this.pluginDependenciesResolver.resolvePlugin(extensionPlugin, null, null, repositories, session);
        return this.toMavenArtifacts(root);
    }

    private static /* synthetic */ InputStream lambda$extractPluginDescriptor$1(File pluginXml) throws IOException {
        return Files.newInputStream(pluginXml.toPath(), new OpenOption[0]);
    }

    private static /* synthetic */ InputStream lambda$extractPluginDescriptor$0(JarFile pluginJar, ZipEntry pluginDescriptorEntry) throws IOException {
        return pluginJar.getInputStream(pluginDescriptorEntry);
    }
}

