/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.artifact;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.metadata.ResolutionGroup;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.ArtifactRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.MultipleArtifactsNotFoundException;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExclusionArtifactFilter;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.bridge.MavenRepositorySystem;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Relocation;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.artifact.ArtifactWithDependencies;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.project.artifact.MavenMetadataCache;
import org.apache.maven.properties.internal.EnvironmentUtils;
import org.apache.maven.properties.internal.SystemProperties;
import org.apache.maven.repository.internal.MavenWorkspaceReader;
import org.apache.maven.repository.legacy.metadata.DefaultMetadataResolutionRequest;
import org.apache.maven.repository.legacy.metadata.MetadataResolutionRequest;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.transfer.ArtifactNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="maven")
@Singleton
@Deprecated
public class MavenMetadataSource
implements ArtifactMetadataSource {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final RepositoryMetadataManager repositoryMetadataManager;
    private final ArtifactFactory artifactFactory;
    private final ProjectBuilder projectBuilder;
    private final MavenMetadataCache cache;
    private final LegacySupport legacySupport;
    private MavenRepositorySystem mavenRepositorySystem;

    @Inject
    public MavenMetadataSource(RepositoryMetadataManager repositoryMetadataManager, ArtifactFactory artifactFactory, ProjectBuilder projectBuilder, MavenMetadataCache cache, LegacySupport legacySupport, MavenRepositorySystem mavenRepositorySystem) {
        this.repositoryMetadataManager = repositoryMetadataManager;
        this.artifactFactory = artifactFactory;
        this.projectBuilder = projectBuilder;
        this.cache = cache;
        this.legacySupport = legacySupport;
        this.mavenRepositorySystem = mavenRepositorySystem;
    }

    private void injectSession(MetadataResolutionRequest request) {
        RepositorySystemSession session = this.legacySupport.getRepositorySession();
        if (session != null) {
            request.setOffline(session.isOffline());
            request.setForceUpdate("always".equals(session.getUpdatePolicy()));
        }
    }

    @Override
    public ResolutionGroup retrieve(Artifact artifact, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories) throws ArtifactMetadataRetrievalException {
        return this.retrieve(artifact, localRepository, remoteRepositories, false);
    }

    public ResolutionGroup retrieve(Artifact artifact, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, boolean resolveManagedVersions) throws ArtifactMetadataRetrievalException {
        DefaultMetadataResolutionRequest request = new DefaultMetadataResolutionRequest();
        this.injectSession(request);
        request.setArtifact(artifact);
        request.setLocalRepository(localRepository);
        request.setRemoteRepositories((List)remoteRepositories);
        request.setResolveManagedVersions(resolveManagedVersions);
        return this.retrieve(request);
    }

    @Override
    public ResolutionGroup retrieve(MetadataResolutionRequest request) throws ArtifactMetadataRetrievalException {
        List dependencies;
        Artifact pomArtifact;
        Model model;
        Artifact artifact = request.getArtifact();
        if (artifact.getScope() != null && artifact.getScope().equals("system")) {
            return new ResolutionGroup(null, null, null);
        }
        ResolutionGroup cached = this.cache.get(artifact, request.isResolveManagedVersions(), request.getLocalRepository(), request.getRemoteRepositories());
        if (cached != null && (!request.isForceUpdate() || this.hasFile(cached.getPomArtifact()))) {
            return cached;
        }
        List managedDependencies = null;
        List<Object> pomRepositories = null;
        Artifact relocatedArtifact = null;
        RepositorySystemSession repositorySession = this.legacySupport.getRepositorySession();
        WorkspaceReader workspace = repositorySession.getWorkspaceReader();
        if (workspace instanceof MavenWorkspaceReader) {
            MavenWorkspaceReader mavenWorkspaceReader = (MavenWorkspaceReader)workspace;
            model = mavenWorkspaceReader.findModel(RepositoryUtils.toArtifact((Artifact)artifact));
        } else {
            model = null;
        }
        if (model != null) {
            pomArtifact = artifact;
            dependencies = model.getDependencies();
            DependencyManagement dependencyManagement = model.getDependencyManagement();
            managedDependencies = dependencyManagement == null ? null : dependencyManagement.getDependencies();
            MavenSession session = this.legacySupport.getSession();
            pomRepositories = session != null ? (session.getProjects() != null ? session.getProjects().stream().filter(p -> artifact.equals((Object)p.getArtifact())).map(MavenProject::getRemoteArtifactRepositories).findFirst().orElseGet(() -> this.getRepositoriesFromModel(repositorySession, model)) : this.getRepositoriesFromModel(repositorySession, model)) : new ArrayList();
        } else if (artifact instanceof ArtifactWithDependencies) {
            ArtifactWithDependencies artifactWithDependencies = (ArtifactWithDependencies)artifact;
            pomArtifact = artifact;
            dependencies = artifactWithDependencies.getDependencies();
            managedDependencies = artifactWithDependencies.getManagedDependencies();
        } else {
            ProjectRelocation rel = this.retrieveRelocatedProject(artifact, request);
            if (rel == null) {
                return null;
            }
            pomArtifact = rel.pomArtifact;
            relocatedArtifact = rel.relocatedArtifact;
            if (rel.project == null) {
                dependencies = Collections.emptyList();
            } else {
                dependencies = rel.project.getModel().getDependencies();
                DependencyManagement depMgmt = rel.project.getModel().getDependencyManagement();
                managedDependencies = depMgmt != null ? depMgmt.getDependencies() : null;
                pomRepositories = rel.project.getRemoteArtifactRepositories();
            }
        }
        Set<Artifact> artifacts = Collections.emptySet();
        if (!artifact.getArtifactHandler().isIncludesDependencies()) {
            artifacts = new LinkedHashSet();
            for (Object dependency : dependencies) {
                Artifact dependencyArtifact = this.createDependencyArtifact((Dependency)dependency, artifact, pomArtifact);
                if (dependencyArtifact == null) continue;
                artifacts.add(dependencyArtifact);
            }
        }
        HashMap<String, Artifact> managedVersions = null;
        if (managedDependencies != null && request.isResolveManagedVersions()) {
            managedVersions = new HashMap<String, Artifact>();
            for (Dependency managedDependency : managedDependencies) {
                Artifact managedArtifact = this.createDependencyArtifact(managedDependency, null, pomArtifact);
                managedVersions.put(managedDependency.getManagementKey(), managedArtifact);
            }
        }
        List<ArtifactRepository> aggregatedRepositories = this.aggregateRepositories(request.getRemoteRepositories(), pomRepositories);
        ResolutionGroup result = new ResolutionGroup(pomArtifact, relocatedArtifact, artifacts, managedVersions, aggregatedRepositories);
        this.cache.put(artifact, request.isResolveManagedVersions(), request.getLocalRepository(), request.getRemoteRepositories(), result);
        return result;
    }

    private List<ArtifactRepository> getRepositoriesFromModel(RepositorySystemSession repositorySession, Model model) {
        ArrayList<ArtifactRepository> pomRepositories = new ArrayList<ArtifactRepository>();
        for (Repository modelRepository : model.getRepositories()) {
            try {
                pomRepositories.add(MavenRepositorySystem.buildArtifactRepository((Repository)modelRepository));
            }
            catch (InvalidRepositoryException invalidRepositoryException) {}
        }
        this.mavenRepositorySystem.injectMirror(repositorySession, pomRepositories);
        this.mavenRepositorySystem.injectProxy(repositorySession, pomRepositories);
        this.mavenRepositorySystem.injectAuthentication(repositorySession, pomRepositories);
        return pomRepositories;
    }

    private boolean hasFile(Artifact artifact) {
        return artifact != null && artifact.getFile() != null && artifact.getFile().exists();
    }

    private List<ArtifactRepository> aggregateRepositories(List<ArtifactRepository> requestRepositories, List<ArtifactRepository> pomRepositories) {
        List<ArtifactRepository> repositories = requestRepositories;
        if (pomRepositories != null && !pomRepositories.isEmpty()) {
            LinkedHashMap<String, ArtifactRepository> repos = new LinkedHashMap<String, ArtifactRepository>();
            for (ArtifactRepository repo : requestRepositories) {
                if (repos.containsKey(repo.getId())) continue;
                repos.put(repo.getId(), repo);
            }
            for (ArtifactRepository repo : pomRepositories) {
                if (repos.containsKey(repo.getId())) continue;
                repos.put(repo.getId(), repo);
            }
            repositories = new ArrayList(repos.values());
        }
        return repositories;
    }

    private Artifact createDependencyArtifact(Dependency dependency, Artifact owner, Artifact pom) throws ArtifactMetadataRetrievalException {
        try {
            String inheritedScope = owner != null ? owner.getScope() : null;
            ArtifactFilter inheritedFilter = owner != null ? owner.getDependencyFilter() : null;
            return MavenMetadataSource.createDependencyArtifact(this.artifactFactory, dependency, inheritedScope, inheritedFilter);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new ArtifactMetadataRetrievalException("Invalid version for dependency " + dependency.getManagementKey() + ": " + e.getMessage(), e, pom);
        }
    }

    private static Artifact createDependencyArtifact(ArtifactFactory factory, Dependency dependency, String inheritedScope, ArtifactFilter inheritedFilter) throws InvalidVersionSpecificationException {
        String effectiveScope = MavenMetadataSource.getEffectiveScope(dependency.getScope(), inheritedScope);
        if (effectiveScope == null) {
            return null;
        }
        VersionRange versionRange = VersionRange.createFromVersionSpec((String)dependency.getVersion());
        Artifact dependencyArtifact = factory.createDependencyArtifact(dependency.getGroupId(), dependency.getArtifactId(), versionRange, dependency.getType(), dependency.getClassifier(), effectiveScope, dependency.isOptional());
        if (inheritedFilter != null && !inheritedFilter.include(dependencyArtifact)) {
            return null;
        }
        if ("system".equals(effectiveScope)) {
            dependencyArtifact.setFile(new File(dependency.getSystemPath()));
        }
        dependencyArtifact.setDependencyFilter(MavenMetadataSource.createDependencyFilter(dependency, inheritedFilter));
        return dependencyArtifact;
    }

    private static String getEffectiveScope(String originalScope, String inheritedScope) {
        String effectiveScope = "runtime";
        if (originalScope == null) {
            originalScope = "compile";
        }
        if (inheritedScope == null) {
            effectiveScope = originalScope;
        } else if ("test".equals(originalScope) || "provided".equals(originalScope)) {
            effectiveScope = null;
        } else if ("system".equals(originalScope)) {
            effectiveScope = "system";
        } else if ("compile".equals(originalScope) && "compile".equals(inheritedScope)) {
            effectiveScope = "compile";
        } else if ("test".equals(inheritedScope)) {
            effectiveScope = "test";
        } else if ("provided".equals(inheritedScope)) {
            effectiveScope = "provided";
        }
        return effectiveScope;
    }

    private static ArtifactFilter createDependencyFilter(Dependency dependency, ArtifactFilter inheritedFilter) {
        ArtifactFilter effectiveFilter = inheritedFilter;
        if (!dependency.getExclusions().isEmpty()) {
            effectiveFilter = new ExclusionArtifactFilter(dependency.getExclusions());
            if (inheritedFilter != null) {
                effectiveFilter = new AndArtifactFilter(Arrays.asList(inheritedFilter, effectiveFilter));
            }
        }
        return effectiveFilter;
    }

    @Override
    public List<ArtifactVersion> retrieveAvailableVersions(Artifact artifact, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories) throws ArtifactMetadataRetrievalException {
        DefaultMetadataResolutionRequest request = new DefaultMetadataResolutionRequest();
        this.injectSession(request);
        request.setArtifact(artifact);
        request.setLocalRepository(localRepository);
        request.setRemoteRepositories((List)remoteRepositories);
        return this.retrieveAvailableVersions(request);
    }

    @Override
    public List<ArtifactVersion> retrieveAvailableVersions(MetadataResolutionRequest request) throws ArtifactMetadataRetrievalException {
        ArtifactRepositoryMetadata metadata = new ArtifactRepositoryMetadata(request.getArtifact());
        try {
            this.repositoryMetadataManager.resolve(metadata, request);
        }
        catch (RepositoryMetadataResolutionException e) {
            throw new ArtifactMetadataRetrievalException(e.getMessage(), e, request.getArtifact());
        }
        List availableVersions = request.getLocalRepository().findVersions(request.getArtifact());
        return this.retrieveAvailableVersionsFromMetadata(metadata.getMetadata(), availableVersions);
    }

    @Override
    public List<ArtifactVersion> retrieveAvailableVersionsFromDeploymentRepository(Artifact artifact, ArtifactRepository localRepository, ArtifactRepository deploymentRepository) throws ArtifactMetadataRetrievalException {
        ArtifactRepositoryMetadata metadata = new ArtifactRepositoryMetadata(artifact);
        try {
            this.repositoryMetadataManager.resolveAlways(metadata, localRepository, deploymentRepository);
        }
        catch (RepositoryMetadataResolutionException e) {
            throw new ArtifactMetadataRetrievalException(e.getMessage(), e, artifact);
        }
        List availableVersions = localRepository.findVersions(artifact);
        return this.retrieveAvailableVersionsFromMetadata(metadata.getMetadata(), availableVersions);
    }

    private List<ArtifactVersion> retrieveAvailableVersionsFromMetadata(Metadata repoMetadata, List<String> availableVersions) {
        LinkedHashSet<String> versions = new LinkedHashSet<String>();
        if (repoMetadata != null && repoMetadata.getVersioning() != null) {
            versions.addAll(repoMetadata.getVersioning().getVersions());
        }
        versions.addAll(availableVersions);
        ArrayList<ArtifactVersion> artifactVersions = new ArrayList<ArtifactVersion>(versions.size());
        for (String version : versions) {
            artifactVersions.add((ArtifactVersion)new DefaultArtifactVersion(version));
        }
        return artifactVersions;
    }

    @Deprecated
    public static Set<Artifact> createArtifacts(ArtifactFactory artifactFactory, List<Dependency> dependencies, String inheritedScope, ArtifactFilter dependencyFilter, MavenProject project) throws InvalidDependencyVersionException {
        LinkedHashSet<Artifact> artifacts = new LinkedHashSet<Artifact>();
        for (Dependency d : dependencies) {
            Artifact dependencyArtifact;
            try {
                dependencyArtifact = MavenMetadataSource.createDependencyArtifact(artifactFactory, d, inheritedScope, dependencyFilter);
            }
            catch (InvalidVersionSpecificationException e) {
                throw new InvalidDependencyVersionException(project.getId(), d, project.getFile(), e);
            }
            if (dependencyArtifact == null) continue;
            artifacts.add(dependencyArtifact);
        }
        return artifacts;
    }

    private ProjectRelocation retrieveRelocatedProject(Artifact artifact, MetadataResolutionRequest repositoryRequest) throws ArtifactMetadataRetrievalException {
        Artifact pomArtifact;
        MavenProject project;
        Artifact relocatedArtifact = null;
        boolean done = false;
        do {
            project = null;
            pomArtifact = this.artifactFactory.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getScope());
            if ("pom".equals(artifact.getType())) {
                pomArtifact.setFile(artifact.getFile());
            }
            if ("system".equals(artifact.getScope())) {
                done = true;
                continue;
            }
            try {
                DefaultProjectBuildingRequest configuration = new DefaultProjectBuildingRequest();
                configuration.setLocalRepository(repositoryRequest.getLocalRepository());
                configuration.setRemoteRepositories(repositoryRequest.getRemoteRepositories());
                configuration.setValidationLevel(0);
                configuration.setProcessPlugins(false);
                configuration.setRepositoryMerging(ProjectBuildingRequest.RepositoryMerging.REQUEST_DOMINANT);
                MavenSession session = this.legacySupport.getSession();
                if (session != null) {
                    configuration.setSystemProperties(session.getSystemProperties());
                    configuration.setUserProperties(session.getUserProperties());
                } else {
                    configuration.setSystemProperties(this.getSystemProperties());
                    configuration.setUserProperties(new Properties());
                }
                configuration.setRepositorySession(this.legacySupport.getRepositorySession());
                project = this.projectBuilder.build(pomArtifact, (ProjectBuildingRequest)configuration).getProject();
            }
            catch (ProjectBuildingException e) {
                String message;
                ModelProblem missingParentPom = this.hasMissingParentPom(e);
                if (missingParentPom != null) {
                    throw new ArtifactMetadataRetrievalException("Failed to process POM for " + artifact.getId() + ": " + missingParentPom.getMessage(), missingParentPom.getException(), artifact);
                }
                if (this.isMissingPom((Exception)((Object)e))) {
                    message = "Missing POM for " + artifact.getId();
                } else {
                    if (this.isNonTransferablePom((Exception)((Object)e))) {
                        throw new ArtifactMetadataRetrievalException("Failed to retrieve POM for " + artifact.getId() + ": " + e.getCause().getMessage(), e.getCause(), artifact);
                    }
                    message = "Invalid POM for " + artifact.getId() + ", transitive dependencies (if any) will not be available, enable verbose output (-X) for more details";
                }
                if (this.logger.isDebugEnabled()) {
                    message = message + ": " + e.getMessage();
                }
                this.logger.warn(message);
            }
            if (project != null) {
                Relocation relocation = null;
                DistributionManagement distMgmt = project.getModel().getDistributionManagement();
                if (distMgmt != null) {
                    relocation = distMgmt.getRelocation();
                    artifact.setDownloadUrl(distMgmt.getDownloadUrl());
                    pomArtifact.setDownloadUrl(distMgmt.getDownloadUrl());
                }
                if (relocation != null) {
                    if (relocation.getGroupId() != null) {
                        artifact.setGroupId(relocation.getGroupId());
                        relocatedArtifact = artifact;
                        project.setGroupId(relocation.getGroupId());
                    }
                    if (relocation.getArtifactId() != null) {
                        artifact.setArtifactId(relocation.getArtifactId());
                        relocatedArtifact = artifact;
                        project.setArtifactId(relocation.getArtifactId());
                    }
                    if (relocation.getVersion() != null) {
                        artifact.setVersionRange(VersionRange.createFromVersion((String)relocation.getVersion()));
                        relocatedArtifact = artifact;
                        project.setVersion(relocation.getVersion());
                    }
                    if (artifact.getDependencyFilter() != null && !artifact.getDependencyFilter().include(artifact)) {
                        return null;
                    }
                    List<ArtifactVersion> available = artifact.getAvailableVersions();
                    if (available != null && !available.isEmpty()) {
                        DefaultMetadataResolutionRequest metadataRequest = new DefaultMetadataResolutionRequest(repositoryRequest);
                        metadataRequest.setArtifact(artifact);
                        available = this.retrieveAvailableVersions(metadataRequest);
                        artifact.setAvailableVersions(available);
                    }
                    String message = "  this artifact has been relocated to " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion() + ".";
                    if (relocation.getMessage() != null) {
                        message = message + "  " + relocation.getMessage();
                    }
                    if (artifact.getDependencyTrail() != null && artifact.getDependencyTrail().size() == 1) {
                        this.logger.warn("While downloading {}:{}:{}{}", new Object[]{pomArtifact.getGroupId(), pomArtifact.getArtifactId(), pomArtifact.getVersion(), message});
                        continue;
                    }
                    this.logger.debug("While downloading {}:{}:{}{}", new Object[]{pomArtifact.getGroupId(), pomArtifact.getArtifactId(), pomArtifact.getVersion(), message});
                    continue;
                }
                done = true;
                continue;
            }
            done = true;
        } while (!done);
        ProjectRelocation rel = new ProjectRelocation();
        rel.project = project;
        rel.pomArtifact = pomArtifact;
        rel.relocatedArtifact = relocatedArtifact;
        return rel;
    }

    private ModelProblem hasMissingParentPom(ProjectBuildingException e) {
        Throwable throwable = e.getCause();
        if (throwable instanceof ModelBuildingException) {
            ModelBuildingException mbe = (ModelBuildingException)throwable;
            for (ModelProblem problem : mbe.getProblems()) {
                if (!(problem.getException() instanceof UnresolvableModelException)) continue;
                return problem;
            }
        }
        return null;
    }

    private boolean isMissingPom(Exception e) {
        if (e.getCause() instanceof MultipleArtifactsNotFoundException) {
            return true;
        }
        return e.getCause() instanceof org.eclipse.aether.resolution.ArtifactResolutionException && e.getCause().getCause() instanceof ArtifactNotFoundException;
    }

    private boolean isNonTransferablePom(Exception e) {
        if (e.getCause() instanceof ArtifactResolutionException) {
            return true;
        }
        return e.getCause() instanceof org.eclipse.aether.resolution.ArtifactResolutionException && !(e.getCause().getCause() instanceof ArtifactNotFoundException);
    }

    private Properties getSystemProperties() {
        Properties props = new Properties();
        EnvironmentUtils.addEnvVars((Properties)props);
        SystemProperties.addSystemProperties((Properties)props);
        return props;
    }

    private static final class ProjectRelocation {
        private MavenProject project;
        private Artifact pomArtifact;
        private Artifact relocatedArtifact;

        private ProjectRelocation() {
        }
    }
}

