/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.maven.api.Repository;
import org.apache.maven.api.Session;
import org.apache.maven.api.Version;
import org.apache.maven.api.di.Inject;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.services.VersionRangeResolver;
import org.apache.maven.api.services.VersionRangeResolverException;
import org.apache.maven.api.services.VersionRangeResolverRequest;
import org.apache.maven.api.services.VersionRangeResolverResult;
import org.apache.maven.impl.DefaultLocalRepository;
import org.apache.maven.impl.DefaultRemoteRepository;
import org.apache.maven.impl.ImplUtils;
import org.apache.maven.impl.InternalSession;
import org.apache.maven.impl.RequestTraceHelper;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;

@Named
@Singleton
public class DefaultVersionRangeResolver
implements VersionRangeResolver {
    private final RepositorySystem repositorySystem;

    @Inject
    public DefaultVersionRangeResolver(RepositorySystem repositorySystem) {
        this.repositorySystem = repositorySystem;
    }

    public VersionRangeResolverResult resolve(VersionRangeResolverRequest request) throws VersionRangeResolverException {
        Objects.requireNonNull(request, "request");
        InternalSession session = InternalSession.from((Session)request.getSession());
        return session.request(request, this::doResolve);
    }

    public VersionRangeResolverResult doResolve(final VersionRangeResolverRequest request) throws VersionRangeResolverException {
        final InternalSession session = InternalSession.from((Session)request.getSession());
        RequestTraceHelper.ResolverTrace trace = RequestTraceHelper.enter(session, request);
        try {
            final VersionRangeResult res = this.repositorySystem.resolveVersionRange(session.getSession(), new VersionRangeRequest(session.toArtifact(request.getArtifactCoordinates()), session.toRepositories(request.getRepositories() != null ? request.getRepositories() : session.getRemoteRepositories()), trace.context()).setTrace(trace.trace()));
            final Map<String, ArtifactRepository> repos = res.getVersions().stream().filter(v -> res.getRepository(v) != null).collect(Collectors.toMap(v -> v.toString(), arg_0 -> ((VersionRangeResult)res).getRepository(arg_0)));
            VersionRangeResolverResult versionRangeResolverResult = new VersionRangeResolverResult(){
                final /* synthetic */ DefaultVersionRangeResolver this$0;
                {
                    this.this$0 = this$0;
                }

                public VersionRangeResolverRequest getRequest() {
                    return request;
                }

                public List<Exception> getExceptions() {
                    return res.getExceptions();
                }

                public List<Version> getVersions() {
                    return ImplUtils.map(res.getVersions(), v -> session.parseVersion(v.toString()));
                }

                public Optional<Repository> getRepository(Version version) {
                    ArtifactRepository repo = (ArtifactRepository)repos.get(version.toString());
                    if (repo instanceof LocalRepository) {
                        LocalRepository localRepository = (LocalRepository)repo;
                        return Optional.of(new DefaultLocalRepository(localRepository));
                    }
                    if (repo instanceof RemoteRepository) {
                        RemoteRepository remoteRepository = (RemoteRepository)repo;
                        return Optional.of(new DefaultRemoteRepository(remoteRepository));
                    }
                    return Optional.empty();
                }
            };
            return versionRangeResolverResult;
        }
        catch (VersionRangeResolutionException e) {
            throw new VersionRangeResolverException("Unable to resolve version range", (Throwable)e);
        }
        finally {
            RequestTraceHelper.exit(trace);
        }
    }
}

