/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl;

import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.maven.api.Language;
import org.apache.maven.api.ProjectScope;
import org.apache.maven.api.Session;
import org.apache.maven.api.SourceRoot;
import org.apache.maven.api.Version;
import org.apache.maven.api.model.Resource;
import org.apache.maven.api.model.Source;
import org.apache.maven.impl.PathSelector;

public final class DefaultSourceRoot
implements SourceRoot {
    private final Path directory;
    private final List<String> includes;
    private final List<String> excludes;
    private final ProjectScope scope;
    private final Language language;
    private final String moduleName;
    private final Version targetVersion;
    private final Path targetPath;
    private final boolean stringFiltering;
    private final boolean enabled;

    public DefaultSourceRoot(Session session, Path baseDir, Source source) {
        this.includes = source.getIncludes();
        this.excludes = source.getExcludes();
        this.stringFiltering = source.isStringFiltering();
        this.enabled = source.isEnabled();
        this.moduleName = DefaultSourceRoot.nonBlank(source.getModule());
        String value = DefaultSourceRoot.nonBlank(source.getScope());
        this.scope = value != null ? session.requireProjectScope(value) : ProjectScope.MAIN;
        value = DefaultSourceRoot.nonBlank(source.getLang());
        this.language = value != null ? session.requireLanguage(value) : Language.JAVA_FAMILY;
        value = DefaultSourceRoot.nonBlank(source.getDirectory());
        if (value != null) {
            this.directory = baseDir.resolve(value);
        } else {
            Path src = baseDir.resolve("src");
            if (this.moduleName != null) {
                src = src.resolve(this.language.id());
            }
            this.directory = src.resolve(this.scope.id()).resolve(this.language.id());
        }
        value = DefaultSourceRoot.nonBlank(source.getTargetVersion());
        this.targetVersion = value != null ? session.parseVersion(value) : null;
        value = DefaultSourceRoot.nonBlank(source.getTargetPath());
        this.targetPath = value != null ? baseDir.resolve(value) : null;
    }

    public DefaultSourceRoot(Path baseDir, ProjectScope scope, Resource resource) {
        String value = DefaultSourceRoot.nonBlank(resource.getDirectory());
        if (value == null) {
            throw new IllegalArgumentException("Source declaration without directory value.");
        }
        this.directory = baseDir.resolve(value).normalize();
        this.includes = resource.getIncludes();
        this.excludes = resource.getExcludes();
        this.stringFiltering = Boolean.parseBoolean(resource.getFiltering());
        this.enabled = true;
        this.moduleName = null;
        this.scope = scope;
        this.language = Language.RESOURCES;
        this.targetVersion = null;
        this.targetPath = null;
    }

    public DefaultSourceRoot(ProjectScope scope, Language language, Path directory) {
        this.scope = Objects.requireNonNull(scope);
        this.language = Objects.requireNonNull(language);
        this.directory = Objects.requireNonNull(directory);
        this.includes = List.of();
        this.excludes = List.of();
        this.moduleName = null;
        this.targetVersion = null;
        this.targetPath = null;
        this.stringFiltering = false;
        this.enabled = true;
    }

    public DefaultSourceRoot(ProjectScope scope, Language language, Path directory, List<String> includes, List<String> excludes) {
        this.scope = Objects.requireNonNull(scope);
        this.language = language;
        this.directory = Objects.requireNonNull(directory);
        this.includes = includes != null ? List.copyOf(includes) : List.of();
        this.excludes = excludes != null ? List.copyOf(excludes) : List.of();
        this.moduleName = null;
        this.targetVersion = null;
        this.targetPath = null;
        this.stringFiltering = false;
        this.enabled = true;
    }

    private static String nonBlank(String value) {
        if (value != null && (value = value.trim()).isBlank()) {
            value = null;
        }
        return value;
    }

    public Path directory() {
        return this.directory;
    }

    public List<String> includes() {
        return this.includes;
    }

    public List<String> excludes() {
        return this.excludes;
    }

    public PathMatcher matcher(Collection<String> defaultIncludes, boolean useDefaultExcludes) {
        Collection<String> actual = this.includes();
        if (actual == null || actual.isEmpty()) {
            actual = defaultIncludes;
        }
        return new PathSelector(this.directory(), actual, this.excludes(), useDefaultExcludes).simplify();
    }

    public ProjectScope scope() {
        return this.scope;
    }

    public Language language() {
        return this.language;
    }

    public Optional<String> module() {
        return Optional.ofNullable(this.moduleName);
    }

    public Optional<Version> targetVersion() {
        return Optional.ofNullable(this.targetVersion);
    }

    public Optional<Path> targetPath() {
        return Optional.ofNullable(this.targetPath);
    }

    public boolean stringFiltering() {
        return this.stringFiltering;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public int hashCode() {
        return Objects.hash(this.directory, this.includes, this.excludes, this.scope, this.language, this.moduleName, this.targetVersion, this.targetPath, this.stringFiltering, this.enabled);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultSourceRoot) {
            DefaultSourceRoot other = (DefaultSourceRoot)obj;
            return this.directory.equals(other.directory) && this.includes.equals(other.includes) && this.excludes.equals(other.excludes) && Objects.equals(this.scope, other.scope) && Objects.equals(this.language, other.language) && Objects.equals(this.moduleName, other.moduleName) && Objects.equals(this.targetVersion, other.targetVersion) && this.stringFiltering == other.stringFiltering && this.enabled == other.enabled;
        }
        return false;
    }
}

