/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.api.DependencyCoordinates;
import org.apache.maven.api.DependencyScope;
import org.apache.maven.api.Exclusion;
import org.apache.maven.api.Packaging;
import org.apache.maven.api.ProducedArtifact;
import org.apache.maven.api.Project;
import org.apache.maven.api.Type;
import org.apache.maven.api.VersionConstraint;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.model.Dependency;
import org.apache.maven.api.model.DependencyManagement;
import org.apache.maven.api.model.Model;
import org.apache.maven.internal.impl.InternalMavenSession;
import org.apache.maven.internal.impl.MappedCollection;
import org.apache.maven.internal.impl.MappedList;
import org.apache.maven.internal.impl.Utils;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.ProjectArtifact;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;

public class DefaultProject
implements Project {
    private final InternalMavenSession session;
    private final MavenProject project;
    private final Packaging packaging;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultProject(InternalMavenSession session, MavenProject project) {
        this.session = session;
        this.project = project;
        ClassLoader ttcl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)project.getClassRealm());
            this.packaging = session.requirePackaging(project.getPackaging());
        }
        finally {
            Thread.currentThread().setContextClassLoader(ttcl);
        }
    }

    public InternalMavenSession getSession() {
        return this.session;
    }

    public MavenProject getProject() {
        return this.project;
    }

    @Nonnull
    public String getGroupId() {
        return this.project.getGroupId();
    }

    @Nonnull
    public String getArtifactId() {
        return this.project.getArtifactId();
    }

    @Nonnull
    public String getVersion() {
        return this.project.getVersion();
    }

    @Nonnull
    public List<ProducedArtifact> getArtifacts() {
        Artifact pomArtifact = RepositoryUtils.toArtifact((org.apache.maven.artifact.Artifact)new ProjectArtifact(this.project));
        Artifact projectArtifact = RepositoryUtils.toArtifact(this.project.getArtifact());
        ArrayList<ProducedArtifact> result = new ArrayList<ProducedArtifact>(2);
        result.add((ProducedArtifact)this.session.getArtifact(ProducedArtifact.class, pomArtifact));
        if (!ArtifactIdUtils.equalsVersionlessId((Artifact)pomArtifact, (Artifact)projectArtifact)) {
            result.add((ProducedArtifact)this.session.getArtifact(ProducedArtifact.class, projectArtifact));
        }
        return Collections.unmodifiableList(result);
    }

    @Nonnull
    public Packaging getPackaging() {
        return this.packaging;
    }

    @Nonnull
    public Model getModel() {
        return this.project.getModel().getDelegate();
    }

    @Nonnull
    public Path getPomPath() {
        return ((File)Utils.nonNull((Object)this.project.getFile(), (String)"pomPath")).toPath();
    }

    public Path getBasedir() {
        return ((File)Utils.nonNull((Object)this.project.getBasedir(), (String)"basedir")).toPath();
    }

    @Nonnull
    public List<DependencyCoordinates> getDependencies() {
        return new MappedList(this.getModel().getDependencies(), this::toDependency);
    }

    @Nonnull
    public List<DependencyCoordinates> getManagedDependencies() {
        DependencyManagement dependencyManagement = this.getModel().getDependencyManagement();
        if (dependencyManagement != null) {
            return new MappedList(dependencyManagement.getDependencies(), this::toDependency);
        }
        return Collections.emptyList();
    }

    public boolean isTopProject() {
        return this.getBasedir().equals(this.getSession().getTopDirectory());
    }

    public boolean isRootProject() {
        return this.getBasedir().equals(this.getRootDirectory());
    }

    public Path getRootDirectory() {
        return this.project.getRootDirectory();
    }

    public Optional<Project> getParent() {
        MavenProject parent = this.project.getParent();
        return Optional.ofNullable(this.session.getProject(parent));
    }

    @Nonnull
    private DependencyCoordinates toDependency(final Dependency dependency) {
        return new DependencyCoordinates(){

            public String getGroupId() {
                return dependency.getGroupId();
            }

            public String getArtifactId() {
                return dependency.getArtifactId();
            }

            public String getClassifier() {
                String classifier = dependency.getClassifier();
                if ((classifier == null || classifier.isEmpty()) && (classifier = this.getType().getClassifier()) == null) {
                    classifier = "";
                }
                return classifier;
            }

            public VersionConstraint getVersionConstraint() {
                return DefaultProject.this.session.parseVersionConstraint(dependency.getVersion());
            }

            public String getExtension() {
                return this.getType().getExtension();
            }

            public Type getType() {
                String type = dependency.getType();
                return DefaultProject.this.session.requireType(type);
            }

            @Nonnull
            public DependencyScope getScope() {
                String scope = dependency.getScope() != null ? dependency.getScope() : "";
                return DefaultProject.this.session.requireDependencyScope(scope);
            }

            public Boolean getOptional() {
                return dependency.isOptional();
            }

            @Nonnull
            public Collection<Exclusion> getExclusions() {
                return new MappedCollection((Collection)dependency.getExclusions(), this::toExclusion);
            }

            private Exclusion toExclusion(final org.apache.maven.api.model.Exclusion exclusion) {
                return new Exclusion(){

                    @Nullable
                    public String getGroupId() {
                        return exclusion.getGroupId();
                    }

                    @Nullable
                    public String getArtifactId() {
                        return exclusion.getArtifactId();
                    }
                };
            }
        };
    }
}

