/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.invoker;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.cli.Logger;

public class ProtoLogger
implements Logger {
    private final PrintWriter out;
    private final PrintWriter err;

    public ProtoLogger() {
        this(null, null);
    }

    public ProtoLogger(@Nullable OutputStream out, @Nullable OutputStream err) {
        this.out = new PrintWriter(this.toPsOrDef(out, System.out), true);
        this.err = new PrintWriter(this.toPsOrDef(err, System.err), true);
    }

    private PrintStream toPsOrDef(OutputStream outputStream, PrintStream def) {
        if (outputStream == null) {
            return def;
        }
        if (outputStream instanceof PrintStream) {
            PrintStream ps = (PrintStream)outputStream;
            return ps;
        }
        return new PrintStream(outputStream);
    }

    public void log(Logger.Level level, String message, Throwable error) {
        PrintWriter pw;
        PrintWriter printWriter = level == Logger.Level.ERROR ? this.err : (pw = level == Logger.Level.WARN ? this.out : null);
        if (pw != null) {
            pw.println(level.name() + " " + message);
            if (error != null) {
                error.printStackTrace(pw);
            }
        }
    }
}

