/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.invoker;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.maven.api.ProtoSession;
import org.apache.maven.api.cli.InvokerException;
import org.apache.maven.api.cli.InvokerRequest;
import org.apache.maven.api.cli.Logger;
import org.apache.maven.api.services.Lookup;
import org.apache.maven.api.settings.Settings;
import org.apache.maven.cling.invoker.ContainerCapsule;
import org.apache.maven.cling.logging.Slf4jConfiguration;
import org.jline.terminal.Terminal;
import org.slf4j.ILoggerFactory;

public class LookupContext
implements AutoCloseable {
    public final InvokerRequest invokerRequest;
    public final Function<String, Path> cwdResolver;
    public final Function<String, Path> installationResolver;
    public final Function<String, Path> userResolver;
    public ProtoSession protoSession;
    public Logger logger;
    public ILoggerFactory loggerFactory;
    public Slf4jConfiguration slf4jConfiguration;
    public Slf4jConfiguration.Level loggerLevel;
    public Boolean coloredOutput;
    public Terminal terminal;
    public Consumer<String> writer;
    public ContainerCapsule containerCapsule;
    public Lookup lookup;
    public boolean interactive;
    public Path localRepositoryPath;
    public Settings effectiveSettings;
    public final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();

    protected LookupContext(InvokerRequest invokerRequest) {
        this.invokerRequest = Objects.requireNonNull(invokerRequest);
        this.cwdResolver = s -> invokerRequest.cwd().resolve((String)s).normalize().toAbsolutePath();
        this.installationResolver = s -> invokerRequest.installationDirectory().resolve((String)s).normalize().toAbsolutePath();
        this.userResolver = s -> invokerRequest.userHomeDirectory().resolve((String)s).normalize().toAbsolutePath();
        this.logger = invokerRequest.parserRequest().logger();
        HashMap<String, String> user = new HashMap<String, String>(invokerRequest.userProperties());
        user.put("session.topDirectory", invokerRequest.topDirectory().toString());
        if (invokerRequest.rootDirectory().isPresent()) {
            user.put("session.rootDirectory", ((Path)invokerRequest.rootDirectory().get()).toString());
        }
        this.protoSession = ProtoSession.newBuilder().withSystemProperties(invokerRequest.systemProperties()).withUserProperties(user).withTopDirectory(invokerRequest.topDirectory()).withRootDirectory((Path)invokerRequest.rootDirectory().orElse(null)).build();
    }

    @Override
    public void close() throws InvokerException {
        ArrayList<Exception> causes = null;
        ArrayList<AutoCloseable> cs = new ArrayList<AutoCloseable>(this.closeables);
        Collections.reverse(cs);
        for (AutoCloseable c : cs) {
            if (c == null) continue;
            try {
                c.close();
            }
            catch (Exception e) {
                if (causes == null) {
                    causes = new ArrayList<Exception>();
                }
                causes.add(e);
            }
        }
        if (causes != null) {
            InvokerException exception = new InvokerException("Unable to close context");
            causes.forEach(exception::addSuppressed);
            throw exception;
        }
    }

    protected void closeContainer() {
        if (this.containerCapsule != null) {
            try {
                this.containerCapsule.close();
            }
            finally {
                this.lookup = null;
                this.containerCapsule = null;
            }
        }
    }
}

