/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.slf4j;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.maven.logging.api.LogLevelRecorder;
import org.slf4j.event.Level;

public class DefaultLogLevelRecorder
implements LogLevelRecorder {
    private static final Map<String, LogLevelRecorder.Level> ACCEPTED_LEVELS = new HashMap<String, LogLevelRecorder.Level>();
    private LogLevelRecorder.Level maxAllowed;
    private final AtomicReference<LogLevelRecorder.Level> maxReached = new AtomicReference<LogLevelRecorder.Level>(LogLevelRecorder.Level.DEBUG);

    public DefaultLogLevelRecorder(String threshold) {
        this(DefaultLogLevelRecorder.determineThresholdLevel(threshold));
    }

    public DefaultLogLevelRecorder(LogLevelRecorder.Level maxAllowed) {
        this.maxAllowed = maxAllowed;
    }

    @Override
    public boolean hasReachedMaxLevel() {
        return this.maxReached.get().ordinal() > this.maxAllowed.ordinal();
    }

    @Override
    public LogLevelRecorder.Level getMaxLevelReached() {
        return this.maxReached.get();
    }

    @Override
    public LogLevelRecorder.Level getMaxLevelAllowed() {
        return this.maxAllowed;
    }

    @Override
    public void setMaxLevelAllowed(LogLevelRecorder.Level level) {
        this.maxAllowed = level;
    }

    private static LogLevelRecorder.Level determineThresholdLevel(String input) {
        LogLevelRecorder.Level result = ACCEPTED_LEVELS.get(input);
        if (result == null) {
            String message = String.format("%s is not a valid log severity threshold. Valid severities are WARN/WARNING and ERROR.", input);
            throw new IllegalArgumentException(message);
        }
        return result;
    }

    public void record(Level logLevel) {
        LogLevelRecorder.Level r;
        LogLevelRecorder.Level level = switch (logLevel) {
            default -> throw new IncompatibleClassChangeError();
            case Level.TRACE, Level.DEBUG -> LogLevelRecorder.Level.DEBUG;
            case Level.INFO -> LogLevelRecorder.Level.INFO;
            case Level.WARN -> LogLevelRecorder.Level.WARN;
            case Level.ERROR -> LogLevelRecorder.Level.ERROR;
        };
        do {
            r = this.maxReached.get();
        } while (level.ordinal() > r.ordinal() && !this.maxReached.compareAndSet(r, level));
    }

    public boolean metThreshold() {
        return this.maxReached.get().ordinal() >= this.maxAllowed.ordinal();
    }

    static {
        ACCEPTED_LEVELS.put("WARN", LogLevelRecorder.Level.WARN);
        ACCEPTED_LEVELS.put("WARNING", LogLevelRecorder.Level.WARN);
        ACCEPTED_LEVELS.put("ERROR", LogLevelRecorder.Level.ERROR);
    }
}

