/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl.di;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.di.Key;
import org.apache.maven.di.Scope;
import org.apache.maven.di.impl.DIException;

public class MojoExecutionScope
implements Scope {
    private final ThreadLocal<LinkedList<ScopeState>> values = new ThreadLocal();

    public static <T> Supplier<T> seededKeySupplier(Class<? extends T> clazz) {
        return () -> {
            throw new IllegalStateException("No instance of " + clazz.getName() + " is bound to the mojo execution scope.");
        };
    }

    public void enter() {
        LinkedList<ScopeState> stack = this.values.get();
        if (stack == null) {
            stack = new LinkedList();
            this.values.set(stack);
        }
        stack.addFirst(new ScopeState());
    }

    protected ScopeState getScopeState() {
        LinkedList<ScopeState> stack = this.values.get();
        if (stack == null || stack.isEmpty()) {
            throw new IllegalStateException();
        }
        return stack.getFirst();
    }

    public void exit() {
        LinkedList<ScopeState> stack = this.values.get();
        if (stack == null || stack.isEmpty()) {
            throw new IllegalStateException();
        }
        stack.removeFirst();
        if (stack.isEmpty()) {
            this.values.remove();
        }
    }

    public <T> void seed(Class<T> clazz, Supplier<T> value) {
        this.getScopeState().seed(clazz, value);
    }

    public <T> void seed(Class<T> clazz, T value) {
        this.seed(clazz, (T)((Supplier<Object>)() -> value));
    }

    @Nonnull
    public <T> Supplier<T> scope(@Nonnull Key<T> key, @Nonnull Supplier<T> unscoped) {
        return () -> {
            LinkedList<ScopeState> stack = this.values.get();
            if (stack == null || stack.isEmpty()) {
                throw new DIException("Cannot access " + String.valueOf(key) + " outside of a scoping block");
            }
            ScopeState state = stack.getFirst();
            Supplier<?> seeded = state.seeded.get(key);
            if (seeded != null) {
                return seeded.get();
            }
            Object provided = state.provided.get(key);
            if (provided == null && unscoped != null) {
                provided = unscoped.get();
                state.provided.put(key, provided);
            }
            return provided;
        };
    }

    protected static final class ScopeState {
        private final Map<Key<?>, Supplier<?>> seeded = new HashMap();
        private final Map<Key<?>, Object> provided = new HashMap();

        protected ScopeState() {
        }

        public <T> void seed(Class<T> clazz, Supplier<T> value) {
            this.seeded.put(Key.of(clazz), value);
        }

        public Collection<Object> provided() {
            return this.provided.values();
        }
    }
}

