/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.api.di.Inject;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.services.SuperPomProvider;
import org.apache.maven.api.services.model.ModelProcessor;
import org.apache.maven.api.services.xml.XmlReaderRequest;

@Named
@Singleton
public class DefaultSuperPomProvider
implements SuperPomProvider {
    private final ModelProcessor modelProcessor;
    private static final Map<String, Model> SUPER_MODELS = new ConcurrentHashMap<String, Model>();

    @Inject
    public DefaultSuperPomProvider(ModelProcessor modelProcessor) {
        this.modelProcessor = modelProcessor;
    }

    public Model getSuperPom(String version) {
        return SUPER_MODELS.computeIfAbsent(Objects.requireNonNull(version), v -> this.readModel(version, (String)v));
    }

    private Model readModel(String version, String v) {
        Model model;
        block9: {
            String resource = "/org/apache/maven/model/pom-" + v + ".xml";
            URL url = this.getClass().getResource(resource);
            if (url == null) {
                throw new IllegalStateException("The super POM " + resource + " was not found, please verify the integrity of your Maven installation");
            }
            InputStream is = url.openStream();
            try {
                String modelId = "org.apache.maven:maven-api-impl:" + this.getClass().getPackage().getImplementationVersion() + ":super-pom-" + version;
                model = this.modelProcessor.read(XmlReaderRequest.builder().modelId(modelId).location(url.toExternalForm()).inputStream(is).strict(false).build());
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("The super POM " + resource + " is damaged, please verify the integrity of your Maven installation", e);
                }
            }
            is.close();
        }
        return model;
    }
}

