/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.building;

import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.TransformerContext;
import org.apache.maven.model.locator.ModelLocator;

@Deprecated(since="4.0.0")
class DefaultTransformerContext
implements TransformerContext {
    final ModelLocator modelLocator;
    final Map<String, String> userProperties = new ConcurrentHashMap<String, String>();
    final Map<Path, Holder> modelByPath = new ConcurrentHashMap<Path, Holder>();
    final Map<GAKey, Holder> modelByGA = new ConcurrentHashMap<GAKey, Holder>();

    DefaultTransformerContext(ModelLocator modelLocator) {
        this.modelLocator = modelLocator;
    }

    @Override
    public String getUserProperty(String key) {
        return this.userProperties.get(key);
    }

    @Override
    public Model getRawModel(Path from, Path p) {
        return Holder.deref(this.modelByPath.get(p));
    }

    @Override
    public Model getRawModel(Path from, String groupId, String artifactId) {
        return Holder.deref(this.modelByGA.get(new GAKey(groupId, artifactId)));
    }

    @Override
    public Path locate(Path path) {
        File file = this.modelLocator.locateExistingPom(path.toFile());
        return file != null ? file.toPath() : null;
    }

    public static class Holder {
        private volatile boolean set;
        private volatile Model model;

        Holder() {
        }

        Holder(Model model) {
            this.model = Objects.requireNonNull(model);
            this.set = true;
        }

        public static Model deref(Holder holder) {
            return holder != null ? holder.get() : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Model get() {
            if (!this.set) {
                Holder holder = this;
                synchronized (holder) {
                    if (!this.set) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            return this.model;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Model computeIfAbsent(Supplier<Model> supplier) {
            if (!this.set) {
                Holder holder = this;
                synchronized (holder) {
                    if (!this.set) {
                        this.set = true;
                        this.model = supplier.get();
                        this.notifyAll();
                    }
                }
            }
            return this.model;
        }
    }

    static class GAKey {
        private final String groupId;
        private final String artifactId;
        private final int hashCode;

        GAKey(String groupId, String artifactId) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.hashCode = Objects.hash(groupId, artifactId);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof GAKey)) {
                return false;
            }
            GAKey other = (GAKey)obj;
            return Objects.equals(this.artifactId, other.artifactId) && Objects.equals(this.groupId, other.groupId);
        }
    }
}

