//
// Account.swift
// mas
//
// Copyright © 2015 mas-cli. All rights reserved.
//

internal import ArgumentParser

extension MAS {
	/// Outputs the Apple Account signed in to the App Store.
	struct Account: AsyncParsableCommand, Sendable {
		static let configuration = CommandConfiguration(
			abstract: "Output the Apple Account signed in to the App Store"
		)

		func run() async throws {
			guard let appleAccount = try await appleAccount.emailAddress else {
				throw MASError.error("Not signed in to an Apple Account in the App Store")
			}

			printer.info(appleAccount)
		}
	}
}
