
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file YHyperCoordinateAttributes.h
    \\brief Definition of YHyperCoordinate Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 2020-10-14
*/

#include "YHyperCoordinateAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

YHyperCoordinateAttributes::YHyperCoordinateAttributes():
	min_lat_(ParameterManager::getDouble("subpage_y_min_latitude")),
	max_lat_(ParameterManager::getDouble("subpage_y_max_latitude")),
	min_lon_(ParameterManager::getDouble("subpage_y_min_longitude")),
	max_lon_(ParameterManager::getDouble("subpage_y_max_longitude")),
	reverse_(ParameterManager::getBool("subpage_y_automatic_reverse"))
	,
	automatic_(MagTranslator<string, AxisAutomaticSetting>().magics("subpage_y_automatic"))
	 
{
} 


YHyperCoordinateAttributes::~YHyperCoordinateAttributes()
{
	
}

    
void YHyperCoordinateAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(3);
	int i = 0;
	prefix[i++] = "subpage";
	prefix[i++] = "subpage_y";
	prefix[i++] = "subpage_y_hyper";
	
	setAttribute(prefix, "subpage_y_min_latitude", min_lat_, params);
	setAttribute(prefix, "subpage_y_max_latitude", max_lat_, params);
	setAttribute(prefix, "subpage_y_min_longitude", min_lon_, params);
	setAttribute(prefix, "subpage_y_max_longitude", max_lon_, params);
	setAttribute(prefix, "subpage_y_automatic_reverse", reverse_, params);
	
	setAttribute(prefix, "subpage_y_automatic", automatic_, params);
	
}

void YHyperCoordinateAttributes::copy(const YHyperCoordinateAttributes& other)
{
	min_lat_ = other.min_lat_;
	max_lat_ = other.max_lat_;
	min_lon_ = other.min_lon_;
	max_lon_ = other.max_lon_;
	reverse_ = other.reverse_;
	automatic_ = other.automatic_;
	
} 


bool YHyperCoordinateAttributes::accept(const string& node)
{	
	
	if ( magCompare(node, "y_hyper")  )
		return true;
	
	return false;
}

void YHyperCoordinateAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "y_hyper")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		
	}
	for (auto &elt : node.elements())
	{
		
	}
}

void YHyperCoordinateAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " min_lat = " <<  min_lat_;
	out << " max_lat = " <<  max_lat_;
	out << " min_lon = " <<  min_lon_;
	out << " max_lon = " <<  max_lon_;
	out << " reverse = " <<  reverse_;
	out << " automatic = " <<  automatic_;
	
	out << "]" << "\n";
}

void YHyperCoordinateAttributes::toxml(ostream& out)  const
{
	out <<  "\"y_hyper\""; 
	out << ", \"subpage_y_min_latitude\":";
	niceprint(out,min_lat_);
	out << ", \"subpage_y_max_latitude\":";
	niceprint(out,max_lat_);
	out << ", \"subpage_y_min_longitude\":";
	niceprint(out,min_lon_);
	out << ", \"subpage_y_max_longitude\":";
	niceprint(out,max_lon_);
	out << ", \"subpage_y_automatic_reverse\":";
	niceprint(out,reverse_);
	out << ", \"subpage_y_automatic\":";
	niceprint(out, automatic_);
	
}

static MagicsParameter<double> subpage_y_min_latitude("subpage_y_min_latitude", -90, "");
static MagicsParameter<double> subpage_y_max_latitude("subpage_y_max_latitude", 90, "");
static MagicsParameter<double> subpage_y_min_longitude("subpage_y_min_longitude", -180, "");
static MagicsParameter<double> subpage_y_max_longitude("subpage_y_max_longitude", 180, "");
static MagicsParameter<string> subpage_y_automatic_reverse("subpage_y_automatic_reverse", "off", "");
static MagicsParameter<string> subpage_y_automatic("subpage_y_automatic", "off", ""); 
