
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file ValuePlotMethodAttributes.h
    \\brief Definition of ValuePlotMethod Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 2020-10-14
*/

#include "ValuePlotMethodAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

ValuePlotMethodAttributes::ValuePlotMethodAttributes():
	min_(ParameterManager::getDouble("contour_grid_value_min")),
	max_(ParameterManager::getDouble("contour_grid_value_max")),
	lat_frequency_(ParameterManager::getInt("contour_grid_value_lat_frequency")),
	lon_frequency_(ParameterManager::getInt("contour_grid_value_lon_frequency")),
	height_(ParameterManager::getDouble("contour_grid_value_height")),
	format_(ParameterManager::getString("contour_grid_value_format")),
	quality_(ParameterManager::getString("contour_grid_value_quality")),
	vertical_align_(ParameterManager::getString("contour_grid_value_vertical_align"))
	,
	colour_(MagTranslator<string, Colour>().magics("contour_grid_value_colour")),
	justification_(MagTranslator<string, Justification>().magics("contour_grid_value_justification"))
	 
{
} 


ValuePlotMethodAttributes::~ValuePlotMethodAttributes()
{
	
}

    
void ValuePlotMethodAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(3);
	int i = 0;
	prefix[i++] = "contour";
	prefix[i++] = "contour_grid_value";
	prefix[i++] = "contour_grid_value";
	
	setAttribute(prefix, "contour_grid_value_min", min_, params);
	setAttribute(prefix, "contour_grid_value_max", max_, params);
	setAttribute(prefix, "contour_grid_value_lat_frequency", lat_frequency_, params);
	setAttribute(prefix, "contour_grid_value_lon_frequency", lon_frequency_, params);
	setAttribute(prefix, "contour_grid_value_height", height_, params);
	setAttribute(prefix, "contour_grid_value_format", format_, params);
	setAttribute(prefix, "contour_grid_value_quality", quality_, params);
	setAttribute(prefix, "contour_grid_value_vertical_align", vertical_align_, params);
	
	setMember(prefix, "contour_grid_value_colour", colour_, params);
	setAttribute(prefix, "contour_grid_value_justification", justification_, params);
	
}

void ValuePlotMethodAttributes::copy(const ValuePlotMethodAttributes& other)
{
	min_ = other.min_;
	max_ = other.max_;
	lat_frequency_ = other.lat_frequency_;
	lon_frequency_ = other.lon_frequency_;
	height_ = other.height_;
	format_ = other.format_;
	quality_ = other.quality_;
	vertical_align_ = other.vertical_align_;
	colour_ = unique_ptr<Colour>(other.colour_->clone());
	justification_ = other.justification_;
	
} 


bool ValuePlotMethodAttributes::accept(const string& node)
{	
	
	if ( magCompare(node, "")  )
		return true;
	
	return false;
}

void ValuePlotMethodAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		
	}
	for (auto &elt : node.elements())
	{
		
	}
}

void ValuePlotMethodAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " min = " <<  min_;
	out << " max = " <<  max_;
	out << " lat_frequency = " <<  lat_frequency_;
	out << " lon_frequency = " <<  lon_frequency_;
	out << " height = " <<  height_;
	out << " format = " <<  format_;
	out << " quality = " <<  quality_;
	out << " vertical_align = " <<  vertical_align_;
	out << " colour = " <<  *colour_;
	out << " justification = " <<  justification_;
	
	out << "]" << "\n";
}

void ValuePlotMethodAttributes::toxml(ostream& out)  const
{
	out <<  "\"\""; 
	out << ", \"contour_grid_value_min\":";
	niceprint(out,min_);
	out << ", \"contour_grid_value_max\":";
	niceprint(out,max_);
	out << ", \"contour_grid_value_lat_frequency\":";
	niceprint(out,lat_frequency_);
	out << ", \"contour_grid_value_lon_frequency\":";
	niceprint(out,lon_frequency_);
	out << ", \"contour_grid_value_height\":";
	niceprint(out,height_);
	out << ", \"contour_grid_value_format\":";
	niceprint(out,format_);
	out << ", \"contour_grid_value_quality\":";
	niceprint(out,quality_);
	out << ", \"contour_grid_value_vertical_align\":";
	niceprint(out,vertical_align_);
	out << ", \"contour_grid_value_colour\":";
	niceprint(out, *colour_);
	out << ", \"contour_grid_value_justification\":";
	niceprint(out, justification_);
	
}

static MagicsParameter<double> contour_grid_value_min("contour_grid_value_min", -1.0e+21, "");
static MagicsParameter<double> contour_grid_value_max("contour_grid_value_max", 1.0e+21, "");
static MagicsParameter<int> contour_grid_value_lat_frequency("contour_grid_value_lat_frequency", 1, "");
static MagicsParameter<int> contour_grid_value_lon_frequency("contour_grid_value_lon_frequency", 1, "");
static MagicsParameter<double> contour_grid_value_height("contour_grid_value_height", 0.25, "");
static MagicsParameter<string> contour_grid_value_format("contour_grid_value_format", "(automatic)", "");
static MagicsParameter<string> contour_grid_value_quality("contour_grid_value_quality", "low", "");
static MagicsParameter<string> contour_grid_value_vertical_align("contour_grid_value_vertical_align", "base", "");
static MagicsParameter<string> contour_grid_value_colour("contour_grid_value_colour", "blue", ""); 
static MagicsParameter<string> contour_grid_value_justification("contour_grid_value_justification", "centre", ""); 
