
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file ValuePlotAttributes.h
    \\brief Definition of ValuePlot Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 2020-10-14
*/

#include "ValuePlotAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

ValuePlotAttributes::ValuePlotAttributes():
	type_(ParameterManager::getString("contour_grid_value_type"))
	,
	method_(MagTranslator<string, ValuePlotMethod>().magics("contour_grid_value_plot_type"))
	 
{
} 


ValuePlotAttributes::~ValuePlotAttributes()
{
	
}

    
void ValuePlotAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(3);
	int i = 0;
	prefix[i++] = "contour";
	prefix[i++] = "contour_grid_value";
	prefix[i++] = "contour_grid_value";
	
	setAttribute(prefix, "contour_grid_value_type", type_, params);
	
	setMember(prefix, "contour_grid_value_plot_type", method_, params);
	
}

void ValuePlotAttributes::copy(const ValuePlotAttributes& other)
{
	type_ = other.type_;
	method_ = unique_ptr<ValuePlotMethod>(other.method_->clone());
	
} 


bool ValuePlotAttributes::accept(const string& node)
{	
	
	if ( magCompare(node, "gridvalues")  )
		return true;
	if ( acceptNode(node, method_) )
		return true;
	
	return false;
}

void ValuePlotAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "gridvalues")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		setMember(node.name(), method_, node);
		
	}
	for (auto &elt : node.elements())
	{
		setMember(elt->name(), method_, *elt); 
		
	}
}

void ValuePlotAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " type = " <<  type_;
	out << " method = " <<  *method_;
	
	out << "]" << "\n";
}

void ValuePlotAttributes::toxml(ostream& out)  const
{
	out <<  "\"gridvalues\""; 
	out << ", \"contour_grid_value_type\":";
	niceprint(out,type_);
	out << ", \"contour_grid_value_plot_type\":";
	method_->toxml(out);
	
}

static MagicsParameter<string> contour_grid_value_type("contour_grid_value_type", "normal", "");
static MagicsParameter<string> contour_grid_value_plot_type("contour_grid_value_plot_type", "value", ""); 
#include "BothValuePlotMethod.h"
#include "MarkerValuePlotMethod.h"
#include "ValuePlotMethod.h"
static SimpleObjectMaker<ValuePlotMethod , ValuePlotMethod> value_ValuePlotMethod("value");
static SimpleObjectMaker<MarkerValuePlotMethod , ValuePlotMethod> marker_MarkerValuePlotMethod("marker");
static SimpleObjectMaker<BothValuePlotMethod , ValuePlotMethod> both_BothValuePlotMethod("both");
