
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file UserLogoPlottingAttributes.h
    \\brief Definition of UserLogoPlotting Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 2020-10-14
*/

#include "UserLogoPlottingAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

UserLogoPlottingAttributes::UserLogoPlottingAttributes():
	path_(ParameterManager::getString("user_logo_filename")),
	format_(ParameterManager::getString("user_logo_format")),
	units_(ParameterManager::getString("user_logo_position_units")),
	y_(ParameterManager::getDouble("user_logo_y_position")),
	x_(ParameterManager::getDouble("user_logo_x_position")),
	bottom_(ParameterManager::getString("user_logo_bottom")),
	left_(ParameterManager::getString("user_logo_left")),
	width_(ParameterManager::getDouble("user_logo_width")),
	height_(ParameterManager::getDouble("user_logo_height"))
	
	 
{
} 


UserLogoPlottingAttributes::~UserLogoPlottingAttributes()
{
	
}

    
void UserLogoPlottingAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(3);
	int i = 0;
	prefix[i++] = "page";
	prefix[i++] = "page";
	prefix[i++] = "user_logo";
	
	setAttribute(prefix, "user_logo_filename", path_, params);
	setAttribute(prefix, "user_logo_format", format_, params);
	setAttribute(prefix, "user_logo_position_units", units_, params);
	setAttribute(prefix, "user_logo_y_position", y_, params);
	setAttribute(prefix, "user_logo_x_position", x_, params);
	setAttribute(prefix, "user_logo_bottom", bottom_, params);
	setAttribute(prefix, "user_logo_left", left_, params);
	setAttribute(prefix, "user_logo_width", width_, params);
	setAttribute(prefix, "user_logo_height", height_, params);
	
	
}

void UserLogoPlottingAttributes::copy(const UserLogoPlottingAttributes& other)
{
	path_ = other.path_;
	format_ = other.format_;
	units_ = other.units_;
	y_ = other.y_;
	x_ = other.x_;
	bottom_ = other.bottom_;
	left_ = other.left_;
	width_ = other.width_;
	height_ = other.height_;
	
} 


bool UserLogoPlottingAttributes::accept(const string& node)
{	
	
	if ( magCompare(node, "userlogo")  )
		return true;
	
	return false;
}

void UserLogoPlottingAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "userlogo")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		
	}
	for (auto &elt : node.elements())
	{
		
	}
}

void UserLogoPlottingAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " path = " <<  path_;
	out << " format = " <<  format_;
	out << " units = " <<  units_;
	out << " y = " <<  y_;
	out << " x = " <<  x_;
	out << " bottom = " <<  bottom_;
	out << " left = " <<  left_;
	out << " width = " <<  width_;
	out << " height = " <<  height_;
	
	out << "]" << "\n";
}

void UserLogoPlottingAttributes::toxml(ostream& out)  const
{
	out <<  "\"userlogo\""; 
	out << ", \"user_logo_filename\":";
	niceprint(out,path_);
	out << ", \"user_logo_format\":";
	niceprint(out,format_);
	out << ", \"user_logo_position_units\":";
	niceprint(out,units_);
	out << ", \"user_logo_y_position\":";
	niceprint(out,y_);
	out << ", \"user_logo_x_position\":";
	niceprint(out,x_);
	out << ", \"user_logo_bottom\":";
	niceprint(out,bottom_);
	out << ", \"user_logo_left\":";
	niceprint(out,left_);
	out << ", \"user_logo_width\":";
	niceprint(out,width_);
	out << ", \"user_logo_height\":";
	niceprint(out,height_);
	
}

static MagicsParameter<string> user_logo_filename("user_logo_filename", "", "");
static MagicsParameter<string> user_logo_format("user_logo_format", "PNG", "");
static MagicsParameter<string> user_logo_position_units("user_logo_position_units", "cm", "");
static MagicsParameter<double> user_logo_y_position("user_logo_y_position", 2.5, "");
static MagicsParameter<double> user_logo_x_position("user_logo_x_position", 80, "");
static MagicsParameter<string> user_logo_bottom("user_logo_bottom", "", "");
static MagicsParameter<string> user_logo_left("user_logo_left", "", "");
static MagicsParameter<double> user_logo_width("user_logo_width", -1, "");
static MagicsParameter<double> user_logo_height("user_logo_height", -1, "");
