
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file OutputHandlerAttributes.h
    \\brief Definition of OutputHandler Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 2020-10-14
*/

#include "OutputHandlerAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

OutputHandlerAttributes::OutputHandlerAttributes():
	format_(ParameterManager::getString("output_format")),
	formats_(ParameterManager::getStringArray("output_formats"))
	
	 
{
} 


OutputHandlerAttributes::~OutputHandlerAttributes()
{
	
}

    
void OutputHandlerAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	int i = 0;
	prefix[i++] = "";
	
	setAttribute(prefix, "output_format", format_, params);
	setAttribute(prefix, "output_formats", formats_, params);
	
	
}

void OutputHandlerAttributes::copy(const OutputHandlerAttributes& other)
{
	format_ = other.format_;
	formats_ = other.formats_;
	
} 


bool OutputHandlerAttributes::accept(const string& node)
{	
	
	if ( magCompare(node, "output")  )
		return true;
	
	return false;
}

void OutputHandlerAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "output")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		
	}
	for (auto &elt : node.elements())
	{
		
	}
}

void OutputHandlerAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " format = " <<  format_;
	out << " formats = " <<  formats_;
	
	out << "]" << "\n";
}

void OutputHandlerAttributes::toxml(ostream& out)  const
{
	out <<  "\"output\""; 
	out << ", \"output_format\":";
	niceprint(out,format_);
	out << ", \"output_formats\":";
	niceprint(out,formats_);
	
}

static MagicsParameter<string> output_format("output_format", "ps", "");
static MagicsParameter<stringarray> output_formats("output_formats", stringarray(), "");
