
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file NetcdfDecoderAttributes.h
    \\brief Definition of NetcdfDecoder Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 2020-10-14
*/

#include "NetcdfDecoderAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

NetcdfDecoderAttributes::NetcdfDecoderAttributes():
	metadata_(ParameterManager::getString("netcdf_metadata"))
	,
	interpretor_(MagTranslator<string, NetcdfInterpretor>().magics("netcdf_type"))
	 
{
} 


NetcdfDecoderAttributes::~NetcdfDecoderAttributes()
{
	
}

    
void NetcdfDecoderAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	int i = 0;
	prefix[i++] = "netcdf";
	
	setAttribute(prefix, "netcdf_metadata", metadata_, params);
	
	setMember(prefix, "netcdf_type", interpretor_, params);
	
}

void NetcdfDecoderAttributes::copy(const NetcdfDecoderAttributes& other)
{
	metadata_ = other.metadata_;
	interpretor_ = unique_ptr<NetcdfInterpretor>(other.interpretor_->clone());
	
} 


bool NetcdfDecoderAttributes::accept(const string& node)
{	
	
	if ( magCompare(node, "netcdf")  )
		return true;
	if ( acceptNode(node, interpretor_) )
		return true;
	
	return false;
}

void NetcdfDecoderAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "netcdf")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		setMember(node.name(), interpretor_, node);
		
	}
	for (auto &elt : node.elements())
	{
		setMember(elt->name(), interpretor_, *elt); 
		
	}
}

void NetcdfDecoderAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " metadata = " <<  metadata_;
	out << " interpretor = " <<  *interpretor_;
	
	out << "]" << "\n";
}

void NetcdfDecoderAttributes::toxml(ostream& out)  const
{
	out <<  "\"netcdf\""; 
	out << ", \"netcdf_metadata\":";
	niceprint(out,metadata_);
	out << ", \"netcdf_type\":";
	interpretor_->toxml(out);
	
}

static MagicsParameter<string> netcdf_metadata("netcdf_metadata", "{}", "");
static MagicsParameter<string> netcdf_type("netcdf_type", "guess", ""); 
#include "NetcdfMatrixInterpretor.h"
#include "NetcdfGeopointsInterpretor.h"
#include "NetcdfVectorInterpretor.h"
#include "NetcdfGeoMatrixInterpretor.h"
#include "NetcdfOrcaInterpretor.h"
#include "NetcdfInterpretor.h"
static SimpleObjectMaker<NetcdfGuessInterpretor , NetcdfInterpretor> guess_NetcdfGuessInterpretor("guess");
static SimpleObjectMaker<NetcdfMatrixInterpretor , NetcdfInterpretor> matrix_NetcdfMatrixInterpretor("matrix");
static SimpleObjectMaker<NetcdfGeoMatrixInterpretor , NetcdfInterpretor> geomatrix_NetcdfGeoMatrixInterpretor("geomatrix");
static SimpleObjectMaker<NetcdfVectorInterpretor , NetcdfInterpretor> vector_NetcdfVectorInterpretor("vector");
static SimpleObjectMaker<NetcdfGeoVectorInterpretor , NetcdfInterpretor> geovector_NetcdfGeoVectorInterpretor("geovector");
static SimpleObjectMaker<NetcdfGeoPolarMatrixInterpretor , NetcdfInterpretor> geopolarmatrix_NetcdfGeoPolarMatrixInterpretor("geopolarmatrix");
static SimpleObjectMaker<NetcdfGeopointsInterpretor , NetcdfInterpretor> geopoint_NetcdfGeopointsInterpretor("geopoint");
static SimpleObjectMaker<NetcdfXYpointsInterpretor , NetcdfInterpretor> xypoint_NetcdfXYpointsInterpretor("xypoint");
static SimpleObjectMaker<NetcdfOrcaInterpretor , NetcdfInterpretor> complex_matrix_NetcdfOrcaInterpretor("complex_matrix");
