
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file MetaDataAttributes.h
    \\brief Definition of MetaData Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 2020-10-14
*/

#include "MetaDataAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

MetaDataAttributes::MetaDataAttributes():
	path_(ParameterManager::getString("metadata_path")),
	javascript_(ParameterManager::getString("javascript_path")),
	profile_(ParameterManager::getString("profile_path")),
	world_file_(ParameterManager::getString("world_file_path")),
	wms_file_(ParameterManager::getString("metadata_wms_file")),
	efi_(ParameterManager::getString("efi_path")),
	efi_template_(ParameterManager::getString("efi_template"))
	
	 
{
} 


MetaDataAttributes::~MetaDataAttributes()
{
	
}

    
void MetaDataAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	int i = 0;
	prefix[i++] = "metadata";
	
	setAttribute(prefix, "metadata_path", path_, params);
	setAttribute(prefix, "javascript_path", javascript_, params);
	setAttribute(prefix, "profile_path", profile_, params);
	setAttribute(prefix, "world_file_path", world_file_, params);
	setAttribute(prefix, "metadata_wms_file", wms_file_, params);
	setAttribute(prefix, "efi_path", efi_, params);
	setAttribute(prefix, "efi_template", efi_template_, params);
	
	
}

void MetaDataAttributes::copy(const MetaDataAttributes& other)
{
	path_ = other.path_;
	javascript_ = other.javascript_;
	profile_ = other.profile_;
	world_file_ = other.world_file_;
	wms_file_ = other.wms_file_;
	efi_ = other.efi_;
	efi_template_ = other.efi_template_;
	
} 


bool MetaDataAttributes::accept(const string& node)
{	
	
	if ( magCompare(node, "meta")  )
		return true;
	
	return false;
}

void MetaDataAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "meta")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		
	}
	for (auto &elt : node.elements())
	{
		
	}
}

void MetaDataAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " path = " <<  path_;
	out << " javascript = " <<  javascript_;
	out << " profile = " <<  profile_;
	out << " world_file = " <<  world_file_;
	out << " wms_file = " <<  wms_file_;
	out << " efi = " <<  efi_;
	out << " efi_template = " <<  efi_template_;
	
	out << "]" << "\n";
}

void MetaDataAttributes::toxml(ostream& out)  const
{
	out <<  "\"meta\""; 
	out << ", \"metadata_path\":";
	niceprint(out,path_);
	out << ", \"javascript_path\":";
	niceprint(out,javascript_);
	out << ", \"profile_path\":";
	niceprint(out,profile_);
	out << ", \"world_file_path\":";
	niceprint(out,world_file_);
	out << ", \"metadata_wms_file\":";
	niceprint(out,wms_file_);
	out << ", \"efi_path\":";
	niceprint(out,efi_);
	out << ", \"efi_template\":";
	niceprint(out,efi_template_);
	
}

static MagicsParameter<string> metadata_path("metadata_path", "", "");
static MagicsParameter<string> javascript_path("javascript_path", "", "");
static MagicsParameter<string> profile_path("profile_path", "", "");
static MagicsParameter<string> world_file_path("world_file_path", "", "");
static MagicsParameter<string> metadata_wms_file("metadata_wms_file", "", "");
static MagicsParameter<string> efi_path("efi_path", "", "");
static MagicsParameter<string> efi_template("efi_template", "efi_template.js", "");
