
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file InputMatrixRegularInterpretorAttributes.h
    \\brief Definition of InputMatrixRegularInterpretor Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 2020-10-14
*/

#include "InputMatrixRegularInterpretorAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

InputMatrixRegularInterpretorAttributes::InputMatrixRegularInterpretorAttributes():
	latitude_(ParameterManager::getDouble("input_field_initial_latitude")),
	latitudes_(ParameterManager::getDoubleArray("input_latitudes_list")),
	longitudes_(ParameterManager::getDoubleArray("input_longitudes_list")),
	longitude_(ParameterManager::getDouble("input_field_initial_longitude")),
	latitude_step_(ParameterManager::getDouble("input_field_latitude_step")),
	longitude_step_(ParameterManager::getDouble("input_field_longitude_step")),
	y_first_(ParameterManager::getDouble("input_field_initial_y")),
	x_last_(ParameterManager::getDouble("input_field_final_x")),
	y_last_(ParameterManager::getDouble("input_field_final_y")),
	x_coords_(ParameterManager::getDoubleArray("input_field_x_list")),
	y_coords_(ParameterManager::getDoubleArray("input_field_y_list")),
	x_first_(ParameterManager::getDouble("input_field_initial_x")),
	y_first_date_(ParameterManager::getString("input_field_initial_y_date")),
	x_last_date_(ParameterManager::getString("input_field_final_x_date")),
	y_last_date_(ParameterManager::getString("input_field_final_y_date")),
	x_first_date_(ParameterManager::getString("input_field_initial_x_date")),
	y_step_(ParameterManager::getDouble("input_field_y_step")),
	x_step_(ParameterManager::getDouble("input_field_x_step"))
	
	 
{
} 


InputMatrixRegularInterpretorAttributes::~InputMatrixRegularInterpretorAttributes()
{
	
}

    
void InputMatrixRegularInterpretorAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	int i = 0;
	prefix[i++] = "";
	
	setAttribute(prefix, "input_field_initial_latitude", latitude_, params);
	setAttribute(prefix, "input_latitudes_list", latitudes_, params);
	setAttribute(prefix, "input_longitudes_list", longitudes_, params);
	setAttribute(prefix, "input_field_initial_longitude", longitude_, params);
	setAttribute(prefix, "input_field_latitude_step", latitude_step_, params);
	setAttribute(prefix, "input_field_longitude_step", longitude_step_, params);
	setAttribute(prefix, "input_field_initial_y", y_first_, params);
	setAttribute(prefix, "input_field_final_x", x_last_, params);
	setAttribute(prefix, "input_field_final_y", y_last_, params);
	setAttribute(prefix, "input_field_x_list", x_coords_, params);
	setAttribute(prefix, "input_field_y_list", y_coords_, params);
	setAttribute(prefix, "input_field_initial_x", x_first_, params);
	setAttribute(prefix, "input_field_initial_y_date", y_first_date_, params);
	setAttribute(prefix, "input_field_final_x_date", x_last_date_, params);
	setAttribute(prefix, "input_field_final_y_date", y_last_date_, params);
	setAttribute(prefix, "input_field_initial_x_date", x_first_date_, params);
	setAttribute(prefix, "input_field_y_step", y_step_, params);
	setAttribute(prefix, "input_field_x_step", x_step_, params);
	
	
}

void InputMatrixRegularInterpretorAttributes::copy(const InputMatrixRegularInterpretorAttributes& other)
{
	latitude_ = other.latitude_;
	latitudes_ = other.latitudes_;
	longitudes_ = other.longitudes_;
	longitude_ = other.longitude_;
	latitude_step_ = other.latitude_step_;
	longitude_step_ = other.longitude_step_;
	y_first_ = other.y_first_;
	x_last_ = other.x_last_;
	y_last_ = other.y_last_;
	x_coords_ = other.x_coords_;
	y_coords_ = other.y_coords_;
	x_first_ = other.x_first_;
	y_first_date_ = other.y_first_date_;
	x_last_date_ = other.x_last_date_;
	y_last_date_ = other.y_last_date_;
	x_first_date_ = other.x_first_date_;
	y_step_ = other.y_step_;
	x_step_ = other.x_step_;
	
} 


bool InputMatrixRegularInterpretorAttributes::accept(const string& node)
{	
	
	if ( magCompare(node, "")  )
		return true;
	
	return false;
}

void InputMatrixRegularInterpretorAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		
	}
	for (auto &elt : node.elements())
	{
		
	}
}

void InputMatrixRegularInterpretorAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " latitude = " <<  latitude_;
	out << " latitudes = " <<  latitudes_;
	out << " longitudes = " <<  longitudes_;
	out << " longitude = " <<  longitude_;
	out << " latitude_step = " <<  latitude_step_;
	out << " longitude_step = " <<  longitude_step_;
	out << " y_first = " <<  y_first_;
	out << " x_last = " <<  x_last_;
	out << " y_last = " <<  y_last_;
	out << " x_coords = " <<  x_coords_;
	out << " y_coords = " <<  y_coords_;
	out << " x_first = " <<  x_first_;
	out << " y_first_date = " <<  y_first_date_;
	out << " x_last_date = " <<  x_last_date_;
	out << " y_last_date = " <<  y_last_date_;
	out << " x_first_date = " <<  x_first_date_;
	out << " y_step = " <<  y_step_;
	out << " x_step = " <<  x_step_;
	
	out << "]" << "\n";
}

void InputMatrixRegularInterpretorAttributes::toxml(ostream& out)  const
{
	out <<  "\"\""; 
	out << ", \"input_field_initial_latitude\":";
	niceprint(out,latitude_);
	out << ", \"input_latitudes_list\":";
	niceprint(out,latitudes_);
	out << ", \"input_longitudes_list\":";
	niceprint(out,longitudes_);
	out << ", \"input_field_initial_longitude\":";
	niceprint(out,longitude_);
	out << ", \"input_field_latitude_step\":";
	niceprint(out,latitude_step_);
	out << ", \"input_field_longitude_step\":";
	niceprint(out,longitude_step_);
	out << ", \"input_field_initial_y\":";
	niceprint(out,y_first_);
	out << ", \"input_field_final_x\":";
	niceprint(out,x_last_);
	out << ", \"input_field_final_y\":";
	niceprint(out,y_last_);
	out << ", \"input_field_x_list\":";
	niceprint(out,x_coords_);
	out << ", \"input_field_y_list\":";
	niceprint(out,y_coords_);
	out << ", \"input_field_initial_x\":";
	niceprint(out,x_first_);
	out << ", \"input_field_initial_y_date\":";
	niceprint(out,y_first_date_);
	out << ", \"input_field_final_x_date\":";
	niceprint(out,x_last_date_);
	out << ", \"input_field_final_y_date\":";
	niceprint(out,y_last_date_);
	out << ", \"input_field_initial_x_date\":";
	niceprint(out,x_first_date_);
	out << ", \"input_field_y_step\":";
	niceprint(out,y_step_);
	out << ", \"input_field_x_step\":";
	niceprint(out,x_step_);
	
}

static MagicsParameter<double> input_field_initial_latitude("input_field_initial_latitude", 90, "");
static MagicsParameter<doublearray> input_latitudes_list("input_latitudes_list", floatarray(), "");
static MagicsParameter<doublearray> input_longitudes_list("input_longitudes_list", floatarray(), "");
static MagicsParameter<double> input_field_initial_longitude("input_field_initial_longitude", 0, "");
static MagicsParameter<double> input_field_latitude_step("input_field_latitude_step", -1.5, "");
static MagicsParameter<double> input_field_longitude_step("input_field_longitude_step", 1.5, "");
static MagicsParameter<double> input_field_initial_y("input_field_initial_y", 0, "");
static MagicsParameter<double> input_field_final_x("input_field_final_x", 100, "");
static MagicsParameter<double> input_field_final_y("input_field_final_y", 100, "");
static MagicsParameter<doublearray> input_field_x_list("input_field_x_list", floatarray(), "");
static MagicsParameter<doublearray> input_field_y_list("input_field_y_list", floatarray(), "");
static MagicsParameter<double> input_field_initial_x("input_field_initial_x", 0, "");
static MagicsParameter<string> input_field_initial_y_date("input_field_initial_y_date", "", "");
static MagicsParameter<string> input_field_final_x_date("input_field_final_x_date", "", "");
static MagicsParameter<string> input_field_final_y_date("input_field_final_y_date", "", "");
static MagicsParameter<string> input_field_initial_x_date("input_field_initial_x_date", "", "");
static MagicsParameter<double> input_field_y_step("input_field_y_step", 1, "");
static MagicsParameter<double> input_field_x_step("input_field_x_step", 1, "");
