
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file InputMatrixIrregularInterpretorAttributes.h
    \\brief Definition of InputMatrixIrregularInterpretor Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 2020-10-14
*/

#include "InputMatrixIrregularInterpretorAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

InputMatrixIrregularInterpretorAttributes::InputMatrixIrregularInterpretorAttributes():
	
	latitudes_(MagTranslator<Matrix, Matrix>().magics("input_field_latitudes")),
	longitudes_(MagTranslator<Matrix, Matrix>().magics("input_field_longitudes")),
	y_(MagTranslator<Matrix, Matrix>().magics("input_field_y_coordinates")),
	x_(MagTranslator<Matrix, Matrix>().magics("input_field_x_coordinates"))
	 
{
} 


InputMatrixIrregularInterpretorAttributes::~InputMatrixIrregularInterpretorAttributes()
{
	
}

    
void InputMatrixIrregularInterpretorAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	int i = 0;
	prefix[i++] = "";
	
	
	setAttribute(prefix, "input_field_latitudes", latitudes_, params);
	setAttribute(prefix, "input_field_longitudes", longitudes_, params);
	setAttribute(prefix, "input_field_y_coordinates", y_, params);
	setAttribute(prefix, "input_field_x_coordinates", x_, params);
	
}

void InputMatrixIrregularInterpretorAttributes::copy(const InputMatrixIrregularInterpretorAttributes& other)
{
	latitudes_ = other.latitudes_;
	longitudes_ = other.longitudes_;
	y_ = other.y_;
	x_ = other.x_;
	
} 


bool InputMatrixIrregularInterpretorAttributes::accept(const string& node)
{	
	
	if ( magCompare(node, "")  )
		return true;
	
	return false;
}

void InputMatrixIrregularInterpretorAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		
	}
	for (auto &elt : node.elements())
	{
		
	}
}

void InputMatrixIrregularInterpretorAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " latitudes = " <<  latitudes_;
	out << " longitudes = " <<  longitudes_;
	out << " y = " <<  y_;
	out << " x = " <<  x_;
	
	out << "]" << "\n";
}

void InputMatrixIrregularInterpretorAttributes::toxml(ostream& out)  const
{
	out <<  "\"\""; 
	out << ", \"input_field_latitudes\":";
	niceprint(out, latitudes_);
	out << ", \"input_field_longitudes\":";
	niceprint(out, longitudes_);
	out << ", \"input_field_y_coordinates\":";
	niceprint(out, y_);
	out << ", \"input_field_x_coordinates\":";
	niceprint(out, x_);
	
}

static MagicsParameter<Matrix> input_field_latitudes("input_field_latitudes", Matrix(), ""); 
static MagicsParameter<Matrix> input_field_longitudes("input_field_longitudes", Matrix(), ""); 
static MagicsParameter<Matrix> input_field_y_coordinates("input_field_y_coordinates", Matrix(), ""); 
static MagicsParameter<Matrix> input_field_x_coordinates("input_field_x_coordinates", Matrix(), ""); 
