
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file ImageCalculateColourTechniqueAttributes.h
    \\brief Definition of ImageCalculateColourTechnique Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 2020-10-14
*/

#include "ImageCalculateColourTechniqueAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

ImageCalculateColourTechniqueAttributes::ImageCalculateColourTechniqueAttributes():
	direction_(ParameterManager::getString("image_colour_direction"))
	,
	max_(MagTranslator<string, Colour>().magics("image_max_level_colour")),
	min_(MagTranslator<string, Colour>().magics("image_min_level_colour"))
	 
{
} 


ImageCalculateColourTechniqueAttributes::~ImageCalculateColourTechniqueAttributes()
{
	
}

    
void ImageCalculateColourTechniqueAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	int i = 0;
	prefix[i++] = "image";
	
	setAttribute(prefix, "image_colour_direction", direction_, params);
	
	setMember(prefix, "image_max_level_colour", max_, params);
	setMember(prefix, "image_min_level_colour", min_, params);
	
}

void ImageCalculateColourTechniqueAttributes::copy(const ImageCalculateColourTechniqueAttributes& other)
{
	direction_ = other.direction_;
	max_ = unique_ptr<Colour>(other.max_->clone());
	min_ = unique_ptr<Colour>(other.min_->clone());
	
} 


bool ImageCalculateColourTechniqueAttributes::accept(const string& node)
{	
	
	if ( magCompare(node, "lut_computed")  )
		return true;
	
	return false;
}

void ImageCalculateColourTechniqueAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "lut_computed")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		
	}
	for (auto &elt : node.elements())
	{
		
	}
}

void ImageCalculateColourTechniqueAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " direction = " <<  direction_;
	out << " max = " <<  *max_;
	out << " min = " <<  *min_;
	
	out << "]" << "\n";
}

void ImageCalculateColourTechniqueAttributes::toxml(ostream& out)  const
{
	out <<  "\"lut_computed\""; 
	out << ", \"image_colour_direction\":";
	niceprint(out,direction_);
	out << ", \"image_max_level_colour\":";
	niceprint(out, *max_);
	out << ", \"image_min_level_colour\":";
	niceprint(out, *min_);
	
}

static MagicsParameter<string> image_colour_direction("image_colour_direction", "anti_clockwise", "");
static MagicsParameter<string> image_max_level_colour("image_max_level_colour", "blue", ""); 
static MagicsParameter<string> image_min_level_colour("image_min_level_colour", "red", ""); 
