
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file DotPolyShadingMethodAttributes.h
    \\brief Definition of DotPolyShadingMethod Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 2020-10-14
*/

#include "DotPolyShadingMethodAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

DotPolyShadingMethodAttributes::DotPolyShadingMethodAttributes():
	size_(ParameterManager::getDouble("contour_shade_dot_size")),
	max_density_(ParameterManager::getDouble("contour_shade_max_level_density")),
	min_density_(ParameterManager::getDouble("contour_shade_min_level_density"))
	
	 
{
} 


DotPolyShadingMethodAttributes::~DotPolyShadingMethodAttributes()
{
	
}

    
void DotPolyShadingMethodAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(5);
	int i = 0;
	prefix[i++] = "contour";
	prefix[i++] = "contour";
	prefix[i++] = "contour_shade";
	prefix[i++] = "contour_shade";
	prefix[i++] = "contour_shade";
	
	setAttribute(prefix, "contour_shade_dot_size", size_, params);
	setAttribute(prefix, "contour_shade_max_level_density", max_density_, params);
	setAttribute(prefix, "contour_shade_min_level_density", min_density_, params);
	
	
}

void DotPolyShadingMethodAttributes::copy(const DotPolyShadingMethodAttributes& other)
{
	size_ = other.size_;
	max_density_ = other.max_density_;
	min_density_ = other.min_density_;
	
} 


bool DotPolyShadingMethodAttributes::accept(const string& node)
{	
	
	if ( magCompare(node, "dot")  )
		return true;
	
	return false;
}

void DotPolyShadingMethodAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "dot")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		
	}
	for (auto &elt : node.elements())
	{
		
	}
}

void DotPolyShadingMethodAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " size = " <<  size_;
	out << " max_density = " <<  max_density_;
	out << " min_density = " <<  min_density_;
	
	out << "]" << "\n";
}

void DotPolyShadingMethodAttributes::toxml(ostream& out)  const
{
	out <<  "\"dot\""; 
	out << ", \"contour_shade_dot_size\":";
	niceprint(out,size_);
	out << ", \"contour_shade_max_level_density\":";
	niceprint(out,max_density_);
	out << ", \"contour_shade_min_level_density\":";
	niceprint(out,min_density_);
	
}

static MagicsParameter<double> contour_shade_dot_size("contour_shade_dot_size", 0.02, "");
static MagicsParameter<double> contour_shade_max_level_density("contour_shade_max_level_density", 50.0, "");
static MagicsParameter<double> contour_shade_min_level_density("contour_shade_min_level_density", 1.0, "");
