
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file DateAxisMethodAttributes.h
    \\brief Definition of DateAxisMethod Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 2020-10-14
*/

#include "DateAxisMethodAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

DateAxisMethodAttributes::DateAxisMethodAttributes():
	method_(ParameterManager::getString("axis_date_type")),
	years_(ParameterManager::getBool("axis_years_label")),
	year_font_(ParameterManager::getString("axis_years_label_font")),
	year_font_style_(ParameterManager::getString("axis_years_label_font_style")),
	year_height_(ParameterManager::getDouble("axis_years_label_height")),
	months_(ParameterManager::getBool("axis_months_label")),
	month_composition_(ParameterManager::getString("axis_months_label_composition")),
	month_font_(ParameterManager::getString("axis_months_label_font")),
	month_font_style_(ParameterManager::getString("axis_months_label_font_style")),
	month_height_(ParameterManager::getDouble("axis_months_label_height")),
	days_(ParameterManager::getString("axis_days_label")),
	day_composition_(ParameterManager::getString("axis_days_label_composition")),
	day_position_(ParameterManager::getInt("axis_days_label_position")),
	day_font_(ParameterManager::getString("axis_days_label_font")),
	day_font_style_(ParameterManager::getString("axis_days_label_font_style")),
	day_height_(ParameterManager::getDouble("axis_days_label_height")),
	hours_(ParameterManager::getBool("axis_hours_label")),
	hour_font_(ParameterManager::getString("axis_hours_label_font")),
	hour_font_style_(ParameterManager::getString("axis_hours_label_font_style")),
	hour_height_(ParameterManager::getDouble("axis_hours_label_height"))
	,
	year_colour_(MagTranslator<string, Colour>().magics("axis_years_label_colour")),
	month_colour_(MagTranslator<string, Colour>().magics("axis_months_label_colour")),
	day_colour_(MagTranslator<string, Colour>().magics("axis_days_label_colour")),
	sunday_colour_(MagTranslator<string, Colour>().magics("axis_days_sunday_label_colour")),
	hour_colour_(MagTranslator<string, Colour>().magics("axis_hours_label_colour"))
	 
{
} 


DateAxisMethodAttributes::~DateAxisMethodAttributes()
{
	
}

    
void DateAxisMethodAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(2);
	int i = 0;
	prefix[i++] = "axis";
	prefix[i++] = "axis_date";
	
	setAttribute(prefix, "axis_date_type", method_, params);
	setAttribute(prefix, "axis_years_label", years_, params);
	setAttribute(prefix, "axis_years_label_font", year_font_, params);
	setAttribute(prefix, "axis_years_label_font_style", year_font_style_, params);
	setAttribute(prefix, "axis_years_label_height", year_height_, params);
	setAttribute(prefix, "axis_months_label", months_, params);
	setAttribute(prefix, "axis_months_label_composition", month_composition_, params);
	setAttribute(prefix, "axis_months_label_font", month_font_, params);
	setAttribute(prefix, "axis_months_label_font_style", month_font_style_, params);
	setAttribute(prefix, "axis_months_label_height", month_height_, params);
	setAttribute(prefix, "axis_days_label", days_, params);
	setAttribute(prefix, "axis_days_label_composition", day_composition_, params);
	setAttribute(prefix, "axis_days_label_position", day_position_, params);
	setAttribute(prefix, "axis_days_label_font", day_font_, params);
	setAttribute(prefix, "axis_days_label_font_style", day_font_style_, params);
	setAttribute(prefix, "axis_days_label_height", day_height_, params);
	setAttribute(prefix, "axis_hours_label", hours_, params);
	setAttribute(prefix, "axis_hours_label_font", hour_font_, params);
	setAttribute(prefix, "axis_hours_label_font_style", hour_font_style_, params);
	setAttribute(prefix, "axis_hours_label_height", hour_height_, params);
	
	setMember(prefix, "axis_years_label_colour", year_colour_, params);
	setMember(prefix, "axis_months_label_colour", month_colour_, params);
	setMember(prefix, "axis_days_label_colour", day_colour_, params);
	setMember(prefix, "axis_days_sunday_label_colour", sunday_colour_, params);
	setMember(prefix, "axis_hours_label_colour", hour_colour_, params);
	
}

void DateAxisMethodAttributes::copy(const DateAxisMethodAttributes& other)
{
	method_ = other.method_;
	years_ = other.years_;
	year_font_ = other.year_font_;
	year_font_style_ = other.year_font_style_;
	year_height_ = other.year_height_;
	months_ = other.months_;
	month_composition_ = other.month_composition_;
	month_font_ = other.month_font_;
	month_font_style_ = other.month_font_style_;
	month_height_ = other.month_height_;
	days_ = other.days_;
	day_composition_ = other.day_composition_;
	day_position_ = other.day_position_;
	day_font_ = other.day_font_;
	day_font_style_ = other.day_font_style_;
	day_height_ = other.day_height_;
	hours_ = other.hours_;
	hour_font_ = other.hour_font_;
	hour_font_style_ = other.hour_font_style_;
	hour_height_ = other.hour_height_;
	year_colour_ = unique_ptr<Colour>(other.year_colour_->clone());
	month_colour_ = unique_ptr<Colour>(other.month_colour_->clone());
	day_colour_ = unique_ptr<Colour>(other.day_colour_->clone());
	sunday_colour_ = unique_ptr<Colour>(other.sunday_colour_->clone());
	hour_colour_ = unique_ptr<Colour>(other.hour_colour_->clone());
	
} 


bool DateAxisMethodAttributes::accept(const string& node)
{	
	
	if ( magCompare(node, "date")  )
		return true;
	
	return false;
}

void DateAxisMethodAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "date")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		
	}
	for (auto &elt : node.elements())
	{
		
	}
}

void DateAxisMethodAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " method = " <<  method_;
	out << " years = " <<  years_;
	out << " year_font = " <<  year_font_;
	out << " year_font_style = " <<  year_font_style_;
	out << " year_height = " <<  year_height_;
	out << " months = " <<  months_;
	out << " month_composition = " <<  month_composition_;
	out << " month_font = " <<  month_font_;
	out << " month_font_style = " <<  month_font_style_;
	out << " month_height = " <<  month_height_;
	out << " days = " <<  days_;
	out << " day_composition = " <<  day_composition_;
	out << " day_position = " <<  day_position_;
	out << " day_font = " <<  day_font_;
	out << " day_font_style = " <<  day_font_style_;
	out << " day_height = " <<  day_height_;
	out << " hours = " <<  hours_;
	out << " hour_font = " <<  hour_font_;
	out << " hour_font_style = " <<  hour_font_style_;
	out << " hour_height = " <<  hour_height_;
	out << " year_colour = " <<  *year_colour_;
	out << " month_colour = " <<  *month_colour_;
	out << " day_colour = " <<  *day_colour_;
	out << " sunday_colour = " <<  *sunday_colour_;
	out << " hour_colour = " <<  *hour_colour_;
	
	out << "]" << "\n";
}

void DateAxisMethodAttributes::toxml(ostream& out)  const
{
	out <<  "\"date\""; 
	out << ", \"axis_date_type\":";
	niceprint(out,method_);
	out << ", \"axis_years_label\":";
	niceprint(out,years_);
	out << ", \"axis_years_label_font\":";
	niceprint(out,year_font_);
	out << ", \"axis_years_label_font_style\":";
	niceprint(out,year_font_style_);
	out << ", \"axis_years_label_height\":";
	niceprint(out,year_height_);
	out << ", \"axis_months_label\":";
	niceprint(out,months_);
	out << ", \"axis_months_label_composition\":";
	niceprint(out,month_composition_);
	out << ", \"axis_months_label_font\":";
	niceprint(out,month_font_);
	out << ", \"axis_months_label_font_style\":";
	niceprint(out,month_font_style_);
	out << ", \"axis_months_label_height\":";
	niceprint(out,month_height_);
	out << ", \"axis_days_label\":";
	niceprint(out,days_);
	out << ", \"axis_days_label_composition\":";
	niceprint(out,day_composition_);
	out << ", \"axis_days_label_position\":";
	niceprint(out,day_position_);
	out << ", \"axis_days_label_font\":";
	niceprint(out,day_font_);
	out << ", \"axis_days_label_font_style\":";
	niceprint(out,day_font_style_);
	out << ", \"axis_days_label_height\":";
	niceprint(out,day_height_);
	out << ", \"axis_hours_label\":";
	niceprint(out,hours_);
	out << ", \"axis_hours_label_font\":";
	niceprint(out,hour_font_);
	out << ", \"axis_hours_label_font_style\":";
	niceprint(out,hour_font_style_);
	out << ", \"axis_hours_label_height\":";
	niceprint(out,hour_height_);
	out << ", \"axis_years_label_colour\":";
	niceprint(out, *year_colour_);
	out << ", \"axis_months_label_colour\":";
	niceprint(out, *month_colour_);
	out << ", \"axis_days_label_colour\":";
	niceprint(out, *day_colour_);
	out << ", \"axis_days_sunday_label_colour\":";
	niceprint(out, *sunday_colour_);
	out << ", \"axis_hours_label_colour\":";
	niceprint(out, *hour_colour_);
	
}

static MagicsParameter<string> axis_date_type("axis_date_type", "days", "");
static MagicsParameter<string> axis_years_label("axis_years_label", "on", "");
static MagicsParameter<string> axis_years_label_font("axis_years_label_font", "sansserif", "");
static MagicsParameter<string> axis_years_label_font_style("axis_years_label_font_style", "normal", "");
static MagicsParameter<double> axis_years_label_height("axis_years_label_height", 0.2, "");
static MagicsParameter<string> axis_months_label("axis_months_label", "on", "");
static MagicsParameter<string> axis_months_label_composition("axis_months_label_composition", "three", "");
static MagicsParameter<string> axis_months_label_font("axis_months_label_font", "sansserif", "");
static MagicsParameter<string> axis_months_label_font_style("axis_months_label_font_style", "normal", "");
static MagicsParameter<double> axis_months_label_height("axis_months_label_height", 0.2, "");
static MagicsParameter<string> axis_days_label("axis_days_label", "both", "");
static MagicsParameter<string> axis_days_label_composition("axis_days_label_composition", "three", "");
static MagicsParameter<int> axis_days_label_position("axis_days_label_position", 12, "");
static MagicsParameter<string> axis_days_label_font("axis_days_label_font", "sansserif", "");
static MagicsParameter<string> axis_days_label_font_style("axis_days_label_font_style", "normal", "");
static MagicsParameter<double> axis_days_label_height("axis_days_label_height", 0.2, "");
static MagicsParameter<string> axis_hours_label("axis_hours_label", "off", "");
static MagicsParameter<string> axis_hours_label_font("axis_hours_label_font", "sansserif", "");
static MagicsParameter<string> axis_hours_label_font_style("axis_hours_label_font_style", "normal", "");
static MagicsParameter<double> axis_hours_label_height("axis_hours_label_height", 0.2, "");
static MagicsParameter<string> axis_years_label_colour("axis_years_label_colour", "automatic", ""); 
static MagicsParameter<string> axis_months_label_colour("axis_months_label_colour", "automatic", ""); 
static MagicsParameter<string> axis_days_label_colour("axis_days_label_colour", "black", ""); 
static MagicsParameter<string> axis_days_sunday_label_colour("axis_days_sunday_label_colour", "red", ""); 
static MagicsParameter<string> axis_hours_label_colour("axis_hours_label_colour", "black", ""); 
