
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file CurveAttributes.h
    \\brief Definition of Curve Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 2020-10-14
*/

#include "CurveAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

CurveAttributes::CurveAttributes():
	line_(ParameterManager::getBool("graph_line")),
	thickness_(ParameterManager::getInt("graph_line_thickness")),
	symbol_(ParameterManager::getBool("graph_symbol")),
	symbol_marker_(ParameterManager::getInt("graph_symbol_marker_index")),
	symbol_height_(ParameterManager::getDouble("graph_symbol_height")),
	outline_(ParameterManager::getBool("graph_symbol_outline")),
	outline_thickness_(ParameterManager::getInt("graph_symbol_outline_thickness")),
	x_below_(ParameterManager::getDouble("graph_x_suppress_below")),
	x_above_(ParameterManager::getDouble("graph_x_suppress_above")),
	y_below_(ParameterManager::getDouble("graph_y_suppress_below")),
	y_above_(ParameterManager::getDouble("graph_y_suppress_above")),
	missing_mode_(ParameterManager::getString("graph_missing_data_mode")),
	missing_thickness_(ParameterManager::getInt("graph_missing_data_thickness")),
	plot_method_(ParameterManager::getString("graph_curve_method")),
	style_setting_(ParameterManager::getString("graph_style_setting")),
	style_key_(ParameterManager::getString("graph_line_style_variable_name")),
	style_keys_(ParameterManager::getStringArray("graph_line_style_value_list")),
	style_list_(ParameterManager::getStringArray("graph_line_style_list")),
	colour_key_(ParameterManager::getString("graph_colour_variable_name")),
	colour_keys_(ParameterManager::getStringArray("graph_colour_value_list")),
	colour_list_(ParameterManager::getStringArray("graph_colour_list")),
	thickness_key_(ParameterManager::getString("graph_thickness_variable_name")),
	thickness_keys_(ParameterManager::getStringArray("graph_thickness_value_list")),
	thickness_list_(ParameterManager::getIntArray("graph_thickness_list"))
	,
	style_(MagTranslator<string, LineStyle>().magics("graph_line_style")),
	colour_(MagTranslator<string, Colour>().magics("graph_line_colour")),
	symbol_colour_(MagTranslator<string, Colour>().magics("graph_symbol_colour")),
	outline_colour_(MagTranslator<string, Colour>().magics("graph_symbol_outline_colour")),
	outline_style_(MagTranslator<string, LineStyle>().magics("graph_symbol_outline_style")),
	missing_style_(MagTranslator<string, LineStyle>().magics("graph_missing_data_style")),
	missing_colour_(MagTranslator<string, Colour>().magics("graph_missing_data_colour")),
	style_policy_(MagTranslator<string, ListPolicy>().magics("graph_line_style_list_policy")),
	colour_policy_(MagTranslator<string, ListPolicy>().magics("graph_colour_list_policy")),
	thickness_policy_(MagTranslator<string, ListPolicy>().magics("graph_thickness_list_policy"))
	 
{
} 


CurveAttributes::~CurveAttributes()
{
	
}

    
void CurveAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	int i = 0;
	prefix[i++] = "";
	
	setAttribute(prefix, "graph_line", line_, params);
	setAttribute(prefix, "graph_line_thickness", thickness_, params);
	setAttribute(prefix, "graph_symbol", symbol_, params);
	setAttribute(prefix, "graph_symbol_marker_index", symbol_marker_, params);
	setAttribute(prefix, "graph_symbol_height", symbol_height_, params);
	setAttribute(prefix, "graph_symbol_outline", outline_, params);
	setAttribute(prefix, "graph_symbol_outline_thickness", outline_thickness_, params);
	setAttribute(prefix, "graph_x_suppress_below", x_below_, params);
	setAttribute(prefix, "graph_x_suppress_above", x_above_, params);
	setAttribute(prefix, "graph_y_suppress_below", y_below_, params);
	setAttribute(prefix, "graph_y_suppress_above", y_above_, params);
	setAttribute(prefix, "graph_missing_data_mode", missing_mode_, params);
	setAttribute(prefix, "graph_missing_data_thickness", missing_thickness_, params);
	setAttribute(prefix, "graph_curve_method", plot_method_, params);
	setAttribute(prefix, "graph_style_setting", style_setting_, params);
	setAttribute(prefix, "graph_line_style_variable_name", style_key_, params);
	setAttribute(prefix, "graph_line_style_value_list", style_keys_, params);
	setAttribute(prefix, "graph_line_style_list", style_list_, params);
	setAttribute(prefix, "graph_colour_variable_name", colour_key_, params);
	setAttribute(prefix, "graph_colour_value_list", colour_keys_, params);
	setAttribute(prefix, "graph_colour_list", colour_list_, params);
	setAttribute(prefix, "graph_thickness_variable_name", thickness_key_, params);
	setAttribute(prefix, "graph_thickness_value_list", thickness_keys_, params);
	setAttribute(prefix, "graph_thickness_list", thickness_list_, params);
	
	setAttribute(prefix, "graph_line_style", style_, params);
	setMember(prefix, "graph_line_colour", colour_, params);
	setMember(prefix, "graph_symbol_colour", symbol_colour_, params);
	setMember(prefix, "graph_symbol_outline_colour", outline_colour_, params);
	setAttribute(prefix, "graph_symbol_outline_style", outline_style_, params);
	setAttribute(prefix, "graph_missing_data_style", missing_style_, params);
	setMember(prefix, "graph_missing_data_colour", missing_colour_, params);
	setAttribute(prefix, "graph_line_style_list_policy", style_policy_, params);
	setAttribute(prefix, "graph_colour_list_policy", colour_policy_, params);
	setAttribute(prefix, "graph_thickness_list_policy", thickness_policy_, params);
	
}

void CurveAttributes::copy(const CurveAttributes& other)
{
	line_ = other.line_;
	thickness_ = other.thickness_;
	symbol_ = other.symbol_;
	symbol_marker_ = other.symbol_marker_;
	symbol_height_ = other.symbol_height_;
	outline_ = other.outline_;
	outline_thickness_ = other.outline_thickness_;
	x_below_ = other.x_below_;
	x_above_ = other.x_above_;
	y_below_ = other.y_below_;
	y_above_ = other.y_above_;
	missing_mode_ = other.missing_mode_;
	missing_thickness_ = other.missing_thickness_;
	plot_method_ = other.plot_method_;
	style_setting_ = other.style_setting_;
	style_key_ = other.style_key_;
	style_keys_ = other.style_keys_;
	style_list_ = other.style_list_;
	colour_key_ = other.colour_key_;
	colour_keys_ = other.colour_keys_;
	colour_list_ = other.colour_list_;
	thickness_key_ = other.thickness_key_;
	thickness_keys_ = other.thickness_keys_;
	thickness_list_ = other.thickness_list_;
	style_ = other.style_;
	colour_ = unique_ptr<Colour>(other.colour_->clone());
	symbol_colour_ = unique_ptr<Colour>(other.symbol_colour_->clone());
	outline_colour_ = unique_ptr<Colour>(other.outline_colour_->clone());
	outline_style_ = other.outline_style_;
	missing_style_ = other.missing_style_;
	missing_colour_ = unique_ptr<Colour>(other.missing_colour_->clone());
	style_policy_ = other.style_policy_;
	colour_policy_ = other.colour_policy_;
	thickness_policy_ = other.thickness_policy_;
	
} 


bool CurveAttributes::accept(const string& node)
{	
	
	if ( magCompare(node, "")  )
		return true;
	
	return false;
}

void CurveAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		
	}
	for (auto &elt : node.elements())
	{
		
	}
}

void CurveAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " line = " <<  line_;
	out << " thickness = " <<  thickness_;
	out << " symbol = " <<  symbol_;
	out << " symbol_marker = " <<  symbol_marker_;
	out << " symbol_height = " <<  symbol_height_;
	out << " outline = " <<  outline_;
	out << " outline_thickness = " <<  outline_thickness_;
	out << " x_below = " <<  x_below_;
	out << " x_above = " <<  x_above_;
	out << " y_below = " <<  y_below_;
	out << " y_above = " <<  y_above_;
	out << " missing_mode = " <<  missing_mode_;
	out << " missing_thickness = " <<  missing_thickness_;
	out << " plot_method = " <<  plot_method_;
	out << " style_setting = " <<  style_setting_;
	out << " style_key = " <<  style_key_;
	out << " style_keys = " <<  style_keys_;
	out << " style_list = " <<  style_list_;
	out << " colour_key = " <<  colour_key_;
	out << " colour_keys = " <<  colour_keys_;
	out << " colour_list = " <<  colour_list_;
	out << " thickness_key = " <<  thickness_key_;
	out << " thickness_keys = " <<  thickness_keys_;
	out << " thickness_list = " <<  thickness_list_;
	out << " style = " <<  style_;
	out << " colour = " <<  *colour_;
	out << " symbol_colour = " <<  *symbol_colour_;
	out << " outline_colour = " <<  *outline_colour_;
	out << " outline_style = " <<  outline_style_;
	out << " missing_style = " <<  missing_style_;
	out << " missing_colour = " <<  *missing_colour_;
	out << " style_policy = " <<  style_policy_;
	out << " colour_policy = " <<  colour_policy_;
	out << " thickness_policy = " <<  thickness_policy_;
	
	out << "]" << "\n";
}

void CurveAttributes::toxml(ostream& out)  const
{
	out <<  "\"\""; 
	out << ", \"graph_line\":";
	niceprint(out,line_);
	out << ", \"graph_line_thickness\":";
	niceprint(out,thickness_);
	out << ", \"graph_symbol\":";
	niceprint(out,symbol_);
	out << ", \"graph_symbol_marker_index\":";
	niceprint(out,symbol_marker_);
	out << ", \"graph_symbol_height\":";
	niceprint(out,symbol_height_);
	out << ", \"graph_symbol_outline\":";
	niceprint(out,outline_);
	out << ", \"graph_symbol_outline_thickness\":";
	niceprint(out,outline_thickness_);
	out << ", \"graph_x_suppress_below\":";
	niceprint(out,x_below_);
	out << ", \"graph_x_suppress_above\":";
	niceprint(out,x_above_);
	out << ", \"graph_y_suppress_below\":";
	niceprint(out,y_below_);
	out << ", \"graph_y_suppress_above\":";
	niceprint(out,y_above_);
	out << ", \"graph_missing_data_mode\":";
	niceprint(out,missing_mode_);
	out << ", \"graph_missing_data_thickness\":";
	niceprint(out,missing_thickness_);
	out << ", \"graph_curve_method\":";
	niceprint(out,plot_method_);
	out << ", \"graph_style_setting\":";
	niceprint(out,style_setting_);
	out << ", \"graph_line_style_variable_name\":";
	niceprint(out,style_key_);
	out << ", \"graph_line_style_value_list\":";
	niceprint(out,style_keys_);
	out << ", \"graph_line_style_list\":";
	niceprint(out,style_list_);
	out << ", \"graph_colour_variable_name\":";
	niceprint(out,colour_key_);
	out << ", \"graph_colour_value_list\":";
	niceprint(out,colour_keys_);
	out << ", \"graph_colour_list\":";
	niceprint(out,colour_list_);
	out << ", \"graph_thickness_variable_name\":";
	niceprint(out,thickness_key_);
	out << ", \"graph_thickness_value_list\":";
	niceprint(out,thickness_keys_);
	out << ", \"graph_thickness_list\":";
	niceprint(out,thickness_list_);
	out << ", \"graph_line_style\":";
	niceprint(out, style_);
	out << ", \"graph_line_colour\":";
	niceprint(out, *colour_);
	out << ", \"graph_symbol_colour\":";
	niceprint(out, *symbol_colour_);
	out << ", \"graph_symbol_outline_colour\":";
	niceprint(out, *outline_colour_);
	out << ", \"graph_symbol_outline_style\":";
	niceprint(out, outline_style_);
	out << ", \"graph_missing_data_style\":";
	niceprint(out, missing_style_);
	out << ", \"graph_missing_data_colour\":";
	niceprint(out, *missing_colour_);
	out << ", \"graph_line_style_list_policy\":";
	niceprint(out, style_policy_);
	out << ", \"graph_colour_list_policy\":";
	niceprint(out, colour_policy_);
	out << ", \"graph_thickness_list_policy\":";
	niceprint(out, thickness_policy_);
	
}

static MagicsParameter<string> graph_line("graph_line", "on", "");
static MagicsParameter<int> graph_line_thickness("graph_line_thickness", 1, "");
static MagicsParameter<string> graph_symbol("graph_symbol", "off", "");
static MagicsParameter<int> graph_symbol_marker_index("graph_symbol_marker_index", 3, "");
static MagicsParameter<double> graph_symbol_height("graph_symbol_height", 0.2, "");
static MagicsParameter<string> graph_symbol_outline("graph_symbol_outline", "off", "");
static MagicsParameter<int> graph_symbol_outline_thickness("graph_symbol_outline_thickness", 1, "");
static MagicsParameter<double> graph_x_suppress_below("graph_x_suppress_below", LLONG_MIN, "");
static MagicsParameter<double> graph_x_suppress_above("graph_x_suppress_above", LLONG_MAX, "");
static MagicsParameter<double> graph_y_suppress_below("graph_y_suppress_below", LLONG_MIN, "");
static MagicsParameter<double> graph_y_suppress_above("graph_y_suppress_above", LLONG_MAX, "");
static MagicsParameter<string> graph_missing_data_mode("graph_missing_data_mode", "ignore", "");
static MagicsParameter<int> graph_missing_data_thickness("graph_missing_data_thickness", 1, "");
static MagicsParameter<string> graph_curve_method("graph_curve_method", "straight", "");
static MagicsParameter<string> graph_style_setting("graph_style_setting", "simple", "");
static MagicsParameter<string> graph_line_style_variable_name("graph_line_style_variable_name", "", "");
static MagicsParameter<stringarray> graph_line_style_value_list("graph_line_style_value_list", stringarray(), "");
static MagicsParameter<stringarray> graph_line_style_list("graph_line_style_list", stringarray(), "");
static MagicsParameter<string> graph_colour_variable_name("graph_colour_variable_name", "", "");
static MagicsParameter<stringarray> graph_colour_value_list("graph_colour_value_list", stringarray(), "");
static MagicsParameter<stringarray> graph_colour_list("graph_colour_list", stringarray(), "");
static MagicsParameter<string> graph_thickness_variable_name("graph_thickness_variable_name", "", "");
static MagicsParameter<stringarray> graph_thickness_value_list("graph_thickness_value_list", stringarray(), "");
static MagicsParameter<intarray> graph_thickness_list("graph_thickness_list", intarray(), "");
static MagicsParameter<string> graph_line_style("graph_line_style", "solid", ""); 
static MagicsParameter<string> graph_line_colour("graph_line_colour", "blue", ""); 
static MagicsParameter<string> graph_symbol_colour("graph_symbol_colour", "red", ""); 
static MagicsParameter<string> graph_symbol_outline_colour("graph_symbol_outline_colour", "black", ""); 
static MagicsParameter<string> graph_symbol_outline_style("graph_symbol_outline_style", "solid", ""); 
static MagicsParameter<string> graph_missing_data_style("graph_missing_data_style", "dash", ""); 
static MagicsParameter<string> graph_missing_data_colour("graph_missing_data_colour", "red", ""); 
static MagicsParameter<string> graph_line_style_list_policy("graph_line_style_list_policy", "lastone", ""); 
static MagicsParameter<string> graph_colour_list_policy("graph_colour_list_policy", "lastone", ""); 
static MagicsParameter<string> graph_thickness_list_policy("graph_thickness_list_policy", "lastone", ""); 
