
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file CellShadingAttributes.h
    \\brief Definition of CellShading Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 2020-10-14
*/

#include "CellShadingAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

CellShadingAttributes::CellShadingAttributes():
	resolution_(ParameterManager::getDouble("contour_shade_cell_resolution")),
	method_(ParameterManager::getString("contour_shade_cell_method")),
	resolution_method_(ParameterManager::getString("contour_shade_cell_resolution_method"))
	
	 
{
} 


CellShadingAttributes::~CellShadingAttributes()
{
	
}

    
void CellShadingAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(4);
	int i = 0;
	prefix[i++] = "contour";
	prefix[i++] = "contour";
	prefix[i++] = "contour_shade";
	prefix[i++] = "contour_shade_cell";
	
	setAttribute(prefix, "contour_shade_cell_resolution", resolution_, params);
	setAttribute(prefix, "contour_shade_cell_method", method_, params);
	setAttribute(prefix, "contour_shade_cell_resolution_method", resolution_method_, params);
	
	
}

void CellShadingAttributes::copy(const CellShadingAttributes& other)
{
	resolution_ = other.resolution_;
	method_ = other.method_;
	resolution_method_ = other.resolution_method_;
	
} 


bool CellShadingAttributes::accept(const string& node)
{	
	
	if ( magCompare(node, "cell_shading")  )
		return true;
	
	return false;
}

void CellShadingAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "cell_shading")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		
	}
	for (auto &elt : node.elements())
	{
		
	}
}

void CellShadingAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " resolution = " <<  resolution_;
	out << " method = " <<  method_;
	out << " resolution_method = " <<  resolution_method_;
	
	out << "]" << "\n";
}

void CellShadingAttributes::toxml(ostream& out)  const
{
	out <<  "\"cell_shading\""; 
	out << ", \"contour_shade_cell_resolution\":";
	niceprint(out,resolution_);
	out << ", \"contour_shade_cell_method\":";
	niceprint(out,method_);
	out << ", \"contour_shade_cell_resolution_method\":";
	niceprint(out,resolution_method_);
	
}

static MagicsParameter<double> contour_shade_cell_resolution("contour_shade_cell_resolution", 10, "");
static MagicsParameter<string> contour_shade_cell_method("contour_shade_cell_method", "nearest", "");
static MagicsParameter<string> contour_shade_cell_resolution_method("contour_shade_cell_resolution_method", "classic", "");
