
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file CdfGraphAttributes.h
    \\brief Definition of CdfGraph Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 2020-10-14
*/

#include "CdfGraphAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

CdfGraphAttributes::CdfGraphAttributes():
	type_(ParameterManager::getString("cdf_graph_type")),
	colour_(ParameterManager::getStringArray("cdf_lines_colour_array")),
	style_(ParameterManager::getStringArray("cdf_lines_style_array")),
	thickness_(ParameterManager::getIntArray("cdf_lines_thickness_array")),
	clim_thickness_(ParameterManager::getInt("cdf_clim_line_thickness")),
	legend_(ParameterManager::getBool("legend"))
	,
	clim_colour_(MagTranslator<string, Colour>().magics("cdf_clim_line_colour")),
	clim_style_(MagTranslator<string, LineStyle>().magics("cdf_clim_line_style"))
	 
{
} 


CdfGraphAttributes::~CdfGraphAttributes()
{
	
}

    
void CdfGraphAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	int i = 0;
	prefix[i++] = "cdf";
	
	setAttribute(prefix, "cdf_graph_type", type_, params);
	setAttribute(prefix, "cdf_lines_colour_array", colour_, params);
	setAttribute(prefix, "cdf_lines_style_array", style_, params);
	setAttribute(prefix, "cdf_lines_thickness_array", thickness_, params);
	setAttribute(prefix, "cdf_clim_line_thickness", clim_thickness_, params);
	setAttribute(prefix, "legend", legend_, params);
	
	setMember(prefix, "cdf_clim_line_colour", clim_colour_, params);
	setAttribute(prefix, "cdf_clim_line_style", clim_style_, params);
	
}

void CdfGraphAttributes::copy(const CdfGraphAttributes& other)
{
	type_ = other.type_;
	colour_ = other.colour_;
	style_ = other.style_;
	thickness_ = other.thickness_;
	clim_thickness_ = other.clim_thickness_;
	legend_ = other.legend_;
	clim_colour_ = unique_ptr<Colour>(other.clim_colour_->clone());
	clim_style_ = other.clim_style_;
	
} 


bool CdfGraphAttributes::accept(const string& node)
{	
	
	if ( magCompare(node, "cdfgraph")  )
		return true;
	
	return false;
}

void CdfGraphAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "cdfgraph")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		
	}
	for (auto &elt : node.elements())
	{
		
	}
}

void CdfGraphAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " type = " <<  type_;
	out << " colour = " <<  colour_;
	out << " style = " <<  style_;
	out << " thickness = " <<  thickness_;
	out << " clim_thickness = " <<  clim_thickness_;
	out << " legend = " <<  legend_;
	out << " clim_colour = " <<  *clim_colour_;
	out << " clim_style = " <<  clim_style_;
	
	out << "]" << "\n";
}

void CdfGraphAttributes::toxml(ostream& out)  const
{
	out <<  "\"cdfgraph\""; 
	out << ", \"cdf_graph_type\":";
	niceprint(out,type_);
	out << ", \"cdf_lines_colour_array\":";
	niceprint(out,colour_);
	out << ", \"cdf_lines_style_array\":";
	niceprint(out,style_);
	out << ", \"cdf_lines_thickness_array\":";
	niceprint(out,thickness_);
	out << ", \"cdf_clim_line_thickness\":";
	niceprint(out,clim_thickness_);
	out << ", \"legend\":";
	niceprint(out,legend_);
	out << ", \"cdf_clim_line_colour\":";
	niceprint(out, *clim_colour_);
	out << ", \"cdf_clim_line_style\":";
	niceprint(out, clim_style_);
	
}

static MagicsParameter<string> cdf_graph_type("cdf_graph_type", "medium", "");
static MagicsParameter<stringarray> cdf_lines_colour_array("cdf_lines_colour_array", stringarray(), "");
static MagicsParameter<stringarray> cdf_lines_style_array("cdf_lines_style_array", stringarray(), "");
static MagicsParameter<intarray> cdf_lines_thickness_array("cdf_lines_thickness_array", intarray(), "");
static MagicsParameter<int> cdf_clim_line_thickness("cdf_clim_line_thickness", 4, "");
static MagicsParameter<string> legend("legend", "off", "");
static MagicsParameter<string> cdf_clim_line_colour("cdf_clim_line_colour", "black", ""); 
static MagicsParameter<string> cdf_clim_line_style("cdf_clim_line_style", "solid", ""); 
