
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file BaseDriverAttributes.h
    \\brief Definition of BaseDriver Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 2020-10-14
*/

#include "BaseDriverAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

BaseDriverAttributes::BaseDriverAttributes():
	title_(ParameterManager::getString("output_title")),
	name_(ParameterManager::getString("output_name")),
	firstnumber_(ParameterManager::getBool("output_name_first_page_number")),
	firstvalue_(ParameterManager::getInt("output_name_first_page_number_value")),
	fullname_(ParameterManager::getString("output_fullname")),
	legacyname_(ParameterManager::getString("output_legacy_name")),
	numberingwidth_(ParameterManager::getInt("output_file_minimal_width")),
	separator_(ParameterManager::getString("output_file_separator")),
	output_creator_(ParameterManager::getString("output_creator")),
	mgb_template_(ParameterManager::getString("output_mgb_template")),
	debug_(ParameterManager::getBool("output_debug")),
	width_(ParameterManager::getInt("output_width")),
	filelist_(ParameterManager::getBool("output_filelist")),
	filelist_name_(ParameterManager::getString("output_filelist_name")),
	filelist_reset_(ParameterManager::getBool("output_filelist_reset")),
	frame_list_(ParameterManager::getIntArray("output_frame_list"))
	
	 
{
} 


BaseDriverAttributes::~BaseDriverAttributes()
{
	
}

    
void BaseDriverAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	int i = 0;
	prefix[i++] = "output";
	
	setAttribute(prefix, "output_title", title_, params);
	setAttribute(prefix, "output_name", name_, params);
	setAttribute(prefix, "output_name_first_page_number", firstnumber_, params);
	setAttribute(prefix, "output_name_first_page_number_value", firstvalue_, params);
	setAttribute(prefix, "output_fullname", fullname_, params);
	setAttribute(prefix, "output_legacy_name", legacyname_, params);
	setAttribute(prefix, "output_file_minimal_width", numberingwidth_, params);
	setAttribute(prefix, "output_file_separator", separator_, params);
	setAttribute(prefix, "output_creator", output_creator_, params);
	setAttribute(prefix, "output_mgb_template", mgb_template_, params);
	setAttribute(prefix, "output_debug", debug_, params);
	setAttribute(prefix, "output_width", width_, params);
	setAttribute(prefix, "output_filelist", filelist_, params);
	setAttribute(prefix, "output_filelist_name", filelist_name_, params);
	setAttribute(prefix, "output_filelist_reset", filelist_reset_, params);
	setAttribute(prefix, "output_frame_list", frame_list_, params);
	
	
}

void BaseDriverAttributes::copy(const BaseDriverAttributes& other)
{
	title_ = other.title_;
	name_ = other.name_;
	firstnumber_ = other.firstnumber_;
	firstvalue_ = other.firstvalue_;
	fullname_ = other.fullname_;
	legacyname_ = other.legacyname_;
	numberingwidth_ = other.numberingwidth_;
	separator_ = other.separator_;
	output_creator_ = other.output_creator_;
	mgb_template_ = other.mgb_template_;
	debug_ = other.debug_;
	width_ = other.width_;
	filelist_ = other.filelist_;
	filelist_name_ = other.filelist_name_;
	filelist_reset_ = other.filelist_reset_;
	frame_list_ = other.frame_list_;
	
} 


bool BaseDriverAttributes::accept(const string& node)
{	
	
	if ( magCompare(node, "driver")  )
		return true;
	
	return false;
}

void BaseDriverAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "driver")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		
	}
	for (auto &elt : node.elements())
	{
		
	}
}

void BaseDriverAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " title = " <<  title_;
	out << " name = " <<  name_;
	out << " firstnumber = " <<  firstnumber_;
	out << " firstvalue = " <<  firstvalue_;
	out << " fullname = " <<  fullname_;
	out << " legacyname = " <<  legacyname_;
	out << " numberingwidth = " <<  numberingwidth_;
	out << " separator = " <<  separator_;
	out << " output_creator = " <<  output_creator_;
	out << " mgb_template = " <<  mgb_template_;
	out << " debug = " <<  debug_;
	out << " width = " <<  width_;
	out << " filelist = " <<  filelist_;
	out << " filelist_name = " <<  filelist_name_;
	out << " filelist_reset = " <<  filelist_reset_;
	out << " frame_list = " <<  frame_list_;
	
	out << "]" << "\n";
}

void BaseDriverAttributes::toxml(ostream& out)  const
{
	out <<  "\"driver\""; 
	out << ", \"output_title\":";
	niceprint(out,title_);
	out << ", \"output_name\":";
	niceprint(out,name_);
	out << ", \"output_name_first_page_number\":";
	niceprint(out,firstnumber_);
	out << ", \"output_name_first_page_number_value\":";
	niceprint(out,firstvalue_);
	out << ", \"output_fullname\":";
	niceprint(out,fullname_);
	out << ", \"output_legacy_name\":";
	niceprint(out,legacyname_);
	out << ", \"output_file_minimal_width\":";
	niceprint(out,numberingwidth_);
	out << ", \"output_file_separator\":";
	niceprint(out,separator_);
	out << ", \"output_creator\":";
	niceprint(out,output_creator_);
	out << ", \"output_mgb_template\":";
	niceprint(out,mgb_template_);
	out << ", \"output_debug\":";
	niceprint(out,debug_);
	out << ", \"output_width\":";
	niceprint(out,width_);
	out << ", \"output_filelist\":";
	niceprint(out,filelist_);
	out << ", \"output_filelist_name\":";
	niceprint(out,filelist_name_);
	out << ", \"output_filelist_reset\":";
	niceprint(out,filelist_reset_);
	out << ", \"output_frame_list\":";
	niceprint(out,frame_list_);
	
}

static MagicsParameter<string> output_title("output_title", "Magics plot", "");
static MagicsParameter<string> output_name("output_name", "", "");
static MagicsParameter<string> output_name_first_page_number("output_name_first_page_number", "on", "");
static MagicsParameter<int> output_name_first_page_number_value("output_name_first_page_number_value", 1, "");
static MagicsParameter<string> output_fullname("output_fullname", "", "");
static MagicsParameter<string> output_legacy_name("output_legacy_name", "", "");
static MagicsParameter<int> output_file_minimal_width("output_file_minimal_width", 1, "");
static MagicsParameter<string> output_file_separator("output_file_separator", ".", "");
static MagicsParameter<string> output_creator("output_creator", "", "");
static MagicsParameter<string> output_mgb_template("output_mgb_template", "", "");
static MagicsParameter<string> output_debug("output_debug", "off", "");
static MagicsParameter<int> output_width("output_width", 800, "");
static MagicsParameter<string> output_filelist("output_filelist", "off", "");
static MagicsParameter<string> output_filelist_name("output_filelist_name", "magics_outputs.lst", "");
static MagicsParameter<string> output_filelist_reset("output_filelist_reset", "off", "");
static MagicsParameter<intarray> output_frame_list("output_frame_list", intarray(), "");
