
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file Akima474MethodAttributes.h
    \\brief Definition of Akima474Method Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 2020-10-14
*/

#include "Akima474MethodAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

Akima474MethodAttributes::Akima474MethodAttributes():
	resolutionX_(ParameterManager::getDouble("contour_akima_x_resolution")),
	resolutionY_(ParameterManager::getDouble("contour_akima_y_resolution"))
	
	 
{
} 


Akima474MethodAttributes::~Akima474MethodAttributes()
{
	
}

    
void Akima474MethodAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	int i = 0;
	prefix[i++] = "akima";
	
	setAttribute(prefix, "contour_akima_x_resolution", resolutionX_, params);
	setAttribute(prefix, "contour_akima_y_resolution", resolutionY_, params);
	
	
}

void Akima474MethodAttributes::copy(const Akima474MethodAttributes& other)
{
	resolutionX_ = other.resolutionX_;
	resolutionY_ = other.resolutionY_;
	
} 


bool Akima474MethodAttributes::accept(const string& node)
{	
	
	if ( magCompare(node, "akima474")  )
		return true;
	
	return false;
}

void Akima474MethodAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "akima474")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		
	}
	for (auto &elt : node.elements())
	{
		
	}
}

void Akima474MethodAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " resolutionX = " <<  resolutionX_;
	out << " resolutionY = " <<  resolutionY_;
	
	out << "]" << "\n";
}

void Akima474MethodAttributes::toxml(ostream& out)  const
{
	out <<  "\"akima474\""; 
	out << ", \"contour_akima_x_resolution\":";
	niceprint(out,resolutionX_);
	out << ", \"contour_akima_y_resolution\":";
	niceprint(out,resolutionY_);
	
}

static MagicsParameter<double> contour_akima_x_resolution("contour_akima_x_resolution", 1.5, "");
static MagicsParameter<double> contour_akima_y_resolution("contour_akima_y_resolution", 1.5, "");
