
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file XDateCoordinateAttributes.h
    \\brief Definition of XDateCoordinate Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 2020-09-24
*/

#include "XDateCoordinateAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

XDateCoordinateAttributes::XDateCoordinateAttributes():
	date_min_(ParameterManager::getString("subpage_x_date_min")),
	date_max_(ParameterManager::getString("subpage_x_date_max")),
	reverse_(ParameterManager::getBool("subpage_x_automatic_reverse"))
	,
	automatic_(MagTranslator<string, AxisAutomaticSetting>().magics("subpage_x_automatic"))
	 
{
} 


XDateCoordinateAttributes::~XDateCoordinateAttributes()
{
	
}

    
void XDateCoordinateAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(3);
	int i = 0;
	prefix[i++] = "subpage";
	prefix[i++] = "subpage_x";
	prefix[i++] = "subpage_x_date";
	
	setAttribute(prefix, "subpage_x_date_min", date_min_, params);
	setAttribute(prefix, "subpage_x_date_max", date_max_, params);
	setAttribute(prefix, "subpage_x_automatic_reverse", reverse_, params);
	
	setAttribute(prefix, "subpage_x_automatic", automatic_, params);
	
}

void XDateCoordinateAttributes::copy(const XDateCoordinateAttributes& other)
{
	date_min_ = other.date_min_;
	date_max_ = other.date_max_;
	reverse_ = other.reverse_;
	automatic_ = other.automatic_;
	
} 


bool XDateCoordinateAttributes::accept(const string& node)
{	
	
	if ( magCompare(node, "x_date")  )
		return true;
	
	return false;
}

void XDateCoordinateAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "x_date")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		
	}
	for (auto &elt : node.elements())
	{
		
	}
}

void XDateCoordinateAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " date_min = " <<  date_min_;
	out << " date_max = " <<  date_max_;
	out << " reverse = " <<  reverse_;
	out << " automatic = " <<  automatic_;
	
	out << "]" << "\n";
}

void XDateCoordinateAttributes::toxml(ostream& out)  const
{
	out <<  "\"x_date\""; 
	out << ", \"subpage_x_date_min\":";
	niceprint(out,date_min_);
	out << ", \"subpage_x_date_max\":";
	niceprint(out,date_max_);
	out << ", \"subpage_x_automatic_reverse\":";
	niceprint(out,reverse_);
	out << ", \"subpage_x_automatic\":";
	niceprint(out, automatic_);
	
}

static MagicsParameter<string> subpage_x_date_min("subpage_x_date_min", "", "");
static MagicsParameter<string> subpage_x_date_max("subpage_x_date_max", "", "");
static MagicsParameter<string> subpage_x_automatic_reverse("subpage_x_automatic_reverse", "off", "");
static MagicsParameter<string> subpage_x_automatic("subpage_x_automatic", "off", ""); 
