
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file SymbolTableModeAttributes.h
    \\brief Definition of SymbolTableMode Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 2020-09-24
*/

#include "MagRequest.h" 
#include "SymbolTableModeWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"

using namespace magics;


SymbolTableModeWrapper::SymbolTableModeWrapper(): symboltablemode_(new SymbolTableMode())

{

	
	
	SymbolModeWrapper::object(symboltablemode_);
	
	
} 
SymbolTableModeWrapper::SymbolTableModeWrapper(SymbolTableMode* symboltablemode): symboltablemode_(symboltablemode)
{
	
	
	SymbolModeWrapper::object(symboltablemode_);
	
} 

SymbolTableModeWrapper::~SymbolTableModeWrapper()
{
	
}

void SymbolTableModeWrapper::set(const MagRequest& request)
{
	
	
	
	SymbolModeWrapper::set(request);
	

	doublearray  min_value;
	for (int i = 0; i < request.countValues("SYMBOL_MIN_TABLE"); i++)
		min_value.push_back((double)request("SYMBOL_MIN_TABLE", i));
	if ( !min_value.empty() ) 
		symboltablemode_->min_ = min_value;
	doublearray  max_value;
	for (int i = 0; i < request.countValues("SYMBOL_MAX_TABLE"); i++)
		max_value.push_back((double)request("SYMBOL_MAX_TABLE", i));
	if ( !max_value.empty() ) 
		symboltablemode_->max_ = max_value;
	intarray marker_value;
	for (int i = 0; i < request.countValues("SYMBOL_MARKER_TABLE"); i++)
		marker_value.push_back((int)request("SYMBOL_MARKER_TABLE", i));
	if ( !marker_value.empty() ) 
		symboltablemode_->marker_ = marker_value;
	stringarray  symbol_value;
	for (int i = 0; i < request.countValues("SYMBOL_NAME_TABLE"); i++)
		symbol_value.push_back((string)request("SYMBOL_NAME_TABLE", i));
	if ( !symbol_value.empty() ) 
		symboltablemode_->symbol_ = symbol_value;
	stringarray  colour_value;
	for (int i = 0; i < request.countValues("SYMBOL_COLOUR_TABLE"); i++)
		colour_value.push_back((string)request("SYMBOL_COLOUR_TABLE", i));
	if ( !colour_value.empty() ) 
		symboltablemode_->colour_ = colour_value;
	doublearray  height_value;
	for (int i = 0; i < request.countValues("SYMBOL_HEIGHT_TABLE"); i++)
		height_value.push_back((double)request("SYMBOL_HEIGHT_TABLE", i));
	if ( !height_value.empty() ) 
		symboltablemode_->height_ = height_value;
	
	
}

void SymbolTableModeWrapper::print(ostream& out)  const
{
	out << "SymbolTableModeWrapper[]";
}


    



