
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file PageIDAttributes.h
    \\brief Definition of PageID Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 2020-09-24
*/

#include "PageIDAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

PageIDAttributes::PageIDAttributes():
	height_(ParameterManager::getDouble("page_id_line_height")),
	magics_(ParameterManager::getBool("page_id_line_magics")),
	user_text_(ParameterManager::getString("page_id_line_user_text")),
	system_(ParameterManager::getBool("page_id_line_system_plot")),
	date_(ParameterManager::getBool("page_id_line_date_plot")),
	errors_(ParameterManager::getBool("page_id_line_errors_plot")),
	text_(ParameterManager::getBool("page_id_line_user_text_plot")),
	font_(ParameterManager::getString("page_id_line_font")),
	font_style_(ParameterManager::getString("page_id_line_font_style"))
	,
	colour_(MagTranslator<string, Colour>().magics("page_id_line_colour")),
	logo_(MagTranslator<string, NoLogoPlotting>().magics("page_id_line_logo_plot"))
	 
{
} 


PageIDAttributes::~PageIDAttributes()
{
	
}

    
void PageIDAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(2);
	int i = 0;
	prefix[i++] = "page_id";
	prefix[i++] = "page_id_line";
	
	setAttribute(prefix, "page_id_line_height", height_, params);
	setAttribute(prefix, "page_id_line_magics", magics_, params);
	setAttribute(prefix, "page_id_line_user_text", user_text_, params);
	setAttribute(prefix, "page_id_line_system_plot", system_, params);
	setAttribute(prefix, "page_id_line_date_plot", date_, params);
	setAttribute(prefix, "page_id_line_errors_plot", errors_, params);
	setAttribute(prefix, "page_id_line_user_text_plot", text_, params);
	setAttribute(prefix, "page_id_line_font", font_, params);
	setAttribute(prefix, "page_id_line_font_style", font_style_, params);
	
	setMember(prefix, "page_id_line_colour", colour_, params);
	setMember(prefix, "page_id_line_logo_plot", logo_, params);
	
}

void PageIDAttributes::copy(const PageIDAttributes& other)
{
	height_ = other.height_;
	magics_ = other.magics_;
	user_text_ = other.user_text_;
	system_ = other.system_;
	date_ = other.date_;
	errors_ = other.errors_;
	text_ = other.text_;
	font_ = other.font_;
	font_style_ = other.font_style_;
	colour_ = unique_ptr<Colour>(other.colour_->clone());
	logo_ = unique_ptr<NoLogoPlotting>(other.logo_->clone());
	
} 


bool PageIDAttributes::accept(const string& node)
{	
	
	if ( magCompare(node, "pageid")  )
		return true;
	if ( acceptNode(node, logo_) )
		return true;
	
	return false;
}

void PageIDAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "pageid")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		setMember(node.name(), logo_, node);
		
	}
	for (auto &elt : node.elements())
	{
		setMember(elt->name(), logo_, *elt); 
		
	}
}

void PageIDAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " height = " <<  height_;
	out << " magics = " <<  magics_;
	out << " user_text = " <<  user_text_;
	out << " system = " <<  system_;
	out << " date = " <<  date_;
	out << " errors = " <<  errors_;
	out << " text = " <<  text_;
	out << " font = " <<  font_;
	out << " font_style = " <<  font_style_;
	out << " colour = " <<  *colour_;
	out << " logo = " <<  *logo_;
	
	out << "]" << "\n";
}

void PageIDAttributes::toxml(ostream& out)  const
{
	out <<  "\"pageid\""; 
	out << ", \"page_id_line_height\":";
	niceprint(out,height_);
	out << ", \"page_id_line_magics\":";
	niceprint(out,magics_);
	out << ", \"page_id_line_user_text\":";
	niceprint(out,user_text_);
	out << ", \"page_id_line_system_plot\":";
	niceprint(out,system_);
	out << ", \"page_id_line_date_plot\":";
	niceprint(out,date_);
	out << ", \"page_id_line_errors_plot\":";
	niceprint(out,errors_);
	out << ", \"page_id_line_user_text_plot\":";
	niceprint(out,text_);
	out << ", \"page_id_line_font\":";
	niceprint(out,font_);
	out << ", \"page_id_line_font_style\":";
	niceprint(out,font_style_);
	out << ", \"page_id_line_colour\":";
	niceprint(out, *colour_);
	out << ", \"page_id_line_logo_plot\":";
	logo_->toxml(out);
	
}

static MagicsParameter<double> page_id_line_height("page_id_line_height", 0.25, "");
static MagicsParameter<string> page_id_line_magics("page_id_line_magics", "on", "");
static MagicsParameter<string> page_id_line_user_text("page_id_line_user_text", "", "");
static MagicsParameter<string> page_id_line_system_plot("page_id_line_system_plot", "on", "");
static MagicsParameter<string> page_id_line_date_plot("page_id_line_date_plot", "on", "");
static MagicsParameter<string> page_id_line_errors_plot("page_id_line_errors_plot", "on", "");
static MagicsParameter<string> page_id_line_user_text_plot("page_id_line_user_text_plot", "on", "");
static MagicsParameter<string> page_id_line_font("page_id_line_font", "sansserif", "");
static MagicsParameter<string> page_id_line_font_style("page_id_line_font_style", "normal", "");
static MagicsParameter<string> page_id_line_colour("page_id_line_colour", "ecmwf_blue", ""); 
static MagicsParameter<string> page_id_line_logo_plot("page_id_line_logo_plot", "on", ""); 
#include "LogoPlotting.h"
static SimpleObjectMaker<LogoPlotting , NoLogoPlotting> logo_LogoPlotting("logo");
static SimpleObjectMaker<LogoPlotting , NoLogoPlotting> on_LogoPlotting("on");
static SimpleObjectMaker<NoLogoPlotting , NoLogoPlotting> nologo_NoLogoPlotting("nologo");
static SimpleObjectMaker<NoLogoPlotting , NoLogoPlotting> off_NoLogoPlotting("off");
